<?php

namespace app\admin\controller;

use app\api\controller\Upload;
use think\facade\Db;
use think\facade\View;
use app\common\controller\Common;
use think\Request;


class Consult extends Common
{
    /**
     * 首页
     *
     * @return string
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function index()
    {
        $set = Db::name('im_consult')->where('id', '=', 1)->find();

        View::assign('set', $set);

        return View::fetch();
    }

    /**
     * 开关设置
     *
     * @param Request $r
     * @return \think\response\Json
     */
    public function set(Request $r)
    {
        try {
            Db::name('im_consult')->where('id', '=', 1)->save([
                $r->post('field') => $r->post('value')
            ]);
        } catch (\Exception $e) {
            return json(['code' => 1, 'msg' => $e->getMessage()]);
        }


        return json(['code' => 0, 'msg' => '操作成功']);
    }

    /**
     * 删除图片
     *
     * @param Request $r
     * @return \think\response\Json
     */
    public function delete(Request $r)
    {
        try {
            $att = Db::name('im_consult')->where('id', '=', 1)->find();

            list($key, $id) = explode('_', $r->post('id'));

            $upload_avatar = json_decode($att['upload_head'], 1);
            foreach ($upload_avatar as $k => $v) {

                if ($v['id'] == $id) unset($upload_avatar[$k]);
            }

            Db::name('im_consult')->where('id', '=', 1)->save([
                'upload_head' => json_encode($upload_avatar)
            ]);

        } catch (\Exception $e) {

            return json(['code' => 1, 'msg' => $e->getMessage()]);
        }

        return json(['code' => 0, 'msg' => '操作成功']);

    }

    /**
     * 选择头像
     *
     * @param Request $r
     * @return \think\response\Json
     */
    public function selected(Request $r)
    {
        try {
            $att = Db::name('im_consult')->where('id', '=', 1)->find();

            list($key, $id) = explode('_', $r->post('id'));

            $upload_avatar = json_decode($att[$key . '_head'], 1);
            foreach ($upload_avatar as $k => $v) {

                if ($v['id'] == $id) {

                    Db::name('im_consult')->where('id', '=', 1)->save([
                        'head' => $v['url']
                    ]);
                }
            }

        } catch (\Exception $e) {

            return json(['code' => 1, 'msg' => $e->getMessage()]);
        }

        return json(['code' => 0, 'msg' => '操作成功']);
    }

    public function img(Request $r)
    {
        try {
            $upload = new Upload();

            $result = $upload->img($r)->getData();

            foreach ($result['data'] as $key => $item) {

                $att = Db::name('im_attachment')->where('path', '=', $item)->find();

                if (empty($att)) continue;

                $set = Db::name('im_consult')->where('id', '=', 1)->find();

                $upload_avatar = json_decode($set['upload_head'], 1);

                $upload_avatar[] = [
                    'id' => $att['id'],
                    'url' => $att['path']
                ];

                $result = [
                    'code' => 0,
                    'data' => [
                        'id' => $att['id'],
                        'src' => $att['path']
                    ]
                ];

                Db::name('im_consult')->where('id', '=', 1)->save([
                    'upload_head' => json_encode($upload_avatar)
                ]);
            }
        } catch (\Exception $e) {

            return json(['code' => 1, 'msg' => $e->getMessage()]);
        }

        return json($result);
    }

    /**
     * 选择头像
     *
     * @param Request $r
     * @return \think\response\Json
     */
    public function pc_location(Request $r)
    {
        try {
            Db::name('im_consult')->where('id', '=', 1)->save([
                'web_location' => $r->post('value')
            ]);

        } catch (\Exception $e) {

            return json(['code' => 1, 'msg' => $e->getMessage()]);
        }

        return json(['code' => 0, 'msg' => '操作成功']);
    }

    /**
     * 选择头像
     *
     * @param Request $r
     * @return \think\response\Json
     */
    public function m_location(Request $r)
    {
        try {
            Db::name('im_consult')->where('id', '=', 1)->save([
                'mobile_location' => $r->post('value')
            ]);

        } catch (\Exception $e) {

            return json(['code' => 1, 'msg' => $e->getMessage()]);
        }

        return json(['code' => 0, 'msg' => '操作成功']);
    }
}
