<?php

namespace app\admin\controller;

use app\common\controller\Common;
use app\admin\validate\CustomerValidate;
use think\facade\Db;
use think\Request;

class Customer extends Common
{
    /**
     * 修改个人资料
     */
    public function editAccount(Request $r)
    {
        if ($r->post() && $r->isAjax()) {
            $data = $r->post();
            $validate = new CustomerValidate();

            if (!$validate->scene('editAccount')->check($data)) {
                return json(['code' => 300, 'data' => $validate->getError()]);
            }

            Db::name('im_customer')->update([
                'id'     => $this->custs['id'],
                'avatar' => $data['avatar'],
                'nick'   => $data['nick'],
                'phone'  => $data['phone'],
                'email'  => $data['email'],
                'group_id' => $data['group_id']
            ]);
            return json(['code' => 200, 'data' => '修改成功']);
        }
    }

    public function editPass(Request $r)
    {
        if ($r->post() && $r->isAjax()) {
            $data = $r->post();
            $validate = new CustomerValidate();

            if (!$validate->scene('editPass')->check($data)) {
                return json(['code' => 300, 'data' => $validate->getError()]);
            }

            if ($this->custs['upass'] != md5($data['old_upass'].$this->custs['salt']))
            {
                return json(['code' => 300, 'data' => '旧密码错误']);
            }

            Db::name('im_customer')->update([
                'id'     => $this->custs['id'],
                'upass'  => md5($data['new_upass'].$this->custs['salt'])
            ]);
            return json(['code' => 200, 'data' => '修改成功']);
        }
    }
}