<?php

namespace app\admin\controller;

use think\Request;
use think\facade\Db;
use think\facade\View;
use app\common\controller\Common;

class Evaluation extends Common
{
    /**
     * 评价列表
     */
    public function index()
    {
        $evaluation = Db::name('im_evaluation')
            ->where('main_id', $this->main_id)
            ->paginate(10, false, [
                'query' => request()->param(),
                'type' => 'page\Admin',
                'var_page' => 'page'
            ]);

        View::assign([
            'evaluation' => $evaluation
        ]);
        return view();
    }

    /**
     * 删除评价
     */
    public function del(Request $r)
    {
        if ($r->isAjax() && $r->isPost()) {
            Db::name('im_evaluation')->where([
                'main_id' => $this->main_id,
                'id'      => $r->post('eid', 0, 'intval')
            ])->delete();

            return json(['code' => 200, 'data' => '删除成功']);
        }
    }
}