<?php
declare (strict_types = 1);

namespace app\admin\validate;

use think\Validate;

/**
 * 登录验证器
 * Class Login
 * @package app\admin\validate
 */
class ChatsValidate extends Validate
{
    /**
     * 定义验证规则
     * @var array
     */
    protected $rule = [
        'group_name'    => 'require|length:1,50',
        'reply_title'   => 'require|length:1,150',
        'reply_content' => 'require|length:1,2000',
        'reply_id'      => 'require|number',
        'group_id'      => 'require|number'
    ];

    /**
     * 定义错误信息
     * @var array
     */
    protected $message = [
        'group_name.require'    => '分组名称不能为空',
        'group_name.length'     => '分组名称长度不符合标准',
        'reply_title.require'   => '简要标题不能为空',
        'reply_title.length'    => '简要标题长度不符合标准',
        'reply_content.require' => '回复内容不能为空',
        'reply_content.length'  => '回复内容长度不符合标准',
        'reply_id.require'      => '回复ID不能为空',
        'reply_id.length'       => '回复ID必须是数字',
        'group_id.require'      => '分组ID不能为空',
        'group_id.length'       => '分组ID必须是数字'
    ];

    /**
     * 验证场景
     * @var array
     */
    protected $scene = [
        'addGroup'   =>  ['group_name'],
        'editGroup'  =>  ['group_id', 'group_name'],
        'addReply'   =>  ['group_id', 'reply_title', 'reply_content'],
        'editReply'  =>  ['reply_id', 'group_id', 'reply_title', 'reply_content'],
    ];
}
