<?php
declare (strict_types = 1);

namespace app\admin\validate;

use think\Validate;

/**
 * 登录验证器
 * Class Login
 * @package app\admin\validate
 */
class CustomerValidate extends Validate
{
    /**
     * 定义验证规则
     * @var array
     */
    protected $rule = [
        'uname'  => 'require|alphaNum|length:6,50',
        'avatar' => 'require|length:1,200',
        'nick'   => 'require|length:1,50',
        'phone'  => 'mobile',
        'email'  => 'email',
        'group_id'  => 'require|number',
        'old_upass' =>'require|length:6,30',
        'new_upass' =>'require|length:6,30',
        'new2_upass' =>'require|confirm:new_upass|length:6,30'
    ];

    /**
     * 定义错误信息
     * @var array
     */
    protected $message = [
        'uname.require'  => '用户名不能为空',
        'uname.alphaNum' => '用户名只能是字母和数字',
        'uname.length'   => '用户名必须在6到50字符内',
        'avatar.require' => '头像错误',
        'avatar.length'  => '头像错误',
        'nick.require'   => '昵称不能为空',
        'nick.length'    => '昵称长度不符合标准',
        'phone'  => '手机格式错误',
        'email'  => '邮箱格式错误',
        'group_id.require' => '分组ID不能为空',
        'group_id.number'  => '分组ID必须是数字',
        'old_upass.require'  => '旧密码不能为空',
        'old_upass.length'  => '旧密码长度必须在6-30字符之间',
        'new_upass.require'  => '新密码不能为空',
        'new_upass.length'  => '新密码长度必须在6-30字符之间',
        'new2_upass.require'    => '新密码不能为空',
        'new2_upass.length'     => '新密码长度必须在6-30字符之间',
        'new2_upass.confirm'    => '两次新密码必须相同'
    ];

    /**
     * 验证场景
     * @var array
     */
    protected $scene = [
        'editAccount'  =>  ['avatar', 'nick', 'phone', 'email', 'group_id'],
        'editPass'  =>  ['old_upass', 'new_upass', 'new2_upass']
    ];
}
