<?php
declare (strict_types = 1);

namespace app\admin\validate;

use think\Validate;

/**
 * 登录验证器
 * Class Login
 * @package app\admin\validate
 */
class LoginValidate extends Validate
{
    /**
     * 定义验证规则
     * @var array
     */
    protected $rule = [
        'uname' => 'require|length:3,12',
        'upass' => 'require'
    ];

    /**
     * 定义错误信息
     * @var array
     */
    protected $message = [
        'uname' => '用户名格式错误',
        'upass' => '密码不能为空'
    ];
}
