<?php
declare (strict_types = 1);

namespace app\admin\validate;

use think\Validate;

/**
 * 设置验证器
 * Class Set
 * @package app\admin\validate
 */
class SetValidate extends Validate
{
    /**
     * 定义验证规则
     * @var array
     */
    protected $rule = [
        'cu_id'      => 'require|number',
        'group_name' => 'require|length:1,50',
        'group_id'   => 'require|number',
        'avatar'     => 'require|length:1,200',
        'nick'       => 'require|length:1,50',
        'phone'      => 'mobile',
        'email'      => 'email',
        'upass'      => 'require|length:6,30',
        'upass2'     => 'require|confirm:upass|length:6,30',
        'pro_id'     => 'require|number',
        'pro_ask'    => 'require|length:2,100',
        'pro_ukeys'  => 'require|length:2,30',
        'pro_sort'   => 'require|number',
        'pro_isshow' => 'require|number|in:0,1',
        'pro_content'=> 'require|length:2,3000',
    ];

    /**
     * 定义错误信息
     * @var array
     */
    protected $message = [
        'cu_id.require'    => '客服ID不能为空',
        'cu_id.length'     => '客服ID长度不符合标准',
        'group_name.require'    => '分组名称不能为空',
        'group_name.length'     => '分组名称长度不符合标准',
        'group_id.require'      => '分组ID不能为空',
        'group_id.number'       => '分组ID必须是数字',
        'avatar.require' => '头像错误',
        'avatar.length'  => '头像错误',
        'nick.require'   => '昵称不能为空',
        'nick.length'    => '昵称长度不符合标准',
        'phone'  => '手机格式错误',
        'email'  => '邮箱格式错误',
        'upass.require'  => '密码不能为空',
        'upass.length'   => '密码长度必须在6-30字符之间',
        'upass2.require'     => '密码不能为空',
        'upass2.confirm'     => '两次密码必须相同',
        'upass2.length'      => '密码长度必须在6-30字符之间',
        'pro_id.require'     => '常见问题ID不能为空',
        'pro_id.number'      => '常见问题ID必须是数字',
        'pro_ask.require'    => '常见问题不能为空',
        'pro_ask.length'     => '常见问题长度必须在2-100字符之间',
        'pro_ukeys.require'  => '关键词不能为空',
        'pro_ukeys.length'   => '关键词长度必须在2-30字符之间',
        'pro_sort.require'   => '排序不能为空',
        'pro_sort.number'    => '排序必须是数字',
        'pro_isshow.require'   => '是否显示不能为空',
        'pro_isshow.number'    => '是否显示必须是数字',
        'pro_isshow.in'        => '是否显示必须是0或1',
        'pro_content.require'  => '解决回答不能为空',
        'pro_content.length'   => '解决回答长度必须在2-3000字符之间',
    ];

    /**
     * 验证场景
     * @var array
     */
    protected $scene = [
        'delGroup'    =>  ['group_id'],
        'addGroup'    =>  ['group_name'],
        'editGroup'   =>  ['group_id', 'group_name'],
        'addService'  =>  ['avatar', 'uname', 'upass', 'upass2', 'nick', 'phone', 'email', 'group_id'],
        'editService' =>  ['cu_id', 'avatar', 'uname', 'nick', 'phone', 'email', 'group_id'],
        'addProblem'  =>  ['pro_ask', 'pro_ukeys', 'pro_sort', 'pro_isshow', 'pro_content'],
        'editProblem' =>  ['pro_id', 'pro_ask', 'pro_ukeys', 'pro_sort', 'pro_isshow', 'pro_content']
    ];
}
