<?php

namespace app\api\controller;

use think\facade\Db;
use think\Request;

class Cation
{
    /**
     * 根据code获取相应的值
     */
    public function getcation(Request $r)
    {
        if ($r->isPost()) {
            header('Access-Control-Allow-Origin: *');
            header('Access-Control-Allow-Methods: POST');
            header('Access-Control-Allow-Headers: Authorization, Content-Type, If-Match, If-Modified-Since, If-None-Match, If-Unmodified-Since, X-Requested-With');
            $cation = Db::name('im_cation_codes')
                ->field('cuid,gid,style,uname,wname')
                ->where('md5', $r->post('code', ''))
                ->find();
            $main_id = Db::name('im_customer')
                ->where(['uname' => $cation['wname'], 'is_main' => 1])
                ->value('id');
            if ($cation && $main_id) {
                $urls = [];
                $groups = Db::name('im_customer_group')
                    ->where('cuid', $main_id)->select();

                $urls[0]['name'] = '在线咨询';
                $urls[0]['tour'] = exclusiveUrl(['cuid' => $cation['cuid'], 'uname' => $cation['uname'], 'gid' => $cation['gid'], 'wname' => $cation['wname']]);
                $urls[0]['minitour'] = exclusiveUrl(['cuid' => $cation['cuid'], 'uname' => $cation['uname'], 'gid' => $cation['gid'], 'wname' => $cation['wname'], 'du' => 3]);

                foreach ($groups as $key => $item) {
                    $urls[$key + 1]['name'] = $item['name'];
                    $urls[$key + 1]['tour'] = exclusiveUrl(['cuid' => 0, 'uname' => 0, 'gid' => $item['id'], 'wname' => 0]);
                    $urls[$key + 1]['minitour'] = exclusiveUrl(['cuid' => 0, 'uname' => 0, 'gid' => $item['id'], 'wname' => 0, 'du' => 3]);
                }

                $response = [
                    'code' => 200,
                    'data' => [
                        'style' => $cation['style'],
                        'urls' => $urls,
                    ]
                ];

            } else {
                $response = [
                    'code' => 300,
                    'data' => [
                    ]
                ];
            }

            $invite = goalong_hook('invite', ['cation' => ($cation ? 1 : 0)], 1);
            if ($invite) $response['data']['invite'] = $invite;

            //获取悬浮窗设置
            $consult = Db::name('im_consult')->where('id', '=', 1)->find();
            $response['data']['sidebar'] = [
                'isZoom' => $consult['web_is_zoom'],
                'autoZoom' => $consult['web_auto_zoom'],
                'defaultZoom' => $consult['web_default_zoom'],
                'avatar' => is_https().'://'.$_SERVER['SERVER_NAME'] .$consult['head'],
                'location' => \request()->isMobile() ? $consult['mobile_location'] : $consult['web_location'],
                'list' => [],
            ];

            //根据插件设置，修改悬浮窗设置
            $sidebar = goalong_hook('sidebar');

            if (is_array($sidebar)) foreach ($sidebar as $v) {

                if (is_array($v)) foreach ($v as $ke => $va) {
                    if ($ke === 'list') $response['data']['sidebar']['list'] = array_merge($response['data']['sidebar']['list'], $va);
                    else $response['data']['sidebar'][$ke] = $va;
                }
            }

            return json($response);
        }
    }
}