<?php

namespace app\api\controller;

use app\common\controller\Common;
use think\facade\Db;
use think\Request;

/**
 * 对话api类
 * Class Record
 * @package app\api\controller
 */
class History extends Common
{
    /**
     * 获取当前主客服的全部客服
     */
    public function getCustomerAll(Request $r)
    {
        if ($r->isAjax()) {
            $customer = Db::name('im_customer')->field('id,nick,avatar')
                ->where("id=".$this->main_id." or pid=".$this->main_id)->limit(200)->select();
            if (!$customer->isEmpty()) {
                return json(['code' => 200, 'data' => $customer]);
            } else {
                return json(['code' => 300, 'data' => []]);
            }
        }
    }

    /**
     * 根据客服ID获取访客
     */
    public function getCuidVisitorsAll(Request $r)
    {
        if ($r->isAjax() && $r->isPost()) {
            $cuid = $r->post('cuid', 0);
            $visitors = Db::name('im_dialogue')->field('v.id,v.nick,v.avatar')
                ->alias('d')->join('we_im_visitors v','v.id=d.vsid')
                ->where('d.cuid', $cuid)->limit(200)->select();
            if (!$visitors->isEmpty()) {
                return json(['code' => 200, 'data' => $visitors]);
            } else {
                return json(['code' => 300, 'data' => []]);
            }
        }
    }

    /**
     * 根据时间段获取历史消息
     */
    public function getTimeRecord(Request $r)
    {
        if ($r->isAjax() && $r->isPost()) {
            $data   = $r->post();
            $fromid = $data['cuid']??0;
            $toid   = $data['vsid']??0;
            $type   = $data['type']??'7day';
            $record = [];
            if ($type == '7day') {
                $record = Db::name('im_record')
                    ->field('send,send_avatar,receive,receive_avatar,utype,content')
                    ->whereWeek('send_time')
                    ->where("send = {$fromid} AND receive = {$toid} OR send = {$toid} OR receive = {$fromid}")
                    ->order('send_time desc')
                    ->select();
            } elseif ($type == '1month') {
                $record = Db::name('im_record')
                    ->field('send,send_avatar,receive,receive_avatar,utype,content')
                    ->whereMonth('send_time')
                    ->where("send = {$fromid} AND receive = {$toid} OR send = {$toid} OR receive = {$fromid}")
                    ->order('send_time desc')
                    ->select();
            } elseif ($type == 'dtime') {
                $start_time = strtotime($data['start']);
                $end_time   = strtotime($data['end']);
                if ($start_time > $end_time) {
                    return json(['code' => 300, 'msg' => '结束时间不能大于开始时间']);
                }

                $record = Db::name('im_record')
                    ->field('send,send_avatar,receive,receive_avatar,utype,content')
                    ->where("send_time BETWEEN {$start_time} AND {$end_time}")
                    ->where("send = {$fromid} AND receive = {$toid} OR send = {$toid} OR receive = {$fromid}")
                    ->order('send_time desc')
                    ->select();
            }
            if (!$record->isEmpty()) {
                $record = array_reverse($record->toArray());
                return json(['code' => 200, 'data' => $record]);
            } else {
                return json(['code' => 300, 'msg' => '无数据']);
            }
        }
    }
}