<?php

namespace app\api\controller;

use think\facade\Db;
use think\Request;

/**
 * 游客端
 * Class Record
 * @package app\api\controller
 */
class Record
{
    /**
     * 游客端 加载历史消息
     */
    public static function loadMessageHistory(Request $r)
    {
        if ($r->isAjax() && $r->isPost()) {
            $post = $r->post();
            $record = Db::name('im_record')
                ->where("send = {$post['fromid']} AND receive = {$post['toid']}")
                ->whereOr("send = {$post['toid']} AND receive = {$post['fromid']}")
                ->page($post['page'],10)->order('send_time desc')->select();
            $data = array_reverse($record->toArray());
            if (!empty($data)) {
                return json([
                    'code' => 200,
                    'data' => $data
                ]);
            } else {
                return json([
                    'code' => 300,
                    'data' => []
                ]);
            }
        }
    }

    /**
     * 游客点击问题获取回答
     */
    public function getComaskContent(Request $r)
    {
        if ($r->isAjax() && $r->isPost()) {
            $id = $r->post('id', 0, 'intval');
            $content = Db::name('im_comask')
                ->where(['id' => $id, 'isshow' => 1])
                ->value('content');
            if (!empty($content)) {
                return json([
                    'code' => 200,
                    'data' => $content
                ]);
            }
        }
    }

    /**
     * 更新游客次数
     */
    public function updateConsultingNumber(Request $r)
    {
        if ($r->isAjax() && $r->isPost()) {
            Db::name('im_visitors_info')
                ->alias('vi')
                ->where([
                    'v.ip'    => $r->ip(),
                    'vi.vsid' => $r->post('ykid', 0, 'intval'),
                    'vi.cuid' => $r->post('kfid', 0, 'intval')
                ])
                ->join('we_im_visitors v','v.id=vi.vsid')
                ->inc('vi.views')->update();
            return json([
                'code' => 200,
                'data' => []
            ]);
        }
    }

    /*
     * 获取链接
     */
    public function saychaturl(Request $r)
    {
        if ($r->isAjax() && $r->isPost()) {
            try {
                $falg = 'tour';
                $ulr_path = 'chat/tour/';
                if ($r->isMobile()) {
                    $falg = 'mtour';
                    $ulr_path = 'chat/mtour/';
                }
                $cuid = $r->post('cuid', 0, 'intval');
                preg_match_all("/chat\/{$falg}\/(.*?).html/", $r->post('code'), $match);
                parse_str(decodeing(trim($match[1][0])), $param);
                $customer = Db::name('im_customer')->field('id,uname')->find($cuid);
                if (empty($customer)) {
                    return json([
                        'code' => 300,
                        'url'  => ""
                    ]);
                }
                $code = encodeing(http_build_query([
                    'cuid'  => $customer['id'],
                    'uname' => $customer['uname'],
                    'gid'   => $param['gid'],
                    'wname' => $param['wname']
                ]));
                $url = Furl('chat/say/chat', [
                    'code' => $code
                ], true, true);
                $url = str_replace('chat/say/chat.html?code=', $ulr_path, $url);
                $url = str_replace('api.php/', '', $url);
                return json([
                    'code' => 200,
                    'url'  => urldecode($url) . '.html'
                ]);
            } catch(\Exception $e) {
                return json([
                    'code' => 300,
                    'url'  => ""
                ]);
            }
        }
    }
}