<?php

namespace app\api\controller;

use think\facade\Db;

class Unread
{
    /**
     * 未接待会员管理方案
     *
     * @return mixed
     */
    public function index()
    {
        $type = request()->post('type');
        $params = json_decode(request()->post('params', null), 1);

        switch ($type) {
            case 'add':
                $result = self::add($params);
                break;
            case 'clean':
                $result = self::clean($params);
                break;
            case 'lists':
                $result = self::lists($params);
                break;
            case 'getcount':
                $result = self::getcount($params);
                break;
            default:
                $result = self::fails('类型错误');
                break;
        }

        return json($result);
    }

    /**
     * 成功格式
     *
     * @param string $msg
     * @param array $other
     * @return array
     */
    private function success($msg = '操作成功', $other = [])
    {
        $result = [
            'status' => 'success',
            'msg' => $msg
        ];

        if (is_array($other) && !empty($other)) $result = array_merge($result, $other);

        return $result;
    }

    /**
     * 报错格式
     *
     * @param $msg
     * @return array
     */
    private function fails($msg)
    {

        return [
            'status' => 'fails',
            'msg' => $msg
        ];
    }

    /**
     * 增加未读数量
     *
     * @param $params
     * @return array|string[]
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    private function add($params)
    {
        if (!isset($params['uid']) || empty($params['uid'])) return self::fails('请传入uid');

        $u = Db::name('im_unread')->where('uid', '=', $params['uid'])->find();

        if (empty($u)) {
            $number = 1;
            Db::name('im_unread')->insert([
                'uid' => $params['uid'],
                'number' => $number,
                'show' => 1,
            ]);
        } else {

            $number = $u['number'] + 1;
            Db::name('im_unread')->where('uid', '=', $params['uid'])->update([
                'number' => $number,
                'show' => 1,
            ]);
        }

        return self::success('操作成功', ['number' => $number]);
    }

    /**
     * 清空未读数量
     *
     * @param $params
     * @return array|string[]
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    private function clean($params)
    {
        if (!isset($params['uid']) || empty($params['uid'])) {

            Db::name('im_unread')->where(1)->update([
                'show' => 0
            ]);
        } else {

            $u = Db::name('im_unread')->where('uid', '=', $params['uid'])->find();

            if (!empty($u)) {

                Db::name('im_unread')->where('uid', '=', $params['uid'])->update([
                    'number' => 0
                ]);
            }
        }

        return self::success();
    }

    /**
     * 获取列表
     *
     * @param $params
     * @return array|string[]
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    private function lists($params)
    {
        return self::success('操作成功',['lists' => Db::name('im_unread')->where('number', '>', 0)->select()]);
    }

    /**
     * 未读总数
     *
     * @param $params
     * @return array|string[]
     */
    private function getcount($params)
    {
        return self::success('操作成功',['number' => Db::name('im_unread')->where('number', '>', 0)->where('show', '=', 1)->sum('number')]);
    }

}