-- MySQL dump 10.13  Distrib 5.6.50, for Linux (x86_64)
--
-- Host: localhost    Database: kuzhankefu
-- ------------------------------------------------------
-- Server version	5.6.50-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `we_im_alipayface`
--

DROP TABLE IF EXISTS `we_im_alipayface`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_alipayface` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `out_trade_no` varchar(255) DEFAULT NULL COMMENT '订单号',
  `total_amount` decimal(18,2) DEFAULT NULL COMMENT '付款金额',
  `subject` varchar(255) DEFAULT NULL COMMENT '商品标题',
  `qr_code` varchar(255) DEFAULT NULL COMMENT '二维码路径',
  `content` text COMMENT '所有订单参数',
  `status` varchar(255) DEFAULT NULL COMMENT '状态',
  `pay_time` int(11) DEFAULT NULL COMMENT '支付时间',
  `create_time` int(11) DEFAULT NULL COMMENT '下单时间',
  `addons` varchar(255) NOT NULL,
  `addons_notify` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='tab标签';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_alipayface`
--

LOCK TABLES `we_im_alipayface` WRITE;
/*!40000 ALTER TABLE `we_im_alipayface` DISABLE KEYS */;
/*!40000 ALTER TABLE `we_im_alipayface` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_alipaypc`
--

DROP TABLE IF EXISTS `we_im_alipaypc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_alipaypc` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `out_trade_no` varchar(255) DEFAULT NULL COMMENT '订单号',
  `total_amount` decimal(18,2) DEFAULT NULL COMMENT '付款金额',
  `subject` varchar(255) DEFAULT NULL COMMENT '商品标题',
  `content` text COMMENT '所有订单参数',
  `status` varchar(255) DEFAULT NULL COMMENT '状态',
  `pay_time` int(11) DEFAULT NULL COMMENT '支付时间',
  `create_time` int(11) DEFAULT NULL COMMENT '下单时间',
  `addons` varchar(255) NOT NULL,
  `addons_notify` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='tab标签';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_alipaypc`
--

LOCK TABLES `we_im_alipaypc` WRITE;
/*!40000 ALTER TABLE `we_im_alipaypc` DISABLE KEYS */;
/*!40000 ALTER TABLE `we_im_alipaypc` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_attachment`
--

DROP TABLE IF EXISTS `we_im_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_attachment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `title` char(100) NOT NULL DEFAULT '' COMMENT '名称',
  `path` char(230) NOT NULL DEFAULT '' COMMENT '路径',
  `cun_type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1本地2七牛',
  `user_id` mediumint(8) NOT NULL DEFAULT '0' COMMENT '所属上传ID',
  `user_type` tinyint(1) NOT NULL COMMENT '1客服2游客',
  `ip_info` char(150) NOT NULL DEFAULT '' COMMENT 'ip地址及地区',
  `md5` char(100) NOT NULL DEFAULT '' COMMENT 'MD5值',
  `add_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='附件管理表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_attachment`
--

LOCK TABLES `we_im_attachment` WRITE;
/*!40000 ALTER TABLE `we_im_attachment` DISABLE KEYS */;
/*!40000 ALTER TABLE `we_im_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_autoreply`
--

DROP TABLE IF EXISTS `we_im_autoreply`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_autoreply` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `title` char(20) NOT NULL DEFAULT '' COMMENT '标题',
  `sort` int(11) DEFAULT NULL COMMENT '排序',
  `status` char(2) DEFAULT NULL COMMENT '状态',
  `keyword` varchar(255) NOT NULL DEFAULT '' COMMENT '关键字',
  `content` text NOT NULL COMMENT '回复内容',
  `main_id` smallint(6) NOT NULL DEFAULT '0' COMMENT '主客服ID',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='tab标签';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_autoreply`
--

LOCK TABLES `we_im_autoreply` WRITE;
/*!40000 ALTER TABLE `we_im_autoreply` DISABLE KEYS */;
/*!40000 ALTER TABLE `we_im_autoreply` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_autosend`
--

DROP TABLE IF EXISTS `we_im_autosend`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_autosend` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `title` char(20) NOT NULL DEFAULT '' COMMENT '标题',
  `sort` int(11) DEFAULT NULL COMMENT '排序',
  `content` text NOT NULL COMMENT '回复内容',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='tab标签';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_autosend`
--

LOCK TABLES `we_im_autosend` WRITE;
/*!40000 ALTER TABLE `we_im_autosend` DISABLE KEYS */;
/*!40000 ALTER TABLE `we_im_autosend` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_blacklist`
--

DROP TABLE IF EXISTS `we_im_blacklist`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_blacklist` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `cuid` int(10) NOT NULL DEFAULT '0' COMMENT '客服id',
  `vsid` int(10) NOT NULL DEFAULT '0' COMMENT '访客id',
  `add_time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='黑名单表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_blacklist`
--

LOCK TABLES `we_im_blacklist` WRITE;
/*!40000 ALTER TABLE `we_im_blacklist` DISABLE KEYS */;
/*!40000 ALTER TABLE `we_im_blacklist` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_cation_codes`
--

DROP TABLE IF EXISTS `we_im_cation_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_cation_codes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `cuid` smallint(6) NOT NULL COMMENT '所属客服ID',
  `uname` char(50) NOT NULL COMMENT '所属客服用户名',
  `gid` smallint(6) NOT NULL DEFAULT '0' COMMENT '用户组ID',
  `wname` char(50) NOT NULL COMMENT '主客服用户名',
  `style` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1普通2迷你',
  `md5` char(50) NOT NULL COMMENT '以上数据MD5',
  PRIMARY KEY (`id`),
  UNIQUE KEY `md5` (`md5`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='js代码识别码表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_cation_codes`
--

LOCK TABLES `we_im_cation_codes` WRITE;
/*!40000 ALTER TABLE `we_im_cation_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `we_im_cation_codes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_comask`
--

DROP TABLE IF EXISTS `we_im_comask`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_comask` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `ask` char(100) NOT NULL DEFAULT '' COMMENT '问题',
  `ukeys` char(30) NOT NULL DEFAULT '' COMMENT '关键字',
  `content` varchar(3000) NOT NULL DEFAULT '' COMMENT '回答',
  `sort` smallint(6) NOT NULL DEFAULT '1' COMMENT '排序',
  `isshow` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否展示',
  `cuid` smallint(6) NOT NULL DEFAULT '0' COMMENT '主客服ID',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='常见问题表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_comask`
--

LOCK TABLES `we_im_comask` WRITE;
/*!40000 ALTER TABLE `we_im_comask` DISABLE KEYS */;
/*!40000 ALTER TABLE `we_im_comask` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_consult`
--

DROP TABLE IF EXISTS `we_im_consult`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_consult` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `web_is_zoom` tinyint(1) DEFAULT NULL COMMENT '网页缩放开关',
  `web_default_zoom` tinyint(1) DEFAULT NULL COMMENT '网页默认缩放',
  `web_auto_zoom` tinyint(1) DEFAULT NULL COMMENT '网页自动缩放',
  `web_location` tinyint(1) DEFAULT NULL COMMENT '网页位置',
  `mobile_location` tinyint(1) DEFAULT NULL COMMENT '手机端位置',
  `default_head` text COMMENT '默认头像数组',
  `upload_head` text COMMENT '上传头像数组',
  `head` varchar(255) DEFAULT NULL COMMENT '选择的头像路径',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=32 DEFAULT CHARSET=utf8 COMMENT='附件管理表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_consult`
--

LOCK TABLES `we_im_consult` WRITE;
/*!40000 ALTER TABLE `we_im_consult` DISABLE KEYS */;
INSERT INTO `we_im_consult` VALUES (1,1,1,1,4,2,'{\"1\":{\"id\":35,\"url\":\"\\/default.png\"}}','[]','/default.png');
/*!40000 ALTER TABLE `we_im_consult` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_consult_addons`
--

DROP TABLE IF EXISTS `we_im_consult_addons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_consult_addons` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `title` varchar(255) DEFAULT NULL COMMENT '标题',
  `img` varchar(255) DEFAULT NULL COMMENT '图片',
  `url` varchar(255) DEFAULT NULL COMMENT '链接',
  `sort` int(11) DEFAULT NULL COMMENT '排序',
  `type` int(1) DEFAULT NULL COMMENT '类型，0qq，1旺旺，2外链',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=41 DEFAULT CHARSET=utf8 COMMENT='tab标签';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_consult_addons`
--

LOCK TABLES `we_im_consult_addons` WRITE;
/*!40000 ALTER TABLE `we_im_consult_addons` DISABLE KEYS */;
/*!40000 ALTER TABLE `we_im_consult_addons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_customer`
--

DROP TABLE IF EXISTS `we_im_customer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_customer` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `pid` smallint(8) NOT NULL DEFAULT '0' COMMENT '上级客服',
  `uname` char(50) NOT NULL COMMENT '用户名',
  `upass` char(50) NOT NULL COMMENT '密码',
  `avatar` char(220) NOT NULL DEFAULT '/images/avatar/def.png',
  `salt` char(20) NOT NULL COMMENT '密匙',
  `nick` char(50) NOT NULL COMMENT '昵称',
  `phone` char(20) NOT NULL DEFAULT '' COMMENT '手机',
  `email` char(50) NOT NULL DEFAULT '' COMMENT '邮箱',
  `state` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态0暂时离开1我在线上',
  `web_id` char(50) NOT NULL COMMENT '网站|商户id这个是主客服的用户名',
  `group_id` smallint(8) NOT NULL DEFAULT '0' COMMENT '客服分组id',
  `is_main` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否是主客服',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '注册时间',
  `login_time` int(10) NOT NULL DEFAULT '0' COMMENT '登陆时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COMMENT='客服表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_customer`
--

LOCK TABLES `we_im_customer` WRITE;
/*!40000 ALTER TABLE `we_im_customer` DISABLE KEYS */;
INSERT INTO `we_im_customer` VALUES (1,0,'admin','f71c3027366c997ac0b6697e1f0bd0bf','/images/avatar/cust/177.jpg','CT3Lep7e','admin','','',1,'1',1,1,1615990174,1622295116);
/*!40000 ALTER TABLE `we_im_customer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_customer_group`
--

DROP TABLE IF EXISTS `we_im_customer_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_customer_group` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(30) NOT NULL DEFAULT '' COMMENT '名称',
  `cuid` smallint(8) NOT NULL DEFAULT '0' COMMENT '所属主客服id',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=50 DEFAULT CHARSET=utf8 COMMENT='客服分组表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_customer_group`
--

LOCK TABLES `we_im_customer_group` WRITE;
/*!40000 ALTER TABLE `we_im_customer_group` DISABLE KEYS */;
INSERT INTO `we_im_customer_group` VALUES (1,'默认分组',1);
/*!40000 ALTER TABLE `we_im_customer_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_customer_pay`
--

DROP TABLE IF EXISTS `we_im_customer_pay`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_customer_pay` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `out_trade_no` varchar(255) DEFAULT NULL COMMENT '订单号',
  `total_amount` decimal(18,2) DEFAULT NULL COMMENT '付款金额',
  `to_id` int(11) DEFAULT NULL COMMENT '会员id',
  `to_nick` varchar(255) DEFAULT NULL COMMENT '会员昵称',
  `to_avatar` varchar(255) DEFAULT NULL,
  `from_id` int(11) DEFAULT NULL COMMENT '客服id',
  `from_nick` varchar(255) DEFAULT NULL COMMENT '客服昵称',
  `from_avatar` varchar(255) DEFAULT NULL,
  `ip` varchar(255) DEFAULT NULL COMMENT 'IP地址',
  `note` varchar(255) DEFAULT NULL COMMENT '备注',
  `status` varchar(255) DEFAULT NULL COMMENT '状态',
  `qr` varchar(255) DEFAULT NULL COMMENT '二维码地址',
  `dead_time` int(11) DEFAULT NULL COMMENT '失效时间',
  `pay_time` int(11) DEFAULT NULL COMMENT '支付时间',
  `create_time` int(11) DEFAULT NULL COMMENT '下单时间',
  `pay_type` varchar(255) NOT NULL DEFAULT 'alipayface',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='tab标签';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_customer_pay`
--

LOCK TABLES `we_im_customer_pay` WRITE;
/*!40000 ALTER TABLE `we_im_customer_pay` DISABLE KEYS */;
/*!40000 ALTER TABLE `we_im_customer_pay` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_dialogue`
--

DROP TABLE IF EXISTS `we_im_dialogue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_dialogue` (
  `id` int(15) unsigned NOT NULL AUTO_INCREMENT,
  `vsid` mediumint(8) NOT NULL DEFAULT '0' COMMENT '访客id',
  `isshow` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否隐藏',
  `add_time` int(10) NOT NULL DEFAULT '0' COMMENT '最新对话时间',
  `new_cont` char(30) NOT NULL DEFAULT '' COMMENT '最新对话内容',
  `unread_count` smallint(5) NOT NULL DEFAULT '0' COMMENT '未读数量',
  `cuid` mediumint(8) NOT NULL DEFAULT '0' COMMENT '当前客服id',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='当前对话表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_dialogue`
--

LOCK TABLES `we_im_dialogue` WRITE;
/*!40000 ALTER TABLE `we_im_dialogue` DISABLE KEYS */;
/*!40000 ALTER TABLE `we_im_dialogue` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_email_modes`
--

DROP TABLE IF EXISTS `we_im_email_modes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_email_modes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `title` char(20) NOT NULL DEFAULT '' COMMENT '标题',
  `code` char(20) NOT NULL DEFAULT '' COMMENT '模版号',
  `content` text NOT NULL COMMENT '内容',
  `main_id` smallint(6) NOT NULL DEFAULT '0' COMMENT '主客服ID',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='tab标签';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_email_modes`
--

LOCK TABLES `we_im_email_modes` WRITE;
/*!40000 ALTER TABLE `we_im_email_modes` DISABLE KEYS */;
INSERT INTO `we_im_email_modes` VALUES (3,'注册邮件','USER_REGISTER','尊敬的用户，您正在注册，验证码为{$code}，打死不要告诉别人哦;',0),(4,'订单支付','ORDER_PAY','尊敬的用户，您的订单({$order_no})已经完成支付，支付金额为：{$money}，祝您生活愉快。',0),(5,'会员充值','USER_RECHARGE','恭喜{$account}成功充值{$money}元{$gold}金币，您的订单号为：{$order_no}，感谢您的支持如有疑问可以联系客服{$customer}',0),(6,'会员购买','USER_LEVEL','恭喜{$account}成功购买用户组{$level},支付金额{$money}元，您的订单号为：{$order_no}，感谢您的支持如有疑问可以联系客服{$customer}',0);
/*!40000 ALTER TABLE `we_im_email_modes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_evaluation`
--

DROP TABLE IF EXISTS `we_im_evaluation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_evaluation` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `vsid` smallint(6) NOT NULL DEFAULT '0' COMMENT '游客ID',
  `main_id` smallint(6) NOT NULL DEFAULT '0' COMMENT '客服ID',
  `vs_nick` char(50) NOT NULL DEFAULT '' COMMENT '游客昵称',
  `groups` char(50) NOT NULL DEFAULT '' COMMENT '分组',
  `cunick` char(50) NOT NULL DEFAULT '' COMMENT '客服昵称',
  `add_time` int(10) NOT NULL DEFAULT '0' COMMENT '评价时间',
  `pjqk` char(220) NOT NULL DEFAULT '' COMMENT '评价情况',
  `wzpj` char(150) NOT NULL DEFAULT '' COMMENT '文字评价',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='评价记录表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_evaluation`
--

LOCK TABLES `we_im_evaluation` WRITE;
/*!40000 ALTER TABLE `we_im_evaluation` DISABLE KEYS */;
/*!40000 ALTER TABLE `we_im_evaluation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_evaluation_temp`
--

DROP TABLE IF EXISTS `we_im_evaluation_temp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_evaluation_temp` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `evins` char(200) NOT NULL DEFAULT '' COMMENT '评价说明',
  `evlimit` varchar(300) NOT NULL DEFAULT '' COMMENT '评价条目限5',
  `wzev_open` tinyint(1) NOT NULL DEFAULT '1' COMMENT '文字评价开关',
  `wzev_name` char(30) NOT NULL DEFAULT '' COMMENT '文字评价名称',
  `cuid` mediumint(8) NOT NULL DEFAULT '0' COMMENT '所属主客服',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='评价模板显示表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_evaluation_temp`
--

LOCK TABLES `we_im_evaluation_temp` WRITE;
/*!40000 ALTER TABLE `we_im_evaluation_temp` DISABLE KEYS */;
INSERT INTO `we_im_evaluation_temp` VALUES (2,'','',1,'',1);
/*!40000 ALTER TABLE `we_im_evaluation_temp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_fastreply`
--

DROP TABLE IF EXISTS `we_im_fastreply`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_fastreply` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` char(150) NOT NULL DEFAULT '' COMMENT '名称',
  `content` varchar(2000) NOT NULL DEFAULT '' COMMENT '内容',
  `add_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `group_id` smallint(8) NOT NULL DEFAULT '0' COMMENT '分组id',
  `cuid` smallint(8) NOT NULL DEFAULT '0' COMMENT '客服id',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COMMENT='快捷回复表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_fastreply`
--

LOCK TABLES `we_im_fastreply` WRITE;
/*!40000 ALTER TABLE `we_im_fastreply` DISABLE KEYS */;
/*!40000 ALTER TABLE `we_im_fastreply` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_fastreply_group`
--

DROP TABLE IF EXISTS `we_im_fastreply_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_fastreply_group` (
  `id` smallint(8) NOT NULL AUTO_INCREMENT,
  `name` char(50) NOT NULL DEFAULT '' COMMENT '名称',
  `add_time` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间',
  `cuid` smallint(8) NOT NULL DEFAULT '0' COMMENT '客服id',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COMMENT='快捷回复分组表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_fastreply_group`
--

LOCK TABLES `we_im_fastreply_group` WRITE;
/*!40000 ALTER TABLE `we_im_fastreply_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `we_im_fastreply_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_filesystem`
--

DROP TABLE IF EXISTS `we_im_filesystem`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_filesystem` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `disks` char(20) NOT NULL COMMENT '标识',
  `params` varchar(1000) NOT NULL DEFAULT '' COMMENT 'json参数',
  PRIMARY KEY (`id`),
  UNIQUE KEY `disks` (`disks`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='磁盘表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_filesystem`
--

LOCK TABLES `we_im_filesystem` WRITE;
/*!40000 ALTER TABLE `we_im_filesystem` DISABLE KEYS */;
INSERT INTO `we_im_filesystem` VALUES (2,'','{\"bucket\":\"young-test\",\"upload_url_path\":\"http:\\/\\/qsbh3c7pp.hn-bkt.clouddn.com\",\"accessKey\":\"VuNZf3a42TZ4HaaR7Qm-zP-4TL5vK5wvEN0aMsc6\",\"secretKey\":\"N3GNGWF2JqMGdU-Hg8IVc0LKlAjHob3LVrcSjM5_\"}');
/*!40000 ALTER TABLE `we_im_filesystem` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_general_config`
--

DROP TABLE IF EXISTS `we_im_general_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_general_config` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `mess_prompt` tinyint(1) NOT NULL DEFAULT '1' COMMENT '消息提示音',
  `mess_clues` tinyint(1) NOT NULL DEFAULT '1' COMMENT '模板提示语',
  `mess_distr` tinyint(1) NOT NULL DEFAULT '1' COMMENT '智能分配',
  `mess_mp3` char(200) NOT NULL DEFAULT '' COMMENT '提示音',
  `cuid` smallint(6) NOT NULL DEFAULT '0' COMMENT '客服ID',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='通用设置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_general_config`
--

LOCK TABLES `we_im_general_config` WRITE;
/*!40000 ALTER TABLE `we_im_general_config` DISABLE KEYS */;
INSERT INTO `we_im_general_config` VALUES (1,1,1,1,'/uploads/file/20210127/b51ca0f0ff23724a6cbd7b159dfa58a7.mp3',1);
/*!40000 ALTER TABLE `we_im_general_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_goods_card`
--

DROP TABLE IF EXISTS `we_im_goods_card`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_goods_card` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `goods_id` int(11) DEFAULT NULL COMMENT '商品id',
  `content` varchar(255) DEFAULT NULL COMMENT '卡密或链接内容',
  `type` int(1) DEFAULT NULL COMMENT '类型，1卡密，2链接',
  `status` int(1) DEFAULT NULL COMMENT '状态，1正常，0已使用',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='tab标签';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_goods_card`
--

LOCK TABLES `we_im_goods_card` WRITE;
/*!40000 ALTER TABLE `we_im_goods_card` DISABLE KEYS */;
/*!40000 ALTER TABLE `we_im_goods_card` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_goods_class`
--

DROP TABLE IF EXISTS `we_im_goods_class`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_goods_class` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(255) DEFAULT NULL COMMENT '名称',
  `sort` int(11) DEFAULT NULL COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='tab标签';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_goods_class`
--

LOCK TABLES `we_im_goods_class` WRITE;
/*!40000 ALTER TABLE `we_im_goods_class` DISABLE KEYS */;
/*!40000 ALTER TABLE `we_im_goods_class` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_goods_data`
--

DROP TABLE IF EXISTS `we_im_goods_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_goods_data` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `class_id` int(11) DEFAULT NULL COMMENT '分类id',
  `class_name` varchar(255) DEFAULT NULL COMMENT '分类名',
  `keyword` varchar(255) DEFAULT NULL COMMENT '唤醒关键词',
  `name` varchar(255) DEFAULT NULL COMMENT '商品名称',
  `amount` decimal(18,2) DEFAULT NULL COMMENT '单价',
  `type` int(1) DEFAULT NULL COMMENT '类型，1卡密，2链接',
  `status` int(1) DEFAULT NULL COMMENT '状态，0下架，1上架',
  `img` varchar(255) DEFAULT NULL COMMENT '图片地址',
  `content` text COMMENT '详细说明',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='tab标签';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_goods_data`
--

LOCK TABLES `we_im_goods_data` WRITE;
/*!40000 ALTER TABLE `we_im_goods_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `we_im_goods_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_goods_order`
--

DROP TABLE IF EXISTS `we_im_goods_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_goods_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `class_id` int(11) DEFAULT NULL COMMENT '分类id',
  `class_name` varchar(255) DEFAULT NULL COMMENT '分类名',
  `goods_id` int(11) DEFAULT NULL COMMENT '商品id',
  `goods_name` varchar(255) DEFAULT NULL COMMENT '商品名',
  `amount` decimal(18,2) DEFAULT NULL COMMENT '单价',
  `number` int(11) DEFAULT NULL COMMENT '数量',
  `total` decimal(18,2) DEFAULT NULL COMMENT '总价',
  `status` int(11) DEFAULT NULL COMMENT '状态，0待付款，8待发货，9已完结',
  `content` varchar(255) DEFAULT NULL COMMENT '卡密信息',
  `pay_type` varchar(255) DEFAULT NULL COMMENT '支付方式',
  `pay_status` varchar(255) DEFAULT NULL COMMENT '支付状态，0待支付，1已支付',
  `pay_time` int(11) DEFAULT NULL COMMENT '支付时间',
  `pay_total` decimal(18,2) DEFAULT NULL COMMENT '实付款',
  `create_time` int(11) DEFAULT NULL COMMENT '下单时间',
  `out_trade_no` varchar(255) DEFAULT NULL COMMENT '订单号',
  `to_id` int(11) DEFAULT NULL COMMENT '用户id',
  `to_nick` varchar(255) DEFAULT NULL COMMENT '用户昵称',
  `to_avatar` varchar(255) DEFAULT NULL,
  `from_id` int(11) DEFAULT NULL,
  `from_nick` varchar(255) DEFAULT NULL,
  `from_avatar` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL COMMENT '购买人信息',
  `send` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='tab标签';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_goods_order`
--

LOCK TABLES `we_im_goods_order` WRITE;
/*!40000 ALTER TABLE `we_im_goods_order` DISABLE KEYS */;
/*!40000 ALTER TABLE `we_im_goods_order` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_hooks`
--

DROP TABLE IF EXISTS `we_im_hooks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_hooks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(40) NOT NULL DEFAULT '' COMMENT '钩子名称',
  `description` text NOT NULL COMMENT '描述',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '类型',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `addons` varchar(255) NOT NULL DEFAULT '' COMMENT '钩子挂载的插件,分割',
  `status` tinyint(2) DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_hooks`
--

LOCK TABLES `we_im_hooks` WRITE;
/*!40000 ALTER TABLE `we_im_hooks` DISABLE KEYS */;
INSERT INTO `we_im_hooks` VALUES (21,'demo','demo钩子',1,1384481614,'test',1);
/*!40000 ALTER TABLE `we_im_hooks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_invite_set`
--

DROP TABLE IF EXISTS `we_im_invite_set`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_invite_set` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `m_auto_invite` int(11) DEFAULT NULL COMMENT '手机端自动邀请开关',
  `m_content` text COMMENT '手机端邀请语',
  `m_guest1` int(11) DEFAULT NULL COMMENT '手机端首次邀请延迟',
  `m_location_dir` int(11) DEFAULT NULL COMMENT '手机端弹窗显示位置，1中间，2底部',
  `m_no_client` int(11) DEFAULT NULL COMMENT '手机端无客服不弹窗开关',
  `m_title` varchar(255) DEFAULT NULL COMMENT '手机端邀请标题',
  `web_auto_invite` int(11) DEFAULT NULL COMMENT '电脑端自动邀请开关',
  `web_content` text COMMENT '电脑端邀请语',
  `web_guest1` int(11) DEFAULT NULL COMMENT '电脑端首次邀请延迟',
  `web_guest2` int(11) DEFAULT NULL,
  `web_guest3` int(11) DEFAULT NULL,
  `web_location` int(11) DEFAULT NULL COMMENT '电脑端弹窗显示位置',
  `web_no_client` int(11) DEFAULT NULL COMMENT '电脑端无客服不弹窗开关',
  `web_offset_x` int(11) DEFAULT NULL COMMENT '电脑端弹窗位置x轴偏移量',
  `web_offset_y` int(11) DEFAULT NULL COMMENT '电脑端弹窗位置y轴偏移量',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8 COMMENT='tab标签';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_invite_set`
--

LOCK TABLES `we_im_invite_set` WRITE;
/*!40000 ALTER TABLE `we_im_invite_set` DISABLE KEYS */;
INSERT INTO `we_im_invite_set` VALUES (1,1,'欢迎',1,2,0,'你好',1,'您好 有什么可以帮助到您的吗？',1,10,30,5,1,0,0);
/*!40000 ALTER TABLE `we_im_invite_set` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_ip_address`
--

DROP TABLE IF EXISTS `we_im_ip_address`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_ip_address` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `ip` varchar(255) DEFAULT NULL COMMENT 'ip',
  `pro` varchar(255) DEFAULT NULL COMMENT '省',
  `city` varchar(255) DEFAULT NULL COMMENT '市',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COMMENT='tab标签';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_ip_address`
--

LOCK TABLES `we_im_ip_address` WRITE;
/*!40000 ALTER TABLE `we_im_ip_address` DISABLE KEYS */;
INSERT INTO `we_im_ip_address` VALUES (23,'117.136.30.2','$pro','重庆市重庆市  移动 ');
/*!40000 ALTER TABLE `we_im_ip_address` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_market`
--

DROP TABLE IF EXISTS `we_im_market`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_market` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL COMMENT '当前域名',
  `account` varchar(255) DEFAULT NULL,
  `pwd` varchar(255) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `secret` varchar(255) DEFAULT NULL,
  `create_time` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='插件市场表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_market`
--

LOCK TABLES `we_im_market` WRITE;
/*!40000 ALTER TABLE `we_im_market` DISABLE KEYS */;
/*!40000 ALTER TABLE `we_im_market` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_menu`
--

DROP TABLE IF EXISTS `we_im_menu`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `type` enum('menu','file') NOT NULL COMMENT 'menu为菜单,file为权限节点',
  `pid` int(10) unsigned NOT NULL COMMENT '父ID',
  `name` char(100) NOT NULL COMMENT '规则名称',
  `title` char(50) NOT NULL COMMENT '规则名称',
  `icon` char(50) NOT NULL COMMENT '图标',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `ismenu` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否为菜单',
  `issys` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否为系统菜单',
  `weigh` int(10) NOT NULL DEFAULT '100' COMMENT '权重',
  `status` char(30) NOT NULL COMMENT '状态',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`) USING BTREE,
  KEY `pid` (`pid`),
  KEY `weigh` (`weigh`)
) ENGINE=MyISAM AUTO_INCREMENT=43 DEFAULT CHARSET=utf8 COMMENT='菜单表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_menu`
--

LOCK TABLES `we_im_menu` WRITE;
/*!40000 ALTER TABLE `we_im_menu` DISABLE KEYS */;
INSERT INTO `we_im_menu` VALUES (1,'menu',0,'admin/index/index','首页','icon-2jichumokuai',1516374729,1516374729,1,1,1,'normal'),(2,'menu',0,'admin/chats/index','对话平台','icon-shejiao-duihuakuang',1516374729,1516374729,1,1,2,'normal'),(3,'menu',0,'admin/history/index','历史记录','icon-lishi1',1516374729,1516374729,1,1,3,'normal'),(4,'menu',0,'admin/evaluation/index','评价管理','icon-pingjia1',1516374729,1516374729,1,1,5,'normal'),(5,'menu',0,'admin/set/index','系统设置','icon-shezhi1',1516374729,1516374729,1,1,6,'normal'),(6,'menu',5,'admin/set/access_code','网页部署','',1516374729,1516374729,1,1,1,'normal'),(30,'menu',5,'admin/attachment/index','附件管理','',1516374729,1516374729,1,1,4,'normal'),(9,'menu',5,'admin/set/set_general','通用设置','',1516374729,1516374729,1,1,2,'normal'),(10,'menu',5,'admin/set/set_service','客服管理','',1516374729,1516374729,1,1,3,'normal'),(11,'menu',5,'admin/set/set_service_group','客服分组','',1516374729,1516374729,1,1,4,'normal'),(12,'menu',5,'admin/set/set_problem','常见问题','',1516374729,1516374729,1,1,5,'normal'),(13,'menu',5,'admin/set/set_evaluation','评价设置','',1516374729,1516374729,1,1,6,'normal'),(14,'menu',5,'admin/set/set_attachment','附件设置','',1516374729,1516374729,1,1,7,'normal'),(15,'menu',0,'admin/plugins/index','插件中心','icon-chatouplug',1516374729,1516374729,1,1,7,'normal'),(16,'menu',15,'admin/plugins/plugin_lists','已安装','',1516374729,1516374729,1,1,1,'normal'),(17,'menu',15,'admin/plugins/plugin_upload','安装插件','',1516374729,1516374729,1,1,2,'normal'),(18,'menu',15,'admin/plugins/plugin_market','插件市场','',1516374729,1516374729,1,1,3,'normal'),(40,'menu',5,'admin/gateway/index','端口设置','',1516374729,1516374729,1,1,8,'normal'),(41,'menu',5,'admin/clean/index','数据清理','',1516374729,1516374729,1,1,8,'normal'),(42,'menu',5,'admin/consult/index','悬浮窗口','',1516374729,1516374729,1,1,9,'normal');
/*!40000 ALTER TABLE `we_im_menu` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_offlinerecord`
--

DROP TABLE IF EXISTS `we_im_offlinerecord`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_offlinerecord` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(255) DEFAULT NULL COMMENT '姓名',
  `mobile` varchar(20) DEFAULT NULL COMMENT '手机号',
  `qq` varchar(255) DEFAULT NULL COMMENT 'qq',
  `tm` varchar(255) DEFAULT NULL COMMENT '阿里旺旺',
  `email` varchar(255) DEFAULT NULL COMMENT '邮箱',
  `content` text COMMENT '咨询内容',
  `callback` char(1) DEFAULT '0' COMMENT '是否会电',
  `ip` varchar(255) DEFAULT NULL COMMENT 'ip',
  `address` varchar(255) DEFAULT NULL COMMENT '地点',
  `agent` varchar(255) DEFAULT NULL COMMENT '访问设备',
  `create_time` int(11) DEFAULT NULL COMMENT '下单时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='tab标签';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_offlinerecord`
--

LOCK TABLES `we_im_offlinerecord` WRITE;
/*!40000 ALTER TABLE `we_im_offlinerecord` DISABLE KEYS */;
/*!40000 ALTER TABLE `we_im_offlinerecord` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_options`
--

DROP TABLE IF EXISTS `we_im_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `option_cname` varchar(190) NOT NULL DEFAULT '' COMMENT '中文名称',
  `option_ename` varchar(190) NOT NULL DEFAULT '' COMMENT '英文名字',
  `option_value` longtext NOT NULL COMMENT '值',
  `option_default` varchar(150) NOT NULL DEFAULT '' COMMENT '默认值',
  `option_level` int(11) NOT NULL DEFAULT '1' COMMENT '使用等级',
  `option_type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '类型1文本',
  `option_desc` char(50) NOT NULL DEFAULT '' COMMENT '提示信息',
  `type_id` smallint(6) NOT NULL DEFAULT '0' COMMENT '所属分类',
  `cuid` smallint(6) NOT NULL DEFAULT '0' COMMENT '所属主客服ID',
  PRIMARY KEY (`option_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COMMENT='自定义配置表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_options`
--

LOCK TABLES `we_im_options` WRITE;
/*!40000 ALTER TABLE `we_im_options` DISABLE KEYS */;
INSERT INTO `we_im_options` VALUES (1,'游客上传','set_attachment_yksc','1','',1,4,'',1,1),(2,'客服上传','set_attachment_kfsc','1','',1,4,'',1,1),(3,'文件上传','set_attachment_wjsc','1','',1,4,'',1,1),(4,'图片上传','set_attachment_tpsc','1','',1,4,'',1,1),(5,'储存类型','set_attachment_cclx','1','本地,1',1,8,'',1,1),(6,'文件格式','set_attachment_wjgs','jpg,jpeg,png,gif,doc,ppt,txt','',1,9,'',1,1),(7,'图片格式','set_attachment_tpgs','jpeg,jpg,gif,png,bmp','',1,9,'',1,1);
/*!40000 ALTER TABLE `we_im_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_options_type`
--

DROP TABLE IF EXISTS `we_im_options_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_options_type` (
  `type_id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `type_name` char(50) NOT NULL,
  PRIMARY KEY (`type_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='自定义表单分类';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_options_type`
--

LOCK TABLES `we_im_options_type` WRITE;
/*!40000 ALTER TABLE `we_im_options_type` DISABLE KEYS */;
INSERT INTO `we_im_options_type` VALUES (1,'附件设置');
/*!40000 ALTER TABLE `we_im_options_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_plugins`
--

DROP TABLE IF EXISTS `we_im_plugins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_plugins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(40) NOT NULL COMMENT '插件名或标识',
  `title` varchar(20) NOT NULL DEFAULT '' COMMENT '中文名',
  `description` text COMMENT '插件描述',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  `config` text COMMENT '配置',
  `author` varchar(40) DEFAULT '' COMMENT '作者',
  `version` varchar(20) DEFAULT '' COMMENT '版本号',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '安装时间',
  `has_adminlist` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否有后台列表',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='插件表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_plugins`
--

LOCK TABLES `we_im_plugins` WRITE;
/*!40000 ALTER TABLE `we_im_plugins` DISABLE KEYS */;
INSERT INTO `we_im_plugins` VALUES (2,'test','test插件','test插件简介',1,NULL,'byron sampson','0.1',1438154545,0);
/*!40000 ALTER TABLE `we_im_plugins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_qqqpan`
--

DROP TABLE IF EXISTS `we_im_qqqpan`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_qqqpan` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `out_trade_no` varchar(255) DEFAULT NULL COMMENT '订单号',
  `total_amount` decimal(18,2) DEFAULT NULL COMMENT '付款金额',
  `subject` varchar(255) DEFAULT NULL COMMENT '商品标题',
  `status` varchar(255) DEFAULT NULL COMMENT '状态',
  `pay_time` int(11) DEFAULT NULL COMMENT '支付时间',
  `create_time` int(11) DEFAULT NULL COMMENT '下单时间',
  `addons` varchar(255) DEFAULT NULL,
  `addons_notify` varchar(255) DEFAULT NULL,
  `no` varchar(255) DEFAULT NULL COMMENT '通道号',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='tab标签';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_qqqpan`
--

LOCK TABLES `we_im_qqqpan` WRITE;
/*!40000 ALTER TABLE `we_im_qqqpan` DISABLE KEYS */;
/*!40000 ALTER TABLE `we_im_qqqpan` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_qqqpan_set`
--

DROP TABLE IF EXISTS `we_im_qqqpan_set`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_qqqpan_set` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `name` varchar(255) DEFAULT NULL COMMENT '前台显示名称',
  `sort` int(11) DEFAULT NULL COMMENT '排序',
  `status` int(11) DEFAULT NULL COMMENT '状态，0禁用，1启用',
  `no` varchar(255) DEFAULT NULL COMMENT '通道编号',
  `type` varchar(255) DEFAULT NULL COMMENT '类型qr，url',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='tab标签';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_qqqpan_set`
--

LOCK TABLES `we_im_qqqpan_set` WRITE;
/*!40000 ALTER TABLE `we_im_qqqpan_set` DISABLE KEYS */;
INSERT INTO `we_im_qqqpan_set` VALUES (4,'支付宝','支付宝',10,1,'001','qr');
/*!40000 ALTER TABLE `we_im_qqqpan_set` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_record`
--

DROP TABLE IF EXISTS `we_im_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_record` (
  `id` int(20) unsigned NOT NULL AUTO_INCREMENT,
  `send` smallint(8) NOT NULL DEFAULT '0' COMMENT '发送者',
  `send_avatar` char(220) NOT NULL DEFAULT '',
  `receive` smallint(8) NOT NULL DEFAULT '0' COMMENT '接收者',
  `receive_avatar` char(200) NOT NULL DEFAULT '',
  `type` char(15) NOT NULL DEFAULT 'text' COMMENT '消息类型',
  `utype` set('say_from','say_to') DEFAULT NULL COMMENT '聊天类型',
  `content` varchar(2000) NOT NULL COMMENT '发送内容',
  `send_time` int(10) NOT NULL COMMENT '发送时间',
  `is_read` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0未读1已读',
  `send_nick` char(50) NOT NULL COMMENT '发送者昵称',
  `receive_nick` char(50) NOT NULL COMMENT '接收者昵称',
  `main_id` smallint(6) NOT NULL DEFAULT '0' COMMENT '主客服ID',
  PRIMARY KEY (`id`),
  KEY `send` (`send`),
  KEY `receive` (`receive`)
) ENGINE=MyISAM AUTO_INCREMENT=480 DEFAULT CHARSET=utf8 COMMENT='聊天记录表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_record`
--

LOCK TABLES `we_im_record` WRITE;
/*!40000 ALTER TABLE `we_im_record` DISABLE KEYS */;
/*!40000 ALTER TABLE `we_im_record` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_site_data`
--

DROP TABLE IF EXISTS `we_im_site_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_site_data` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `im_stat_zxhy` int(5) NOT NULL DEFAULT '0' COMMENT '咨询会员总数',
  `im_stat_wjd` int(5) NOT NULL DEFAULT '0' COMMENT '未接待会员',
  `im_stat_jrlt` int(5) NOT NULL DEFAULT '0' COMMENT '今日聊天数',
  `im_stat_jrpj` int(5) NOT NULL DEFAULT '0' COMMENT '今日评价数量',
  `im_stat_ltxx` int(5) NOT NULL DEFAULT '0' COMMENT '聊天消息总数',
  `im_stat_zpj` int(5) NOT NULL DEFAULT '0' COMMENT '总评价数量',
  `main_id` smallint(6) NOT NULL DEFAULT '0' COMMENT '主客服ID',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='统计数据';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_site_data`
--

LOCK TABLES `we_im_site_data` WRITE;
/*!40000 ALTER TABLE `we_im_site_data` DISABLE KEYS */;
INSERT INTO `we_im_site_data` VALUES (1,0,0,0,0,0,0,1);
/*!40000 ALTER TABLE `we_im_site_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_sms_modes`
--

DROP TABLE IF EXISTS `we_im_sms_modes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_sms_modes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `title` char(20) NOT NULL DEFAULT '' COMMENT '标题',
  `code` char(20) NOT NULL DEFAULT '' COMMENT '模版号',
  `content` text NOT NULL COMMENT '内容',
  `main_id` smallint(6) NOT NULL DEFAULT '0' COMMENT '主客服ID',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='tab标签';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_sms_modes`
--

LOCK TABLES `we_im_sms_modes` WRITE;
/*!40000 ALTER TABLE `we_im_sms_modes` DISABLE KEYS */;
INSERT INTO `we_im_sms_modes` VALUES (3,'注册短信','USER_REGISTER','尊敬的用户，您正在注册，验证码为{$code}，打死不要告诉别人哦;',0),(4,'订单支付','ORDER_PAY','尊敬的用户，您的订单({$order_no})已经完成支付，支付金额为：{$money}，祝您生活愉快。',0),(5,'会员充值','USER_RECHARGE','恭喜{$account}成功充值{$money}元{$gold}金币，您的订单号为：{$order_no}，感谢您的支持如有疑问可以联系客服',0),(6,'会员等级','USER_LEVEL','恭喜{$account}成功购买用户组{$level},支付金额{$money}元，您的订单号为：{$order_no}，感谢您的支持如有疑问可以联系客服',0);
/*!40000 ALTER TABLE `we_im_sms_modes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_tabs`
--

DROP TABLE IF EXISTS `we_im_tabs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_tabs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `title` char(20) NOT NULL DEFAULT '' COMMENT '标题',
  `content` text NOT NULL COMMENT '内容',
  `main_id` smallint(6) NOT NULL DEFAULT '0' COMMENT '主客服ID',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='tab标签';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_tabs`
--

LOCK TABLES `we_im_tabs` WRITE;
/*!40000 ALTER TABLE `we_im_tabs` DISABLE KEYS */;
/*!40000 ALTER TABLE `we_im_tabs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_u9w`
--

DROP TABLE IF EXISTS `we_im_u9w`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_u9w` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `out_trade_no` varchar(255) DEFAULT NULL COMMENT '订单号',
  `total_amount` decimal(18,2) DEFAULT NULL COMMENT '付款金额',
  `subject` varchar(255) DEFAULT NULL COMMENT '商品标题',
  `status` varchar(255) DEFAULT NULL COMMENT '状态',
  `pay_time` int(11) DEFAULT NULL COMMENT '支付时间',
  `create_time` int(11) DEFAULT NULL COMMENT '下单时间',
  `addons` varchar(255) DEFAULT NULL,
  `addons_notify` varchar(255) DEFAULT NULL,
  `no` varchar(255) DEFAULT NULL COMMENT '通道号',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='tab标签';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_u9w`
--

LOCK TABLES `we_im_u9w` WRITE;
/*!40000 ALTER TABLE `we_im_u9w` DISABLE KEYS */;
/*!40000 ALTER TABLE `we_im_u9w` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_u9w_set`
--

DROP TABLE IF EXISTS `we_im_u9w_set`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_u9w_set` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `name` varchar(255) DEFAULT NULL COMMENT '前台显示名称',
  `sort` int(11) DEFAULT NULL COMMENT '排序',
  `status` int(11) DEFAULT NULL COMMENT '状态，0禁用，1启用',
  `no` varchar(255) DEFAULT NULL COMMENT '通道编号',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='tab标签';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_u9w_set`
--

LOCK TABLES `we_im_u9w_set` WRITE;
/*!40000 ALTER TABLE `we_im_u9w_set` DISABLE KEYS */;
INSERT INTO `we_im_u9w_set` VALUES (3,'微信支付','悠久支付',1,1,'952');
/*!40000 ALTER TABLE `we_im_u9w_set` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_unread`
--

DROP TABLE IF EXISTS `we_im_unread`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_unread` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `uid` int(11) DEFAULT NULL COMMENT '用户id',
  `number` int(11) DEFAULT NULL COMMENT '未读消息数量',
  `show` int(11) DEFAULT '1' COMMENT '左菜单显示',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=45 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_unread`
--

LOCK TABLES `we_im_unread` WRITE;
/*!40000 ALTER TABLE `we_im_unread` DISABLE KEYS */;
INSERT INTO `we_im_unread` VALUES (31,9,0,0),(32,10,0,0),(33,13,0,0),(34,14,0,0),(35,14,0,0),(36,14,0,0),(37,15,0,0),(38,18,0,0),(39,19,0,0),(40,23,0,0),(41,26,0,0),(42,31,0,0),(43,30,0,0),(44,32,0,0);
/*!40000 ALTER TABLE `we_im_unread` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_user_level`
--

DROP TABLE IF EXISTS `we_im_user_level`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_user_level` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `amount` decimal(18,2) DEFAULT NULL COMMENT '单价',
  `level` int(11) DEFAULT NULL COMMENT '等级',
  `name` varchar(255) DEFAULT NULL COMMENT '等级名',
  `sort` int(11) DEFAULT NULL COMMENT '排序',
  `keyword` varchar(255) DEFAULT NULL COMMENT '关键字',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='tab标签';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_user_level`
--

LOCK TABLES `we_im_user_level` WRITE;
/*!40000 ALTER TABLE `we_im_user_level` DISABLE KEYS */;
/*!40000 ALTER TABLE `we_im_user_level` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_user_level_order`
--

DROP TABLE IF EXISTS `we_im_user_level_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_user_level_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `out_trade_no` varchar(255) DEFAULT NULL COMMENT '订单号',
  `total_amount` decimal(18,2) DEFAULT NULL COMMENT '付款金额',
  `level` int(11) DEFAULT NULL COMMENT '升级等级',
  `to_id` int(11) DEFAULT NULL COMMENT '会员id',
  `to_nick` varchar(255) DEFAULT NULL COMMENT '会员昵称',
  `to_avatar` varchar(255) DEFAULT NULL COMMENT '会员头像',
  `from_id` int(11) DEFAULT NULL COMMENT '客服id',
  `from_nick` varchar(255) DEFAULT NULL COMMENT '客服昵称',
  `from_avatar` varchar(255) DEFAULT NULL COMMENT '客服头像',
  `ip` varchar(255) DEFAULT NULL COMMENT 'IP地址',
  `status` varchar(255) DEFAULT NULL COMMENT '状态',
  `send_type` varchar(255) DEFAULT NULL COMMENT '通知方式',
  `pay_type` varchar(255) DEFAULT NULL COMMENT '支付方式',
  `pay_time` int(11) DEFAULT NULL COMMENT '支付时间',
  `create_time` int(11) DEFAULT NULL COMMENT '下单时间',
  `account` varchar(255) DEFAULT NULL COMMENT '会员标识',
  `user` varchar(255) DEFAULT NULL COMMENT '查询表示',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='tab标签';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_user_level_order`
--

LOCK TABLES `we_im_user_level_order` WRITE;
/*!40000 ALTER TABLE `we_im_user_level_order` DISABLE KEYS */;
/*!40000 ALTER TABLE `we_im_user_level_order` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_user_recharge`
--

DROP TABLE IF EXISTS `we_im_user_recharge`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_user_recharge` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `amount` decimal(18,2) DEFAULT NULL COMMENT '单价',
  `gold` decimal(18,2) DEFAULT NULL COMMENT '金币',
  `sort` int(11) DEFAULT NULL COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='tab标签';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_user_recharge`
--

LOCK TABLES `we_im_user_recharge` WRITE;
/*!40000 ALTER TABLE `we_im_user_recharge` DISABLE KEYS */;
INSERT INTO `we_im_user_recharge` VALUES (1,0.01,1.00,1);
/*!40000 ALTER TABLE `we_im_user_recharge` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_user_recharge_order`
--

DROP TABLE IF EXISTS `we_im_user_recharge_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_user_recharge_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `out_trade_no` varchar(255) DEFAULT NULL COMMENT '订单号',
  `total_amount` decimal(18,2) DEFAULT NULL COMMENT '付款金额',
  `gold` decimal(18,2) DEFAULT NULL COMMENT '获得金币',
  `to_id` int(11) DEFAULT NULL COMMENT '会员id',
  `to_nick` varchar(255) DEFAULT NULL COMMENT '会员昵称',
  `to_avatar` varchar(255) DEFAULT NULL COMMENT '会员头像',
  `from_id` int(11) DEFAULT NULL COMMENT '客服id',
  `from_nick` varchar(255) DEFAULT NULL COMMENT '客服昵称',
  `from_avatar` varchar(255) DEFAULT NULL COMMENT '客服头像',
  `ip` varchar(255) DEFAULT NULL COMMENT 'IP地址',
  `status` varchar(255) DEFAULT NULL COMMENT '状态',
  `send_type` varchar(255) DEFAULT NULL COMMENT '通知方式',
  `pay_type` varchar(255) DEFAULT NULL COMMENT '支付方式',
  `pay_time` int(11) DEFAULT NULL COMMENT '支付时间',
  `create_time` int(11) DEFAULT NULL COMMENT '下单时间',
  `account` varchar(255) DEFAULT NULL COMMENT '会员标识',
  `user` varchar(255) DEFAULT NULL COMMENT '查询标识',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='tab标签';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_user_recharge_order`
--

LOCK TABLES `we_im_user_recharge_order` WRITE;
/*!40000 ALTER TABLE `we_im_user_recharge_order` DISABLE KEYS */;
/*!40000 ALTER TABLE `we_im_user_recharge_order` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_visitors`
--

DROP TABLE IF EXISTS `we_im_visitors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_visitors` (
  `id` int(12) unsigned NOT NULL AUTO_INCREMENT,
  `avatar` char(220) NOT NULL DEFAULT '/images/avatar/def.png' COMMENT '头像',
  `ip` char(20) NOT NULL COMMENT 'ip',
  `state` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态0离线1在线',
  `nick` char(50) NOT NULL DEFAULT '' COMMENT '网名',
  `last_time` int(10) NOT NULL DEFAULT '0' COMMENT '最后对话时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ip` (`ip`)
) ENGINE=MyISAM AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COMMENT='访客表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_visitors`
--

LOCK TABLES `we_im_visitors` WRITE;
/*!40000 ALTER TABLE `we_im_visitors` DISABLE KEYS */;
INSERT INTO `we_im_visitors` VALUES (33,'/images/avatar/visi/125.jpg','1.31.149.187',1,'游客kBDLUhCN',1622295127);
/*!40000 ALTER TABLE `we_im_visitors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_visitors_info`
--

DROP TABLE IF EXISTS `we_im_visitors_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_visitors_info` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `vsid` smallint(6) NOT NULL DEFAULT '0' COMMENT '游客id',
  `cuid` smallint(6) NOT NULL DEFAULT '0' COMMENT '客服id',
  `source` char(150) NOT NULL DEFAULT '' COMMENT '来源',
  `city` char(100) NOT NULL DEFAULT '' COMMENT '城市',
  `name` char(30) NOT NULL DEFAULT '' COMMENT '名字',
  `phone` char(30) NOT NULL DEFAULT '' COMMENT '电话',
  `note` varchar(300) NOT NULL DEFAULT '' COMMENT '备注',
  `equi` char(100) NOT NULL DEFAULT '' COMMENT '设备',
  `views` int(10) NOT NULL DEFAULT '0' COMMENT '咨询次数',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COMMENT='访客信息表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_visitors_info`
--

LOCK TABLES `we_im_visitors_info` WRITE;
/*!40000 ALTER TABLE `we_im_visitors_info` DISABLE KEYS */;
INSERT INTO `we_im_visitors_info` VALUES (33,33,1,'https://www.69kz.com/','','','','','Windows 98',0);
/*!40000 ALTER TABLE `we_im_visitors_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `we_im_wechat`
--

DROP TABLE IF EXISTS `we_im_wechat`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `we_im_wechat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `out_trade_no` varchar(255) DEFAULT NULL COMMENT '订单号',
  `total_amount` decimal(18,2) DEFAULT NULL COMMENT '付款金额',
  `subject` varchar(255) DEFAULT NULL COMMENT '商品标题',
  `qr_code` varchar(255) DEFAULT NULL COMMENT '二维码路径',
  `content` text COMMENT '所有订单参数',
  `status` varchar(255) DEFAULT NULL COMMENT '状态',
  `pay_time` int(11) DEFAULT NULL COMMENT '支付时间',
  `create_time` int(11) DEFAULT NULL COMMENT '下单时间',
  `addons` varchar(255) DEFAULT NULL,
  `addons_notify` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='tab标签';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `we_im_wechat`
--

LOCK TABLES `we_im_wechat` WRITE;
/*!40000 ALTER TABLE `we_im_wechat` DISABLE KEYS */;
/*!40000 ALTER TABLE `we_im_wechat` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping events for database 'kuzhankefu'
--

--
-- Dumping routines for database 'kuzhankefu'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2021-05-30  9:50:23
