$(function () {
    loadCustomerAll();

    /**
     * 点击客服获取访客
     */
    $('body').on('click','#custlist li', function() {
        var cuid = $(this).attr('cuid');
        $(this).addClass('col-active').siblings().removeClass('col-active');
        $.ajax({
            type: "post",
            url: IM_config.getCuidVisitorsAll,
            data: {
                cuid:cuid
            },
            dataType: "json",
            success : function(r) {
                if (r.code == 200) {
                    var visilist = "";
                    $.each(r.data,function(index, item) {
                        visilist += '<li class="cursor" vsid="'+item.id+'">'+
                            '<div class="item-img">'+
                                '<img src="'+item.avatar+'">'+
                            '</div>'+
                            '<div class="item-title">'+
                                '<span>'+item.nick+'</span>'+
                            '</div>'+
                        '</li>';
                    });
                    $('#col-visi').show();
                    $('#visilist').html(visilist);
                } else {
                    return we_im_msg('无数据');
                    $('#col-visi,#col-time,#col-record').hide();
                }
            }
        });
    });

    /**
     * 点击访客显示时间段
     */
    $('body').on('click','#visilist li', function() {
        $('#col-time').show();
        $('#getvsid').val($(this).attr('vsid'));
        $(this).addClass('col-active').siblings().removeClass('col-active');
    });

    /**
     * 点击时间
     */
    $('body').on('click','#timelist .time2', function() {
        loadMesssage({
            vsid: $('#getvsid').val(),
            type: $(this).attr('type')
        });
        $(this).addClass('col-active').siblings().removeClass('col-active');
    });

    /**
     * 点击时间段
     */
    $('body').on('click','#timelist .time3 button', function() {
        var vsid  = $('#getvsid').val();
        var cuid  = $('#custlist .col-active').attr('cuid');
        var type  = $(this).attr('type');
        var start = $('#start').val();
        var end   = $('#end').val();
        $('#timelist .col-active').removeClass('col-active');
        if (!start) return we_im_msg('开始时间不能为空');
        if (!end) return we_im_msg('结束时间不能为空');
        loadMesssage({
            cuid:cuid,
            vsid:vsid,
            type:type,
            start:start,
            end:end
        });
    });
});

function loadMesssage(data) {
    $.ajax({
        type: "post",
        url: IM_config.getTimeRecord,
        data: data,
        dataType: "json",
        success : function(r) {
            if (r.code == 200) {
                var message = "";
                $('#col-record').show();
                $.each(r.data,function(index, item) {
                    if (item.utype == 'say_from') {
                        message += '<li class="chatmsg">'+
                            '<div class="showtime">'+timestamp(item.send_time)+'</div>'+
                            '<div style="position: absolute;left:3px;">'+
                                '<img class="my-circle se_pic" src="'+item.send_avatar+'" width="50px" height="50px">'+
                            '</div>'+
                            '<div class="outer-left">'+
                                '<div class="customer">'+
                                    '<pre>'+item.content+'</pre>'+
                                '</div>'+
                            '</div>'+
                        '</li>';
                    } else {
                        message += '<li class="chatmsg">'+
                            '<div class="showtime">'+timestamp(item.send_time)+'</div>'+
                            '<div style="position: absolute;top: 26px;right: 2px;">'+
                                '<img class="my-circle cu_pic" src="'+item.send_avatar+'" width="50px" height="50px">'+
                            '</div>'+
                            '<div class="outer-right">'+
                                '<div class="service">'+
                                    '<pre>'+item.content+'</pre>'+
                                '</div>'+
                            '</div>'+
                        '</li>';
                    }
                });
                $('.conversation').html(message);
                $("#wrap").animate({
                    scrollTop:$("#wrap").prop("scrollHeight")
                }, 50);
            } else {
                $('#col-record').hide();
                $('.conversation').html("");
                return we_im_msg(r.msg);
            }
        }
    });
}

/**
 * 加载显示全部客服
 */
function loadCustomerAll() {
    $.ajax({
        type: "get",
        url: IM_config.getCustomerAll,
        dataType: "json",
        success : function(r) {
            if (r.code == 200) {
                var custlist = "";
                $.each(r.data,function(index, item) {
                    custlist += '<li class="cursor" cuid="'+item.id+'">'+
                        '<div class="item-img">'+
                            '<img src="'+item.avatar+'">'+
                        '</div>'+
                        '<div class="item-title">'+
                            '<span>'+item.nick+'</span>'+
                        '</div>'+
                    '</li>';
                });
                $('#custlist').html(custlist);
            }
        }
    });
}