/**
 1、在要验证的input中写上form-verify="验证方法名|验证方法名" 可写多个但要用|分隔开
 */
var checkedInput = {
    //用户名
    userNames: [
        /^[a-zA-Z0-9_-]{2,20}$/, '由2-20位的字母或数字组成'
    ],
    userName: [
        /^[a-zA-Z\u4e00-\u9fa5]{2,10}$/, '由2-20位中文或英文组成'
    ],
    //英文
    english: [
        /^[A-Za-z]+$/, '只能输入英文'
    ],
    //汉字
    chinese: [
        /^[\u4e00-\u9fa5]+$/, '只能输入汉字'
    ],
    //匹配中文(包括汉字和字符)
    chineseChar: [
        /^[\u0391-\uFFE5]+$/, '只能输入中文(包括汉字和字符)'
    ],
    //字符验证，只能包含中文、英文、数字、下划线等字符
    stringCheck: [
        /^[a-zA-Z0-9\u4e00-\u9fa5-_]+$/, '只能输入中文、英文、数字、下划线等字符'
    ],
    //邮箱
    email: [
        /^(\w-*\.*)+@(\w-?)+(\.\w{2,})+$/, '请输入正确的邮箱'
    ],
    //QQ
    QQ: [
        /^[1-9]\d{4,12}$/, '请输入正确的QQ'
    ],
    //手机号码
    phone: [
        /^1(2|3|4|5|6|7|8|9)\d{9}$/, '请输入正确的手机号码'
    ],
    //居民身份证
    IDCard: [
        /^[1-9]\d{5}[1-9]\d{3}((0\d)|(1[0-2]))(([0|1|2]\d)|3[0-1])\d{3}(\d|x|X)$/, '请输入正确的身份证'
    ],
    //护照
    passport: [
        /^[a-zA-Z0-9]{5,17}$/, '请输入正确的护照'
    ],
    //台胞证   0099730503
    taiWanCertificate: [
        /^([0-9]{8}|[0-9]{10})$/, '请输入正确的台胞证'
    ],
    //港澳通行证
    hongKong: [
        /^[a-zA-Z0-9]{6,10}$/, '请输入正确的港澳通行证'
    ],
    //营业执照
    businessLicense: [
        /^[a-zA-Z0-9]{10,20}$/, '请输入正确的营业执照'
    ],
    //驾照
    drivingLicense: [
        /^[1-9]\d{5}[1-9]\d{3}((0\d)|(1[0-2]))(([0|1|2]\d)|3[0-1])\d{3}(\d|x|X)$/, '请输入正确的驾照'
    ],
    //车牌号正则
    plateNumbers: [
        /^[京津沪渝冀豫云辽黑湘皖鲁新苏浙赣鄂桂甘晋蒙陕吉闽贵粤青藏川宁琼使领A-Z]{1}[A-Z]{1}[A-Z0-9]{4}[A-Z0-9挂学警港澳]{1}$/, '请输入正确的车牌号'
    ],
    //组织机构代码证
    organizationCodeCertificate: [
        /^[a-zA-Z0-9]{10,20}$/, '请输入正确的组织机构代码证'
    ],
    //密码
    password: [
        /^[a-zA-Z]\w{5,17}$/,'必须以字母开头，长度在6~18之间，只能包含字母、数字和下划线'
    ],
    //高强度密码
    seniorPassword:[
        /^(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{8,20}$/,'必须包含大小写字母和数字的组合，不能使用特殊字符，长度在8-20之间'
    ],
    //日期
    date: [
        /^((((19|20)\d{2})-(0?[13-9]|1[012])-(0?[1-9]|[12]\d|30))|(((19|20)\d{2})-(0?[13578]|1[02])-31)|(((19|20)\d{2})-0?2-(0?[1-9]|1\d|2[0-8]))|((((19|20)([13579][26]|[2468][048]|0[48]))|(2000))-0?2-29))$/,
        '请输入正确的日期</br>格式 2020-02-02'
    ],
    //时间
    time: [
        /^(20|21|22|23|[0-1]\d):[0-5]\d:[0-5]\d$/, '请输入正确的时间</br>格式 12:00:00 '
    ],

    //只能输入数字[0-9]
    number: [
        /^\d+$/, '只能输入数字'
    ],
    //整数
    integer: [
        /^[-\+]?\d+$/, '您输入的不是整数'
    ],
    //邮政编码
    zipCode: [
        /^[0-9]{6}$/, '请输入正确的邮政编码'
    ],
    //访问地址URL
    Url: [
        /^http:\/\/[A-Za-z0-9]+\.[A-Za-z0-9]+[\/=\?%\-&_~`@[\]\’:+!]*([^<>\"])*$/, '请输入正确的访问地址'
    ],
    //判断是否为合法字符(a-zA-Z0-9-_)
    rightfulString: [
        /^[A-Za-z0-9_-]+$/, '请输入合法字符'
    ],
    //money
    money: [
        /^\d+(\.\d{1,2})?$/, '请输入有效数字或者两位小数，或者一位小数，整数'
    ],
    //ipv4地址正则
    ipV4:[
        /^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/,'请输入正确的ip'
    ],
    //十六进制颜色判断
    rgbHex :[
        /^#?([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$/,'请输入正确的颜色 </br>格式 #000000或#000'
    ],
    //固话或者传真
    faxes:[
        /^[+]{0,1}(\d){1,3}[ ]?([-]?((\d)|[ ]){1,12})+$/,'请输入正确的传真'
    ],
    // 必填项
    required: function(value) {
        if (value == "" || value == null) {
            return "必填项不能为空";
        } else {
            return true;
        }
    }
}

//验证函数
function checkedInputFunction(element) {
    //定义i (当i=1时则验证失败，i=0验证通过)
    var i = 0;
    var layDate = element.parents("body").find('[form-verify]');
    $.each(layDate, function() {
        var obj  = $(this);
        var key  = obj.attr("form-verify");
        var keys = key.split("|");
        var msg  = obj.attr("data-rule-msg");
        var msgs = msg.split("|");
        for (k in keys) {
            var value = obj.val();
            if (checkedInput[keys[k]] != null) {
                if (typeof checkedInput[keys[k]] == "function") {
                    var keyFunction = checkedInput[keys[k]];
                    var retValue = keyFunction(value);
                    if (retValue != true) {
                        if (msgs.hasOwnProperty(k)) {
                            we_im_msg(msgs[k]!=''?msgs[k]:retValue);
                        } else {
                            we_im_msg(retValue);
                        }
                        obj.focus();
                        i++;
                        return false;
                    }
                } else if (typeof checkedInput[keys[k]] == "object") {
                    if (!checkedInput[keys[k]][0].test(value)) {
                        if (msgs.hasOwnProperty(k)) {
                            we_im_msg(msgs[k]!=''?msgs[k]:checkedInput[keys[k]][1]);
                        } else {
                            we_im_msg(checkedInput[keys[k]][1]);
                        }
                        obj.focus();
                        i++;
                        return false;
                    }
                }
            }
        }
    })
    if (i == 0) {
        return true;
    } else {
        return false;
    }
}

/**
 * 当前时间格式化
 * fmt：返回格式
 * dateFormat("YYYY-mm-dd HH:MM:SS")
 */
function dateFormat(fmt) {
    var ret;
    var date = new Date();
    const opt = {
        "Y+": date.getFullYear().toString(), // 年
        "m+": (date.getMonth() + 1).toString(), // 月
        "d+": date.getDate().toString(), // 日
        "H+": date.getHours().toString(), // 时
        "M+": date.getMinutes().toString(), // 分
        "S+": date.getSeconds().toString() // 秒
        // 有其他格式化字符需求可以继续添加，必须转化成字符串
    };
    for (var k in opt) {
        ret = new RegExp("(" + k + ")").exec(fmt);
        if (ret) {
            fmt = fmt.replace(ret[1], (ret[1].length == 1) ? (opt[k]) : (opt[k].padStart(ret[1].length, "0")))
        };
    };
    return fmt;
};

/**
 * 时间戳转化为年 月 日 时 分 秒
 * number: 传入时间戳
 * format：返回格式
 * var sjc = 1472048779952;
 * (formatTime(sjc, 'YYYY-mm-dd HH:MM:SS')
 */
function formatTime(number, format) {

    var formateArr = ['YYYY', 'mm', 'dd', 'HH', 'MM', 'SS'];
    var returnArr = [];

    var date = new Date(number);
    returnArr.push(date.getFullYear());
    returnArr.push(formatNumber(date.getMonth() + 1));
    returnArr.push(formatNumber(date.getDate()));

    returnArr.push(formatNumber(date.getHours()));
    returnArr.push(formatNumber(date.getMinutes()));
    returnArr.push(formatNumber(date.getSeconds()));

    for (var i in returnArr) {
        format = format.replace(formateArr[i], returnArr[i]);
    }
    return format;
};

function formatNumber(n) {
    n = n.toString()
    return n[1] ? n : '0' + n
};