<?php

use Workerman\Worker;
use Workerman\WebServer;
use GatewayWorker\BusinessWorker;

// 自动加载类
require_once __DIR__ . '/../vendor/autoload.php';

// 配置
$database = require_once __DIR__ . '/../../../config/database.php';
$config  = require __DIR__ . '/../../../config/im.php';

$mysql  = $database['connections']['mysql'];

// 设置进程
$worker = new BusinessWorker();

// 设置名称
$worker->name = 'YourAppBusinessWorker';

// 设置进程
$worker->count = 4;

// 服务注册地址
$worker->registerAddress = "{$config['Register_ip']}:{$config['Register_port']}";

$worker->onWorkerStart = function ($worker) use ($mysql) {
    global $db;
    $db = new \Workerman\MySQL\Connection($mysql['hostname'],$mysql['hostport'],$mysql['username'],$mysql['password'],$mysql['database']);
};

// 启动
if(!defined('GLOBAL_START'))
{
    Worker::runAll();
}