<?php

namespace SocketWorker;

use Workerman\Worker;
use Workerman\WebServer;
use GatewayWorker\Gateway;

// 自动加载类
require_once __DIR__ . '/../vendor/autoload.php';

// 配置
$config  = require __DIR__ . '/../../../config/im.php';

// gateway 进程
$gateway = new Gateway("websocket://0.0.0.0:" . $config['WS_port']);

// 设置名称
$gateway->name = 'YourAppGateway';

// 进程数
$gateway->count = 4;

// 本机ip，分布式部署时使用内网ip
$gateway->lanIp = $config['WS_intranet'];

// 通讯端口
$gateway->startPort = 2300;

// 服务注册地址
$gateway->registerAddress = "{$config['Register_ip']}:{$config['Register_port']}";

// 心跳间隔
$gateway->pingInterval = 50;

// 心跳数据
$gateway->pingData = '';

// 启动
if(!defined('GLOBAL_START')) {
    Worker::runAll();
}