﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Marker.aspx.cs" Inherits="TotCms.Web.MapApi.Marker" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>地图标记</title>
  <script src="../js/jquery-1.5.1.min.js" type="text/javascript"></script>
  <script type="text/javascript" src="http://api.map.baidu.com/api?v=2.0&ak=<%=MapKey()%>"></script>
  <style type="text/css">
<!--
body {
	margin-left: 0px;
	margin-top: 0px;
	margin-right: 0px;
	margin-bottom: 0px;
	font-size:12px;
}
input:focus {
	outline: none;
}
#apDiv1 {
	position:absolute;
	z-index:-999999;
}
#results {
	position:absolute;
	width:224px;
	height:93px;
	left: 2px;
	top: 1px;
	background-color: #f5f5f5;
	overflow:scroll;
}
-->
</style>
</head>
<body>
    <form id="form1" runat="server">
    <div>
    <input id="searchTextField" type="text" size="25" onkeyup="GetFromAddress(this.value)" />
    <input type="button" value="查询" onclick="GetFromAddress(document.getElementById('searchTextField').value)" />
</div>
<div id="apDiv1">
  <div id="results"></div>
</div>
<div id="container" style="width:99%;height:325px;border:1px solid gray;"></div>
<script type="text/javascript">
<!--
var rmarkers=[];
var map = new BMap.Map("container");
map.addControl(new BMap.NavigationControl());               // 添加平移缩放控件
map.addControl(new BMap.ScaleControl());                    // 添加比例尺控件
map.addControl(new BMap.OverviewMapControl());              //添加缩略地图控件
map.addControl(new BMap.MapTypeControl());          //添加地图类型控件
map.enableScrollWheelZoom();
map.addEventListener("click", function(e){  // 监听事件，提示标注点坐标信息  
 map.clearOverlays();
 addMarker(e.point,1);
 returnVal(e.point.lat,e.point.lng);
}); 
var _lng=<%=GetLng() %>;
var _lat=<%=GetLat() %>;
if(_lng>0 && _lat>0){
  map.centerAndZoom(new BMap.Point(_lng,_lat), 15);	
}else{
  var myGeo = new BMap.Geocoder();
  myGeo.getPoint("济南", function(point){
    if (point) {
      map.centerAndZoom(point, 15);		
    }
  }, "全国");
}
var options = {
  onSearchComplete: function(results){
    // 判断状态是否正确
    if (local.getStatus() == BMAP_STATUS_SUCCESS){
        var rhtm='';
        //s.push('<div style="font-family: arial,sans-serif; border: 1px solid rgb(153, 153, 153); font-size: 12px;">');
        //s.push('<div style="background: none repeat scroll 0% 0% rgb(255, 255, 255);">');
        rhtm+='<ol style="margin:10px 15px; padding:5px 15px;">';
        for (var i = 0; i < results.getCurrentNumPois(); i ++){        
            var selected = "";
            if(i == 0){
                selected = "background-color:#f0f0f0;";
            }
						var p=results.getPoi(i).point;
						rhtm+='<li id="list' + i + '" style="line-height:18px;">';
						rhtm+='<a href="javascript:showMarker('+p.lat+','+p.lng+')"><span style="color:#00c;text-decoration:underline">' + results.getPoi(i).title.replace(new RegExp(results.keyword,"g"),'<b>' + results.keyword + '</b>') + '</span></a>';
						//rhtm+='<span style="color:#666;"> - ' + results.getPoi(i).address + '</span>';
						rhtm+='</li>';	          
        }
        rhtm+='</ol>';
        document.getElementById("results").innerHTML =rhtm;
    }
  }
};
var local = new BMap.LocalSearch(map, options);
function GetFromAddress(s){	
	$('#results').show();
	$('#apDiv1').css('z-index','1');
	local.search(s);
}
function showMarker(lat,lng){
	$('#results').hide();
	var po=new BMap.Point(lng,lat);
	map.clearOverlays();
	addMarker(po,0);
	map.panTo(po);
  returnVal(lat,lng);
}

function addMarker(point, index){  
	var myIcon = new BMap.Icon("/images/markers_default.png", new BMap.Size(23, 25));
  var marker = new BMap.Marker(point, {icon: myIcon});
  map.addOverlay(marker);
}
function returnVal(lat,lng){
  var opener = window.parent;
	opener.document.getElementById('MLat').value=lat;
	opener.document.getElementById('MLng').value =lng;		
  alert('成功标注!');
  opener.CloseFrame();	
}  
if(_lng>0 && _lat>0){
  addMarker(new BMap.Point(_lng,_lat),0);
}
//-->
</script>
    </form>
</body>
</html>
