$(document).ready(function(){
	/****************************** 公共模块 ******************************/
	/********** 弹出框 **********/
	$.dialog = {
		open: function(options){
			this.options = {
				width: '90%', 
				height: 'auto', 
				title: '温馨提示', 
				content: '', 
				modal: true, 
				resizable: false, 
				is_url: false, 
				buttons: {
					'确认': function(){
						$(this).dialog('close');
					}
				}
			};
			
			options = $.extend(this.options, options);
			
			var callback = function(data){$("#dialog-modal").html(data);};
			
			$('#dialog-modal').html('<img src="/static/common_pc/images/loading.gif" width="31" height="31" alt="加载" />');
			
			$('#dialog-modal').dialog({
				modal: options.modal, 
				resizable: options.resizable, 
				bgiframe: true, 
				width: options.width, 
				height: options.height, 
				title: options.title, 
				buttons: options.buttons, 
				closeOnEscape: options.closeOnEscape,
				draggable: false
			});
			
			if(options.is_url) $.ajax({
				url: options.content, 
				success: function(html){callback(html);}
			});
			else callback(options.content);
			
			return false;
		}
	};
	/****************************** 公共模块 结束 ******************************/
	
	
	/****************************** 通用模块 ******************************/
	/********** 通用函数 模块内容输入 (参数：方式, 文字, 对象) **********/
	$.Public_Function_Input = function(type, text, obj)
	{
		var val = $(obj).attr('value');
		if(type && type == 10)
		{
			if(val == text) $(obj).attr('value', '');
			$(obj).addClass('hover');
		}
		else
		{
			if(val == '') $(obj).attr('value', text);
			$(obj).removeClass('hover');
		};
	};
	
	
	/********** 通用函数 模块内容搜索 (参数：链接, 对象) **********/
	$.Public_Function_Search = function(lnk, obj)
	{
		if(!lnk) return false;
		
		var val = $(obj).parents('.search').find('.txt').val();
		if(val) window.location.href = lnk + val;
	};
	
	
	/********** 通用函数 暂无图片 (参数：对象, 链接) **********/
	$.Public_Function_Nopic = function(obj, lnk)
	{
		$(obj).each(function(){
			if(!$(this).attr('src')) $(this).attr('src', lnk);
		});
	};
	
	
	/********** 通用函数 模块特效触摸 (参数：方式, 对象) **********/
	$.Public_Function_Touch = function(type, obj)
	{
		if(type && type == 10) $(obj).addClass('hover');
		else $(obj).removeClass('hover');
	};
	
	
	/********** 通用函数 模块点击隐现 (参数：对象) **********/
	$.Public_Function_Toggle = function(obj)
	{
		$(obj).toggle();
	};
	
	
	/********** 通用函数 模块数值初始化 参数：(方式, 数值, 对象, 演示对象) **********/
	$.Public_Function_Initial = function(type, i, obj, demo)
	{
		if(type && type == 10)
		{
			if(i && i > 0) $(obj).find(demo).css({'width':$(obj).parent().width() / i});
			
			var w = 0;
			$(obj).find(demo).each(function(){
				w += $(this).outerWidth();
			});
			$(obj).css({'width':w + 'px'});
		}
		if(type && type == 11)
		{
			var s = $(obj).parent().width();
			var w = 0;
			$(obj).find(demo).each(function(){
				w += $(this).outerWidth();
			});
			if(w <= s) return false;
			
			var i = $(obj).find('.hover').index();
			if(i < 2) return false;
			
			var l = 0;
			for(var x = 0; x < i - 1; x ++){ l -= $(obj).find(demo).eq(x).outerWidth();}
			if(l < s - w) l = s - w;
			
			$(obj).css({'transform':'-moz-translate(' + l + 'px, 0px) scale(1) translateZ(0px)', '-webkit-transform':'translate(' + l + 'px, 0px) scale(1) translateZ(0px)', 'transform':'translate(' + l + 'px, 0px) scale(1) translateZ(0px)'});
		}
		else if(type && type == 20)
		{
			var h = $(window).height() > $('body').height() ? $(window).height(): $('body').height();
			$(obj).css({'height':h});
		}
		else if(type && type == 21)
		{
			var h = $(window).height() - i;
			$(obj).css({'min-height':h});
			if(!i) $(demo).css({'height':$(obj).height()});
		}
		else
		{
			var w = $(obj).width();
			$(obj).find(demo).each(function(){
				var w_demo = $(this).width();
				if(w_demo > w) $(this).css({'width':'100%', 'height':'auto'});
			});
		};
	};
	
	
	/********** 通用函数 模块左右移动 (参数：对象, 插件) **********/
	$.Public_Function_Move = function(obj, plugin)
	{
		var w = $(obj).find('.lnk').width();
		var s = $(obj).find('.lnk a').width() * $(obj).find('.lnk a').size();
		var l = parseInt($(obj).find('.lnk .act').attr('rel'));
		
		
		$(obj).find('.lnk .act').attr({'rel':l}).stop().animate({'left':l}, 250, function(){
			if(plugin && plugin == 10) $.Public_Plugin_Display(w, s, l, obj, 'i.shouye');  // 通用插件调用 导航按钮隐现
		});
	};
	
	// 通用插件 模块隐现 (参数：单位宽度, 单位数量, 位移, 对象, 演示对象)
	$.Public_Plugin_Display = function(w, s, l, obj, demo, demoa)
	{
		if(l == 0) $(obj).find(demo).parent().show().next().hide();
		else $(obj).find(demo).parent().hide().next().show();
	};
	
	
	/********** 通用函数 模块空间定位 (参数：方式, 顶部间距, 对象) **********/
	$.Public_Function_Absolute = function(type, top, obj)
	{
		var t = document.documentElement.scrollTop || document.body.scrollTop;
		if(type && type == 10)
		{
			if(t == top) $(obj).show();
			else $(obj).hide();
		}
		else $(obj).css({'margin-top':top + t});
	};
	
	
	/********** 通用函数 模块点击看大图 (参数：方式, 字符串, 对象, 演示对象) **********/
	$.Public_Function_Img = function(type, str, obj, demo)
	{
		if(type && type == 10)
		{
			var src = $(demo).attr('src').replace(/_big.jpg/ig, '');
			if($(obj).length == 0) $('body').append(str.replace(/src=""/ig, 'src=" ' + src + ' "'));
			else $(obj).show().find('img').attr('src', src);
			
			var h = $(window).height();
			$(obj).css({'height':h + 'px', 'line-height':h + 'px'});
		}
		else $(obj).hide();
	};
	/****************************** 通用模块 结束 ******************************/
});