﻿<%@ webhandler Language="C#" class="Upload" %>

/**
 * KindEditor ASP.NET
 *
 * 本ASP.NET程序是演示程序，建议不要直接在实际项目中使用。
 * 如果您确定直接使用本程序，使用之前请仔细确认相关安全设置。
 *
 */

using System;
using System.Collections;
using System.Web;
using System.IO;
using System.Globalization;
using LitJson;

public class Upload : IHttpHandler
{
	private HttpContext context;

	public void ProcessRequest(HttpContext context)
	{
		String aspxUrl = context.Request.Path.Substring(0, context.Request.Path.LastIndexOf("/") + 1);
		
		//文件保存目录路径
        String savePath = "../../../attached/";
        
        

		//文件保存目录URL
        String saveUrl = context.Application["domainName"].ToString() + "attached/";

		//定义允许上传的文件扩展名
		Hashtable extTable = new Hashtable();
		extTable.Add("image", "gif,jpg,jpeg,png,bmp");
		extTable.Add("flash", "swf,flv");
		extTable.Add("media", "swf,flv,mp3,wav,wma,wmv,mid,avi,mpg,asf,rm,rmvb");
		extTable.Add("file", "doc,docx,xls,xlsx,ppt,htm,html,txt,zip,rar,gz,bz2");

		//最大文件大小
		int maxSize = 1000000;
		this.context = context;

		HttpPostedFile imgFile = context.Request.Files["imgFile"];
		if (imgFile == null)
		{
			showError("请选择文件。");
		}

		String dirPath = context.Server.MapPath(savePath);
		if (!Directory.Exists(dirPath))
		{
			showError("上传目录不存在。");
		}

		String dirName = context.Request.QueryString["dir"];
		if (String.IsNullOrEmpty(dirName)) {
			dirName = "image";
		}
		if (!extTable.ContainsKey(dirName)) {
			showError("目录名不正确。");
		}

		String fileName = imgFile.FileName;
		String fileExt = Path.GetExtension(fileName).ToLower();

		if (imgFile.InputStream == null || imgFile.InputStream.Length > maxSize)
		{
			showError("上传文件大小超过限制。");
		}

		if (String.IsNullOrEmpty(fileExt) || Array.IndexOf(((String)extTable[dirName]).Split(','), fileExt.Substring(1).ToLower()) == -1)
		{
			showError("上传文件扩展名是不允许的扩展名。\n只允许" + ((String)extTable[dirName]) + "格式。");
		}

		//创建文件夹
		dirPath += dirName + "/";
		saveUrl += dirName + "/";
		if (!Directory.Exists(dirPath)) {
			Directory.CreateDirectory(dirPath);
		}

		String newFileName = DateTime.Now.ToString("yyyyMMddHHmmss_ffff", DateTimeFormatInfo.InvariantInfo) + fileExt;
        String filePath = dirPath + newFileName;

		imgFile.SaveAs(filePath);
        if (fileExt.ToLower() == ".jpg")
        {
            if (!Directory.Exists(dirPath + "78_62/"))
                Directory.CreateDirectory(dirPath + "78_62/");
            if (!Directory.Exists(dirPath + "158_126/"))
                Directory.CreateDirectory(dirPath + "158_126/");
            if (!Directory.Exists(dirPath + "188_150/"))
                Directory.CreateDirectory(dirPath + "188_150/");
            if (!Directory.Exists(dirPath + "230_184/"))
                Directory.CreateDirectory(dirPath + "230_184/");
            if (!Directory.Exists(dirPath + "260_208/"))
                Directory.CreateDirectory(dirPath + "260_208/");
            String filePath2 = dirPath + "78_62/" + newFileName;
            ImageThumbnail img = new ImageThumbnail();
            img.ThumbnailImage(filePath, filePath2, 78, 62);
            filePath2 = dirPath + "158_126/" + newFileName;
            img.ThumbnailImage(filePath, filePath2, 158, 126);
            filePath2 = dirPath + "188_150/" + newFileName;
            img.ThumbnailImage(filePath, filePath2, 188, 150);
            filePath2 = dirPath + "230_184/" + newFileName;
            img.ThumbnailImage(filePath, filePath2, 230, 184);
            filePath2 = dirPath + "260_208/" + newFileName;
            img.ThumbnailImage(filePath, filePath2, 260, 208);             
        }

		String fileUrl = saveUrl + newFileName;

		Hashtable hash = new Hashtable();
		hash["error"] = 0;
		hash["url"] = fileUrl;
		context.Response.AddHeader("Content-Type", "text/html; charset=UTF-8");
		context.Response.Write(JsonMapper.ToJson(hash));
		context.Response.End();
	}

	private void showError(string message)
	{
		Hashtable hash = new Hashtable();
		hash["error"] = 1;
		hash["message"] = message;
		context.Response.AddHeader("Content-Type", "text/html; charset=UTF-8");
		context.Response.Write(JsonMapper.ToJson(hash));
		context.Response.End();
	}

	public bool IsReusable
	{
		get
		{
			return true;
		}
	}
}
