﻿if(typeof GoogleMap === 'undefined'){
	var GoogleMap = {};
}

if(typeof ErrorAlert === 'undefined'){
	var ErrorAlert = "对不起, 我们解析不到该餐厅的经纬度坐标！\n如果您知道该餐厅的准确位置，您可以使用“我要标注”，帮助我们该给该餐厅定位。";
}

function getXmlHttpRequestMap()
    {
        var xmlHttp = null;
        try
        {
            xmlHttp = new ActiveXObject("Msxml2.XMLHTTP");
        }
        catch(e)
        {
            try
            {
                xmlHttp = new ActiveXObject("microsoft.XMLHTTP");
            }
            catch(oc)
            {
                xmlHttp = null;
            }
        }
        if(!xmlHttp && typeof XMLHttpRequest != "undefined")
        {
            xmlHttp = new XMLHttpRequest();
        }
        return xmlHttp;
    }

(function(){
	if (!document.getElementById("map-cnt")) {
		return false;
	}
	else {
		
		// 是否可创建Google地图控件
		var isCompatible = new GBrowserIsCompatible();
		if (isCompatible) {
			var mapContainer = document.getElementById("map-cnt");
			// 创建GoogleMAP地图实例
			var map = new GMap2(mapContainer);
			// 地图默认的比例尺级别
			var perviewLevel = 14; 
			// 大的地图缩放级别控件
			var largeMapControl = null;
			if(isshowLevel != null && isshowLevel == 1)
			{
				largeMapControl = new GLargeMapControl(); 
			}
			// 地图缩略图控件
			var overviewMapControl = null;
			if(isshowOverviewMap != null && isshowOverviewMap == 1)
			{
				overviewMapControl = new GOverviewMapControl(); 
			}
			// 比例尺控件
			var scaleControl = null;
			if(isshowScale != null && isshowScale == 1)
			{
				scaleControl = new GScaleControl(); 
			}
			// 地图类形选择控件
			var mapTypeControl = null;
			if(isshowMapType != null && isshowMapType == 1)
			{
				mapTypeControl = new GMapTypeControl(); 
			}
			// 地址-坐标转换器
			var geocoder = new GClientGeocoder();
			var geoCode = geocoder;
			// 上一次的查询地址
			var lastAddress = '';
			// 上一次的查询坐标
			var lastPoint = null;
			// 最后一个创建的标记控件
			var lastMarker = null;
			// 用户标记的最后一个坐标点
			var cusLastPoint = null; 
			
			GoogleMap.mapMsg = [];
			
			// 创建地图
			GoogleMap.Map = function(lat, lng){
				var point = new GLatLng(lat, lng);        
				map.addMapType(G_PHYSICAL_MAP);
				map.setCenter(point, perviewLevel);
				
				map.enableDoubleClickZoom();
				map.enableScrollWheelZoom();
				//map.enableContinuousZoom();
				
				if(largeMapControl != null )
				{ 	
					map.addControl(largeMapControl) ; 
				}
				if(overviewMapControl != null )
				{ 	
					map.addControl(overviewMapControl);
				}
				if(mapTypeControl != null )
				{ 	
					map.addControl(mapTypeControl);
				}
				if(scaleControl != null )
				{ 	
					map.addControl(scaleControl);
				}
			};
			
			
			// 创建标记
			GoogleMap.createMarker = function(latlng, markerOptions){
				var marker = markerOptions ? new GMarker(latlng, markerOptions) : new GMarker(latlng);
				lastMarker = marker;
				return marker;
			};
			
			var gdir;
			gdir = new GDirections(map, document.getElementById("directions"));
			GEvent.addListener(gdir, "error", GoogleMap.handleErrors);
			
			GoogleMap.handleErrors = function (){
				return;
		     var status = gdir.getStatus();
		      switch(status.code) {
		        case G_GEO_BAD_REQUEST :
		          alert("路线规划查询条件设定有误");
		          break;
		        case G_GEO_SERVER_ERROR :
		          alert("服务器不能正确解析你输入的地址");
		          break;
		        case G_GEO_MISSING_QUERY :
		        case G_GEO_MISSING_ADDRESS :
		          alert("查询条件（地址）不能为空");
		          break;
		        case G_GEO_UNKNOWN_ADDRESS :
		          alert("查询地址未知");
		          break;
		        case G_GEO_UNAVAILABLE_ADDRESS :
		          alert("因当地法律或其他原因不能解析给出地址");
		          break;
		        case G_GEO_UNKNOWN_DIRECTIONS :
		          alert("给出的两地之间无路可走或我们的现有的数据中缺少路线规划路线");
		          break;
		        case G_GEO_BAD_KEY :
		          alert("导入类库是指定的密钥有误");
		          break;
		        case G_GEO_TOO_MANY_QUERIES :
		          alert("查询太过频繁，超出密钥允许的查询次数");
		          break;
		      }
		  };
		  
		      GoogleMap.setDirections = function(fromAddress, toAddress) {
      			gdir.load("from: " + fromAddress + " to: " + toAddress);
   			 };
   			 
   			 //驾车路线
			GoogleMap.startGeoCoderService = function(fromAddress, toAddress)
			{
				//var fromAddress="上海市"+document.getElementById("fromAddress").value;
				//解析起点位置
				geoCode.getLatLng(fromAddress,
					function(point) {
						if (!point) {
							//alert("无法解析:" + fromAddress);
						}
						startPoint=point;
			            GoogleMap.EndGeoCoderService(fromAddress,toAddress)				
					}
				);
			};

			GoogleMap.EndGeoCoderService = function(fromAddress, toAddress)
			{
				//var toAddress="上海市"+document.getElementById("toAddress").value;
				//var toAddress="上海市" + tempResAddress ;
				//解析终点位置并绘制驾车路线
				geoCode.getLatLng(toAddress,
					function(point) {
						if (!point) {
							//alert("无法解析:" + toAddress);
						}
						endPoint=point;
						gdir.load("from: " + startPoint + " to: " + endPoint);
					}
				);
			};
			
			// 自定义标记选项
			/* =========================================================================================================================================================================================
			   参数说明：
			   常数：G_DEFAULT_ICON 	标记使用的默认图标。
			   image 	            String 	图标的前景图像 URL。
               shadow 	            String 	图标的阴影图像 URL。
               iconSize 	        GSize 	图标前景图像的像素大小。
               shadowSize 	        GSize 	阴影图像的像素大小。
               iconAnchor 	        GPoint 	此图标在地图上的锚定点相对于图标图像左上角的像素坐标。
               infoWindowAnchor 	GPoint 	信息窗口在此图标上的锚定点相对于图标图像左上角的像素坐标。
               printImage 	        String 	打印地图所用的前景图标图像的 URL。其大小必须与 image 提供的主图标图像的大小相同。
               mozPrintImage 	    String 	用 Firefox/Mozilla 打印地图时所用的前景图标图像的 URL。其大小必须与 image 提供的主图标图像的大小相同。
               printShadow 	        String 	打印地图时所用的阴影图像的 URL。由于大多数浏览器都无法打印 PNG 图像，所以图像格式应该为 GIF。
               transparent 	        String 	在 Internet Explorer 中捕获点击事件时，所用的透明前景图标图像的 URL。此图像应是具有 1% 不透明性的 24 位 PNG 格式的主图标图像，但其大小和形状同主图标相同。
               imageMap             Array of Number  表示图像地图 x/y 坐标的整数数组，用它指定浏览器（非 Internet Explorer）中图标图像的可点击部分。
               maxHeight 	        Integer 指定拖动标记时视觉上垂直“上升”的距离（以像素表示）。（自 2.79 开始）
               dragCrossImage 	    String 	指定拖动图标时十字交叉图像的 URL。（自 2.79 开始）
               dragCrossSize 	    GSize 	指定拖动图标时十字交叉图像的像素大小。（自 2.79 开始）
               dragCrossAnchor 	    GPoint 	指定拖动图标时十字交叉图像的像素坐标偏移量（相对于 iconAnchor）。（自 2.79 开始）
			========================================================================================================================================================================================= */
			GoogleMap.setCustomIcon = function(IconOptions){
				var myIcon = new GIcon(G_DEFAULT_ICON), i;
				for (i in IconOptions) {
					switch (i) {
						case 'iconSize':
						case 'shadowSize':
						case 'dragCrossSize':
							myIcon[i] = new GSize(IconOptions[i][0], IconOptions[i][1]);
							break;
						case 'iconAnchor':	
						case 'infoWindowAnchor':
						case 'infoShadowAnchor':
						case 'dragCrossAnchor':
							myIcon.iconAnchor = new GPoint(IconOptions[i][0], IconOptions[i][1]);
                            break;
						default:
							myIcon[i] = IconOptions[i];
							break;
					}	
					
				}	
				return myIcon;
			};
			// 用户自定义标注
			GoogleMap.customMarkPoint = function(){
				var marker = null;
				var markPoint = cusLastPoint ? new GLatLng(cusLastPoint[0],cusLastPoint[1]) : new GLatLng(lastPoint[0],lastPoint[1]);
				var markOptions = {
					icon: GoogleMap.setCustomIcon({
						image: Gurl + 'img/icon13.png'
					}),
					draggable: true
				};
				
				marker = GoogleMap.createMarker(markPoint, markOptions);
				GEvent.addListener(marker, "dragstart", function(){
					map.closeInfoWindow();
				});
				GEvent.addListener(marker, "dragend", function(){
					var custPoint = marker.getPoint();
					var markTip = '<div class="fgmap_markerMsg" id="cusMarkTip">';
					markTip += '<h4>用户地图标注</h4>';
					markTip += '<div id="mapTips"><p>当前经纬度：(' + custPoint.lat() + ',' + custPoint.lng() + ')<br />';
					markTip += '是否将新位置设置为此商户的默认位置？</p>';
					markTip += '<div class="MDB" style="text-align:center;"><button id="MapOK" onclick="GoogleMap.MapOk()"> 确 认 </button>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<button id="MapCancel" onclick="GoogleMap.MapCancel()"> 取 消 </button></div></div></div>';
					marker.openInfoWindowHtml(markTip);
				});
				map.addOverlay(marker);
			};
			
			// 保存用户自定义坐标
			GoogleMap.MapOk = function(){
				var savedPoint = lastMarker.getPoint();
				var lat = savedPoint.lat(), lng = savedPoint.lng();
				var markTip = document.getElementById('cusMarkTip');
				markTip.innerHTML = '<h4>正在上传您所保存的坐标信息...</h4>';
				
				//AJAX提交坐标
				var rid = document.getElementById("txtResid").value;
				var rname = document.getElementById("txtResname").value;
				var url = Gurl + "adentity/doajax.aspx";
				var par = "resid="+escape(rid)+"&resname="+escape(rname)+"&lat="+lat+"&lng="+lng;
				var Xttp = getXmlHttpRequestMap();
				Xttp.open("POST",url,true);
				Xttp.setRequestHeader("Method","POST "+url+" HTTP/1.1");
                Xttp.setRequestHeader("Content-type","application/x-www-form-urlencoded");
                Xttp.onreadystatechange = function(){
                    if (Xttp.readyState == 4){
			            if (Xttp.status==200){
				            var responsetext = Xttp.responseText;
				            if(responsetext == 1)
				            {
				                map.clearOverlays();
					            var marker = GoogleMap.createMarker(savedPoint);
					            if (GoogleMap.mapMsg) {
						            GEvent.addListener(marker, "click", function(){
							            var msg = '<span class="fgmap_markerMsg">', j;
							            msg += '<h4>' + GoogleMap.mapMsg[1][0] + '</h4>';
							            for (var j = 1; j < GoogleMap.mapMsg[1].length; j++) {
								            msg += GoogleMap.mapMsg[1][j] + "<br />";
							            }
							            msg += "</span>";
							            map.openInfoWindowHtml(savedPoint, msg);
						            });
					            }
					            map.addOverlay(marker);
					            map.setCenter(savedPoint);
				                cusLastPoint = [lat,lng];
				                alert("保存成功!");
				            }
				            else
				            {
				                alert("保存失败,请稍后再试");
				            }
        				    
			            }
		            }else{

		            }
                };
                Xttp.send(par);
				//lat 纬度 lng 经度
				
				//提交成功
				/*
				function(){
					map.clearOverlays();
					var marker = GoogleMap.createMarker(savedPoint);
					if (GoogleMap.mapMsg) {
						GEvent.addListener(marker, "click", function(){
							var msg = '<span class="fgmap_markerMsg">', j;
							msg += '<h4>' + GoogleMap.mapMsg[1][0] + '</h4>';
							for (var j = 1; j < GoogleMap.mapMsg[1].length; j++) {
								msg += GoogleMap.mapMsg[1][j] + "<br />";
							}
							msg += "</span>";
							map.openInfoWindowHtml(savedPoint, msg);
						});
					}
					map.addOverlay(marker);
					map.setCenter(savedPoint);
				    cusLastPoint = [lat,lng];
				}*/
			};
			
			// 取消用户自定义坐标操作
			GoogleMap.MapCancel = function(){
				map.removeOverlay(lastMarker);
				map.closeInfoWindow();
			};
			
			// 通过地址获得坐标
			GoogleMap.getAddresslatlng = function(response){
				var place = response.Placemark[0];
				var point = new GLatLng(place.Point.coordinates[1], place.Point.coordinates[0]);
				return [place.Point.coordinates[1], place.Point.coordinates[0], point, place];
			};
			
		    // 标注坐标和相应的说明信息
			GoogleMap.MarkerMap = function(lat, lng){
				var marker = null;
				var point = new GLatLng(lat, lng); 
				GoogleMap.Map(lat, lng);
				
				marker = this.createMarker(point);
				if (GoogleMap.mapMsg) {
					 if(GoogleMap.mapMsg[1] != null && GoogleMap.mapMsg[1].length > 0 )
					{
						GEvent.addListener(marker, "click", function(){
								var msg = '<span class="fgmap_markerMsg">', j;
								msg += '<h4>' + GoogleMap.mapMsg[1][0] + '</h4>';
								for (var j = 1; j < GoogleMap.mapMsg[1].length; j++) {
									msg += GoogleMap.mapMsg[1][j] + "<br />";
								}
								msg += "</span>";
								map.openInfoWindowHtml(point, msg);
						});
					}
				}
				map.addOverlay(marker);
			};
			
			GoogleMap.ShowMapInfo = function(lat, lng){
				var point = new GLatLng(lat, lng);
				if (GoogleMap.mapMsg) {
					 if(GoogleMap.mapMsg[1] != null && GoogleMap.mapMsg[1].length > 0 )
					{
						var msg = '<span class="fgmap_markerMsg">', j;
						msg += '<h4>' + GoogleMap.mapMsg[1][0] + '</h4>';
						for (var j = 1; j < GoogleMap.mapMsg[1].length; j++) {
							msg += GoogleMap.mapMsg[1][j] + "<br />";
						}
						msg += "</span>";
						map.openInfoWindowHtml(point, msg);
					}
				}
			};
			
			// 将查询地址添加到地图
			GoogleMap.addAddressToMap = function(response){
				map.clearOverlays();
				if (!response || response.Status.code != 200) {
					 if(ErrorAlert)alert(ErrorAlert);
            GoogleMap.showLocation(['31.2243531','121.4759159']);
				}
				else {
					var marker = null, point = GoogleMap.getAddresslatlng(response);
					var address = point[3].address, lat = point[0], lng = point[1];

					GoogleMap.mapMsg = (GoogleMap.mapMsg !== '' && (lastAddress === GoogleMap.mapMsg[0])) ? GoogleMap.mapMsg : [address, [point[3].address, ('经度：' + point[1]), ('纬度：' + point[0])]];
					GoogleMap.MarkerMap(lat, lng);
					lastPoint = [lat,lng];
				}
			};
			
			// 将查询坐标添加到地图
			GoogleMap.addPointToMap = function(cPoint){
				map.clearOverlays();
				var marker = null, lat = cPoint[0], lng = cPoint[1];
				GoogleMap.MarkerMap(lat, lng);
				lastPoint = [lat,lng];
			};
			
			// 通过地址/坐标将Marker显示到地图上
			GoogleMap.showLocation = function(cPoint){
				if (typeof cPoint === 'string') {
					geocoder.getLocations(cPoint, this.addAddressToMap);
					lastAddress = cPoint;
				}
				else{
					GoogleMap.addPointToMap(cPoint);
				}
			};
			
			GEvent.addListener(window, 'unload', GUnload);
		}
		else {
			alert("对不起，您的浏览器不支持创建地图！");
		}
	}
})();