﻿<%@ control language="C#" autoeventwireup="true" inherits="Controls_Member_UserInfoUpdate, DoodiiShop" %>
<link rel="Stylesheet" type="text/css" href="/js/jquery-calendar/jquery-calendar.css" />
<script type="text/javascript" src="/js/jquery.js"></script>
<script type="text/javascript" src="/js/jquery-calendar/jquery-calendar.js"></script>
<script type="text/javascript" src="/js/Format.js"></script>

<script type="text/javascript">
    $(document).ready( function(){ init() });
    
    var init = function() {
        bindEvents();
        var date = new Date();
        $("#tbBirthday").val((date.getFullYear()-35) + "-1-1");
        $("#tbBirthday").calendar();
        getRegionList();
    }
    
    var bindEvents = function() {
        $("#tbMobile").bind("blur", function(){ validateMobile() });
        $("#tbPhone").bind("focus", function(){ resetMessage($("#lblPhoneMessage").get(0), "格式如：010-12345678。") });
        $("#tbPhone").bind("blur", function(){ validatePhone() });
        $("#ddlRegion").bind("change", function(){ getZoneList() });
        $("#ddlZone").bind("change", function(){ getAreaList() });
        $("#ddlArea").bind("change", function(){ $("#tbOtherArea").val(""); $("#tbOtherArea").hide(); });
        //$("#tbOtherArea").bind("click", function(){ $("#ddlArea").val(0) });
        
        $("#btnSubmit").bind("click", function(){ saveForm() });
    }
    
    var resetMessage = function( objDom, Message ) {
        $(objDom).removeAttr("class");
        $(objDom).html( Message );
    }
    
    var setRightMessage = function( objDom ) {
        $(objDom).attr("class", "MessageRight");
        $(objDom).html( "√" );
    }
    
    var setErrorMessage = function( objDom, Message ) {
        $(objDom).attr("class", "MessageError");
        $(objDom).html( Message );
    }
    
   
    var validateMobile = function()
    {
        if ( $("#tbMobile").val() == "" )
        {
            $("#lblMobileMessage").html("");
            return true;
        }
        var reg = /^1\d{10}$/;
        if ( reg.exec( $("#tbMobile").val() ) )
        {
            setRightMessage( document.getElementById("lblMobileMessage") );
            return true;
        }
        else
        {
            setErrorMessage( document.getElementById("lblMobileMessage"), "格式填写有误！" );
            return false;
        }
    }
    
    var validatePhone = function()
    {
        if ( $("#tbPhone").val() == "" )
        {
            $("#lblPhoneMessage").html("");
            return true;
        }
        var reg = /^(([0\+]\d{2,3}-)?(0\d{2,3})-)?(\d{7,8})(-(\d{1,}))?$/;
        if ( reg.exec( $("#tbPhone").val() ) )
        {
            setRightMessage( document.getElementById("lblPhoneMessage") );
            return true;
        }
        else
        {
            setErrorMessage( document.getElementById("lblPhoneMessage"), "格式填写有误！" );
            return false;
        }
    }
    
    var validateRegions = function()
    {
        var _oRegionsMessage = document.getElementById("lblRegionsMessage");
        var _RegionId = parseInt($("#ddlRegion").val());
        var _ZoneId = parseInt($("#ddlZone").val());
        var _AreaId = parseInt($("#ddlArea").val());
        var _OtherArea = $("#tbOtherArea").val().trim();
        var _Address = $("#tbAddress").val().trim();
            if (_RegionId == 0)
            {
                setErrorMessage(_oRegionsMessage, "请选择地区！");
                return false;
            }
            if (_ZoneId == 0)
            {
                setErrorMessage(_oRegionsMessage, "请选择片区！");
                return false;
            }
            if (_AreaId == 0 && _OtherArea == "")
            {
                setErrorMessage(_oRegionsMessage, "请选择或填写楼宇！");
                return false;
            }
            if (_Address == "")
            {
                setErrorMessage(_oRegionsMessage, "请填写楼层、房间号！");
                return false;
            }
            resetMessage(_oRegionsMessage, "");
            return true;
    }
    
   
    var getRegionList = function() {
        document.body.focus();
        var CityId = <%=userCityID %>;
        var dt = Controls_Member_UserInfoUpdate.GetRegionList( CityId ).value;
        ddlRemove("ddlRegion");
        ddlAdd( "ddlRegion", "地区", 0);
        if ( dt != null && typeof(dt) == "object" ) {
            for ( var i=0; i<dt.Rows.length; i++ ) {
                ddlAdd( "ddlRegion", dt.Rows[i].name, dt.Rows[i].id );
            }
        }
        getZoneList();
    }
    
    var getZoneList = function() {
        document.body.focus();
        var RegionId = parseInt( $("#ddlRegion").val() );
        var dt = Controls_Member_UserInfoUpdate.GetZoneList( RegionId ).value;
        ddlRemove( "ddlZone");
        ddlAdd( "ddlZone", "片区", 0 );
        if ( dt != null && typeof(dt) == "object" ) {
            for ( var i=0; i<dt.Rows.length; i++ ) {
                ddlAdd( "ddlZone", dt.Rows[i].name, dt.Rows[i].id );
            }
        }
        getAreaList();
    }
    
    var getAreaList = function() {
        document.body.focus();
        var ZoneId = parseInt( $("#ddlZone").val() );
        var dt = Controls_Member_UserInfoUpdate.GetAreaList( ZoneId ).value;
        ddlRemove("ddlArea");
        ddlAdd( "ddlArea", "楼宇", 0 );
        if ( dt != null && typeof(dt) == "object" ) {
            for ( var i=0; i<dt.Rows.length; i++ ) {
                ddlAdd( "ddlArea", dt.Rows[i].name, dt.Rows[i].id );
            }
        }
    }
   
   function ShowOtherArea()
   {
       $("#ddlArea").val(0);
       $("#tbOtherArea").val("");
       $("#ddlArea").hide();
       $("#tbOtherArea").show();
       $("#SelectOtherArea1").hide();
       $("#SelectOtherArea2").show();
   } 
   
   function ShowAreaList()
   {
    $("#tbOtherArea").val("");
    $("#tbOtherArea").hide();
    $("#ddlArea").show();
    $("#SelectOtherArea2").hide();
    $("#SelectOtherArea1").show();
   }
    
    var validateForm = function() {
        var ret = true;
        if ( !validateMobile() ) ret = false;
        if ( !validatePhone() ) ret = false;
        if ( !validateRegions() ) ret = false;
        return ret;
    }
    
    var saveForm = function()
    {
        if ( !validateForm() )
        {
            document.documentElement.scrollTop = 0;
            return;
        }

        var TrueName = $("#tbTrueName").val();
        var BirthdayStr = $("#tbBirthday").val();
        var Mobile = $("#tbMobile").val();
        var Phone = $("#tbPhone").val();
        var QQ = $("#tbQQ").val();
        var MSN = $("#tbMSN").val();
        var RegionId = $("#ddlRegion").val();
        var ZoneId = $("#ddlZone").val();
        var AreaId = $("#ddlArea").val();
        var Address = $("#tbAddress").val();
        var OtherArea = $("#tbOtherArea").val();
        var PrivacyClassId = $("#ddlPrivacyClass").val();
        var ret = Controls_Member_UserInfoUpdate.UserInfoUpdate(TrueName, BirthdayStr, Mobile, Phone, QQ , MSN , RegionId
            , ZoneId, AreaId, Address, OtherArea, PrivacyClassId).value;           
        if ( ret == 0 )
        {
            $("#btnSubmit").attr("disabled", true);
            alert('提交成功！');            
            $("#btnSubmit").attr("disabled", false);
            window.location='/';
        }
        else
        {
            alert(ret);
        }
    }
</script>

<style type="text/css">
<!--
    .STYLE1 {
        color: #FF0000
    }
    .MessageError {
        color:#f00;
    }
    .MessageRight {
        color:#090;
    }
-->
</style>
<div style="color:Red;" >
    <asp:Label ID="lblNickName" runat="server" Text=""></asp:Label>，恭喜您已注册成功
您已经获得豆丁赠送积分：<asp:Label ID="lblRegIntegral" runat="server" Text="" ForeColor="red"></asp:Label>分！
</div>
<hr style="color:Red;" />
<table border="0">  
            <tr>
                <td align="right">
                    <span style="color: #FF0000;">*</span> 送餐地址：</td>
                <td colspan="2">
                    <select id="ddlRegion">
                    </select>
                    <select id="ddlZone">
                    </select>
                </td>
            </tr>
            <tbody style="padding: 3px 0px;">
                <tr style="height: 5px;">
                    <td style="height: 5px;" colspan="3">
                    </td>
                </tr>
                <tr>
                    <td align="right">
                    </td>
                    <td>
                        <select id="ddlArea">
                        </select>
                        <input id="tbOtherArea" type="text" style="display:none" />
                    </td>
                    <td id="SelectOtherArea1" class="KcAttentionFont">
                        如果列表中没有您所在的大厦，请在<a href="javascript:ShowOtherArea();">这里</a>添加。
                    </td>
                    <td id="SelectOtherArea2" class="KcAttentionFont" style="display:none">
                        请输入您所在的楼宇大厦，<a href="javascript:ShowAreaList()">返回楼宇列表</a>
                    </td>
                </tr>
                <tr style="height: 5px;">
                    <td style="height: 5px;" colspan="3">
                    </td>
                </tr>
            </tbody>
            <tr>
                <td align="right">
                </td>
                <td>
                    <input id="tbAddress" type="text" />
                </td>
                <td class="KcAttentionFont">
                    请输入您所在的楼层、房间号和公司名称。</td>
            </tr>
            <tr>
                <td>
                </td>
                <td>
                    <span id="lblRegionsMessage"></span>
                </td>
                <td>
                </td>
            </tr> 
            <tr>
                <td align="right">
                    姓&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;名：</td>
                <td>
                    <input id="tbTrueName" type="text" maxlength="20" />
                </td>
                <td>
                </td>
            </tr>
            <tr>
                <td align="right">
                    生&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;日：</td>
                <td>
                    <input id="tbBirthday" type="text" maxlength="20" value="" readonly />
                </td>
                <td>
                </td>
            </tr>
            <tr>
                <td align="right">
                    手&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;机：</td>
                <td>
                    <input id="tbMobile" type="text" maxlength="15" />
                </td>
                <td>
                    <span id="lblMobileMessage"></span>
                </td>
            </tr>
            <tr>
                <td align="right">
                    固定电话：</td>
                <td>
                    <input id="tbPhone" type="text" maxlength="20" />
                </td>
                <td>
                    <span id="lblPhoneMessage"></span>
                </td>
            </tr>
            <tr>
                <td align="right">
                    QQ：
                </td>
                <td>
                    <input id="tbQQ" type="text" maxlength="50" />
                </td>
                <td class="KcAttentionFont">
                </td>
            </tr>
    <tr>
        <td align="right">
            MSN：</td>
        <td>
            <input id="tbMSN" type="text" maxlength="50" /></td>
        <td class="KcAttentionFont">
        </td>
    </tr>
            <tr>
                <td align="right">
                    资料权限：</td>
                <td>
                    <select id="ddlPrivacyClass">
                        <option value="0">私有</option>
                        <option value="1">仅好友可见</option>
                        <option value="2" selected="selected">公开</option>
                    </select>
                </td>
                <td>
                </td>
            </tr>
            <tr style="height:50px">
                <td align="right">
                    &nbsp;</td>
                <td>                                        
                    <a id="btnSubmit" style="cursor:pointer;">提交信息</a>
                    <a href="javascript:window.location='/'" style="cursor:pointer;">暂不填写</a>
                    </td>
                <td>
                </td>
            </tr>
        </table>