﻿<%@ control language="C#" autoeventwireup="true" inherits="Controls_Rest_Manage_RestOrderPrint, DoodiiShop" %>
<link rel="Stylesheet" type="text/css" href="/js/jquery-tabs/jquery.tabs.css" />
<link rel="Stylesheet" type="text/css" href="/js/jquery-calendar/jquery-calendar.css" />
<link rel="Stylesheet" type="text/css" href="/js/jquery-tabs/jquery.tabs-ie.css" />

<script type="text/javascript" src="/js/jquery-tabs/jquery.tabs.pack.js"></script>

<script type="text/javascript" src="/js/jquery-calendar/jquery-calendar.js"></script>

<script type="text/javascript" src="/js/Format.js"></script>

<script type="text/javascript" src="/js/Lib/PageNavigator.js"></script>

<script type="text/javascript" src="/js/Func.js"></script>

<script type="text/javascript" src="/js/Lib/AreaSelector.js"></script>

<div id="divDemo" runat="server" style="float:left;color: red; font-size: 24px;margin:0px;padding:0px;">    
    <strong>如果您需要申请试用或购买本模块请<a href='http://www.doulaiding.com/buy/' target="_blank">联系我们</a>！</strong><br>
        <img src='/images/Rest/RestOrderPrint.jpg' /> 
</div>
<div id="divContent" runat="server">

    <script type="text/javascript">
    var oNav = null;
    var oOrderInfo = null;
    var gAreaId=0;
    var DeliverAddress_ServiceContact = "";
    var DeliverAddress_objAreaSelector = null;    
    $(document).ready( function(){  init() });
 
    
    function init()
    {
        $("#tbBeginDeliverDate").calendar();
        $("#tbEndDeliverDate").calendar();
        var _Today = new Date();
        var _TodayStr = _Today.getFullYear() + "-" + (_Today.getMonth()+1) + "-" + _Today.getDate();
        $("#tbBeginDeliverDate").val( _TodayStr );
        $("#tbEndDeliverDate").val( _TodayStr );
        oNav = new vensonNav("PageNav", "getOrderList");
        initPositionList();
        $("#btnSearch").attr("disabled", true);
        $("#btnSelectAll").attr("disabled", true);
        $("#btnReverseSelect").attr("disabled", true);
        $("#btnPrintSubmit").attr("disabled", true);
        getRestList();
    }
    
    function initPositionList()
    {
        for (var i = 1; i <= 30; i++)
        {
            ddlAdd("ddlPosition", i, i);
        }
    }
    
    function bindEvents()
    {
        $("#btnSearch").bind("click", function(){ oNav.pageIndex=1;getOrderList() });
        $("#btnSelectAll").bind("click", function(){ selectAll() });
        $("#btnReverseSelect").bind("click", function(){ reverseSelect() });
        $("#ddlPrintType").bind("change", function(){ if (this.value == 3) $("#ddlPosition").val(1); });
        $("#ddlPosition").bind("change", function(){ if ($("#ddlPrintType").val() == 3) this.value=1; });
        $("#btnPrintSubmit").bind("click", function(){ printSubmit() });
        $("#btnSearch").removeAttr("disabled");
        $("#btnSelectAll").removeAttr("disabled");
        $("#btnReverseSelect").removeAttr("disabled");
        $("#btnPrintSubmit").removeAttr("disabled");
    }
    
    function getRestList() {
        var ret = Controls_Rest_Manage_RestOrderPrint.GetRestList().value;
        if ( ret != null && typeof(ret) == "object" ) {
            if ( ret.length == 0 )
            {
                alert("您还没有开设餐馆！");
                return;
            }
            for ( var i=0; i<ret.length; i++ ) {
                ddlAdd("ddlRest", ret[i].Name, ret[i].RestId );
            }
            bindEvents();
            getOrderList();
        }
    }
    function searchOrderByDate()
    {
       $("#ddlState option[@value=-3]").attr("selected", true);
       gAreaId = 0;
       $("#tbAreaName").val("");
       $("#tbOrderId").val("");
     
       getOrderList();
    }
    function searchOrderByRest()
    {
       $("#ddlState option[@value=-3]").attr("selected", true);
       gAreaId = 0;
        $("#tbAreaName").val("");
       $("#tbOrderId").val("");
      
        getOrderList();
    }
    function searchOrderByState()
    {
        gAreaId = 0;
        $("#tbAreaName").val("");
       $("#tbOrderId").val("");
     
        getOrderList();
    }
    function searchOrderByArea()
    {
       $("#tbOrderId").val("");
        getOrderList();
    }
    function getOrderList()
    {
        var _RestId = parseInt($("#ddlRest").val());
        var _State = parseInt($("#ddlState").val());
        var _OrderId = $("#tbOrderId").val();
        var str ="";
        if (_OrderId == "") _OrderId = 0;
        _OrderId = parseInt(_OrderId);
        if (isNaN(_OrderId))
        {
            alert("请填写有效的订单号！");
            return;
        }
        var _BeginDeliverDateStr = $("#tbBeginDeliverDate").val();
        if (_BeginDeliverDateStr == "")
        {
            alert("请选择有效的起始日期！");
            return;
        }
        var _EndDeliverDateStr = $("#tbEndDeliverDate").val();
        if (_EndDeliverDateStr == "")
        {
            alert("请选择有效的截止日期！");
            return;
        }
        
        var ddlRest = document.getElementById("ddlRest");
        var ddlState = document.getElementById("ddlState");
        var restName = ddlRest.options[ddlRest.selectedIndex].text;
        var stateName = ddlState.options[ddlState.selectedIndex].text;
        var timeStr = "日期("+ _BeginDeliverDateStr +"至"+ _EndDeliverDateStr +")";
        var areaName = $("#tbAreaName").val();
        if(_RestId !=0)
        str ="<a href='javascript:searchOrderByRest()'>"+ restName +"</a>";
        str +="&nbsp;\>&nbsp;<a href='javascript:searchOrderByDate()'>"+ timeStr +"</a>";
        if(_State != -3)
        str +="&nbsp;\>&nbsp;<a href='javascript:searchOrderByState()'>"+ stateName +"</a>";
        if(gAreaId !=0)
        str +="&nbsp;\>&nbsp;<a href='javascript:searchOrderByArea()'>"+ areaName +"</a>";
        if(_OrderId !=0)
        str +="&nbsp;\>&nbsp;"+ _OrderId;
        $("#spTop").html(str);
        $("#OrderList").html("");
        var ret = Controls_Rest_Manage_RestOrderPrint.GetOrderList(_RestId, _OrderId, _State, _BeginDeliverDateStr, _EndDeliverDateStr, oNav.pageIndex, 10,gAreaId).value;
        if (ret != null && typeof(ret) == "object")
        {
            if (ret.GeneralOrderInfos.length == 0)
            {
                alert("暂无订单！");
                return;
            }
            oOrderInfo = ret;
            renderOrderList();
        }
        else
        {
            alert("获取订单列表失败！");
        }
    }
    
    function renderOrderList() {
        oNav.render(oOrderInfo.GeneralOrderPageInfo.PageIndex, oOrderInfo.GeneralOrderPageInfo.TotalPage);
        for ( var i=0; i<oOrderInfo.GeneralOrderInfos.length; i++ ) {
            var Item = oOrderInfo.GeneralOrderInfos[i];
            var _OrderId = parseInt( Item.OrderId );
            var _OrderType = parseInt( Item.OrderType );
            var table = document.createElement("table");
            table.className = "NewTable";
            var tr = table.insertRow(-1);
            var th = document.createElement("th");
            th.colSpan = 3;
            th.innerHTML = "<input name='chkOrder' type='checkbox' value='" + _OrderId + ":" + _OrderType + "' />"
            th.innerHTML += "#<strong>" + _OrderId + "</strong>";
            th.innerHTML += "&nbsp;(" + Item.RestName + ")";
            th.innerHTML += "&nbsp;[";
            switch ( Item.State ) {
                case -2 : th.innerHTML += "虚假订单"; break;
                case -1 : th.innerHTML += "已作废"; break;
                case 0 : th.innerHTML += "未处理"; break;
                case 1 : th.innerHTML += "已完成"; break;
                default : th.innerHTML += "未知状态"; break;
            }
            th.innerHTML += "&nbsp;]";
            tr.appendChild( th );
            var th = document.createElement("th");
            th.style.textAlign = "center";
            th.innerHTML = "<a href='javascript:showOrderInfo(" + _OrderId + "," + _OrderType + ")'>客户信息</a>";
            //th.innerHTML += "&nbsp;[&nbsp;<a href='javascript:copyInfo(" + _OrderId + "," + _OrderType + ")'>复制</a>&nbsp;]";
            tr.appendChild( th );
            var tr = table.insertRow(-1);
            var td = tr.insertCell(-1);
            td.className = "htd";
            td.innerHTML = "送餐时间";
            tr.appendChild( td );
            var td = tr.insertCell(-1);
            td.innerHTML = formatDateTimeFromDateStr( Item.DeliverDate, true );
            var td = tr.insertCell(-1);
            td.className = "htd";
            td.innerHTML = "订单金额";
            var td = tr.insertCell(-1);
             var payStr = "<strong>餐费：</strong><span style='color:#05AE1D'>" + formatToMoney(Item.Total) + "</span>元";
            if(Item.DeliveryMoney!="0")
            {
                payStr +="&nbsp;<strong>外送费：</strong><span style='color:#05AE1D'>" + formatToMoney(Item.DeliveryMoney) + "</span>元";
            }
            payStr +="&nbsp;<strong>共计：</strong><span style='color:#05AE1D'>"+formatToMoney(Item.Total+Item.DeliveryMoney)+"</span>元";
           td.innerHTML =payStr;
            var tr = table.insertRow(-1);
            var td = tr.insertCell(-1);
            td.className = "htd";
            td.innerHTML = "客户信息";
            var td = tr.insertCell(-1);
            td.colSpan = 3;
            td.innerHTML = "<strong>联系人：</strong>" + HtmlEncode(Item.Name)
                + "&nbsp;&nbsp;<strong>联络电话：</strong>" + HtmlEncode(Item.Phone)
                + "&nbsp;&nbsp;<strong>下单时间：</strong>" + formatDateTimeFromDateStr(Item.DateTime, true)
                + "<br /><strong>送餐地址：</strong>" + Item.Address;
            var tr = table.insertRow(-1);
            var td = tr.insertCell(-1);
            td.className = "htd";
            td.innerHTML = "餐品内容";
            var td = tr.insertCell(-1);
            td.colSpan = 3;
            td.innerHTML = Item.OrderContent;
            var tr = table.insertRow(-1);
            var td = tr.insertCell(-1);
            td.className = "htd";
            td.innerHTML = "备注";
            var td = tr.insertCell(-1);
            td.colSpan = 3;
            td.innerHTML = Item.Note;
            $("#OrderList").append( table );
            Item = null;
        }
    }
    
    function selectAll()
    {
        $("input[@type=checkbox][@name=chkOrder]").each(
            function(){ $(this).attr("checked", true) }
        );
    }
    
    function reverseSelect()
    {
        $("input[@type=checkbox][@name=chkOrder]").each(
            function(){ $(this).attr("checked", !$(this).attr("checked")) }
        );
    }
    
    function printSubmit()
    {
        if ($("input[@type=checkbox][@name=chkOrder][@checked]").size() == 0)
        {
            alert("请选择要打印的订单！");
            return;
        }
        var _OrderList = "";
        $("input[@type=checkbox][@name=chkOrder][@checked]").each(
            function(){ if (_OrderList != "") _OrderList += "|"; _OrderList += this.value }
        );
        var _PrintType = parseInt($("#ddlPrintType").val());
        var _Position = parseInt($("#ddlPosition").val());
        switch (_PrintType)
        {
            case 1: var url = "RestOrderPrintSubmit1.aspx?Position=" + _Position + "&OrderList=" + _OrderList; break;
            case 2: var url = "RestOrderPrintSubmit2.aspx?Position=" + _Position + "&OrderList=" + _OrderList; break;
            case 3: var url = "RestOrderPrintSubmit3.aspx?OrderList=" + _OrderList; break;
            default: return; break;
        }
        window.open(url, "", "top=0, left=0, width=850, height=680, scrollbars=yes, status=yes");
    }
    
    var showOrderInfo = function( OrderId, OrderType ) {
        var url = "/Rest/Manage/RestOrderInfo.aspx?OrderId=" + OrderId + "&OrderType=" + OrderType;
        window.open( url, "", "width=700, height=400, status=yes, scrollbars=yes");
    }
    
     function RestOrderPrint_showAreaSelector(areaName)
    { 
        popDiv("tbAreaName");
         var RestId = $("#ddlRest").val();
        var BeginDeliverDateStr = $("#tbBeginDeliverDate").val();
        var EndDeliverDateStr =$("#tbEndDeliverDate").val();
        
        var State = $("#ddlState").val();
        if(areaName == null) areaName = "";
        Controls_Rest_Manage_RestOrderPrint.GetAreaOrderList(RestId,State,BeginDeliverDateStr,EndDeliverDateStr,areaName,callBackAreaList);
       
        function callBackAreaList(res)
        {
            var ret = res.value;
            var str = "";
            if(typeof(ret) == "undefined" || ret == null)
            {
                $("#divAreaOrderList").html("没有相关楼宇");
                return;
            }
            else
            {
                var len = ret.Rows.length;
                for(var i = 0;i<len;i++)
                {
                    str +="<li onclick='javascript:SelectArea("+ i +","+ ret.Rows[i].areaid +",\""+ ret.Rows[i].areaname +"\")'>"+ ret.Rows[i].areaname +"<span class='f_import'>["+ ret.Rows[i].orderCount +"笔]</span></li>"
                }
            }
           document.getElementById("divAreaOrderList").innerHTML=str;
        }
        
    }
    function SelectArea(i,areaId,areaName)
    {
        $("#divAreaOrderList>li:eq(" + i + ")").attr("class", "current");
       document.getElementById("tbAreaName").value=areaName;
       gAreaId = areaId;
        selectAreaClose();
        oNav.pageIndex=1;getOrderList();
    }
    function selectByName()
    {
        var areaName = document.getElementById("tbAreaName").value;
        RestOrderPrint_showAreaSelector(areaName);
       if(areaName == "")
       {
         gAreaId = 0; 
       }
      
    }
    function onFocusAreaName()
    {
        if(gAreaId != 0)
        {
            document.getElementById("tbAreaName").value="";
            gAreaId = 0;
            RestOrderPrint_showAreaSelector("");
        }
        else
        {
            selectByName();
        }
    }
     //弹出下拉框
         function popDiv(obj)
        {
            var x = getPosition(obj).x;
            var y = getPosition(obj).y;
            var divHeight = y + 18;
           document.getElementById("divPrintOrderAreaPop").style.display = "";
            $("#divPrintOrderAreaPop").css("top",divHeight);
            $("#divPrintOrderAreaPop").css("left",x);
        }
          var getPosition = function(obj)
        {
            var o = null;
            var height = 0;
            if( typeof obj == 'string')
                o = document.getElementById(obj);
            else
                o = obj;
            var x=y=0;
            do
            { 
                x += o.offsetLeft;
                y += o.offsetTop;
            }while(o = o.offsetParent);
            return{"x":x,"y":y};
        }
         function selectAreaClose()
        {
            $("#divPrintOrderAreaPop").hide();
        }
    </script>

    <style type="text/css">
    .NewTable {
        margin-bottom:10px;
    }
    .NewTable th {
        text-align:left;
        background-color:#f5f7ff;
        font-weight:normal;
        color:#369;
    }
    .NewTable .htd {
        width:80px;
        background-color:#F4F4F4;
    }
    #PageNav
    {
        text-align:right;
        margin:5px;
    }
    #Control
    {
        text-align:center;
        margin:5px;
        padding:5px;
        border-top:1px solid #ccc
    }
        .OrderSumInfo {
        margin-bottom:5px;
        padding:5px;
        border:1px dotted #ccc;
        text-align:left;
        background-color:#F3F3F3;
    }
    .OrderSumInfo .Value {
        font-weight:bold;
        color:#f00;
    }
    
 .suggest2
{
	position:absolute;
	border:1px solid #008c00;
	background-color:#ebffff;
	z-index:999px;
	font-size:12px;
	width:200px;
}

.suggest2 .toolbar
{
	margin:0px;
	padding:2px;
	background-color:#008c00;
	text-align:right;
}

.suggest2 .toolbar a
{
	cursor:pointer;
	color:#fff;
}

.suggest2 ul
{
	list-style-type:none;
	margin:5px;
	padding:5px;
}

.suggest2 li
{
	cursor:pointer;
	border-bottom:1px dotted #ccc;
}

.suggest2 li.current
{
	background-color:#008c00;
	color:#fff;
}
</style>
    <input id="hdShopId" type="hidden" runat="server" />
    <input id="hdServiceContact" type="hidden" runat="server" />
    <div class="Toobar">
        <span>选择餐馆：</span>
        <select id="ddlRest">
        </select>
        <br />
        <br />
        <span>起始日期：</span>
        <input id="tbBeginDeliverDate" type="text" readonly="readonly" style="width: 80px;" />
        <span>截止日期：</span>
        <input id="tbEndDeliverDate" type="text" readonly="readonly" style="width: 80px;" /><br />
        <br />
        <span>订单状态：</span>
        <select id="ddlState">
            <option value="-3">全部</option>
            <option value="-2">虚假</option>
            <option value="-1">作废</option>
            <option value="0">待处理</option>
            <option value="1">已完成</option>
        </select>
        <span>订单号：</span>
        <input id="tbOrderId" type="text" maxlength="10" style="width: 110px;" />
        &nbsp;&nbsp; 有订单的楼宇选择：<input type="text" id="tbAreaName" maxlength="20" onfocus="onFocusAreaName()"
            onkeyup="onFocusAreaName()" />
        <input id="btnSearch" type="button" value="搜索" />
    </div>
    <div class="OrderSumInfo">
        查询条件：<span id="spTop"></span>
    </div>
    <div id="PageNav" style="float: right; margin-bottom: 10px">
    </div>
    <div id="OrderList" style="clear: both">
    </div>
    <br />
    <div id="Control" style="text-align: left">
        打印方式：
        <select id="ddlPrintType">
            <option value="1">单份打印(3*10无边距)</option>
            <option value="2">单份打印(3*9)</option>
            <option value="3">订单打印</option>
        </select>
        <span>起始位置：</span>
        <select id="ddlPosition">
        </select>
        <input id="btnPrintSubmit" type="button" value="打印预览" />
        <input id="btnSelectAll" type="button" value="全选" />
        <input id="btnReverseSelect" type="button" value="反选" />
        <span></span>
    </div>
    <div id="divPrintOrderAreaPop" style="display: none" class="suggest2">
        <div class="toolbar">
            <span style="cursor: pointer; color: White" onclick="selectAreaClose()">[关闭]</span></div>
        <ul id="divAreaOrderList">
        </ul>
    </div>
</div>
