﻿<%@ control language="C#" autoeventwireup="true" inherits="Controls_User_UserModifyBasicInfo, DoodiiShop" %>

<script type="text/javascript" src="/js/jquery-calendar/jquery-calendar.js"></script>

<link rel="Stylesheet" type="text/css" href="/js/jquery-calendar/jquery-calendar.css" />

<script type="text/javascript" language="javascript">
    $(document).ready( function(){ init() });
    
    var init = function() {
         $("#<%=tbBirthday.ClientID%>").calendar();
        $("#<%=tbNickName.ClientID%>").bind("focus", function(){
            resetMessage( document.getElementById("lblNickNameMessage"), "长度为4-16位字符！")} );
        $("#<%=tbNickName.ClientID%>").bind("blur", function(){ validateNickName()} );
        $("#<%=tbMobile.ClientID%>").bind("blur", function(){ validateMobile() } );
        $("#<%=tbPhone.ClientID%>").bind("blur", function(){ validatePhone() } );
        $("#<%=tbMSN.ClientID%>").bind("blur", function(){ validateMSN() } );
        $("#<%=tbQQ.ClientID%>").bind("blur", function(){ validateQQ() } );
        $("#<%=tbNote.ClientID%>").bind("blur", function(){ validateNote() } );
        $("#<%=tbEmail.ClientID%>").bind("blur", function(){ validateEmail() } );
    }
    
    var resetMessage = function( objDom, Message ) {
        $(objDom).removeAttr("class");
        $(objDom).html( Message );
    }
    
    var setRightMessage = function( objDom ) {
        $(objDom).attr("class", "MessageRight");
        $(objDom).html( "√" );
    }
    
    var setErrorMessage = function( objDom, Message ) {
        $(objDom).attr("class", "MessageError");
        $(objDom).html( Message );
    }
    
    var validateNickName = function() {
        var NickName = $("#<%=tbNickName.ClientID%>").val();
        if(NickName.indexOf("@")>=0)
        {
            setErrorMessage(document.getElementById("lblNickNameMessage"), "昵称不能输入@符号" ); 
            return false;
        }
        var ret = Controls_User_UserModifyBasicInfo.CheckNickName( NickName ).value;
        if ( ret == "0" ) {
            setRightMessage( document.getElementById("lblNickNameMessage") );
            return true;
        } else {
            setErrorMessage( document.getElementById("lblNickNameMessage"), ret );
            return false;
        }
    }
    
    var validateMobile = function() {
        if ( $("#<%=tbMobile.ClientID%>").val() == "" ) return true;
        var reg = /^1\d{10}$/;
        if ( reg.exec( $("#<%=tbMobile.ClientID%>").val() ) ) {
            setRightMessage( document.getElementById("lblMobileMessage") );
            return true;
        } else {
            setErrorMessage( document.getElementById("lblMobileMessage"), "格式填写有误！" );
            return false;
        }
    }
    
    var validatePhone = function() {
        if ( $("#<%=tbPhone.ClientID%>").val() == "" ) return true;
        var reg = /^(([0\+]\d{2,3}-)?(0\d{2,3})-)?(\d{7,8})(-(\d{1,}))?$/;
        if ( reg.exec( $("#<%=tbPhone.ClientID%>").val() ) ) {
            setRightMessage( document.getElementById("lblPhoneMessage") );
            return true;
        } else {
            setErrorMessage( document.getElementById("lblPhoneMessage"), "格式填写有误！" );
            return false;
        }
    }
    
    var validateMSN = function() {
        if ( $("#<%=tbMSN.ClientID%>").val() == "" ) return true;
        var reg = /^[\w-]+(\.[\w-]+)*@[\w-]+(\.[\w-]+)+$/;
        if ( reg.exec( $("#<%=tbMSN.ClientID%>").val() ) ) {
            setRightMessage( document.getElementById("lblMSNMessage") );
            return true;
        } else {
            setErrorMessage( document.getElementById("lblMSNMessage"), "格式填写有误！" );
            return false;
        }
    }
    
    var validateQQ = function() {
        if ( $("#<%=tbQQ.ClientID%>").val() == "" ) return true;
        var reg = /^[A-Za-z0-9]+$/;
        if ( reg.exec( $("#<%=tbQQ.ClientID%>").val() ) ) {
            setRightMessage( document.getElementById("lblQQMessage") );
            return true;
        } else {
            setErrorMessage( document.getElementById("lblQQMessage"), "格式填写有误！");
            return false;
        }
    }
    
    var validateEmail =function(){
        var Email = $("#<%=tbEmail.ClientID%>").val();
        if(Email.indexOf(".")==-1||Email.indexOf("@")==-1||Email.indexOf("@")>Email.indexOf("."))
        {
            setErrorMessage( document.getElementById("lblEmailMessage"), "邮箱格式填写有误！" );
            return false;
        }
        else
        {
            setRightMessage( document.getElementById("lblEmailMessage") );
            return true;
        }
    }
    
    var validateNote = function() {
        var str = $("#<%=tbNote.ClientID%>").val();
        if ( str.length == 0 ) return true;
        if ( str.length <= 1024 ) {
            setRightMessage( document.getElementById("lblNoteMessage") );
            return true;
        } else {
            setErrorMessage( document.getElementById("lblNoteMessage"), "长度超出了限制！");
            return false;
        }
    }
    
    var setProvince = function() {
        var ddlProvince = document.getElementById( "<%=ddlProvince.ClientID %>");
        var ddlCity = document.getElementById( "<%=ddlCity.ClientID %>" );
        var dt = Controls_User_UserModifyBasicInfo.GetCity( ddlProvince.value ).value;
        ddlBind( dt, "<%=ddlCity.ClientID%>");
        document.body.focus();
    }
    
    var validateForm = function() {
        if ( !validateNickName() ) return false;
        if ( !validateMobile() ) return false;
        if ( !validatePhone() ) return false;
        if ( !validateMSN() ) return false;
        if ( !validateQQ() ) return false
        if ( !validateNote() ) return false;
        return true;
    }
    
    var saveForm = function() {
        if ( !validateForm() ) return;
        $("#btnSubmit").attr("disabled", true);
        var NickName = $( "#<%=tbNickName.ClientID%>" ).val();
        var SexId = 0;
        if ( $( "#<%=rdoSex1.ClientID%>").attr("checked") ) SexId = 1;
        var ProvinceId = $( "#<%=ddlProvince.ClientID%>").val();
        var CityId = $( "#<%=ddlCity.ClientID%>").val();
        var TrueName = $( "#<%=tbTrueName.ClientID%>").val();
        var BirthdayStr = $("#<%=tbBirthday.ClientID%>").val();
        var Mobile = $( "#<%=tbMobile.ClientID%>").val();
        var Phone = $( "#<%=tbPhone.ClientID%>").val();
        var MSN = $( "#<%=tbMSN.ClientID%>").val();
        var QQ = $( "#<%=tbQQ.ClientID%>").val();
        var Note = $( "#<%=tbNote.ClientID%>").val();
        var PrivacyClassId = $( "#<%=ddlPrivacyClass.ClientID%>").val();
        var Email = $("#<%=tbEmail.ClientID%>").val();
        if(Email.indexOf(".")==-1||Email.indexOf("@")==-1||Email.indexOf("@")>Email.indexOf("."))
        {
            setErrorMessage( document.getElementById("lblEmailMessage"), "邮箱格式填写有误！" );
            return;
        }
        setRightMessage( document.getElementById("lblEmailMessage") );
        var ret = Controls_User_UserModifyBasicInfo.SaveForm(
            NickName, SexId, ProvinceId, CityId, TrueName, BirthdayStr
            , Mobile, Phone, MSN, QQ, Note, PrivacyClassId,Email ).value;
        $("#btnSubmit").removeAttr("disabled");
        if ( ret == "0" )
            alert("修改成功！");
        else
            alert("发生错误:" + ret);
    }
</script>

<style type="text/css">
<!--
    .MessageError {
        color:#f00;
    }
    .MessageRight {
        color:#090;
    }
    .isShow{
        display:none;
    }
-->
</style>
<input id="hdClientId" type="hidden" runat="server" />
<table class="MyTable" width="100%" cellpadding="1" cellspacing="1" border="0">
<tr>
        <th class="right">
            邮箱：</th>
        <td>
            <input id="tbEmail" type="text"  runat="server" />
            <span id="lblEmailMessage"></span>
        </td>
        <td>
           </td>
    </tr>
    <tr>
        <th class="right">
            昵称：</th>
        <td>
            <input id="tbNickName" type="text" maxlength="16" runat="server"/>
            <span id="lblNickNameMessage"></span>
        </td>
        <td class="KcAttentionFont">
            给自己起一个酷点的名字吧。</td>
    </tr>
    <tr>
        <th class="right">
            性别：</th>
        <td>
            <input id="rdoSex0" type="radio" value="0" runat="server" />
            <span>先生</span>
            <input id="rdoSex1" type="radio" value="1" runat="server" />
            <span>女士</span>
        </td>
        <td>
        </td>
    </tr>
    <tr>
        <th class="right">
            所在城市：</th>
        <td>
            <asp:DropDownList ID="ddlProvince" runat="server">
            </asp:DropDownList>
            <asp:DropDownList ID="ddlCity" runat="server">
            </asp:DropDownList>
        </td>
        <td class="KcAttentionFont">
            请选择您所在的城市。</td>
    </tr>
    <tr class="isShow">
        <th colspan="3" >
            <span class="KcAttentionFont">以下部分为选填部分，你可以根据需要来填写！</span></th>
    </tr>
    <tr class="isShow">
        <th class="right">
            姓名：</th>
        <td>
            <input id="tbTrueName" type="text" maxlength="20" runat="server" />
        </td>
        <td rowspan="6" class="KcAttentionFont">
            隐私信息，只为您提供服务时使用，绝对不会泄露。</td>
    </tr>
     <tr class="isShow">
        <th class="right">
            生日：</th>
        <td>
            <input id="tbBirthday" type="text" maxlength="15" readonly="readonly" runat="server" />
        </td>
    </tr>
     <tr class="isShow">
        <th class="right">
            手机：</th>
        <td>
            <input id="tbMobile" type="text" maxlength="15" runat="server" />
            <span id="lblMobileMessage"></span>
        </td>
    </tr>
     <tr class="isShow">
        <th class="right">
            固定电话：</th>
        <td>
            <input id="tbPhone" type="text" maxlength="20" runat="server" />
            <span id="lblPhoneMessage"></span>
            <br />
            <span class="KcAttentionFont">格式如：010-12345678</span>
        </td>
    </tr>
    <tr class="isShow">
        <th class="right">
            MSN：</th>
        <td>
            <input id="tbMSN" type="text" runat="server" maxlength="50" />
            <span id="lblMSNMessage"></span>
        </td>
    </tr>
    <tr class="isShow">
        <th class="right">
            QQ：</th>
        <td>
            <input id="tbQQ" type="text" runat="server" maxlength="20" />
            <span id="lblQQMessage"></span>
        </td>
    </tr>
     <tr class="isShow">
        <th class="right">
            个人简介：</th>
        <td>
            <textarea id="tbNote" cols="25" rows="5" runat="server"></textarea>
            <span id="lblNoteMessage"></span>
        </td>
        <td class="KcAttentionFont">
            简单的介绍一下自己吧！(长度在1024个字符以内)</td>
    </tr>
    <tr class="isShow">
        <th class="right">
            资料权限：</th>
        <td>
            <select id="ddlPrivacyClass" runat="server">
                <option value="0">私有</option>
                <option value="1">仅好友可见</option>
                <option value="2">公开</option>
            </select>
        </td>
        <td>
        </td>
    </tr>
    <tr align="center">
        <td colspan="3" style="text-align: center;">
            <input id="btnSubmit" type="button" value="提交" runat="server" />
            <input id="btnReset" type="button" value="还原" onclick="window.location='UserModifyBasicInfo.aspx'" />
        </td>
    </tr>
</table>
