﻿<%@ control language="C#" autoeventwireup="true" inherits="Controls_User_UserModifyPassword, DoodiiShop" %>

<script type="text/javascript">
    $(document).ready( function(){ init() });
    var init = function() {
        bindEvents();
    }
    var bindEvents = function() {
        $("#tbOldPwd").bind("blur", function(){ validatePassword(this) });
        $("#tbPwd").bind("blur", function(){ validatePassword(this) });
        $("#tbPwd2").bind("blur", function(){ validatePassword(this) });
    }
    var validatePassword = function( objDom ) {
        var txt = objDom.value;
        if ( txt.length < 6 || txt.length > 17 ) {
            $(objDom).next().attr("class", "MessageError");
            $(objDom).next().html("密码长度不符，请重新输入。");
            return false;
        } else {
            $(objDom).next().attr("class", "MessageRight");
            $(objDom).next().html("√");
            validatePasswordSame();
            return true;
        }
    }
    var validatePasswordSame = function() {
        if ( $("#tbPwd").val() != $("#tbPwd2").val() ) {
            $("#tbPwd2").next().attr("class", "MessageError");
            $("#tbPwd2").next().html("与上边密码不一致。");
            return false;
        } else {
            return true;
        }
    }
    var validateForm = function() {
        if ( !validatePassword( document.getElementById("tbOldPwd") ) ) return false;
        if ( !validatePassword( document.getElementById("tbPwd") ) ) return false;
        if ( !validatePassword( document.getElementById("tbPwd2") ) ) return false;
        if ( !validatePasswordSame() ) return false;
        return true;
    }
    function saveForm() {
        if ( !validateForm() ) {
            return;
        }
        var OldPwd = $("#tbOldPwd").val();
        var NewPwd = $("#tbPwd").val();
        var NewPwd2 = $("#tbPwd2").val();
        if ( NewPwd != NewPwd2 ) {
            alert("两次输入的新密码不致");
            return;
        }
        $("#btnSaveForm").attr("disabled", true);
        var ret = Controls_User_UserModifyPassword.ChangePassword(OldPwd, NewPwd).value;
        $("#btnSaveForm").removeAttr("disabled");
        if ( ret == "0" )
            alert("修改成功！");
        else
            alert("发生错误:" + ret);
    }
</script>

<style type="text/css">
    .MessageError {
        color:#f00;
    }
    .MessageRight {
        color:#090;
    }
    .sio {
    display:block;
    background-color:green;
    color:#ffffff;
    height:25px;
    line-height:25px;
    margin-right:50px;
    text-align:center;
    width:48px;
    
    }
    

.STYLE1 {color: #FFFFFF}
</style>

<div id="PasswordCenter">
<table class="MyTable" width="100%" border="0" cellpadding="1" cellspacing="1">
    <tr>
        <td class="htd">
            原密码：</td>
        <td class="rtd">
            <input id="tbOldPwd" type="password" maxlength="17" onpaste="return false" />
            <span class="KcAttentionFont"></span>
        </td>
    </tr>
    <tr>
        <td class="htd">
            新密码：</td>
        <td class="rtd">
            <input id="tbPwd" type="password" maxlength="17" onpaste="return false" />
            <span class="KcAttentionFont">6-16个字符（字母、数字、特殊符号），不区分大小写。</span>
        </td>
    </tr>
    <tr>
        <td class="htd">
            重复新密码：</td>
        <td class="rtd">
            <input id="tbPwd2" type="password" maxlength="17" onpaste="return false" />
            <span class="KcAttentionFont">再次输入上面设定的密码。</span>
        </td>
    </tr>
    <tr>
        <td colspan="2" style="padding:10px 0px;">
            <div style="width:90px; margin:0 auto; color:#ffffff;">
            <a class="sio" id="btnSaveForm" href="javascript:saveForm()">提&nbsp;交</a>
            </div>
        </td>
    </tr>
</table>
</div>