﻿<%@ control language="C#" autoeventwireup="true" inherits="Controls_User_UserUploadHeadPortrait, DoodiiShop" %>
<%@ Register Assembly="Brettle.Web.NeatUpload" Namespace="Brettle.Web.NeatUpload"
    TagPrefix="Upload" %>

<script type="text/javascript" src="/js/jquery-tabs/jquery.tabs.pack.js"></script>

<link rel="Stylesheet" type="text/css" href="/js/jquery-tabs/jquery.tabs.css" />
<link rel="Stylesheet" type="text/css" href="/js/jquery-tabs/jquery.tabs-ie.css" />

<script type="text/javascript">
    $(document).ready( function(){ init() });
    
    var init = function() {
        bindEvents();
        $("#tabContent").tabs({ fxFade: true, fxSpeed: 'fast' });
        setUploadKind( 1 );
        getCurrentPhoto();
        getHeadPhotoList();
    } 
    
    var bindEvents = function() {
        $("#rdoKind1").bind("click", function(){ setUploadKind( 1 ) });
        $("#rdoKind2").bind("click", function(){ setUploadKind( 2 ) });
        $("#btnSetSystemHeadPhoto").bind("click", function(){ setSystemHeadPhoto() });
    }
    
    function viewFU()
    {        

        var file = $("#<%=InputFile1.ClientID %>").val();
        var result = doodii.Web.App_Code.Common.checkImgExt(file).value;
        if (result == 0)
        {            
            document.getElementById("imgCurrentPhoto").src="/getImage_0_100_100_0_0_0_0.shtml";
            alert("请选择正确的文件类型！");
        }
        else 
            document.getElementById("imgCurrentPhoto").src=file;
    }
    
    var setUploadKind = function( kind ) {
        if ( kind == 1 ) {
            $("#tabContent1").show();
            $("#tabContent2").hide();
        } else {
            $("#tabContent1").hide();
            $("#tabContent2").show();
        }
        document.documentElement.scrollTop = 0;
        document.body.focus();
    }
   
    var getCurrentPhoto = function(PhotoId) {
        if (PhotoId == undefined) PhotoId = Controls_User_UserUploadHeadPortrait.GetCurrentHeadPhotoId().value;
        alert(PhotoId);
        if ( PhotoId != null ) {
            document.getElementById("imgCurrentPhoto").src = "/getImage_" + PhotoId + "_100_100_0_0_0_1.shtml";
            /*
            if ( $("#imgCurrentPhoto").css("display") == "none" ) {
                $("#imgCurrentPhoto").css("display", "block");
            }
            */
        } else {
            alert("获取当前头像失败！");
        }
    }

    var getHeadPhotoList = function() {
        var ret = Controls_User_UserUploadHeadPortrait.GetHeadPhotoList().value;
        var oTable = document.getElementById("SystemHeadPhotoTable");
        if ( ret != null && typeof(ret) == "object" ) {
            var n = 1;
            var tr = oTable.insertRow(-1);
            for ( var i=0; i<ret.length; i++ ) {
                if ( n > 5 ) var tr = oTable.insertRow(-1);
                var PhotoId = ret[i].PhotoId;
                var ImgSrc = "/getImage_" + PhotoId + "_100_100_0_0_0_1.shtml";
                var td = tr.insertCell(-1);
                td.innerHTML += "<img src='" + ImgSrc + "' />";
                td.innerHTML += "<br />";
                td.innerHTML += "<input type='radio' name='rdo' value='" + PhotoId + "' />";
                n++;
            }
        } else {
            alert("获取系统头像库失败！");
        }
    }    
   
    var setSystemHeadPhoto = function() { 
        var SystemHeadPhotoId = $("input[@name=rdo][@checked]").eq(0).val();
        if ( SystemHeadPhotoId == null ) {
            alert("请选择一个系统头像！"); 
        } else {
            var ret = Controls_User_UserUploadHeadPortrait.SetHeadPhoto( SystemHeadPhotoId ).value;
            if ( ret == "0" ) {
                alert("头像修改成功！");
                getCurrentPhoto();
            } else {
                alert("发生错误:" + ret);
            }
        }
    }
    
    var clearHeadPhoto = function() {
        if ( window.confirm("您确定要删除当前头像吗?") ) {
            var ret = Controls_User_UserUploadHeadPortrait.SetHeadPhoto( 0 ).value;
            if ( ret == "0" ) {
                alert("头像删除成功！");
                getCurrentPhoto();
            } else {
                alert("发生错误:" + ret);
            }
        }
    }
    
    var changeImage = function() {
        var filePath = $("#<%=InputFile1.ClientID%>").val();
        if ( doodii.Web.App_Code.Common.checkImgExt(filePath).value == 0 ) {
            $("#imgPreview").attr("src", "/getImage_0_100_100_0_0_0_1.shtml");
        } else {
            $("#imgPreview").attr("src", filePath);
        }
    }
    
</script>

<style type="text/css">
    #ContentDiv {
        width:100%;
        text-align:left;
    } 
    #CurrentPhoto {
        margin:5px;
    }
    #CurrentPhoto img {
        /*display:none;*/
    }
    #ContentDiv img {
        width:100px;
        height:100px;
        border:1px solid #ccc;
        margin:5px;
    }
    .tabContent .Title {
        margin:5px;
        padding:5px;
        font-weight:bold;
        border-bottom:1px dotted #555;
    }
    hr {
        height:1px ;
    }
    #SystemHeadPhotoTable td {
        padding:5px;
        text-align:center;
    }
    .ProgressBar {
        width:500px;
        height:100px;
    }
</style>
<div id="ContentDiv">
    <div id="CurrentPhoto" style="display: none;">
        <span class="KcAttentionFont">更改头像时，新的头像会自动覆盖原头像。</span> <span class="KcAttentionFont">
            如果您要删除当前头像，请点击“<a href="javascript:clearHeadPhoto();">[删除头像]</a>”。</span>
    </div>
    <div id="tabContent">
        <ul style="display: none;">
            <li><a href="#tabContent1"><span>从硬盘中浏览上传</span></a></li>
            <li><a href="#tabContent2"><span>从系统头像库中选择</span></a></li>
        </ul>
        <div id="tabContent1">
            <div class="Title" style="display: none;">
                <span>从硬盘中浏览</span>
                <img id="imgPreview" alt="图处预览" src="/getImage_0_100_100_0_0_0_1.aspx" onload="DrawImage(this,100,100);" />
            </div>
            <br />
            <span class="KcAttentionFont">（头像长宽比例最好是1:1，文件大小请不要超过100KB。文件类型可使用gif、jpg及pnp。）</span>
            <Upload:InputFile ID="InputFile1" runat="server" Size="50" onchange="changeImage()" />
            <asp:Button ID="btnUpload" runat="server" Text="上传" OnClick="btnUpload_Click" />
            <br />
            <Upload:ProgressBar ID="ProgressBar1" runat="server" Inline="True">
            </Upload:ProgressBar>
            <br />
            <span class="KcAttentionFont">上传头像时，新的头像会自动覆盖原头像。</span>
            <br />
            <img id="imgCurrentPhoto" alt="当前头像" src="/getImage_0_100_100_0_0_0_0.aspx" width="100" height="100" />
            <img id="imgCurrentPhoto2" alt="当前头像" src="" width="80" height="80" />
            <img id="imgCurrentPhoto3" alt="当前头像" src="" width="50" height="50" />
        </div>
        <div id="tabContent2" class="tabContent" style="display: none;">
            <div class="Title">
                <span>系统头像库</span>
                <input id="btnSetSystemHeadPhoto" type="button" value="提交选择" />
            </div>
            <table id="SystemHeadPhotoTable">
            </table>
        </div>
    </div>
</div>
