﻿<%@ page language="C#" autoeventwireup="true" masterpagefile="~/MasterPage/UserMasterPage.master" inherits="Rest_Manage_RestCollectList, DoodiiShop" enableEventValidation="false" viewStateEncryptionMode="Never" %>

<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="Server">
    <script type="text/javascript" src="/js/Nav.js"></script>
    <script type="text/javascript">
        var g_PageSize = 5;
        var o_Nav = null;
        
        $(document).ready( function(){ init() });
        
        var init = function() {
            o_Nav = new vensonNav("PageNav", "o_Nav", "getList");
            $("#ddlState").bind("change", function(){ o_Nav.pageIndex=1; getList() });
            $("#btnAppend").bind("click", function(){ addRestCollect() });
            getList();
        }
        
        var getList = function() {
            $("#ContentBar").html("");
            var _State = $("#ddlState").val();
            var ret = Rest_Manage_RestCollectList.GetList(_State, o_Nav.pageIndex, g_PageSize).value;
            if (ret != null && typeof(ret) == "object")
            {
                o_Nav.render(ret.PageInfo.PageIndex, ret.PageInfo.TotalPage);
                if (ret.Items.length == 0) {
                    $("#ContentBar").html("暂无记录");
                    return;
                }
                for (var i=0; i<ret.Items.length; i++) {
                    var div = document.createElement("div");
                    div.className = "Info_Title";
                    div.innerHTML = "餐馆名称：" + HtmlEncode(ret.Items[i].Name) + "(";
                    switch (ret.Items[i].State) {
                        case -1: div.innerHTML += "验证未通过"; break;
                        case 0: div.innerHTML += "待验证"; break;
                        case 1: div.innerHTML += "验证通过"; break;
                    }
                    div.innerHTML += ")";
                    $("#ContentBar").append(div);
                    var div = document.createElement("div");
                    div.className = "Info_Content";
                    var p = document.createElement("p");
                    p.innerHTML = "<span class='Info_Field'>餐馆电话：</span>" + HtmlEncode(ret.Items[i].Phone);
                    div.appendChild(p);
                    var p = document.createElement("p");
                    p.innerHTML = "<span class='Info_Field'>负责人：</span>" + HtmlEncode(ret.Items[i].Principal);
                    div.appendChild(p);
                    var p = document.createElement("p");
                    p.innerHTML = "<span class='Info_Field'>餐馆地址：</span>" + HtmlEncode(ret.Items[i].Address);
                    div.appendChild(p);
                    var p = document.createElement("p");
                    p.innerHTML = "<span class='Info_Field'>外卖信息：</span>" + HtmlEncode(ret.Items[i].DeliverInfo);
                    div.appendChild(p);
                    var p = document.createElement("p");
                    p.innerHTML = "<span class='Info_Field'>连锁信息：</span>" + HtmlEncode(ret.Items[i].LinkInfo);
                    div.appendChild(p);
                    var p = document.createElement("p");
                    p.innerHTML = "<span class='Info_Field'>豆丁反馈：</span>" +
                        "<span class='Info_Feedback'>" + HtmlEncode(ret.Items[i].Feedback) + "</span>";
                    div.appendChild(p);
                    $("#ContentBar").append(div);
                }
            }
        }
        
        var addRestCollect = function() {
            window.open("/User/RestAddCollect.aspx", "", "width=400, height=300, status=yes");
        }
    </script>
    <style type="text/css">
        .NewTable {
            margin-bottom: 5px;
        }
        .NewTable .htd {
            width:80px;
        }
        #ToolBar {
            margin:5px;
            padding:5px;
            text-align:left;
            border:1px dotted #ccc;
        }
        #PageNav {
            margin:5px;
            text-align:right;
        }
        #ContentBar {
            
        }
        .Info_Title {
            padding:3px;
            background-color:#F4F4F4;
            border:1px solid #ccc;
            font-weight:bold;
            color:#369;
        }
        .Info_Field {
            font-weight:bold;
        }
        .Info_Content {
            border:1px solid #ccc;
            margin-bottom:5px;
        }
        .Info_Content p {
            margin:3px;
        }
        .Info_Feedback {
            color:#f00;
        }
    </style>
    <div id="ToolBar">
        <span>状态：</span>
        <select id="ddlState">
            <option value="-2">全部</option>
            <option value="-1">验证未通过</option>
            <option value="0">待验证</option>
            <option value="1">验证通过</option>
        </select>
        <input id="btnAppend" type="button" value="添加熟悉的餐馆" />
    </div>
    <div id="PageNav"></div>
    <div id="ContentBar">
    </div>
    <!--
    <div class="Info_Title">餐馆名称：xxxxxx店(验证通过)</div>
    <div class="Info_Content">
        <p><span class="Info_Field">餐馆电话：</span>80243294324</p>
        <p><span class="Info_Field">负责人：</span>8李林</p>
        <p><span class="Info_Field">餐馆地址：</span>8sfsdfsdfsdfsddsdsfdsf</p>
        <p><span class="Info_Field">外卖方式：</span>不外卖</p>
        <p><span class="Info_Field">连锁方式：</span>不连锁</p>
    </div>
    -->
</asp:Content>