﻿<%@ page language="C#" autoeventwireup="true" masterpagefile="~/MasterPage/UserMasterPage.master" inherits="Rest_Manage_RestOrder, DoodiiShop" enableEventValidation="false" viewStateEncryptionMode="Never" %>

<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" runat="Server">

    <script type="text/javascript" src="/js/jquery-tabs/jquery.tabs.pack.js"></script>

    <script type="text/javascript" src="/js/jquery-calendar/jquery-calendar.js"></script>

    <script type="text/javascript" src="/js/Format.js"></script>

    <script type="text/javascript" src="/js/Nav.js"></script>

    <link rel="Stylesheet" type="text/css" href="/js/jquery-tabs/jquery.tabs.css" />
    <link rel="Stylesheet" type="text/css" href="/js/jquery-tabs/jquery.tabs-ie.css" />
    <link rel="Stylesheet" type="text/css" href="/js/jquery-calendar/jquery-calendar.css" />

    <script type="text/javascript">
    var navTodayOrder = null;
    var navReservationOrder = null;
    var navSearchOrder = null;
    var navBuyerOrder = null;
    
    $(document).ready( function(){ init() });
        
    var init = function() {
        bindEvents();
        $("#tabContainer").tabs({ fxFade: true, fxSpeed: 'fast' });
        $("#tabContainer").triggerTab( 1 );
        $("#tbSearchOrderBeginDeliverDate").calendar();
        $("#tbSearchOrderEndDeliverDate").calendar();
        var _Today = new Date();
        var _TodayStr = _Today.getFullYear() + "-" + (_Today.getMonth()+1) + "-" + _Today.getDate();
        $("#tbSearchOrderBeginDeliverDate").val( _TodayStr );
        $("#tbSearchOrderEndDeliverDate").val( _TodayStr );
        navTodayOrder = new vensonNav(
            "TodayOrderPageNav",
            "navTodayOrder",
            "getTodayOrderList"
        );
        navReservationOrder = new vensonNav(
            "ReservationOrderNav",
            "navReservationOrder",
            "getReservationOrderList"
        );
        navSearchOrder = new vensonNav(
            "SearchOrderNav",
            "navSearchOrder",
            "getSearchOrderList"
        );
        navBuyerOrder = new vensonNav(
            "BuyerOrderNav",
            "navBuyerOrder",
            "getBuyerOrderList"
        );
        getRestList();
//        getNewOrderCount();
//        getFirstHastenOrderInfo();
    }
    
    var bindEvents = function() {
//        window.onscroll = refreshPopMessage;
//        setInterval(getNewOrderCount, 15000);
//        setInterval(getFirstHastenOrderInfo, 20000);
        $("#PopOrder").bind("click", function(){ $(this).hide() });
        $("#btnHastenOrderSubmit").bind("click", function(){ submitHastenOrder() });
        $("#btnHastenOrderCancel").bind("click", function(){ $("#PopHastenOrder").hide() });
        $("#btnTodayOrderSearch").bind("click", function(){
            navTodayOrder.pageIndex = 1;
            getTodayOrderList();
        });
        $("#btnReservationOrderSearch").bind("click", function(){
            navReservationOrder.pageIndex = 1;
            getReservationOrderList();
        });
        $("#btnSearchOrderSearch").bind("click", function(){
            navSearchOrder.pageIndex = 1;
            getSearchOrderList();
        });
        $("#btnBuyerOrderSearch").bind("click", function(){
            navBuyerOrder.pageIndex = 1;
            getBuyerOrderList();
        });
        $("#tbBuyerOrderName").bind("focus", function(){
            $(this).attr( "title", $(this).val() );
            $(this).val( "" );
        } );
        $("#tbBuyerOrderName").bind("blur", function(){
            if ( $(this).val() == "" && $(this).attr("title") != undefined ) {
                $(this).val( $(this).attr("title") );
            }
        });
    }
    
    function refreshPopMessage()
    {
        var _PopOrderHeight = parseInt($("#PopOrder").css("height"));
        var _PopHastenOrderHeight = parseInt($("#PopHastenOrder").css("height"));
        var _PopOrderTop = document.documentElement.scrollTop
            + document.documentElement.clientHeight
            - _PopOrderHeight - 5;
        var _PopHastenOrderTop = document.documentElement.scrollTop + document.documentElement.clientHeight
            - _PopHastenOrderHeight - 5;
        $("#PopOrder").css("top", _PopOrderTop + "px");
        $("#PopHastenOrder").css("top", _PopHastenOrderTop + "px");
    }
    
    function getNewOrderCount()
    {
        var ret = Rest_Manage_RestOrder.GetNewOrderCount().value;
        if (ret != null)
        {
            $("#PopOrder").hide();
            $("#lblNewOrderCount").html(ret);
            if (ret > 0)
            {
                $("#PopOrder").show("500");
                document.body.focus();
            }
        }
    }
    
    function getFirstHastenOrderInfo()
    {
        var ret = Rest_Manage_RestOrder.GetFirstHastenOrderInfo().value;
        if (ret != null && typeof(ret) == "object")
        {
            $("#PopHastenOrder").hide();
            $("#hdHastenOrderId").val(ret.Id);
            $("#lblHastenOrderOrderId").html(ret.OrderId);
            $("#PopHastenOrder").show(500);
            document.body.focus();
        }
    }
    
    function submitHastenOrder()
    {
        var HastenOrderId = parseInt($("#hdHastenOrderId").val());
        //var OrderId = parseInt($("#lblHastenOrderOrderId").html());
        if ($("input[@type=radio][@name=rdoHastenOrderResult][@checked]").size() == 0)
        {
            alert("请选择回复结果!");
            return;
        }
        var Sign = parseInt($("input[@type=radio][@name=rdoHastenOrderResult][@checked]").val());
        if (window.confirm("您确定要提交回复吗?"))
        {
            var ret = Rest_Manage_RestOrder.UpdateHastenOrderReply(HastenOrderId, Sign).value;
            if (ret == true)
            {
                alert("回复提交成功!");
                $("#hdHastenOrderId").val(0);
                $("#lblHastenOrderOrderId").html("0");
                $("#PopHastenOrder").hide();
            }
            else
            {
                alert("提交失败!");
            }
        }
    }
    
    var getRestList = function() {
        var ret = Rest_Manage_RestOrder.GetRestList().value;
        if ( ret != null && typeof(ret) == "object" ) {
            if ( ret.length == 0 ) {
                $("#btnTodayOrderSearch").attr("disabled", true);
                $("#btnReservationOrderSearch").attr("disabled", true);
                $("#btnSearchOrderSearch").attr("disabled", true);
                $("#btnBuyerOrderSearch").attr("disabled", true);
                if ( window.confirm("只有豆丁的联盟合作店才能管理订单，您要现在加入豆丁吗？") ) {
                    window.open("http://www2.53kf.com/company.php?arg=doodii&style=1&language=cn&lytype=0&charset=GBK&kflist=off&kf=&referer=http%3A%2F%2Fwww.doodii.com%2FsuiteMenu%2Findex.aspx&keyword=&tpl=crystal_blue_free");
                }
            }
            for ( var i=0; i<ret.length; i++ ) {
                ddlAdd( document.getElementById("ddlTodayOrderRest"), ret[i].Name, ret[i].RestId );
                ddlAdd( document.getElementById("ddlReservationOrderRest"), ret[i].Name, ret[i].RestId );
                ddlAdd( document.getElementById("ddlSearchOrderRest"), ret[i].Name, ret[i].RestId );
            }
        }
        getTodayOrderList();
        getReservationOrderList();
    }
    
    var renderOrderList = function( OrderContentIndex, objInfos ) {
        for ( var i=0; i<objInfos.length; i++ ) {
            var Item = objInfos[i];
            var _OrderId = parseInt( Item.OrderId );
            var _OrderType = parseInt( Item.OrderType );
            var table = document.createElement("table");
            table.className = "NewTable";
            var tr = table.insertRow(-1);
            var th = document.createElement("th");
            th.colSpan = 3;
            if (Item.State == -1 || Item.State == -2)
            {
                $(th).css("background-color", "#333");
                $(th).css("color", "#fff");
            }
            else if (Item.State == 1)
            {
                $(th).css("background-color", "#060");
                $(th).css("color", "#fff");
            }
            th.innerHTML = "#<strong>" + _OrderId + "</strong>";
            th.innerHTML += "&nbsp;(<a href='/Rest/" + Item.RestId + ".shtml' target='_blank'>" + Item.RestName + "</a>)";
            th.innerHTML += "&nbsp;[";
            if ( Item.State == 0 ) {
                th.innerHTML += "&nbsp;<a href='javascript:updateOrderState(" + OrderContentIndex + "," + _OrderId + ",1," + _OrderType + ")'>完成</a>";
                th.innerHTML += "&nbsp;<a href='javascript:updateOrderState(" + OrderContentIndex + "," + _OrderId + ",-2," + _OrderType + ")'>虚假</a>";
                th.innerHTML += "&nbsp;<a href='javascript:updateOrderState(" + OrderContentIndex + "," + _OrderId + ",-1," + _OrderType + ")'>作废</a>";
            } else {
                switch ( Item.State ) {
                    case -2 : th.innerHTML += "虚假订单"; break;
                    case -1 : th.innerHTML += "已作废"; break;
                    case 1 : th.innerHTML += "已完成"; break;
                    default : th.innerHTML += "未知状态"; break;
                }
            }
            th.innerHTML += "&nbsp;]";
            tr.appendChild( th );
            var th = document.createElement("th");
            th.style.textAlign = "center";
            th.innerHTML = "<a href='javascript:showOrderInfo(" + _OrderId + "," + _OrderType + ")'>客户信息</a>";
            th.innerHTML += "&nbsp;[&nbsp;<a href='javascript:copyInfo(" + _OrderId + "," + _OrderType + ")'>复制</a>&nbsp;]";
            tr.appendChild( th );
            var tr = table.insertRow(-1);
            var td = tr.insertCell(-1);
            td.className = "htd";
            td.innerHTML = "送餐时间";
            tr.appendChild( td );
            var td = tr.insertCell(-1);
            td.innerHTML = formatDateTimeFromDateStr( Item.DeliverDate, true );
            var td = tr.insertCell(-1);
            td.className = "htd";
            td.innerHTML = "订单金额";
            var td = tr.insertCell(-1);
            td.innerHTML = formatToMoney( Item.Total ) + "元";
            var tr = table.insertRow(-1);
            var td = tr.insertCell(-1);
            td.className = "htd";
            td.innerHTML = "客户信息";
            var td = tr.insertCell(-1);
            td.colSpan = 3;
            td.innerHTML = "<strong>姓名：</strong>" + HtmlEncode(Item.Name)
                + "&nbsp;&nbsp;<strong>电话：</strong>" + HtmlEncode(Item.Phone)
                + "&nbsp;&nbsp;<strong>下单时间：</strong>" + formatDateTimeFromDateStr(Item.DateTime, true)
                + "<br><strong>地址：</strong>" + HtmlEncode(Item.Address);
            var tr = table.insertRow(-1);
            var td = tr.insertCell(-1);
            td.className = "htd";
            td.innerHTML = "餐品内容";
            var td = tr.insertCell(-1);
            td.colSpan = 3;
            td.innerHTML = Item.OrderContent;
            var tr = table.insertRow(-1);
            var td = tr.insertCell(-1);
            td.className = "htd";
            td.innerHTML = "备注";
            var td = tr.insertCell(-1);
            td.colSpan = 3;
            td.innerHTML = Item.Note;
            var OrderContentId;
            switch ( OrderContentIndex ) {
                case 1 : OrderContentId = "TodayOrderContent"; break;
                case 2 : OrderContentId = "ReservationOrderContent"; break;
                case 3 : OrderContentId = "SearchOrderContent"; break;
                case 4 : OrderContentId = "BuyerOrderContent"; break;
            }
            document.getElementById(OrderContentId).appendChild( table );
            Item = null;
        }
    }
    
    var getTodayOrderList = function() {
        $("#TodayOrderContent").html( "" );
        var RestId = parseInt( $("#ddlTodayOrderRest").val() );
        var State = parseInt( $("#ddlTodayOrderState").val() );
        var OrderId = $("#tbTodayOrderId").val();
        if (OrderId != "")
            OrderId = parseInt(OrderId);
        else
            OrderId = 0;
        if (isNaN(OrderId))
        {
            alert("订单号无效！");
            return;
        }
        var ret = Rest_Manage_RestOrder.GetTodayOrderList(RestId, State, OrderId, navTodayOrder.pageIndex, 10).value;
        if ( ret != null && typeof(ret) == "object" ) {
            navTodayOrder.render( ret.GeneralOrderPageInfo.PageIndex, ret.GeneralOrderPageInfo.TotalPage );
            if ( ret.GeneralOrderInfos.length == 0 ) {
                $("#TodayOrderContent").html( "暂无结果！" );
            } else {
                renderOrderList( 1, ret.GeneralOrderInfos );
            }
        } else {
            alert("今日订单读取失败！");
        }
        getTodayOrderSumInfo( RestId );
    }
    
    var getReservationOrderList = function() {
        $("#ReservationOrderContent").html( "" );
        var RestId = parseInt( $("#ddlReservationOrderRest").val() );
        var State = parseInt( $("#ddlReservationOrderState").val() );
        var ret = Rest_Manage_RestOrder.GetReservationOrderList(RestId, State, navReservationOrder.pageIndex, 10).value;
        if ( ret != null && typeof(ret) == "object" ) {
            navReservationOrder.render( ret.GeneralOrderPageInfo.PageIndex, ret.GeneralOrderPageInfo.TotalPage );
            if ( ret.GeneralOrderInfos.length == 0 ) {
                $("#ReservationOrderContent").html( "暂无结果！" );
            } else {
                renderOrderList( 2, ret.GeneralOrderInfos );
            }
        } else {
            alert("预定订单读取失败！");
        }
    }
    
    var getSearchOrderList = function() {
        $("#SearchOrderContent").html( "" );
        var RestId = parseInt( $("#ddlSearchOrderRest").val() );
        var State = parseInt( $("#ddlSearchOrderState").val() );
        var OrderId = $("#tbSearchOrderId").val();
        if (OrderId != "")
            OrderId = parseInt(OrderId);
        else
            OrderId = 0;
        if (isNaN(OrderId))
        {
            alert("订单号无效！");
            return;
        }
        var BeginDeliverDateStr = $("#tbSearchOrderBeginDeliverDate").val();
        var EndDeliverDateStr = $("#tbSearchOrderEndDeliverDate").val();
        if ( !isShortDate( BeginDeliverDateStr ) ) {
            alert("请填写正确的起始时间！");
            return;
        }
        if ( !isShortDate( EndDeliverDateStr ) ) {
            alert("请填写正确的截止时间！");
            return;
        }
        if ( BeginDeliverDateStr == "" ) {
            alert("请选择起始时间！");
            return;
        }
        if ( EndDeliverDateStr == "" ) {
            alert("请选择截止时间！");
            return;
        }
        var ret = Rest_Manage_RestOrder.GetSearchOrderList(RestId, State, OrderId, BeginDeliverDateStr, EndDeliverDateStr, navSearchOrder.pageIndex, 10).value;
        if ( ret != null && typeof(ret) == "object" ) {
            navSearchOrder.render( ret.GeneralOrderPageInfo.PageIndex, ret.GeneralOrderPageInfo.TotalPage );
            if ( ret.GeneralOrderInfos.length == 0 ) {
                alert("暂无结果！");
            } else {
                renderOrderList( 3, ret.GeneralOrderInfos );
            }
        } else {
            alert("查询订单读取失败！");
        }
        getOrderSumInfo( RestId, BeginDeliverDateStr, EndDeliverDateStr );
    }
    
    var getBuyerOrderList = function() {
        $("#BuyerOrderContent").html( "" );
        var Name = $("#tbBuyerOrderName").val();
        if ( $.trim(Name) == "" ) {
            alert("请填写客户名称！");
            return;
        }
        var ret = Rest_Manage_RestOrder.GetBuyerOrderList(Name, navBuyerOrder.pageIndex, 10).value;
        if ( ret != null && typeof(ret) == "object" ) {
            navBuyerOrder.render( ret.GeneralOrderPageInfo.PageIndex, ret.GeneralOrderPageInfo.TotalPage );
            if ( ret.GeneralOrderInfos.length == 0 ) {
                alert("暂无结果！");
            } else {
                renderOrderList( 4, ret.GeneralOrderInfos );
            }
        } else {
            alert("客户查询读取失败！");
        }
    }
    
    var getTodayOrderSumInfo = function( RestId ) {
        $("#lblTodayTotalCount").html( "0" );
        $("#lblTodayTotalPrice").html( "0.00元" );
        $("#lblTodaySucceedCount").html( "0" );
        $("#lblTodaySucceedPrice").html( "0.00元" );
        $("#lblTodayDeductPrice").html( "0.00元" );
        var curDate = new Date();
        var strDate = curDate.getFullYear() + "-" + (curDate.getMonth()+1) + "-" + curDate.getDate();
        var ret = Rest_Manage_RestOrder.GetOrderSumInfo(RestId, strDate, strDate).value;
        if ( ret != null && typeof(ret) == "object" ) {
            $("#lblTodayTotalCount").html( ret.TotalCount + "" );
            $("#lblTodayTotalPrice").html( formatToMoney(ret.TotalPrice) + "元" );
            $("#lblTodaySucceedCount").html( ret.SucceedCount + "" );
            $("#lblTodaySucceedPrice").html( formatToMoney(ret.SucceedPrice) + "元" );
            $("#lblTodayDeductPrice").html( formatToMoney(ret.DeductPrice) + "元" );
        } else {
            alert("今天订单统计信息读取失败！");
        }
    }
    
    var getOrderSumInfo = function( RestId, BeginDeliverDateStr, EndDeliverDateStr ) {
        $("#lblTotalCount").html( "0" );
        $("#lblTotalPrice").html( "0.00元" );
        $("#lblSucceedCount").html( "0" );
        $("#lblSucceedPrice").html( "0.00元" );
        $("#lblDeductPrice").html( "0.00元" );
        var ret = Rest_Manage_RestOrder.GetOrderSumInfo(RestId, BeginDeliverDateStr, EndDeliverDateStr).value;
        if ( ret != null && typeof(ret) == "object" ) {
            $("#lblTotalCount").html( ret.TotalCount + "" );
            $("#lblTotalPrice").html( formatToMoney(ret.TotalPrice) + "元" );
            $("#lblSucceedCount").html( ret.SucceedCount + "" );
            $("#lblSucceedPrice").html( formatToMoney(ret.SucceedPrice) + "元" );
            $("#lblDeductPrice").html( formatToMoney(ret.DeductPrice) + "元" );
        } else {
            alert("订单统计信息读取失败！");
        }
    }
    
    var showOrderInfo = function( OrderId, OrderType ) {
        var url = "/Rest/Manage/RestOrderInfo.aspx?OrderId=" + OrderId + "&OrderType=" + OrderType;
        window.open( url, "", "width=700, height=400, status=yes, scrollbars=yes");
    }
    
    var updateOrderState = function( OrderContentIndex, OrderId, State, OrderType ) {
        var Str;
        switch ( State ) {
            case -2: Str = "虚假"; break;
            case -1: Str = "作废"; break;
            case 1: Str = "已完成"; break;
            default: Str = "未知"; break;
        }
        if ( window.confirm("您确定要将此订单状态设置为[ " + Str + " ]吗?") ) {
            var ret = Rest_Manage_RestOrder.UpdateOrderState( OrderId, State, OrderType ).value;
            if ( ret == "0" ) {
                alert("设置成功！");
                switch ( OrderContentIndex ) {
                    case 1 : getTodayOrderList(); break;
                    case 2 : getReservationOrderList(); break;
                    case 3 : getSearchOrderList(); break;
                    case 4 : getBuyerOrderList(); break;
                }
            } else {
                alert( ret );
            }
        }
    }
    
    var copyInfo = function( OrderId, OrderType ) {
        var str = "";
        if ( OrderType == 1 ) {
            var ret = Rest_Manage_RestOrder.GetCommonOrderInfo(OrderId).value;
        } else {
            var ret = Rest_Manage_RestOrder.GetSuiteMenuOrderInfo(OrderId).value;
        }
        if ( ret != null && typeof(ret) == "object" ) {
            var o_DetailInfos = new Array();
            for (var i=0; i<ret.DetailInfos.length; i++) {
                var _DetailInfo = ret.DetailInfos[i];
                for (var j=0; j<_DetailInfo.Amount; j++) {
                    var _obj = new Object();
                    if (OrderType == 1)
                        _obj.MenuName = _DetailInfo.MenuName;
                    else
                        _obj.MenuName = _DetailInfo.MenuName + "(" + _DetailInfo.MenuContent + ")";
                    _obj.Price = _DetailInfo.Price;
                    o_DetailInfos.push(_obj);
                }
            }
        
            for ( var i=0; i<o_DetailInfos.length; i++ ) {
                str += "#" + ret.Id + " " + (i+1) + "/" + o_DetailInfos.length
                    + " 单价：" + formatToMoney( o_DetailInfos[i].Price ) + "元"
                    + " 总价：" + formatToMoney( ret.Total ) + "元"
                    + "\r\n姓名：" + ret.Name
                    + " 电话：" + ret.Phone
                    + "\r\n地址：" + ret.Address
                    + "\r\n送达时间：" + formatDateTimeFromDateStr( ret.DeliverDate, true )
                    + "\r\n餐品内容：" + HtmlEncode( o_DetailInfos[i].MenuName )
                    + "\r\n\r\n";
            }
            try {
                if ( window.clipboardData.setData( "text", str) == true )
                    alert("复制成功！");
                else
                    alert("复制失败！");
            } catch(e) { alert("您的浏览器未支持复制功能！"); }
        } else {
            alert("读取订单数据失败！");
        }
    }
    </script>

    <style type="text/css">
        .NewTable {
            margin-bottom:10px;
        }
        .NewTable th {
            text-align:left;
            background-color:#f5f7ff;
            font-weight:normal;
            color:#369;
        }
        .NewTable .htd {
            width:80px;
            background-color:#F4F4F4;
        }
        .OrderToolbar {
            margin-bottom:5px;
            padding:5px;
            border:1px dotted #ccc;
        }
        .OrderSumInfo {
            margin-bottom:5px;
            padding:5px;
            border:1px dotted #ccc;
            text-align:left;
            background-color:#F3F3F3;
        }
        .OrderSumInfo .Value {
            font-weight:bold;
            color:#f00;
        }
        .OrderPageInfo {
            padding:5px;
            text-align:right;
        }
        #PopOrder
        {
            position:absolute;
            bottom:5px;
            right:5px;
            width:250px;
            height:100px;
            background:url(/images/ddts.gif) no-repeat;
            text-align:left;
            display:none;
        }
        #PopHastenOrder
        {
            position:absolute;
            bottom:5px;
            left:5px;
            width:300px;
            height:240px;
            <%--background:url(/images/ddts.gif) no-repeat;--%>
            background-color:#F3F3F3;
            border:1px solid #ccc;
            text-align:left;
            display:none;
        }
        #PopOrder .Content, #PopHastenOrder .Content
        {
            margin:40px 5px 5px 15px;
        }
    </style>
    <div id="PopOrder">
        <div class="Content">您有&nbsp;<span id="lblNewOrderCount" style="font-weight:bold;color:#f00">0</span>&nbsp;个未处理订单！</div>
    </div>
    <div id="PopHastenOrder">
        <div class="Content">
            <input id="hdHastenOrderId" type="hidden" />
            <span>订单号：</span>
            <span id="lblHastenOrderOrderId" style="font-weight:bold;color:#f00">0</span>
            <br />
            <input name="rdoHastenOrderResult" type="radio" value="1" />
            <span>A：餐品将在5分钟后到达，请您耐心等待!</span>
            <br />
            <input name="rdoHastenOrderResult" type="radio" value="2" />
            <span>B：餐品将在15分钟内到达，请您耐心等待!</span>
            <br />
            <input name="rdoHastenOrderResult" type="radio" value="3" />
            <span>C：餐品将在30分钟内到达，请您耐心等待!</span>
            <br />
            <input name="rdoHastenOrderResult" type="radio" value="4" />
            <span>D：很抱歉，由于订单处理错误，订单取消了，我们将与你联系!</span>
            <br />
            <input id="btnHastenOrderSubmit" type="button" value="提交" />
            <input id="btnHastenOrderCancel" type="button" value="取消" />
        </div>
    </div>
    <div id="tabContainer">
        <ul>
            <li><a href="#tabTodayOrder"><span>今日订单</span></a></li>
            <li><a href="#tabReservationOrder"><span>预定订单</span></a></li>
            <li><a href="#tabSearchOrder"><span>订单查询</span></a></li>
            <li><a href="#tabBuyerOrder"><span>客户查询</span></a></li>
        </ul>
        <div id="tabTodayOrder">
            <div class="OrderToolbar">
                <span>餐馆选择：</span>
                <select id="ddlTodayOrderRest">
                    <option value="0">全部</option>
                </select>
                <span>订单状态：</span>
                <select id="ddlTodayOrderState">
                    <option value="-3">全部</option>
                    <option value="-2">虚假</option>
                    <option value="-1">作废</option>
                    <option value="0">待处理</option>
                    <option value="1">已完成</option>
                </select>
                <span>订单号：</span>
                <input id="tbTodayOrderId" type="text" style="width:100px" maxlength="6" />
                <input id="btnTodayOrderSearch" type="button" value="查询" />
            </div>
            <div class="OrderSumInfo">
                <span>全部金额：</span>
                <span id="lblTodayTotalPrice" class="Value">0.00元</span>
                <span>全部笔数：</span>
                <span id="lblTodayTotalCount" class="Value">0</span>
                <span>成功金额：</span>
                <span id="lblTodaySucceedPrice" class="Value">0.00元</span>
                <span>成功笔数：</span>
                <span id="lblTodaySucceedCount" class="Value">0</span>
                <span>豆丁提成：</span>
                <span id="lblTodayDeductPrice" class="Value">0.00元</span>
            </div>
            <div id="TodayOrderPageNav" class="OrderPageInfo">
            </div>
            <div id="TodayOrderContent">
            </div>
        </div>
        <div id="tabReservationOrder">
            <div class="OrderToolbar">
                <span>餐馆选择：</span>
                <select id="ddlReservationOrderRest">
                    <option value="0">全部</option>
                </select>
                <span>订单状态：</span>
                <select id="ddlReservationOrderState">
                    <option value="-3">全部</option>
                    <option value="-2">虚假</option>
                    <option value="-1">作废</option>
                    <option value="0">待处理</option>
                    <option value="1">已完成</option>
                </select>
                <input id="btnReservationOrderSearch" type="button" value="查询" />
            </div>
            <div id="ReservationOrderNav" class="OrderPageInfo">
            </div>
            <div id="ReservationOrderContent">
            </div>
        </div>
        <div id="tabSearchOrder">
            <div class="OrderToolbar">
                <span>餐馆选择：</span>
                <select id="ddlSearchOrderRest">
                    <option value="0">全部</option>
                </select>
                <span>订单状态：</span>
                <select id="ddlSearchOrderState">
                    <option value="-3">全部</option>
                    <option value="-2">虚假</option>
                    <option value="-1">作废</option>
                    <option value="0">待处理</option>
                    <option value="1">已完成</option>
                </select>
                <span>订单号：</span>
                <input id="tbSearchOrderId" type="text" style="width:100px;" maxlength="6" />
                <br />
                <span>起始时间：</span>
                <input id="tbSearchOrderBeginDeliverDate" type="text" style="width:80px" />
                <span>截止时间：</span>
                <input id="tbSearchOrderEndDeliverDate" type="text" style="width:80px" />
                <input id="btnSearchOrderSearch" type="button" value="查询" />
                <span>时间填写格式：如2007-7-1</span>
            </div>
            <div class="OrderSumInfo">
                <span>全部金额：</span>
                <span id="lblTotalPrice" class="Value">0.00元</span>
                <span>全部笔数：</span>
                <span id="lblTotalCount" class="Value">0</span>
                <span>成功金额：</span>
                <span id="lblSucceedPrice" class="Value">0.00元</span>
                <span>成功笔数：</span>
                <span id="lblSucceedCount" class="Value">0</span>
                <span>豆丁提成：</span>
                <span id="lblDeductPrice" class="Value">0.00元</span>
            </div>
            <div id="SearchOrderNav" class="OrderPageInfo">
            </div>
            <div id="SearchOrderContent">
            </div>
        </div>
        <div id="tabBuyerOrder">
            <div class="OrderToolbar">
                <span>客户名称：</span>
                <input id="tbBuyerOrderName" type="text" />
                <input id="btnBuyerOrderSearch" type="button" value="查询" />
            </div>
            <div id="BuyerOrderNav" class="OrderPageInfo">
            </div>
            <div id="BuyerOrderContent">
            </div>
        </div>
    </div>
</asp:Content>
