﻿<%@ page language="C#" autoeventwireup="true" inherits="Rest_Manage_RestOrderInfo, DoodiiShop" enableEventValidation="false" viewStateEncryptionMode="Never" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>订单管理-查看客户信息</title>
    <link rel="Stylesheet" type="text/css" href="../../css/contain.css" />

    <script type="text/javascript" src="/js/jquery.js"></script>

    <script type="text/javascript" src="/js/Format.js"></script>
<script type="text/javascript" src="/js/func.js"></script>
    <script type="text/javascript" language="javascript">
        var g_OrderType = 0;
        var o_OrderInfo = null;
        var o_DetailInfos = null;
        
        $(document).ready( function(){ init() });
        var init = function() {
            var OrderId = getQueryString("OrderId");
            var OrderType = getQueryString("OrderType");
            if ( isNaN( parseInt( OrderId ) ) ) {
                alert("订单ID错误");
                return;
            }
            OrderId = parseInt( OrderId );
            if ( isNaN( parseInt( OrderType ) ) ) {
                alert("订单类型错误");
                return;
            }
            OrderType = parseInt( OrderType );
            if ( OrderType != 1 && OrderType != 2 ) {
                alert("订单类型错误");
                return;
            }
            g_OrderType = OrderType;
            if ( OrderType == 1 ) {
                var ret = Rest_Manage_RestOrderInfo.GetCommonOrderInfo(OrderId).value;
            } else {
                var ret = Rest_Manage_RestOrderInfo.GetSuiteMenuOrderInfo(OrderId).value;
            }
            if ( ret != null && typeof(ret) == "object" ) {
                o_OrderInfo = ret;
                $("#OrderInfo").get(0).innerHTML = "<a href='javascript:copyAllInfo()'>[复制订单信息]</a>"
                    + "<br><br><strong>姓名：</strong>" + HtmlEncode(ret.Name)
                    + "&nbsp;&nbsp;<strong>电话：</strong>" + HtmlEncode(ret.Phone)
                    + "&nbsp;&nbsp;<strong>地址：</strong>" + HtmlEncode(ret.Address);
                fillDetailData();
            } else {
                alert("读取数据失败");
            }
        }
        
        var fillDetailData = function() {
            o_DetailInfos = new Array();
            for (var i=0; i<o_OrderInfo.DetailInfos.length; i++) {
                var _DetailInfo = o_OrderInfo.DetailInfos[i];
                for (var j=0; j<_DetailInfo.Amount; j++) {
                    var _obj = new Object();
                    if (g_OrderType == 1)
                        _obj.MenuName = _DetailInfo.MenuName;
                    else
                        _obj.MenuName = _DetailInfo.MenuName + "(" + _DetailInfo.MenuContent + ")";
                    _obj.Price = _DetailInfo.Price;
                    o_DetailInfos.push(_obj);
                }
            }
            fillData();
        }
        
       var fillData = function() {
            if ( o_OrderInfo.DetailInfos.length == 0 ) return;
            var tr = $("#ListTable").get(0).insertRow(-1);
            var n = 0;
            for ( var i=0; i<o_DetailInfos.length; i++ ) {
                n++;
                if ( n % 2 == 1 ) var tr = $("#ListTable").get(0).insertRow(-1);
                var td = tr.insertCell(-1);

                td.innerHTML = "#" + o_OrderInfo.Id + "&nbsp;<span style='font-weight:bold;'>" + (i+1) + "/" + o_DetailInfos.length+"</span>"
                    + "&nbsp;总计：<span style='font-weight:bold;'>" + formatToMoney( o_OrderInfo.Total ) + "元</span>"
                    + "<br/>地址：<span style='font-weight:bold'>" + o_OrderInfo.AreaName +"</span> "+o_OrderInfo.RoomName
                    + "<br>姓名：" + HtmlEncode( o_OrderInfo.Name )
                    + "&nbsp;电话：" + HtmlEncode( o_OrderInfo.Phone )
                    + "<br>内容：" + HtmlEncode( o_DetailInfos[i].MenuName )
                    + "<br>时间：<span style='font-weight:bold'>" +o_OrderInfo.DeliverDate.getHours()+":"+ o_OrderInfo.DeliverDate.getMinutes()+"</span>"
                    + "&nbsp;单价：<span style='font-weight:bold'>" + formatToMoney( o_DetailInfos[i].Price ) + "元</span>"
                    +"<br>备注："+HtmlEncode( o_OrderInfo.Note )
                    + "<br><br><a href='javascript:copyInfo(" + i + ",\"" + (i+1) + "/" + o_DetailInfos.length + "\")'>[复制信息]</a>";     
            }
            if (n % 2 == 1) var td = tr.insertCell(-1);
        }
        
        
        var copyInfo = function( i, NoStr ) {
            var str = "#" + o_OrderInfo.Id
                + " " + NoStr +" "+" 总计：" + formatToMoney( o_OrderInfo.Total ) + "元"
                + "\r\n地址："+  HtmlEncode(o_OrderInfo.AreaName +" "+o_OrderInfo.RoomName)
                + "\r\n姓名：" + o_OrderInfo.Name
                + " 电话：" + o_OrderInfo.Phone
                + "\r\n内容：" + HtmlEncode( o_DetailInfos[i].MenuName )
                + "\r\n时间："  +o_OrderInfo.DeliverDate.getHours()+":"+ ((o_OrderInfo.DeliverDate.getMinutes()<10)?"0"+o_OrderInfo.DeliverDate.getMinutes():o_OrderInfo.DeliverDate.getMinutes())
                + " 单价：" + formatToMoney( o_DetailInfos[i].Price ) + "元"
                +"\r\n备注："+HtmlEncode( o_OrderInfo.Note )
                + "\r\n\r\n";
            try {
                if ( copy_clip(str) == true )
                    alert("复制成功！");
                else
                    alert("复制失败！");
            } catch(e) { alert("您的浏览器未支持复制功能！"); }
        }
        
        var copyAllInfo = function() {
            var str = "";
            for (var i=0; i<o_DetailInfos.length; i++) {
                str += "#" + o_OrderInfo.Id + " " + (i+1) + "/" + o_DetailInfos.length
                    + " 总计：" + formatToMoney( o_OrderInfo.Total ) + "元"
                    + "\r\n地址：" +  HtmlEncode(o_OrderInfo.AreaName) +" "+ HtmlEncode(o_OrderInfo.RoomName)
                    + "\r\n姓名：" + o_OrderInfo.Name
                    + " 电话：" + o_OrderInfo.Phone
                    + "\r\n内容：" + HtmlEncode( o_DetailInfos[i].MenuName )
                    + "\r\n时间："  +o_OrderInfo.DeliverDate.getHours()+":"+ ((o_OrderInfo.DeliverDate.getMinutes()<10)?"0"+o_OrderInfo.DeliverDate.getMinutes():o_OrderInfo.DeliverDate.getMinutes())
                    + " 单价：" + formatToMoney( o_DetailInfos[i].Price ) + "元"
                    +"\r\n备注："+HtmlEncode( o_OrderInfo.Note )
                    + "\r\n\r\n";
            }
            try {
                if ( copy_clip(str) == true)
                    alert("复制成功！");
                else
                    alert("复制失败！");
            } catch(e) { alert("您的浏览器未支持复制功能！"); }
        }
    </script>

    <style type="text/css">
        body {
            margin:0px;
            padding:0px;
            background-color:#F3F3F3;
        }
        td {
            padding:0px;
        }
        td a {
            background-color:#E3E3E3;
            border:1px solid #ccc;
        }
        
        #OrderInfo {
            margin:5px;
            padding:5px;
            border-bottom:1px solid #555;
        }
        #OrderDetail {
            margin:5px;
        }
    </style>
</head>
<body>
    <form id="form1" runat="server">
        <div id="OrderInfo">
        </div>
        <div id="OrderDetail">
            <table id="ListTable" class="MyTable" width="100%">
            </table>
        </div>
    </form>
</body>
</html>
