﻿<%@ page language="C#" autoeventwireup="true" inherits="Rest_Manage_RestOrderPrintSubmit1, DoodiiShop" enableEventValidation="false" viewStateEncryptionMode="Never" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>都来订网络外卖订餐系统 - 订单打印预览(3*10无边距)</title>

    <script type="text/javascript" src="../../js/jquery.js"></script>
    <script type="text/javascript" src="../../js/Format.js"></script>

    <script type="text/javascript">
        var gWB = null;
        var gPosition = 1;
        var gOrderList = "";
        var gOrderArr = null;
        var gTotalCount = 0;//总份数
        var oOrderInfos = new Array();//订单缓存
        
        $(document).ready( function(){ init() });
        
        function init()
        {
            gWB = document.getElementById("wb");
            gPosition = parseInt(getQueryString("Position"));
            if (isNaN(gPosition)) gPosition = 1;
            if (gPosition < 1 || gPosition > 30) gPosition = 1;
            gOrderList = getQueryString("OrderList");
            gOrderArr = gOrderList.split("|");
            if (gOrderArr.length == 0)
            {
                alert("没有要打印的订单！");
                return;
            }
            $("#btnPrint").bind("click", function(){ print() });
            $("#btnPrintSetup").bind("click", function(){ printSetup() });
            $("#btnPrintPreview").bind("click", function(){ printPreview() });
            fillData();
        }
        
        function createContainer(OrderId, OrderDetailIndex, OrderCount, Price, Total, Name, Phone, Address, DeliverDate, OrderContent,AreaName,RoomName,Note)
        {
            var divContainer = document.createElement("div");
            
            divContainer.className = "Container";
            divContainer.innerHTML ="#" + OrderId + "&nbsp;<span style='font-weight:bold;'>" + OrderDetailIndex + "/" + OrderCount+"</span>"
                    + "&nbsp;总计：<span style='font-weight:bold;'>" + formatToMoney(Total ) + "元</span>"
                    + "<br/>地址：<span style='font-weight:bold'>" + AreaName +"</span> "+RoomName
                    + "<br>姓名：" + HtmlEncode( Name )
                    + "&nbsp;电话：" + HtmlEncode( Phone )
                    + "<br>内容：" + HtmlEncode( OrderContent )
                    + "<br>时间：<span style='font-weight:bold'>" +DeliverDate.getHours()+":"+ ((DeliverDate.getMinutes()<10)?"0"+DeliverDate.getMinutes():DeliverDate.getMinutes())+"</span>"
                    + "&nbsp;单价：<span style='font-weight:bold'>" + formatToMoney(Price ) + "元</span>"
                    +"<br>备注："+HtmlEncode(Note);
                    
//            divContainer.innerHTML = "#" + OrderId + " " + OrderDetailIndex + "/" + OrderCount
//                + " 单价：" + formatToMoney(Price) + "元 总价：" + formatToMoney(Total) + "元"
//                + "<br />姓名：" + Name
//                + " 电话：" + Phone
//                + "<br />地址：" + Address
//                + "<br />送达时间：" + formatDateTimeFromDateStr(DeliverDate, 1)
//                + "<br />餐品内容：" + OrderContent + "&nbsp;[豆丁网]";
            return divContainer;
        }
        
        function createPart()
        {
            var divPart = document.createElement("div");
            divPart.className = "PagePart";
            return divPart;
        }
        
        function createItem()
        {
            var div = document.createElement("div");
            div.className = "Item";
            return div;
        }
        
        function fillData()
        {
            if (gPosition > 1)
            {
                for (var i = 0; i < gPosition-1; i++)
                {
                    oOrderInfos.push(createItem());
                }
            }
            for (var i = 0; i < gOrderArr.length; i ++)
            {
                var _OrderInfo = gOrderArr[i].split(":");
                var _OrderId = parseInt(_OrderInfo[0]);
                var _OrderType = parseInt(_OrderInfo[1]);
                if (isNaN(_OrderId) || isNaN(_OrderType))
                {
                    alert("订单数据错误！");
                    return;
                }
                if (_OrderType == 1)
                    var ret = Rest_Manage_RestOrderPrintSubmit1.GetCommonOrderInfo(_OrderId).value;
                else
                    var ret = Rest_Manage_RestOrderPrintSubmit1.GetSuiteMenuOrderInfo(_OrderId).value;
                if (ret == null || typeof(ret) != "object")
                {
                    alert("获取订单数据失败");
                    return;
                }
                var _Name = ret.Name;
                var _Phone = ret.Phone;
                var _Total = ret.Total;
                var _Address = ret.Address;
                var _DateTime = ret.DateTime;
                var _DeliverDate = ret.DeliverDate;
                var _OrderCount = 0;
                var _AreaName = ret.AreaName;
                var _RoomName = ret.RoomName;
                var _Note = ret.Note;
                for (var j = 0; j < ret.DetailInfos.length; j++) _OrderCount += parseInt(ret.DetailInfos[j].Amount);
                var _OrderDetailIndex = 0;
                for (var j = 0; j < ret.DetailInfos.length; j++)
                {
                    for (var m = 0; m < ret.DetailInfos[j].Amount; m++)
                    {
                        _OrderDetailIndex++;
                        var _Price = ret.DetailInfos[j].Price;
                        if (_OrderType == 1)
                            var _OrderContent = ret.DetailInfos[j].MenuName;
                        else
                            var _OrderContent = ret.DetailInfos[j].MenuName + "(" + ret.DetailInfos[j].MenuContent + ")";
                        var divItem = createItem();
                        $(divItem).append(createContainer(_OrderId, _OrderDetailIndex, _OrderCount, _Price, _Total, _Name, _Phone, _Address, _DeliverDate, _OrderContent,_AreaName,_RoomName,_Note));
                        oOrderInfos.push(divItem);
                    }
                }
            }
            renderData();
        }
        
        function renderData()
        {
            var divPart = createPart();
            divPart.className = "PagePartFirst";
            for (var i = 1; i <= oOrderInfos.length; i ++)
            {    
                //if (i % 2 == 0) $(oOrderInfos[i-1]).css("background-color", "#f3f3f3");
                divPart.appendChild(oOrderInfos[i-1]);
                if (i == oOrderInfos.length)
                {
                    $("#form1").append(divPart);
                    break;
                }
                if (i % 30 == 0 && i != 1)
                {
                    $("#form1").append(divPart);
                    var divPart = createPart();
                }
            }
        }
        
        function print()
        {
            var isAllow='<%=IsAllow %>';
            if(isAllow=="False")
            {
                alert("您还没有权限使用此功能，请赶快申请许可证。");
                return;
            }
            if (window.confirm("您确定现在开始打印吗?"))
            {
                
                gWB.execwb(6, 6);
            }
        }
        
        function printPreview()
        {
            gWB.execwb(7, 1);
        }
        
        function printSetup()
        {
            gWB.execwb(8, 1);
        }
    </script>

    <style type="text/css">
        body, td
        {
            font-size:12px;
            font-family:'宋体', MS Reference Sans Serif;
        }
        body
        {
            margin:0px;
            padding:0px;
        }
        form
        {
            margin:0px;
            padding:0px;
        }
        .Item
        {
            <%--width:261px;--%>
            width:250px;
            <%--height:111px;--%>
            height:112px;
            <%--height:120px;--%>
            float:left;
            overflow:hidden;
            border:1px solid #ccc;
        }
        .Item .Container
        {
            margin:5px;
        }
        .PagePartFirst
        {
            float:left;
            border:1px solid #ccc;
            margin-top:20px;
        }
        .PagePart
        {
            float:left;
            border:1px solid #ccc;
            margin-top:20px;
        }
        .noprint
        {
            padding:5px;
            text-align:center;
        }
    </style>
    <style type="text/css" media="print">
        .noprint
        {
            display:none;
        }
        .Item
        {
            border:0px;
        }
        .Item .Container
        {
            margin:5px;
        }
        .PagePartFirst
        {
            border:0px;
            float:none;
            margin-top:0px;
        }
        .PagePart
        {
            border:0px;
            float:none;
            page-break-before:always;
            margin-top:0px;
        }
    </style>
</head>
<body>
    <form id="form1" runat="server">
        <object id="wb" height="0" width="0" classid="CLSID:8856F961-340A-11D0-A96B-00C04FD705A2"
            name="wb">
        </object>
        <div class="noprint">
            <input id="btnPrint" type="button" value="直接打印" />
            <input id="btnPrintSetup" type="button" value="页面设置" />
            <input id="btnPrintPreview" type="button" value="打印预览" />
            <hr />
        </div>
    </form>
</body>
</html>
