﻿<%@ page language="C#" autoeventwireup="true" inherits="Rest_Manage_RestOrderPrintSubmit3, DoodiiShop" enableEventValidation="false" viewStateEncryptionMode="Never" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>都来订网络外卖订餐系统 - 订单打印预览</title>

    <script type="text/javascript" src="../../js/jquery.js"></script>
    <script type="text/javascript" src="../../js/Format.js"></script>

    <script type="text/javascript">
        var gWB = null;
        var gOrderList = "";
        var gOrderArr = null;
        var oOrderInfos = new Array();//订单缓存
        
        $(document).ready( function(){ init() });
        
        function init()
        {
            gWB = document.getElementById("wb");
            gOrderList = getQueryString("OrderList");
            gOrderArr = gOrderList.split("|");
            if (gOrderArr.length == 0)
            {
                alert("没有要打印的订单！");
                return;
            }
            $("#btnPrint").bind("click", function(){ print() });
            $("#btnPrintSetup").bind("click", function(){ printSetup() });
            $("#btnPrintPreview").bind("click", function(){ printPreview() });
            fillData();
        }
        
        function fillData()
        {
            for (var i = 0; i < gOrderArr.length; i++)
            {
                var _OrderInfo = gOrderArr[i].split(":");
                var _OrderId = parseInt(_OrderInfo[0]);
                var _OrderType = parseInt(_OrderInfo[1]);
                if (isNaN(_OrderId) || isNaN(_OrderType))
                {
                    alert("订单参数错误!");
                    return;
                }
                if (_OrderType == 1)
                    var ret = Rest_Manage_RestOrderPrintSubmit3.GetCommonOrderInfo(_OrderId).value;
                else
                    var ret = Rest_Manage_RestOrderPrintSubmit3.GetSuiteMenuOrderInfo(_OrderId).value;
                if (ret == null || typeof(ret) != "object")
                {
                    alert("获取订单数据失败");
                    return;
                }
                var orderPart = document.createElement("div");
                orderPart.className = "OrderPart";
                var table = document.createElement("table");
                table.className = "NewTable";
                var tr = table.insertRow(-1);
                var td = tr.insertCell(-1);
                td.innerHTML = "订单号：";
                td.className = "htd";
                var td = tr.insertCell(-1);
                td.innerHTML = _OrderId;
                var td = tr.insertCell(-1);
                td.className = "htd";
                td.innerHTML = "总金额：";
                var td = tr.insertCell(-1);
                td.innerHTML = formatToMoney(ret.Total) + "元";
                var td = tr.insertCell(-1);
                td.className = "htd";
                td.innerHTML = "下单时间：";
                var td = tr.insertCell(-1);
                td.innerHTML = formatDateTimeFromDateStr(ret.DateTime, true);
                var tr = table.insertRow(-1);
                var td = tr.insertCell(-1);
                td.className = "htd";
                td.innerHTML = "姓名：";
                var td = tr.insertCell(-1);
                td.innerHTML = HtmlEncode(ret.Name);
                var td = tr.insertCell(-1);
                td.className = "htd";
                td.innerHTML = "电话：";
                var td = tr.insertCell(-1);
                td.innerHTML = HtmlEncode(ret.Phone);
                var td = tr.insertCell(-1);
                td.className = "htd";
                td.innerHTML = "送达时间：";
                var td = tr.insertCell(-1);
                td.innerHTML = formatDateTimeFromDateStr(ret.DeliverDate, true);
                var tr = table.insertRow(-1);
                var td = tr.insertCell(-1);                
                td.className = "htd";
                td.innerHTML = "送餐地址：";
                var td = tr.insertCell(-1);
                td.colSpan = 5;
                td.align = "left";
                td.innerHTML = HtmlEncode(ret.Address);
                orderPart.appendChild(table);
                var table = document.createElement("table");
                table.className = "NewTable";
                var tr = table.insertRow(-1);
                var th = document.createElement("th");
                th.innerHTML = "餐品内容";
                tr.appendChild(th);
                var th = document.createElement("th");
                th.innerHTML = "份数";
                tr.appendChild(th);
                var th = document.createElement("th");
                th.innerHTML = "单价";
                tr.appendChild(th);
                var th = document.createElement("th");
                th.innerHTML = "小计";
                tr.appendChild(th);
                for (var j = 0; j < ret.DetailInfos.length; j++)
                {
                    var Item = ret.DetailInfos[j];
                    var tr = table.insertRow(-1);
                    var td = tr.insertCell(-1);
                    if (_OrderType == 1)
                        td.innerHTML = HtmlEncode(Item.MenuName);
                    else
                        td.innerHTML = HtmlEncode(Item.MenuName + "(" + Item.MenuContent + ")");
                    var td = tr.insertCell(-1);
                    td.innerHTML = Item.Amount + "份";
                    var td = tr.insertCell(-1);
                    td.innerHTML = formatToMoney(Item.Price) + "元";
                    var td = tr.insertCell(-1);
                    td.innerHTML = formatToMoney(Item.MenuSum) + "元";
                }
                orderPart.appendChild(table);
                $("#form1").append(orderPart);
            }
        }
        
        function print()
        {
            var isAllow='<%=IsAllow %>';
            if(isAllow=="False")
            {
                alert("您还没有权限使用此功能，请赶快申请许可证。");
                return;
            }
            if (window.confirm("您确定现在开始打印吗?"))
            {
                
                gWB.execwb(6, 6);
            }
        }
        
        function printPreview()
        {
            gWB.execwb(7, 1);
        }
        
        function printSetup()
        {
            gWB.execwb(8, 1);
        }
    </script>

    <style type="text/css">
        body, td
        {
            font-size:12px;
            font-family:'宋体', MS Reference Sans Serif;
        }
        body
        {
            margin:10px 10px 15px 10px;
            padding:0px;
            text-align:center;
        }
        form
        {
            margin:0px;
            padding:0px;
        }
        .noprint
        {
            padding:5px;
        }
        .OrderPart
        {
            margin-top:25px;
        }
        table{
	        width:740px;
	        border-collapse:collapse;
        }
        table th{	
	        border:1px solid #ccc;
	        padding:5px;
	        font-weight:bold;
            background-color:#F3F3F3;
        }
        table td{	
	        border:1px solid #ccc;
	        padding:5px;
        }
        table .htd
        {
            font-weight:bold;
            background-color:#F3F3F3;
        }
    </style>
    <style type="text/css" media="print">
        .noprint
        {
            display:none;
        }
    </style>
</head>
<body>
    <form id="form1" runat="server">
        <object id="wb" height="0" width="0" classid="CLSID:8856F961-340A-11D0-A96B-00C04FD705A2"
            name="wb">
        </object>
        <div class="noprint">
            <input id="btnPrint" type="button" value="直接打印" />
            <input id="btnPrintSetup" type="button" value="页面设置" />
            <input id="btnPrintPreview" type="button" value="打印预览" />
            <hr />
        </div>
    </form>
</body>
</html>
