﻿///request:/js/Format.js
var AreaSelector = function(settings)
{
    var me = this;
    
    this.regionArray = [[7, "海淀"], [8, "朝阳"], [9, "东城"], [10, "西城"], [11, "宣武"], [12, "崇文"], [13, "丰台"], [15, "石景山"], [16, "其它区"]];
    this.regionIndex = -1;
    this.regionId = 0;
    this.pageIndex = 1;
    this.pageSize = 8;
    this.keyword = "";
    this.showing = false;
    
    this.parentDom = document.getElementById(settings.parentDomId);
    this.offsetX = settings.offsetX;
    this.offsetY = settings.offsetY;
    this.onRegionChangeFunc = settings.onRegionChangeFunc;
    this.onPageChangeFunc = settings.onPageChangeFunc;
    this.onKeywordChangeFunc = settings.onKeywordChangeFunc;
    this.onSelectAreaFunc = settings.onSelectAreaFunc;
    
    this.divDom = document.createElement("div");
    this.divDom.className = "AreaSelector";
    
    this.divRegionUL = document.createElement("ul");
    this.divRegionUL.className = "AreaSelector_RegionUL";
    this.divDom.appendChild(this.divRegionUL);
    
    this.divAreaUL = document.createElement("ul");
    this.divAreaUL.className = "AreaSelector_AreaUL";
    this.divDom.appendChild(this.divAreaUL);
    
    this.divPageDom = document.createElement("div");
    this.divPageDom.className = "AreaSelector_Page";
    this.divDom.appendChild(this.divPageDom);
    
    this.divToolbarDom = document.createElement("div");
    this.divToolbarDom.className = "AreaSelector_Toolbar";
    this.divToolbarDom.innerHTML = "<span>&nbsp;楼宇搜索：</span>";
    this.tbKeyword = document.createElement("input");
    this.tbKeyword.type = "text";
    this.tbKeyword.maxLength = 20;
    this.tbKeyword.title = "可以输入首拼或全拼进行搜索";
    this.tbKeyword.onkeyup = function(e){ return me.setKeyword(e); }
    this.divToolbarDom.appendChild(this.tbKeyword);
    var a = document.createElement("a");
    a.innerHTML = "关闭";
    a.href = "javascript:void(0)";
    a.onclick = function(){ me.hide() }
    this.divToolbarDom.appendChild(a);
    this.divDom.appendChild(this.divToolbarDom);
    
    document.body.appendChild(this.divDom);
    this.showRegionList();
}
//adjustPosition
AreaSelector.prototype.adjustPosition = function()
{
    var x = 0;
    var y = 0;
    if ($.browser.msie == true)
    {
        if (this.offsetX != undefined)
        {
            x = parseInt(this.offsetX);
            if (isNaN(x) == true) x = 0;
        }
        if (this.offsetY != undefined)
        {
            y = parseInt(this.offsetY);
            if (isNaN(y) == true) y = 0;
        }
    }
    var parentDomHeight = this.parentDom.offsetHeight + 1;
    var clientWidth = document.body.clientWidth;
    var clientHeight = document.body.clientHeight;
    var divDomLeft = this.getPosition(this.parentDom).x + x;
    var divDomTop = this.getPosition(this.parentDom).y + parentDomHeight + y;
    var divDomWidth = parseInt($(this.divDom).css("width"));
    var divDomHeight = parseInt($(this.divDom).css("height"));
    if ((divDomLeft + divDomWidth) > clientWidth) divDomLeft = clientWidth - divDomWidth - 5;
    if ((divDomTop + divDomHeight) > clientHeight) divDomTop = clientHeight - divDomHeight - 5;
    $(this.divDom).css("left", divDomLeft);
    $(this.divDom).css("top", divDomTop);
    
}
//Show or hide
AreaSelector.prototype.show = function()
{
    if (this.showing == true) return;
    this.adjustPosition();
    $(this.divDom).fadeIn();
    this.showing = true;
    if (this.regionIndex == -1) this.setRegion(0);
}

AreaSelector.prototype.hide = function()
{
    if (this.showing == false) return;
    $(this.divDom).fadeOut();
    this.showing = false;
}
//Region
AreaSelector.prototype.showRegionList = function()
{
    var me = this;
    for (var i = 0; i < this.regionArray.length; i++)
    {
        var li = document.createElement("li");
        var a = document.createElement("a");
        a.innerHTML = this.regionArray[i][1];
        a.index = i;
        a.href = "javascript:void(0)";
        a.onclick = function(){ me.setRegion(this.index); }
        li.appendChild(a);
        this.divRegionUL.appendChild(li);
    }
}
AreaSelector.prototype.setRegion = function(index)
{
    index = parseInt(index);
    if (isNaN(index) == true) return;
    if (index < 0 || index > this.regionArray.length-1) return;
    this.regionIndex = index;
    this.regionId = parseInt(this.regionArray[index][0]);
    this.pageIndex = 1;
    for (var i = 0; i < this.divRegionUL.childNodes.length; i++)
    {
        if (index == i)
            this.divRegionUL.childNodes[i].childNodes[0].className = "cur";
        else
            this.divRegionUL.childNodes[i].childNodes[0].className = "";
    }
    this.divDom.focus();
    if (this.onRegionChangeFunc != undefined) this.onRegionChangeFunc(index);
}
//Page
AreaSelector.prototype.setPage = function(pageIndex)
{
    this.pageIndex = parseInt(pageIndex);
    if (isNaN(this.pageIndex) == true) this.pageIndex = 1;
    if (this.pageIndex < 1) this.pageIndex = 1;
    if (this.onPageChangeFunc != undefined) this.onPageChangeFunc(pageIndex);
}
AreaSelector.prototype.showPage = function(pageCount)
{
    var me = this;
    $(this.divPageDom).children("a").each( function(){ $(this).unbind("click"); });
    this.divPageDom.innerHTML = "";
    pageCount = parseInt(pageCount);
    if (isNaN(pageCount) == true) pageCount = 1;
    if (pageCount < 1) pageCount = 1;
    if (this.pageIndex > pageCount) this.pageIndex = pageCount;
    if (this.pageIndex > 1)
    {
        var a = document.createElement("a");
        a.innerHTML = "上一页";
        a.pageIndex = this.pageIndex - 1;
        a.href = "javascript:void(0)";
        a.onclick = function(){ me.setPage(this.pageIndex); }
        this.divPageDom.appendChild(a);
    }
    if (this.pageIndex < pageCount)
    {
        var a = document.createElement("a");
        a.innerHTML = "下一页";
        a.pageIndex = this.pageIndex + 1;
        a.href = "javascript:void(0)";
        a.onclick = function(){ me.setPage(this.pageIndex); }
        this.divPageDom.appendChild(a);
    }
    var span = document.createElement("span");
    span.innerHTML += this.pageIndex + "/" + pageCount;
    this.divPageDom.appendChild(span);
}
//Area
AreaSelector.prototype.setArea = function(areaId, areaName, deliveryMoney, responseTime)
{
    if (this.onSelectAreaFunc != undefined)
    {
        this.onSelectAreaFunc(
        {
            areaId: areaId,
            areaName: areaName,
            regionId: this.regionArray[this.regionIndex][0],
            regionName: this.regionArray[this.regionIndex][1],
            deliveryMoney: deliveryMoney,
            responseTime: responseTime
        });
    }
}
AreaSelector.prototype.clearAreaResult = function()
{
    for (var i = 0; i < this.divAreaUL.childNodes.length; i++)
    {
        $(this.divAreaUL.childNodes[i].childNodes[0]).unbind("click");
    }
    this.divAreaUL.innerHTML = "";
}
AreaSelector.prototype.appendArea = function(areaId, areaName, deliveryMoney, responseTime)
{
    var me = this;
    var li = document.createElement("li");
    var a = document.createElement("a");
    a.innerHTML = cutString(HtmlEncode(areaName), 24);
    a.title = areaName;
    a.href = "javascript:void(0)";
    $(a).bind("click", function(){ me.setArea(areaId, areaName, deliveryMoney, responseTime) });
    li.appendChild(a);
    this.divAreaUL.appendChild(li);
}
AreaSelector.prototype.setMessage = function(s)
{
    for (var i = 0; i < this.divAreaUL.childNodes.length; i++)
    {
        $(this.divAreaUL.childNodes[i].childNodes[0]).unbind("click");
    }
    this.divAreaUL.innerHTML = "<li>" + s + "</li>";
}
//keyword
AreaSelector.prototype.setKeyword = function(e)
{
    this.keyword = this.tbKeyword.value;
    var evt = window.event || e;
    var keyCode = evt.keyCode || evt.which;
    if (keyCode == 13) return true;
    this.pageIndex = 1;
    if (this.onKeywordChangeFunc != undefined) this.onKeywordChangeFunc(this.keyword);
}
//Other
AreaSelector.prototype.cutString = function(bfTitleCharsSource, bfTitleLen)
{
    if(bfTitleCharsSource.replace(/[^\x00-\xff]/g,"xx").length <= bfTitleLen)
    {
        return bfTitleCharsSource;
    }

    var str = "";
    var l = 0;
    var bfTitleChars;
    for(var i=0; bfTitleChars=bfTitleCharsSource.charAt(i); i++)
    {
        str += bfTitleChars;
        l += (bfTitleChars.match(/[^\x00-\xff]/) != null ? 2 : 1);
        if(l >= bfTitleLen)
        {
            str += "...";
            break;
        }
    }
    return str;
}
AreaSelector.prototype.getPosition = function(obj)
{
    var x = y = 0;
    do
    {
        x += obj.offsetLeft;
        y += obj.offsetTop;
    }
    while (obj = obj.offsetParent);
    return {"x":x,"y":y};
}