﻿///request:/js/Format.js
var AreaSelector2 = function(settings)
{
    var me = this;
    
    //this.regionArray = [[0,"全部",1],[7, "海淀",1], [8, "朝阳",1], [9, "东城",0], [10, "西城",0], [11, "宣武",0], [12, "崇文",0], [13, "丰台",0], [15, "石景山",0], [16, "其它区",0]];
    this.regionArray=[[0,"全部",1]];
    this.listersArray = ["A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","W","X","Y","Z"];
    this.pageStyle = 0;//分页样式:0默订,1分页控件
    this.isBtnSearch = false;
    this.lettersIndex = 0;
    
    this.regionIndex = -1;
    this.regionId = 0;
    this.pageIndex = 1;
    this.pageSize = 40;
    this.keyword = "";
    this.showing = false;
    
    this.parentDom = document.getElementById(settings.parentDomId);   
        
    this.offsetX = settings.offsetX;
    this.offsetY = settings.offsetY;
    this.onRegionChangeFunc = settings.onRegionChangeFunc;
    this.onPageChangeFunc = settings.onPageChangeFunc;
    this.onKeywordChangeFunc = settings.onKeywordChangeFunc;
    this.onSelectAreaFunc = settings.onSelectAreaFunc;
    this.onLettersChangeFunc = settings.onLettersChangeFunc;
    if (settings.onClearFunc != undefined)
        this.onClearFunc = settings.onClearFunc;  
    if (settings.onClosedFunc != undefined)  
        this.onClosedFunc = settings.onClosedFunc;
    if (settings.pageStyle != undefined)
        this.pageStyle = settings.pageStyle;
    this.divToolbarDomContent = settings.divToolbarDomContent;//搜索框后文字
    if (settings.isBtnSearch != undefined)//是否显示搜索按钮
        this.isBtnSearch = settings.isBtnSearch
    
    this.divDom = document.createElement("div");
    this.divDom.className = "AreaSelector2";
    
    this.divTitle = document.createElement("div");
    this.divTitle.innerHTML = "请在本店送餐楼宇范围内选择";
    this.divTitle.className = "AreaSelector2_title";
    /*关闭按钮*/
    this.btnClose = document.createElement("a");
    this.btnClose.className = "BtnClose";
    this.btnClose.innerHTML = "关闭";
    $(this.btnClose).css("color", "#FFFFFF");
    this.btnClose.href = "javascript:void(0)";
    this.btnClose.onclick = function(){ me.close() }
    this.divDom.appendChild(this.btnClose);
    
    this.divDom.appendChild(this.divTitle);
    
    this.divRegionUL = document.createElement("ul");
   // this.divRegionUL.className = "AreaSelector2_RegionUL";
   // this.divDom.appendChild(this.divRegionUL);
    
    /*搜索*/
    this.divToolbarDom = document.createElement("div");
    this.divToolbarDom.className = "AreaSelector2_Toolbar";    
    
    this.divToolbarDomLeft = document.createElement("div");
    $(this.divToolbarDomLeft).css("float","left");
    this.divToolbarDomLeft.innerHTML = "<span style='font-weight:bold;'>&nbsp;&nbsp;楼宇搜索：</span>";    
    
    this.tbKeyword = document.createElement("input");
    this.tbKeyword.type = "text";
    this.tbKeyword.className = "tbKeyword";
    this.tbKeyword.maxLength = 20;
    this.tbKeyword.title = "可以输入首拼或全拼进行搜索";  
    this.tbKeyword.onkeyup = function(e){ return me.setKeyword(e); }   
    this.divToolbarDomLeft.appendChild(this.tbKeyword);
    
    if (this.isBtnSearch)
    {
        this.btnSearch = document.createElement("input");
        this.btnSearch.type = "button";
        this.btnSearch.value = "搜索";
        this.btnSearch.style.width = "50px";
        this.btnSearch.onclick = function(){ return me.btnSearch_click(); }
        this.divToolbarDomLeft.appendChild(this.btnSearch);  
    }
    if (this.onClearFunc != undefined)
    {
        //清空
        var a = document.createElement("a");
        a.innerHTML = "清空";
        a.href = "javascript:void(0);";
        a.onclick = this.onClearFunc;
        this.divToolbarDom.appendChild(a);
    }
    
    
    this.divToolbarDomText = document.createElement("span");    
    $(this.divToolbarDomText).css("float","left");
    if (this.divToolbarDomContent != undefined)
    {
        this.divToolbarDomText.innerHTML = this.divToolbarDomContent;
    }
    else
    {
        this.divToolbarDomText.innerHTML = "<span style='color:#999;'>&nbsp;&nbsp;如果楼宇太多，不方便查找您可以直接在这里搜索。</span>";
    }
    this.divToolbarDom.appendChild(this.divToolbarDomLeft);
    this.divToolbarDom.appendChild(this.divToolbarDomText);
    this.divDom.appendChild(this.divToolbarDom);  
    
    
    /*拼音父列表*/
    /*this.divLettersParent = document.createElement("div");
    $(this.divLettersParent).css("float","left");
    this.divDom.appendChild(this.divLettersParent);*/
    
    this.divLettersText = document.createElement("div");
    //$(this.divLettersText).css("float","left",);    
    this.divLettersText.className = "AreaSelector2_divLettersText";
    this.divLettersText.innerHTML = "<span style='font-weight:bold;'>拼音索引：</span>";
    this.divDom.appendChild(this.divLettersText); 
                
    /*拼音列表*/
    this.divLettersUL = document.createElement("ul");
    this.divLettersUL.className = "AreaSelector2_LettersUL";
    this.divDom.appendChild(this.divLettersUL); 
    
    this.divAreaUL = document.createElement("ul");
    this.divAreaUL.className = "AreaSelector2_AreaUL";    
    this.divDom.appendChild(this.divAreaUL);
    
    this.divPageDom = document.createElement("div");
    this.divPageDom.id = "AreaSelector2_divPage";
    this.divPageDom.className = "AreaSelector2_Page";
    this.divDom.appendChild(this.divPageDom);
    
      
    document.body.appendChild(this.divDom);
    this.showRegionList();
    this.showLettersList();
    if (this.pageStyle == 1) this.oNav = new vensonNav("AreaSelector2_divPage", me.onPageChangeFunc);    
}

/*拼音列表 开始*/
AreaSelector2.prototype.showLettersList = function()
{
    var me = this;
    
    for (var i = 0; i < this.listersArray.length; i++)
    {
        //this.listersArray[i] = String.fromCharCode(65+i);
        var li = document.createElement("li");
        var a = document.createElement("a");
        a.innerHTML = this.listersArray[i];
        a.index = i;
        a.href = "javascript:void(0)";
        a.onclick = function(){ me.setLetters(this.index); }
        li.appendChild(a);
        this.divLettersUL.appendChild(li);
    }
}
AreaSelector2.prototype.setLetters = function(index)
{
    index = parseInt(index);
    if (isNaN(index) == true) return;        
    this.lettersIndex = index;       
    if (index < 0 || index > this.listersArray.length-1)
    {
        this.letter = "";
    }
    else
    {
        this.letter = this.listersArray[index];
    }
    for (var i = 0; i < this.listersArray.length; i++)
    {
        if (index == i)
            this.divLettersUL.childNodes[i].childNodes[0].className = "AreaSelector2_LettersUL_cur";
        else
            this.divLettersUL.childNodes[i].childNodes[0].className = "";
    }
    if (index>-1)
    {
        this.tbKeyword.value = "";
        this.keyword = "";
        if (this.onLettersChangeFunc != undefined) this.onLettersChangeFunc(this.letter);
    }    
}

/*拼音列表 结束*/

//adjustPosition
AreaSelector2.prototype.adjustPosition = function()
{ 
    if (this.parentDom == null)
    {//定位中心       
        var el = this.divDom;
        //var width = parseInt($(this.divDom).css("width"));
        var width = 760;
        //var height = parseInt($(this.divDom).css("Height"));
        var height = 366;
        var divDomLeft = (document.documentElement.scrollWidth/2)  - (width/2);
        var divDomTop = (document.documentElement.clientHeight/2 + document.documentElement.scrollTop - height/2);
        if (divDomTop < 0) divDomTop = 1;
        $(this.divDom).css("left", divDomLeft + "px");
        $(this.divDom).css("top", divDomTop + "px"); 
    }
    else
    {
        var x = 0;
        var y = 0;
        if ($.browser.msie == true)
        {
            if (this.offsetX != undefined)
            {
                x = parseInt(this.offsetX);
                if (isNaN(x) == true) x = 0;
            }
            if (this.offsetY != undefined)
            {
                y = parseInt(this.offsetY);
                if (isNaN(y) == true) y = 0;
            }
        }
        var parentDomHeight = this.parentDom.offsetHeight + 1;
        var clientWidth = document.body.clientWidth;
        var clientHeight = document.body.clientHeight;
        var divDomLeft = this.getPosition(this.parentDom).x + x;
        var divDomTop = this.getPosition(this.parentDom).y + parentDomHeight + y;
        var divDomWidth = parseInt($(this.divDom).css("width"));
        var divDomHeight = parseInt($(this.divDom).css("Height"));
        if ((divDomLeft + divDomWidth) > clientWidth) divDomLeft = clientWidth - divDomWidth - 5;
        if ((divDomTop + divDomHeight) > clientHeight) divDomTop = clientHeight - divDomHeight - 5;
        $(this.divDom).css("left", divDomLeft);
        $(this.divDom).css("top", divDomTop);    
    } 
}
//Show or hide
AreaSelector2.prototype.show = function()
{
    if (this.showing == true) return;    
    this.adjustPosition();
    $(this.divDom).fadeIn();    
    this.showing = true;
    if (this.regionIndex == -1) this.setRegion(0);
}
AreaSelector2.prototype.close = function()
{
    this.hide();
    if (this.onClosedFunc != undefined) this.onClosedFunc();
}
AreaSelector2.prototype.hide = function()
{
    if (this.showing == false) return;
    $(this.divDom).fadeOut();
    this.showing = false;    
}
//Region
AreaSelector2.prototype.showRegionList = function()
{
    var me = this;
    for (var i = 0; i < this.regionArray.length; i++)
    {
        var li = document.createElement("li");
        if (this.regionArray[i][2]==1)
        {
            var a = document.createElement("a");
            a.innerHTML = this.regionArray[i][1];
            a.index = i;
            a.href = "javascript:void(0)";            
            a.onclick = function(){ me.setRegion(this.index); }            
            li.appendChild(a);
        }
        else
        {            
            var sp = document.createElement("span");
            sp.innerHTML = this.regionArray[i][1];
            sp.index = i;
            sp.className = "AreaSelector2_RegionUL_disableCur";
            li.appendChild(sp);
        }
        //this.divRegionUL.appendChild(li);
    }
}
AreaSelector2.prototype.setRegion = function(index,noExec)
{
    index = parseInt(index);
    if (isNaN(index) == true) return;
    if (index < 0 || index > this.regionArray.length-1) return;
    this.regionIndex = index;
    this.regionId = parseInt(this.regionArray[index][0]);
    this.pageIndex = 1;
    this.setLetters(-1);
    for (var i = 0; i < this.divRegionUL.childNodes.length; i++)
    {
        if (index == i)
            this.divRegionUL.childNodes[i].childNodes[0].className = "AreaSelector2_RegionUL_cur";
        else if (this.regionArray[i][2] == 1)        
            this.divRegionUL.childNodes[i].childNodes[0].className = "";
    }
    //this.divDom.focus();
    if (noExec == null)
    {    
        this.tbKeyword.value = "";
        this.keyword = "";
        if (this.onRegionChangeFunc != undefined) this.onRegionChangeFunc(index);        
    }
}
//Page
AreaSelector2.prototype.setPage = function(pageIndex)
{
    var me = this;
    this.pageIndex = parseInt(pageIndex);
    if (isNaN(this.pageIndex) == true) this.pageIndex = 1;
    if (this.pageIndex < 1) this.pageIndex = 1;
    //alert("SETPAGE:" + me.onPageChangeFunc);
    if (this.onPageChangeFunc != undefined) this.onPageChangeFunc(pageIndex);
}
AreaSelector2.prototype.showPage = function(pageCount)
{    
    pageCount = parseInt(pageCount);
    if (isNaN(pageCount) == true) pageCount = 1;
    if (pageCount < 1) pageCount = 1;
    if (this.pageIndex > pageCount) this.pageIndex = pageCount;   
     
    if (this.pageStyle == 1)
    {       
       this.oNav.render(this.pageIndex, pageCount); return ;
    }
    
    var me = this;
    $(this.divPageDom).children("a").each( function(){ $(this).unbind("click"); });
    this.divPageDom.innerHTML = "";  
    
    if (this.pageIndex > 1)
    {
        var a = document.createElement("a");
        a.innerHTML = "上一页";
        a.pageIndex = this.pageIndex - 1;
        a.href = "javascript:void(0)";
        a.onclick = function(){ me.setPage(this.pageIndex); }
        this.divPageDom.appendChild(a);
    }
    if (this.pageIndex < pageCount)
    {
        var a = document.createElement("a");
        a.innerHTML = "下一页";
        a.pageIndex = this.pageIndex + 1;
        a.href = "javascript:void(0)";
        a.onclick = function(){ me.setPage(this.pageIndex); }
        this.divPageDom.appendChild(a);
    }
    var span = document.createElement("span");
    span.innerHTML += this.pageIndex + "/" + pageCount;
    this.divPageDom.appendChild(span);
}
//Area
AreaSelector2.prototype.setArea = function(areaId, areaName,areaAddress,areaPhotoId)
{
    if (this.onSelectAreaFunc != undefined)
    {
        this.onSelectAreaFunc(
        {
            areaId: areaId,
            areaName: areaName,
            areaAddress: areaAddress,
            areaPhotoId: areaPhotoId,
            regionId: this.regionArray[this.regionIndex][0],
            regionName: this.regionArray[this.regionIndex][1]            
        });
    }
}
AreaSelector2.prototype.clearAreaResult = function()
{
    for (var i = 0; i < this.divAreaUL.childNodes.length; i++)
    {
        $(this.divAreaUL.childNodes[i].childNodes[0]).unbind("click");
    }
    this.divAreaUL.innerHTML = "";
}
AreaSelector2.prototype.appendArea = function(areaId, areaName,areaAddress,areaPhotoId)
{
    var me = this;
    var li = document.createElement("li");
    var a = document.createElement("a");
    a.innerHTML = cutString(HtmlEncode(areaName), 20);
    a.title = areaName;
    a.href = "javascript:void(0)";
    $(a).bind("click", function(){ ;me.setArea(areaId, areaName,areaAddress,areaPhotoId) });
    li.appendChild(a);
    this.divAreaUL.appendChild(li);
}
AreaSelector2.prototype.setMessage = function(s)
{
    for (var i = 0; i < this.divAreaUL.childNodes.length; i++)
    {
        $(this.divAreaUL.childNodes[i].childNodes[0]).unbind("click");
    }
    this.divAreaUL.innerHTML = "<li style='border:0px solid #FFF;width:730px;'>" + s + "</li>";
}
//keyword
AreaSelector2.prototype.setKeyword = function(e)
{
    this.keyword = this.tbKeyword.value;
    var evt = window.event || e;
    var keyCode = evt.keyCode || evt.which;
    if (keyCode == 13) return true;
    this.pageIndex = 1;
    //this.setLetters(-1);
    this.setRegion(0,true);
    //this.tbKeyword.focus();
    if (this.onKeywordChangeFunc != undefined) this.onKeywordChangeFunc(this.keyword);
}
AreaSelector2.prototype.btnSearch_click = function()
{
    this.keyword = this.tbKeyword.value;
    this.pageIndex = 1;
    this.setLetters(-1);
    
    if (this.onKeywordChangeFunc != undefined) this.onKeywordChangeFunc(this.keyword);
}
//Other
AreaSelector2.prototype.cutString = function(bfTitleCharsSource, bfTitleLen)
{
    if(bfTitleCharsSource.replace(/[^\x00-\xff]/g,"xx").length <= bfTitleLen)
    {
        return bfTitleCharsSource;
    }

    var str = "";
    var l = 0;
    var bfTitleChars;
    for(var i=0; bfTitleChars=bfTitleCharsSource.charAt(i); i++)
    {
        str += bfTitleChars;
        l += (bfTitleChars.match(/[^\x00-\xff]/) != null ? 2 : 1);
        if(l >= bfTitleLen)
        {
            str += "...";
            break;
        }
    }
    return str;
}
AreaSelector2.prototype.getPosition = function(obj)
{
    var x = y = 0;
    do
    {
        x += obj.offsetLeft;
        y += obj.offsetTop;
    }
    while (obj = obj.offsetParent);
    return {"x":x,"y":y};
}