﻿//Author:Venson
var vensonNav = function(parentDomId, callbackFuncName)
{
    this.renderType = 1;
    this.parentDom = document.getElementById(parentDomId);
    this.parentDom.innerHTML = "";
    this.callbackFuncName = callbackFuncName;
    this.pageIndex = 1;
    this.pageCount = 0;
    this.divDom = document.createElement("div");
    this.divDom.className = "PageNavigator";
    this.parentDom.appendChild(this.divDom);
}

vensonNav.prototype.setPageIndex = function(pageIndex)
{
    this.pageIndex = parseInt(pageIndex);
    if (isNaN(this.pageIndex) == true) this.pageIndex = 1;
    if (this.pageIndex < 1) this.pageIndex = 1;
    this.pageCount = 0;
    if (typeof this.callbackFuncName == "string")
        eval(this.callbackFuncName + "(" + this.pageIndex + ")");
    else
    {
        this.callbackFuncName( this.pageIndex);
    }
        
}

vensonNav.prototype.render = function(pageIndex, pageCount)
{
    $(this.divDom).children("a").each( function() { $(this).unbind("click") } );
    this.divDom.innerHTML = "";
    this.pageIndex = parseInt(pageIndex);
    if (isNaN(this.pageIndex) == true) this.pageIndex = 1;
    if (this.pageIndex < 1) this.pageIndex = 1;
    this.pageCount = parseInt(pageCount);
    if (isNaN(this.pageCount) == true) this.pageCount = 0;
    if (this.pageCount < 0) this.pageCount = 0;
    if (this.pageCount == 0)
    {
        //alert("error: page count can not be 0!");
        return false;
    }
    if (this.pageIndex > this.pageCount)
    {
        //alert("error: page index over page count!");
        return false;
    }
    if (this.renderType == 1)
        this.renderByTypeA();
    else
        this.renderByTypeB();
}

vensonNav.prototype.createNewPage = function(pageIndex, pageTitle, alt)
{
    var me = this;
    var a = document.createElement("a");
    a.href = "javascript:void(0)";
    a.pageIndex = pageIndex;
    a.innerHTML = pageTitle;
    if (alt != undefined)
        a.title = alt;
    else
        a.title = "点击转到第『" + pageIndex + "』页";
    if (pageIndex == this.pageIndex && pageIndex == pageTitle)
    {
        a.title = "当前为第『" + pageIndex + "』页";
        a.className = "cur";
    }
    else
        $(a).bind("click", function(){ me.setPageIndex(this.pageIndex) });
    return a;
}

vensonNav.prototype.createNewText = function(text, disabled)
{
    var span = document.createElement("span");
    span.innerHTML = text;
    if (disabled == true) span.className = "disabled";
    return span;
}

vensonNav.prototype.renderByTypeA = function()
{
    var me = this;
    //startIndex and endIndex
    var startIndex = this.pageIndex - 5;
    var endIndex = this.pageIndex + 4;
    if (startIndex < 4)
    {
        startIndex = 1;
        endIndex = 10;
        if (endIndex > this.pageCount) endIndex = this.pageCount;
    }
    else if (endIndex > this.pageCount - 3)
    {
        endIndex = this.pageCount;
        startIndex = this.pageCount - 9;
        if (startIndex < 1) startIndex = 1;
    }
    //prevoius
    if (this.pageIndex > 1)
        this.divDom.appendChild(this.createNewPage(this.pageIndex-1, "&laquo;上一页", "点击转到上一页"));
    else
        this.divDom.appendChild(this.createNewText("&laquo;上一页", true));
    //first
    if (startIndex > 3)
    {
        this.divDom.appendChild(this.createNewPage(1, 1));
        this.divDom.appendChild(this.createNewPage(2, 2));
        this.divDom.appendChild(this.createNewText("&hellip;"));
    }
    //mid
    for (var i = startIndex; i <= endIndex; i++)
        this.divDom.appendChild(this.createNewPage(i, i));
    //Last
    if (endIndex < this.pageCount - 2)
    {
        this.divDom.appendChild(this.createNewText("&hellip;"));
        this.divDom.appendChild(this.createNewPage(this.pageCount-1, this.pageCount-1));
        this.divDom.appendChild(this.createNewPage(this.pageCount, this.pageCount));
    }
    //next
    if (this.pageIndex < this.pageCount)
        this.divDom.appendChild(this.createNewPage(this.pageIndex+1, "下一页&raquo;", "点击转到下一页"));
    else
        this.divDom.appendChild(this.createNewText("下一页&raquo;", true));
}

vensonNav.prototype.renderByTypeB = function()
{
    var me = this;
    for (var i = this.pageIndex - 2; i < this.pageIndex; i++)
    {
        if (i > 0) this.divDom.appendChild(this.createNewPage(i, i));
    }
    this.divDom.appendChild(this.createNewPage(this.pageIndex, this.pageIndex));
    for (var i = this.pageIndex + 1; i <= this.pageIndex + 2; i++)
    {
        if (i <= this.pageCount) this.divDom.appendChild(this.createNewPage(i, i));
    }
    this.divDom.appendChild(this.createNewText("共" + this.pageCount + "页"));
}