﻿//Suggest
//Request: Format.js
var Suggest = function(bindDomId, onActiveFunc, onSubmitFunc)
{
    this.lastKeyword = "";
    this.bindDom = document.getElementById(bindDomId);
    this.onActiveFunc = onActiveFunc
    this.onSubmitFunc = onSubmitFunc;
    this.dom = null;
    this.ulDom = null;
    this.pageIndex = 1;
    this.items = new Array();
    this.itemIndex = -1;
    this.Init();
    this.BindEvent();
}

Suggest.prototype.Init = function()
{
    var me = this;
    //this.parentDom.value = "";
    this.dom = document.createElement("div");
    this.dom.className = "Suggest";
    var divToolbar = document.createElement("div");
    divToolbar.className = "Toolbar";
    var a = document.createElement("a");
    a.innerHTML = "（ESC）[关闭]";
    a.onclick = function(){ me.Clear(); }
    divToolbar.appendChild(a);
    this.dom.appendChild(divToolbar);    
    this.ulDom = document.createElement("ul");
    this.dom.appendChild(this.ulDom);
    document.body.appendChild(this.dom);    
    //this.Clear();
}
Suggest.prototype.BindEvent = function()
{
    var me = this;
    this.bindDom.onkeyup = function(e)
    {
        var evt = window.event || e;
		var keyCode = evt.keyCode || evt.which;
	    if (keyCode == 40)//down
	    {
	        return;
	        me.SetItemIndex(me.itemIndex + 1);
	        return;
	    }
	    if (keyCode == 38)//up
	    {
	        return;
	        me.SetItemIndex(me.itemIndex - 1);
	        return;
	    }
	    if (keyCode == 13)//enter
	    {
	        if (me.itemIndex > -1)
	            me.Select();
	        //else
	            //me.procSubmitEvent();
	        return;
	    }
	    if (keyCode == 27)//esc
	    {
	        me.Clear();
	        return;
	    }
	    if (keyCode == 37) return;//left
	    if (keyCode == 39) return;//right
        me.ProcActiveEvent();
    }
    this.bindDom.onkeypress = function(e)
    {
        var evt = window.event || e;
		var keyCode = evt.keyCode || evt.which;
		if (keyCode == 13) return false;
    }
}
Suggest.prototype.ProcActiveEvent = function()
{
    var s = this.bindDom.value;
    if (s == this.lastKeyword) return;
    this.lastKeyword = s;
    this.onActiveFunc(this.bindDom.value);
}
Suggest.prototype.ProcSubmitEvent = function()
{
    this.Clear();
    this.onSubmitFunc();
}
Suggest.prototype.Append = function(text, eventTag)
{
    var me = this;
    if (this.ulDom.childNodes.length == 0) this.Show();
    var obj = new Object();
    obj.text = text;
    obj.eventTag = eventTag;
    this.items.push(obj);
    var index = this.items.length-1;
    var li = document.createElement("li");
    li.innerHTML = HtmlEncode(obj.text);
    li.onmouseover = function(){ me.SetItemIndex(index); }
    li.onclick = function(){ me.Select(); }
    $(this.ulDom).append(li);
}
Suggest.prototype.Clear = function()
{
    this.items.clear();
    this.Hide();
    this.itemIndex = -1;
    this.ulDom.innerHTML = "";
}
Suggest.prototype.SetItemIndex = function(index)
{
    if (this.ulDom.childNodes.length == 0) return;
    if (index < 0) index = 0;
    if (index > this.items.length - 1) index = this.items.length - 1;
    this.itemIndex = index;
    for (var i = 0; i < this.ulDom.childNodes.length; i++)
        this.ulDom.childNodes[i].className = "";
    this.ulDom.childNodes[this.itemIndex].className = "current";
}
Suggest.prototype.Select = function()
{
    if (this.itemIndex > -1)
    {
        eval(this.items[this.itemIndex].eventTag);
        this.Clear();
    }
}
Suggest.prototype.Show = function()
{
    var x = 0;
    var y = 0;
    var domWidth = this.bindDom.offsetWidth;
    var domHeight = this.bindDom.offsetHeight + 1;
    var domLeft = this.GetPosition(this.bindDom).x + x;
    var domTop = this.GetPosition(this.bindDom).y + domHeight + y;
    this.dom.style.left = domLeft + "px";
    this.dom.style.top = domTop + "px";
    this.dom.style.width = domWidth + "px";
    this.dom.style.display = "block";
    this.itemIndex = -1;
}
Suggest.prototype.Hide = function()
{
    this.dom.style.display = "none";
}
Suggest.prototype.GetPosition = function(obj)
{
    var x = y = 0;
    do
    {
        x += obj.offsetLeft;
        y += obj.offsetTop;
    }
    while (obj = obj.offsetParent);
    return {"x":x,"y":y};
}