﻿//suggest
//request jquery.js
var suggest = function(parentDomId, activeEventName, submitEventName)
{
    this.parentDom = document.getElementById(parentDomId);
    this.activeEventName = activeEventName;
    this.submitEventName = submitEventName;
    this.contentDom = null;
    this.ulDom = null;
    this.pageIndex = 1;
    this.items = new Array();
    this.itemIndex = -1;
    this.init();
    this.bindEvent();
}



//初始化
suggest.prototype.init = function()
{
    var me = this;
    //this.parentDom.value = "";
    this.contentDom = document.createElement("div");
    this.contentDom.className = "suggest";
    var pWidth = this.getSize(this.parentDom).w;
    var pHeight = this.getSize(this.parentDom).h;
    var pTop = this.getPosition(this.parentDom).y;
    pTop = this.parentDom.offsetHeight+1;
    var p = this.parentDom;
    for (; p; p = p.offsetParent) pTop  += p.offsetTop;
    var pLeft = this.getPosition(this.parentDom).x;
    $(this.contentDom).css("top", pTop+ "px");
    $(this.contentDom).css("left", (pLeft - 2) + "px");
    $(this.contentDom).css("width", (pWidth + 4) + "px");
    var divToolbar = document.createElement("div");
    divToolbar.className = "toolbar";
    var a = document.createElement("a");
    $(a).html("(ESC) [关闭]");
    $(a).bind("click", function(){ me.clear() });
    $(divToolbar).append(a);
    $(this.contentDom).append(divToolbar);
    this.ulDom = document.createElement("ul");
    $(this.contentDom).append(this.ulDom);
    $(document.body).append(this.contentDom);
    this.clear();
}

//调整位置
suggest.prototype.adjustPosition = function(offsetX, offsetY)
{
    var pHeight = this.getSize(this.parentDom).h;
    var pTop = this.getPosition(this.parentDom).y;
    pTop = this.parentDom.offsetHeight+1;
    var p = this.parentDom;
    for (; p; p = p.offsetParent) pTop  += p.offsetTop;
    var pLeft = this.getPosition(this.parentDom).x;
    $(this.contentDom).css("top", (pTop + offsetY) + "px");
    //$(this.contentDom).css("left", (pLeft - 2 + offsetX) + "px");
}

//事件绑定
suggest.prototype.bindEvent = function()
{
    var me = this;
    this.parentDom.onkeyup = function(e)
    {
        var evt = window.event || e;
		var keyCode = evt.keyCode || evt.which;
	    if (keyCode == 40)//down
	    {
	        me.setItemIndex(me.itemIndex + 1);
	        return;
	    }
	    if (keyCode == 38)//up
	    {
	        me.setItemIndex(me.itemIndex - 1);
	        return;
	    }
	    if (keyCode == 13)//enter
	    {
	        if (me.itemIndex > -1)
	            me.select();
	        else
	            me.procSubmitEvent();
	        return;
	    }
	    if (keyCode == 27)//esc
	    {
	        me.clear();
	        return;
	    }
	    if (keyCode == 37) return;//left
	    if (keyCode == 39) return;//right
        me.procActiveEvent();
    }
    this.parentDom.onkeypress = function(e)
    {
        var evt = window.event || e;
		var keyCode = evt.keyCode || evt.which;
		if (keyCode == 13) return false;
    }
}

//执行触发事件
suggest.prototype.procActiveEvent = function()
{
    eval(this.activeEventName);
}

//执行提交事件
suggest.prototype.procSubmitEvent = function()
{
    this.clear();
    eval(this.submitEventName);
}

//添加新项
suggest.prototype.append = function(text, eventTag)
{
    var me = this;
    if (this.ulDom.childNodes.length == 0) this.setVisible(true);
    var obj = new Object();
    obj.text = text;
    obj.eventTag = eventTag;
    this.items.push(obj);
    var index = this.items.length-1;
    var li = document.createElement("li");
    $(li).html(obj.text);
    $(li).bind("mouseover", function(){ me.setItemIndex(index) });
    $(li).bind("click", function(){ me.select() });
    $(this.ulDom).append(li);
}

//清除列表
suggest.prototype.clear = function()
{
    this.items.clear();
    this.setVisible(false);
    this.itemIndex = -1;
    this.ulDom.innerHTML = "";
}

//设置索引
suggest.prototype.setItemIndex = function(index)
{
    if (this.ulDom.childNodes.length == 0) return;
    if (index < 0) index = 0;
    if (index > this.items.length - 1) index = this.items.length - 1;
    this.itemIndex = index;
    this.onChangeItemIndex();
}

//索引改变事件
suggest.prototype.onChangeItemIndex = function()
{
    for (var i = 0; i < this.ulDom.childNodes.length; i++)
        this.ulDom.childNodes[i].className = "";
    this.ulDom.childNodes[this.itemIndex].className = "current";
}


//选择项
suggest.prototype.select = function()
{
    if (this.itemIndex > -1)
    {
        eval(this.items[this.itemIndex].eventTag);
        this.clear();
    }
}

//显示状态
suggest.prototype.setVisible = function(value)
{
    if (value == true)
    {
        $(this.contentDom).show();
        this.itemIndex = -1;
    }
    else
    {
        $(this.contentDom).hide();
    }
}

//获取位置信息
suggest.prototype.getPosition = function(e)
{
	var x = 0;
	var y = 0;
	var es = e.style;
	var restoreStyles = false;
	if (jQuery(e).css('display') == 'none') {
		var oldVisibility = es.visibility;
		var oldPosition = es.position;
		restoreStyles = true;
		es.visibility = 'hidden';
		es.display = 'block';
		es.position = 'absolute';
	}
	var el = e;
	while (el){
		x += el.offsetLeft + (el.currentStyle && !jQuery.browser.opera ?parseInt(el.currentStyle.borderLeftWidth)||0:0);
		y += el.offsetTop + (el.currentStyle && !jQuery.browser.opera ?parseInt(el.currentStyle.borderTopWidth)||0:0);
		el = el.offsetParent;
	}
	el = e;
	while (el && el.tagName  && el.tagName.toLowerCase() != 'body')
	{
		x -= el.scrollLeft||0;
		y -= el.scrollTop||0;
		el = el.parentNode;
	}
	if (restoreStyles == true) {
		es.display = 'none';
		es.position = oldPosition;
		es.visibility = oldVisibility;
	}
	return {x:x, y:y};
}

//获取尺寸信息
suggest.prototype.getSize = function(e)
{
	var w = jQuery.css(e,'width');
	var h = jQuery.css(e,'height');
	var wb = 0;
	var hb = 0;
	var es = e.style;
	if (jQuery(e).css('display') != 'none') {
		wb = e.offsetWidth;
		hb = e.offsetHeight;
	} else {
		var oldVisibility = es.visibility;
		var oldPosition = es.position;
		es.visibility = 'hidden';
		es.display = 'block';
		es.position = 'absolute';
		wb = e.offsetWidth;
		hb = e.offsetHeight;
		es.display = 'none';
		es.position = oldPosition;
		es.visibility = oldVisibility;
	}
	return {w:w, h:h, wb:wb, hb:hb};
}