﻿<%@ Control Language="C#" AutoEventWireup="true" Inherits="doodii.Web.Controls.Member.UserRegister" %>

<script type="text/javascript" src="/system/js/jquery-calendar/jquery-calendar.js"></script>

<script type="text/javascript" src="/system/js/Format.js"></script>

<script type="text/javascript" src="/system/js/Lib/AreaSelector2.js"></script>

<script type="text/javascript" src="/system/js/Lib/PageNavigator.js"></script>

<script type="text/javascript">
    
    var gAreaId = 0;
    var gObjAreaSelector = null;
    var DeliverAddress_objAreaSelector = null;
    $(document).ready( function(){ init() });
    
    function init()
    {
        bindEvents();
        var date = new Date();
        var _Email = getQueryString("email");
        var myReg = /^[-_A-Za-z0-9]+@([_A-Za-z0-9]+\.)+[A-Za-z0-9]{2,3}$/;
        if(myReg.test(_Email)) $("#tbExtendUserEmail").val(_Email);
    }
    
    var bindEvents = function() {
        $("#tbEmail").bind("focus", function(){
            resetMessage($("#tbEmail"),document.getElementById("lblEmailMessage"),
                "请正确填写您的常用电子邮件地址。" )}
        );
        $("#tbEmail").bind("blur", function(){ validateEmail() });
        $("#tbNickName").bind("focus", function(){
            resetMessage($("#tbNickName"), document.getElementById("lblNickNameMessage"),
            "给自己起一个独一无二的昵称吧!")}
        );
        $("#tbNickName").bind("blur", function(){ validateNickName() });
        $("#tbPassword").bind("focus", function(){
            resetMessage($("#tbPassword"), document.getElementById("lblPasswordMessage"),
                "6-16位字符。" )}
        );
        $("#tbPassword").bind("blur", function(){ validatePassword() });
        $("#tbConfirmPassword").bind("focus", function(){
            resetMessage($("#tbConfirmPassword"), document.getElementById("lblConfirmPasswordMessage"),
                "6-16位字符。" )}
        );
        $("#tbConfirmPassword").bind("blur", function(){ validateConfirmPassword() });
        $("#tbQuestion").bind("focus", function(){
            resetMessage($("#tbQuestion"), document.getElementById("lblQuestionMessage"),
                "您可以自定义一个问题。" )}
        );
        $("#tbQuestion").bind("blur", function(){ validateQuestion() });
        
        $("#tbKey").bind("focus", function(){
            resetMessage($("#tbKey"), document.getElementById("lblKeyMessage"),
                "自定义问题的答案。" )}
        );
        $("#tbKey").bind("blur", function(){ validateKey() });
    }
    
    var resetMessage = function(objinput,objDom, Message ) {
        $(objDom).removeAttr("class");
        $(objDom).html( Message );
        $(objinput).attr("class","inputCurrent");
    }
    
    var setRightMessage = function(objinput,objDom ) {
        $(objDom).attr("class", "MessageRight");
        $(objinput).attr("class","");
        $(objDom).html( "√" );
    }
    
    var setErrorMessage = function(objinput, objDom, Message ) {
        $(objDom).attr("class", "MessageError");
        $(objinput).attr("class","inputError");
        $(objDom).html( Message );
        
    }
    
    var validateEmail = function() {
        var Email = $("#tbEmail").val();
        if ($.trim(Email) != Email)
        {
            setErrorMessage($("#tbEmail"), document.getElementById("lblEmailMessage"), "X");
            return false;
        }
        var ret = doodii.Web.Controls.Member.UserRegister.CheckEmail( Email ).value;
        if ( ret == "0" ) {
            setRightMessage($("#tbEmail"), document.getElementById("lblEmailMessage") );
            
            return true;
        } else {
            setErrorMessage($("#tbEmail"), document.getElementById("lblEmailMessage"), ret );
            return false
        }
    }
    
    var validateNickName = function() {
        var NickName = $("#tbNickName").val();
        if(NickName.indexOf("@")>=0)
        {
            setErrorMessage($("#tbNickName"), document.getElementById("lblNickNameMessage"), "X" ); 
            return false;
        }
        var ret = doodii.Web.Controls.Member.UserRegister.CheckNickName( NickName ).value;
        if ( ret == "0" ) {
            setRightMessage($("#tbNickName"), document.getElementById("lblNickNameMessage") );
            return true;
        } else {
            setErrorMessage($("#tbNickName"), document.getElementById("lblNickNameMessage"), ret );
            return false;
        }
    }
   
    var validatePassword = function() {
        var Password = $("#tbPassword").val();
        if ($.trim(Password) != Password)
        {
            setErrorMessage($("#tbPassword"),document.getElementById("lblPasswordMessage"), "X");
           
            return;
        }
        if ( Password.length < 6 || Password.length > 16 ) {
            setErrorMessage($("#tbPassword"), document.getElementById("lblPasswordMessage"), "X");
            return false;
        } else {
            setRightMessage($("#tbPassword"), document.getElementById("lblPasswordMessage") );
            validateBothPassword();
            return true;
        }
    }
    
    var validateConfirmPassword = function() {
        var ConfirmPassword = $("#tbConfirmPassword").val();
        if ($.trim(ConfirmPassword) != ConfirmPassword)
        {
            setErrorMessage($("#tbConfirmPassword"),document.getElementById("lblConfirmPasswordMessage"), "X");
            return;
        }
        if ( ConfirmPassword.length < 6 || ConfirmPassword.length > 16 ) {
            setErrorMessage($("#tbConfirmPassword"), document.getElementById("lblConfirmPasswordMessage"), "X");
            return false;
        } else {
            setRightMessage($("#tbConfirmPassword"), document.getElementById("lblConfirmPasswordMessage") );
            validateBothPassword();
            return true;
        }
    }
    
    var validateBothPassword = function() {
        var Password = $("#tbPassword").val();
        var ConfirmPassword = $("#tbConfirmPassword").val();
        if ( Password != ConfirmPassword ) {
            setErrorMessage( $("#tbConfirmPassword"),document.getElementById("lblConfirmPasswordMessage"), "您两次输入的密码不一致！");
            return false;
        } else {
         $("tbPassword").attr("class","");
            return true;
        }
    }
     var validateQuestion= function() {
        var Question = $("#tbQuestion").val();
        if ($.trim(Question) != Question)
        {
            setErrorMessage($("#tbQuestion"),document.getElementById("lblQuestionMessage"), "X");
            return;
        }
        if (Question.length > 30|| Question.length<1) {
            setErrorMessage($("#tbQuestion"), document.getElementById("lblQuestionMessage"), "X");
            return false;
        } 
        else {
            setRightMessage($("#tbQuestion"), document.getElementById("lblQuestionMessage") );
            return true;
        }
       
    }
    var validateKey= function() {
        var key = $("#tbKey").val();
        if ($.trim(key) != key)
        {
            setErrorMessage($("#tbKey"),document.getElementById("lblKeyMessage"), "X");
            return;
        }
        if (key.length > 30|| key.length<1) {
            setErrorMessage($("#tbKey"), document.getElementById("lblKeyMessage"), "X");
            return false;
        } 
        else {
            setRightMessage($("#tbKey"), document.getElementById("lblKeyMessage") );
            return true;
        }
    }
    var validateForm = function() {
        var ret = true;
        if ( !validateEmail() ) ret = false;
        if ( !validateNickName() ) ret = false;
        if ( !validatePassword() ) ret = false;
        if ( !validateConfirmPassword() ) ret = false;
        if ( !validateBothPassword() ) ret = false;
        if ( !validateQuestion() ) ret = false;
        if ( !validateKey() ) ret = false;
       
        return ret;
    }
    
    var saveForm = function()
    {
        if ( !validateForm() )
        {
            document.documentElement.scrollTop = 0;
            return;
        }
        if ($("#cbxNotice").attr("checked") != true )
        {
            document.documentElement.scrollTop = 0;
            alert("提交前必须同意服务条款！");
            return;
        }
        var Email = $.trim($("#tbEmail").val());
        var NickName = $("#tbNickName").val();
        var Password = $.trim($("#tbPassword").val());
        var ConfirmPassword = $.trim($("#tbConfirmPassword").val());
        if ( Password != ConfirmPassword )
        {
            alert("两次输入的密码不一致！");
            return;
        }
        var question = $.trim($("#tbQuestion").val());
        var key = $("#tbKey").val();
        var ret = doodii.Web.Controls.Member.UserRegister.SaveForm(Email, NickName, Password, 0, 0
            , 0, "","","","",0,"",0,"","",question,key).value;        
        if ( ret == 0 )
        {
            $("#btnSubmit").attr("disabled", true);

            var reg_url=$("#<%=back_url.ClientID %>").val();
            alert('注册成功，恭喜您已成为我们的会员！');
            if(reg_url !="")
           { 
            window.location=reg_url;}
            else
            {
//            window.location='/Member/RegisterSuccess.aspx?AreaId='+gAreaId;
                 window.location='/Member/RegisterSuccess.aspx';
            }
        }
        else
        {
            alert(ret);
        }
        }


</script>

<style type="text/css">
    .STYLE1 {
        color: #FF0000
    }
    .MessageError {
        color:#f00;
    }
    .MessageRight {
        color:#090;
    }

        .inputCurrent{background-color:#CAFCA9; border:1px solid #ccc;}
        .inputError{background-color:#FF9966;border:1px solid #ccc;}
        .inputRight{background-color:#EEEEEE;border:1px solid #ccc;}
 .PopMessage25
{
    position:absolute;
    width:300px;
    padding:5px 5px 5px 5px;
    right:0px; top:0px;
    background-color:#F7FCF5;
    line-height:20px;
    z-index:9999;
    border:2px solid #61BD33;
}
.red{color:red;}
.Band1
{
    width: 960px;
    margin: 0 auto;
    clear: both;
    padding-top:0px;
}
</style>
<div class="Band1">
    <div class="style_zhuce">
        欢迎注册<asp:Label ID="lblRest" CssClass="red" runat="server"></asp:Label>会员！</div>
    <div class="zhuceInfo">
        <div class="Register">
            <input type="hidden" value="" id="back_url" runat="server" />
            （这部分一旦填写是不可以更改的哦。）</div>
        <table style="margin-left: 90px; margin-top: 15px;" border="0">
            <tr>
                <td align="right">
                    <span style="color: #FF0000; width: 80px;">*</span> 邮&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;箱：</td>
                <td>
                    <input id="tbEmail" type="text" maxlength="50" />
                </td>
                <td style="width: 500px;">
                    <span id="lblEmailMessage" class="KcAttentionFont">准确填写邮箱，可以帮您找回密码，并有机会享受更多服务。</span>
                </td>
            </tr>
            <tr>
                <td align="right">
                    <span style="color: #FF0000;">*</span> 昵&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;称：</td>
                <td>
                    <input id="tbNickName" type="text" maxlength="16" />
                </td>
                <td>
                    <span id="lblNickNameMessage" class="KcAttentionFont">给自己起一个独一无二的昵称吧!</span>
                </td>
            </tr>
            <tr>
                <td align="right">
                    <span style="color: #FF0000;">*</span> 密&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;码：</td>
                <td>
                    <input id="tbPassword" type="password" maxlength="16" />
                </td>
                <td>
                    <span id="lblPasswordMessage" class="KcAttentionFont">6-16个字符（字母、数字、特殊符号），不区分大小写。</span>
                </td>
            </tr>
            <tr>
                <td align="right">
                    <span style="color: #FF0000;">*</span> 确认密码：</td>
                <td>
                    <input id="tbConfirmPassword" type="password" maxlength="16" />
                </td>
                <td>
                    <span class="KcAttentionFont" id="lblConfirmPasswordMessage">再次输入上面设定的密码。</span>
                </td>
            </tr>
        </table>
        <div class="Register1 Register">
            （用于找回密码。）</div>
        <table style="margin-left: 90px; margin-top: 15px;" border="0">
            <tr>
                <td align="right">
                    <span style="color: #FF0000; width: 80px;">*</span> 问&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;题：</td>
                <td>
                    <input id="tbQuestion" type="text" maxlength="30" />
                </td>
                <td style="width: 500px;">
                    <span id="lblQuestionMessage" class="KcAttentionFont">您可以自定义一个问题。</span>
                </td>
            </tr>
            <tr>
                <td align="right">
                    <span style="color: #FF0000;">*</span> 答&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;案：</td>
                <td>
                    <input id="tbKey" type="text" maxlength="30" />
                </td>
                <td>
                    <span id="lblKeyMessage" class="KcAttentionFont">自定义问题的答案。</span>
                </td>
            </tr>
        </table>
        <div class="Register2 Register">
        </div>
        <div style="margin-left: 350px; margin-top: 15px; clear: both;">
            <span style="color: #FF0000;">*&nbsp;</span><input id="cbxNotice" type="checkbox"
                checked="checked" value="1" />
            <label for="cbxNotice">
                <span>我已阅读并接受“<a class="normal" href="/Member/ServiceTerms.aspx" target="_blank">服务条款</a>”</span></label>
        </div>
        <div style="margin-left: 350px; margin-top: 15px;">
            <a class="Style_Input" href="javascript:saveForm();" id="btnSubmit">创建账号</a>
        </div>
    </div>
        <div class="xiakuang">
    &nbsp
    </div>
</div>
