﻿/*<script type="text/javascript" src="/js/Lib/Tabs.js"></script>
<link rel="Stylesheet" type="text/css" href="/css/V5/Lib.css" />*/
//parentDomId: parentDom element id
//callbackFuncName: Example:function onChangeTabIndex(index){} -> "onChangeTabIndex"
//items: "tabTitle1,tabTitle2,tabTitle3....tabTitleN"
//changeMode:1:Click; 2:mouseover; 3:url(setHref)
var vensonTabs = function(parentDomId, callbackFuncName, items, changeMode, styleName)
{
    this.parentDom = document.getElementById(parentDomId);
    this.callbackFuncName = callbackFuncName;
    this.items = items.split(",");
    this.styleName = "Default";
    if (styleName != "" && styleName != undefined) this.styleName = styleName;
    this.changeMode = 1;
    if (changeMode == 2) this.changeMode = 2;
    if (changeMode == 3) this.changeMode = 3;
    this.tabIndex = -1;
    this.divDom = document.createElement("div");
    this.divDom.className = "tabs_" + this.styleName;
    this.init();
}
vensonTabs.prototype.init = function()
{
    var me = this;


    for (var i = 0; i < this.items.length; i++)
    {


        var a = document.createElement("a");
        a.innerHTML = this.items[i];
        a.index = i;
        if (this.changeMode == 1)
        {
            a.href = "javascript:void(0)";
            a.onclick = function(){ me.changeIndex(this.index) }
        }
        else if (this.changeMode == 2)
        {
            a.href = "javascript:void(0)";
            a.onmouseover = function(){ me.changeIndex(this.index) }
        }
        else if (this.changeMode == 3)
        {
            a.href = "#";
        }
        this.divDom.appendChild(a);
    }
    this.parentDom.innerHTML = "";
    this.parentDom.appendChild(this.divDom);
}

vensonTabs.prototype.setHref = function(index, url)
{
    $(this.divDom).children().eq(index).attr("href", url);
}

vensonTabs.prototype.setIndex = function(index)
{
    index = parseInt(index);
    if (isNaN(index) == true)
    {
        alert("index is null��");
        return false;
    }
    if (index < 0)
    {
        alert("index overflow!");
        return false;
    }
    if (index > this.items.length-1)
    {
        alert("index overflow!");
        return false;
    }
    $(this.divDom).children().each( function(){ $(this).attr("class", "") } );
    $(this.divDom).children().eq(index).attr("class", "selected");
}

vensonTabs.prototype.changeIndex = function(index)
{
    this.setIndex(index);
    if (this.callbackFuncName != null)
        eval(this.callbackFuncName + "(" + index + ")");
}

