﻿//Request /js/Format.js, /js/jquery.js, /css/v5/lib.css
var vWindowsManagerBg = null;
var vWindowsManagerBgIframe = null;

//Class: vWindowsManager
var vWindowsManager =
{
    winList : [],
    dialog : null,
    dragWind : null
}
vWindowsManager.Open = function(oPageInfo)
{
    this.AppendWindow(new vWindowClass(oPageInfo));
}
vWindowsManager.ShowDialog = function(elementId)
{
    this.SetBgState(true);
    var el = document.getElementById(elementId);
    if (el == undefined) return;
    var width = parseInt($(el).css("width"));
    var height = parseInt($(el).css("height"));
    var left = (window.document.body.clientWidth/2)  - (width/2);
    var top = (document.documentElement.clientHeight/2 + document.documentElement.scrollTop - height/2);
    if (left < 1) left = 1;
    if (top < 1) top = 1;
    el.style.left = left + "px";
    el.style.top = top + "px";
    el.style.display = "block";
    this.dialog = el;
}
vWindowsManager.HideDialog = function()
{
    this.SetBgState(false);
    if (this.dialog != null)
    {
        this.dialog.style.display = "none";
        this.dialog = null;
    }
}
vWindowsManager.AppendWindow = function(obj)
{
    if (obj.winId != undefined) this.winList.push(obj);
}
vWindowsManager.RemoveWindow = function(winId)
{
    for (var i = 0; i < this.winList.length; i++)
    {
        if (this.winList[i].winId == winId)
        {
            this.winList[i] == undefined;
            this.winList = this.winList.slice(0,i).concat(this.winList.slice(i+1,this.winList.length));
        }
    }
}
vWindowsManager.GetWindow = function(winId)
{
    for (var i = 0; i < this.winList.length; i++)
    {
        if (this.winList[i].winId == winId)
        {
            return this.winList[i];
            break;
        }
    }
}
vWindowsManager.Close = function(winId)
{
    this.GetWindow(winId).Close();
}
vWindowsManager.CloseAndCallback = function(winId, e)
{
    this.GetWindow(winId).CloseAndCallback(e);
}
vWindowsManager.ResizeBg = function()
{
    var width = window.document.body.clientWidth;
    var height = document.documentElement.scrollHeight;
    $(vWindowsManagerBg).css("width", width + "px");
    $(vWindowsManagerBg).css("height", height + "px");
    if (vWindowsManagerBgIframe != null)
    {
        $(vWindowsManagerBgIframe).css("width", width + "px");
        $(vWindowsManagerBgIframe).css("height", height + "px");
    }
}
vWindowsManager.SetBgState = function(state)
{
    if (state == true && vWindowsManagerBg == null)
    {
        vWindowsManagerBg = document.createElement("div");
        vWindowsManagerBg.className = "vWindowsManagerBg";
        if ($.browser.msie && ($.browser.version < 7))
        {
            vWindowsManagerBgIframe = document.createElement("iframe");
            vWindowsManagerBgIframe.className = "vWindowsManagerBgIframe";
            document.body.appendChild(vWindowsManagerBgIframe); 
        }
        this.ResizeBg();
        $(window).bind("resize", this.ResizeBg);
        document.body.appendChild(vWindowsManagerBg);
    }
    else
    {
        $(window).unbind("resize", this.ResizeBg);
        document.body.removeChild(vWindowsManagerBg);
        vWindowsManagerBg = null;
        if (vWindowsManagerBgIframe != null)
        {
            document.body.removeChild(vWindowsManagerBgIframe);
            vWindowsManagerBgIframe = null;
        }
    }
}
vWindowsManager.HasSingleInst = function(url)
{
    for (var i = 0; i < this.winList.length; i++)
    {
        if (this.winList[i].oPageInfo.url == url && this.winList[i].oPageInfo.singleInst == true)
        {
            return true;
            break;
        }
    }
    return false;
}

//Class: vWindowClass
var vWindowClass = function(oPageInfo)
{
    this.oPageInfo = this.FormatPageInfo(oPageInfo);
    if (vWindowsManager.HasSingleInst(oPageInfo.url) == true)
    {
        alert("已经存在同地址实例窗口！");
        return;
    }
    var me = this;
    this.winId = this.CreateId();
    this.winDom = document.createElement("div");
    this.winDom.className = "vWindowClass";
    var winLeft = (window.document.body.clientWidth/2)  - (this.oPageInfo.width/2);
    var winTop = (document.documentElement.clientHeight/2 + document.documentElement.scrollTop - this.oPageInfo.height/2);
    if (winLeft < 0) winLeft = 0;
    if (winTop < 0) winTop = 0;
    this.winDom.style.left = winLeft + "px";
    this.winDom.style.top = winTop + "px";
    var titleDom = document.createElement("div");
    titleDom.className = "vWindowClassTitle";
    var titleSpan = document.createElement("span");
    titleSpan.innerHTML = HtmlEncode(this.oPageInfo.title);
    this.lnkClose = document.createElement("a");
    this.lnkClose.className = "BtnClose";
    $(this.lnkClose).css("margin-left", (this.oPageInfo.width - 40) + "px");   
    this.lnkClose.innerHTML = "关闭";
    this.lnkClose.href = "javascript:void(0)";

    this.lnkClose.onclick = function(){ me.Close(); }
    this.winDom.appendChild(this.lnkClose);
    var iframe = document.createElement("iframe");
    iframe.frameBorder = 0;
    iframe.width = this.oPageInfo.width;
    iframe.height = this.oPageInfo.height;
    iframe.src = this.oPageInfo.url + (this.oPageInfo.url.indexOf("?") == -1 ? "?" : "&") + "winid=" + this.winId;
    
    titleDom.appendChild(titleSpan);
    //titleDom.appendChild(this.lnkClose);
    this.winDom.appendChild(titleDom);
    this.winDom.appendChild(iframe);
    if (this.oPageInfo.topMode == true) vWindowsManager.SetBgState(1);
    if (this.oPageInfo.dragAble)
    {
        this.winDom.onmousedown = this.OnTitleMouseDown;
        this.winDom.onmousemove = this.OnTitleMouseMove;
        this.winDom.onmouseup = this.OnTitleMouseUp;
    }
    document.body.appendChild(this.winDom);
}
vWindowClass.prototype.UnBindEvents = function()
{
    $(this.lnkClose).unbind("mouseclick");
    if (this.oPageInfo.dragAble == true)
    {
        $(this.winDom).unbind("mousedown");
        $(this.winDom).unbind("mousemove");
        $(this.winDom).unbind("mouseup");
    }
}
vWindowClass.prototype.Close = function()
{
    this.UnBindEvents();
    document.body.removeChild(this.winDom);
    if (this.oPageInfo.topMode == true) vWindowsManager.SetBgState(0);
    vWindowsManager.RemoveWindow(this.winId);
}
vWindowClass.prototype.CloseAndCallback = function(e)
{
    this.UnBindEvents();
    document.body.removeChild(this.winDom);
    if (this.oPageInfo.topMode == true) vWindowsManager.SetBgState(0);
    vWindowsManager.RemoveWindow(this.winId);
    if (typeof(this.oPageInfo.callbackFunc) == "function") this.oPageInfo.callbackFunc(e);
}
vWindowClass.prototype.CreateId = function()
{
    var t = new Date();
	var hours = t.getHours();
	var minutes = t.getMinutes();
	var seconds = t.getSeconds();
	var Id = "ID";
	Id += ((hours < 10 ) ? "0" : "") + hours;
	Id += ((minutes < 10) ? "0" : "") + minutes;
  	Id += ((seconds < 10) ? "0" : "") + seconds;
	t = null;   
	return Id;
}
vWindowClass.prototype.FormatPageInfo = function(oPageInfo)
{
    oPageInfo.title = oPageInfo.title == undefined ? "New window" : oPageInfo.title;
    oPageInfo.height = isNaN(parseInt(oPageInfo.height)) == true ? 200 : parseInt(oPageInfo.height);
    oPageInfo.width = isNaN(parseInt(oPageInfo.width)) == true ? 200 : parseInt(oPageInfo.width);
    oPageInfo.url = oPageInfo.url == undefined ? "" : oPageInfo.url;
    oPageInfo.callbackFunc = typeof(oPageInfo.callbackFunc) == "function" ? oPageInfo.callbackFunc :  null;
    oPageInfo.topMode = oPageInfo.topMode == true ? true : false;
    oPageInfo.dragAble = oPageInfo.dragAble == true ? true : false;
    oPageInfo.singleInst = oPageInfo.singleInst == true ? true : false;
    return oPageInfo;
}
//Drag
vWindowClass.prototype.OnTitleMouseDown = function(e)
{
	vWindowsManager.dragWin = this;
	if (e)
	    window.captureEvents(Event.MOUSEMOVE);
	else
		this.setCapture();
	var evt = e ? e : window.event;
	var mx = evt.pageX ? evt.pageX : evt.x;
	var my = evt.pageY ? evt.pageY : evt.y;
	vWindowsManager.dragWin.l = mx - parseInt(this.style.left);
	vWindowsManager.dragWin.t = my - parseInt(this.style.top);
}
vWindowClass.prototype.OnTitleMouseMove = function(e)
{
	if (vWindowsManager.dragWin == null) return;
	var evt = e ? e : window.event;
	var mx = evt.pageX ? evt.pageX : evt.x;
	var my = evt.pageY ? evt.pageY : evt.y;
	this.style.left = mx -vWindowsManager.dragWin.l + "px";
	this.style.top = my - vWindowsManager.dragWin.t + "px";
}
vWindowClass.prototype.OnTitleMouseUp = function(e)
{
	if (vWindowsManager.dragWin == null) return;
	if (e)
	    window.releaseEvents(Event.MOUSEMOVE);
	else
		this.releaseCapture();
	vWindowsManager.dragWin = null;
}