﻿//MyMap
//------------------------------------------------------
//Editer:venson;
var MyMap = function( domId, defaultCityName, endSearchFunc, endSetMarkFunc ) {
    this.defaultCityName = defaultCityName;
    this.oMap = new LTMaps( domId );
    this.oSearch = new LTLocalSearch();
    LTEvent.addListener( this.oSearch, "loadend", endSearchFunc );
    this.oMarker = new LTMarkControl();
    this.oMap.addControl( this.oMarker ); 
    this.oMarker.setVisible( false );   
    LTEvent.addListener( this.oMarker , "mouseup" , endSetMarkFunc );
    //this.oMap.handleKeyboard();
    //this.oMap.handleMouseScroll();
    this.oMap.addControl( new LTStandMapControl(2) );
    this.searchByCity( defaultCityName );
}

MyMap.prototype.settings = {
    markIconPath: "",
    searchKeywordDomId: ""
}

MyMap.prototype.points = new Array();

MyMap.prototype.addPoint = function( x, y ) {
    this.points.push( new LTPoint( x, y ) );
}

MyMap.prototype.clearPoints = function() {
    this.points.length = 0;
}

MyMap.prototype.setBestRegion = function() {
    if ( this.points.length == 0 ) {
        this.searchByCity( this.defaultCityName );
    } else {
        this.oMap.getBestMap( this.points );
    }
}

MyMap.prototype.htmlEncode = function( text ) {
	var ret = "";
	if ( typeof(text) != "string" ) return ret;
	var arr = text.split('');
	for ( var i=0; i<arr.length; i++ ) {
		var s = arr[i];
		switch ( s ) {
			case "<" : ret += "&lt;"; break;
			case ">" : ret += "&gt;"; break;
			case "&" : ret += "&amp;"; break;
			case 13 : ret += "<br>"; break;
			case " " : ret += "&nbsp;"; break;
			default : ret += s;
		}
	}
	return ret;
}

MyMap.prototype.clear = function() {
    this.oMap.clearOverLays();
}

MyMap.prototype.addMark = function( x, y, text, iconUrl ) {
    var _Point = new LTPoint( x, y );
    var _Icon = new LTIcon();
    if ( iconUrl != undefined && iconUrl != "" ) {
        _Icon.setImageUrl( iconUrl );
    } else {
        if ( this.settings.markIconPath != undefined && this.settings.markIconPath != "" ) {
            _Icon.setImageUrl( this.settings.markIconPath );
        }
    }
    var _Marker = new LTMarker( _Point, _Icon );
    this.oMap.addOverLay( _Marker );
    var _MapText = new LTMapText( _Marker );
    _MapText.setLabel( text );
    this.oMap.addOverLay( _MapText );
}

MyMap.prototype.setMark = function() {
    this.oMarker.btnClick();
}

MyMap.prototype.getMarkPoint = function() {
    return this.oMarker.getMarkControlPoint();
}

MyMap.prototype.outSearchKeyword = function( keyword ) {
    if ( this.settings.searchKeywordDomId != "" ) {
        $("#"+this.settings.searchKeywordDomId).html( this.htmlEncode( keyword ) );
    }
}

MyMap.prototype.searchByCity = function( cityName ) {
    this.outSearchKeyword( cityName );
    this.oMap.centerAndZoom( cityName, 5 );
}

MyMap.prototype.searchByPoint = function( x, y, markText ) {
    var _Point = new LTPoint( x, y );
    this.oMap.centerAndZoom( _Point, 3 );
    if ( markText != undefined ) this.addMark( x, y, markText );
}

MyMap.prototype.searchByKeyword = function( cityName, keyword ) {
    this.oSearch.setCity( cityName );
    this.outSearchKeyword( "[" + cityName + "]" + keyword );
    this.oSearch.search( keyword );
}