﻿//----------------------------------
//Class: vuiNav(分页导航组件)
//Author: Venson
//Email: zoom9002@163.com
//Version: 1.0
//----------------------------------
//属性:
//elementId: 父级HTML元素ID
//instName:  实例化类时所使用的名称
//callBackFuncName: 刷新数据所使用的函数名称

//构造函数
//Param.ElementId: 父级HTML元素ID
//Param.InstName:  实例化类时所使用的名称
//Param.CallBackFuncName: 刷新数据所使用的函数名称
var vensonNav = function( ElementId, InstName, CallBackFuncName ) {
    this.elementId = ElementId;
    this.instName = InstName;
    this.callBackFuncName = CallBackFuncName;
    this.renderType = 1;
	this.pageIndex = 1;
	this.pageCount = 1;
	//this.showPageNumberCount = 3;//3+1+3
}

//渲染方式A
vensonNav.prototype.renderForTypeA = function() {
    var obj = document.getElementById( this.elementId );
	while ( obj.childNodes.length > 0 ) obj.removeChild(obj.childNodes[0] );
	//First and previous button
	if ( this.pageIndex > 1 ) {
	    var a = document.createElement("a");
	    a.innerHTML = "最前";
	    a.href = "javascript:" + this.instName + ".pageIndex=1;" + this.callBackFuncName + "();";
	    obj.appendChild( a );
	    obj.innerHTML += "&nbsp;";
	    var a = document.createElement("a");
	    a.innerHTML = "向前";
	    a.href = "javascript:" + this.instName + ".pageIndex--;" + this.callBackFuncName + "();";
	    obj.appendChild( a );
	 } else {
	    var a = document.createElement("a");
	    a.innerHTML = "最前";
	    obj.appendChild( a );
	    obj.innerHTML += "&nbsp;";
	    var a = document.createElement("a");
	    a.innerHTML = "向前";
	    obj.appendChild( a );
	 }
	 //Refresh
	 obj.innerHTML += "&nbsp;";
	 var a = document.createElement("a");
	 a.innerHTML = this.pageIndex + "/" + this.pageCount;
	 a.href = "javascript:" + this.callBackFuncName + "()";
	 obj.appendChild( a );
	 obj.innerHTML += "&nbsp;";
	 //Next and last
	 if ( this.pageIndex < this.pageCount ) {
	    var a = document.createElement("a");
	    a.innerHTML = "向后";
	    a.href = "javascript:" + this.instName + ".pageIndex++;" + this.callBackFuncName + "()";
	    obj.appendChild( a );
	    obj.innerHTML += "&nbsp;";
	    var a = document.createElement("a");
	    a.innerHTML = "最后";
	    a.href = "javascript:" + this.instName + ".pageIndex=" + this.instName + ".pageCount;" + this.callBackFuncName + "()";
	    obj.appendChild( a );
	 } else {
	    var a = document.createElement("a");
	    a.innerHTML = "向后";
	    obj.appendChild( a );
	    obj.innerHTML += "&nbsp;";
	    var a = document.createElement("a");
	    a.innerHTML = "最后";
	    obj.appendChild( a );
	    
	 }
	obj = null;
}

//渲染方式B(private)
vensonNav.prototype.renderForTypeB = function()
{
    var obj = document.getElementById( this.elementId );
	while ( obj.childNodes.length > 0 ) obj.removeChild(obj.childNodes[0] );
	    for (var i = (this.pageIndex - 5); i < this.pageIndex; i++)
	    {
	        if (i > 0)
	        {
	            obj.innerHTML += "&nbsp;";
	            var a = document.createElement("a");
	            a.href = "javascript:" + this.instName + ".pageIndex=" + i + ";" + this.callBackFuncName + "();";
	            a.innerHTML = i;
	            obj.appendChild(a);
	        }
	    }
	 //Refresh
	 obj.innerHTML += "&nbsp;<strong><a href='javascript:" + this.callBackFuncName + "()'>" + this.pageIndex + "</a></strong>";
	 //Next and last
	    for (var i = (this.pageIndex + 1); i <= (this.pageIndex + 5); i++)
	    {
	        if (i <= this.pageCount)
	        {
	            obj.innerHTML += "&nbsp;";
	            var a = document.createElement("a");
	            a.href = "javascript:" + this.instName + ".pageIndex=" + i + ";" + this.callBackFuncName + "();";
	            a.innerHTML = i;
	            obj.appendChild(a);
	        }
	    }
	obj = null;
}

//渲染(public)
vensonNav.prototype.render = function( PageIndex, PageCount )
{
    if ( isNaN( parseInt( PageCount ) ) ) {
        PageCount = 0;
    } else {
        PageCount = parseInt( PageCount );
        if ( PageCount < 0 ) PageCount = 0;
    }
    if ( isNaN( parseInt( PageIndex ) ) ) {
        PageIndex = 1;
    } else {
        PageIndex = parseInt( PageIndex );
        if ( PageIndex < 1 ) PageIndex = 1;
    }
    if ( PageIndex > PageCount ) PageIndex = PageCount;
	this.pageIndex = parseInt( PageIndex );
	this.pageCount = parseInt( PageCount );
    switch ( this.renderType ) {
        case 1 : this.renderForTypeA(); break;
        case 2 : this.renderForTypeB(); break;
    }
}
