﻿//======================================================
/**
 * Interface Elements for jQuery
 * utility function
 * 
 * http://interface.eyecon.ro
 * 
 * Copyright (c) 2006 Stefan Petre
 * Dual licensed under the MIT (MIT-LICENSE.txt) 
 * and GPL (GPL-LICENSE.txt) licenses.
 *   
 *
 */

jQuery.iUtil = {
	getPos : function (e, s)
	{
		var l = 0;
		var t  = 0;
		var sl = 0;
		var st  = 0;
		var w = jQuery.css(e,'width');
		var h = jQuery.css(e,'height');
		var wb = e.offsetWidth;
		var hb = e.offsetHeight;
		while (e.offsetParent){
			l += e.offsetLeft + (e.currentStyle?parseInt(e.currentStyle.borderLeftWidth)||0:0);
			t += e.offsetTop  + (e.currentStyle?parseInt(e.currentStyle.borderTopWidth)||0:0);
			if (s) {
				sl += e.parentNode.scrollLeft||0;
				st += e.parentNode.scrollTop||0;
			}
			e = e.offsetParent;
		}
		l += e.offsetLeft + (e.currentStyle?parseInt(e.currentStyle.borderLeftWidth)||0:0);
		t += e.offsetTop  + (e.currentStyle?parseInt(e.currentStyle.borderTopWidth)||0:0);
		st = t - st;
		sl = l - sl;
		return {x:l, y:t, sx:sl, sy:st, w:w, h:h, wb:wb, hb:hb};
	},
	getPosition : function(e)
	{
		var x = 0;
		var y = 0;
		var restoreStyle = false;
		es = e.style;
		if (jQuery(e).css('display') == 'none') {
			oldVisibility = es.visibility;
			oldPosition = es.position;
			es.visibility = 'hidden';
			es.display = 'block';
			es.position = 'absolute';
			restoreStyle = true;
		}
		el = e;
		while (el){
			x += el.offsetLeft + (el.currentStyle && !jQuery.browser.opera ?parseInt(el.currentStyle.borderLeftWidth)||0:0);
			y += el.offsetTop + (el.currentStyle && !jQuery.browser.opera ?parseInt(el.currentStyle.borderTopWidth)||0:0);
			el = el.offsetParent;
		}
		el = e;
		while (el && el.tagName.toLowerCase() != 'body')
		{
			x -= el.scrollLeft||0;
			y -= el.scrollTop||0;
			el = el.parentNode;
		}
		if (restoreStyle) {
			es.display = 'none';
			es.position = oldPosition;
			es.visibility = oldVisibility;
		}
		return {x:x, y:y};
	},
	getSize : function(e)
	{
		var w = jQuery.css(e,'width');
		var h = jQuery.css(e,'height');
		var wb = 0;
		var hb = 0;
		es = e.style;
		if (jQuery(e).css('display') != 'none') {
			wb = e.offsetWidth;
			hb = e.offsetHeight;
		} else {
			oldVisibility = es.visibility;
			oldPosition = es.position;
			es.visibility = 'hidden';
			es.display = 'block';
			es.position = 'absolute';
			wb = e.offsetWidth;
			hb = e.offsetHeight;
			es.display = 'none';
			es.position = oldPosition;
			es.visibility = oldVisibility;
		}
		return {w:w, h:h, wb:wb, hb:hb};
	},
	getClient : function(e)
	{
		if (e) {
			w = e.clientWidth;
			h = e.clientHeight;
		} else {
			de = document.documentElement;
			w = window.innerWidth || self.innerWidth || (de&&de.clientWidth) || document.body.clientWidth;
			h = window.innerHeight || self.innerHeight || (de&&de.clientHeight) || document.body.clientHeight;
		}
		return {w:w,h:h};
	},
	getScroll : function (e) 
	{
		if (e) {
			t = e.scrollTop;
			l = e.scrollLeft;
			w = e.scrollWidth;
			h = e.scrollHeight;
			iw = 0;
			ih = 0;
		} else  {
			if (document.documentElement && document.documentElement.scrollTop) {
				t = document.documentElement.scrollTop;
				l = document.documentElement.scrollLeft;
				w = document.documentElement.scrollWidth;
				h = document.documentElement.scrollHeight;
			} else if (document.body) {
				t = document.body.scrollTop;
				l = document.body.scrollLeft;
				w = document.body.scrollWidth;
				h = document.body.scrollHeight;
			}
			iw = self.innerWidth||document.documentElement.clientWidth||document.body.clientWidth||0;
			ih = self.innerHeight||document.documentElement.clientHeight||document.body.clientHeight||0;
		}
		return { t: t, l: l, w: w, h: h, iw: iw, ih: ih };
	},
	getMargins : function(e, toInteger)
	{
		el = jQuery(e);
		t = el.css('marginTop') || '';
		r = el.css('marginRight') || '';
		b = el.css('marginBottom') || '';
		l = el.css('marginLeft') || '';
		if (toInteger)
			return {
				t: parseInt(t)||0, 
				r: parseInt(r)||0,
				b: parseInt(b)||0,
				l: parseInt(l)
			};
		else
			return {t: t, r: r,	b: b, l: l};
	},
	getPadding : function(e, toInteger)
	{
		el = jQuery(e);
		t = el.css('paddingTop') || '';
		r = el.css('paddingRight') || '';
		b = el.css('paddingBottom') || '';
		l = el.css('paddingLeft') || '';
		if (toInteger)
			return {
				t: parseInt(t)||0, 
				r: parseInt(r)||0,
				b: parseInt(b)||0,
				l: parseInt(l)
			};
		else
			return {t: t, r: r,	b: b, l: l};
	},
	getBorder : function(e, toInteger)
	{
		el = jQuery(e);
		t = el.css('borderTopWidth') || '';
		r = el.css('borderRightWidth') || '';
		b = el.css('borderBottomWidth') || '';
		l = el.css('borderLeftWidth') || '';
		if (toInteger)
			return {
				t: parseInt(t)||0, 
				r: parseInt(r)||0,
				b: parseInt(b)||0,
				l: parseInt(l)||0
			};
		else
			return {t: t, r: r,	b: b, l: l};
	},
	getPointer : function(event)
	{
		x = event.pageX || (event.clientX + (document.documentElement.scrollLeft || document.body.scrollLeft)) || 0;
		y = event.pageY || (event.clientY + (document.documentElement.scrollTop || document.body.scrollTop)) || 0;
		return {x:x, y:y};	
	}
};





/////////////////////////////////////
//Class: vuiWin
//Authoer: Venson
//Email: zoom9002@163.com
//Version: 1.0
/////////////////////////////////////
var Win = {
	rndTag : 'WinRnd',
	dragWin : null,
	winRndCount : 7,
	winBar : null,
	winHeader : "vuiWin_",
	frameHeader : "vuiFrame_",
	minHeader : "vuiMin_",
	winBarItemHeader : "yuiItem_",
	winClassName : "vui_Win",
	winZIndex:9999,
	
	winID : null,
	winSimple : false,
	winIframeID : null,
	winMinBtnID : null,
	winRndSeed : null
	
}

Win.setWinBar = function( el ) {
	this.winBar = el;
}

Win.getWinBarItem = function( rndSeed ) {
	return document.getElementById( this.winBarItemHeader + rndSeed );
}

Win.addWinBarItem = function( rndSeed, title ) {
	if ( this.winBar != null ) {
		var divItem = document.createElement("div");
		divItem.id = this.winBarItemHeader + rndSeed;
		divItem.className = "ItemUsed";
		divItem.innerHTML = title;
		divItem.title = title;
		divItem.onclick = function(){ Win.winBarClick( rndSeed ) };
		this.winBar.appendChild( divItem );
		divItem = null;
	}
}

Win.toggleWinBarItem = function( rndSeed ) {
	var oItem = this.getWinBarItem( rndSeed );
	if ( oItem != null ) {
		if ( oItem.className = "ItemUsed" )
			oItem.className = "Item";
		else
			oItem.className = "ItemUsed";
	}
	oItem = null;
}

Win.removeWinBarItem = function( rndSeed ) {
	var oItem = this.getWinBarItem( rndSeed );
	if ( oItem != null ) {
		oItem.onclick = null;
		oItem.parentNode.removeChild( oItem );
	}
	oItem = null;
}

Win.winBarClick = function( rndSeed ) {
	var oItem = this.getWinBarItem( rndSeed );
	if ( oItem != null ) {
		oItem.className = "ItemUsed";
		this.topWin( this.getWin( rndSeed ) );
	}
	oItem = null;
}

//openWin
Win.openWin = function( url, title, width, height ,simple) {
    
    //如果已经打开了窗口就不再打开了
    if (simple!=null)  
    {  
        this.winSimple = simple;
        if (simple == true && this.winID!=null) return;        
    }    
	
	var t = new Date();
	var hours = t.getHours();
	var minutes = t.getMinutes();
	var seconds = t.getSeconds();
	var rndSeed = "s";
	rndSeed += ((hours < 10 ) ? "0" : "") + hours;
	rndSeed += ((minutes < 10) ? "0" : "") + minutes;
  	rndSeed += ((seconds < 10) ? "0" : "") + seconds;this.winRndSeed = rndSeed;
	t = null;
	url += ((url.indexOf("?")==-1)?"?":"&") + this.rndTag + "=" + rndSeed;
	//winDiv
	var divBox = document.createElement("div");
	divBox.id = this.winHeader + rndSeed;this.winID = divBox.id;
	divBox.className = this.winClassName;
	divBox.style.zIndex = this.winZIndex;
	//divBox.style.left = ($.iUtil.getClient().w-width-120)/2 + "px";
	divBox.style.left = ($.iUtil.getClient().w-width)/2 + "px";
	divBox.style.top = ($.iUtil.getClient().h-height)/2-20 + Win.GetScrollTop() + "px";
	divBox.onmousedown = this.handleMouseDown;
	divBox.onmousemove = this.handleMouseMove;
	divBox.onmouseup = this.handleMouseUp;
	//TitleBar
	var divTitleBar = document.createElement("div");
	divTitleBar.className = "TitleBar";
	//TitleName
	var spanTitleName = document.createElement("span");
	spanTitleName.innerHTML = title;
	divTitleBar.appendChild( spanTitleName );
	
//	//HideBar
//	var divHideBar = document.createElement("div");
//	divHideBar.className = "HideBar";
//	divHideBar.title = "Hide window";
//	divHideBar.onclick = function() { Win.hideWin( rndSeed ) };	
//	divHideBar.innerHTML = "_";
//	divTitleBar.appendChild( divHideBar );
	
	//MinBar
	var divMinBar = document.createElement("div");
	divMinBar.id = this.minHeader + rndSeed;this.winMinBtnID = divMinBar.id;
	divMinBar.className = "MinBar";
	divMinBar.title = "最小化";
	divMinBar.onclick = function() { Win.min(); };
	divMinBar.innerHTML = "<img src='/js/win/images/xiao01.gif' border='0'/>";
	divTitleBar.appendChild( divMinBar );
	
	//CloseBar
	var divCloseBar = document.createElement("div");
	divCloseBar.className = "CloseBar";
	divCloseBar.title = "关闭";
	divCloseBar.onclick = function(){ Win.closeWin(rndSeed) };
	divCloseBar.innerHTML = "&nbsp;";
	divTitleBar.appendChild( divCloseBar );
	divBox.appendChild( divTitleBar );
	
	//Iframe
	var iFrame = document.createElement("iframe");
	iFrame.id = this.frameHeader + rndSeed;this.winIframeID = iFrame.id;
	iFrame.className = "iframeBar";
	iFrame.scrolling = "no";
	iFrame.frameBorder = 0;
	iFrame.width = width;
	iFrame.height = height;
	divBox.appendChild( iFrame );
	document.body.appendChild(divBox);
	iFrame.src = url;
	this.addWinBarItem( rndSeed, title );
	//Clear
	iFrame = null;
	divCloseBar = null;
	divFoldBar = null;
	divTitleBar = null;
	divBox = null;
}

//DragWin
Win.handleMouseDown = function(e) {
	Win.dragWin = this;
	Win.topWin( this );
	if ( !e )
		this.setCapture();
	else
		window.captureEvents(Event.MOUSEMOVE);
	var evt = e ? e : window.event;
	var mx = evt.pageX ? evt.pageX : evt.x;
	var my = evt.pageY ? evt.pageY : evt.y;
	//var mx = event.x;
	//var my = event.y;
	Win.dragWin.l = mx-parseInt(this.style.left);
	Win.dragWin.t = my-parseInt(this.style.top);
}

Win.handleMouseMove = function(e) {
	if( Win.dragWin != null ) {
		var evt = e ? e : window.event;
		var mx = evt.pageX ? evt.pageX : evt.x;
		var my = evt.pageY ? evt.pageY : evt.y;
		//var mx = event.x;
		//var my = event.y;
		this.style.left = mx-Win.dragWin.l + "px";
		this.style.top = my-Win.dragWin.t + "px";
	}
}

Win.handleMouseUp = function(e) {
	if( Win.dragWin != null) {
		if ( !e )
			this.releaseCapture();
		else
			window.releaseEvents(Event.MOUSEMOVE);
		Win.dragWin = null;
	}
}

//getWin
Win.getWin = function( rndSeed ) {
	return document.getElementById(this.winHeader + rndSeed);
}

//hideWin
Win.hideWin = function( rndSeed ) {
	oWin = this.getWin( rndSeed );
	if ( oWin != null ) {
		oWin.style.display = "none";
		this.toggleWinBarItem( rndSeed );
	}
	oWin = null;
}


//topWin
Win.topWin = function( oWin ) {
	if ( oWin != null ) {
		$("."+this.winClassName).css("z-index", "0");
		oWin.style.zIndex = this.winZIndex;
		oWin.style.display = "block";
	}
	oWin = null;
}

//closeWin
Win.closeWin = function( rndSeed ) {
    if (rndSeed==null)
        rndSeed = this.winRndSeed;
	var objWin = Win.getWin( rndSeed );
	if ( objWin != null )
	{
		var iFrame = document.getElementById( this.frameHeader + rndSeed );
		iFrame.src="";
		iFrame = null;
		if ( objWin.detachEvent ) {
			objWin.detachEvent("onmousedown", this.handleMouseDown);
			objWin.detachEvent("onmousemove", this.handleMouseMove);
			objWin.detachEvent("onmouseup", this.handleMouseUp);
		} else {
			objWin.removeEventListener("mousedown", this.handleMouseDown, false);
			objWin.removeEventListener("mousemove", this.handleMouseMove, false);
			objWin.removeEventListener("mouseup", this.handleMouseUp, false);
		}
		objWin.parentNode.removeChild( objWin );
		this.removeWinBarItem( rndSeed );
	}
	objWin = null;
	
	if (this.winSimple)
	    this.winID = null;
    
}

//最小化
Win.min = function(x,y)
{
    var id = document.getElementById(this.winID);
    var ifr = document.getElementById(this.winIframeID);
    var minBtn = document.getElementById(this.winMinBtnID);
    if (ifr.style.display == "none")
    {    
        ifr.style.display = "";
        minBtn.title = "最小化";
        id.style.width = "";        
        minBtn.innerHTML = "<img src='/js/win/images/xiao01.gif' border='0'/>";
    }    
    else
    {    
        ifr.style.display = "none";
        minBtn.title = "恢复";
        id.style.width = "100px";
        minBtn.innerHTML = "<img src='/js/win/images/huifu01.gif' border='0'/>";
    }
}

//框架自动拉伸　开始
Win.dyniframesize = function (iframename) {
      var getFFVersion=navigator.userAgent.substring(navigator.userAgent.indexOf("Firefox")).split("/")[1]
     //extra height in px to add to iframe in FireFox 1.0+ browsers
      var FFextraHeight=getFFVersion>=0.1? 16 : 0
      
      var pTar = null;
      if (document.getElementById){
        pTar = document.getElementById(iframename);
      }
      else{
        eval('pTar = ' + iframename + ';');
      }
     
      if (pTar && !window.opera){
        //begin resizing iframe
        pTar.style.display="block";
        // alert(pTar.contentDocument.body.offsetHeight);
        if (pTar.contentDocument && pTar.contentDocument.body.offsetHeight){
              //ns6 syntax
            alert(pTar.contentDocument.body.offsetHeight);
              pTar.height = pTar.contentDocument.body.offsetHeight+FFextraHeight;
        }
        else if (pTar.Document && pTar.Document.body.scrollHeight){
              //ie5+ syntax
              
              pTar.height = pTar.Document.body.scrollHeight;
        }
//        else{
//            pTar.height = pTar.contentDocument.body.offsetHeight+FFextraHeight;
//        }
      }
}



Win.autoHeight = function(h){
    if (document.getElementById(this.winIframeID).style.display != "none")
    {    
        Win.dyniframesize(this.winIframeID);    
        if (h!=null)
        {   
            document.getElementById(this.winIframeID).style.height = h + "px";
        }
    }
}
//框架自动拉伸　结束

///////////////////////////---------------------
//获取滚动条高度 开始    
 Win.GetScrollTop = function (){ 
        var agt=navigator.userAgent.toLowerCase();
        var ie = ((agt.indexOf("msie") != -1) && (agt.indexOf("opera") == -1) && (agt.indexOf("omniweb") == -1));
        return ie ? IeTrueBody().scrollTop : window.pageYOffset; 
        
        function IeTrueBody(){
            return (document.compatMode && document.compatMode!="BackCompat")? document.documentElement : document.body;
        }         
 }
//获取滚动条高度 结束





