﻿IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Property]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Property] 
 
CREATE TABLE dbo.Web_Property([ID] [int]  NOT NULL,[TypeID] [int]  NOT NULL,[Name] [nvarchar] (50)  NULL,[IsSearch] [int]  NOT NULL,[IsSelect] [int]  NOT NULL,[InputType] [int]  NOT NULL,[OrderID] [int]  NOT NULL,[Value] [nvarchar] (250)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Property ADD CONSTRAINT DF_Web_Property_TypeID DEFAULT ((0)) FOR [TypeID]
 
ALTER TABLE dbo.Web_Property ADD CONSTRAINT DF_Web_Property_IsSearch DEFAULT ((0)) FOR [IsSearch]
 
ALTER TABLE dbo.Web_Property ADD CONSTRAINT DF_Web_Property_IsSelect DEFAULT ((0)) FOR [IsSelect]
 
ALTER TABLE dbo.Web_Property ADD CONSTRAINT DF_Web_Property_InputType DEFAULT ((0)) FOR [InputType]
 
ALTER TABLE dbo.Web_Property ADD CONSTRAINT DF_Web_Property_OrderID DEFAULT ((1000)) FOR [OrderID]
 
CREATE TABLE dbo.Tmp_Web_Property([ID] [int]  NOT NULL IDENTITY (1, 1),[TypeID] [int]  NOT NULL,[Name] [nvarchar] (50)  NULL,[IsSearch] [int]  NOT NULL,[IsSelect] [int]  NOT NULL,[InputType] [int]  NOT NULL,[OrderID] [int]  NOT NULL,[Value] [nvarchar] (250)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_Property ADD CONSTRAINT DF_Tmp_Web_Property_TypeID DEFAULT ((0)) FOR [TypeID]
 
ALTER TABLE dbo.Tmp_Web_Property ADD CONSTRAINT DF_Tmp_Web_Property_IsSearch DEFAULT ((0)) FOR [IsSearch]
 
ALTER TABLE dbo.Tmp_Web_Property ADD CONSTRAINT DF_Tmp_Web_Property_IsSelect DEFAULT ((0)) FOR [IsSelect]
 
ALTER TABLE dbo.Tmp_Web_Property ADD CONSTRAINT DF_Tmp_Web_Property_InputType DEFAULT ((0)) FOR [InputType]
 
ALTER TABLE dbo.Tmp_Web_Property ADD CONSTRAINT DF_Tmp_Web_Property_OrderID DEFAULT ((1000)) FOR [OrderID]
 
SET IDENTITY_INSERT dbo.Tmp_Web_Property ON
 
IF EXISTS(SELECT * FROM dbo.Web_Property) EXEC('INSERT INTO dbo.Tmp_Web_Property ([ID],[TypeID],[Name],[IsSearch],[IsSelect],[InputType],[OrderID],[Value]) SELECT [ID],[TypeID],[Name],[IsSearch],[IsSelect],[InputType],[OrderID],[Value] FROM dbo.Web_Property WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Property OFF
 
DROP TABLE dbo.Web_Property
 
EXECUTE sp_rename N'dbo.Tmp_Web_Property', N'Web_Property', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_OrderPriceModifytLog]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_OrderPriceModifytLog] 
 
CREATE TABLE dbo.Web_OrderPriceModifytLog([ID] [int]  NOT NULL,[OrderNumber] [nvarchar] (50)  NOT NULL,[ModifyPrice] [decimal]  (18,2) NOT NULL,[Date] [datetime]  NOT NULL,[IP] [nvarchar] (50)  NOT NULL,[Remark] [nvarchar] (100)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_OrderPriceModifytLog ADD CONSTRAINT DF_Web_OrderPriceModifytLog_Date DEFAULT (getdate()) FOR [Date]
 
CREATE TABLE dbo.Tmp_Web_OrderPriceModifytLog([ID] [int]  NOT NULL IDENTITY (1, 1),[OrderNumber] [nvarchar] (50)  NOT NULL,[ModifyPrice] [decimal]  (18,2) NOT NULL,[Date] [datetime]  NOT NULL,[IP] [nvarchar] (50)  NOT NULL,[Remark] [nvarchar] (100)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_OrderPriceModifytLog ADD CONSTRAINT DF_Tmp_Web_OrderPriceModifytLog_Date DEFAULT (getdate()) FOR [Date]
 
SET IDENTITY_INSERT dbo.Tmp_Web_OrderPriceModifytLog ON
 
IF EXISTS(SELECT * FROM dbo.Web_OrderPriceModifytLog) EXEC('INSERT INTO dbo.Tmp_Web_OrderPriceModifytLog ([ID],[OrderNumber],[ModifyPrice],[Date],[IP],[Remark]) SELECT [ID],[OrderNumber],[ModifyPrice],[Date],[IP],[Remark] FROM dbo.Web_OrderPriceModifytLog WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_OrderPriceModifytLog OFF
 
DROP TABLE dbo.Web_OrderPriceModifytLog
 
EXECUTE sp_rename N'dbo.Tmp_Web_OrderPriceModifytLog', N'Web_OrderPriceModifytLog', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Role]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Role] 
 
CREATE TABLE dbo.Web_Role([ID] [int]  NOT NULL,[Name] [nvarchar] (20)  NULL,[Short] [nvarchar] (20)  NULL,[CreateDate] [datetime]  NOT NULL,[Creator] [nvarchar] (50)  NULL,[IsDel] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Role ADD CONSTRAINT DF_Web_Role_CreateDate DEFAULT (getdate()) FOR [CreateDate]
 
ALTER TABLE dbo.Web_Role ADD CONSTRAINT DF_Web_Role_IsDel DEFAULT ((0)) FOR [IsDel]
 
INSERT INTO Web_Role VALUES ('1','管理员','Adminstrators','2008-5-14 16:03:26','登录用户的姓名','0')
 
CREATE TABLE dbo.Tmp_Web_Role([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (20)  NULL,[Short] [nvarchar] (20)  NULL,[CreateDate] [datetime]  NOT NULL,[Creator] [nvarchar] (50)  NULL,[IsDel] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_Role ADD CONSTRAINT DF_Tmp_Web_Role_CreateDate DEFAULT (getdate()) FOR [CreateDate]
 
ALTER TABLE dbo.Tmp_Web_Role ADD CONSTRAINT DF_Tmp_Web_Role_IsDel DEFAULT ((0)) FOR [IsDel]
 
SET IDENTITY_INSERT dbo.Tmp_Web_Role ON
 
IF EXISTS(SELECT * FROM dbo.Web_Role) EXEC('INSERT INTO dbo.Tmp_Web_Role ([ID],[Name],[Short],[CreateDate],[Creator],[IsDel]) SELECT [ID],[Name],[Short],[CreateDate],[Creator],[IsDel] FROM dbo.Web_Role WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Role OFF
 
DROP TABLE dbo.Web_Role
 
EXECUTE sp_rename N'dbo.Tmp_Web_Role', N'Web_Role', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_SubscriptionCategory]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_SubscriptionCategory] 
 
CREATE TABLE dbo.Web_SubscriptionCategory([Id] [int]  NOT NULL,[Name] [nvarchar] (50)  NULL,[Description] [nvarchar] (250)  NULL)  ON [PRIMARY] 
 
INSERT INTO Web_SubscriptionCategory VALUES ('1','商城杂志','默认的订阅类型,商城杂志,您可继续添加订阅类型')
 
CREATE TABLE dbo.Tmp_Web_SubscriptionCategory([Id] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NULL,[Description] [nvarchar] (250)  NULL)  ON [PRIMARY] 
 
SET IDENTITY_INSERT dbo.Tmp_Web_SubscriptionCategory ON
 
IF EXISTS(SELECT * FROM dbo.Web_SubscriptionCategory) EXEC('INSERT INTO dbo.Tmp_Web_SubscriptionCategory ([Id],[Name],[Description]) SELECT [Id],[Name],[Description] FROM dbo.Web_SubscriptionCategory WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_SubscriptionCategory OFF
 
DROP TABLE dbo.Web_SubscriptionCategory
 
EXECUTE sp_rename N'dbo.Tmp_Web_SubscriptionCategory', N'Web_SubscriptionCategory', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_UserGroup]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_UserGroup] 
 
CREATE TABLE dbo.Web_UserGroup([ID] [int]  NOT NULL,[Name] [nvarchar] (50)  NOT NULL,[Discount] [int]  NOT NULL,[MinScore] [int]  NOT NULL,[Ico] [nvarchar] (150)  NULL,[Level] [int]  NOT NULL,[IsDefault] [int]  NOT NULL,[IsShowPrice] [int]  NOT NULL)  ON [PRIMARY] 
 
INSERT INTO Web_UserGroup VALUES ('0','默认会员等级','100','100','','0','1','1')
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_UserCardLog]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_UserCardLog] 
 
CREATE TABLE dbo.Web_UserCardLog([Id] [int]  NOT NULL,[Number] [nvarchar] (100)  NOT NULL,[OrderNumber] [nvarchar] (50)  NOT NULL,[Price] [decimal]  (18,2) NOT NULL,[Date] [datetime]  NOT NULL,[UserName] [varchar] (1) NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_UserCardLog ADD CONSTRAINT DF_Web_UserCardLog_Date DEFAULT (getdate()) FOR [Date]
 
CREATE TABLE dbo.Tmp_Web_UserCardLog([Id] [int]  NOT NULL IDENTITY (1, 1),[Number] [nvarchar] (100)  NOT NULL,[OrderNumber] [nvarchar] (50)  NOT NULL,[Price] [decimal]  (18,2) NOT NULL,[Date] [datetime]  NOT NULL,[UserName] [varchar] (1) NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_UserCardLog ADD CONSTRAINT DF_Tmp_Web_UserCardLog_Date DEFAULT (getdate()) FOR [Date]
 
SET IDENTITY_INSERT dbo.Tmp_Web_UserCardLog ON
 
IF EXISTS(SELECT * FROM dbo.Web_UserCardLog) EXEC('INSERT INTO dbo.Tmp_Web_UserCardLog ([Id],[Number],[OrderNumber],[Price],[Date],[UserName]) SELECT [Id],[Number],[OrderNumber],[Price],[Date],[UserName] FROM dbo.Web_UserCardLog WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_UserCardLog OFF
 
DROP TABLE dbo.Web_UserCardLog
 
EXECUTE sp_rename N'dbo.Tmp_Web_UserCardLog', N'Web_UserCardLog', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_AdsCategory]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_AdsCategory] 
 
CREATE TABLE dbo.Web_AdsCategory([ID] [int]  NOT NULL,[Name] [nvarchar] (50)  NULL,[OrderID] [int]  NOT NULL,[Level] [int]  NOT NULL,[HeadID] [int]  NOT NULL,[Family] [nvarchar] (250)  NULL,[Description] [nvarchar] (250)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_AdsCategory ADD CONSTRAINT DF_Web_AdsCategory_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Web_AdsCategory ADD CONSTRAINT DF_Web_AdsCategory_Level DEFAULT ((0)) FOR [Level]
 
ALTER TABLE dbo.Web_AdsCategory ADD CONSTRAINT DF_Web_AdsCategory_HeadID DEFAULT ((0)) FOR [HeadID]
 
CREATE TABLE dbo.Tmp_Web_AdsCategory([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NULL,[OrderID] [int]  NOT NULL,[Level] [int]  NOT NULL,[HeadID] [int]  NOT NULL,[Family] [nvarchar] (250)  NULL,[Description] [nvarchar] (250)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_AdsCategory ADD CONSTRAINT DF_Tmp_Web_AdsCategory_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Tmp_Web_AdsCategory ADD CONSTRAINT DF_Tmp_Web_AdsCategory_Level DEFAULT ((0)) FOR [Level]
 
ALTER TABLE dbo.Tmp_Web_AdsCategory ADD CONSTRAINT DF_Tmp_Web_AdsCategory_HeadID DEFAULT ((0)) FOR [HeadID]
 
SET IDENTITY_INSERT dbo.Tmp_Web_AdsCategory ON
 
IF EXISTS(SELECT * FROM dbo.Web_AdsCategory) EXEC('INSERT INTO dbo.Tmp_Web_AdsCategory ([ID],[Name],[OrderID],[Level],[HeadID],[Family],[Description]) SELECT [ID],[Name],[OrderID],[Level],[HeadID],[Family],[Description] FROM dbo.Web_AdsCategory WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_AdsCategory OFF
 
DROP TABLE dbo.Web_AdsCategory
 
EXECUTE sp_rename N'dbo.Tmp_Web_AdsCategory', N'Web_AdsCategory', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Order]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Order] 
 
CREATE TABLE dbo.Web_Order([Number] [nvarchar] (20)  NOT NULL,[UserName] [nvarchar] (50)  NOT NULL,[SendName] [nvarchar] (50)  NOT NULL,[SendTel] [nvarchar] (100)  NOT NULL,[SendMobile] [nvarchar] (100)  NOT NULL,[SendEmail] [nvarchar] (100)  NOT NULL,[ReceiveName] [nvarchar] (100)  NOT NULL,[ReceiveTel] [nvarchar] (100)  NOT NULL,[ReceiveMobile] [nvarchar] (150)  NOT NULL,[ReceivePostCode] [nvarchar] (100)  NOT NULL,[ReceiveAddress] [nvarchar] (250)  NOT NULL,[ReceiveDate] [datetime]  NOT NULL,[ReceiveSex] [int]  NOT NULL,[Payment] [nvarchar] (50)  NOT NULL,[PaymentPrice] [decimal]  (18,2) NOT NULL,[Delivery] [nvarchar] (50)  NOT NULL,[Remark] [nvarchar] (250)  NOT NULL,[IsInvoice] [int]  NOT NULL,[InvoiceHead] [nvarchar] (50)  NOT NULL,[InvoicePrice] [decimal]  (18,2) NOT NULL,[InvoiceType] [nvarchar] (100)  NOT NULL,[IsCancel] [int]  NOT NULL,[Fee] [decimal]  (18,2) NOT NULL,[SafePrice] [decimal]  (18,2) NOT NULL,[Price] [decimal]  (18,2) NOT NULL,[PriceModify] [decimal]  (18,2) NOT NULL,[AdminRemark] [nvarchar] (250)  NOT NULL,[Date] [datetime]  NOT NULL,[ProviderExtend] [nvarchar] (100)  NOT NULL,[DeliveryExtend] [nvarchar] (100)  NOT NULL,[Building] [nvarchar] (100)  NOT NULL,[StatusID] [int]  NOT NULL,[IsUserCancel] [int]  NOT NULL,[GroupBuyID] [int]  NOT NULL,[ProductPackageID] [int]  NOT NULL,[ProductPackagePrice] [decimal]  (18,2) NOT NULL,[GreetingCardID] [int]  NOT NULL,[GreetingCardPrice] [decimal]  (18,2) NOT NULL,[GreetingCardInfomation] [nvarchar] (200)  NOT NULL,[IsDel] [int]  NOT NULL,[IsCOD] [int]  NULL,[UserRemark] [nvarchar] (150)  NOT NULL,[UsedScore] [int]  NOT NULL,[ScoreTradePrice] [decimal]  (18,2) NOT NULL,[CouponTradePrice] [decimal]  (18,2) NOT NULL,[OriginalPrice] [decimal]  (18,2) NOT NULL,[NewProductPrice] [decimal]  (18,2) NOT NULL,[OldProductPrice] [decimal]  (18,2) NOT NULL,[CouponNumber] [nvarchar] (50)  NOT NULL,[IsOut] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_UserName DEFAULT ('') FOR [UserName]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_SendName DEFAULT (N'匿名用户') FOR [SendName]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_SendTel DEFAULT ('') FOR [SendTel]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_SendMobile DEFAULT ('') FOR [SendMobile]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_SendEmail DEFAULT ('') FOR [SendEmail]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_ReceiveName DEFAULT ('') FOR [ReceiveName]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_ReceiveTel DEFAULT ('') FOR [ReceiveTel]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_ReceiveMobile DEFAULT ('') FOR [ReceiveMobile]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_ReceivePostCode DEFAULT ('') FOR [ReceivePostCode]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_ReceiveAddress DEFAULT ('') FOR [ReceiveAddress]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_ReceiveDate DEFAULT (getdate()) FOR [ReceiveDate]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_ReceiveSex DEFAULT ((0)) FOR [ReceiveSex]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_Payment DEFAULT ('') FOR [Payment]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_PaymentPrice DEFAULT ((0)) FOR [PaymentPrice]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_Delivery DEFAULT ('') FOR [Delivery]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_Remark DEFAULT ('') FOR [Remark]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_IsInvoice DEFAULT ((0)) FOR [IsInvoice]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_InvoiceHead DEFAULT ('') FOR [InvoiceHead]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_InvoicePrice DEFAULT ((0)) FOR [InvoicePrice]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_InvoiceType DEFAULT ('') FOR [InvoiceType]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_IsCancel DEFAULT ((0)) FOR [IsCancel]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_Fee DEFAULT ((0)) FOR [Fee]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_SafePrice DEFAULT ((0)) FOR [SafePrice]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_Price DEFAULT ((0)) FOR [Price]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_PriceModify DEFAULT ((0)) FOR [PriceModify]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_AdminRemark DEFAULT ('') FOR [AdminRemark]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_ProviderExtend DEFAULT ('') FOR [ProviderExtend]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_DeliveryExtend DEFAULT ('') FOR [DeliveryExtend]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_Building DEFAULT ('') FOR [Building]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_StatusID DEFAULT ((0)) FOR [StatusID]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_IsUserCancel DEFAULT ((0)) FOR [IsUserCancel]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_GroupBuyID DEFAULT ((0)) FOR [GroupBuyID]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_ProductPackageID DEFAULT ((0)) FOR [ProductPackageID]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_ProductPackagePrice DEFAULT ((0.00)) FOR [ProductPackagePrice]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_GreetingCardID DEFAULT ((0)) FOR [GreetingCardID]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_GreetingCardPrice DEFAULT ((0.00)) FOR [GreetingCardPrice]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_GreetingCardInfomation DEFAULT ('') FOR [GreetingCardInfomation]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_IsDel DEFAULT ((0)) FOR [IsDel]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_IsCOD DEFAULT ((0)) FOR [IsCOD]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_UserRemark DEFAULT ('1') FOR [UserRemark]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_UsedScore DEFAULT ((0)) FOR [UsedScore]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_ScoreTradePrice DEFAULT ((0.00)) FOR [ScoreTradePrice]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_CouponTradePrice DEFAULT ((0.00)) FOR [CouponTradePrice]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_OriginalPrice DEFAULT ((0.00)) FOR [OriginalPrice]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_NewProductPrice DEFAULT ((0.00)) FOR [NewProductPrice]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_OldProductPrice DEFAULT ((0.00)) FOR [OldProductPrice]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_CouponNumber DEFAULT ('') FOR [CouponNumber]
 
ALTER TABLE dbo.Web_Order ADD CONSTRAINT DF_Web_Order_IsOut DEFAULT ((0)) FOR [IsOut]
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Language]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Language] 
 
CREATE TABLE dbo.Web_Language([ID] [int]  NOT NULL,[Name] [nvarchar] (50)  NULL,[Mark] [nvarchar] (50)  NULL)  ON [PRIMARY] 
 
CREATE TABLE dbo.Tmp_Web_Language([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NULL,[Mark] [nvarchar] (50)  NULL)  ON [PRIMARY] 
 
SET IDENTITY_INSERT dbo.Tmp_Web_Language ON
 
IF EXISTS(SELECT * FROM dbo.Web_Language) EXEC('INSERT INTO dbo.Tmp_Web_Language ([ID],[Name],[Mark]) SELECT [ID],[Name],[Mark] FROM dbo.Web_Language WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Language OFF
 
DROP TABLE dbo.Web_Language
 
EXECUTE sp_rename N'dbo.Tmp_Web_Language', N'Web_Language', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_VoteOption]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_VoteOption] 
 
CREATE TABLE dbo.Web_VoteOption([Id] [int]  NOT NULL,[VoteID] [int]  NOT NULL,[Name] [nvarchar] (20)  NULL,[Count] [int]  NOT NULL,[OrderID] [int]  NOT NULL)  ON [PRIMARY] 
 
CREATE TABLE dbo.Tmp_Web_VoteOption([Id] [int]  NOT NULL IDENTITY (1, 1),[VoteID] [int]  NOT NULL,[Name] [nvarchar] (20)  NULL,[Count] [int]  NOT NULL,[OrderID] [int]  NOT NULL)  ON [PRIMARY] 
 
SET IDENTITY_INSERT dbo.Tmp_Web_VoteOption ON
 
IF EXISTS(SELECT * FROM dbo.Web_VoteOption) EXEC('INSERT INTO dbo.Tmp_Web_VoteOption ([Id],[VoteID],[Name],[Count],[OrderID]) SELECT [Id],[VoteID],[Name],[Count],[OrderID] FROM dbo.Web_VoteOption WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_VoteOption OFF
 
DROP TABLE dbo.Web_VoteOption
 
EXECUTE sp_rename N'dbo.Tmp_Web_VoteOption', N'Web_VoteOption', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_AdminDesktop]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_AdminDesktop] 
 
CREATE TABLE dbo.Web_AdminDesktop([AdminName] [nvarchar] (50)  NOT NULL,[PageID] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_AdminDesktop ADD CONSTRAINT DF_Web_AdminDesktop_PageID DEFAULT ((0)) FOR [PageID]
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Snatch]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Snatch] 
 
CREATE TABLE dbo.Web_Snatch([Id] [int]  NOT NULL,[Name] [nvarchar] (50)  NOT NULL,[ProductID] [int]  NOT NULL,[FinalPrice] [decimal]  (18,2) NOT NULL,[MinPrice] [decimal]  (18,2) NOT NULL,[MaxPrice] [decimal]  (18,2) NOT NULL,[FinalMaxPrice] [decimal]  (18,2) NOT NULL,[StartDate] [datetime]  NOT NULL,[EndDate] [datetime]  NOT NULL,[Score] [int]  NOT NULL,[Description] [nvarchar] (250)  NOT NULL,[SrcList] [nvarchar] (200)  NOT NULL,[SrcDetail] [nvarchar] (200)  NOT NULL,[IsDel] [int]  NOT NULL,[OrderID] [int]  NOT NULL,[MarketPrice] [decimal]  (18,2) NOT NULL,[HitCount] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Snatch ADD CONSTRAINT DF_Web_Snatch_Name DEFAULT ('') FOR [Name]
 
ALTER TABLE dbo.Web_Snatch ADD CONSTRAINT DF_Web_Snatch_ProductID DEFAULT ((0)) FOR [ProductID]
 
ALTER TABLE dbo.Web_Snatch ADD CONSTRAINT DF_Web_Snatch_FinalPrice DEFAULT ((0.0)) FOR [FinalPrice]
 
ALTER TABLE dbo.Web_Snatch ADD CONSTRAINT DF_Web_Snatch_MinPrice DEFAULT ((0)) FOR [MinPrice]
 
ALTER TABLE dbo.Web_Snatch ADD CONSTRAINT DF_Web_Snatch_MaxPrice DEFAULT ((0)) FOR [MaxPrice]
 
ALTER TABLE dbo.Web_Snatch ADD CONSTRAINT DF_Web_Snatch_FinalMaxPrice DEFAULT ((0)) FOR [FinalMaxPrice]
 
ALTER TABLE dbo.Web_Snatch ADD CONSTRAINT DF_Web_Snatch_StartDate DEFAULT (getdate()) FOR [StartDate]
 
ALTER TABLE dbo.Web_Snatch ADD CONSTRAINT DF_Web_Snatch_EndDate DEFAULT (getdate()) FOR [EndDate]
 
ALTER TABLE dbo.Web_Snatch ADD CONSTRAINT DF_Web_Snatch_Score DEFAULT ((0)) FOR [Score]
 
ALTER TABLE dbo.Web_Snatch ADD CONSTRAINT DF_Web_Snatch_Description DEFAULT ('') FOR [Description]
 
ALTER TABLE dbo.Web_Snatch ADD CONSTRAINT DF_Web_Snatch_SrcList DEFAULT ('') FOR [SrcList]
 
ALTER TABLE dbo.Web_Snatch ADD CONSTRAINT DF_Web_Snatch_SrcDetail DEFAULT ('') FOR [SrcDetail]
 
ALTER TABLE dbo.Web_Snatch ADD CONSTRAINT DF_Web_Snatch_IsDel DEFAULT ((0)) FOR [IsDel]
 
ALTER TABLE dbo.Web_Snatch ADD CONSTRAINT DF_Web_Snatch_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Web_Snatch ADD CONSTRAINT DF_Web_Snatch_MarketPrice DEFAULT ((0)) FOR [MarketPrice]
 
ALTER TABLE dbo.Web_Snatch ADD CONSTRAINT DF_Web_Snatch_HitCount DEFAULT ((0)) FOR [HitCount]
 
CREATE TABLE dbo.Tmp_Web_Snatch([Id] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NOT NULL,[ProductID] [int]  NOT NULL,[FinalPrice] [decimal]  (18,2) NOT NULL,[MinPrice] [decimal]  (18,2) NOT NULL,[MaxPrice] [decimal]  (18,2) NOT NULL,[FinalMaxPrice] [decimal]  (18,2) NOT NULL,[StartDate] [datetime]  NOT NULL,[EndDate] [datetime]  NOT NULL,[Score] [int]  NOT NULL,[Description] [nvarchar] (250)  NOT NULL,[SrcList] [nvarchar] (200)  NOT NULL,[SrcDetail] [nvarchar] (200)  NOT NULL,[IsDel] [int]  NOT NULL,[OrderID] [int]  NOT NULL,[MarketPrice] [decimal]  (18,2) NOT NULL,[HitCount] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_Snatch ADD CONSTRAINT DF_Tmp_Web_Snatch_Name DEFAULT ('') FOR [Name]
 
ALTER TABLE dbo.Tmp_Web_Snatch ADD CONSTRAINT DF_Tmp_Web_Snatch_ProductID DEFAULT ((0)) FOR [ProductID]
 
ALTER TABLE dbo.Tmp_Web_Snatch ADD CONSTRAINT DF_Tmp_Web_Snatch_FinalPrice DEFAULT ((0.0)) FOR [FinalPrice]
 
ALTER TABLE dbo.Tmp_Web_Snatch ADD CONSTRAINT DF_Tmp_Web_Snatch_MinPrice DEFAULT ((0)) FOR [MinPrice]
 
ALTER TABLE dbo.Tmp_Web_Snatch ADD CONSTRAINT DF_Tmp_Web_Snatch_MaxPrice DEFAULT ((0)) FOR [MaxPrice]
 
ALTER TABLE dbo.Tmp_Web_Snatch ADD CONSTRAINT DF_Tmp_Web_Snatch_FinalMaxPrice DEFAULT ((0)) FOR [FinalMaxPrice]
 
ALTER TABLE dbo.Tmp_Web_Snatch ADD CONSTRAINT DF_Tmp_Web_Snatch_StartDate DEFAULT (getdate()) FOR [StartDate]
 
ALTER TABLE dbo.Tmp_Web_Snatch ADD CONSTRAINT DF_Tmp_Web_Snatch_EndDate DEFAULT (getdate()) FOR [EndDate]
 
ALTER TABLE dbo.Tmp_Web_Snatch ADD CONSTRAINT DF_Tmp_Web_Snatch_Score DEFAULT ((0)) FOR [Score]
 
ALTER TABLE dbo.Tmp_Web_Snatch ADD CONSTRAINT DF_Tmp_Web_Snatch_Description DEFAULT ('') FOR [Description]
 
ALTER TABLE dbo.Tmp_Web_Snatch ADD CONSTRAINT DF_Tmp_Web_Snatch_SrcList DEFAULT ('') FOR [SrcList]
 
ALTER TABLE dbo.Tmp_Web_Snatch ADD CONSTRAINT DF_Tmp_Web_Snatch_SrcDetail DEFAULT ('') FOR [SrcDetail]
 
ALTER TABLE dbo.Tmp_Web_Snatch ADD CONSTRAINT DF_Tmp_Web_Snatch_IsDel DEFAULT ((0)) FOR [IsDel]
 
ALTER TABLE dbo.Tmp_Web_Snatch ADD CONSTRAINT DF_Tmp_Web_Snatch_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Tmp_Web_Snatch ADD CONSTRAINT DF_Tmp_Web_Snatch_MarketPrice DEFAULT ((0)) FOR [MarketPrice]
 
ALTER TABLE dbo.Tmp_Web_Snatch ADD CONSTRAINT DF_Tmp_Web_Snatch_HitCount DEFAULT ((0)) FOR [HitCount]
 
SET IDENTITY_INSERT dbo.Tmp_Web_Snatch ON
 
IF EXISTS(SELECT * FROM dbo.Web_Snatch) EXEC('INSERT INTO dbo.Tmp_Web_Snatch ([Id],[Name],[ProductID],[FinalPrice],[MinPrice],[MaxPrice],[FinalMaxPrice],[StartDate],[EndDate],[Score],[Description],[SrcList],[SrcDetail],[IsDel],[OrderID],[MarketPrice],[HitCount]) SELECT [Id],[Name],[ProductID],[FinalPrice],[MinPrice],[MaxPrice],[FinalMaxPrice],[StartDate],[EndDate],[Score],[Description],[SrcList],[SrcDetail],[IsDel],[OrderID],[MarketPrice],[HitCount] FROM dbo.Web_Snatch WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Snatch OFF
 
DROP TABLE dbo.Web_Snatch
 
EXECUTE sp_rename N'dbo.Tmp_Web_Snatch', N'Web_Snatch', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_WholeSaleProject]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_WholeSaleProject] 
 
CREATE TABLE dbo.Web_WholeSaleProject([ID] [int]  NOT NULL,[WholeSaleID] [int]  NOT NULL,[Price] [decimal]  (18,0) NULL,[Count] [int]  NULL,[Discount] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_WholeSaleProject ADD CONSTRAINT DF_Web_WholeSaleProject_Price DEFAULT ((0)) FOR [Price]
 
ALTER TABLE dbo.Web_WholeSaleProject ADD CONSTRAINT DF_Web_WholeSaleProject_Count DEFAULT ((0)) FOR [Count]
 
ALTER TABLE dbo.Web_WholeSaleProject ADD CONSTRAINT DF_Web_WholeSaleProject_Discount DEFAULT ((100)) FOR [Discount]
 
CREATE TABLE dbo.Tmp_Web_WholeSaleProject([ID] [int]  NOT NULL IDENTITY (1, 1),[WholeSaleID] [int]  NOT NULL,[Price] [decimal]  (18,0) NULL,[Count] [int]  NULL,[Discount] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_WholeSaleProject ADD CONSTRAINT DF_Tmp_Web_WholeSaleProject_Price DEFAULT ((0)) FOR [Price]
 
ALTER TABLE dbo.Tmp_Web_WholeSaleProject ADD CONSTRAINT DF_Tmp_Web_WholeSaleProject_Count DEFAULT ((0)) FOR [Count]
 
ALTER TABLE dbo.Tmp_Web_WholeSaleProject ADD CONSTRAINT DF_Tmp_Web_WholeSaleProject_Discount DEFAULT ((100)) FOR [Discount]
 
SET IDENTITY_INSERT dbo.Tmp_Web_WholeSaleProject ON
 
IF EXISTS(SELECT * FROM dbo.Web_WholeSaleProject) EXEC('INSERT INTO dbo.Tmp_Web_WholeSaleProject ([ID],[WholeSaleID],[Price],[Count],[Discount]) SELECT [ID],[WholeSaleID],[Price],[Count],[Discount] FROM dbo.Web_WholeSaleProject WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_WholeSaleProject OFF
 
DROP TABLE dbo.Web_WholeSaleProject
 
EXECUTE sp_rename N'dbo.Tmp_Web_WholeSaleProject', N'Web_WholeSaleProject', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_UserScoreBuyLog]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_UserScoreBuyLog] 
 
CREATE TABLE dbo.Web_UserScoreBuyLog([Id] [int]  NOT NULL,[UserName] [nvarchar] (50)  NOT NULL,[Score] [int]  NOT NULL,[Price] [decimal]  (18,3) NOT NULL,[Date] [datetime]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_UserScoreBuyLog ADD CONSTRAINT DF_Web_UserScoreBuyLog_Date DEFAULT (getdate()) FOR [Date]
 
CREATE TABLE dbo.Tmp_Web_UserScoreBuyLog([Id] [int]  NOT NULL IDENTITY (1, 1),[UserName] [nvarchar] (50)  NOT NULL,[Score] [int]  NOT NULL,[Price] [decimal]  (18,3) NOT NULL,[Date] [datetime]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_UserScoreBuyLog ADD CONSTRAINT DF_Tmp_Web_UserScoreBuyLog_Date DEFAULT (getdate()) FOR [Date]
 
SET IDENTITY_INSERT dbo.Tmp_Web_UserScoreBuyLog ON
 
IF EXISTS(SELECT * FROM dbo.Web_UserScoreBuyLog) EXEC('INSERT INTO dbo.Tmp_Web_UserScoreBuyLog ([Id],[UserName],[Score],[Price],[Date]) SELECT [Id],[UserName],[Score],[Price],[Date] FROM dbo.Web_UserScoreBuyLog WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_UserScoreBuyLog OFF
 
DROP TABLE dbo.Web_UserScoreBuyLog
 
EXECUTE sp_rename N'dbo.Tmp_Web_UserScoreBuyLog', N'Web_UserScoreBuyLog', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_GroupBuyCondition]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_GroupBuyCondition] 
 
CREATE TABLE dbo.Web_GroupBuyCondition([ID] [int]  NOT NULL,[GroupBuyID] [int]  NOT NULL,[Price] [decimal]  (18,0) NOT NULL,[Count] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_GroupBuyCondition ADD CONSTRAINT DF_Web_GroupBuyCondition_GroupBuyID DEFAULT ((0)) FOR [GroupBuyID]
 
ALTER TABLE dbo.Web_GroupBuyCondition ADD CONSTRAINT DF_Web_GroupBuyCondition_Price DEFAULT ((0)) FOR [Price]
 
ALTER TABLE dbo.Web_GroupBuyCondition ADD CONSTRAINT DF_Web_GroupBuyCondition_Count DEFAULT ((0)) FOR [Count]
 
CREATE TABLE dbo.Tmp_Web_GroupBuyCondition([ID] [int]  NOT NULL IDENTITY (1, 1),[GroupBuyID] [int]  NOT NULL,[Price] [decimal]  (18,0) NOT NULL,[Count] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_GroupBuyCondition ADD CONSTRAINT DF_Tmp_Web_GroupBuyCondition_GroupBuyID DEFAULT ((0)) FOR [GroupBuyID]
 
ALTER TABLE dbo.Tmp_Web_GroupBuyCondition ADD CONSTRAINT DF_Tmp_Web_GroupBuyCondition_Price DEFAULT ((0)) FOR [Price]
 
ALTER TABLE dbo.Tmp_Web_GroupBuyCondition ADD CONSTRAINT DF_Tmp_Web_GroupBuyCondition_Count DEFAULT ((0)) FOR [Count]
 
SET IDENTITY_INSERT dbo.Tmp_Web_GroupBuyCondition ON
 
IF EXISTS(SELECT * FROM dbo.Web_GroupBuyCondition) EXEC('INSERT INTO dbo.Tmp_Web_GroupBuyCondition ([ID],[GroupBuyID],[Price],[Count]) SELECT [ID],[GroupBuyID],[Price],[Count] FROM dbo.Web_GroupBuyCondition WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_GroupBuyCondition OFF
 
DROP TABLE dbo.Web_GroupBuyCondition
 
EXECUTE sp_rename N'dbo.Tmp_Web_GroupBuyCondition', N'Web_GroupBuyCondition', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_OrderProduct]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_OrderProduct] 
 
CREATE TABLE dbo.Web_OrderProduct([ID] [int]  NOT NULL,[OrderNumber] [nvarchar] (20)  NOT NULL,[ProductID] [int]  NOT NULL,[UserName] [nvarchar] (100)  NOT NULL,[CategoryID] [int]  NOT NULL,[Number] [nvarchar] (50)  NULL,[Count] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[Name] [nvarchar] (200)  NULL,[MarketPrice] [decimal]  (18,2) NOT NULL,[MemberPrice] [decimal]  (18,2) NOT NULL,[OrderPrice] [decimal]  (18,2) NOT NULL,[Score] [int]  NOT NULL,[Weight] [decimal]  (18,3) NOT NULL,[ActivityID] [int]  NOT NULL,[IsChangeSale] [int]  NOT NULL,[WholeSaleID] [int]  NOT NULL,[UseScore] [int]  NOT NULL,[PropertysText] [nvarchar] (2000)  NULL,[PropertysID] [nvarchar] (250)  NULL,[IsEntity] [int]  NOT NULL,[GroupBuyID] [int]  NOT NULL,[SnatchID] [int]  NOT NULL,[Src] [nvarchar] (250)  NULL,[IsFitting] [int]  NOT NULL,[FittingProductID] [int]  NOT NULL,[IsScore] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_OrderProduct ADD CONSTRAINT DF_Web_OrderProduct_ProductID DEFAULT ((0)) FOR [ProductID]
 
ALTER TABLE dbo.Web_OrderProduct ADD CONSTRAINT DF_Web_OrderProduct_CategoryID DEFAULT ((0)) FOR [CategoryID]
 
ALTER TABLE dbo.Web_OrderProduct ADD CONSTRAINT DF_Web_OrderProduct_Count DEFAULT ((0)) FOR [Count]
 
ALTER TABLE dbo.Web_OrderProduct ADD CONSTRAINT DF_Web_OrderProduct_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Web_OrderProduct ADD CONSTRAINT DF_Web_OrderProduct_MarketPrice DEFAULT ((0)) FOR [MarketPrice]
 
ALTER TABLE dbo.Web_OrderProduct ADD CONSTRAINT DF_Web_OrderProduct_MemberPrice DEFAULT ((0)) FOR [MemberPrice]
 
ALTER TABLE dbo.Web_OrderProduct ADD CONSTRAINT DF_Web_OrderProduct_OrderPrice DEFAULT ((0)) FOR [OrderPrice]
 
ALTER TABLE dbo.Web_OrderProduct ADD CONSTRAINT DF_Web_OrderProduct_Score DEFAULT ((0)) FOR [Score]
 
ALTER TABLE dbo.Web_OrderProduct ADD CONSTRAINT DF_Web_OrderProduct_Weight DEFAULT ((0)) FOR [Weight]
 
ALTER TABLE dbo.Web_OrderProduct ADD CONSTRAINT DF_Web_OrderProduct_ActivityID DEFAULT ((0)) FOR [ActivityID]
 
ALTER TABLE dbo.Web_OrderProduct ADD CONSTRAINT DF_Web_OrderProduct_IsChangeSale DEFAULT ((0)) FOR [IsChangeSale]
 
ALTER TABLE dbo.Web_OrderProduct ADD CONSTRAINT DF_Web_OrderProduct_WholeSaleID DEFAULT ((0)) FOR [WholeSaleID]
 
ALTER TABLE dbo.Web_OrderProduct ADD CONSTRAINT DF_Web_OrderProduct_UseScore DEFAULT ((0)) FOR [UseScore]
 
ALTER TABLE dbo.Web_OrderProduct ADD CONSTRAINT DF_Web_OrderProduct_IsEntity DEFAULT ((1)) FOR [IsEntity]
 
ALTER TABLE dbo.Web_OrderProduct ADD CONSTRAINT DF_Web_OrderProduct_GroupBuyID DEFAULT ((0)) FOR [GroupBuyID]
 
ALTER TABLE dbo.Web_OrderProduct ADD CONSTRAINT DF_Web_OrderProduct_SnatchID DEFAULT ((0)) FOR [SnatchID]
 
ALTER TABLE dbo.Web_OrderProduct ADD CONSTRAINT DF_Web_OrderProduct_IsFitting DEFAULT ((0)) FOR [IsFitting]
 
ALTER TABLE dbo.Web_OrderProduct ADD CONSTRAINT DF_Web_OrderProduct_FittingProductID DEFAULT ((0)) FOR [FittingProductID]
 
ALTER TABLE dbo.Web_OrderProduct ADD CONSTRAINT DF_Web_OrderProduct_IsScore DEFAULT ((0)) FOR [IsScore]
 
CREATE TABLE dbo.Tmp_Web_OrderProduct([ID] [int]  NOT NULL IDENTITY (1, 1),[OrderNumber] [nvarchar] (20)  NOT NULL,[ProductID] [int]  NOT NULL,[UserName] [nvarchar] (100)  NOT NULL,[CategoryID] [int]  NOT NULL,[Number] [nvarchar] (50)  NULL,[Count] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[Name] [nvarchar] (200)  NULL,[MarketPrice] [decimal]  (18,2) NOT NULL,[MemberPrice] [decimal]  (18,2) NOT NULL,[OrderPrice] [decimal]  (18,2) NOT NULL,[Score] [int]  NOT NULL,[Weight] [decimal]  (18,3) NOT NULL,[ActivityID] [int]  NOT NULL,[IsChangeSale] [int]  NOT NULL,[WholeSaleID] [int]  NOT NULL,[UseScore] [int]  NOT NULL,[PropertysText] [nvarchar] (2000)  NULL,[PropertysID] [nvarchar] (250)  NULL,[IsEntity] [int]  NOT NULL,[GroupBuyID] [int]  NOT NULL,[SnatchID] [int]  NOT NULL,[Src] [nvarchar] (250)  NULL,[IsFitting] [int]  NOT NULL,[FittingProductID] [int]  NOT NULL,[IsScore] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_OrderProduct ADD CONSTRAINT DF_Tmp_Web_OrderProduct_ProductID DEFAULT ((0)) FOR [ProductID]
 
ALTER TABLE dbo.Tmp_Web_OrderProduct ADD CONSTRAINT DF_Tmp_Web_OrderProduct_CategoryID DEFAULT ((0)) FOR [CategoryID]
 
ALTER TABLE dbo.Tmp_Web_OrderProduct ADD CONSTRAINT DF_Tmp_Web_OrderProduct_Count DEFAULT ((0)) FOR [Count]
 
ALTER TABLE dbo.Tmp_Web_OrderProduct ADD CONSTRAINT DF_Tmp_Web_OrderProduct_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Tmp_Web_OrderProduct ADD CONSTRAINT DF_Tmp_Web_OrderProduct_MarketPrice DEFAULT ((0)) FOR [MarketPrice]
 
ALTER TABLE dbo.Tmp_Web_OrderProduct ADD CONSTRAINT DF_Tmp_Web_OrderProduct_MemberPrice DEFAULT ((0)) FOR [MemberPrice]
 
ALTER TABLE dbo.Tmp_Web_OrderProduct ADD CONSTRAINT DF_Tmp_Web_OrderProduct_OrderPrice DEFAULT ((0)) FOR [OrderPrice]
 
ALTER TABLE dbo.Tmp_Web_OrderProduct ADD CONSTRAINT DF_Tmp_Web_OrderProduct_Score DEFAULT ((0)) FOR [Score]
 
ALTER TABLE dbo.Tmp_Web_OrderProduct ADD CONSTRAINT DF_Tmp_Web_OrderProduct_Weight DEFAULT ((0)) FOR [Weight]
 
ALTER TABLE dbo.Tmp_Web_OrderProduct ADD CONSTRAINT DF_Tmp_Web_OrderProduct_ActivityID DEFAULT ((0)) FOR [ActivityID]
 
ALTER TABLE dbo.Tmp_Web_OrderProduct ADD CONSTRAINT DF_Tmp_Web_OrderProduct_IsChangeSale DEFAULT ((0)) FOR [IsChangeSale]
 
ALTER TABLE dbo.Tmp_Web_OrderProduct ADD CONSTRAINT DF_Tmp_Web_OrderProduct_WholeSaleID DEFAULT ((0)) FOR [WholeSaleID]
 
ALTER TABLE dbo.Tmp_Web_OrderProduct ADD CONSTRAINT DF_Tmp_Web_OrderProduct_UseScore DEFAULT ((0)) FOR [UseScore]
 
ALTER TABLE dbo.Tmp_Web_OrderProduct ADD CONSTRAINT DF_Tmp_Web_OrderProduct_IsEntity DEFAULT ((1)) FOR [IsEntity]
 
ALTER TABLE dbo.Tmp_Web_OrderProduct ADD CONSTRAINT DF_Tmp_Web_OrderProduct_GroupBuyID DEFAULT ((0)) FOR [GroupBuyID]
 
ALTER TABLE dbo.Tmp_Web_OrderProduct ADD CONSTRAINT DF_Tmp_Web_OrderProduct_SnatchID DEFAULT ((0)) FOR [SnatchID]
 
ALTER TABLE dbo.Tmp_Web_OrderProduct ADD CONSTRAINT DF_Tmp_Web_OrderProduct_IsFitting DEFAULT ((0)) FOR [IsFitting]
 
ALTER TABLE dbo.Tmp_Web_OrderProduct ADD CONSTRAINT DF_Tmp_Web_OrderProduct_FittingProductID DEFAULT ((0)) FOR [FittingProductID]
 
ALTER TABLE dbo.Tmp_Web_OrderProduct ADD CONSTRAINT DF_Tmp_Web_OrderProduct_IsScore DEFAULT ((0)) FOR [IsScore]
 
SET IDENTITY_INSERT dbo.Tmp_Web_OrderProduct ON
 
IF EXISTS(SELECT * FROM dbo.Web_OrderProduct) EXEC('INSERT INTO dbo.Tmp_Web_OrderProduct ([ID],[OrderNumber],[ProductID],[UserName],[CategoryID],[Number],[Count],[Date],[Name],[MarketPrice],[MemberPrice],[OrderPrice],[Score],[Weight],[ActivityID],[IsChangeSale],[WholeSaleID],[UseScore],[PropertysText],[PropertysID],[IsEntity],[GroupBuyID],[SnatchID],[Src],[IsFitting],[FittingProductID],[IsScore]) SELECT [ID],[OrderNumber],[ProductID],[UserName],[CategoryID],[Number],[Count],[Date],[Name],[MarketPrice],[MemberPrice],[OrderPrice],[Score],[Weight],[ActivityID],[IsChangeSale],[WholeSaleID],[UseScore],[PropertysText],[PropertysID],[IsEntity],[GroupBuyID],[SnatchID],[Src],[IsFitting],[FittingProductID],[IsScore] FROM dbo.Web_OrderProduct WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_OrderProduct OFF
 
DROP TABLE dbo.Web_OrderProduct
 
EXECUTE sp_rename N'dbo.Tmp_Web_OrderProduct', N'Web_OrderProduct', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_PageControlHelp]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_PageControlHelp] 
 
CREATE TABLE dbo.Web_PageControlHelp([ID] [int]  NOT NULL,[PageControlID] [int]  NOT NULL,[Language] [nvarchar] (50)  NULL,[Content] [ntext]  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_PageControlHelp ADD CONSTRAINT DF_Web_PageControlHelp_PageControlID DEFAULT ((0)) FOR [PageControlID]
 
CREATE TABLE dbo.Tmp_Web_PageControlHelp([ID] [int]  NOT NULL IDENTITY (1, 1),[PageControlID] [int]  NOT NULL,[Language] [nvarchar] (50)  NULL,[Content] [ntext]  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_PageControlHelp ADD CONSTRAINT DF_Tmp_Web_PageControlHelp_PageControlID DEFAULT ((0)) FOR [PageControlID]
 
SET IDENTITY_INSERT dbo.Tmp_Web_PageControlHelp ON
 
IF EXISTS(SELECT * FROM dbo.Web_PageControlHelp) EXEC('INSERT INTO dbo.Tmp_Web_PageControlHelp ([ID],[PageControlID],[Language],[Content]) SELECT [ID],[PageControlID],[Language],[Content] FROM dbo.Web_PageControlHelp WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_PageControlHelp OFF
 
DROP TABLE dbo.Web_PageControlHelp
 
EXECUTE sp_rename N'dbo.Tmp_Web_PageControlHelp', N'Web_PageControlHelp', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_SystemSubject]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_SystemSubject] 
 
CREATE TABLE dbo.Web_SystemSubject([ID] [int]  NOT NULL,[IsShow] [int]  NOT NULL,[IsUrl] [int]  NOT NULL,[IsSystem] [int]  NOT NULL,[Name] [nvarchar] (50)  NULL,[Url] [nvarchar] (255)  NULL,[OrderID] [int]  NOT NULL,[Template] [nvarchar] (255)  NULL,[Title] [nvarchar] (100)  NULL,[Keywords] [nvarchar] (255)  NULL,[Description] [nvarchar] (255)  NULL,[FolderName] [nvarchar] (20)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_SystemSubject ADD CONSTRAINT DF_Web_SystemSubject_IsShow DEFAULT ((0)) FOR [IsShow]
 
ALTER TABLE dbo.Web_SystemSubject ADD CONSTRAINT DF_Web_SystemSubject_IsUrl DEFAULT ((0)) FOR [IsUrl]
 
ALTER TABLE dbo.Web_SystemSubject ADD CONSTRAINT DF_Web_SystemSubject_IsSystem DEFAULT ((0)) FOR [IsSystem]
 
ALTER TABLE dbo.Web_SystemSubject ADD CONSTRAINT DF_Web_SystemSubject_OrderID DEFAULT ((10000)) FOR [OrderID]
 
CREATE TABLE dbo.Tmp_Web_SystemSubject([ID] [int]  NOT NULL IDENTITY (1, 1),[IsShow] [int]  NOT NULL,[IsUrl] [int]  NOT NULL,[IsSystem] [int]  NOT NULL,[Name] [nvarchar] (50)  NULL,[Url] [nvarchar] (255)  NULL,[OrderID] [int]  NOT NULL,[Template] [nvarchar] (255)  NULL,[Title] [nvarchar] (100)  NULL,[Keywords] [nvarchar] (255)  NULL,[Description] [nvarchar] (255)  NULL,[FolderName] [nvarchar] (20)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_SystemSubject ADD CONSTRAINT DF_Tmp_Web_SystemSubject_IsShow DEFAULT ((0)) FOR [IsShow]
 
ALTER TABLE dbo.Tmp_Web_SystemSubject ADD CONSTRAINT DF_Tmp_Web_SystemSubject_IsUrl DEFAULT ((0)) FOR [IsUrl]
 
ALTER TABLE dbo.Tmp_Web_SystemSubject ADD CONSTRAINT DF_Tmp_Web_SystemSubject_IsSystem DEFAULT ((0)) FOR [IsSystem]
 
ALTER TABLE dbo.Tmp_Web_SystemSubject ADD CONSTRAINT DF_Tmp_Web_SystemSubject_OrderID DEFAULT ((10000)) FOR [OrderID]
 
SET IDENTITY_INSERT dbo.Tmp_Web_SystemSubject ON
 
IF EXISTS(SELECT * FROM dbo.Web_SystemSubject) EXEC('INSERT INTO dbo.Tmp_Web_SystemSubject ([ID],[IsShow],[IsUrl],[IsSystem],[Name],[Url],[OrderID],[Template],[Title],[Keywords],[Description],[FolderName]) SELECT [ID],[IsShow],[IsUrl],[IsSystem],[Name],[Url],[OrderID],[Template],[Title],[Keywords],[Description],[FolderName] FROM dbo.Web_SystemSubject WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_SystemSubject OFF
 
DROP TABLE dbo.Web_SystemSubject
 
EXECUTE sp_rename N'dbo.Tmp_Web_SystemSubject', N'Web_SystemSubject', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_PriceDetail]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_PriceDetail] 
 
CREATE TABLE dbo.Web_PriceDetail([ProductDetailID] [int]  NOT NULL,[GroupID] [int]  NOT NULL,[Price] [decimal]  (18,2) NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_PriceDetail ADD CONSTRAINT DF_Web_PriceDetail_ProductDetailID DEFAULT ((0)) FOR [ProductDetailID]
 
ALTER TABLE dbo.Web_PriceDetail ADD CONSTRAINT DF_Web_PriceDetail_GroupID DEFAULT ((0)) FOR [GroupID]
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_RuleCategory]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_RuleCategory] 
 
CREATE TABLE dbo.Web_RuleCategory([ID] [int]  NOT NULL,[Name] [nvarchar] (30)  NULL,[Level] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_RuleCategory ADD CONSTRAINT DF_Web_RuleCategory_Level DEFAULT ((0)) FOR [Level]
 
CREATE TABLE dbo.Tmp_Web_RuleCategory([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (30)  NULL,[Level] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_RuleCategory ADD CONSTRAINT DF_Tmp_Web_RuleCategory_Level DEFAULT ((0)) FOR [Level]
 
SET IDENTITY_INSERT dbo.Tmp_Web_RuleCategory ON
 
IF EXISTS(SELECT * FROM dbo.Web_RuleCategory) EXEC('INSERT INTO dbo.Tmp_Web_RuleCategory ([ID],[Name],[Level]) SELECT [ID],[Name],[Level] FROM dbo.Web_RuleCategory WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_RuleCategory OFF
 
DROP TABLE dbo.Web_RuleCategory
 
EXECUTE sp_rename N'dbo.Tmp_Web_RuleCategory', N'Web_RuleCategory', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_GroupBuy]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_GroupBuy] 
 
CREATE TABLE dbo.Web_GroupBuy([ID] [int]  NOT NULL,[ProductID] [int]  NOT NULL,[Price] [int]  NOT NULL,[NeedPrice] [decimal]  (18,2) NOT NULL,[Storage] [int]  NOT NULL,[Score] [int]  NOT NULL,[Content] [ntext]  NOT NULL,[StartDate] [datetime]  NOT NULL,[EndDate] [datetime]  NOT NULL,[MaxCount] [int]  NOT NULL,[IsSuccess] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[SrcDetail] [nvarchar] (250)  NOT NULL,[SrcList] [nvarchar] (250)  NOT NULL,[Name] [nvarchar] (100)  NOT NULL,[MarketPrice] [decimal]  (18,2) NOT NULL,[IsShowPro] [int]  NOT NULL,[OrderID] [int]  NOT NULL,[BuyCount] [int]  NOT NULL,[HitCount] [int]  NOT NULL,[IsOrder] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_GroupBuy ADD CONSTRAINT DF_Web_GroupBuy_ProductID DEFAULT ((0)) FOR [ProductID]
 
ALTER TABLE dbo.Web_GroupBuy ADD CONSTRAINT DF_Web_GroupBuy_Price DEFAULT ((0)) FOR [Price]
 
ALTER TABLE dbo.Web_GroupBuy ADD CONSTRAINT DF_Web_GroupBuy_NeedPrice DEFAULT ((0)) FOR [NeedPrice]
 
ALTER TABLE dbo.Web_GroupBuy ADD CONSTRAINT DF_Web_GroupBuy_Storage DEFAULT ((0)) FOR [Storage]
 
ALTER TABLE dbo.Web_GroupBuy ADD CONSTRAINT DF_Web_GroupBuy_Score DEFAULT ((0)) FOR [Score]
 
ALTER TABLE dbo.Web_GroupBuy ADD CONSTRAINT DF_Web_GroupBuy_Content DEFAULT ('') FOR [Content]
 
ALTER TABLE dbo.Web_GroupBuy ADD CONSTRAINT DF_Web_GroupBuy_StartDate DEFAULT (getdate()) FOR [StartDate]
 
ALTER TABLE dbo.Web_GroupBuy ADD CONSTRAINT DF_Web_GroupBuy_EndDate DEFAULT (getdate()) FOR [EndDate]
 
ALTER TABLE dbo.Web_GroupBuy ADD CONSTRAINT DF_Web_GroupBuy_MaxCount DEFAULT ((0)) FOR [MaxCount]
 
ALTER TABLE dbo.Web_GroupBuy ADD CONSTRAINT DF_Web_GroupBuy_IsSuccess DEFAULT ((0)) FOR [IsSuccess]
 
ALTER TABLE dbo.Web_GroupBuy ADD CONSTRAINT DF_Web_GroupBuy_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Web_GroupBuy ADD CONSTRAINT DF_Web_GroupBuy_SrcDetail DEFAULT ('') FOR [SrcDetail]
 
ALTER TABLE dbo.Web_GroupBuy ADD CONSTRAINT DF_Web_GroupBuy_SrcList DEFAULT ('') FOR [SrcList]
 
ALTER TABLE dbo.Web_GroupBuy ADD CONSTRAINT DF_Web_GroupBuy_Name DEFAULT ('') FOR [Name]
 
ALTER TABLE dbo.Web_GroupBuy ADD CONSTRAINT DF_Web_GroupBuy_MarketPrice DEFAULT ((0)) FOR [MarketPrice]
 
ALTER TABLE dbo.Web_GroupBuy ADD CONSTRAINT DF_Web_GroupBuy_IsShowPro DEFAULT ((0)) FOR [IsShowPro]
 
ALTER TABLE dbo.Web_GroupBuy ADD CONSTRAINT DF_Web_GroupBuy_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Web_GroupBuy ADD CONSTRAINT DF_Web_GroupBuy_BuyCount DEFAULT ((0)) FOR [BuyCount]
 
ALTER TABLE dbo.Web_GroupBuy ADD CONSTRAINT DF_Web_GroupBuy_HitCount DEFAULT ((0)) FOR [HitCount]
 
ALTER TABLE dbo.Web_GroupBuy ADD CONSTRAINT DF_Web_GroupBuy_IsOrder DEFAULT ((0)) FOR [IsOrder]
 
CREATE TABLE dbo.Tmp_Web_GroupBuy([ID] [int]  NOT NULL IDENTITY (1, 1),[ProductID] [int]  NOT NULL,[Price] [int]  NOT NULL,[NeedPrice] [decimal]  (18,2) NOT NULL,[Storage] [int]  NOT NULL,[Score] [int]  NOT NULL,[Content] [ntext]  NOT NULL,[StartDate] [datetime]  NOT NULL,[EndDate] [datetime]  NOT NULL,[MaxCount] [int]  NOT NULL,[IsSuccess] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[SrcDetail] [nvarchar] (250)  NOT NULL,[SrcList] [nvarchar] (250)  NOT NULL,[Name] [nvarchar] (100)  NOT NULL,[MarketPrice] [decimal]  (18,2) NOT NULL,[IsShowPro] [int]  NOT NULL,[OrderID] [int]  NOT NULL,[BuyCount] [int]  NOT NULL,[HitCount] [int]  NOT NULL,[IsOrder] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_GroupBuy ADD CONSTRAINT DF_Tmp_Web_GroupBuy_ProductID DEFAULT ((0)) FOR [ProductID]
 
ALTER TABLE dbo.Tmp_Web_GroupBuy ADD CONSTRAINT DF_Tmp_Web_GroupBuy_Price DEFAULT ((0)) FOR [Price]
 
ALTER TABLE dbo.Tmp_Web_GroupBuy ADD CONSTRAINT DF_Tmp_Web_GroupBuy_NeedPrice DEFAULT ((0)) FOR [NeedPrice]
 
ALTER TABLE dbo.Tmp_Web_GroupBuy ADD CONSTRAINT DF_Tmp_Web_GroupBuy_Storage DEFAULT ((0)) FOR [Storage]
 
ALTER TABLE dbo.Tmp_Web_GroupBuy ADD CONSTRAINT DF_Tmp_Web_GroupBuy_Score DEFAULT ((0)) FOR [Score]
 
ALTER TABLE dbo.Tmp_Web_GroupBuy ADD CONSTRAINT DF_Tmp_Web_GroupBuy_Content DEFAULT ('') FOR [Content]
 
ALTER TABLE dbo.Tmp_Web_GroupBuy ADD CONSTRAINT DF_Tmp_Web_GroupBuy_StartDate DEFAULT (getdate()) FOR [StartDate]
 
ALTER TABLE dbo.Tmp_Web_GroupBuy ADD CONSTRAINT DF_Tmp_Web_GroupBuy_EndDate DEFAULT (getdate()) FOR [EndDate]
 
ALTER TABLE dbo.Tmp_Web_GroupBuy ADD CONSTRAINT DF_Tmp_Web_GroupBuy_MaxCount DEFAULT ((0)) FOR [MaxCount]
 
ALTER TABLE dbo.Tmp_Web_GroupBuy ADD CONSTRAINT DF_Tmp_Web_GroupBuy_IsSuccess DEFAULT ((0)) FOR [IsSuccess]
 
ALTER TABLE dbo.Tmp_Web_GroupBuy ADD CONSTRAINT DF_Tmp_Web_GroupBuy_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Tmp_Web_GroupBuy ADD CONSTRAINT DF_Tmp_Web_GroupBuy_SrcDetail DEFAULT ('') FOR [SrcDetail]
 
ALTER TABLE dbo.Tmp_Web_GroupBuy ADD CONSTRAINT DF_Tmp_Web_GroupBuy_SrcList DEFAULT ('') FOR [SrcList]
 
ALTER TABLE dbo.Tmp_Web_GroupBuy ADD CONSTRAINT DF_Tmp_Web_GroupBuy_Name DEFAULT ('') FOR [Name]
 
ALTER TABLE dbo.Tmp_Web_GroupBuy ADD CONSTRAINT DF_Tmp_Web_GroupBuy_MarketPrice DEFAULT ((0)) FOR [MarketPrice]
 
ALTER TABLE dbo.Tmp_Web_GroupBuy ADD CONSTRAINT DF_Tmp_Web_GroupBuy_IsShowPro DEFAULT ((0)) FOR [IsShowPro]
 
ALTER TABLE dbo.Tmp_Web_GroupBuy ADD CONSTRAINT DF_Tmp_Web_GroupBuy_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Tmp_Web_GroupBuy ADD CONSTRAINT DF_Tmp_Web_GroupBuy_BuyCount DEFAULT ((0)) FOR [BuyCount]
 
ALTER TABLE dbo.Tmp_Web_GroupBuy ADD CONSTRAINT DF_Tmp_Web_GroupBuy_HitCount DEFAULT ((0)) FOR [HitCount]
 
ALTER TABLE dbo.Tmp_Web_GroupBuy ADD CONSTRAINT DF_Tmp_Web_GroupBuy_IsOrder DEFAULT ((0)) FOR [IsOrder]
 
SET IDENTITY_INSERT dbo.Tmp_Web_GroupBuy ON
 
IF EXISTS(SELECT * FROM dbo.Web_GroupBuy) EXEC('INSERT INTO dbo.Tmp_Web_GroupBuy ([ID],[ProductID],[Price],[NeedPrice],[Storage],[Score],[Content],[StartDate],[EndDate],[MaxCount],[IsSuccess],[Date],[SrcDetail],[SrcList],[Name],[MarketPrice],[IsShowPro],[OrderID],[BuyCount],[HitCount],[IsOrder]) SELECT [ID],[ProductID],[Price],[NeedPrice],[Storage],[Score],[Content],[StartDate],[EndDate],[MaxCount],[IsSuccess],[Date],[SrcDetail],[SrcList],[Name],[MarketPrice],[IsShowPro],[OrderID],[BuyCount],[HitCount],[IsOrder] FROM dbo.Web_GroupBuy WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_GroupBuy OFF
 
DROP TABLE dbo.Web_GroupBuy
 
EXECUTE sp_rename N'dbo.Tmp_Web_GroupBuy', N'Web_GroupBuy', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_EmailGroupUser]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_EmailGroupUser] 
 
CREATE TABLE dbo.Web_EmailGroupUser([GroupID] [int]  NOT NULL,[UserName] [nvarchar] (50)  NOT NULL)  ON [PRIMARY] 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Page]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Page] 
 
CREATE TABLE dbo.Web_Page([ID] [int]  NOT NULL,[Name] [nvarchar] (50)  NOT NULL,[CategoryCode] [nvarchar] (50)  NOT NULL,[Ico] [nvarchar] (150)  NULL,[OrderID] [int]  NOT NULL,[IsDel] [int]  NOT NULL,[FirstID] [int]  NOT NULL,[SecondID] [int]  NOT NULL,[ThirdID] [int]  NOT NULL,[SubSystemID] [int]  NOT NULL,[Description] [nvarchar] (250)  NULL,[FilePath] [nvarchar] (250)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Page ADD CONSTRAINT DF_Web_Page_CategoryCode DEFAULT ('') FOR [CategoryCode]
 
ALTER TABLE dbo.Web_Page ADD CONSTRAINT DF_Web_Page_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Web_Page ADD CONSTRAINT DF_Web_Page_IsDel DEFAULT ((0)) FOR [IsDel]
 
ALTER TABLE dbo.Web_Page ADD CONSTRAINT DF_Web_Page_FirstID DEFAULT ((0)) FOR [FirstID]
 
ALTER TABLE dbo.Web_Page ADD CONSTRAINT DF_Web_Page_SecondID DEFAULT ((0)) FOR [SecondID]
 
ALTER TABLE dbo.Web_Page ADD CONSTRAINT DF_Web_Page_ThirdID DEFAULT ((0)) FOR [ThirdID]
 
ALTER TABLE dbo.Web_Page ADD CONSTRAINT DF_Web_Page_SubSystemID DEFAULT ((0)) FOR [SubSystemID]
 
INSERT INTO Web_Page VALUES ('1','公告管理','MenuPage','','1','0','1','1','0','0','','System_Notice_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('2','图片模块','MenuPage','','6','0','2','0','0','0','','')
 
INSERT INTO Web_Page VALUES ('3','图片类别管理','MenuPage','','1','0','2','1','0','0','','Picture_Category_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('4','图片管理','MenuPage','','2','0','2','2','0','0','','Picture_Picture_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('5','来电速记模块','MenuPage','','9','0','3','0','0','0','','')
 
INSERT INTO Web_Page VALUES ('6','来电速记管理','MenuPage','','1','0','3','1','0','0','','TelphoneRecord_TelRecord_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('7','文档模块','MenuPage','','8','0','4','0','0','0','','')
 
INSERT INTO Web_Page VALUES ('8','文档类别管理','MenuPage','','1','0','4','1','0','0','','Document_Category_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('9','文档管理','MenuPage','','2','0','4','2','0','0','','Document_Document_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('10','参数设置','MenuPage','','2','0','1','2','0','0','','System_Config_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('11','地区管理','MenuPage','','3','0','1','3','0','0','','System_Area_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('12','配送方式管理','MenuPage','','5','0','1','4','0','0','','System_Delivery_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('13','配送区域管理','FlowPage','','0','0','1','5','0','0','','System_DeliveryArea_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('14','帮助分类管理','MenuPage','','8','0','1','6','0','0','','System_HelpCategory_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('15','广告系统','MenuPage','','7','0','5','0','0','0','','')
 
INSERT INTO Web_Page VALUES ('16','广告分类管理','MenuPage','','1','0','5','1','0','0','','Advertisement_AdsCategory_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('17','广告管理','MenuPage','','2','0','5','2','0','0','','Advertisement_Ads_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('18','帮助管理','MenuPage','','9','0','1','7','0','0','','System_Help_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('19','邮件服务管理','MenuPage','','6','0','1','8','0','0','','System_EmailConfig_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('20','友情链接管理','MenuPage','','10','0','1','9','0','0','','System_Link_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('21','其它系统','MenuPage','','16','0','7','0','0','0','','')
 
INSERT INTO Web_Page VALUES ('22','短信管理','MenuPage','','1','0','7','1','0','0','','Others_Msg_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('23','短信添加','MenuPage','','2','0','7','3','0','0','','Others_Msg_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('24','搜索关键字管理','MenuPage','','11','0','1','10','0','0','','System_SearchKey_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('25','在线调查管理','MenuPage','','3','0','7','4','0','0','','Other_Vote_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('26','权限管理','MenuPage','','15','0','6','0','0','0','','')
 
INSERT INTO Web_Page VALUES ('27','操作员管理','MenuPage','','1','0','6','1','0','0','','Tool_Admin_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('28','日志管理','MenuPage','','12','0','6','2','0','0','','Tool_AdminLog_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('29','权限组页面分配','MenuPage','','6','0','6','3','0','0','','Tool_PagePower_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('30','页面管理','MenuPage','','7','0','6','4','0','0','','Tool_Page_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('31','系统设置','MenuPage','','1','0','1','0','0','0','','')
 
INSERT INTO Web_Page VALUES ('32','分配权限组','MenuPage','','5','0','6','5','0','0','','Tool_AdminRole_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('33','部门管理','MenuPage','','2','0','6','6','0','0','','Tool_Department_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('34','部门分配','MenuPage','','3','0','6','7','0','0','','Tool_DeptAdmin_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('35','页面控件管理','MenuPage','','8','0','6','8','0','0','','Tool_PageControl_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('36','权限组管理','MenuPage','','4','0','6','9','0','0','','Tool_Role_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('37','邮件管理','MenuPage','','11','0','8','0','0','0','','')
 
INSERT INTO Web_Page VALUES ('38','订阅类型管理','MenuPage','','1','0','8','1','0','0','','Email_SubscriptionCategory_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('39','邮件订阅管理','MenuPage','','2','0','8','2','0','0','','Email_Subscription_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('40','模板/标签系统','MenuPage','','12','0','9','0','0','0','','')
 
INSERT INTO Web_Page VALUES ('41','模板风格管理','MenuPage','','1','0','9','1','0','0','','Template_Template_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('42','模板标签管理','MenuPage','','3','0','9','3','0','0','','Template_Lable_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('43','模板样式管理','MenuPage','','5','0','9','4','0','0','','Template_Style_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('44','邮件类别','MenuPage','','3','0','8','3','0','0','','Email_EmailCategory_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('45','权限组控件分配','MenuPage','','9','0','6','10','0','0','','Tool_PageControlPower_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('46','模板页面管理','MenuPage','','2','0','9','2','0','0','','Template_Page_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('47','模板图片管理','MenuPage','','6','0','9','6','0','0','','Template_Picture_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('48','CSS资源管理','MenuPage','','8','0','9','8','0','0','','Template_Css_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('49','邮件内容管理','MenuPage','','4','0','8','4','0','0','','Email_EmailContent_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('50','后台帮助管理','MenuPage','','11','0','6','11','0','0','','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('51','邮件组管理','MenuPage','','5','0','8','5','0','0','','Email_EmailGroup_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('52','模板图片分类','MenuPage','','7','0','9','7','0','0','','Template_PictureCategory_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('53','邮件发送记录','MenuPage','','7','0','8','6','0','0','','Email_EmailLog_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('54','IP过滤管理','MenuPage','','4','0','7','5','0','0','','Other_BlackIP_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('55','菜单管理','MenuPage','','8','0','7','6','0','0','','Other_Menu_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('56','菜单类别管理','MenuPage','','7','0','7','7','0','0','','Other_MenuCategory_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('57','系统扩展','MenuPage','','13','0','10','0','0','0','','')
 
INSERT INTO Web_Page VALUES ('58','客服通整合','MenuPage','','1','0','10','1','0','0','','Kft_kft_api.aspx')
 
INSERT INTO Web_Page VALUES ('59','文章系统','MenuPage','','10','0','11','0','0','0','','')
 
INSERT INTO Web_Page VALUES ('60','文章分类管理','MenuPage','','1','0','11','1','0','0','','Article_ArticleCategory_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('61','文章管理','MenuPage','','2','0','11','2','0','0','','Article_Article_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('62','来电速记添加','MenuPage','','2','0','3','2','0','0','','TelphoneRecord_Telrecord_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('63','威博客服通注册','MenuPage','','2','0','10','2','0','0','','Kft_Kft_Register.aspx')
 
INSERT INTO Web_Page VALUES ('64','客服通登陆','MenuPage','','3','0','10','3','0','0','','Kft_Kft_Login.aspx')
 
INSERT INTO Web_Page VALUES ('65','商品管理','MenuPage','','2','0','12','0','0','0','','')
 
INSERT INTO Web_Page VALUES ('66','品牌管理','MenuPage','','1','0','12','1','0','0','','Product_Brand_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('67','商品分类管理','MenuPage','','3','0','12','2','0','0','','Product_Category_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('68','文章评论管理','MenuPage','','3','0','11','12','0','0','','Article_ArticleReview_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('69','会员管理','MenuPage','','3','0','13','0','0','0','','')
 
INSERT INTO Web_Page VALUES ('70','会员管理','MenuPage','','1','0','13','14','0','0','','User_User_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('71','商品类型管理','MenuPage','','2','0','12','13','0','0','','Product_ProductType_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('72','会员添加更新','FlowPage','','0','0','13','14','14','0','','User_User_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('73','会员等级管理','MenuPage','','2','0','13','14','0','0','','User_UserGroup_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('74','会员留言管理','MenuPage','','6','0','13','14','0','0','','User_GBook_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('75','编号规则管理','MenuPage','','4','0','12','13','0','0','','Product_RuleCategory_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('76','会员卡管理','MenuPage','','3','0','13','14','0','0','','User_UserCard_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('77','商品单位管理','MenuPage','','5','0','12','13','0','0','','Product_Unit_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('78','商品管理','MenuPage','','7','0','12','13','0','0','','Product_Product_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('79','添加新商品','MenuPage','','6','0','12','13','0','0','','Product_Product_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('80','购物卡管理','MenuPage','','4','0','13','14','0','0','','User_ShopCard_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('81','充值卡管理','MenuPage','','5','0','13','14','0','0','','User_PriceCard_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('82','促销模块管理','MenuPage','','5','0','14','0','0','0','','')
 
INSERT INTO Web_Page VALUES ('83','夺宝奇兵管理','MenuPage','','1','0','14','15','0','0','','Promotions_IndianaJones_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('84','夺宝奇兵添加编辑','FlowPage','','0','0','14','15','15','0','','Promotions_IndianaJones_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('85','商品包装管理','MenuPage','','2','0','14','15','0','0','','Promotions_ProductPackage_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('86','商品包装添加编辑','FlowPage','','0','0','14','15','1','0','','Promotions_ProductPackage_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('87','祝福贺卡管理','MenuPage','','3','0','14','15','0','0','','Promotions_GreetingCard_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('88','祝福贺卡添加编辑','FlowPage','','0','0','14','15','1','0','','Promotions_GreetingCard_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('89','商品导购管理','MenuPage','','4','0','14','15','0','0','','Promotions_Guide_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('90','邮件变量管理','MenuPage','','8','0','8','9','0','0','','Email_EmailVariableTable_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('91','邮件变量字段管理','MenuPage','UploadFile/Picture/20086137233.jpg','9','0','8','9','0','0','','Email_EmailVariableField_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('92','优惠券管理','MenuPage','','5','0','14','15','0','0','','Promotions_Coupon_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('93','团购管理','MenuPage','','6','0','14','15','0','0','','Promotions_GroupBuy_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('94','优惠活动管理','MenuPage','','7','0','14','15','0','0','','Promotions_Activity_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('95','优惠活动添加编辑','FlowPage','','0','0','14','15','15','0','','Promotions_Activity_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('96','批发方案管理','MenuPage','','0','0','14','15','0','0','','Promotions_WholeSale_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('97','虚拟卡列表','MenuPage','','8','0','12','13','0','0','','Product_VirtualCard_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('98','标签类别管理','MenuPage','','4','0','9','3','0','0','','Template_Lable_Category_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('99','模板标签添加/编辑','DailogPage','','0','0','9','3','10','0','','Template_Lable_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('100','样式添加/编辑','FlowPage','','0','0','9','4','1','0','','Template_Style_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('101','广告管理添加/编辑','FlowPage','','0','0','5','2','6','0','','Advertisement_Ads_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('102','广告管理对话框','DailogPage','','0','0','5','2','6','0','','Advertisement_Ads_Operate_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('103','广告分类对话框','DailogPage','','0','0','5','1','1','0','','Advertisement_AdsCategory_Manage_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('104','文章编辑','FlowPage','','0','0','11','2','12','0','','Article_Article_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('105','广告分类添加/编辑','FlowPage','','0','0','5','1','6','0','','Advertisement_AdsCategory_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('106','文章分类对话框','DailogPage','','0','0','11','1','12','0','','Article_ArticleCategory_Manage_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('107','类别样式弹出页','DailogPage','','0','0','9','4','10','0','','Template_Lable_Category_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('108','文章分类添加/编辑','FlowPage','','0','0','11','1','12','0','','Article_ArticleCategory_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('109','文章评论添加/编辑','FlowPage','','0','0','11','12','12','0','','Article_ArticleReview_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('110','邮件类别添加/编辑','FlowPage','','0','0','8','3','9','0','','Email_EmailCategory_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('111','邮件内容添加/编辑','FlowPage','','0','0','8','4','9','0','','Email_EmailContent_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('112','邮件组用户添加/编辑','FlowPage','','0','0','8','5','9','0','','Email_EmailGroupUser_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('113','邮件组添加/编辑','FlowPage','','0','0','8','5','9','0','','Email_EmailGroup_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('114','订阅类型添加/编辑','FlowPage','','0','0','8','1','9','0','','Email_SubscriptionCategory_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('115','IP过滤添加/编辑','FlowPage','','0','0','7','5','8','0','','Other_BlackIP_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('116','文章标签管理','DailogPage','','0','0','9','3','10','0','','Template_Lable_Article_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('117','商品标签管理','DailogPage','','0','0','9','3','10','0','','Template_Lable_Malls_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('118','在线调查添加/编辑','FlowPage','','0','0','7','4','8','0','','Other_Vote_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('119','商品常规标签管理','DailogPage','','0','0','9','3','10','0','','Template_Lable_Malls_Link_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('120','品牌列表对话框','DailogPage','','0','0','9','3','10','0','','Template_Lable_Brand_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('121','品牌常规标签管理','DailogPage','','0','0','9','3','10','0','','Template_Lable_Brand_Link_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('122','优惠卷列表标签管理','DailogPage','','0','0','9','3','10','0','','Template_Lable_Coupon_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('123','优惠卷常规标签管理','DailogPage','','0','0','9','3','10','0','','Template_Lable_Coupon_Link_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('124','团购列表标签管理','DailogPage','','0','0','9','3','10','0','','Template_Lable_Group_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('125','导购列表标签管理','DailogPage','','0','0','9','3','10','0','','Template_Lable_Guide_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('126','导购常规标签管理','DailogPage','','0','0','9','3','10','0','','Template_Lable_Guide_Link_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('127','活动样式弹出页','DailogPage','','0','0','9','3','10','0','','Template_Style_Activity_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('128','文章样式弹出页','DailogPage','','0','0','9','4','10','0','','Template_Style_Article_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('129','品牌样式弹出页','DailogPage','','0','0','9','4','10','0','','Template_Style_Brand_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('130','综合类样式弹出页','DailogPage','','0','0','9','4','10','0','','Template_Style_Common_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('131','优惠卷样式弹出页','DailogPage','','0','0','9','4','10','0','','Template_Style_Coupon_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('132','团购样式弹出页','DailogPage','','0','0','9','4','10','0','','Template_Style_Group_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('133','导购样式弹出页','DailogPage','','0','0','9','4','10','0','','Template_Style_Guide_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('134','图片管理对话框','DailogPage','','0','0','2','2','3','0','','Picture_Picture_Manage_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('135','公告样式弹出页','DailogPage','','0','0','9','4','10','0','','Template_Style_Notice_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('136','品牌添加/编辑','FlowPage','','0','0','12','1','13','0','','Product_Brand_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('137','商品样式弹出页','DailogPage','','0','0','9','4','10','0','','Template_Style_Manage_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('138','品牌分类添加/编辑','FlowPage','','0','0','12','1','13','0','','Product_BrandCategory_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('139','商品分类添加/编辑','FlowPage','','0','0','12','2','13','0','','Product_Category_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('140','相关分类','FlowPage','','0','0','12','2','13','0','','Product_CategoryBrand_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('141','商品配件管理','FlowPage','','0','0','12','13','1','0','','Product_FittingType_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('142','商品配件添加/编辑','FlowPage','','0','0','12','13','2','0','','Product_FittingType_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('143','商品分类_对话框','DailogPage','','0','0','12','2','13','0','','Product_ProductCategory_Manage_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('144','商品类型添加/编辑','FlowPage','','0','0','12','13','13','0','','Product_ProductType_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('145','商品属性管理','FlowPage','','0','0','12','13','3','0','','Product_Property_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('146','商品属性添加/编辑','FlowPage','','0','0','12','13','13','0','','Product_Property_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('147','商品规则管理','FlowPage','','0','0','12','13','13','0','','Product_Rule_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('148','优惠卷生成','FlowPage','','0','0','14','15','15','0','','Promotions_Coupon_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('149','团购添加/编辑','FlowPage','','0','0','14','15','15','0','','Promotions_GroupBuy_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('150','商品导购添加/编辑','FlowPage','','0','0','14','15','15','0','','Promotions_Guide_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('151','夺宝奇兵对话框','DailogPage','','0','0','14','15','15','0','','Promotions_IndianaJones_Dailog.aspx')
 
INSERT INTO Web_Page VALUES ('152','批发方案添加/编辑','FlowPage','','0','0','14','15','15','0','','Promotions_WholeSale_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('153','配送区域添加/编辑','FlowPage','','0','0','1','5','2','0','','System_DeliveryArea_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('154','邮件服务添加/编辑','FlowPage','','0','0','1','8','2','0','','System_EmailConfig_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('155','帮助信息添加/编辑','FlowPage','','0','0','1','7','2','0','','System_Help_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('156','帮助分类添加/编辑','FlowPage','','0','0','1','6','2','0','','System_HelpCategory_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('157','站点发布功能','FlowPage','','0','0','1','2','2','0','','System_Html_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('158','友情链接添加/编辑','FlowPage','','0','0','1','9','2','0','','System_Link_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('159','公告添加/编辑','FlowPage','','0','0','1','1','2','0','','System_Notice_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('160','搜索关键字添加/编辑','FlowPage','','0','0','1','10','2','0','','System_SearchKey_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('161','CSS资源添加/编辑','FlowPage','','0','0','9','8','10','0','','Template_Css_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('162','文章标签管理','FlowPage','','0','0','9','3','10','0','','Template_Lable_Article_Link_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('163','模块标签选择对话框','DailogPage','','0','0','9','3','10','0','','Template_Lable_Manage_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('164','模块页面添加/编辑','FlowPage','','0','0','9','2','10','0','','Template_Page_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('165','图片资源选择对话框','FlowPage','','0','0','9','6','10','0','','Template_Picture_Manage_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('166','商品感言标签弹出页','DailogPage','','0','0','9','3','10','0','','Template_Style_Feeling_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('167','礼品标签管理','DailogPage','','0','0','9','3','10','0','','Template_Style_Gift_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('168','商品常规样式选择','DailogPage','','0','0','9','4','10','0','','Template_Style_MallLink_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('169','模块添加/编辑','FlowPage','','0','0','9','2','10','0','','Template_Template_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('170','冻结资金/积分','FlowPage','','0','0','13','14','14','0','','User_Freeze_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('171','会员留言添加/编辑','FlowPage','','0','0','13','14','14','0','','User_GBook_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('172','查看收货地址','FlowPage','','0','0','13','14','14','0','','User_UserAddress_List.aspx')
 
INSERT INTO Web_Page VALUES ('173','会员卡生成','FlowPage','','0','0','13','14','14','0','','User_UserCard_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('174','会员等级添加/编辑','FlowPage','','0','0','13','14','14','0','','User_UserGroup_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('175','商品评论管理','MenuPage','UploadFile/Picture/074416341832680.gif','11','0','12','13','0','0','','Product_ProductReview_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('176','商品评论回复','FlowPage','','0','0','12','13','13','0','','Product_ProductReview_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('177','商品感言管理','MenuPage','','0','0','12','13','0','0','','Product_ProductThanks_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('178','换购商品管理','MenuPage','','9','0','12','13','0','0','','Product_ProductChange_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('179','积分商品管理','MenuPage','','10','0','12','13','0','0','','Product_ProductScore_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('180','库存管理','MenuPage','','12','0','12','13','0','0','','Product_StockLog_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('181','后台登录密码修改','MenuPage','','10','0','6','7','0','0','','Tool_ChangePassword_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('182','库存添加','FlowPage','','0','0','12','13','0','0','','Product_StockLog_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('183','缺货登记管理','MenuPage','','13','0','12','13','0','0','','Product_OutStock_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('184','缺货处理','FlowPage','','0','0','12','13','0','0','','Product_OutStock_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('185','积分操作','FlowPage','','0','0','13','14','14','0','','User_UserScore_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('186','发货通知管理','MenuPage','','14','0','12','13','0','0','','Product_ShippingAdvice_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('187','发货通知添加','FlowPage','','0','0','12','13','0','0','','Product_ShippingAdvice_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('188','商品批量上传','MenuPage','','15','0','12','13','0','0','','Product_MultiUpLoad_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('189','团购常规标签管理','DailogPage','','0','0','9','3','10','0','','Template_Lable_Group_Link_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('190','夺宝奇兵列表标签管理','DailogPage','','0','0','9','3','10','0','','Template_Lable_Snatch_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('191','夺宝奇兵常规标签管理','DailogPage','','0','0','9','3','10','0','','Template_Lable_Snatch_Link_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('192','夺宝奇兵样式弹出页','DailogPage','','0','0','9','4','10','0','','Template_Style_Snatch_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('193','活动列表标签管理','DailogPage','','0','0','9','3','10','0','','Template_Lable_Activity_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('194','活动常规标签管理','DailogPage','','0','0','9','3','10','0','','Template_Lable_Activity_Link_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('195','订单管理','MenuPage','','4','0','15','0','0','0','','')
 
INSERT INTO Web_Page VALUES ('196','订单管理','MenuPage','','1','0','15','16','0','0','','Order_Order_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('197','商品批量编辑','MenuPage','','16','0','12','13','0','0','','Product_MultiEditProduct_List.aspx')
 
INSERT INTO Web_Page VALUES ('198','订单添加_会员选择','FlowPage','','1','0','15','16','16','0','','Order_Order_Add_User.aspx')
 
INSERT INTO Web_Page VALUES ('199','批量编辑操作页','FlowPage','','0','0','12','13','0','0','','Product_MultiEditProduct_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('200','订单添加_商品选择','FlowPage','','0','0','15','16','16','0','','Order_Order_Add_Product.aspx')
 
INSERT INTO Web_Page VALUES ('201','站点地图','MenuPage','','12','0','1','2','0','0','','System_SiteMap_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('202','网站空间查看','MenuPage','','6','0','7','8','0','0','','Other_Space_View.aspx')
 
INSERT INTO Web_Page VALUES ('203','订单添加_购物车处理','FlowPage','','0','0','15','16','16','0','','Order_Order_Add_Cart.aspx')
 
INSERT INTO Web_Page VALUES ('204','订单添加_设置收货人信息','FlowPage','','0','0','15','16','16','0','','Order_Order_Add_RecvInfo.aspx')
 
INSERT INTO Web_Page VALUES ('205','图片批量上传对话框','DailogPage','','0','0','9','6','10','0','','Template_Picture_Upload_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('206','订单添加_配送方式选择','FlowPage','','0','0','15','16','16','0','','Order_Order_Add_Delivery.aspx')
 
INSERT INTO Web_Page VALUES ('207','订单添加_支付方式选择','FlowPage','','0','0','15','16','16','0','','Order_Order_Add_Payment.aspx')
 
INSERT INTO Web_Page VALUES ('208','订单添加_包装选择','FlowPage','','0','0','15','16','16','0','','Order_Order_Add_Package.aspx')
 
INSERT INTO Web_Page VALUES ('209','订单添加_贺卡选择','FlowPage','','0','0','15','16','16','0','','Order_Order_Add_GreetingCard.aspx')
 
INSERT INTO Web_Page VALUES ('210','邮件变量选择','FlowPage','','0','0','8','9','0','0','','Email_EmailContent_Operate_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('211','订单添加_其它信息','FlowPage','','0','0','15','16','16','0','','Order_Order_Add_Others.aspx')
 
INSERT INTO Web_Page VALUES ('212','邮件群发管理','MenuPage','','6','0','8','9','0','0','','Email_GroupSend_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('213','订单添加_完成订单','FlowPage','','0','0','15','16','16','0','','Order_Order_Add_Finish.aspx')
 
INSERT INTO Web_Page VALUES ('214','支付方式管理','MenuPage','','4','0','1','2','0','0','','System_Payment_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('215','支付方式编辑','FlowPage','','0','0','1','2','0','0','','System_Payment_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('216','订单编辑/查看','FlowPage','','0','0','15','16','16','0','','Order_Order_View.aspx')
 
INSERT INTO Web_Page VALUES ('217','订单编辑_商品选择','FlowPage','','0','0','15','16','16','0','','Order_Order_Edit_Product.aspx')
 
INSERT INTO Web_Page VALUES ('218','缓存清理','FlowPage','','0','0','16','0','0','0','','System_Cache_Clear.aspx')
 
INSERT INTO Web_Page VALUES ('219','底部栏目管理','MenuPage','','7','0','1','2','0','0','','System_Info_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('220','信息添加','FlowPage','','0','0','1','2','0','0','','System_Info_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('221','订单总金额变更对话框','DailogPage','','0','0','15','16','16','0','','Order_Order_View_Dailog.aspx')
 
INSERT INTO Web_Page VALUES ('222','广告效果预览','DailogPage','','0','0','5','2','6','0','','Advertisement_Ads_Operate_DialogView.aspx')
 
INSERT INTO Web_Page VALUES ('223','订单价格修改记录','MenuPage','','2','0','15','16','0','0','','Order_Order_ViewLog.aspx')
 
INSERT INTO Web_Page VALUES ('224','订单打印','FlowPage','','0','0','15','16','16','0','','Order_Order_Print.aspx')
 
INSERT INTO Web_Page VALUES ('225','后台快捷设置','FlowPage','','0','0','1','2','0','0','','Tool_AdminDesktop_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('226','订单导出','FlowPage','','0','0','15','16','16','0','','Order_Order_Export.aspx')
 
INSERT INTO Web_Page VALUES ('227','添加/编辑外部文章','FlowPage','','0','0','11','2','12','0','','Article_Article_OperateLink.aspx')
 
INSERT INTO Web_Page VALUES ('228','添加库存对话框','DailogPage','','0','0','12','13','0','0','','Product_StockLog_Operate_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('229','合并订单','MenuPage','','3','0','15','16','0','0','','Order_Order_Merge.aspx')
 
INSERT INTO Web_Page VALUES ('230','报表统计','MenuPage','','14','0','17','0','0','0','','')
 
INSERT INTO Web_Page VALUES ('231','会员统计','MenuPage','','1','0','17','18','0','0','','Report_MemberCount_Count.aspx')
 
INSERT INTO Web_Page VALUES ('232','销售统计','MenuPage','','2','0','17','18','0','0','','Report_Sale_Count.aspx')
 
INSERT INTO Web_Page VALUES ('233','团购订单查询','FlowPage','','0','0','14','15','15','0','','Promotions_GroupBuy_Detail.aspx')
 
INSERT INTO Web_Page VALUES ('234','图片尺寸管理','MenuPage','','9','0','9','10','0','0','','Template_PictureSize_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('235','在线交流工具','MenuPage','','5','0','7','8','0','0','','Other_OnlineTool_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('236','添加在线交流工具','FlowPage','','0','0','7','8','0','0','','Other_OnlineTool_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('237','查看优惠卷','FlowPage','','0','0','14','15','15','0','查看优惠卷','Promotions_Coupon_View.aspx')
 
INSERT INTO Web_Page VALUES ('238','会员统计概况','FlowPage','','0','0','17','18','0','0','','Report_Member_Count.aspx')
 
INSERT INTO Web_Page VALUES ('239','商品编号编辑','FlowPage','','0','0','12','13','0','0','','Product_ProductNumber_Manage_Dialog.aspx')
 
INSERT INTO Web_Page VALUES ('240','查看购物卡使用记录','FlowPage','','0','0','13','14','0','0','查看购物卡使用记录','User_ShopCardLog_View.aspx')
 
INSERT INTO Web_Page VALUES ('241','查看会员卡使用记录','FlowPage','','0','0','13','14','0','0','查看会员卡使用记录','User_UserCardLog_View.aspx')
 
INSERT INTO Web_Page VALUES ('242','订单编辑_支付方式','DailogPage','','0','0','15','16','16','0','订单编辑_支付方式','Order_Order_Edit_Payment.aspx')
 
INSERT INTO Web_Page VALUES ('243','订单编辑_购物车','FlowPage','','0','0','15','16','16','0','订单编辑_购物车','Order_Order_Edit_Cart.aspx')
 
INSERT INTO Web_Page VALUES ('244','站点发布','MenuPage','','0','0','18','0','0','0','','')
 
INSERT INTO Web_Page VALUES ('245','缓存文件清理','MenuPage','','0','0','18','19','0','0','','Html_Html_ClearCache.aspx')
 
INSERT INTO Web_Page VALUES ('246','站点模式设置','MenuPage','','0','0','18','19','0','0','','Html_Html_ModeSet.aspx')
 
INSERT INTO Web_Page VALUES ('247','页面发布','FlowPage','','0','0','18','19','0','0','','Html_Html_Public.aspx')
 
INSERT INTO Web_Page VALUES ('248','一键发布','FlowPage','','0','0','18','19','0','0','','Html_Html_OneKeyPublic.aspx')
 
INSERT INTO Web_Page VALUES ('249','发布数据统计','FlowPage','','0','0','18','19','0','0','','Html_Html_GetPubCount.aspx')
 
INSERT INTO Web_Page VALUES ('250','数据库管理','MenuPage','','0','0','19','0','0','0','','')
 
INSERT INTO Web_Page VALUES ('251','数据库备份','MenuPage','','0','0','19','20','0','0','','Data_DataBase_Backup.aspx')
 
INSERT INTO Web_Page VALUES ('252','数据库恢复','MenuPage','','0','0','19','20','0','0','','Data_DataBase_Restore.aspx')
 
INSERT INTO Web_Page VALUES ('253','商品添加配置','MenuPage','','0','0','12','13','0','0','','Product_Product_Operate_Config.aspx')
 
INSERT INTO Web_Page VALUES ('254','团购出价记录','FlowPage','','0','0','14','15','15','0','','Promotions_GroupBuy_ViewBuyLog.aspx')
 
INSERT INTO Web_Page VALUES ('255','商品配件类型','MenuPage','','2','0','12','13','0','0','','Product_FittingType_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('256','数据库修复','MenuPage','','0','0','19','20','0','0','','Data_DataBase_Repair.aspx')
 
INSERT INTO Web_Page VALUES ('257','文章附件','FlowPage','','0','0','11','12','0','0','','Document_Document_Manage_Category.aspx')
 
INSERT INTO Web_Page VALUES ('258','社区整合','MenuPage','','0','0','10','11','0','0','','System_Api_Operate.aspx')
 
INSERT INTO Web_Page VALUES ('260','CNZZ全景统计','MenuPage','','0','0','10','11','0','0','CNZZ全景统计','System_Wss_Api.aspx')
 
INSERT INTO Web_Page VALUES ('261','会员注册项管理','MenuPage','','0','0','13','14','0','0','会员注册项管理','User_RegFields_Manage.aspx')
 
INSERT INTO Web_Page VALUES ('262','会员注册项管理添加/编辑','FlowPage','','0','0','13','14','0','0','会员注册项管理添加/编辑','User_RegFields_Operate.aspx')
 
CREATE TABLE dbo.Tmp_Web_Page([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NOT NULL,[CategoryCode] [nvarchar] (50)  NOT NULL,[Ico] [nvarchar] (150)  NULL,[OrderID] [int]  NOT NULL,[IsDel] [int]  NOT NULL,[FirstID] [int]  NOT NULL,[SecondID] [int]  NOT NULL,[ThirdID] [int]  NOT NULL,[SubSystemID] [int]  NOT NULL,[Description] [nvarchar] (250)  NULL,[FilePath] [nvarchar] (250)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_Page ADD CONSTRAINT DF_Tmp_Web_Page_CategoryCode DEFAULT ('') FOR [CategoryCode]
 
ALTER TABLE dbo.Tmp_Web_Page ADD CONSTRAINT DF_Tmp_Web_Page_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Tmp_Web_Page ADD CONSTRAINT DF_Tmp_Web_Page_IsDel DEFAULT ((0)) FOR [IsDel]
 
ALTER TABLE dbo.Tmp_Web_Page ADD CONSTRAINT DF_Tmp_Web_Page_FirstID DEFAULT ((0)) FOR [FirstID]
 
ALTER TABLE dbo.Tmp_Web_Page ADD CONSTRAINT DF_Tmp_Web_Page_SecondID DEFAULT ((0)) FOR [SecondID]
 
ALTER TABLE dbo.Tmp_Web_Page ADD CONSTRAINT DF_Tmp_Web_Page_ThirdID DEFAULT ((0)) FOR [ThirdID]
 
ALTER TABLE dbo.Tmp_Web_Page ADD CONSTRAINT DF_Tmp_Web_Page_SubSystemID DEFAULT ((0)) FOR [SubSystemID]
 
SET IDENTITY_INSERT dbo.Tmp_Web_Page ON
 
IF EXISTS(SELECT * FROM dbo.Web_Page) EXEC('INSERT INTO dbo.Tmp_Web_Page ([ID],[Name],[CategoryCode],[Ico],[OrderID],[IsDel],[FirstID],[SecondID],[ThirdID],[SubSystemID],[Description],[FilePath]) SELECT [ID],[Name],[CategoryCode],[Ico],[OrderID],[IsDel],[FirstID],[SecondID],[ThirdID],[SubSystemID],[Description],[FilePath] FROM dbo.Web_Page WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Page OFF
 
DROP TABLE dbo.Web_Page
 
EXECUTE sp_rename N'dbo.Tmp_Web_Page', N'Web_Page', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_WholeSaleUserGroup]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_WholeSaleUserGroup] 
 
CREATE TABLE dbo.Web_WholeSaleUserGroup([WholeSaleID] [int]  NOT NULL,[UserGroupID] [int]  NOT NULL)  ON [PRIMARY] 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Cost]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Cost] 
 
CREATE TABLE dbo.Web_Cost([ID] [int]  NOT NULL,[ProductID] [int]  NOT NULL,[name] [nvarchar] (50)  NULL,[price] [decimal]  (18,3) NOT NULL)  ON [PRIMARY] 
 
CREATE TABLE dbo.Tmp_Web_Cost([ID] [int]  NOT NULL IDENTITY (1, 1),[ProductID] [int]  NOT NULL,[name] [nvarchar] (50)  NULL,[price] [decimal]  (18,3) NOT NULL)  ON [PRIMARY] 
 
SET IDENTITY_INSERT dbo.Tmp_Web_Cost ON
 
IF EXISTS(SELECT * FROM dbo.Web_Cost) EXEC('INSERT INTO dbo.Tmp_Web_Cost ([ID],[ProductID],[name],[price]) SELECT [ID],[ProductID],[name],[price] FROM dbo.Web_Cost WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Cost OFF
 
DROP TABLE dbo.Web_Cost
 
EXECUTE sp_rename N'dbo.Tmp_Web_Cost', N'Web_Cost', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_DeliveryAreaList]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_DeliveryAreaList] 
 
CREATE TABLE dbo.Web_DeliveryAreaList([DeliveryAreaID] [int]  NOT NULL,[AreaID] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_DeliveryAreaList ADD CONSTRAINT DF_Web_DeliveryAreaList_DeliveryAreaID DEFAULT ((0)) FOR [DeliveryAreaID]
 
ALTER TABLE dbo.Web_DeliveryAreaList ADD CONSTRAINT DF_Web_DeliveryAreaList_AreaID DEFAULT ((0)) FOR [AreaID]
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_WholeSale]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_WholeSale] 
 
CREATE TABLE dbo.Web_WholeSale([Id] [int]  NOT NULL,[Name] [nvarchar] (50)  NOT NULL,[Description] [nvarchar] (250)  NOT NULL,[IsSingle] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[IsAct] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_WholeSale ADD CONSTRAINT DF_Web_WholeSale_Description DEFAULT ('') FOR [Description]
 
ALTER TABLE dbo.Web_WholeSale ADD CONSTRAINT DF_Web_WholeSale_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Web_WholeSale ADD CONSTRAINT DF_Web_WholeSale_IsAct DEFAULT ((0)) FOR [IsAct]
 
CREATE TABLE dbo.Tmp_Web_WholeSale([Id] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NOT NULL,[Description] [nvarchar] (250)  NOT NULL,[IsSingle] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[IsAct] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_WholeSale ADD CONSTRAINT DF_Tmp_Web_WholeSale_Description DEFAULT ('') FOR [Description]
 
ALTER TABLE dbo.Tmp_Web_WholeSale ADD CONSTRAINT DF_Tmp_Web_WholeSale_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Tmp_Web_WholeSale ADD CONSTRAINT DF_Tmp_Web_WholeSale_IsAct DEFAULT ((0)) FOR [IsAct]
 
SET IDENTITY_INSERT dbo.Tmp_Web_WholeSale ON
 
IF EXISTS(SELECT * FROM dbo.Web_WholeSale) EXEC('INSERT INTO dbo.Tmp_Web_WholeSale ([Id],[Name],[Description],[IsSingle],[Date],[IsAct]) SELECT [Id],[Name],[Description],[IsSingle],[Date],[IsAct] FROM dbo.Web_WholeSale WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_WholeSale OFF
 
DROP TABLE dbo.Web_WholeSale
 
EXECUTE sp_rename N'dbo.Tmp_Web_WholeSale', N'Web_WholeSale', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_OnlineTool]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_OnlineTool] 
 
CREATE TABLE dbo.Web_OnlineTool([ID] [int]  NOT NULL,[Name] [nvarchar] (20)  NOT NULL,[ToolNumber] [nvarchar] (50)  NOT NULL,[ToolType] [nvarchar] (50)  NOT NULL,[IsAct] [int]  NOT NULL,[OrderID] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_OnlineTool ADD CONSTRAINT DF_Web_OnlineTool_IsAct DEFAULT ((1)) FOR [IsAct]
 
CREATE TABLE dbo.Tmp_Web_OnlineTool([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (20)  NOT NULL,[ToolNumber] [nvarchar] (50)  NOT NULL,[ToolType] [nvarchar] (50)  NOT NULL,[IsAct] [int]  NOT NULL,[OrderID] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_OnlineTool ADD CONSTRAINT DF_Tmp_Web_OnlineTool_IsAct DEFAULT ((1)) FOR [IsAct]
 
SET IDENTITY_INSERT dbo.Tmp_Web_OnlineTool ON
 
IF EXISTS(SELECT * FROM dbo.Web_OnlineTool) EXEC('INSERT INTO dbo.Tmp_Web_OnlineTool ([ID],[Name],[ToolNumber],[ToolType],[IsAct],[OrderID]) SELECT [ID],[Name],[ToolNumber],[ToolType],[IsAct],[OrderID] FROM dbo.Web_OnlineTool WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_OnlineTool OFF
 
DROP TABLE dbo.Web_OnlineTool
 
EXECUTE sp_rename N'dbo.Tmp_Web_OnlineTool', N'Web_OnlineTool', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_BindDetail]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_BindDetail] 
 
CREATE TABLE dbo.Web_BindDetail([ID] [int]  NOT NULL,[ProductID] [int]  NOT NULL,[Name] [nvarchar] (50)  NULL,[Count] [int]  NOT NULL,[BindID] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_BindDetail ADD CONSTRAINT DF_Web_BindDetail_ProductID DEFAULT ((0)) FOR [ProductID]
 
ALTER TABLE dbo.Web_BindDetail ADD CONSTRAINT DF_Web_BindDetail_Count DEFAULT ((0)) FOR [Count]
 
ALTER TABLE dbo.Web_BindDetail ADD CONSTRAINT DF_Web_BindDetail_BindID DEFAULT ((0)) FOR [BindID]
 
CREATE TABLE dbo.Tmp_Web_BindDetail([ID] [int]  NOT NULL IDENTITY (1, 1),[ProductID] [int]  NOT NULL,[Name] [nvarchar] (50)  NULL,[Count] [int]  NOT NULL,[BindID] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_BindDetail ADD CONSTRAINT DF_Tmp_Web_BindDetail_ProductID DEFAULT ((0)) FOR [ProductID]
 
ALTER TABLE dbo.Tmp_Web_BindDetail ADD CONSTRAINT DF_Tmp_Web_BindDetail_Count DEFAULT ((0)) FOR [Count]
 
ALTER TABLE dbo.Tmp_Web_BindDetail ADD CONSTRAINT DF_Tmp_Web_BindDetail_BindID DEFAULT ((0)) FOR [BindID]
 
SET IDENTITY_INSERT dbo.Tmp_Web_BindDetail ON
 
IF EXISTS(SELECT * FROM dbo.Web_BindDetail) EXEC('INSERT INTO dbo.Tmp_Web_BindDetail ([ID],[ProductID],[Name],[Count],[BindID]) SELECT [ID],[ProductID],[Name],[Count],[BindID] FROM dbo.Web_BindDetail WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_BindDetail OFF
 
DROP TABLE dbo.Web_BindDetail
 
EXECUTE sp_rename N'dbo.Tmp_Web_BindDetail', N'Web_BindDetail', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_DefaultTpl]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_DefaultTpl] 
 
CREATE TABLE dbo.Web_DefaultTpl([ID] [int]  NOT NULL,[TableName] [nvarchar] (50)  NULL,[TplPage] [nvarchar] (50)  NULL)  ON [PRIMARY] 
 
CREATE TABLE dbo.Tmp_Web_DefaultTpl([ID] [int]  NOT NULL IDENTITY (1, 1),[TableName] [nvarchar] (50)  NULL,[TplPage] [nvarchar] (50)  NULL)  ON [PRIMARY] 
 
SET IDENTITY_INSERT dbo.Tmp_Web_DefaultTpl ON
 
IF EXISTS(SELECT * FROM dbo.Web_DefaultTpl) EXEC('INSERT INTO dbo.Tmp_Web_DefaultTpl ([ID],[TableName],[TplPage]) SELECT [ID],[TableName],[TplPage] FROM dbo.Web_DefaultTpl WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_DefaultTpl OFF
 
DROP TABLE dbo.Web_DefaultTpl
 
EXECUTE sp_rename N'dbo.Tmp_Web_DefaultTpl', N'Web_DefaultTpl', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_EmailVariableField]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_EmailVariableField] 
 
CREATE TABLE dbo.Web_EmailVariableField([ID] [int]  NOT NULL,[EmailVariableTableID] [int]  NOT NULL,[Name] [nvarchar] (100)  NOT NULL,[Descripation] [nvarchar] (250)  NOT NULL,[OrderID] [int]  NOT NULL,[CanDel] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_EmailVariableField ADD CONSTRAINT DF_Web_EmailVariableField_Descripation DEFAULT ('') FOR [Descripation]
 
ALTER TABLE dbo.Web_EmailVariableField ADD CONSTRAINT DF_Web_EmailVariableField_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Web_EmailVariableField ADD CONSTRAINT DF_Web_EmailVariableField_CanDel DEFAULT ((0)) FOR [CanDel]
 
INSERT INTO Web_EmailVariableField VALUES ('1','1','Name','用户名','1','0')
 
INSERT INTO Web_EmailVariableField VALUES ('2','1','Password','密码','2','0')
 
INSERT INTO Web_EmailVariableField VALUES ('3','1','RegDate','注册时间','3','0')
 
INSERT INTO Web_EmailVariableField VALUES ('4','1','Score','积分','4','0')
 
INSERT INTO Web_EmailVariableField VALUES ('5','1','ScoreUsed','已消耗积分','5','0')
 
INSERT INTO Web_EmailVariableField VALUES ('6','1','Email','电子邮件','6','0')
 
INSERT INTO Web_EmailVariableField VALUES ('7','1','Sex','性别','7','0')
 
INSERT INTO Web_EmailVariableField VALUES ('8','1','LoginDate','上次登陆时间','8','0')
 
INSERT INTO Web_EmailVariableField VALUES ('9','11','LoginTimes','登陆次数','9','0')
 
INSERT INTO Web_EmailVariableField VALUES ('10','1','IdentityCard','身份证号码','10','0')
 
INSERT INTO Web_EmailVariableField VALUES ('11','1','PostCode','邮政编码','11','0')
 
INSERT INTO Web_EmailVariableField VALUES ('12','1','AreaID','地区','12','0')
 
INSERT INTO Web_EmailVariableField VALUES ('13','1','Address','用户地址','13','0')
 
INSERT INTO Web_EmailVariableField VALUES ('14','1','IsLock','是否锁定','14','0')
 
INSERT INTO Web_EmailVariableField VALUES ('15','1','GroupID','用户组','15','0')
 
INSERT INTO Web_EmailVariableField VALUES ('16','1','Question','提示问题','16','0')
 
INSERT INTO Web_EmailVariableField VALUES ('17','1','Answer','提示答案','17','0')
 
INSERT INTO Web_EmailVariableField VALUES ('18','1','LoginIP','最后登陆IP','18','0')
 
INSERT INTO Web_EmailVariableField VALUES ('19','1','FrozenDeposit','冻结预存款','19','0')
 
INSERT INTO Web_EmailVariableField VALUES ('20','1','FrozenScore','冻结积分','20','0')
 
INSERT INTO Web_EmailVariableField VALUES ('21','1','BirthDay','生日','21','0')
 
INSERT INTO Web_EmailVariableField VALUES ('22','1','QQ','Qq号码','22','0')
 
INSERT INTO Web_EmailVariableField VALUES ('23','1','Telephone','固定电话','23','0')
 
INSERT INTO Web_EmailVariableField VALUES ('24','1','Phone','手机号码','24','0')
 
INSERT INTO Web_EmailVariableField VALUES ('25','1','TrueName','真实姓名','25','0')
 
INSERT INTO Web_EmailVariableField VALUES ('26','1','Credit','信用额度','26','0')
 
INSERT INTO Web_EmailVariableField VALUES ('27','1','CommendUser','推荐人','27','0')
 
INSERT INTO Web_EmailVariableField VALUES ('28','2','Name','商品长名称','28','0')
 
INSERT INTO Web_EmailVariableField VALUES ('29','2','ShortName','商品简称','29','0')
 
INSERT INTO Web_EmailVariableField VALUES ('30','2','MarketPrice','市场价格','30','0')
 
INSERT INTO Web_EmailVariableField VALUES ('31','2','MemberPrice','会员价格','31','0')
 
INSERT INTO Web_EmailVariableField VALUES ('32','2','CostPrice','成本价格','32','0')
 
INSERT INTO Web_EmailVariableField VALUES ('33','2','ShortContent','简单描述','33','0')
 
INSERT INTO Web_EmailVariableField VALUES ('34','2','Content','商品详细描述','34','0')
 
INSERT INTO Web_EmailVariableField VALUES ('35','2','OrderID','排序号','35','0')
 
INSERT INTO Web_EmailVariableField VALUES ('36','2','Weight','重量（千克）','36','0')
 
INSERT INTO Web_EmailVariableField VALUES ('37','2','IsOnSale','是否上架','37','0')
 
INSERT INTO Web_EmailVariableField VALUES ('38','2','Number','商品编号','38','0')
 
INSERT INTO Web_EmailVariableField VALUES ('39','2','Unit','单位','39','0')
 
INSERT INTO Web_EmailVariableField VALUES ('40','2','BrandID','品牌','40','0')
 
INSERT INTO Web_EmailVariableField VALUES ('41','2','BrandName','品牌名称','41','0')
 
INSERT INTO Web_EmailVariableField VALUES ('42','2','SrcDetail','商品详细图片','42','0')
 
INSERT INTO Web_EmailVariableField VALUES ('43','2','SrcList','商品列表图片','43','0')
 
INSERT INTO Web_EmailVariableField VALUES ('44','2','SeoTitle','TITLE标题','44','0')
 
INSERT INTO Web_EmailVariableField VALUES ('45','2','SeoKeywords','META关键词','45','0')
 
INSERT INTO Web_EmailVariableField VALUES ('46','2','SeoDescription','META描述','46','0')
 
INSERT INTO Web_EmailVariableField VALUES ('47','2','ReviewCount','商品评论次数','47','0')
 
INSERT INTO Web_EmailVariableField VALUES ('48','2','HitCount','商品点击次数','48','0')
 
INSERT INTO Web_EmailVariableField VALUES ('49','2','CollectCount','商品收藏次数','49','0')
 
INSERT INTO Web_EmailVariableField VALUES ('50','2','BuyCount','商品购买次数','50','0')
 
INSERT INTO Web_EmailVariableField VALUES ('51','2','StarCount','商品评价星级','51','0')
 
INSERT INTO Web_EmailVariableField VALUES ('52','2','ModifyDate','商品更新时间','52','0')
 
INSERT INTO Web_EmailVariableField VALUES ('53','2','SearchKey','商品搜索关键词','53','0')
 
INSERT INTO Web_EmailVariableField VALUES ('54','2','GUID','不重复唯一ID','54','0')
 
INSERT INTO Web_EmailVariableField VALUES ('55','2','IsDel','是否放入回收站','55','0')
 
INSERT INTO Web_EmailVariableField VALUES ('56','2','IsVirtual','是否为实体商品','56','0')
 
INSERT INTO Web_EmailVariableField VALUES ('57','2','IsPresent','是否为赠品或配件','57','0')
 
INSERT INTO Web_EmailVariableField VALUES ('58','2','IsChangedBuy','是否可换购','58','0')
 
INSERT INTO Web_EmailVariableField VALUES ('59','2','PresentPrice','换购价格','59','0')
 
INSERT INTO Web_EmailVariableField VALUES ('60','2','IsChanged','是否可以积分兑换','60','0')
 
INSERT INTO Web_EmailVariableField VALUES ('61','2','ChangeScore','兑换积分','61','0')
 
INSERT INTO Web_EmailVariableField VALUES ('62','2','Score','赠送积分','62','0')
 
INSERT INTO Web_EmailVariableField VALUES ('63','2','CategoryID','商品类别ID','63','0')
 
INSERT INTO Web_EmailVariableField VALUES ('64','2','CategoryFamily','商品类别家谱','64','0')
 
INSERT INTO Web_EmailVariableField VALUES ('65','2','CategoryName','商品类别名称','65','0')
 
INSERT INTO Web_EmailVariableField VALUES ('66','2','CategoryExtend','扩展商品类别','66','0')
 
INSERT INTO Web_EmailVariableField VALUES ('67','2','NeedPrice','换购商品满足金额','67','0')
 
INSERT INTO Web_EmailVariableField VALUES ('68','2','IsNew','是否为最新商品','68','0')
 
INSERT INTO Web_EmailVariableField VALUES ('69','2','IsRecommond','是否为推荐商品','69','0')
 
INSERT INTO Web_EmailVariableField VALUES ('70','2','IsSpecialOffer','是否为特价商品','70','0')
 
INSERT INTO Web_EmailVariableField VALUES ('71','2','IsHot','是否为热卖商品','71','0')
 
INSERT INTO Web_EmailVariableField VALUES ('72','2','Storage','库存','72','0')
 
INSERT INTO Web_EmailVariableField VALUES ('73','2','BuyNum','起购数量','73','0')
 
INSERT INTO Web_EmailVariableField VALUES ('74','2','VideoUrl','视频文件地址','74','0')
 
INSERT INTO Web_EmailVariableField VALUES ('75','2','VideoName','视频文件名称','75','0')
 
INSERT INTO Web_EmailVariableField VALUES ('76','2','VideoWidth','视频档宽','76','0')
 
INSERT INTO Web_EmailVariableField VALUES ('77','2','VideoHeight','视频檔高','77','0')
 
INSERT INTO Web_EmailVariableField VALUES ('78','2','Date','添加日期','78','0')
 
INSERT INTO Web_EmailVariableField VALUES ('79','2','GoodReview','好评数','79','0')
 
INSERT INTO Web_EmailVariableField VALUES ('80','2','BadReview','差评数','80','0')
 
INSERT INTO Web_EmailVariableField VALUES ('81','2','GoodPercent','好评率','81','0')
 
INSERT INTO Web_EmailVariableField VALUES ('82','2','ID','自动编号','82','0')
 
INSERT INTO Web_EmailVariableField VALUES ('83','3','Number','订单编号','83','0')
 
INSERT INTO Web_EmailVariableField VALUES ('84','3','UserName','下单用户名','84','0')
 
INSERT INTO Web_EmailVariableField VALUES ('85','3','SendName','购买人姓名','85','0')
 
INSERT INTO Web_EmailVariableField VALUES ('86','3','SendTel','购买人联系方式','86','0')
 
INSERT INTO Web_EmailVariableField VALUES ('87','3','SendMobile','购买人手机','87','0')
 
INSERT INTO Web_EmailVariableField VALUES ('88','3','SendEmail','购买人Email','88','0')
 
INSERT INTO Web_EmailVariableField VALUES ('89','3','ReceiveName','收货人姓名','89','0')
 
INSERT INTO Web_EmailVariableField VALUES ('90','3','ReceiveTel','收货人电话','90','0')
 
INSERT INTO Web_EmailVariableField VALUES ('91','3','ReceiveMobile','收货人手机','91','0')
 
INSERT INTO Web_EmailVariableField VALUES ('92','3','ReceivePostCode','收货人邮政编码','92','0')
 
INSERT INTO Web_EmailVariableField VALUES ('93','3','ReceiveAddress','收货人地址','93','0')
 
INSERT INTO Web_EmailVariableField VALUES ('94','3','ReceiveDate','收货时间','94','0')
 
INSERT INTO Web_EmailVariableField VALUES ('95','3','ReceiveSex','收货人性别','95','0')
 
INSERT INTO Web_EmailVariableField VALUES ('96','3','Payment','支付方式','96','0')
 
INSERT INTO Web_EmailVariableField VALUES ('97','3','PaymentPrice','支付费用','97','0')
 
INSERT INTO Web_EmailVariableField VALUES ('98','3','Delivery','送货方式','98','0')
 
INSERT INTO Web_EmailVariableField VALUES ('99','3','Remark','订单备注','99','0')
 
INSERT INTO Web_EmailVariableField VALUES ('100','3','IsInvoice','是否需要发票','100','0')
 
INSERT INTO Web_EmailVariableField VALUES ('101','3','InvoiceHead','发票抬头','101','0')
 
INSERT INTO Web_EmailVariableField VALUES ('102','3','InvoicePrice','发票金额','102','0')
 
INSERT INTO Web_EmailVariableField VALUES ('103','3','InvoiceType','发票类型','103','0')
 
INSERT INTO Web_EmailVariableField VALUES ('104','3','IsCancel','订单取消','104','0')
 
INSERT INTO Web_EmailVariableField VALUES ('105','3','Fee','配送费用','105','0')
 
INSERT INTO Web_EmailVariableField VALUES ('106','3','SafePrice','支付费用','106','0')
 
INSERT INTO Web_EmailVariableField VALUES ('107','3','Price','订单总金额','107','0')
 
INSERT INTO Web_EmailVariableField VALUES ('108','3','PriceModify','金额变动','108','0')
 
INSERT INTO Web_EmailVariableField VALUES ('109','3','AdminRemark','管理员备注','109','0')
 
INSERT INTO Web_EmailVariableField VALUES ('110','3','Date','下单时间','110','0')
 
INSERT INTO Web_EmailVariableField VALUES ('111','3','Building','标志建筑','111','0')
 
INSERT INTO Web_EmailVariableField VALUES ('112','3','StatusID','订单状态','112','0')
 
INSERT INTO Web_EmailVariableField VALUES ('113','3','IsUserCancel','用户自行取消','113','0')
 
INSERT INTO Web_EmailVariableField VALUES ('114','3','ProductPackageID','包装ID','114','0')
 
INSERT INTO Web_EmailVariableField VALUES ('115','3','ProductPackagePrice','商品包装费用','115','0')
 
INSERT INTO Web_EmailVariableField VALUES ('116','3','GreetingCardID','贺卡ID','116','0')
 
INSERT INTO Web_EmailVariableField VALUES ('117','3','GreetingCardPrice','贺卡费用','117','0')
 
INSERT INTO Web_EmailVariableField VALUES ('118','3','GreetingCardInfomation','贺卡祝福语','118','0')
 
INSERT INTO Web_EmailVariableField VALUES ('119','3','IsCOD','是否货到付款','119','0')
 
INSERT INTO Web_EmailVariableField VALUES ('120','3','UsedScore','抵用消耗积分','120','0')
 
INSERT INTO Web_EmailVariableField VALUES ('121','3','ScoreTradePrice','积分优惠金额','121','0')
 
INSERT INTO Web_EmailVariableField VALUES ('122','3','CouponTradePrice','优惠卷优惠金额','122','0')
 
INSERT INTO Web_EmailVariableField VALUES ('123','3','OriginalPrice','订单原始总金额','123','0')
 
INSERT INTO Web_EmailVariableField VALUES ('124','3','OldProductPrice','商品原总金额','124','0')
 
INSERT INTO Web_EmailVariableField VALUES ('125','3','CouponNumber','使用优惠卷号','125','0')
 
INSERT INTO Web_EmailVariableField VALUES ('126','3','NewProductPrice','商品总金额','126','0')
 
INSERT INTO Web_EmailVariableField VALUES ('127','4','UserName','会员ID','127','0')
 
INSERT INTO Web_EmailVariableField VALUES ('128','4','TrueName','真实姓名','128','0')
 
INSERT INTO Web_EmailVariableField VALUES ('129','4','OrderNumber','订单号码','129','0')
 
INSERT INTO Web_EmailVariableField VALUES ('130','4','ExpressCompany','快递公司','130','0')
 
INSERT INTO Web_EmailVariableField VALUES ('131','4','ExpressNumber','快递编号','131','0')
 
INSERT INTO Web_EmailVariableField VALUES ('132','4','SendDate','发货时间','132','0')
 
INSERT INTO Web_EmailVariableField VALUES ('133','4','Remark','简单备注','133','0')
 
INSERT INTO Web_EmailVariableField VALUES ('134','5','ProductID','商品ID','134','0')
 
INSERT INTO Web_EmailVariableField VALUES ('135','5','Count','需要数量','135','0')
 
INSERT INTO Web_EmailVariableField VALUES ('136','5','UserName','会员ID','136','0')
 
INSERT INTO Web_EmailVariableField VALUES ('137','5','Date','登记时间','137','0')
 
INSERT INTO Web_EmailVariableField VALUES ('138','5','TrueName','联系人姓名','138','0')
 
INSERT INTO Web_EmailVariableField VALUES ('139','5','DealName','处理人姓名','139','0')
 
INSERT INTO Web_EmailVariableField VALUES ('140','5','DealDate','处理时间','140','0')
 
INSERT INTO Web_EmailVariableField VALUES ('141','5','DealRemark','处理备注','141','0')
 
INSERT INTO Web_EmailVariableField VALUES ('142','5','LatestDate','最晚到货时间','142','0')
 
INSERT INTO Web_EmailVariableField VALUES ('143','5','ProductName','商品名称','143','0')
 
CREATE TABLE dbo.Tmp_Web_EmailVariableField([ID] [int]  NOT NULL IDENTITY (1, 1),[EmailVariableTableID] [int]  NOT NULL,[Name] [nvarchar] (100)  NOT NULL,[Descripation] [nvarchar] (250)  NOT NULL,[OrderID] [int]  NOT NULL,[CanDel] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_EmailVariableField ADD CONSTRAINT DF_Tmp_Web_EmailVariableField_Descripation DEFAULT ('') FOR [Descripation]
 
ALTER TABLE dbo.Tmp_Web_EmailVariableField ADD CONSTRAINT DF_Tmp_Web_EmailVariableField_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Tmp_Web_EmailVariableField ADD CONSTRAINT DF_Tmp_Web_EmailVariableField_CanDel DEFAULT ((0)) FOR [CanDel]
 
SET IDENTITY_INSERT dbo.Tmp_Web_EmailVariableField ON
 
IF EXISTS(SELECT * FROM dbo.Web_EmailVariableField) EXEC('INSERT INTO dbo.Tmp_Web_EmailVariableField ([ID],[EmailVariableTableID],[Name],[Descripation],[OrderID],[CanDel]) SELECT [ID],[EmailVariableTableID],[Name],[Descripation],[OrderID],[CanDel] FROM dbo.Web_EmailVariableField WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_EmailVariableField OFF
 
DROP TABLE dbo.Web_EmailVariableField
 
EXECUTE sp_rename N'dbo.Tmp_Web_EmailVariableField', N'Web_EmailVariableField', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_ProductImg]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_ProductImg] 
 
CREATE TABLE dbo.Web_ProductImg([ID] [int]  NOT NULL,[Src] [nvarchar] (255)  NULL,[ProductID] [int]  NOT NULL,[Title] [nvarchar] (50)  NULL,[OrderID] [int]  NOT NULL,[ProductDetailID] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_ProductImg ADD CONSTRAINT DF_Web_ProductImg_ProductID DEFAULT ((0)) FOR [ProductID]
 
ALTER TABLE dbo.Web_ProductImg ADD CONSTRAINT DF_Web_ProductImg_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Web_ProductImg ADD CONSTRAINT DF_Web_ProductImg_ProductDetailID DEFAULT ((0)) FOR [ProductDetailID]
 
CREATE TABLE dbo.Tmp_Web_ProductImg([ID] [int]  NOT NULL IDENTITY (1, 1),[Src] [nvarchar] (255)  NULL,[ProductID] [int]  NOT NULL,[Title] [nvarchar] (50)  NULL,[OrderID] [int]  NOT NULL,[ProductDetailID] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_ProductImg ADD CONSTRAINT DF_Tmp_Web_ProductImg_ProductID DEFAULT ((0)) FOR [ProductID]
 
ALTER TABLE dbo.Tmp_Web_ProductImg ADD CONSTRAINT DF_Tmp_Web_ProductImg_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Tmp_Web_ProductImg ADD CONSTRAINT DF_Tmp_Web_ProductImg_ProductDetailID DEFAULT ((0)) FOR [ProductDetailID]
 
SET IDENTITY_INSERT dbo.Tmp_Web_ProductImg ON
 
IF EXISTS(SELECT * FROM dbo.Web_ProductImg) EXEC('INSERT INTO dbo.Tmp_Web_ProductImg ([ID],[Src],[ProductID],[Title],[OrderID],[ProductDetailID]) SELECT [ID],[Src],[ProductID],[Title],[OrderID],[ProductDetailID] FROM dbo.Web_ProductImg WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_ProductImg OFF
 
DROP TABLE dbo.Web_ProductImg
 
EXECUTE sp_rename N'dbo.Tmp_Web_ProductImg', N'Web_ProductImg', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_DeliveryArea]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_DeliveryArea] 
 
CREATE TABLE dbo.Web_DeliveryArea([ID] [int]  NOT NULL,[Name] [nvarchar] (50)  NULL,[Description] [nvarchar] (250)  NULL,[DeliveryKey] [nvarchar] (50)  NOT NULL,[OrderID] [int]  NOT NULL,[QueryArray] [nvarchar] (250)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_DeliveryArea ADD CONSTRAINT DF_Web_DeliveryArea_OrderID DEFAULT ((1000)) FOR [OrderID]
 
CREATE TABLE dbo.Tmp_Web_DeliveryArea([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NULL,[Description] [nvarchar] (250)  NULL,[DeliveryKey] [nvarchar] (50)  NOT NULL,[OrderID] [int]  NOT NULL,[QueryArray] [nvarchar] (250)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_DeliveryArea ADD CONSTRAINT DF_Tmp_Web_DeliveryArea_OrderID DEFAULT ((1000)) FOR [OrderID]
 
SET IDENTITY_INSERT dbo.Tmp_Web_DeliveryArea ON
 
IF EXISTS(SELECT * FROM dbo.Web_DeliveryArea) EXEC('INSERT INTO dbo.Tmp_Web_DeliveryArea ([ID],[Name],[Description],[DeliveryKey],[OrderID],[QueryArray]) SELECT [ID],[Name],[Description],[DeliveryKey],[OrderID],[QueryArray] FROM dbo.Web_DeliveryArea WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_DeliveryArea OFF
 
DROP TABLE dbo.Web_DeliveryArea
 
EXECUTE sp_rename N'dbo.Tmp_Web_DeliveryArea', N'Web_DeliveryArea', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Unit]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Unit] 
 
CREATE TABLE dbo.Web_Unit([ID] [int]  NOT NULL,[Name] [nvarchar] (20)  NULL,[Code] [nvarchar] (20)  NULL)  ON [PRIMARY] 
 
INSERT INTO Web_Unit VALUES ('1','克','g')
 
INSERT INTO Web_Unit VALUES ('2','公斤','KG')
 
INSERT INTO Web_Unit VALUES ('3','部','bu')
 
INSERT INTO Web_Unit VALUES ('4','本','BEN')
 
INSERT INTO Web_Unit VALUES ('5','件','JIAN')
 
INSERT INTO Web_Unit VALUES ('6','盒','HE')
 
INSERT INTO Web_Unit VALUES ('7','套','TAO')
 
INSERT INTO Web_Unit VALUES ('8','箱','XIANG')
 
INSERT INTO Web_Unit VALUES ('9','台','TAI')
 
INSERT INTO Web_Unit VALUES ('10','瓶','PING')
 
CREATE TABLE dbo.Tmp_Web_Unit([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (20)  NULL,[Code] [nvarchar] (20)  NULL)  ON [PRIMARY] 
 
SET IDENTITY_INSERT dbo.Tmp_Web_Unit ON
 
IF EXISTS(SELECT * FROM dbo.Web_Unit) EXEC('INSERT INTO dbo.Tmp_Web_Unit ([ID],[Name],[Code]) SELECT [ID],[Name],[Code] FROM dbo.Web_Unit WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Unit OFF
 
DROP TABLE dbo.Web_Unit
 
EXECUTE sp_rename N'dbo.Tmp_Web_Unit', N'Web_Unit', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_MenuCategory]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_MenuCategory] 
 
CREATE TABLE dbo.Web_MenuCategory([Id] [int]  NOT NULL,[Code] [nvarchar] (50)  NOT NULL,[Name] [nvarchar] (20)  NOT NULL,[Remark] [nvarchar] (250)  NOT NULL,[IsDel] [int]  NOT NULL)  ON [PRIMARY] 
 
INSERT INTO Web_MenuCategory VALUES ('1','fsfs','发送方式','邮件发送方式(fsfs)','0')
 
INSERT INTO Web_MenuCategory VALUES ('2','ImgWidth','图片宽高','图片宽高(ImgWidth)','0')
 
INSERT INTO Web_MenuCategory VALUES ('3','TelRecordDealStatus','来电记录处理方式','来电记录处理方式(TelRecordDealStatus)','0')
 
INSERT INTO Web_MenuCategory VALUES ('4','SearchType','搜索类型','搜索类型(SearchType)','0')
 
INSERT INTO Web_MenuCategory VALUES ('5','SubscriptionStatus','订阅状态','订阅状态(SubscriptionStatus)','0')
 
INSERT INTO Web_MenuCategory VALUES ('6','ArticleProperty','文章属性','文章属性(ArticleProperty)','0')
 
INSERT INTO Web_MenuCategory VALUES ('7','PageCategory','页面类别','页面类别(PageCategory)','0')
 
INSERT INTO Web_MenuCategory VALUES ('8','lylx','留言类型','留言类型:(lylx)','0')
 
INSERT INTO Web_MenuCategory VALUES ('9','ReportType','统计类型','','0')
 
INSERT INTO Web_MenuCategory VALUES ('10','EmailCode','邮件编码','','0')
 
INSERT INTO Web_MenuCategory VALUES ('11','SendObject','发送对象','','0')
 
INSERT INTO Web_MenuCategory VALUES ('12','Refer','更新频率','','0')
 
INSERT INTO Web_MenuCategory VALUES ('13','ToolType','在线交流工具类型','','0')
 
INSERT INTO Web_MenuCategory VALUES ('14','Sex','用户性别','','0')
 
INSERT INTO Web_MenuCategory VALUES ('15','RegQuestion','会员注册问题',' ','0')
 
INSERT INTO Web_MenuCategory VALUES ('16','UserCardOverTime','会员卡延长时间','会员卡延长时间,以月份计算','0')
 
INSERT INTO Web_MenuCategory VALUES ('17','SiteMode','站点生成模式','','0')
 
CREATE TABLE dbo.Tmp_Web_MenuCategory([Id] [int]  NOT NULL IDENTITY (1, 1),[Code] [nvarchar] (50)  NOT NULL,[Name] [nvarchar] (20)  NOT NULL,[Remark] [nvarchar] (250)  NOT NULL,[IsDel] [int]  NOT NULL)  ON [PRIMARY] 
 
SET IDENTITY_INSERT dbo.Tmp_Web_MenuCategory ON
 
IF EXISTS(SELECT * FROM dbo.Web_MenuCategory) EXEC('INSERT INTO dbo.Tmp_Web_MenuCategory ([Id],[Code],[Name],[Remark],[IsDel]) SELECT [Id],[Code],[Name],[Remark],[IsDel] FROM dbo.Web_MenuCategory WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_MenuCategory OFF
 
DROP TABLE dbo.Web_MenuCategory
 
EXECUTE sp_rename N'dbo.Tmp_Web_MenuCategory', N'Web_MenuCategory', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_PagePower]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_PagePower] 
 
CREATE TABLE dbo.Web_PagePower([ID] [bigint]  NOT NULL,[RoleID] [int]  NOT NULL,[PageID] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_PagePower ADD CONSTRAINT DF_Web_PagePower_RoleID DEFAULT ((0)) FOR [RoleID]
 
ALTER TABLE dbo.Web_PagePower ADD CONSTRAINT DF_Web_PagePower_PageID DEFAULT ((0)) FOR [PageID]
 
INSERT INTO Web_PagePower VALUES ('3250','1','1')
 
INSERT INTO Web_PagePower VALUES ('3251','1','2')
 
INSERT INTO Web_PagePower VALUES ('3252','1','3')
 
INSERT INTO Web_PagePower VALUES ('3253','1','4')
 
INSERT INTO Web_PagePower VALUES ('3254','1','5')
 
INSERT INTO Web_PagePower VALUES ('3255','1','6')
 
INSERT INTO Web_PagePower VALUES ('3256','1','7')
 
INSERT INTO Web_PagePower VALUES ('3257','1','8')
 
INSERT INTO Web_PagePower VALUES ('3258','1','9')
 
INSERT INTO Web_PagePower VALUES ('3259','1','10')
 
INSERT INTO Web_PagePower VALUES ('3260','1','11')
 
INSERT INTO Web_PagePower VALUES ('3261','1','12')
 
INSERT INTO Web_PagePower VALUES ('3262','1','13')
 
INSERT INTO Web_PagePower VALUES ('3263','1','14')
 
INSERT INTO Web_PagePower VALUES ('3264','1','15')
 
INSERT INTO Web_PagePower VALUES ('3265','1','16')
 
INSERT INTO Web_PagePower VALUES ('3266','1','17')
 
INSERT INTO Web_PagePower VALUES ('3267','1','18')
 
INSERT INTO Web_PagePower VALUES ('3268','1','19')
 
INSERT INTO Web_PagePower VALUES ('3269','1','20')
 
INSERT INTO Web_PagePower VALUES ('3270','1','21')
 
INSERT INTO Web_PagePower VALUES ('3271','1','22')
 
INSERT INTO Web_PagePower VALUES ('3272','1','23')
 
INSERT INTO Web_PagePower VALUES ('3273','1','24')
 
INSERT INTO Web_PagePower VALUES ('3274','1','25')
 
INSERT INTO Web_PagePower VALUES ('3275','1','26')
 
INSERT INTO Web_PagePower VALUES ('3276','1','27')
 
INSERT INTO Web_PagePower VALUES ('3277','1','28')
 
INSERT INTO Web_PagePower VALUES ('3278','1','29')
 
INSERT INTO Web_PagePower VALUES ('3279','1','30')
 
INSERT INTO Web_PagePower VALUES ('3280','1','31')
 
INSERT INTO Web_PagePower VALUES ('3281','1','32')
 
INSERT INTO Web_PagePower VALUES ('3282','1','33')
 
INSERT INTO Web_PagePower VALUES ('3283','1','34')
 
INSERT INTO Web_PagePower VALUES ('3284','1','35')
 
INSERT INTO Web_PagePower VALUES ('3285','1','36')
 
INSERT INTO Web_PagePower VALUES ('3286','1','37')
 
INSERT INTO Web_PagePower VALUES ('3287','1','38')
 
INSERT INTO Web_PagePower VALUES ('3288','1','39')
 
INSERT INTO Web_PagePower VALUES ('3289','1','40')
 
INSERT INTO Web_PagePower VALUES ('3290','1','41')
 
INSERT INTO Web_PagePower VALUES ('3291','1','42')
 
INSERT INTO Web_PagePower VALUES ('3292','1','43')
 
INSERT INTO Web_PagePower VALUES ('3293','1','44')
 
INSERT INTO Web_PagePower VALUES ('3294','1','45')
 
INSERT INTO Web_PagePower VALUES ('3295','1','46')
 
INSERT INTO Web_PagePower VALUES ('3296','1','47')
 
INSERT INTO Web_PagePower VALUES ('3297','1','48')
 
INSERT INTO Web_PagePower VALUES ('3298','1','49')
 
INSERT INTO Web_PagePower VALUES ('3299','1','50')
 
INSERT INTO Web_PagePower VALUES ('3300','1','51')
 
INSERT INTO Web_PagePower VALUES ('3301','1','52')
 
INSERT INTO Web_PagePower VALUES ('3302','1','53')
 
INSERT INTO Web_PagePower VALUES ('3303','1','54')
 
INSERT INTO Web_PagePower VALUES ('3304','1','55')
 
INSERT INTO Web_PagePower VALUES ('3305','1','56')
 
INSERT INTO Web_PagePower VALUES ('3306','1','57')
 
INSERT INTO Web_PagePower VALUES ('3307','1','59')
 
INSERT INTO Web_PagePower VALUES ('3308','1','60')
 
INSERT INTO Web_PagePower VALUES ('3309','1','61')
 
INSERT INTO Web_PagePower VALUES ('3310','1','62')
 
INSERT INTO Web_PagePower VALUES ('3311','1','64')
 
INSERT INTO Web_PagePower VALUES ('3312','1','65')
 
INSERT INTO Web_PagePower VALUES ('3313','1','66')
 
INSERT INTO Web_PagePower VALUES ('3314','1','67')
 
INSERT INTO Web_PagePower VALUES ('3315','1','68')
 
INSERT INTO Web_PagePower VALUES ('3316','1','69')
 
INSERT INTO Web_PagePower VALUES ('3317','1','70')
 
INSERT INTO Web_PagePower VALUES ('3318','1','71')
 
INSERT INTO Web_PagePower VALUES ('3319','1','72')
 
INSERT INTO Web_PagePower VALUES ('3320','1','73')
 
INSERT INTO Web_PagePower VALUES ('3321','1','74')
 
INSERT INTO Web_PagePower VALUES ('3322','1','75')
 
INSERT INTO Web_PagePower VALUES ('3323','1','76')
 
INSERT INTO Web_PagePower VALUES ('3324','1','77')
 
INSERT INTO Web_PagePower VALUES ('3325','1','78')
 
INSERT INTO Web_PagePower VALUES ('3326','1','79')
 
INSERT INTO Web_PagePower VALUES ('3327','1','80')
 
INSERT INTO Web_PagePower VALUES ('3328','1','81')
 
INSERT INTO Web_PagePower VALUES ('3329','1','82')
 
INSERT INTO Web_PagePower VALUES ('3330','1','83')
 
INSERT INTO Web_PagePower VALUES ('3331','1','84')
 
INSERT INTO Web_PagePower VALUES ('3332','1','85')
 
INSERT INTO Web_PagePower VALUES ('3333','1','86')
 
INSERT INTO Web_PagePower VALUES ('3334','1','87')
 
INSERT INTO Web_PagePower VALUES ('3335','1','88')
 
INSERT INTO Web_PagePower VALUES ('3336','1','89')
 
INSERT INTO Web_PagePower VALUES ('3337','1','90')
 
INSERT INTO Web_PagePower VALUES ('3338','1','91')
 
INSERT INTO Web_PagePower VALUES ('3339','1','92')
 
INSERT INTO Web_PagePower VALUES ('3340','1','93')
 
INSERT INTO Web_PagePower VALUES ('3341','1','94')
 
INSERT INTO Web_PagePower VALUES ('3342','1','95')
 
INSERT INTO Web_PagePower VALUES ('3343','1','97')
 
INSERT INTO Web_PagePower VALUES ('3344','1','98')
 
INSERT INTO Web_PagePower VALUES ('3345','1','99')
 
INSERT INTO Web_PagePower VALUES ('3346','1','100')
 
INSERT INTO Web_PagePower VALUES ('3347','1','101')
 
INSERT INTO Web_PagePower VALUES ('3348','1','102')
 
INSERT INTO Web_PagePower VALUES ('3349','1','103')
 
INSERT INTO Web_PagePower VALUES ('3350','1','104')
 
INSERT INTO Web_PagePower VALUES ('3351','1','105')
 
INSERT INTO Web_PagePower VALUES ('3352','1','106')
 
INSERT INTO Web_PagePower VALUES ('3353','1','107')
 
INSERT INTO Web_PagePower VALUES ('3354','1','108')
 
INSERT INTO Web_PagePower VALUES ('3355','1','109')
 
INSERT INTO Web_PagePower VALUES ('3356','1','110')
 
INSERT INTO Web_PagePower VALUES ('3357','1','111')
 
INSERT INTO Web_PagePower VALUES ('3358','1','112')
 
INSERT INTO Web_PagePower VALUES ('3359','1','113')
 
INSERT INTO Web_PagePower VALUES ('3360','1','114')
 
INSERT INTO Web_PagePower VALUES ('3361','1','115')
 
INSERT INTO Web_PagePower VALUES ('3362','1','116')
 
INSERT INTO Web_PagePower VALUES ('3363','1','117')
 
INSERT INTO Web_PagePower VALUES ('3364','1','118')
 
INSERT INTO Web_PagePower VALUES ('3365','1','119')
 
INSERT INTO Web_PagePower VALUES ('3366','1','120')
 
INSERT INTO Web_PagePower VALUES ('3367','1','121')
 
INSERT INTO Web_PagePower VALUES ('3368','1','122')
 
INSERT INTO Web_PagePower VALUES ('3369','1','123')
 
INSERT INTO Web_PagePower VALUES ('3370','1','124')
 
INSERT INTO Web_PagePower VALUES ('3371','1','125')
 
INSERT INTO Web_PagePower VALUES ('3372','1','126')
 
INSERT INTO Web_PagePower VALUES ('3373','1','127')
 
INSERT INTO Web_PagePower VALUES ('3374','1','128')
 
INSERT INTO Web_PagePower VALUES ('3375','1','129')
 
INSERT INTO Web_PagePower VALUES ('3376','1','130')
 
INSERT INTO Web_PagePower VALUES ('3377','1','131')
 
INSERT INTO Web_PagePower VALUES ('3378','1','132')
 
INSERT INTO Web_PagePower VALUES ('3379','1','133')
 
INSERT INTO Web_PagePower VALUES ('3380','1','134')
 
INSERT INTO Web_PagePower VALUES ('3381','1','135')
 
INSERT INTO Web_PagePower VALUES ('3382','1','136')
 
INSERT INTO Web_PagePower VALUES ('3383','1','137')
 
INSERT INTO Web_PagePower VALUES ('3384','1','138')
 
INSERT INTO Web_PagePower VALUES ('3385','1','139')
 
INSERT INTO Web_PagePower VALUES ('3386','1','140')
 
INSERT INTO Web_PagePower VALUES ('3387','1','141')
 
INSERT INTO Web_PagePower VALUES ('3388','1','142')
 
INSERT INTO Web_PagePower VALUES ('3389','1','143')
 
INSERT INTO Web_PagePower VALUES ('3390','1','144')
 
INSERT INTO Web_PagePower VALUES ('3391','1','145')
 
INSERT INTO Web_PagePower VALUES ('3392','1','146')
 
INSERT INTO Web_PagePower VALUES ('3393','1','147')
 
INSERT INTO Web_PagePower VALUES ('3394','1','148')
 
INSERT INTO Web_PagePower VALUES ('3395','1','149')
 
INSERT INTO Web_PagePower VALUES ('3396','1','150')
 
INSERT INTO Web_PagePower VALUES ('3397','1','151')
 
INSERT INTO Web_PagePower VALUES ('3398','1','152')
 
INSERT INTO Web_PagePower VALUES ('3399','1','153')
 
INSERT INTO Web_PagePower VALUES ('3400','1','154')
 
INSERT INTO Web_PagePower VALUES ('3401','1','155')
 
INSERT INTO Web_PagePower VALUES ('3402','1','156')
 
INSERT INTO Web_PagePower VALUES ('3403','1','157')
 
INSERT INTO Web_PagePower VALUES ('3404','1','158')
 
INSERT INTO Web_PagePower VALUES ('3405','1','159')
 
INSERT INTO Web_PagePower VALUES ('3406','1','160')
 
INSERT INTO Web_PagePower VALUES ('3407','1','161')
 
INSERT INTO Web_PagePower VALUES ('3408','1','162')
 
INSERT INTO Web_PagePower VALUES ('3409','1','163')
 
INSERT INTO Web_PagePower VALUES ('3410','1','164')
 
INSERT INTO Web_PagePower VALUES ('3411','1','165')
 
INSERT INTO Web_PagePower VALUES ('3412','1','166')
 
INSERT INTO Web_PagePower VALUES ('3413','1','167')
 
INSERT INTO Web_PagePower VALUES ('3414','1','168')
 
INSERT INTO Web_PagePower VALUES ('3415','1','169')
 
INSERT INTO Web_PagePower VALUES ('3416','1','170')
 
INSERT INTO Web_PagePower VALUES ('3417','1','171')
 
INSERT INTO Web_PagePower VALUES ('3418','1','172')
 
INSERT INTO Web_PagePower VALUES ('3419','1','173')
 
INSERT INTO Web_PagePower VALUES ('3420','1','174')
 
INSERT INTO Web_PagePower VALUES ('3421','1','175')
 
INSERT INTO Web_PagePower VALUES ('3422','1','176')
 
INSERT INTO Web_PagePower VALUES ('3423','1','178')
 
INSERT INTO Web_PagePower VALUES ('3424','1','179')
 
INSERT INTO Web_PagePower VALUES ('3425','1','180')
 
INSERT INTO Web_PagePower VALUES ('3426','1','181')
 
INSERT INTO Web_PagePower VALUES ('3427','1','182')
 
INSERT INTO Web_PagePower VALUES ('3428','1','183')
 
INSERT INTO Web_PagePower VALUES ('3429','1','184')
 
INSERT INTO Web_PagePower VALUES ('3430','1','185')
 
INSERT INTO Web_PagePower VALUES ('3431','1','186')
 
INSERT INTO Web_PagePower VALUES ('3432','1','187')
 
INSERT INTO Web_PagePower VALUES ('3433','1','188')
 
INSERT INTO Web_PagePower VALUES ('3434','1','189')
 
INSERT INTO Web_PagePower VALUES ('3435','1','190')
 
INSERT INTO Web_PagePower VALUES ('3436','1','191')
 
INSERT INTO Web_PagePower VALUES ('3437','1','192')
 
INSERT INTO Web_PagePower VALUES ('3438','1','193')
 
INSERT INTO Web_PagePower VALUES ('3439','1','194')
 
INSERT INTO Web_PagePower VALUES ('3440','1','195')
 
INSERT INTO Web_PagePower VALUES ('3441','1','196')
 
INSERT INTO Web_PagePower VALUES ('3442','1','197')
 
INSERT INTO Web_PagePower VALUES ('3443','1','198')
 
INSERT INTO Web_PagePower VALUES ('3444','1','199')
 
INSERT INTO Web_PagePower VALUES ('3445','1','200')
 
INSERT INTO Web_PagePower VALUES ('3446','1','201')
 
INSERT INTO Web_PagePower VALUES ('3447','1','202')
 
INSERT INTO Web_PagePower VALUES ('3448','1','203')
 
INSERT INTO Web_PagePower VALUES ('3449','1','204')
 
INSERT INTO Web_PagePower VALUES ('3450','1','205')
 
INSERT INTO Web_PagePower VALUES ('3451','1','206')
 
INSERT INTO Web_PagePower VALUES ('3452','1','207')
 
INSERT INTO Web_PagePower VALUES ('3453','1','208')
 
INSERT INTO Web_PagePower VALUES ('3454','1','209')
 
INSERT INTO Web_PagePower VALUES ('3455','1','210')
 
INSERT INTO Web_PagePower VALUES ('3456','1','211')
 
INSERT INTO Web_PagePower VALUES ('3457','1','212')
 
INSERT INTO Web_PagePower VALUES ('3458','1','213')
 
INSERT INTO Web_PagePower VALUES ('3459','1','214')
 
INSERT INTO Web_PagePower VALUES ('3460','1','215')
 
INSERT INTO Web_PagePower VALUES ('3461','1','216')
 
INSERT INTO Web_PagePower VALUES ('3462','1','217')
 
INSERT INTO Web_PagePower VALUES ('3463','1','218')
 
INSERT INTO Web_PagePower VALUES ('3464','1','219')
 
INSERT INTO Web_PagePower VALUES ('3465','1','220')
 
INSERT INTO Web_PagePower VALUES ('3466','1','221')
 
INSERT INTO Web_PagePower VALUES ('3467','1','222')
 
INSERT INTO Web_PagePower VALUES ('3468','1','223')
 
INSERT INTO Web_PagePower VALUES ('3469','1','224')
 
INSERT INTO Web_PagePower VALUES ('3470','1','225')
 
INSERT INTO Web_PagePower VALUES ('3471','1','226')
 
INSERT INTO Web_PagePower VALUES ('3472','1','227')
 
INSERT INTO Web_PagePower VALUES ('3473','1','228')
 
INSERT INTO Web_PagePower VALUES ('3474','1','229')
 
INSERT INTO Web_PagePower VALUES ('3475','1','230')
 
INSERT INTO Web_PagePower VALUES ('3476','1','231')
 
INSERT INTO Web_PagePower VALUES ('3477','1','232')
 
INSERT INTO Web_PagePower VALUES ('3478','1','233')
 
INSERT INTO Web_PagePower VALUES ('3479','1','234')
 
INSERT INTO Web_PagePower VALUES ('3480','1','235')
 
INSERT INTO Web_PagePower VALUES ('3481','1','236')
 
INSERT INTO Web_PagePower VALUES ('3482','1','237')
 
INSERT INTO Web_PagePower VALUES ('3483','1','238')
 
INSERT INTO Web_PagePower VALUES ('3484','1','239')
 
INSERT INTO Web_PagePower VALUES ('3485','1','240')
 
INSERT INTO Web_PagePower VALUES ('3486','1','241')
 
INSERT INTO Web_PagePower VALUES ('3487','1','242')
 
INSERT INTO Web_PagePower VALUES ('3488','1','243')
 
INSERT INTO Web_PagePower VALUES ('3489','1','244')
 
INSERT INTO Web_PagePower VALUES ('3490','1','245')
 
INSERT INTO Web_PagePower VALUES ('3491','1','246')
 
INSERT INTO Web_PagePower VALUES ('3492','1','247')
 
INSERT INTO Web_PagePower VALUES ('3493','1','248')
 
INSERT INTO Web_PagePower VALUES ('3494','1','249')
 
INSERT INTO Web_PagePower VALUES ('3495','1','250')
 
INSERT INTO Web_PagePower VALUES ('3496','1','251')
 
INSERT INTO Web_PagePower VALUES ('3497','1','252')
 
INSERT INTO Web_PagePower VALUES ('3498','1','253')
 
INSERT INTO Web_PagePower VALUES ('3499','1','254')
 
INSERT INTO Web_PagePower VALUES ('3500','1','255')
 
INSERT INTO Web_PagePower VALUES ('3501','1','256')
 
INSERT INTO Web_PagePower VALUES ('3502','1','257')
 
INSERT INTO Web_PagePower VALUES ('3503','1','258')
 
INSERT INTO Web_PagePower VALUES ('3504','1','260')
 
INSERT INTO Web_PagePower VALUES ('3505','1','261')
 
INSERT INTO Web_PagePower VALUES ('3506','1','262')
 
CREATE TABLE dbo.Tmp_Web_PagePower([ID] [bigint]  NOT NULL IDENTITY (1, 1),[RoleID] [int]  NOT NULL,[PageID] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_PagePower ADD CONSTRAINT DF_Tmp_Web_PagePower_RoleID DEFAULT ((0)) FOR [RoleID]
 
ALTER TABLE dbo.Tmp_Web_PagePower ADD CONSTRAINT DF_Tmp_Web_PagePower_PageID DEFAULT ((0)) FOR [PageID]
 
SET IDENTITY_INSERT dbo.Tmp_Web_PagePower ON
 
IF EXISTS(SELECT * FROM dbo.Web_PagePower) EXEC('INSERT INTO dbo.Tmp_Web_PagePower ([ID],[RoleID],[PageID]) SELECT [ID],[RoleID],[PageID] FROM dbo.Web_PagePower WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_PagePower OFF
 
DROP TABLE dbo.Web_PagePower
 
EXECUTE sp_rename N'dbo.Tmp_Web_PagePower', N'Web_PagePower', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_ActivityGroup]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_ActivityGroup] 
 
CREATE TABLE dbo.Web_ActivityGroup([UserGroupID] [int]  NOT NULL,[ActivityID] [int]  NOT NULL)  ON [PRIMARY] 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_SnatchLog]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_SnatchLog] 
 
CREATE TABLE dbo.Web_SnatchLog([Id] [int]  NOT NULL,[SnatchID] [int]  NOT NULL,[UserName] [nvarchar] (50)  NOT NULL,[Count] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[Price] [decimal]  (18,2) NOT NULL,[Score] [int]  NOT NULL,[Email] [nvarchar] (100)  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_SnatchLog ADD CONSTRAINT DF_Web_SnatchLog_UserName DEFAULT ('') FOR [UserName]
 
ALTER TABLE dbo.Web_SnatchLog ADD CONSTRAINT DF_Web_SnatchLog_Count DEFAULT ((0)) FOR [Count]
 
ALTER TABLE dbo.Web_SnatchLog ADD CONSTRAINT DF_Web_SnatchLog_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Web_SnatchLog ADD CONSTRAINT DF_Web_SnatchLog_Price DEFAULT ((0)) FOR [Price]
 
ALTER TABLE dbo.Web_SnatchLog ADD CONSTRAINT DF_Web_SnatchLog_Score DEFAULT ((0)) FOR [Score]
 
ALTER TABLE dbo.Web_SnatchLog ADD CONSTRAINT DF_Web_SnatchLog_Email DEFAULT ('') FOR [Email]
 
CREATE TABLE dbo.Tmp_Web_SnatchLog([Id] [int]  NOT NULL IDENTITY (1, 1),[SnatchID] [int]  NOT NULL,[UserName] [nvarchar] (50)  NOT NULL,[Count] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[Price] [decimal]  (18,2) NOT NULL,[Score] [int]  NOT NULL,[Email] [nvarchar] (100)  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_SnatchLog ADD CONSTRAINT DF_Tmp_Web_SnatchLog_UserName DEFAULT ('') FOR [UserName]
 
ALTER TABLE dbo.Tmp_Web_SnatchLog ADD CONSTRAINT DF_Tmp_Web_SnatchLog_Count DEFAULT ((0)) FOR [Count]
 
ALTER TABLE dbo.Tmp_Web_SnatchLog ADD CONSTRAINT DF_Tmp_Web_SnatchLog_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Tmp_Web_SnatchLog ADD CONSTRAINT DF_Tmp_Web_SnatchLog_Price DEFAULT ((0)) FOR [Price]
 
ALTER TABLE dbo.Tmp_Web_SnatchLog ADD CONSTRAINT DF_Tmp_Web_SnatchLog_Score DEFAULT ((0)) FOR [Score]
 
ALTER TABLE dbo.Tmp_Web_SnatchLog ADD CONSTRAINT DF_Tmp_Web_SnatchLog_Email DEFAULT ('') FOR [Email]
 
SET IDENTITY_INSERT dbo.Tmp_Web_SnatchLog ON
 
IF EXISTS(SELECT * FROM dbo.Web_SnatchLog) EXEC('INSERT INTO dbo.Tmp_Web_SnatchLog ([Id],[SnatchID],[UserName],[Count],[Date],[Price],[Score],[Email]) SELECT [Id],[SnatchID],[UserName],[Count],[Date],[Price],[Score],[Email] FROM dbo.Web_SnatchLog WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_SnatchLog OFF
 
DROP TABLE dbo.Web_SnatchLog
 
EXECUTE sp_rename N'dbo.Tmp_Web_SnatchLog', N'Web_SnatchLog', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Payment]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Payment] 
 
CREATE TABLE dbo.Web_Payment([id] [int]  NOT NULL,[DllName] [nvarchar] (50)  NOT NULL,[Name] [nvarchar] (50)  NULL,[Description] [nvarchar] (1000)  NULL,[OrderID] [int]  NOT NULL,[Src] [nvarchar] (150)  NULL,[IsAct] [int]  NOT NULL,[Version] [nvarchar] (50)  NULL,[Author] [nvarchar] (50)  NULL,[QueryArray] [nvarchar] (255)  NULL,[DefaultDescription] [nvarchar] (1000)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Payment ADD CONSTRAINT DF_Web_Payment_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Web_Payment ADD CONSTRAINT DF_Web_Payment_IsAct DEFAULT ((0)) FOR [IsAct]
 
ALTER TABLE dbo.Web_Payment ADD CONSTRAINT DF_Web_Payment_Version DEFAULT ((0)) FOR [Version]
 
INSERT INTO Web_Payment VALUES ('1','Alipay_Instant','支付宝(即时到帐,年服务费)','支付宝即时到帐接口，是支付宝公司针对网上收款、付费、虚拟物品交易而建立的一个安全即时到帐交易平台、无需繁杂的过程即可轻松实现在线交易。','1000',NULL,'1','V1.35','V5Shop Team','sells@021web.com.cn,btfhyepobkdkemcxtk2m74tmt85vjnzh,2088002061866935,UploadFile/Picture/200812198501.gif','支付宝即时到帐接口，是支付宝公司针对网上收款、付费、虚拟物品交易而建立的一个安全即时到帐交易平台、无需繁杂的过程即可轻松实现在线交易。按年收取服务费：600元/年包48000元交易量、18000元/年包180000元交易量。<a href="https://www.alipay.com/cooperate/btools_shop.htm?type=from_agent_contract&id=C4335319145103694111" target="_blank"><font color="#ff0000"><strong>立即申请</strong></font></a>')
 
INSERT INTO Web_Payment VALUES ('2','Alipay_Instant_Year','支付宝(即时到帐,单笔2%交易费)','支付宝即时到帐接口，是支付宝公司针对网上收款、付费、虚拟物品交易而建立的一个安全即时到帐交易平台、无需繁杂的过程即可轻松实现在线交易。','1000',NULL,'1','V1.35','V5Shop Team','sells@021web.com.cn,btfhyepobkdkemcxtk2m74tmt85vjnzh,2088002061866935,UploadFile/Picture/200812198501.gif','支付宝即时到帐接口，是支付宝公司针对网上收款、付费、虚拟物品交易而建立的一个安全即时到帐交易平台、无需繁杂的过程即可轻松实现在线交易。单笔2%交易费。<a href="https://www.alipay.com/cooperate/btools_shop.htm?type=from_agent_contract&id=C4335329993464066118" target="_blank"><font color="#ff0000"><strong>立即申请</strong></font></a>')
 
INSERT INTO Web_Payment VALUES ('3','Alipay_Standard','支付宝(担保交易,年服务费)','支付宝，是支付宝公司针对网上交易而特别推出的安全付款服务，其运作的实质是以支付宝为信用中介，在买家确认收到商品前，由支付宝替买卖双方暂时保管货款的一种增值服务。','1000',NULL,'1','V1.35','V5Shop Team','sells@021web.com.cn,btfhyepobkdkemcxtk2m74tmt85vjnzh,2088002061866935,UploadFile/Picture/200812198501.gif','支付宝，是支付宝公司针对网上交易而特别推出的安全付款服务，其运作的实质是以支付宝为信用中介，在买家确认收到商品前，由支付宝替买卖双方暂时保管货款的一种增值服务。按年收取服务费：600元/年包48000元交易量、18000元/年包180000元交易量。<a href="https://www.alipay.com/cooperate/btools_shop.htm?type=from_agent_contract&id=C4335319145103694111" target="_blank"><font color="#ff0000"><strong>立即申请</strong></font></a>')
 
INSERT INTO Web_Payment VALUES ('4','Alipay_Standard_Year','支付宝(担保交易,单笔2%交易费)','支付宝，是支付宝公司针对网上交易而特别推出的安全付款服务，其运作的实质是以支付宝为信用中介，在买家确认收到商品前，由支付宝替买卖双方暂时保管货款的一种增值服务。','1000',NULL,'1','V1.35','V5Shop Team','sells@021web.com.cn,btfhyepobkdkemcxtk2m74tmt85vjnzh,2088002061866935,UploadFile/Picture/200812198501.gif','支付宝，是支付宝公司针对网上交易而特别推出的安全付款服务，其运作的实质是以支付宝为信用中介，在买家确认收到商品前，由支付宝替买卖双方暂时保管货款的一种增值服务。单笔2%交易费。<a href="https://www.alipay.com/cooperate/btools_shop.htm?type=from_agent_contract&id=C4335329993464066118" target="_blank"><font color="#ff0000"><strong>立即申请</strong></font></a>')
 
INSERT INTO Web_Payment VALUES ('5','Bank','线下银行汇款','线下银行汇款','1000',NULL,'1','V1.0','V5Shop Team',NULL,'线下银行汇款')
 
INSERT INTO Web_Payment VALUES ('6','Bill99','快钱在线支付','快钱在线支付','1000',NULL,'1','V2.0','V5Shop Team','1001531458201,9QEA634SCX75ETYC,UploadFile/Picture/200812195448.gif','上海快钱信息服务有限公司是国内第一家提供基于EMAIL和手机号码的网上收付款服务的互联网企业。快钱已同中国建设银行、中国银联、中国农业银行、中国银行、招商银行、交通银行、华夏银行、中国光大银行、中信银行、深圳发展银行、广东发展银行等结成战略合作并推出网上交易的收付款服务，服务覆盖国内外27亿张银行卡。（网址：http://www.99bill.com） <a href="http://agent.99bill.com/agent/jsp/agent/onlineprotocol/agentProtocol.do?act=check&agentno=shwb01" target=_blank><font color="#ff0000"><strong>立即申请</strong></font></a>')
 
INSERT INTO Web_Payment VALUES ('7','ChinaBank','网银在线支付','网银在线（北京）科技有限公司自成立以来，凭借强大的技术实力和良好的服务理念，以“电子支付专家”为发展定位，致力于为国内中小型企业提供完善的电子支付解决方案。','1000',NULL,'1','V4.0','V5Shop Team','20419553,v8t1u9f9b0s8d8izs7h7','网银在线（北京）科技有限公司是2003年6月在中关村注册的高新技术企业，注册资金1000万人民币。自成立以来，凭借强大的技术实力和良好的服务理念，以“电子支付专家”为发展定位，联合中国银行、中国工商银行、中国农业银行、中国建设银行、招商银行等国内各大银行，以及VISA、MasterCard、JCB等国际信用卡组织，致力于为国内中小型企业提供完善的电子支付解决方案。')
 
INSERT INTO Web_Payment VALUES ('8','ShopCard','购物卡支付','购物卡支付','1000',NULL,'1','V1.0','V5Shop Team',NULL,'购物卡支付')
 
INSERT INTO Web_Payment VALUES ('9','Tenpay','财付通在线支付','财付通网站 (www.tenpay.com) 作为功能强大的支付平台，是由中国最早、最大的互联网即时通信软件开发商腾讯公司创办，为最广大的QQ用户群提供安全、便捷、简单的在线支付服务。','1000',NULL,'1','V2.0','V5Shop Team',NULL,'财付通网站 (www.tenpay.com) 作为功能强大的支付平台，是由中国最早、最大的互联网即时通信软件开发商腾讯公司创办，为最广大的QQ用户群提供安全、便捷、简单的在线支付服务。<a href="http://union.tenpay.com/mch/?id=1202530401" target="_blank" style="font-weight:bold; color:#CC0000">立即注册</a>')
 
INSERT INTO Web_Payment VALUES ('10','UserCard','会员卡支付','会员卡支付','1000',NULL,'1','V1.0','V5Shop Team',NULL,'会员卡支付')
 
INSERT INTO Web_Payment VALUES ('11','Yeepay','易宝在线支付','YeePay易宝（北京通融通信息技术有限公司）是专业从事多元化电子支付业务一站式服务的领跑者。在立足于网上支付的同时，YeePay易宝不断创新，将互联网、手机、固定电话整合在一个平台上，继短信支付、手机充值之后，首家推出了YeePay易宝电话支付业务，真正实现了离线支付，为更多传统行业搭建了电子支付的高速公路。','1000',NULL,'1','V2.1','V5Shop Team','10000459383,wmC898B9o5p549dJ2K5ZzEah5N3813YNd5W948v5g6Y85a40o14I17839f71','YeePay易宝（北京通融通信息技术有限公司）是专业从事多元化电子支付业务一站式服务的领跑者。在立足于网上支付的同时，YeePay易宝不断创新，将互联网、手机、固定电话整合在一个平台上，继短信支付、手机充值之后，首家推出了YeePay易宝电话支付业务，真正实现了离线支付，为更多传统行业搭建了电子支付的高速公路。YeePay易宝融合世界先进的电子支付文化，聚合众多金融、电信、IT、互联网等领域内的巨擘，旨在通过创新的支付机制，推动中国电子商务新进程。YeePay易宝致力于成为世界一流的电子支付应用和服务提供商，专注于金融增值服务和移动增值服务两大领域，创新并推广多元化、低成本的、安全有效的支付服务。')
 
CREATE TABLE dbo.Tmp_Web_Payment([id] [int]  NOT NULL IDENTITY (1, 1),[DllName] [nvarchar] (50)  NOT NULL,[Name] [nvarchar] (50)  NULL,[Description] [nvarchar] (1000)  NULL,[OrderID] [int]  NOT NULL,[Src] [nvarchar] (150)  NULL,[IsAct] [int]  NOT NULL,[Version] [nvarchar] (50)  NULL,[Author] [nvarchar] (50)  NULL,[QueryArray] [nvarchar] (255)  NULL,[DefaultDescription] [nvarchar] (1000)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_Payment ADD CONSTRAINT DF_Tmp_Web_Payment_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Tmp_Web_Payment ADD CONSTRAINT DF_Tmp_Web_Payment_IsAct DEFAULT ((0)) FOR [IsAct]
 
ALTER TABLE dbo.Tmp_Web_Payment ADD CONSTRAINT DF_Tmp_Web_Payment_Version DEFAULT ((0)) FOR [Version]
 
SET IDENTITY_INSERT dbo.Tmp_Web_Payment ON
 
IF EXISTS(SELECT * FROM dbo.Web_Payment) EXEC('INSERT INTO dbo.Tmp_Web_Payment ([id],[DllName],[Name],[Description],[OrderID],[Src],[IsAct],[Version],[Author],[QueryArray],[DefaultDescription]) SELECT [id],[DllName],[Name],[Description],[OrderID],[Src],[IsAct],[Version],[Author],[QueryArray],[DefaultDescription] FROM dbo.Web_Payment WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Payment OFF
 
DROP TABLE dbo.Web_Payment
 
EXECUTE sp_rename N'dbo.Tmp_Web_Payment', N'Web_Payment', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Price]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Price] 
 
CREATE TABLE dbo.Web_Price([ProductID] [int]  NOT NULL,[GroupID] [int]  NOT NULL,[Price] [decimal]  (18,2) NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Price ADD CONSTRAINT DF_Web_Price_ProductID DEFAULT ((0)) FOR [ProductID]
 
ALTER TABLE dbo.Web_Price ADD CONSTRAINT DF_Web_Price_GroupID DEFAULT ((0)) FOR [GroupID]
 
ALTER TABLE dbo.Web_Price ADD CONSTRAINT DF_Web_Price_Price DEFAULT ((0)) FOR [Price]
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Area]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Area] 
 
CREATE TABLE dbo.Web_Area([ID] [int]  NOT NULL,[Name] [nvarchar] (50)  NULL,[OrderID] [int]  NULL,[HeadID] [int]  NULL,[Level] [int]  NULL,[Family] [nvarchar] (250)  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Area ADD CONSTRAINT DF_Web_Area_OrderID DEFAULT ((0)) FOR [OrderID]
 
ALTER TABLE dbo.Web_Area ADD CONSTRAINT DF_Web_Area_HeadID DEFAULT ((0)) FOR [HeadID]
 
ALTER TABLE dbo.Web_Area ADD CONSTRAINT DF_Web_Area_Level DEFAULT ((0)) FOR [Level]
 
ALTER TABLE dbo.Web_Area ADD CONSTRAINT DF_Web_Area_Family DEFAULT (N',') FOR [Family]
 
INSERT INTO Web_Area VALUES ('1','安徽省','1','392','2',',')
 
INSERT INTO Web_Area VALUES ('2','北京市','2','392','2',',')
 
INSERT INTO Web_Area VALUES ('3','山东省','3','392','2',',')
 
INSERT INTO Web_Area VALUES ('4','江苏省','4','392','2',',')
 
INSERT INTO Web_Area VALUES ('5','上海市','5','392','2',',')
 
INSERT INTO Web_Area VALUES ('6','广东省','6','392','2',',')
 
INSERT INTO Web_Area VALUES ('7','浙江省','7','392','2',',')
 
INSERT INTO Web_Area VALUES ('8','福建省','8','392','2',',')
 
INSERT INTO Web_Area VALUES ('9','重庆市','9','392','2',',')
 
INSERT INTO Web_Area VALUES ('10','甘肃省','10','392','2',',')
 
INSERT INTO Web_Area VALUES ('11','广西省','11','392','2',',')
 
INSERT INTO Web_Area VALUES ('12','贵州省','12','392','2',',')
 
INSERT INTO Web_Area VALUES ('13','海南省','13','392','2',',')
 
INSERT INTO Web_Area VALUES ('15','河南省','15','392','2',',')
 
INSERT INTO Web_Area VALUES ('16','黑龙江省','16','392','2',',')
 
INSERT INTO Web_Area VALUES ('17','湖北省','17','392','2',',')
 
INSERT INTO Web_Area VALUES ('18','湖南省','18','392','2',',')
 
INSERT INTO Web_Area VALUES ('19','江西省','19','392','2',',')
 
INSERT INTO Web_Area VALUES ('20','吉林省','20','392','2',',')
 
INSERT INTO Web_Area VALUES ('21','辽宁省','21','392','2',',')
 
INSERT INTO Web_Area VALUES ('22','内蒙古','22','392','2',',')
 
INSERT INTO Web_Area VALUES ('23','宁夏','23','392','2',',')
 
INSERT INTO Web_Area VALUES ('24','青海省','24','392','2',',')
 
INSERT INTO Web_Area VALUES ('25','山西省','25','392','2',',')
 
INSERT INTO Web_Area VALUES ('26','陕西省','26','392','2',',')
 
INSERT INTO Web_Area VALUES ('27','四川省','27','392','2',',')
 
INSERT INTO Web_Area VALUES ('28','天津市','28','392','2',',')
 
INSERT INTO Web_Area VALUES ('29','新疆','29','392','2',',')
 
INSERT INTO Web_Area VALUES ('30','西藏','30','392','2',',')
 
INSERT INTO Web_Area VALUES ('31','云南省','31','392','2',',')
 
INSERT INTO Web_Area VALUES ('32','香港','32','392','2',',')
 
INSERT INTO Web_Area VALUES ('33','澳门','33','392','2',',')
 
INSERT INTO Web_Area VALUES ('34','台湾','34','392','2',',')
 
INSERT INTO Web_Area VALUES ('35','国外与其它','35','392','2',',')
 
INSERT INTO Web_Area VALUES ('36','合肥市','36','1','3',',')
 
INSERT INTO Web_Area VALUES ('37','芜湖市','37','1','3',',')
 
INSERT INTO Web_Area VALUES ('39','安庆市','39','1','3',',')
 
INSERT INTO Web_Area VALUES ('40','巢湖市','40','1','3',',')
 
INSERT INTO Web_Area VALUES ('41','滁州市','41','1','3',',')
 
INSERT INTO Web_Area VALUES ('42','淮南市','42','1','3',',')
 
INSERT INTO Web_Area VALUES ('43','马鞍山市','43','1','3',',')
 
INSERT INTO Web_Area VALUES ('44','宿州市','44','1','3',',')
 
INSERT INTO Web_Area VALUES ('45','宣州市','45','1','3',',')
 
INSERT INTO Web_Area VALUES ('46','蚌埠市','46','1','3',',')
 
INSERT INTO Web_Area VALUES ('47','池州地区','47','1','3',',')
 
INSERT INTO Web_Area VALUES ('48','阜阳市','48','1','3',',')
 
INSERT INTO Web_Area VALUES ('49','淮北市','49','1','3',',')
 
INSERT INTO Web_Area VALUES ('50','黄山市','50','1','3',',')
 
INSERT INTO Web_Area VALUES ('51','六安市','51','1','3',',')
 
INSERT INTO Web_Area VALUES ('52','铜陵市','52','1','3',',')
 
INSERT INTO Web_Area VALUES ('53','亳州市','53','1','3',',')
 
INSERT INTO Web_Area VALUES ('54','济南市','54','3','3',',')
 
INSERT INTO Web_Area VALUES ('55','东营市','55','3','3',',')
 
INSERT INTO Web_Area VALUES ('56','滨州地区','56','3','3',',')
 
INSERT INTO Web_Area VALUES ('57','淄博市','57','3','3',',')
 
INSERT INTO Web_Area VALUES ('58','德州市','58','3','3',',')
 
INSERT INTO Web_Area VALUES ('59','济宁市','59','3','3',',')
 
INSERT INTO Web_Area VALUES ('60','聊城地区','60','3','3',',')
 
INSERT INTO Web_Area VALUES ('61','临沂市','61','3','3',',')
 
INSERT INTO Web_Area VALUES ('62','莱芜市','62','3','3',',')
 
INSERT INTO Web_Area VALUES ('63','青岛市','63','3','3',',')
 
INSERT INTO Web_Area VALUES ('64','日照市','64','3','3',',')
 
INSERT INTO Web_Area VALUES ('65','威海市','65','3','3',',')
 
INSERT INTO Web_Area VALUES ('66','泰安市','66','3','3',',')
 
INSERT INTO Web_Area VALUES ('67','潍坊市','67','3','3',',')
 
INSERT INTO Web_Area VALUES ('68','烟台市','68','3','3',',')
 
INSERT INTO Web_Area VALUES ('69','菏泽地区','69','3','3',',')
 
INSERT INTO Web_Area VALUES ('70','枣庄市','70','3','3',',')
 
INSERT INTO Web_Area VALUES ('71','南京市','71','4','3',',')
 
INSERT INTO Web_Area VALUES ('72','淮阴市','72','4','3',',')
 
INSERT INTO Web_Area VALUES ('73','常州市','73','4','3',',')
 
INSERT INTO Web_Area VALUES ('74','连云港市','74','4','3',',')
 
INSERT INTO Web_Area VALUES ('75','南通市','75','4','3',',')
 
INSERT INTO Web_Area VALUES ('76','徐州市','76','4','3',',')
 
INSERT INTO Web_Area VALUES ('77','苏州市','77','4','3',',')
 
INSERT INTO Web_Area VALUES ('78','无锡市','78','4','3',',')
 
INSERT INTO Web_Area VALUES ('79','盐城市','79','4','3',',')
 
INSERT INTO Web_Area VALUES ('80','扬州市','80','4','3',',')
 
INSERT INTO Web_Area VALUES ('81','镇江市','81','4','3',',')
 
INSERT INTO Web_Area VALUES ('82','泰州市','82','4','3',',')
 
INSERT INTO Web_Area VALUES ('83','宿迁市','83','4','3',',')
 
INSERT INTO Web_Area VALUES ('84','上海市','84','5','3',',')
 
INSERT INTO Web_Area VALUES ('85','广州市','85','6','3',',')
 
INSERT INTO Web_Area VALUES ('86','佛山市','86','6','3',',')
 
INSERT INTO Web_Area VALUES ('87','惠州市','87','6','3',',')
 
INSERT INTO Web_Area VALUES ('88','东莞市','88','6','3',',')
 
INSERT INTO Web_Area VALUES ('89','江门市','89','6','3',',')
 
INSERT INTO Web_Area VALUES ('90','揭阳市','90','6','3',',')
 
INSERT INTO Web_Area VALUES ('91','潮州市','91','6','3',',')
 
INSERT INTO Web_Area VALUES ('92','茂名市','92','6','3',',')
 
INSERT INTO Web_Area VALUES ('93','梅州市','93','6','3',',')
 
INSERT INTO Web_Area VALUES ('94','清远市','94','6','3',',')
 
INSERT INTO Web_Area VALUES ('95','汕头市','95','6','3',',')
 
INSERT INTO Web_Area VALUES ('96','汕尾市','96','6','3',',')
 
INSERT INTO Web_Area VALUES ('97','深圳市','97','6','3',',')
 
INSERT INTO Web_Area VALUES ('98','韶关市','98','6','3',',')
 
INSERT INTO Web_Area VALUES ('99','阳江市','99','6','3',',')
 
INSERT INTO Web_Area VALUES ('100','河源市','100','6','3',',')
 
INSERT INTO Web_Area VALUES ('101','云浮市','101','6','3',',')
 
INSERT INTO Web_Area VALUES ('102','中山市','102','6','3',',')
 
INSERT INTO Web_Area VALUES ('103','珠海市','103','6','3',',')
 
INSERT INTO Web_Area VALUES ('104','湛江市','104','6','3',',')
 
INSERT INTO Web_Area VALUES ('105','湛江市','105','6','3',',')
 
INSERT INTO Web_Area VALUES ('106','江门市','106','6','3',',')
 
INSERT INTO Web_Area VALUES ('107','杭州市','107','7','3',',')
 
INSERT INTO Web_Area VALUES ('108','嘉兴市','108','7','3',',')
 
INSERT INTO Web_Area VALUES ('109','金华市','109','7','3',',')
 
INSERT INTO Web_Area VALUES ('110','衢州市','110','7','3',',')
 
INSERT INTO Web_Area VALUES ('111','丽水地区','111','7','3',',')
 
INSERT INTO Web_Area VALUES ('112','宁波市','112','7','3',',')
 
INSERT INTO Web_Area VALUES ('113','绍兴市','113','7','3',',')
 
INSERT INTO Web_Area VALUES ('114','台州市','114','7','3',',')
 
INSERT INTO Web_Area VALUES ('115','温州市','115','7','3',',')
 
INSERT INTO Web_Area VALUES ('116','舟山市','116','7','3',',')
 
INSERT INTO Web_Area VALUES ('117','湖州市','117','7','3',',')
 
INSERT INTO Web_Area VALUES ('118','福州市','118','8','3',',')
 
INSERT INTO Web_Area VALUES ('119','龙岩地区','119','8','3',',')
 
INSERT INTO Web_Area VALUES ('120','南平市','120','8','3',',')
 
INSERT INTO Web_Area VALUES ('121','宁德地区','121','8','3',',')
 
INSERT INTO Web_Area VALUES ('122','莆田市','122','8','3',',')
 
INSERT INTO Web_Area VALUES ('123','泉州市','123','8','3',',')
 
INSERT INTO Web_Area VALUES ('124','三明市','124','8','3',',')
 
INSERT INTO Web_Area VALUES ('125','厦门市','125','8','3',',')
 
INSERT INTO Web_Area VALUES ('126','漳州市','126','8','3',',')
 
INSERT INTO Web_Area VALUES ('127','重庆市','127','9','3',',')
 
INSERT INTO Web_Area VALUES ('128','涪陵市','128','9','3',',')
 
INSERT INTO Web_Area VALUES ('129','黔江地区','129','9','3',',')
 
INSERT INTO Web_Area VALUES ('130','万县市','130','9','3',',')
 
INSERT INTO Web_Area VALUES ('131','兰州市','131','10','3',',')
 
INSERT INTO Web_Area VALUES ('132','甘南藏族自治州','132','10','3',',')
 
INSERT INTO Web_Area VALUES ('133','定西地区','133','10','3',',')
 
INSERT INTO Web_Area VALUES ('134','白银市','134','9','3',',')
 
INSERT INTO Web_Area VALUES ('135','嘉峪关市','135','10','3',',')
 
INSERT INTO Web_Area VALUES ('136','金昌市','136','10','3',',')
 
INSERT INTO Web_Area VALUES ('137','酒泉地区','137','10','3',',')
 
INSERT INTO Web_Area VALUES ('138','临夏回族自治州','138','10','3',',')
 
INSERT INTO Web_Area VALUES ('139','陇南地区','139','10','3',',')
 
INSERT INTO Web_Area VALUES ('140','平凉地区','140','10','3',',')
 
INSERT INTO Web_Area VALUES ('141','庆阳地区','141','10','3',',')
 
INSERT INTO Web_Area VALUES ('142','天水市','142','10','3',',')
 
INSERT INTO Web_Area VALUES ('143','武威地区','143','10','3',',')
 
INSERT INTO Web_Area VALUES ('144','张掖地区','144','10','3',',')
 
INSERT INTO Web_Area VALUES ('145','南宁市','145','11','3',',')
 
INSERT INTO Web_Area VALUES ('146','防城港市','146','11','3',',')
 
INSERT INTO Web_Area VALUES ('147','北海市','147','11','3',',')
 
INSERT INTO Web_Area VALUES ('148','百色地区','148','11','3',',')
 
INSERT INTO Web_Area VALUES ('149','桂林地区','149','11','3',',')
 
INSERT INTO Web_Area VALUES ('150','桂林市','150','11','3',',')
 
INSERT INTO Web_Area VALUES ('151','柳州地区','151','11','3',',')
 
INSERT INTO Web_Area VALUES ('152','柳州市','152','11','3',',')
 
INSERT INTO Web_Area VALUES ('153','南宁地区','153','11','3',',')
 
INSERT INTO Web_Area VALUES ('154','钦州市','154','11','3',',')
 
INSERT INTO Web_Area VALUES ('155','梧州地区','155','11','3',',')
 
INSERT INTO Web_Area VALUES ('156','梧州市','156','11','3',',')
 
INSERT INTO Web_Area VALUES ('157','河池地区','157','11','3',',')
 
INSERT INTO Web_Area VALUES ('158','玉林地区','158','11','3',',')
 
INSERT INTO Web_Area VALUES ('159','贵港市','159','11','3',',')
 
INSERT INTO Web_Area VALUES ('160','贵阳市','160','12','3',',')
 
INSERT INTO Web_Area VALUES ('161','毕节地区','161','12','3',',')
 
INSERT INTO Web_Area VALUES ('162','遵义地区','162','12','3',',')
 
INSERT INTO Web_Area VALUES ('163','安顺地区','163','12','3',',')
 
INSERT INTO Web_Area VALUES ('164','六盘水市','164','12','3',',')
 
INSERT INTO Web_Area VALUES ('165','黔东南苗族侗族自治州','165','12','3',',')
 
INSERT INTO Web_Area VALUES ('166','黔南布依族苗族自治州','166','12','3',',')
 
INSERT INTO Web_Area VALUES ('167','黔西南布依族苗族自治州','167','12','3',',')
 
INSERT INTO Web_Area VALUES ('168','铜仁地区','168','12','3',',')
 
INSERT INTO Web_Area VALUES ('169','三亚市','169','13','3',',')
 
INSERT INTO Web_Area VALUES ('170','海口市','170','13','3',',')
 
INSERT INTO Web_Area VALUES ('182','郑州市','182','15','3',',')
 
INSERT INTO Web_Area VALUES ('183','开封市','183','15','3',',')
 
INSERT INTO Web_Area VALUES ('184','驻马店地区','184','15','3',',')
 
INSERT INTO Web_Area VALUES ('185','安阳市','185','15','3',',')
 
INSERT INTO Web_Area VALUES ('186','焦作市','186','15','3',',')
 
INSERT INTO Web_Area VALUES ('187','洛阳市','187','15','3',',')
 
INSERT INTO Web_Area VALUES ('188','濮阳市','188','15','3',',')
 
INSERT INTO Web_Area VALUES ('189','漯河市','189','15','3',',')
 
INSERT INTO Web_Area VALUES ('190','南阳市','190','15','3',',')
 
INSERT INTO Web_Area VALUES ('191','平顶山市','191','15','3',',')
 
INSERT INTO Web_Area VALUES ('192','新乡市','192','15','3',',')
 
INSERT INTO Web_Area VALUES ('193','信阳地区','193','15','3',',')
 
INSERT INTO Web_Area VALUES ('194','许昌市','194','15','3',',')
 
INSERT INTO Web_Area VALUES ('195','商丘地区','195','15','3',',')
 
INSERT INTO Web_Area VALUES ('196','三门峡市','196','15','3',',')
 
INSERT INTO Web_Area VALUES ('197','鹤壁市','197','15','3',',')
 
INSERT INTO Web_Area VALUES ('198','周口地区','198','15','3',',')
 
INSERT INTO Web_Area VALUES ('199','哈尔滨市','199','16','3',',')
 
INSERT INTO Web_Area VALUES ('200','大庆市','200','16','3',',')
 
INSERT INTO Web_Area VALUES ('201','大兴安岭地区','201','16','3',',')
 
INSERT INTO Web_Area VALUES ('202','鸡西市','202','16','3',',')
 
INSERT INTO Web_Area VALUES ('203','佳木斯市','203','16','3',',')
 
INSERT INTO Web_Area VALUES ('204','牡丹江市','204','16','3',',')
 
INSERT INTO Web_Area VALUES ('205','齐齐哈尔市','205','16','3',',')
 
INSERT INTO Web_Area VALUES ('206','七台河市','206','16','3',',')
 
INSERT INTO Web_Area VALUES ('207','双鸭山市','207','16','3',',')
 
INSERT INTO Web_Area VALUES ('208','绥化地区','208','16','3',',')
 
INSERT INTO Web_Area VALUES ('209','松花江地区','209','16','3',',')
 
INSERT INTO Web_Area VALUES ('210','鹤岗市','210','16','3',',')
 
INSERT INTO Web_Area VALUES ('211','黑河市','211','16','3',',')
 
INSERT INTO Web_Area VALUES ('212','伊春市','212','16','3',',')
 
INSERT INTO Web_Area VALUES ('213','武汉市','213','17','3',',')
 
INSERT INTO Web_Area VALUES ('214','黄冈市','214','17','3',',')
 
INSERT INTO Web_Area VALUES ('215','黄石市','215','17','3',',')
 
INSERT INTO Web_Area VALUES ('216','恩施土家族苗族自治州','216','17','3',',')
 
INSERT INTO Web_Area VALUES ('217','鄂州市','217','17','3',',')
 
INSERT INTO Web_Area VALUES ('218','荆门市','218','17','3',',')
 
INSERT INTO Web_Area VALUES ('219','荆沙市','219','17','3',',')
 
INSERT INTO Web_Area VALUES ('220','孝感市','220','17','3',',')
 
INSERT INTO Web_Area VALUES ('221','十堰市','221','17','3',',')
 
INSERT INTO Web_Area VALUES ('222','襄樊市','222','17','3',',')
 
INSERT INTO Web_Area VALUES ('223','咸宁地区','223','17','3',',')
 
INSERT INTO Web_Area VALUES ('224','宜昌市','224','17','3',',')
 
INSERT INTO Web_Area VALUES ('225','长沙市','225','18','3',',')
 
INSERT INTO Web_Area VALUES ('226','怀化地区','226','18','3',',')
 
INSERT INTO Web_Area VALUES ('227','郴州市','227','18','3',',')
 
INSERT INTO Web_Area VALUES ('228','常德市','228','18','3',',')
 
INSERT INTO Web_Area VALUES ('229','娄底地区','229','18','3',',')
 
INSERT INTO Web_Area VALUES ('230','邵阳市','230','18','3',',')
 
INSERT INTO Web_Area VALUES ('231','湘潭市','231','18','3',',')
 
INSERT INTO Web_Area VALUES ('232','湘西土家族苗族自治州','232','18','3',',')
 
INSERT INTO Web_Area VALUES ('233','衡阳市','233','18','3',',')
 
INSERT INTO Web_Area VALUES ('234','永州市','234','18','3',',')
 
INSERT INTO Web_Area VALUES ('235','益阳市','235','18','3',',')
 
INSERT INTO Web_Area VALUES ('236','岳阳市','236','18','3',',')
 
INSERT INTO Web_Area VALUES ('237','株洲市','237','18','3',',')
 
INSERT INTO Web_Area VALUES ('238','张家界市','238','18','3',',')
 
INSERT INTO Web_Area VALUES ('239','南昌市','239','19','3',',')
 
INSERT INTO Web_Area VALUES ('240','抚州地区','240','19','3',',')
 
INSERT INTO Web_Area VALUES ('241','赣州地区','241','19','3',',')
 
INSERT INTO Web_Area VALUES ('242','吉安地区','242','19','3',',')
 
INSERT INTO Web_Area VALUES ('243','景德镇市','243','19','3',',')
 
INSERT INTO Web_Area VALUES ('244','九江市','244','19','3',',')
 
INSERT INTO Web_Area VALUES ('245','萍乡市','245','19','3',',')
 
INSERT INTO Web_Area VALUES ('246','新余市','246','19','3',',')
 
INSERT INTO Web_Area VALUES ('247','上饶地区','247','19','3',',')
 
INSERT INTO Web_Area VALUES ('248','鹰潭市','248','19','3',',')
 
INSERT INTO Web_Area VALUES ('249','宜春地区','249','19','3',',')
 
INSERT INTO Web_Area VALUES ('250','长春市','250','20','3',',')
 
INSERT INTO Web_Area VALUES ('251','白城市','251','20','3',',')
 
INSERT INTO Web_Area VALUES ('252','白山市','252','20','3',',')
 
INSERT INTO Web_Area VALUES ('253','吉林市','253','20','3',',')
 
INSERT INTO Web_Area VALUES ('254','辽源市','254','20','3',',')
 
INSERT INTO Web_Area VALUES ('255','四平市','255','20','3',',')
 
INSERT INTO Web_Area VALUES ('256','松原市','256','20','3',',')
 
INSERT INTO Web_Area VALUES ('257','通化市','257','20','3',',')
 
INSERT INTO Web_Area VALUES ('258','延边朝鲜族自治州','258','20','3',',')
 
INSERT INTO Web_Area VALUES ('259','沈阳市','259','21','3',',')
 
INSERT INTO Web_Area VALUES ('260','大连市','260','21','3',',')
 
INSERT INTO Web_Area VALUES ('261','阜新市','261','21','3',',')
 
INSERT INTO Web_Area VALUES ('262','抚顺市','262','21','3',',')
 
INSERT INTO Web_Area VALUES ('263','本溪市','263','21','3',',')
 
INSERT INTO Web_Area VALUES ('264','鞍山市','264','21','3',',')
 
INSERT INTO Web_Area VALUES ('265','丹东市','265','21','3',',')
 
INSERT INTO Web_Area VALUES ('266','锦州市','266','21','3',',')
 
INSERT INTO Web_Area VALUES ('267','朝阳市','267','21','3',',')
 
INSERT INTO Web_Area VALUES ('268','辽阳市','268','21','3',',')
 
INSERT INTO Web_Area VALUES ('269','盘锦市','269','21','3',',')
 
INSERT INTO Web_Area VALUES ('270','铁岭市','270','21','3',',')
 
INSERT INTO Web_Area VALUES ('271','营口市','271','21','3',',')
 
INSERT INTO Web_Area VALUES ('272','锦西市','272','21','3',',')
 
INSERT INTO Web_Area VALUES ('273','呼和浩特市','273','22','3',',')
 
INSERT INTO Web_Area VALUES ('274','阿拉善盟','274','22','3',',')
 
INSERT INTO Web_Area VALUES ('275','巴彦淖尔盟','275','22','3',',')
 
INSERT INTO Web_Area VALUES ('276','包头市','276','22','3',',')
 
INSERT INTO Web_Area VALUES ('277','赤峰市','277','22','3',',')
 
INSERT INTO Web_Area VALUES ('278','兴安盟','278','22','3',',')
 
INSERT INTO Web_Area VALUES ('279','乌兰察布盟','279','22','3',',')
 
INSERT INTO Web_Area VALUES ('280','乌海市','280','22','3',',')
 
INSERT INTO Web_Area VALUES ('281','锡林郭勒盟','281','22','3',',')
 
INSERT INTO Web_Area VALUES ('282','呼伦贝尔盟','282','22','3',',')
 
INSERT INTO Web_Area VALUES ('283','伊克昭盟','283','22','3',',')
 
INSERT INTO Web_Area VALUES ('284','哲里木盟','284','22','3',',')
 
INSERT INTO Web_Area VALUES ('285','银川市','285','23','3',',')
 
INSERT INTO Web_Area VALUES ('286','固原地区','286','23','3',',')
 
INSERT INTO Web_Area VALUES ('287','石嘴山市','287','23','3',',')
 
INSERT INTO Web_Area VALUES ('288','银南地区','288','23','3',',')
 
INSERT INTO Web_Area VALUES ('289','西宁市','289','24','3',',')
 
INSERT INTO Web_Area VALUES ('290','海东地区','290','24','3',',')
 
INSERT INTO Web_Area VALUES ('291','海南藏族自治州','291','24','3',',')
 
INSERT INTO Web_Area VALUES ('292','海北藏族自治州','292','24','3',',')
 
INSERT INTO Web_Area VALUES ('293','黄南藏族自治州','293','24','3',',')
 
INSERT INTO Web_Area VALUES ('294','果洛藏族自治州','294','24','3',',')
 
INSERT INTO Web_Area VALUES ('295','海西蒙古族藏族自治州','295','24','3',',')
 
INSERT INTO Web_Area VALUES ('296','太原市','296','25','3',',')
 
INSERT INTO Web_Area VALUES ('297','大同市','297','25','3',',')
 
INSERT INTO Web_Area VALUES ('298','晋城市','298','25','3',',')
 
INSERT INTO Web_Area VALUES ('299','晋中地区','299','25','3',',')
 
INSERT INTO Web_Area VALUES ('300','长治市','300','25','3',',')
 
INSERT INTO Web_Area VALUES ('301','临汾地区','301','25','3',',')
 
INSERT INTO Web_Area VALUES ('302','吕梁地区','302','25','3',',')
 
INSERT INTO Web_Area VALUES ('303','忻州地区','303','25','3',',')
 
INSERT INTO Web_Area VALUES ('304','朔州市','304','25','3',',')
 
INSERT INTO Web_Area VALUES ('305','阳泉市','305','25','3',',')
 
INSERT INTO Web_Area VALUES ('306','运城地区','306','25','3',',')
 
INSERT INTO Web_Area VALUES ('307','西安市','307','26','3',',')
 
INSERT INTO Web_Area VALUES ('308','宝鸡市','308','26','3',',')
 
INSERT INTO Web_Area VALUES ('309','安康地区','309','26','3',',')
 
INSERT INTO Web_Area VALUES ('310','商洛地区','310','26','3',',')
 
INSERT INTO Web_Area VALUES ('311','铜川市','311','26','3',',')
 
INSERT INTO Web_Area VALUES ('312','渭南地区','312','26','3',',')
 
INSERT INTO Web_Area VALUES ('313','渭南地区','313','26','3',',')
 
INSERT INTO Web_Area VALUES ('314','延安地区','314','26','3',',')
 
INSERT INTO Web_Area VALUES ('315','汉中地区','315','26','3',',')
 
INSERT INTO Web_Area VALUES ('316','榆林地区','316','26','3',',')
 
INSERT INTO Web_Area VALUES ('317','成都市','317','27','3',',')
 
INSERT INTO Web_Area VALUES ('318','达川地区','318','27','3',',')
 
INSERT INTO Web_Area VALUES ('319','甘孜藏族自治州','319','27','3',',')
 
INSERT INTO Web_Area VALUES ('320','自贡市','320','27','3',',')
 
INSERT INTO Web_Area VALUES ('321','阿坝藏族羌族自治州','321','27','3',',')
 
INSERT INTO Web_Area VALUES ('322','巴中地区','322','27','3',',')
 
INSERT INTO Web_Area VALUES ('323','德阳市','323','27','3',',')
 
INSERT INTO Web_Area VALUES ('324','广安地区','324','27','3',',')
 
INSERT INTO Web_Area VALUES ('325','广元市','325','27','3',',')
 
INSERT INTO Web_Area VALUES ('326','凉山彝族自治州','326','27','3',',')
 
INSERT INTO Web_Area VALUES ('327','乐山市','327','27','3',',')
 
INSERT INTO Web_Area VALUES ('328','攀枝花市','328','27','3',',')
 
INSERT INTO Web_Area VALUES ('329','南充市','329','27','3',',')
 
INSERT INTO Web_Area VALUES ('330','内江市','330','27','3',',')
 
INSERT INTO Web_Area VALUES ('331','泸州市','331','27','3',',')
 
INSERT INTO Web_Area VALUES ('332','绵阳市','332','27','3',',')
 
INSERT INTO Web_Area VALUES ('333','遂宁市','333','27','3',',')
 
INSERT INTO Web_Area VALUES ('334','雅安地区','334','27','3',',')
 
INSERT INTO Web_Area VALUES ('335','宜宾地区','335','27','3',',')
 
INSERT INTO Web_Area VALUES ('336','天津市','336','28','3',',')
 
INSERT INTO Web_Area VALUES ('337','乌鲁木齐市','337','29','3',',')
 
INSERT INTO Web_Area VALUES ('338','喀什地区','338','29','3',',')
 
INSERT INTO Web_Area VALUES ('339','克孜勒苏柯尔克孜自治州','339','29','3',',')
 
INSERT INTO Web_Area VALUES ('340','克拉玛依市','340','29','3',',')
 
INSERT INTO Web_Area VALUES ('341','阿克苏地区','341','29','3',',')
 
INSERT INTO Web_Area VALUES ('342','阿勒泰地区','342','29','3',',')
 
INSERT INTO Web_Area VALUES ('343','巴音郭楞蒙古自治州','343','29','3',',')
 
INSERT INTO Web_Area VALUES ('344','哈密地区','344','29','3',',')
 
INSERT INTO Web_Area VALUES ('345','博尔塔拉蒙古自治州','345','29','3',',')
 
INSERT INTO Web_Area VALUES ('346','昌吉回族自治州','346','29','3',',')
 
INSERT INTO Web_Area VALUES ('347','塔城地区','347','29','3',',')
 
INSERT INTO Web_Area VALUES ('348','吐鲁番地区','348','29','3',',')
 
INSERT INTO Web_Area VALUES ('349','和田地区','349','29','3',',')
 
INSERT INTO Web_Area VALUES ('350','伊犁地区','350','29','3',',')
 
INSERT INTO Web_Area VALUES ('351','伊犁哈萨克自治州','351','29','3',',')
 
INSERT INTO Web_Area VALUES ('352','石河子市','352','29','3',',')
 
INSERT INTO Web_Area VALUES ('353','拉萨市','353','30','3',',')
 
INSERT INTO Web_Area VALUES ('354','阿里地区','354','30','3',',')
 
INSERT INTO Web_Area VALUES ('355','昌都地区','355','30','3',',')
 
INSERT INTO Web_Area VALUES ('356','林芝地区','356','30','3',',')
 
INSERT INTO Web_Area VALUES ('357','那曲地区','357','30','3',',')
 
INSERT INTO Web_Area VALUES ('358','山南地区','358','30','3',',')
 
INSERT INTO Web_Area VALUES ('359','日喀则地区','359','30','3',',')
 
INSERT INTO Web_Area VALUES ('360','昆明市','360','31','3',',')
 
INSERT INTO Web_Area VALUES ('361','大理白族自治州','361','31','3',',')
 
INSERT INTO Web_Area VALUES ('362','东川市','362','31','3',',')
 
INSERT INTO Web_Area VALUES ('363','保山地区','363','31','3',',')
 
INSERT INTO Web_Area VALUES ('364','德宏傣族景颇族自治州','364','31','3',',')
 
INSERT INTO Web_Area VALUES ('365','迪庆藏族自治州','365','31','3',',')
 
INSERT INTO Web_Area VALUES ('366','楚雄彝族自治州','366','31','3',',')
 
INSERT INTO Web_Area VALUES ('367','临沧地区','367','31','3',',')
 
INSERT INTO Web_Area VALUES ('368','丽江地区','368','31','3',',')
 
INSERT INTO Web_Area VALUES ('369','怒江傈僳族自治州','369','31','3',',')
 
INSERT INTO Web_Area VALUES ('370','曲靖地区','370','31','3',',')
 
INSERT INTO Web_Area VALUES ('371','思茅地区','371','31','3',',')
 
INSERT INTO Web_Area VALUES ('372','西双版纳傣族自治州','372','31','3',',')
 
INSERT INTO Web_Area VALUES ('373','文山壮族苗族自治州','373','31','3',',')
 
INSERT INTO Web_Area VALUES ('374','红河哈尼族彝族自治州','374','31','3',',')
 
INSERT INTO Web_Area VALUES ('375','玉溪地区','375','31','3',',')
 
INSERT INTO Web_Area VALUES ('376','昭通地区','376','31','3',',')
 
INSERT INTO Web_Area VALUES ('377','香港','377','32','3',',')
 
INSERT INTO Web_Area VALUES ('378','澳门','378','33','3',',')
 
INSERT INTO Web_Area VALUES ('379','台湾','379','34','3',',')
 
INSERT INTO Web_Area VALUES ('380','国外与其它','380','35','3',',')
 
INSERT INTO Web_Area VALUES ('381','温岭市','381','7','3',',')
 
INSERT INTO Web_Area VALUES ('382','汉川','382','17','3',',')
 
INSERT INTO Web_Area VALUES ('390','长安区','390','307','4',',')
 
INSERT INTO Web_Area VALUES ('391','霸桥区','391','307','4',',')
 
INSERT INTO Web_Area VALUES ('392','中国','392','0','1',',')
 
CREATE TABLE dbo.Tmp_Web_Area([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NULL,[OrderID] [int]  NULL,[HeadID] [int]  NULL,[Level] [int]  NULL,[Family] [nvarchar] (250)  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_Area ADD CONSTRAINT DF_Tmp_Web_Area_OrderID DEFAULT ((0)) FOR [OrderID]
 
ALTER TABLE dbo.Tmp_Web_Area ADD CONSTRAINT DF_Tmp_Web_Area_HeadID DEFAULT ((0)) FOR [HeadID]
 
ALTER TABLE dbo.Tmp_Web_Area ADD CONSTRAINT DF_Tmp_Web_Area_Level DEFAULT ((0)) FOR [Level]
 
ALTER TABLE dbo.Tmp_Web_Area ADD CONSTRAINT DF_Tmp_Web_Area_Family DEFAULT (N',') FOR [Family]
 
SET IDENTITY_INSERT dbo.Tmp_Web_Area ON
 
IF EXISTS(SELECT * FROM dbo.Web_Area) EXEC('INSERT INTO dbo.Tmp_Web_Area ([ID],[Name],[OrderID],[HeadID],[Level],[Family]) SELECT [ID],[Name],[OrderID],[HeadID],[Level],[Family] FROM dbo.Web_Area WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Area OFF
 
DROP TABLE dbo.Web_Area
 
EXECUTE sp_rename N'dbo.Tmp_Web_Area', N'Web_Area', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_EmailConfig]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_EmailConfig] 
 
CREATE TABLE dbo.Web_EmailConfig([Id] [int]  NOT NULL,[RevertEmail] [nvarchar] (50)  NULL,[Smtp] [nvarchar] (50)  NULL,[Name] [nvarchar] (50)  NULL,[Serer] [nvarchar] (50)  NULL,[LoginID] [nvarchar] (50)  NULL,[LoginPass] [nvarchar] (50)  NULL,[Port] [int]  NOT NULL,[Code] [nvarchar] (50)  NULL,[SendType] [nvarchar] (50)  NULL,[IsUsed] [int]  NOT NULL,[IsDel] [int]  NOT NULL)  ON [PRIMARY] 
 
CREATE TABLE dbo.Tmp_Web_EmailConfig([Id] [int]  NOT NULL IDENTITY (1, 1),[RevertEmail] [nvarchar] (50)  NULL,[Smtp] [nvarchar] (50)  NULL,[Name] [nvarchar] (50)  NULL,[Serer] [nvarchar] (50)  NULL,[LoginID] [nvarchar] (50)  NULL,[LoginPass] [nvarchar] (50)  NULL,[Port] [int]  NOT NULL,[Code] [nvarchar] (50)  NULL,[SendType] [nvarchar] (50)  NULL,[IsUsed] [int]  NOT NULL,[IsDel] [int]  NOT NULL)  ON [PRIMARY] 
 
SET IDENTITY_INSERT dbo.Tmp_Web_EmailConfig ON
 
IF EXISTS(SELECT * FROM dbo.Web_EmailConfig) EXEC('INSERT INTO dbo.Tmp_Web_EmailConfig ([Id],[RevertEmail],[Smtp],[Name],[Serer],[LoginID],[LoginPass],[Port],[Code],[SendType],[IsUsed],[IsDel]) SELECT [Id],[RevertEmail],[Smtp],[Name],[Serer],[LoginID],[LoginPass],[Port],[Code],[SendType],[IsUsed],[IsDel] FROM dbo.Web_EmailConfig WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_EmailConfig OFF
 
DROP TABLE dbo.Web_EmailConfig
 
EXECUTE sp_rename N'dbo.Tmp_Web_EmailConfig', N'Web_EmailConfig', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Bind]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Bind] 
 
CREATE TABLE dbo.Web_Bind([ID] [int]  NOT NULL,[Name] [nvarchar] (50)  NOT NULL,[Price] [float]  NOT NULL,[Stock] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[Src] [nvarchar] (255)  NULL,[IsOnSale] [bit]  NOT NULL,[OrderID] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Bind ADD CONSTRAINT DF_Web_Bind_Price DEFAULT ((0)) FOR [Price]
 
ALTER TABLE dbo.Web_Bind ADD CONSTRAINT DF_Web_Bind_Stock DEFAULT ((0)) FOR [Stock]
 
ALTER TABLE dbo.Web_Bind ADD CONSTRAINT DF_Web_Bind_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Web_Bind ADD CONSTRAINT DF_Web_Bind_IsOnSale DEFAULT ((0)) FOR [IsOnSale]
 
ALTER TABLE dbo.Web_Bind ADD CONSTRAINT DF_Web_Bind_OrderID DEFAULT ((0)) FOR [OrderID]
 
CREATE TABLE dbo.Tmp_Web_Bind([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NOT NULL,[Price] [float]  NOT NULL,[Stock] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[Src] [nvarchar] (255)  NULL,[IsOnSale] [bit]  NOT NULL,[OrderID] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_Bind ADD CONSTRAINT DF_Tmp_Web_Bind_Price DEFAULT ((0)) FOR [Price]
 
ALTER TABLE dbo.Tmp_Web_Bind ADD CONSTRAINT DF_Tmp_Web_Bind_Stock DEFAULT ((0)) FOR [Stock]
 
ALTER TABLE dbo.Tmp_Web_Bind ADD CONSTRAINT DF_Tmp_Web_Bind_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Tmp_Web_Bind ADD CONSTRAINT DF_Tmp_Web_Bind_IsOnSale DEFAULT ((0)) FOR [IsOnSale]
 
ALTER TABLE dbo.Tmp_Web_Bind ADD CONSTRAINT DF_Tmp_Web_Bind_OrderID DEFAULT ((0)) FOR [OrderID]
 
SET IDENTITY_INSERT dbo.Tmp_Web_Bind ON
 
IF EXISTS(SELECT * FROM dbo.Web_Bind) EXEC('INSERT INTO dbo.Tmp_Web_Bind ([ID],[Name],[Price],[Stock],[Date],[Src],[IsOnSale],[OrderID]) SELECT [ID],[Name],[Price],[Stock],[Date],[Src],[IsOnSale],[OrderID] FROM dbo.Web_Bind WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Bind OFF
 
DROP TABLE dbo.Web_Bind
 
EXECUTE sp_rename N'dbo.Tmp_Web_Bind', N'Web_Bind', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Html]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Html] 
 
CREATE TABLE dbo.Web_Html([id] [int]  NOT NULL,[url] [nvarchar] (255)  NULL,[html] [nvarchar] (255)  NULL,[date] [datetime]  NOT NULL,[IsOver] [int]  NOT NULL,[Name] [nvarchar] (50)  NULL,[DataID] [nvarchar] (50)  NOT NULL,[PageID] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Html ADD CONSTRAINT DF_Web_Html_date DEFAULT (getdate()) FOR [date]
 
ALTER TABLE dbo.Web_Html ADD CONSTRAINT DF_Web_Html_IsOver DEFAULT ((0)) FOR [IsOver]
 
ALTER TABLE dbo.Web_Html ADD CONSTRAINT DF_Web_Html_DataID DEFAULT ((0)) FOR [DataID]
 
ALTER TABLE dbo.Web_Html ADD CONSTRAINT DF_Web_Html_PageID DEFAULT ((0)) FOR [PageID]
 
CREATE TABLE dbo.Tmp_Web_Html([id] [int]  NOT NULL IDENTITY (1, 1),[url] [nvarchar] (255)  NULL,[html] [nvarchar] (255)  NULL,[date] [datetime]  NOT NULL,[IsOver] [int]  NOT NULL,[Name] [nvarchar] (50)  NULL,[DataID] [nvarchar] (50)  NOT NULL,[PageID] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_Html ADD CONSTRAINT DF_Tmp_Web_Html_date DEFAULT (getdate()) FOR [date]
 
ALTER TABLE dbo.Tmp_Web_Html ADD CONSTRAINT DF_Tmp_Web_Html_IsOver DEFAULT ((0)) FOR [IsOver]
 
ALTER TABLE dbo.Tmp_Web_Html ADD CONSTRAINT DF_Tmp_Web_Html_DataID DEFAULT ((0)) FOR [DataID]
 
ALTER TABLE dbo.Tmp_Web_Html ADD CONSTRAINT DF_Tmp_Web_Html_PageID DEFAULT ((0)) FOR [PageID]
 
SET IDENTITY_INSERT dbo.Tmp_Web_Html ON
 
IF EXISTS(SELECT * FROM dbo.Web_Html) EXEC('INSERT INTO dbo.Tmp_Web_Html ([id],[url],[html],[date],[IsOver],[Name],[DataID],[PageID]) SELECT [id],[url],[html],[date],[IsOver],[Name],[DataID],[PageID] FROM dbo.Web_Html WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Html OFF
 
DROP TABLE dbo.Web_Html
 
EXECUTE sp_rename N'dbo.Tmp_Web_Html', N'Web_Html', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_EmailLog]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_EmailLog] 
 
CREATE TABLE dbo.Web_EmailLog([Id] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[SendObject] [nvarchar] (50)  NULL,[SendObjectEmail] [nvarchar] (50)  NULL,[SendType] [int]  NOT NULL,[SendStatus] [int]  NOT NULL,[UserName] [nvarchar] (50)  NULL,[SendCategory] [nvarchar] (20)  NULL,[EmailContent] [ntext]  NULL,[EmailTitle] [nvarchar] (100)  NULL)  ON [PRIMARY] 
 
CREATE TABLE dbo.Tmp_Web_EmailLog([Id] [int]  NOT NULL IDENTITY (1, 1),[Date] [datetime]  NOT NULL,[SendObject] [nvarchar] (50)  NULL,[SendObjectEmail] [nvarchar] (50)  NULL,[SendType] [int]  NOT NULL,[SendStatus] [int]  NOT NULL,[UserName] [nvarchar] (50)  NULL,[SendCategory] [nvarchar] (20)  NULL,[EmailContent] [ntext]  NULL,[EmailTitle] [nvarchar] (100)  NULL)  ON [PRIMARY] 
 
SET IDENTITY_INSERT dbo.Tmp_Web_EmailLog ON
 
IF EXISTS(SELECT * FROM dbo.Web_EmailLog) EXEC('INSERT INTO dbo.Tmp_Web_EmailLog ([Id],[Date],[SendObject],[SendObjectEmail],[SendType],[SendStatus],[UserName],[SendCategory],[EmailContent],[EmailTitle]) SELECT [Id],[Date],[SendObject],[SendObjectEmail],[SendType],[SendStatus],[UserName],[SendCategory],[EmailContent],[EmailTitle] FROM dbo.Web_EmailLog WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_EmailLog OFF
 
DROP TABLE dbo.Web_EmailLog
 
EXECUTE sp_rename N'dbo.Tmp_Web_EmailLog', N'Web_EmailLog', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_ActivityCoupon]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_ActivityCoupon] 
 
CREATE TABLE dbo.Web_ActivityCoupon([CouponID] [int]  NOT NULL,[ActivityID] [int]  NOT NULL)  ON [PRIMARY] 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_StockLog]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_StockLog] 
 
CREATE TABLE dbo.Web_StockLog([ID] [int]  NOT NULL,[UserName] [nvarchar] (50)  NULL,[Count] [int]  NOT NULL,[IsOut] [int]  NOT NULL,[date] [datetime]  NULL,[ProductID] [int]  NOT NULL,[Remark] [nvarchar] (250)  NULL,[ActorType] [nvarchar] (50)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_StockLog ADD CONSTRAINT DF_Web_StockLog_date DEFAULT (getdate()) FOR [date]
 
CREATE TABLE dbo.Tmp_Web_StockLog([ID] [int]  NOT NULL IDENTITY (1, 1),[UserName] [nvarchar] (50)  NULL,[Count] [int]  NOT NULL,[IsOut] [int]  NOT NULL,[date] [datetime]  NULL,[ProductID] [int]  NOT NULL,[Remark] [nvarchar] (250)  NULL,[ActorType] [nvarchar] (50)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_StockLog ADD CONSTRAINT DF_Tmp_Web_StockLog_date DEFAULT (getdate()) FOR [date]
 
SET IDENTITY_INSERT dbo.Tmp_Web_StockLog ON
 
IF EXISTS(SELECT * FROM dbo.Web_StockLog) EXEC('INSERT INTO dbo.Tmp_Web_StockLog ([ID],[UserName],[Count],[IsOut],[date],[ProductID],[Remark],[ActorType]) SELECT [ID],[UserName],[Count],[IsOut],[date],[ProductID],[Remark],[ActorType] FROM dbo.Web_StockLog WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_StockLog OFF
 
DROP TABLE dbo.Web_StockLog
 
EXECUTE sp_rename N'dbo.Tmp_Web_StockLog', N'Web_StockLog', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Menu]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Menu] 
 
CREATE TABLE dbo.Web_Menu([Id] [int]  NOT NULL,[Name] [nvarchar] (50)  NOT NULL,[Code] [nvarchar] (50)  NOT NULL,[OrderID] [int]  NOT NULL,[MenuCategoryCode] [nvarchar] (50)  NOT NULL,[IsDel] [int]  NOT NULL)  ON [PRIMARY] 
 
INSERT INTO Web_Menu VALUES ('1','Jmail方式','Jmail','1','fsfs','0')
 
INSERT INTO Web_Menu VALUES ('2','400*100','400,100','2','ImgWidth','0')
 
INSERT INTO Web_Menu VALUES ('3','300*300','300,300','3','ImgWidth','0')
 
INSERT INTO Web_Menu VALUES ('4','150*150','150,150','4','ImgWidth','0')
 
INSERT INTO Web_Menu VALUES ('5','未处理','0','5','TelRecordStatus','0')
 
INSERT INTO Web_Menu VALUES ('6','已处理','1','6','TelRecordStatus','0')
 
INSERT INTO Web_Menu VALUES ('7','无法处理','2','7','TelRecordStatus','0')
 
INSERT INTO Web_Menu VALUES ('8','商品','0','8','SearchType','0')
 
INSERT INTO Web_Menu VALUES ('9','文章','1','9','SearchType','0')
 
INSERT INTO Web_Menu VALUES ('10','未确认','0','10','SubscriptionStatus','0')
 
INSERT INTO Web_Menu VALUES ('11','已确认','1','11','SubscriptionStatus','0')
 
INSERT INTO Web_Menu VALUES ('12','已退订','2','12','SubscriptionStatus','0')
 
INSERT INTO Web_Menu VALUES ('14','推荐','tj','14','ArticleProperty','0')
 
INSERT INTO Web_Menu VALUES ('15','精华','jh','15','ArticleProperty','0')
 
INSERT INTO Web_Menu VALUES ('16','流程页','FlowPage','16','PageCategory','0')
 
INSERT INTO Web_Menu VALUES ('17','菜单页','MenuPage','17','PageCategory','0')
 
INSERT INTO Web_Menu VALUES ('18','对话框','DailogPage','18','PageCategory','0')
 
INSERT INTO Web_Menu VALUES ('19','弹出来电','tcld','19','TelRecordDealStatus','0')
 
INSERT INTO Web_Menu VALUES ('20','删除来电','scld','20','TelRecordDealStatus','0')
 
INSERT INTO Web_Menu VALUES ('21','询问','xw','21','lylx','1')
 
INSERT INTO Web_Menu VALUES ('22','留言','ly','22','lylx','0')
 
INSERT INTO Web_Menu VALUES ('23','售后','sh','23','lylx','1')
 
INSERT INTO Web_Menu VALUES ('24','3234','32324','24','ImgWidth','0')
 
INSERT INTO Web_Menu VALUES ('25','32423','32423','25','-1','0')
 
INSERT INTO Web_Menu VALUES ('26','234322','23423','26','-1','0')
 
INSERT INTO Web_Menu VALUES ('27','.net自带组件','NetMail','27','fsfs','0')
 
INSERT INTO Web_Menu VALUES ('28','商品统计','Product','28','ReportType','0')
 
INSERT INTO Web_Menu VALUES ('29','分类统计','Category','29','ReportType','0')
 
INSERT INTO Web_Menu VALUES ('30','会员统计','Member','30','ReportType','0')
 
INSERT INTO Web_Menu VALUES ('31','地区统计','Area','31','ReportType','0')
 
INSERT INTO Web_Menu VALUES ('32','国际化编码（utf8）','utf-8','32','EmailCode','0')
 
INSERT INTO Web_Menu VALUES ('33','简体中文','gb2312','33','EmailCode','0')
 
INSERT INTO Web_Menu VALUES ('34','繁体中文','big5','34','EmailCode','0')
 
INSERT INTO Web_Menu VALUES ('35','邮件组会员','1','35','SendObject','0')
 
INSERT INTO Web_Menu VALUES ('36','等级会员','2','36','SendObject','0')
 
INSERT INTO Web_Menu VALUES ('37','订阅会员','3','37','SendObject','0')
 
INSERT INTO Web_Menu VALUES ('38','所有会员','0','38','SendObject','0')
 
INSERT INTO Web_Menu VALUES ('39','一直更新','always','39','Refer','0')
 
INSERT INTO Web_Menu VALUES ('40','小时','hourly','40','Refer','0')
 
INSERT INTO Web_Menu VALUES ('41','日','daily','41','Refer','0')
 
INSERT INTO Web_Menu VALUES ('42','周','weekly','42','Refer','0')
 
INSERT INTO Web_Menu VALUES ('43','月','monthly','43','Refer','0')
 
INSERT INTO Web_Menu VALUES ('44','年','yearly','44','Refer','0')
 
INSERT INTO Web_Menu VALUES ('45','QQ','qq','45','ToolType','0')
 
INSERT INTO Web_Menu VALUES ('46','Msn','msn','46','ToolType','0')
 
INSERT INTO Web_Menu VALUES ('47','淘宝旺旺','ww','47','ToolType','0')
 
INSERT INTO Web_Menu VALUES ('48','SkyPe','skype','48','ToolType','0')
 
INSERT INTO Web_Menu VALUES ('49','贸易通','myt','49','ToolType','0')
 
INSERT INTO Web_Menu VALUES ('50','我的姓名？','我的姓名？','50','RegQuestion','0')
 
INSERT INTO Web_Menu VALUES ('51','我爱人的姓名？','我爱人的姓名？','51','RegQuestion','0')
 
INSERT INTO Web_Menu VALUES ('52','我的生日？','我的生日？','52','RegQuestion','0')
 
INSERT INTO Web_Menu VALUES ('53','头条','tt','53','ArticleProperty','0')
 
INSERT INTO Web_Menu VALUES ('54','热点','ld','54','ArticleProperty','0')
 
INSERT INTO Web_Menu VALUES ('55','男','1','55','Sex','0')
 
INSERT INTO Web_Menu VALUES ('56','女','0','56','Sex','0')
 
INSERT INTO Web_Menu VALUES ('57','投诉','ts','57','lylx','1')
 
INSERT INTO Web_Menu VALUES ('58','一个月','1','58','UserCardOverTime','0')
 
INSERT INTO Web_Menu VALUES ('59','三个月','3','59','UserCardOverTime','0')
 
INSERT INTO Web_Menu VALUES ('60','半年','6','60','UserCardOverTime','0')
 
INSERT INTO Web_Menu VALUES ('61','一年','12','61','UserCardOverTime','0')
 
INSERT INTO Web_Menu VALUES ('62','两年','24','62','UserCardOverTime','0')
 
INSERT INTO Web_Menu VALUES ('63','五年','60','63','UserCardOverTime','0')
 
INSERT INTO Web_Menu VALUES ('64','动态模式','Aspx','64','SiteMode','0')
 
INSERT INTO Web_Menu VALUES ('65','静态HTML模式','HTML','65','SiteMode','0')
 
INSERT INTO Web_Menu VALUES ('66','Url重写模式','Rewrite','66','SiteMode','0')
 
CREATE TABLE dbo.Tmp_Web_Menu([Id] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NOT NULL,[Code] [nvarchar] (50)  NOT NULL,[OrderID] [int]  NOT NULL,[MenuCategoryCode] [nvarchar] (50)  NOT NULL,[IsDel] [int]  NOT NULL)  ON [PRIMARY] 
 
SET IDENTITY_INSERT dbo.Tmp_Web_Menu ON
 
IF EXISTS(SELECT * FROM dbo.Web_Menu) EXEC('INSERT INTO dbo.Tmp_Web_Menu ([Id],[Name],[Code],[OrderID],[MenuCategoryCode],[IsDel]) SELECT [Id],[Name],[Code],[OrderID],[MenuCategoryCode],[IsDel] FROM dbo.Web_Menu WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Menu OFF
 
DROP TABLE dbo.Web_Menu
 
EXECUTE sp_rename N'dbo.Tmp_Web_Menu', N'Web_Menu', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_ProductView]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_ProductView] 
 
CREATE TABLE dbo.Web_ProductView([ID] [int]  NOT NULL,[ProductID] [int]  NOT NULL,[FromID] [int]  NOT NULL,[Username] [nvarchar] (50)  NULL,[Date] [datetime]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_ProductView ADD CONSTRAINT DF_Web_ProductView_ProductID DEFAULT ((0)) FOR [ProductID]
 
ALTER TABLE dbo.Web_ProductView ADD CONSTRAINT DF_Web_ProductView_FromID DEFAULT ((0)) FOR [FromID]
 
ALTER TABLE dbo.Web_ProductView ADD CONSTRAINT DF_Web_ProductView_Date DEFAULT (getdate()) FOR [Date]
 
CREATE TABLE dbo.Tmp_Web_ProductView([ID] [int]  NOT NULL IDENTITY (1, 1),[ProductID] [int]  NOT NULL,[FromID] [int]  NOT NULL,[Username] [nvarchar] (50)  NULL,[Date] [datetime]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_ProductView ADD CONSTRAINT DF_Tmp_Web_ProductView_ProductID DEFAULT ((0)) FOR [ProductID]
 
ALTER TABLE dbo.Tmp_Web_ProductView ADD CONSTRAINT DF_Tmp_Web_ProductView_FromID DEFAULT ((0)) FOR [FromID]
 
ALTER TABLE dbo.Tmp_Web_ProductView ADD CONSTRAINT DF_Tmp_Web_ProductView_Date DEFAULT (getdate()) FOR [Date]
 
SET IDENTITY_INSERT dbo.Tmp_Web_ProductView ON
 
IF EXISTS(SELECT * FROM dbo.Web_ProductView) EXEC('INSERT INTO dbo.Tmp_Web_ProductView ([ID],[ProductID],[FromID],[Username],[Date]) SELECT [ID],[ProductID],[FromID],[Username],[Date] FROM dbo.Web_ProductView WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_ProductView OFF
 
DROP TABLE dbo.Web_ProductView
 
EXECUTE sp_rename N'dbo.Tmp_Web_ProductView', N'Web_ProductView', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_IDMaster]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_IDMaster] 
 
CREATE TABLE dbo.Web_IDMaster([Code] [nvarchar] (50)  NOT NULL,[MaxID] [int]  NOT NULL,[Content] [nvarchar] (100)  NULL)  ON [PRIMARY] 
 
INSERT INTO Web_IDMaster VALUES ('PriceCard','0','充值卡发放批次')
 
INSERT INTO Web_IDMaster VALUES ('ShopCard','0','购物卡发放批次')
 
INSERT INTO Web_IDMaster VALUES ('UserCard','0','会员卡发放批次')
 
INSERT INTO Web_IDMaster VALUES ('Web_UserGroup','1','会员等级ID')
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_EmailCategory]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_EmailCategory] 
 
CREATE TABLE dbo.Web_EmailCategory([Id] [int]  NOT NULL,[Name] [nvarchar] (50)  NULL,[Description] [nvarchar] (250)  NULL)  ON [PRIMARY] 
 
INSERT INTO Web_EmailCategory VALUES ('1','系统邮件','存放系统中的邮件')
 
CREATE TABLE dbo.Tmp_Web_EmailCategory([Id] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NULL,[Description] [nvarchar] (250)  NULL)  ON [PRIMARY] 
 
SET IDENTITY_INSERT dbo.Tmp_Web_EmailCategory ON
 
IF EXISTS(SELECT * FROM dbo.Web_EmailCategory) EXEC('INSERT INTO dbo.Tmp_Web_EmailCategory ([Id],[Name],[Description]) SELECT [Id],[Name],[Description] FROM dbo.Web_EmailCategory WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_EmailCategory OFF
 
DROP TABLE dbo.Web_EmailCategory
 
EXECUTE sp_rename N'dbo.Tmp_Web_EmailCategory', N'Web_EmailCategory', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_BlackIPUser]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_BlackIPUser] 
 
CREATE TABLE dbo.Web_BlackIPUser([BlackIPId] [int]  NOT NULL,[UserType] [int]  NOT NULL,[UserName] [nvarchar] (50)  NOT NULL)  ON [PRIMARY] 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_ArticleAttachment]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_ArticleAttachment] 
 
CREATE TABLE dbo.Web_ArticleAttachment([ArticleID] [int]  NOT NULL,[AttachmentID] [int]  NOT NULL)  ON [PRIMARY] 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_PageControl]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_PageControl] 
 
CREATE TABLE dbo.Web_PageControl([ID] [int]  NOT NULL,[Name] [nvarchar] (50)  NULL,[PageID] [int]  NOT NULL,[ControlID] [nvarchar] (50)  NOT NULL,[Type] [nvarchar] (200)  NOT NULL,[Description] [nvarchar] (2000)  NULL,[IsDel] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_PageControl ADD CONSTRAINT DF_Web_PageControl_IsDel DEFAULT ((0)) FOR [IsDel]
 
INSERT INTO Web_PageControl VALUES ('1','添加','1','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('2','编辑','1','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('3','删除','1','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('4','向上','1','btnUp','Button','向上','0')
 
INSERT INTO Web_PageControl VALUES ('5','向下','1','btnDown','Button','向下','0')
 
INSERT INTO Web_PageControl VALUES ('6','添加','3','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('7','编辑','3','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('8','删除','3','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('9','确定','3','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('10','更新','3','btnEditSubmit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('11','添加','4','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('12','编辑','4','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('13','删除','4','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('14','确定','4','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('15','更新','4','btnEditSubmit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('16','添加','6','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('17','编辑','6','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('18','删除','6','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('19','查询','6','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('20','添加','8','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('21','编辑','8','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('22','删除','8','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('23','确定','8','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('24','更新','8','btnEditSubmit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('25','添加','9','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('26','编辑','9','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('27','删除','9','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('28','确定','9','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('29','更新','9','btnEditSubmit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('30','确定','11','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('31','更新','11','btnEditSubmit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('32','删除','11','btnDelete','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('33','编辑','11','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('34','安装','12','btnAdd','Button','安装','0')
 
INSERT INTO Web_PageControl VALUES ('35','卸载','12','btnEdit','Button','卸载','0')
 
INSERT INTO Web_PageControl VALUES ('36','编辑','12','btnDel','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('37','查询','13','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('38','添加','13','btnAdd','Button','添加','0')
 
INSERT INTO Web_PageControl VALUES ('39','编辑','13','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('40','删除','13','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('41','添加','14','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('42','编辑','14','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('43','删除','14','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('44','向上','14','btnUp','Button','向上','0')
 
INSERT INTO Web_PageControl VALUES ('45','向下','14','btnDown','Button','向下','0')
 
INSERT INTO Web_PageControl VALUES ('46','查询','14','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('47','添加','16','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('48','编辑','16','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('49','删除','16','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('50','添加','17','btnAdd','Button','添加','0')
 
INSERT INTO Web_PageControl VALUES ('51','编辑','17','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('52','删除','17','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('53','广告调用代码','17','LinkButton1','Button','广告调用代码(LinkButton)','0')
 
INSERT INTO Web_PageControl VALUES ('54','广告预览 ','17','LinkButton2','Button','广告预览(LinkButton) ','0')
 
INSERT INTO Web_PageControl VALUES ('55','添加','18','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('56','编辑','18','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('57','删除','18','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('58','向上','18','btnUp','Button','向上','0')
 
INSERT INTO Web_PageControl VALUES ('59','向下','18','btnDown','Button','向下','0')
 
INSERT INTO Web_PageControl VALUES ('60','添加','19','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('61','编辑','19','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('62','删除','19','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('63','添加','20','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('64','编辑','20','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('65','删除','20','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('66','向上','20','btnUp','Button','向上','0')
 
INSERT INTO Web_PageControl VALUES ('67','向下','20','btnDown','Button','向下','0')
 
INSERT INTO Web_PageControl VALUES ('68','查询','20','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('69','添加','22','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('70','编辑','22','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('71','删除','22','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('72','查询','22','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('73','搜索','23','btnLevelSearch','Button','会员等级搜索','0')
 
INSERT INTO Web_PageControl VALUES ('74','搜索','23','btnNameSearch','Button','会员关健字搜索','0')
 
INSERT INTO Web_PageControl VALUES ('75','确定','23','btnAdd','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('76','更新','23','btnEdit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('77','添加','24','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('78','编辑','24','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('79','删除','24','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('80','显示','24','btnVisibleT','Button','显示','0')
 
INSERT INTO Web_PageControl VALUES ('81','隐藏','24','btnVisibleF','Button','隐藏','0')
 
INSERT INTO Web_PageControl VALUES ('82','查询','24','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('83','添加','25','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('84','编辑','25','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('85','删除','25','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('86','添加','27','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('87','编辑','27','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('88','删除','27','btnDelStatus','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('89','彻底删除','27','btnDel','Button','彻底删除','0')
 
INSERT INTO Web_PageControl VALUES ('90','确定','27','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('91','更新','27','btnEditSubmit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('92','查询','27','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('93','删除','28','btnDelStatus','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('94','查询','28','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('95','全选','29','btnSelectAll','Button','全选','0')
 
INSERT INTO Web_PageControl VALUES ('96','全不选','29','btnSelectNoAll','Button','全不选','0')
 
INSERT INTO Web_PageControl VALUES ('97','确定','29','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('98','添加','30','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('99','编辑','30','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('100','删除','30','btnDelStatus','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('101','彻底删除','30','btnDel','Button','彻底删除','0')
 
INSERT INTO Web_PageControl VALUES ('102','查询','30','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('103','确定','30','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('104','更新','32','btnEditSubmit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('105','查询','32','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('106','添加','33','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('107','编辑','33','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('108','删除','33','btnDelStatus','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('109','彻底删除','33','btnDel','Button','彻底删除','0')
 
INSERT INTO Web_PageControl VALUES ('110','确定','33','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('111','更新','33','btnEditSubmit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('112','查询','34','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('113','添加','35','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('114','编辑','35','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('115','删除','35','btnDelStatus','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('116','彻底删除','35','btnDel','Button','彻底删除','0')
 
INSERT INTO Web_PageControl VALUES ('117','确定','35','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('118','更新','35','btnEditSubmit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('119','查询','35','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('120','添加','36','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('121','编辑','36','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('122','删除','36','btnDelStatus','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('123','彻底删除','36','btnDel','Button','彻底删除','0')
 
INSERT INTO Web_PageControl VALUES ('124','确定','36','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('125','更新','36','btnEditSubmit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('126','查询','36','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('127','添加','38','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('128','编辑','38','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('129','删除','38','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('130','查询','38','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('131','确认','39','btnConfirm','Button','确认','0')
 
INSERT INTO Web_PageControl VALUES ('132','退订','39','btnCancel','Button','退订','0')
 
INSERT INTO Web_PageControl VALUES ('133','删除','39','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('134','查询','39','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('135','添加','44','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('136','编辑','44','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('137','删除','44','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('138','查询','44','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('139','确定','45','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('140','添加','49','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('141','编辑','49','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('142','删除','49','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('143','查询','49','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('144','编辑','50','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('145','查询','50','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('146','确定','50','btnEditSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('147','添加','51','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('148','编辑','51','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('149','删除','51','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('150','添加组成员 ','51','btnAddUser','Button','添加组成员 ','0')
 
INSERT INTO Web_PageControl VALUES ('151','查询','51','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('152','发送','53','btnSend','Button','发送','0')
 
INSERT INTO Web_PageControl VALUES ('153','删除','53','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('154','添加','54','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('155','编辑','54','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('156','删除','54','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('157','查询','54','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('158','添加','55','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('159','编辑','55','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('160','删除','55','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('161','查询','55','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('162','确定','55','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('163','更新','55','btnEditSubmit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('164','添加','56','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('165','编辑','56','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('166','删除','56','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('167','查询','56','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('168','确定','56','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('169','更新','56','btnEditSubmit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('170','添加','60','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('171','编辑','60','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('172','删除','60','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('173','添加文章','61','btnAdd','Button','添加文章','0')
 
INSERT INTO Web_PageControl VALUES ('174','添加外部文章','61','AddLink','Button','添加外部文章','0')
 
INSERT INTO Web_PageControl VALUES ('175','编辑 ','61','btnEdit','Button','编辑 ','0')
 
INSERT INTO Web_PageControl VALUES ('176','删除','61','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('177','前台预览','61','lblReview','Button','前台预览(LinkButton)','0')
 
INSERT INTO Web_PageControl VALUES ('178','查看评论 ','61','btnReply','Button','查看评论 ','0')
 
INSERT INTO Web_PageControl VALUES ('179','查询','61','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('180','确定','62','btnAdd','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('181','更新','62','btnEdit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('182','添加','66','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('183','编辑','66','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('184','删除','66','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('185','向上','66','btnUp','Button','向上','0')
 
INSERT INTO Web_PageControl VALUES ('186','向下','66','btnDown','Button','向下','0')
 
INSERT INTO Web_PageControl VALUES ('187','相关分类','66','btnBrandCategory','Button','相关分类','0')
 
INSERT INTO Web_PageControl VALUES ('188','查询','66','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('189','添加','67','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('190','编辑','67','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('191','删除','67','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('192','相关品牌','67','btnCategoryBrand','Button','相关品牌','0')
 
INSERT INTO Web_PageControl VALUES ('193','查看评论','68','btnView','Button','查看评论','0')
 
INSERT INTO Web_PageControl VALUES ('194','回复','68','btnEdit','Button','回复','0')
 
INSERT INTO Web_PageControl VALUES ('195','审核','68','btnPass','Button','审核','0')
 
INSERT INTO Web_PageControl VALUES ('196','取消审核','68','btnUnPass','Button','取消审核','0')
 
INSERT INTO Web_PageControl VALUES ('197','删除','68','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('198','查询','68','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('199','添加','70','btnAdd','Button','添加','0')
 
INSERT INTO Web_PageControl VALUES ('200','编辑','70','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('201','删除','70','btnDelStatus','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('202','锁定用户','70','btnLockUser','Button','锁定用户','0')
 
INSERT INTO Web_PageControl VALUES ('203','取消锁定','70','btnUnLock','Button','取消锁定','0')
 
INSERT INTO Web_PageControl VALUES ('204','冻结资金/积分','70','btnLockScore','Button','冻结资金/积分','0')
 
INSERT INTO Web_PageControl VALUES ('205','积分操作','70','btnScoreOperate','Button','积分操作','0')
 
INSERT INTO Web_PageControl VALUES ('206','查看收货地址','70','btnLookAddress','Button','查看收货地址','0')
 
INSERT INTO Web_PageControl VALUES ('207','查看订单','70','btnViewOrder','Button','查看订单','0')
 
INSERT INTO Web_PageControl VALUES ('208','分配会员卡','70','btnSetUserCard','Button','分配会员卡','0')
 
INSERT INTO Web_PageControl VALUES ('209','分配充值卡','70','btnSetCard','Button','分配充值卡','0')
 
INSERT INTO Web_PageControl VALUES ('210','分配购物卡','70','btnSetShopCard','Button','分配购物卡','0')
 
INSERT INTO Web_PageControl VALUES ('211','分配优惠卷','70','btnSetCoupon','Button','分配优惠卷','0')
 
INSERT INTO Web_PageControl VALUES ('212','查询','70','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('213','确定','72','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('214','添加','73','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('215','编辑','73','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('216','删除','73','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('217','确定','73','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('218','详细/回复','74','btnEdit','Button','详细/回复','0')
 
INSERT INTO Web_PageControl VALUES ('219','审核','74','btnSetPass','Button','审核','0')
 
INSERT INTO Web_PageControl VALUES ('220','取消审核','74','btnSetUnPass','Button','取消审核','0')
 
INSERT INTO Web_PageControl VALUES ('221','删除 ','74','btnDelStatus','Button','删除 ','0')
 
INSERT INTO Web_PageControl VALUES ('222','查询','74','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('223','添加','75','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('224','编辑','75','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('225','删除','75','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('226','管理规则内容','75','btnRuleManage','Button','管理规则内容','0')
 
INSERT INTO Web_PageControl VALUES ('227','确定','75','btnAddT','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('228','添加','76','btnAdd','Button','添加','0')
 
INSERT INTO Web_PageControl VALUES ('229','删除','76','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('230','锁定','76','btnLock','Button','锁定','0')
 
INSERT INTO Web_PageControl VALUES ('231','取消锁定','76','btnUnLock','Button','取消锁定','0')
 
INSERT INTO Web_PageControl VALUES ('232','查看使用记录','76','btnViewLog','Button','查看使用记录','0')
 
INSERT INTO Web_PageControl VALUES ('233','分配给会员','76','btnDistribute','Button','分配给会员(分配卡的时候才显示)','0')
 
INSERT INTO Web_PageControl VALUES ('234','查询','76','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('235','添加','77','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('236','编辑','77','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('237','删除','77','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('238','确定','77','btnAddT','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('239','添加','78','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('240','编辑','78','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('241','删除','78','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('242','向上','78','btnUp','Button','向上','0')
 
INSERT INTO Web_PageControl VALUES ('243','向下','78','btnDown','Button','向下','0')
 
INSERT INTO Web_PageControl VALUES ('244','补货','78','btnAddVirutalCard','Button','补货','0')
 
INSERT INTO Web_PageControl VALUES ('245','相关商品','78','btnRelatedProduct','Button','相关商品','0')
 
INSERT INTO Web_PageControl VALUES ('246','相关文章','78','btnRelatedArticle','Button','相关文章','0')
 
INSERT INTO Web_PageControl VALUES ('247','确定','78','btnExecute','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('248','查询','78','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('249','设置组合商品','79','btnSetPropertyProduct','Button','设置组合商品','0')
 
INSERT INTO Web_PageControl VALUES ('250','显示组合商品','79','btnShowPropertyProduct','Button','显示组合商品','0')
 
INSERT INTO Web_PageControl VALUES ('251','隐藏组合商品','79','btnHiddenPropertyProduct','Button','隐藏组合商品','0')
 
INSERT INTO Web_PageControl VALUES ('252','设置会员价格','79','btnSetPMP','Button','设置会员价格','0')
 
INSERT INTO Web_PageControl VALUES ('253','添加','79','btnCostAdd_T','Button','商品成本的添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('254','更新','79','btnCostEdit_T','Button','商品成本的更新按钮','0')
 
INSERT INTO Web_PageControl VALUES ('255','计算等级会员价格','79','btnAutoCount','Button','','0')
 
INSERT INTO Web_PageControl VALUES ('256','添加','79','btnSelfPropertyAdd_T','Button','自定义商品属性的添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('257','更新','79','btnSelfPropertyEdit_T','Button','自定义商品属性的更新按钮','0')
 
INSERT INTO Web_PageControl VALUES ('258','添加','79','btnAddMorePic_T','Button','商品多图的添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('259','更新','79','btnEditMorePic_T','Button','商品多图的更新按钮','0')
 
INSERT INTO Web_PageControl VALUES ('260','添加','79','btnADDFitting','Button','商品配件的添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('261','移除','79','btnDelFitting','Button','商品配件的移除按钮','0')
 
INSERT INTO Web_PageControl VALUES ('262','添加','79','btnADDRelatedProduct','Button','相关商品的添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('263','移除','79','btnDelRelatedProduct','Button','相关商品的移除按钮','0')
 
INSERT INTO Web_PageControl VALUES ('264','添加','79','btnADDRealtedArticle','Button','相关文章的添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('265','移除','79','btnDelRealtedArticle','Button','相关文章的移除按钮','0')
 
INSERT INTO Web_PageControl VALUES ('266','添加','79','btnADDExtendCategory','Button','扩展分类的添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('267','移除','79','btnDelExtendCategory','Button','扩展分类的移除按钮','0')
 
INSERT INTO Web_PageControl VALUES ('268','确定','79','btnAdd','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('269','更新','79','btnEdit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('270','删除','80','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('271','锁定','80','btnLock','Button','锁定','0')
 
INSERT INTO Web_PageControl VALUES ('272','取消锁定','80','btnUnLock','Button','取消锁定','0')
 
INSERT INTO Web_PageControl VALUES ('273','查看使用记录','80','btnViewLog','Button','查看使用记录','0')
 
INSERT INTO Web_PageControl VALUES ('274','分配给会员','80','btnDistribute','Button','分配给会员(分配卡的时候才显示)','0')
 
INSERT INTO Web_PageControl VALUES ('275','查询','80','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('276','添加','81','btnAdd','Button','添加','0')
 
INSERT INTO Web_PageControl VALUES ('277','删除','81','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('278','分配给会员','81','btnDistribute','Button','分配给会员(分配卡的时候才显示)','0')
 
INSERT INTO Web_PageControl VALUES ('279','添加','83','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('280','编辑','83','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('281','删除','83','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('282','详细','83','btnDetail','Button','详细','0')
 
INSERT INTO Web_PageControl VALUES ('283','查询','83','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('284','查询','84','btnProduct','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('285','确定','84','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('286','添加','85','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('287','编辑','85','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('288','删除','85','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('289','查询','85','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('290','确定','86','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('291','添加','87','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('292','编辑','87','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('293','删除','87','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('294','查询','87','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('295','添加','89','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('296','编辑','89','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('297','删除','89','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('298','查询','89','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('299','添加','90','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('300','编辑','90','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('301','删除','90','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('302','查询','90','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('303','确定','90','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('304','更新','90','btnEditSubmit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('305','添加','91','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('306','编辑','91','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('307','删除','91','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('308','查询','91','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('309','确定','91','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('310','更新','91','btnEditSubmit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('311','添加','92','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('312','删除','92','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('313','启用','92','btnActive','Button','启用','0')
 
INSERT INTO Web_PageControl VALUES ('314','禁用','92','btnUnActive','Button','禁用','0')
 
INSERT INTO Web_PageControl VALUES ('315','查询','92','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('316','分配给会员','92','btnDistribute','Button','分配给会员(分配优惠卷的时候才显示)','0')
 
INSERT INTO Web_PageControl VALUES ('317','添加','93','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('318','编辑','93','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('319','删除','93','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('320','查看订单','93','btnDetail','Button','查看订单','0')
 
INSERT INTO Web_PageControl VALUES ('321','查询','93','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('322','添加','94','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('323','编辑','94','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('324','删除','94','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('325','查询','94','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('326','确定','95','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('327','添加','97','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('328','编辑','97','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('329','删除','97','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('330','确定','97','btnAddT','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('331','更新','97','btnEditT','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('332','查询','97','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('333','确定','101','btnAdd','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('334','更新','101','btnEdit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('335','确定','102','btnAdd','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('336','更新','102','btnEdit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('337','确定','103','btnAdd','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('338','更新','103','btnEdit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('339','确定','104','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('340','确定','105','btnAdd','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('341','更新','105','btnEdit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('342','确定','108','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('343','确定','109','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('344','确定','110','btnAdd','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('345','更新','110','btnEdit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('346','确定','111','btnAdd','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('347','更新','111','btnEdit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('348','添加','112','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('349','添加>>','112','btnAddUser','Button','添加>>','0')
 
INSERT INTO Web_PageControl VALUES ('350','<<移除','112','btnDelUser','Button','<<移除','0')
 
INSERT INTO Web_PageControl VALUES ('351','确定','113','btnAdd','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('352','更新','113','btnEdit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('353','确定','114','btnAdd','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('354','更新','114','btnEdit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('355','搜索','115','btnSearchUser','Button','搜索','0')
 
INSERT INTO Web_PageControl VALUES ('356','添加>>','115','btnAddUser','Button','添加>>','0')
 
INSERT INTO Web_PageControl VALUES ('357','<<移除','115','btnDelUser','Button','<<移除','0')
 
INSERT INTO Web_PageControl VALUES ('358','确定','115','btnAdd','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('359','更新','115','btnEdit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('360','确定','118','btnAdd','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('361','更新','118','btnEdit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('362','确定','118','btnOptionAdd','Button','调查选项里面的确定','0')
 
INSERT INTO Web_PageControl VALUES ('363','更新','118','btnOptionEdit','Button','调查选项里面的更新','0')
 
INSERT INTO Web_PageControl VALUES ('364','添加','118','lbAdd','Button','添加按钮(Linkbutton)','0')
 
INSERT INTO Web_PageControl VALUES ('365','编辑','118','lbEdit','Button','编辑(Linkbutton)','0')
 
INSERT INTO Web_PageControl VALUES ('366','删除','118','lbDel','Button','删除(Linkbutton)','0')
 
INSERT INTO Web_PageControl VALUES ('367','添加','134','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('368','编辑','134','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('369','删除','134','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('370','确定','134','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('371','更新','134','btnEditSubmit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('372','确定','136','btnAdd','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('373','更新','136','btnEdit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('374','添加>>','138','btnAddCategory','Button','添加>>','0')
 
INSERT INTO Web_PageControl VALUES ('375','<<移除','138','btnDelCategory','Button','<<移除','0')
 
INSERT INTO Web_PageControl VALUES ('376','确定','138','btnAdd','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('377','添加>>','139','btnAddBrand','Button','','0')
 
INSERT INTO Web_PageControl VALUES ('378','<<移除','139','btnDelBrand','Button','','0')
 
INSERT INTO Web_PageControl VALUES ('379','确定','139','btnAdd','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('380','更新','139','btnEdit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('381','添加>>','140','btnAddBrand','Button','添加>>','0')
 
INSERT INTO Web_PageControl VALUES ('382','<<移除','140','btnDelBrand','Button','<<移除','0')
 
INSERT INTO Web_PageControl VALUES ('383','确定','140','btnAdd','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('384','添加','147','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('385','编辑','147','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('386','删除','147','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('387','确定','147','btnAddT','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('388','更新','147','btnEditT','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('389','确定','148','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('390','添加','149','btnAdd','Button','添加按钮(添加价格阶梯的按钮)','0')
 
INSERT INTO Web_PageControl VALUES ('391','编辑','149','btnEdit','Button','编辑(添加价格阶梯的按钮)','0')
 
INSERT INTO Web_PageControl VALUES ('392','删除','149','btnDel','Button','删除(添加价格阶梯的按钮)','0')
 
INSERT INTO Web_PageControl VALUES ('393','确定','149','btnSetPrice','Button','确定(添加价格阶梯的按钮)','0')
 
INSERT INTO Web_PageControl VALUES ('394','确定','149','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('395','确定','150','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('396','添加','153','btnMoveRight','Button','添加','0')
 
INSERT INTO Web_PageControl VALUES ('397','移除','153','btnMoveLeft','Button','移除','0')
 
INSERT INTO Web_PageControl VALUES ('398','确定','153','btnAdd','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('399','更新','153','btnEdit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('400','测试邮件发送','154','btnSendTest','Button','测试邮件发送','0')
 
INSERT INTO Web_PageControl VALUES ('401','确定','154','btnAdd','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('402','更新','154','btnEdit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('403','管理','155','btnManage','Button','管理','0')
 
INSERT INTO Web_PageControl VALUES ('404','确定','155','btnAdd','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('405','更新','155','btnEdit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('406','确定','156','btnAdd','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('407','确定','158','btnAdd','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('408','更新','158','btnEdit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('409','确定','159','btnAdd','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('410','更新','159','btnEdit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('411','确定','160','btnAdd','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('412','更新','160','btnEdit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('413','确定','171','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('414','确定','173','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('415','查看评论','175','btnView','Button','查看评论','0')
 
INSERT INTO Web_PageControl VALUES ('416','回复','175','btnEdit','Button','回复','0')
 
INSERT INTO Web_PageControl VALUES ('417','审核','175','btnPass','Button','审核','0')
 
INSERT INTO Web_PageControl VALUES ('418','取消审核','175','btnUnPass','Button','取消审核','0')
 
INSERT INTO Web_PageControl VALUES ('419','删除','175','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('420','查询','175','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('421','添加','178','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('422','编辑','178','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('423','删除','178','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('424','向上','178','btnUp','Button','向上','0')
 
INSERT INTO Web_PageControl VALUES ('425','向下','178','btnDown','Button','向下','0')
 
INSERT INTO Web_PageControl VALUES ('426',' 转为普通商品','178','btnChangeNormalProduct','Button',' 转为普通商品','0')
 
INSERT INTO Web_PageControl VALUES ('427','查询','179','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('428','添加','179','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('429','编辑','179','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('430','删除','179','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('431','向上','179','btnUp','Button','向上','0')
 
INSERT INTO Web_PageControl VALUES ('432','向下','179','btnDown','Button','向下','0')
 
INSERT INTO Web_PageControl VALUES ('433',' 转为普通商品','179','btnChangeNormalProduct','Button',' 转为普通商品','0')
 
INSERT INTO Web_PageControl VALUES ('434','查询','179','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('435','添加','180','btnAdd','Button','添加按钮','0')
 
INSERT INTO Web_PageControl VALUES ('436','删除','180','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('437','查询','180','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('438','确定','181','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('439','确定','181','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('440','确定','182','btnAdd','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('441',' 处理/详细','183','btnEdit','Button',' 处理/详细','0')
 
INSERT INTO Web_PageControl VALUES ('442','删除 ','183','btnDel','Button','删除 ','0')
 
INSERT INTO Web_PageControl VALUES ('443','入库 ','183','btnInStock','Button','入库 ','0')
 
INSERT INTO Web_PageControl VALUES ('444','更新','184','btnEdit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('445','确定','201','btnCreate','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('446','选择全部会员','212','btnSelectAll','Button','选择全部会员','0')
 
INSERT INTO Web_PageControl VALUES ('447','发送','212','btnSend','Button','发送','0')
 
INSERT INTO Web_PageControl VALUES ('448','安装','214','btnAdd','Button','安装','0')
 
INSERT INTO Web_PageControl VALUES ('449','卸载','214','btnDel','Button','卸载','0')
 
INSERT INTO Web_PageControl VALUES ('450','编辑','214','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('451','确定','215','btnAdd','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('452','更新','215','btnEdit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('453','查询','219','btnSearch','Button','查询','0')
 
INSERT INTO Web_PageControl VALUES ('454','添加','219','btnAdd','Button','添加','0')
 
INSERT INTO Web_PageControl VALUES ('455','编辑','219','btnEdit','Button','编辑','0')
 
INSERT INTO Web_PageControl VALUES ('456','删除','219','btnDel','Button','删除','0')
 
INSERT INTO Web_PageControl VALUES ('457','向上','219','btnUp','Button','向上','0')
 
INSERT INTO Web_PageControl VALUES ('458','向下','219','btnDown','Button','向下','0')
 
INSERT INTO Web_PageControl VALUES ('459','确定','220','btnAdd','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('460','更新','220','btnEdit','Button','更新','0')
 
INSERT INTO Web_PageControl VALUES ('461','确定','227','btnAddSubmit','Button','确定','0')
 
INSERT INTO Web_PageControl VALUES ('462','向上','61','btnUp','Button','向上','0')
 
INSERT INTO Web_PageControl VALUES ('463','向下','61','btnDown','Button','向下','0')
 
CREATE TABLE dbo.Tmp_Web_PageControl([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NULL,[PageID] [int]  NOT NULL,[ControlID] [nvarchar] (50)  NOT NULL,[Type] [nvarchar] (200)  NOT NULL,[Description] [nvarchar] (2000)  NULL,[IsDel] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_PageControl ADD CONSTRAINT DF_Tmp_Web_PageControl_IsDel DEFAULT ((0)) FOR [IsDel]
 
SET IDENTITY_INSERT dbo.Tmp_Web_PageControl ON
 
IF EXISTS(SELECT * FROM dbo.Web_PageControl) EXEC('INSERT INTO dbo.Tmp_Web_PageControl ([ID],[Name],[PageID],[ControlID],[Type],[Description],[IsDel]) SELECT [ID],[Name],[PageID],[ControlID],[Type],[Description],[IsDel] FROM dbo.Web_PageControl WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_PageControl OFF
 
DROP TABLE dbo.Web_PageControl
 
EXECUTE sp_rename N'dbo.Tmp_Web_PageControl', N'Web_PageControl', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Brand]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Brand] 
 
CREATE TABLE dbo.Web_Brand([ID] [int]  NOT NULL,[Name] [nvarchar] (50)  NULL,[SrcList] [nvarchar] (255)  NULL,[SrcDetail] [nvarchar] (250)  NULL,[Website] [nvarchar] (100)  NULL,[OrderID] [int]  NOT NULL,[Content] [ntext]  NULL,[IsShow] [int]  NOT NULL,[Title] [nvarchar] (100)  NULL,[Keywords] [nvarchar] (255)  NULL,[Description] [nvarchar] (255)  NULL,[Pinyin] [nvarchar] (100)  NULL,[Company] [nvarchar] (100)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Brand ADD CONSTRAINT DF_Web_Brand_OrderID DEFAULT ((0)) FOR [OrderID]
 
ALTER TABLE dbo.Web_Brand ADD CONSTRAINT DF_Web_Brand_IsShow DEFAULT ((0)) FOR [IsShow]
 
CREATE TABLE dbo.Tmp_Web_Brand([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NULL,[SrcList] [nvarchar] (255)  NULL,[SrcDetail] [nvarchar] (250)  NULL,[Website] [nvarchar] (100)  NULL,[OrderID] [int]  NOT NULL,[Content] [ntext]  NULL,[IsShow] [int]  NOT NULL,[Title] [nvarchar] (100)  NULL,[Keywords] [nvarchar] (255)  NULL,[Description] [nvarchar] (255)  NULL,[Pinyin] [nvarchar] (100)  NULL,[Company] [nvarchar] (100)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_Brand ADD CONSTRAINT DF_Tmp_Web_Brand_OrderID DEFAULT ((0)) FOR [OrderID]
 
ALTER TABLE dbo.Tmp_Web_Brand ADD CONSTRAINT DF_Tmp_Web_Brand_IsShow DEFAULT ((0)) FOR [IsShow]
 
SET IDENTITY_INSERT dbo.Tmp_Web_Brand ON
 
IF EXISTS(SELECT * FROM dbo.Web_Brand) EXEC('INSERT INTO dbo.Tmp_Web_Brand ([ID],[Name],[SrcList],[SrcDetail],[Website],[OrderID],[Content],[IsShow],[Title],[Keywords],[Description],[Pinyin],[Company]) SELECT [ID],[Name],[SrcList],[SrcDetail],[Website],[OrderID],[Content],[IsShow],[Title],[Keywords],[Description],[Pinyin],[Company] FROM dbo.Web_Brand WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Brand OFF
 
DROP TABLE dbo.Web_Brand
 
EXECUTE sp_rename N'dbo.Tmp_Web_Brand', N'Web_Brand', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_TelRecord]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_TelRecord] 
 
CREATE TABLE dbo.Web_TelRecord([ID] [int]  NOT NULL,[Content] [nvarchar] (250)  NULL,[Telephone] [nvarchar] (150)  NULL,[TelUser] [nvarchar] (50)  NULL,[TelTitle] [nvarchar] (250)  NULL,[ListenUser] [nvarchar] (50)  NULL,[Remark] [nvarchar] (250)  NULL,[Date] [datetime]  NOT NULL,[DealStatus] [int]  NOT NULL,[UserName] [nvarchar] (50)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_TelRecord ADD CONSTRAINT DF_Web_TelRecord_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Web_TelRecord ADD CONSTRAINT DF_Web_TelRecord_DealStatus DEFAULT ((0)) FOR [DealStatus]
 
CREATE TABLE dbo.Tmp_Web_TelRecord([ID] [int]  NOT NULL IDENTITY (1, 1),[Content] [nvarchar] (250)  NULL,[Telephone] [nvarchar] (150)  NULL,[TelUser] [nvarchar] (50)  NULL,[TelTitle] [nvarchar] (250)  NULL,[ListenUser] [nvarchar] (50)  NULL,[Remark] [nvarchar] (250)  NULL,[Date] [datetime]  NOT NULL,[DealStatus] [int]  NOT NULL,[UserName] [nvarchar] (50)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_TelRecord ADD CONSTRAINT DF_Tmp_Web_TelRecord_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Tmp_Web_TelRecord ADD CONSTRAINT DF_Tmp_Web_TelRecord_DealStatus DEFAULT ((0)) FOR [DealStatus]
 
SET IDENTITY_INSERT dbo.Tmp_Web_TelRecord ON
 
IF EXISTS(SELECT * FROM dbo.Web_TelRecord) EXEC('INSERT INTO dbo.Tmp_Web_TelRecord ([ID],[Content],[Telephone],[TelUser],[TelTitle],[ListenUser],[Remark],[Date],[DealStatus],[UserName]) SELECT [ID],[Content],[Telephone],[TelUser],[TelTitle],[ListenUser],[Remark],[Date],[DealStatus],[UserName] FROM dbo.Web_TelRecord WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_TelRecord OFF
 
DROP TABLE dbo.Web_TelRecord
 
EXECUTE sp_rename N'dbo.Tmp_Web_TelRecord', N'Web_TelRecord', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_OrderStatus]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_OrderStatus] 
 
CREATE TABLE dbo.Web_OrderStatus([ID] [int]  NOT NULL,[Name] [nvarchar] (20)  NULL,[OrderID] [int]  NOT NULL,[IsCODOrderID] [int]  NOT NULL)  ON [PRIMARY] 
 
INSERT INTO Web_OrderStatus VALUES ('-3','用户取消','2','2')
 
INSERT INTO Web_OrderStatus VALUES ('-2','管理员取消','1','1')
 
INSERT INTO Web_OrderStatus VALUES ('0','未处理 → ','3','3')
 
INSERT INTO Web_OrderStatus VALUES ('1','已付款 → ','4','6')
 
INSERT INTO Web_OrderStatus VALUES ('2','已收款 → ','5','7')
 
INSERT INTO Web_OrderStatus VALUES ('3','已发货 → ','6','4')
 
INSERT INTO Web_OrderStatus VALUES ('4','已收货 → ','7','5')
 
INSERT INTO Web_OrderStatus VALUES ('5','完成','8','8')
 
CREATE TABLE dbo.Tmp_Web_OrderStatus([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (20)  NULL,[OrderID] [int]  NOT NULL,[IsCODOrderID] [int]  NOT NULL)  ON [PRIMARY] 
 
SET IDENTITY_INSERT dbo.Tmp_Web_OrderStatus ON
 
IF EXISTS(SELECT * FROM dbo.Web_OrderStatus) EXEC('INSERT INTO dbo.Tmp_Web_OrderStatus ([ID],[Name],[OrderID],[IsCODOrderID]) SELECT [ID],[Name],[OrderID],[IsCODOrderID] FROM dbo.Web_OrderStatus WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_OrderStatus OFF
 
DROP TABLE dbo.Web_OrderStatus
 
EXECUTE sp_rename N'dbo.Tmp_Web_OrderStatus', N'Web_OrderStatus', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_CouponGroup]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_CouponGroup] 
 
CREATE TABLE dbo.Web_CouponGroup([GroupID] [int]  NOT NULL,[CouponID] [int]  NOT NULL)  ON [PRIMARY] 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_UserCard]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_UserCard] 
 
CREATE TABLE dbo.Web_UserCard([ID] [int]  NOT NULL,[Number] [nvarchar] (100)  NOT NULL,[Password] [nvarchar] (50)  NOT NULL,[Discount] [int]  NOT NULL,[UserName] [nvarchar] (50)  NOT NULL,[Price] [decimal]  (18,2) NOT NULL,[DispenseCount] [int]  NOT NULL,[EndDate] [datetime]  NOT NULL,[DispenseOrder] [int]  NOT NULL,[DistributeStatus] [int]  NOT NULL,[CardPrise] [decimal]  (18,2) NOT NULL,[DistributeName] [nvarchar] (20)  NOT NULL,[AdminName] [nvarchar] (20)  NOT NULL,[Date] [datetime]  NOT NULL,[IsLock] [int]  NOT NULL,[IsDel] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_UserCard ADD CONSTRAINT DF_Web_UserCard_Discount DEFAULT ((100)) FOR [Discount]
 
ALTER TABLE dbo.Web_UserCard ADD CONSTRAINT DF_Web_UserCard_UserName DEFAULT ('') FOR [UserName]
 
ALTER TABLE dbo.Web_UserCard ADD CONSTRAINT DF_Web_UserCard_DistributeStatus DEFAULT ((0)) FOR [DistributeStatus]
 
ALTER TABLE dbo.Web_UserCard ADD CONSTRAINT DF_Web_UserCard_DistributeName DEFAULT ('') FOR [DistributeName]
 
ALTER TABLE dbo.Web_UserCard ADD CONSTRAINT DF_Web_UserCard_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Web_UserCard ADD CONSTRAINT DF_Web_UserCard_IsLock DEFAULT ((0)) FOR [IsLock]
 
ALTER TABLE dbo.Web_UserCard ADD CONSTRAINT DF_Web_UserCard_IsDel DEFAULT ((0)) FOR [IsDel]
 
CREATE TABLE dbo.Tmp_Web_UserCard([ID] [int]  NOT NULL IDENTITY (1, 1),[Number] [nvarchar] (100)  NOT NULL,[Password] [nvarchar] (50)  NOT NULL,[Discount] [int]  NOT NULL,[UserName] [nvarchar] (50)  NOT NULL,[Price] [decimal]  (18,2) NOT NULL,[DispenseCount] [int]  NOT NULL,[EndDate] [datetime]  NOT NULL,[DispenseOrder] [int]  NOT NULL,[DistributeStatus] [int]  NOT NULL,[CardPrise] [decimal]  (18,2) NOT NULL,[DistributeName] [nvarchar] (20)  NOT NULL,[AdminName] [nvarchar] (20)  NOT NULL,[Date] [datetime]  NOT NULL,[IsLock] [int]  NOT NULL,[IsDel] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_UserCard ADD CONSTRAINT DF_Tmp_Web_UserCard_Discount DEFAULT ((100)) FOR [Discount]
 
ALTER TABLE dbo.Tmp_Web_UserCard ADD CONSTRAINT DF_Tmp_Web_UserCard_UserName DEFAULT ('') FOR [UserName]
 
ALTER TABLE dbo.Tmp_Web_UserCard ADD CONSTRAINT DF_Tmp_Web_UserCard_DistributeStatus DEFAULT ((0)) FOR [DistributeStatus]
 
ALTER TABLE dbo.Tmp_Web_UserCard ADD CONSTRAINT DF_Tmp_Web_UserCard_DistributeName DEFAULT ('') FOR [DistributeName]
 
ALTER TABLE dbo.Tmp_Web_UserCard ADD CONSTRAINT DF_Tmp_Web_UserCard_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Tmp_Web_UserCard ADD CONSTRAINT DF_Tmp_Web_UserCard_IsLock DEFAULT ((0)) FOR [IsLock]
 
ALTER TABLE dbo.Tmp_Web_UserCard ADD CONSTRAINT DF_Tmp_Web_UserCard_IsDel DEFAULT ((0)) FOR [IsDel]
 
SET IDENTITY_INSERT dbo.Tmp_Web_UserCard ON
 
IF EXISTS(SELECT * FROM dbo.Web_UserCard) EXEC('INSERT INTO dbo.Tmp_Web_UserCard ([ID],[Number],[Password],[Discount],[UserName],[Price],[DispenseCount],[EndDate],[DispenseOrder],[DistributeStatus],[CardPrise],[DistributeName],[AdminName],[Date],[IsLock],[IsDel]) SELECT [ID],[Number],[Password],[Discount],[UserName],[Price],[DispenseCount],[EndDate],[DispenseOrder],[DistributeStatus],[CardPrise],[DistributeName],[AdminName],[Date],[IsLock],[IsDel] FROM dbo.Web_UserCard WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_UserCard OFF
 
DROP TABLE dbo.Web_UserCard
 
EXECUTE sp_rename N'dbo.Tmp_Web_UserCard', N'Web_UserCard', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Notice]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Notice] 
 
CREATE TABLE dbo.Web_Notice([ID] [int]  NOT NULL,[Title] [nvarchar] (100)  NULL,[Description] [nvarchar] (250)  NULL,[Content] [ntext]  NULL,[Hits] [int]  NOT NULL,[IsDel] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[SeoTitle] [nvarchar] (150)  NULL,[SeoKeywords] [nvarchar] (150)  NULL,[SeoDescription] [nvarchar] (300)  NULL,[OrderID] [int]  NOT NULL,[Author] [nvarchar] (50)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Notice ADD CONSTRAINT DF_Web_Notice_Hits DEFAULT ((0)) FOR [Hits]
 
ALTER TABLE dbo.Web_Notice ADD CONSTRAINT DF_Web_Notice_IsDel DEFAULT ((0)) FOR [IsDel]
 
ALTER TABLE dbo.Web_Notice ADD CONSTRAINT DF_Web_Notice_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Web_Notice ADD CONSTRAINT DF_Web_Notice_OrderID DEFAULT ((1000)) FOR [OrderID]
 
CREATE TABLE dbo.Tmp_Web_Notice([ID] [int]  NOT NULL IDENTITY (1, 1),[Title] [nvarchar] (100)  NULL,[Description] [nvarchar] (250)  NULL,[Content] [ntext]  NULL,[Hits] [int]  NOT NULL,[IsDel] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[SeoTitle] [nvarchar] (150)  NULL,[SeoKeywords] [nvarchar] (150)  NULL,[SeoDescription] [nvarchar] (300)  NULL,[OrderID] [int]  NOT NULL,[Author] [nvarchar] (50)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_Notice ADD CONSTRAINT DF_Tmp_Web_Notice_Hits DEFAULT ((0)) FOR [Hits]
 
ALTER TABLE dbo.Tmp_Web_Notice ADD CONSTRAINT DF_Tmp_Web_Notice_IsDel DEFAULT ((0)) FOR [IsDel]
 
ALTER TABLE dbo.Tmp_Web_Notice ADD CONSTRAINT DF_Tmp_Web_Notice_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Tmp_Web_Notice ADD CONSTRAINT DF_Tmp_Web_Notice_OrderID DEFAULT ((1000)) FOR [OrderID]
 
SET IDENTITY_INSERT dbo.Tmp_Web_Notice ON
 
IF EXISTS(SELECT * FROM dbo.Web_Notice) EXEC('INSERT INTO dbo.Tmp_Web_Notice ([ID],[Title],[Description],[Content],[Hits],[IsDel],[Date],[SeoTitle],[SeoKeywords],[SeoDescription],[OrderID],[Author]) SELECT [ID],[Title],[Description],[Content],[Hits],[IsDel],[Date],[SeoTitle],[SeoKeywords],[SeoDescription],[OrderID],[Author] FROM dbo.Web_Notice WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Notice OFF
 
DROP TABLE dbo.Web_Notice
 
EXECUTE sp_rename N'dbo.Tmp_Web_Notice', N'Web_Notice', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_ActivityProduct]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_ActivityProduct] 
 
CREATE TABLE dbo.Web_ActivityProduct([ProductID] [int]  NOT NULL,[ActivityID] [int]  NOT NULL)  ON [PRIMARY] 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_FittingType]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_FittingType] 
 
CREATE TABLE dbo.Web_FittingType([ID] [int]  NOT NULL,[Name] [nvarchar] (50)  NULL,[TypeID] [int]  NOT NULL,[IsSingle] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_FittingType ADD CONSTRAINT DF_Web_FittingType_TypeID DEFAULT ((0)) FOR [TypeID]
 
ALTER TABLE dbo.Web_FittingType ADD CONSTRAINT DF_Web_FittingType_IsSingle DEFAULT ((0)) FOR [IsSingle]
 
CREATE TABLE dbo.Tmp_Web_FittingType([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NULL,[TypeID] [int]  NOT NULL,[IsSingle] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_FittingType ADD CONSTRAINT DF_Tmp_Web_FittingType_TypeID DEFAULT ((0)) FOR [TypeID]
 
ALTER TABLE dbo.Tmp_Web_FittingType ADD CONSTRAINT DF_Tmp_Web_FittingType_IsSingle DEFAULT ((0)) FOR [IsSingle]
 
SET IDENTITY_INSERT dbo.Tmp_Web_FittingType ON
 
IF EXISTS(SELECT * FROM dbo.Web_FittingType) EXEC('INSERT INTO dbo.Tmp_Web_FittingType ([ID],[Name],[TypeID],[IsSingle]) SELECT [ID],[Name],[TypeID],[IsSingle] FROM dbo.Web_FittingType WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_FittingType OFF
 
DROP TABLE dbo.Web_FittingType
 
EXECUTE sp_rename N'dbo.Tmp_Web_FittingType', N'Web_FittingType', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Picture]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Picture] 
 
CREATE TABLE dbo.Web_Picture([ID] [int]  NOT NULL,[Name] [nvarchar] (20)  NULL,[CategoryID] [int]  NOT NULL,[Src] [nvarchar] (250)  NULL,[Date] [datetime]  NOT NULL,[Description] [nvarchar] (100)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Picture ADD CONSTRAINT DF_Web_Picture_CategoryID DEFAULT ((0)) FOR [CategoryID]
 
ALTER TABLE dbo.Web_Picture ADD CONSTRAINT DF_Web_Picture_Date DEFAULT (getdate()) FOR [Date]
 
CREATE TABLE dbo.Tmp_Web_Picture([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (20)  NULL,[CategoryID] [int]  NOT NULL,[Src] [nvarchar] (250)  NULL,[Date] [datetime]  NOT NULL,[Description] [nvarchar] (100)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_Picture ADD CONSTRAINT DF_Tmp_Web_Picture_CategoryID DEFAULT ((0)) FOR [CategoryID]
 
ALTER TABLE dbo.Tmp_Web_Picture ADD CONSTRAINT DF_Tmp_Web_Picture_Date DEFAULT (getdate()) FOR [Date]
 
SET IDENTITY_INSERT dbo.Tmp_Web_Picture ON
 
IF EXISTS(SELECT * FROM dbo.Web_Picture) EXEC('INSERT INTO dbo.Tmp_Web_Picture ([ID],[Name],[CategoryID],[Src],[Date],[Description]) SELECT [ID],[Name],[CategoryID],[Src],[Date],[Description] FROM dbo.Web_Picture WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Picture OFF
 
DROP TABLE dbo.Web_Picture
 
EXECUTE sp_rename N'dbo.Tmp_Web_Picture', N'Web_Picture', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_UserCollect]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_UserCollect] 
 
CREATE TABLE dbo.Web_UserCollect([ID] [int]  NOT NULL,[UserName] [varchar] (1) NOT NULL,[ProductID] [int]  NOT NULL,[Date] [datetime]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_UserCollect ADD CONSTRAINT DF_Web_UserCollect_Date DEFAULT (getdate()) FOR [Date]
 
CREATE TABLE dbo.Tmp_Web_UserCollect([ID] [int]  NOT NULL IDENTITY (1, 1),[UserName] [varchar] (1) NOT NULL,[ProductID] [int]  NOT NULL,[Date] [datetime]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_UserCollect ADD CONSTRAINT DF_Tmp_Web_UserCollect_Date DEFAULT (getdate()) FOR [Date]
 
SET IDENTITY_INSERT dbo.Tmp_Web_UserCollect ON
 
IF EXISTS(SELECT * FROM dbo.Web_UserCollect) EXEC('INSERT INTO dbo.Tmp_Web_UserCollect ([ID],[UserName],[ProductID],[Date]) SELECT [ID],[UserName],[ProductID],[Date] FROM dbo.Web_UserCollect WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_UserCollect OFF
 
DROP TABLE dbo.Web_UserCollect
 
EXECUTE sp_rename N'dbo.Tmp_Web_UserCollect', N'Web_UserCollect', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Guide]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Guide] 
 
CREATE TABLE dbo.Web_Guide([ID] [int]  NOT NULL,[Name] [nvarchar] (50)  NOT NULL,[SrcList] [nvarchar] (250)  NOT NULL,[SrcDetail] [nvarchar] (250)  NOT NULL,[Date] [datetime]  NOT NULL,[SearchKey] [nvarchar] (50)  NOT NULL,[OrderID] [int]  NOT NULL,[Content] [ntext]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Guide ADD CONSTRAINT DF_Web_Guide_SrcList DEFAULT ('') FOR [SrcList]
 
ALTER TABLE dbo.Web_Guide ADD CONSTRAINT DF_Web_Guide_SrcDetail DEFAULT ('') FOR [SrcDetail]
 
ALTER TABLE dbo.Web_Guide ADD CONSTRAINT DF_Web_Guide_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Web_Guide ADD CONSTRAINT DF_Web_Guide_SearchKey DEFAULT ('') FOR [SearchKey]
 
ALTER TABLE dbo.Web_Guide ADD CONSTRAINT DF_Web_Guide_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Web_Guide ADD CONSTRAINT DF_Web_Guide_Content DEFAULT ('') FOR [Content]
 
CREATE TABLE dbo.Tmp_Web_Guide([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NOT NULL,[SrcList] [nvarchar] (250)  NOT NULL,[SrcDetail] [nvarchar] (250)  NOT NULL,[Date] [datetime]  NOT NULL,[SearchKey] [nvarchar] (50)  NOT NULL,[OrderID] [int]  NOT NULL,[Content] [ntext]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_Guide ADD CONSTRAINT DF_Tmp_Web_Guide_SrcList DEFAULT ('') FOR [SrcList]
 
ALTER TABLE dbo.Tmp_Web_Guide ADD CONSTRAINT DF_Tmp_Web_Guide_SrcDetail DEFAULT ('') FOR [SrcDetail]
 
ALTER TABLE dbo.Tmp_Web_Guide ADD CONSTRAINT DF_Tmp_Web_Guide_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Tmp_Web_Guide ADD CONSTRAINT DF_Tmp_Web_Guide_SearchKey DEFAULT ('') FOR [SearchKey]
 
ALTER TABLE dbo.Tmp_Web_Guide ADD CONSTRAINT DF_Tmp_Web_Guide_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Tmp_Web_Guide ADD CONSTRAINT DF_Tmp_Web_Guide_Content DEFAULT ('') FOR [Content]
 
SET IDENTITY_INSERT dbo.Tmp_Web_Guide ON
 
IF EXISTS(SELECT * FROM dbo.Web_Guide) EXEC('INSERT INTO dbo.Tmp_Web_Guide ([ID],[Name],[SrcList],[SrcDetail],[Date],[SearchKey],[OrderID],[Content]) SELECT [ID],[Name],[SrcList],[SrcDetail],[Date],[SearchKey],[OrderID],[Content] FROM dbo.Web_Guide WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Guide OFF
 
DROP TABLE dbo.Web_Guide
 
EXECUTE sp_rename N'dbo.Tmp_Web_Guide', N'Web_Guide', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_BrandCategory]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_BrandCategory] 
 
CREATE TABLE dbo.Web_BrandCategory([BrandID] [int]  NOT NULL,[CategoryID] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_BrandCategory ADD CONSTRAINT DF_Web_BrandCategory_BrandID DEFAULT ((0)) FOR [BrandID]
 
ALTER TABLE dbo.Web_BrandCategory ADD CONSTRAINT DF_Web_BrandCategory_CategoryID DEFAULT ((0)) FOR [CategoryID]
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_ProductProperty]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_ProductProperty] 
 
CREATE TABLE dbo.Web_ProductProperty([ID] [int]  NOT NULL,[ProductID] [int]  NOT NULL,[Name] [nvarchar] (50)  NULL,[Value] [nvarchar] (250)  NULL,[IsInOrder] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_ProductProperty ADD CONSTRAINT DF_Web_ProductProperty_ProductID DEFAULT ((0)) FOR [ProductID]
 
CREATE TABLE dbo.Tmp_Web_ProductProperty([ID] [int]  NOT NULL IDENTITY (1, 1),[ProductID] [int]  NOT NULL,[Name] [nvarchar] (50)  NULL,[Value] [nvarchar] (250)  NULL,[IsInOrder] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_ProductProperty ADD CONSTRAINT DF_Tmp_Web_ProductProperty_ProductID DEFAULT ((0)) FOR [ProductID]
 
SET IDENTITY_INSERT dbo.Tmp_Web_ProductProperty ON
 
IF EXISTS(SELECT * FROM dbo.Web_ProductProperty) EXEC('INSERT INTO dbo.Tmp_Web_ProductProperty ([ID],[ProductID],[Name],[Value],[IsInOrder]) SELECT [ID],[ProductID],[Name],[Value],[IsInOrder] FROM dbo.Web_ProductProperty WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_ProductProperty OFF
 
DROP TABLE dbo.Web_ProductProperty
 
EXECUTE sp_rename N'dbo.Tmp_Web_ProductProperty', N'Web_ProductProperty', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_GuideProduct]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_GuideProduct] 
 
CREATE TABLE dbo.Web_GuideProduct([ProductID] [int]  NOT NULL,[GuideID] [int]  NOT NULL)  ON [PRIMARY] 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_ProductReview]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_ProductReview] 
 
CREATE TABLE dbo.Web_ProductReview([ID] [int]  NOT NULL,[ProductID] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[UserName] [nvarchar] (50)  NOT NULL,[Star] [int]  NOT NULL,[Title] [nvarchar] (50)  NOT NULL,[Content] [nvarchar] (250)  NOT NULL,[IP] [nvarchar] (20)  NOT NULL,[Remark] [nvarchar] (250)  NOT NULL,[RemarkDate] [datetime]  NOT NULL,[IsRemark] [int]  NOT NULL,[IsPass] [int]  NOT NULL,[IsDel] [int]  NOT NULL,[ReviewTo] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_ProductReview ADD CONSTRAINT DF_Web_ProductReview_ProductID DEFAULT ((0)) FOR [ProductID]
 
ALTER TABLE dbo.Web_ProductReview ADD CONSTRAINT DF_Web_ProductReview_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Web_ProductReview ADD CONSTRAINT DF_Web_ProductReview_UserName DEFAULT ('') FOR [UserName]
 
ALTER TABLE dbo.Web_ProductReview ADD CONSTRAINT DF_Web_ProductReview_Star DEFAULT ((0)) FOR [Star]
 
ALTER TABLE dbo.Web_ProductReview ADD CONSTRAINT DF_Web_ProductReview_Title DEFAULT ('') FOR [Title]
 
ALTER TABLE dbo.Web_ProductReview ADD CONSTRAINT DF_Web_ProductReview_Content DEFAULT ('') FOR [Content]
 
ALTER TABLE dbo.Web_ProductReview ADD CONSTRAINT DF_Web_ProductReview_IP DEFAULT ('') FOR [IP]
 
ALTER TABLE dbo.Web_ProductReview ADD CONSTRAINT DF_Web_ProductReview_Remark DEFAULT ('') FOR [Remark]
 
ALTER TABLE dbo.Web_ProductReview ADD CONSTRAINT DF_Web_ProductReview_RemarkDate DEFAULT (getdate()) FOR [RemarkDate]
 
ALTER TABLE dbo.Web_ProductReview ADD CONSTRAINT DF_Web_ProductReview_IsRemark DEFAULT ((0)) FOR [IsRemark]
 
ALTER TABLE dbo.Web_ProductReview ADD CONSTRAINT DF_Web_ProductReview_IsPass DEFAULT ((0)) FOR [IsPass]
 
ALTER TABLE dbo.Web_ProductReview ADD CONSTRAINT DF_Web_ProductReview_IsDel DEFAULT ((0)) FOR [IsDel]
 
ALTER TABLE dbo.Web_ProductReview ADD CONSTRAINT DF_Web_ProductReview_ReviewTo DEFAULT ((0)) FOR [ReviewTo]
 
CREATE TABLE dbo.Tmp_Web_ProductReview([ID] [int]  NOT NULL IDENTITY (1, 1),[ProductID] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[UserName] [nvarchar] (50)  NOT NULL,[Star] [int]  NOT NULL,[Title] [nvarchar] (50)  NOT NULL,[Content] [nvarchar] (250)  NOT NULL,[IP] [nvarchar] (20)  NOT NULL,[Remark] [nvarchar] (250)  NOT NULL,[RemarkDate] [datetime]  NOT NULL,[IsRemark] [int]  NOT NULL,[IsPass] [int]  NOT NULL,[IsDel] [int]  NOT NULL,[ReviewTo] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_ProductReview ADD CONSTRAINT DF_Tmp_Web_ProductReview_ProductID DEFAULT ((0)) FOR [ProductID]
 
ALTER TABLE dbo.Tmp_Web_ProductReview ADD CONSTRAINT DF_Tmp_Web_ProductReview_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Tmp_Web_ProductReview ADD CONSTRAINT DF_Tmp_Web_ProductReview_UserName DEFAULT ('') FOR [UserName]
 
ALTER TABLE dbo.Tmp_Web_ProductReview ADD CONSTRAINT DF_Tmp_Web_ProductReview_Star DEFAULT ((0)) FOR [Star]
 
ALTER TABLE dbo.Tmp_Web_ProductReview ADD CONSTRAINT DF_Tmp_Web_ProductReview_Title DEFAULT ('') FOR [Title]
 
ALTER TABLE dbo.Tmp_Web_ProductReview ADD CONSTRAINT DF_Tmp_Web_ProductReview_Content DEFAULT ('') FOR [Content]
 
ALTER TABLE dbo.Tmp_Web_ProductReview ADD CONSTRAINT DF_Tmp_Web_ProductReview_IP DEFAULT ('') FOR [IP]
 
ALTER TABLE dbo.Tmp_Web_ProductReview ADD CONSTRAINT DF_Tmp_Web_ProductReview_Remark DEFAULT ('') FOR [Remark]
 
ALTER TABLE dbo.Tmp_Web_ProductReview ADD CONSTRAINT DF_Tmp_Web_ProductReview_RemarkDate DEFAULT (getdate()) FOR [RemarkDate]
 
ALTER TABLE dbo.Tmp_Web_ProductReview ADD CONSTRAINT DF_Tmp_Web_ProductReview_IsRemark DEFAULT ((0)) FOR [IsRemark]
 
ALTER TABLE dbo.Tmp_Web_ProductReview ADD CONSTRAINT DF_Tmp_Web_ProductReview_IsPass DEFAULT ((0)) FOR [IsPass]
 
ALTER TABLE dbo.Tmp_Web_ProductReview ADD CONSTRAINT DF_Tmp_Web_ProductReview_IsDel DEFAULT ((0)) FOR [IsDel]
 
ALTER TABLE dbo.Tmp_Web_ProductReview ADD CONSTRAINT DF_Tmp_Web_ProductReview_ReviewTo DEFAULT ((0)) FOR [ReviewTo]
 
SET IDENTITY_INSERT dbo.Tmp_Web_ProductReview ON
 
IF EXISTS(SELECT * FROM dbo.Web_ProductReview) EXEC('INSERT INTO dbo.Tmp_Web_ProductReview ([ID],[ProductID],[Date],[UserName],[Star],[Title],[Content],[IP],[Remark],[RemarkDate],[IsRemark],[IsPass],[IsDel],[ReviewTo]) SELECT [ID],[ProductID],[Date],[UserName],[Star],[Title],[Content],[IP],[Remark],[RemarkDate],[IsRemark],[IsPass],[IsDel],[ReviewTo] FROM dbo.Web_ProductReview WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_ProductReview OFF
 
DROP TABLE dbo.Web_ProductReview
 
EXECUTE sp_rename N'dbo.Tmp_Web_ProductReview', N'Web_ProductReview', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_UserCoupon]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_UserCoupon] 
 
CREATE TABLE dbo.Web_UserCoupon([Id] [int]  NOT NULL,[CouponID] [int]  NOT NULL,[UserName] [nvarchar] (50)  NOT NULL,[Number] [nvarchar] (50)  NOT NULL,[IsUsed] [int]  NOT NULL,[OrderNumber] [nvarchar] (50)  NOT NULL,[Date] [datetime]  NOT NULL,[IsActive] [int]  NOT NULL,[IsDistribution] [int]  NOT NULL,[IsDel] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_UserCoupon ADD CONSTRAINT DF_Web_UserCoupon_CouponID DEFAULT ((0)) FOR [CouponID]
 
ALTER TABLE dbo.Web_UserCoupon ADD CONSTRAINT DF_Web_UserCoupon_UserName DEFAULT ('') FOR [UserName]
 
ALTER TABLE dbo.Web_UserCoupon ADD CONSTRAINT DF_Web_UserCoupon_Number DEFAULT (substring(CONVERT([nvarchar](100),newid(),(0)),(5),(19))) FOR [Number]
 
ALTER TABLE dbo.Web_UserCoupon ADD CONSTRAINT DF_Web_UserCoupon_IsUsed DEFAULT ((0)) FOR [IsUsed]
 
ALTER TABLE dbo.Web_UserCoupon ADD CONSTRAINT DF_Web_UserCoupon_OrderNumber DEFAULT ('') FOR [OrderNumber]
 
ALTER TABLE dbo.Web_UserCoupon ADD CONSTRAINT DF_Web_UserCoupon_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Web_UserCoupon ADD CONSTRAINT DF_Web_UserCoupon_IsActive DEFAULT ((0)) FOR [IsActive]
 
ALTER TABLE dbo.Web_UserCoupon ADD CONSTRAINT DF_Web_UserCoupon_IsDistribution DEFAULT ((0)) FOR [IsDistribution]
 
ALTER TABLE dbo.Web_UserCoupon ADD CONSTRAINT DF_Web_UserCoupon_IsDel DEFAULT ((0)) FOR [IsDel]
 
CREATE TABLE dbo.Tmp_Web_UserCoupon([Id] [int]  NOT NULL IDENTITY (1, 1),[CouponID] [int]  NOT NULL,[UserName] [nvarchar] (50)  NOT NULL,[Number] [nvarchar] (50)  NOT NULL,[IsUsed] [int]  NOT NULL,[OrderNumber] [nvarchar] (50)  NOT NULL,[Date] [datetime]  NOT NULL,[IsActive] [int]  NOT NULL,[IsDistribution] [int]  NOT NULL,[IsDel] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_UserCoupon ADD CONSTRAINT DF_Tmp_Web_UserCoupon_CouponID DEFAULT ((0)) FOR [CouponID]
 
ALTER TABLE dbo.Tmp_Web_UserCoupon ADD CONSTRAINT DF_Tmp_Web_UserCoupon_UserName DEFAULT ('') FOR [UserName]
 
ALTER TABLE dbo.Tmp_Web_UserCoupon ADD CONSTRAINT DF_Tmp_Web_UserCoupon_Number DEFAULT (substring(CONVERT([nvarchar](100),newid(),(0)),(5),(19))) FOR [Number]
 
ALTER TABLE dbo.Tmp_Web_UserCoupon ADD CONSTRAINT DF_Tmp_Web_UserCoupon_IsUsed DEFAULT ((0)) FOR [IsUsed]
 
ALTER TABLE dbo.Tmp_Web_UserCoupon ADD CONSTRAINT DF_Tmp_Web_UserCoupon_OrderNumber DEFAULT ('') FOR [OrderNumber]
 
ALTER TABLE dbo.Tmp_Web_UserCoupon ADD CONSTRAINT DF_Tmp_Web_UserCoupon_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Tmp_Web_UserCoupon ADD CONSTRAINT DF_Tmp_Web_UserCoupon_IsActive DEFAULT ((0)) FOR [IsActive]
 
ALTER TABLE dbo.Tmp_Web_UserCoupon ADD CONSTRAINT DF_Tmp_Web_UserCoupon_IsDistribution DEFAULT ((0)) FOR [IsDistribution]
 
ALTER TABLE dbo.Tmp_Web_UserCoupon ADD CONSTRAINT DF_Tmp_Web_UserCoupon_IsDel DEFAULT ((0)) FOR [IsDel]
 
SET IDENTITY_INSERT dbo.Tmp_Web_UserCoupon ON
 
IF EXISTS(SELECT * FROM dbo.Web_UserCoupon) EXEC('INSERT INTO dbo.Tmp_Web_UserCoupon ([Id],[CouponID],[UserName],[Number],[IsUsed],[OrderNumber],[Date],[IsActive],[IsDistribution],[IsDel]) SELECT [Id],[CouponID],[UserName],[Number],[IsUsed],[OrderNumber],[Date],[IsActive],[IsDistribution],[IsDel] FROM dbo.Web_UserCoupon WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_UserCoupon OFF
 
DROP TABLE dbo.Web_UserCoupon
 
EXECUTE sp_rename N'dbo.Tmp_Web_UserCoupon', N'Web_UserCoupon', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Cart]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Cart] 
 
CREATE TABLE dbo.Web_Cart([ID] [int]  NOT NULL,[GUID] [uniqueidentifier]  NOT NULL,[UserName] [nvarchar] (100)  NOT NULL,[ProductID] [int]  NOT NULL,[CategoryID] [int]  NOT NULL,[Number] [nvarchar] (50)  NULL,[Count] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[Name] [nvarchar] (200)  NULL,[MarketPrice] [decimal]  (18,2) NOT NULL,[MemberPrice] [decimal]  (18,2) NOT NULL,[OrderPrice] [decimal]  (18,2) NOT NULL,[Score] [int]  NOT NULL,[Weight] [decimal]  (18,3) NOT NULL,[ActivityID] [int]  NOT NULL,[IsChangeSale] [int]  NOT NULL,[WholeSaleID] [int]  NOT NULL,[UseScore] [int]  NOT NULL,[PropertysText] [nvarchar] (2000)  NULL,[PropertysID] [nvarchar] (250)  NULL,[IsEntity] [int]  NOT NULL,[GroupBuyID] [int]  NOT NULL,[SnatchID] [int]  NOT NULL,[Src] [nvarchar] (250)  NULL,[IsFitting] [int]  NOT NULL,[FittingProductID] [int]  NOT NULL,[IsScore] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Cart ADD CONSTRAINT DF_Web_Cart_ProductID DEFAULT ((0)) FOR [ProductID]
 
ALTER TABLE dbo.Web_Cart ADD CONSTRAINT DF_Web_Cart_CategoryID DEFAULT ((0)) FOR [CategoryID]
 
ALTER TABLE dbo.Web_Cart ADD CONSTRAINT DF_Web_Cart_Count DEFAULT ((0)) FOR [Count]
 
ALTER TABLE dbo.Web_Cart ADD CONSTRAINT DF_Web_Cart_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Web_Cart ADD CONSTRAINT DF_Web_Cart_MarketPrice DEFAULT ((0)) FOR [MarketPrice]
 
ALTER TABLE dbo.Web_Cart ADD CONSTRAINT DF_Web_Cart_MemberPrice DEFAULT ((0)) FOR [MemberPrice]
 
ALTER TABLE dbo.Web_Cart ADD CONSTRAINT DF_Web_Cart_OrderPrice DEFAULT ((0)) FOR [OrderPrice]
 
ALTER TABLE dbo.Web_Cart ADD CONSTRAINT DF_Web_Cart_Score DEFAULT ((0)) FOR [Score]
 
ALTER TABLE dbo.Web_Cart ADD CONSTRAINT DF_Web_Cart_Weight DEFAULT ((0)) FOR [Weight]
 
ALTER TABLE dbo.Web_Cart ADD CONSTRAINT DF_Web_Cart_ActivityID DEFAULT ((0)) FOR [ActivityID]
 
ALTER TABLE dbo.Web_Cart ADD CONSTRAINT DF_Web_Cart_IsChangeSale DEFAULT ((0)) FOR [IsChangeSale]
 
ALTER TABLE dbo.Web_Cart ADD CONSTRAINT DF_Web_Cart_WholeSaleID DEFAULT ((0)) FOR [WholeSaleID]
 
ALTER TABLE dbo.Web_Cart ADD CONSTRAINT DF_Web_Cart_UseScore DEFAULT ((0)) FOR [UseScore]
 
ALTER TABLE dbo.Web_Cart ADD CONSTRAINT DF_Web_Cart_IsEntity DEFAULT ((1)) FOR [IsEntity]
 
ALTER TABLE dbo.Web_Cart ADD CONSTRAINT DF_Web_Cart_GroupBuyID DEFAULT ((0)) FOR [GroupBuyID]
 
ALTER TABLE dbo.Web_Cart ADD CONSTRAINT DF_Web_Cart_SnatchID DEFAULT ((0)) FOR [SnatchID]
 
ALTER TABLE dbo.Web_Cart ADD CONSTRAINT DF_Web_Cart_IsFitting DEFAULT ((0)) FOR [IsFitting]
 
ALTER TABLE dbo.Web_Cart ADD CONSTRAINT DF_Web_Cart_FittingProductID DEFAULT ((0)) FOR [FittingProductID]
 
ALTER TABLE dbo.Web_Cart ADD CONSTRAINT DF_Web_Cart_IsScore DEFAULT ((0)) FOR [IsScore]
 
CREATE TABLE dbo.Tmp_Web_Cart([ID] [int]  NOT NULL IDENTITY (1, 1),[GUID] [uniqueidentifier]  NOT NULL,[UserName] [nvarchar] (100)  NOT NULL,[ProductID] [int]  NOT NULL,[CategoryID] [int]  NOT NULL,[Number] [nvarchar] (50)  NULL,[Count] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[Name] [nvarchar] (200)  NULL,[MarketPrice] [decimal]  (18,2) NOT NULL,[MemberPrice] [decimal]  (18,2) NOT NULL,[OrderPrice] [decimal]  (18,2) NOT NULL,[Score] [int]  NOT NULL,[Weight] [decimal]  (18,3) NOT NULL,[ActivityID] [int]  NOT NULL,[IsChangeSale] [int]  NOT NULL,[WholeSaleID] [int]  NOT NULL,[UseScore] [int]  NOT NULL,[PropertysText] [nvarchar] (2000)  NULL,[PropertysID] [nvarchar] (250)  NULL,[IsEntity] [int]  NOT NULL,[GroupBuyID] [int]  NOT NULL,[SnatchID] [int]  NOT NULL,[Src] [nvarchar] (250)  NULL,[IsFitting] [int]  NOT NULL,[FittingProductID] [int]  NOT NULL,[IsScore] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_Cart ADD CONSTRAINT DF_Tmp_Web_Cart_ProductID DEFAULT ((0)) FOR [ProductID]
 
ALTER TABLE dbo.Tmp_Web_Cart ADD CONSTRAINT DF_Tmp_Web_Cart_CategoryID DEFAULT ((0)) FOR [CategoryID]
 
ALTER TABLE dbo.Tmp_Web_Cart ADD CONSTRAINT DF_Tmp_Web_Cart_Count DEFAULT ((0)) FOR [Count]
 
ALTER TABLE dbo.Tmp_Web_Cart ADD CONSTRAINT DF_Tmp_Web_Cart_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Tmp_Web_Cart ADD CONSTRAINT DF_Tmp_Web_Cart_MarketPrice DEFAULT ((0)) FOR [MarketPrice]
 
ALTER TABLE dbo.Tmp_Web_Cart ADD CONSTRAINT DF_Tmp_Web_Cart_MemberPrice DEFAULT ((0)) FOR [MemberPrice]
 
ALTER TABLE dbo.Tmp_Web_Cart ADD CONSTRAINT DF_Tmp_Web_Cart_OrderPrice DEFAULT ((0)) FOR [OrderPrice]
 
ALTER TABLE dbo.Tmp_Web_Cart ADD CONSTRAINT DF_Tmp_Web_Cart_Score DEFAULT ((0)) FOR [Score]
 
ALTER TABLE dbo.Tmp_Web_Cart ADD CONSTRAINT DF_Tmp_Web_Cart_Weight DEFAULT ((0)) FOR [Weight]
 
ALTER TABLE dbo.Tmp_Web_Cart ADD CONSTRAINT DF_Tmp_Web_Cart_ActivityID DEFAULT ((0)) FOR [ActivityID]
 
ALTER TABLE dbo.Tmp_Web_Cart ADD CONSTRAINT DF_Tmp_Web_Cart_IsChangeSale DEFAULT ((0)) FOR [IsChangeSale]
 
ALTER TABLE dbo.Tmp_Web_Cart ADD CONSTRAINT DF_Tmp_Web_Cart_WholeSaleID DEFAULT ((0)) FOR [WholeSaleID]
 
ALTER TABLE dbo.Tmp_Web_Cart ADD CONSTRAINT DF_Tmp_Web_Cart_UseScore DEFAULT ((0)) FOR [UseScore]
 
ALTER TABLE dbo.Tmp_Web_Cart ADD CONSTRAINT DF_Tmp_Web_Cart_IsEntity DEFAULT ((1)) FOR [IsEntity]
 
ALTER TABLE dbo.Tmp_Web_Cart ADD CONSTRAINT DF_Tmp_Web_Cart_GroupBuyID DEFAULT ((0)) FOR [GroupBuyID]
 
ALTER TABLE dbo.Tmp_Web_Cart ADD CONSTRAINT DF_Tmp_Web_Cart_SnatchID DEFAULT ((0)) FOR [SnatchID]
 
ALTER TABLE dbo.Tmp_Web_Cart ADD CONSTRAINT DF_Tmp_Web_Cart_IsFitting DEFAULT ((0)) FOR [IsFitting]
 
ALTER TABLE dbo.Tmp_Web_Cart ADD CONSTRAINT DF_Tmp_Web_Cart_FittingProductID DEFAULT ((0)) FOR [FittingProductID]
 
ALTER TABLE dbo.Tmp_Web_Cart ADD CONSTRAINT DF_Tmp_Web_Cart_IsScore DEFAULT ((0)) FOR [IsScore]
 
SET IDENTITY_INSERT dbo.Tmp_Web_Cart ON
 
IF EXISTS(SELECT * FROM dbo.Web_Cart) EXEC('INSERT INTO dbo.Tmp_Web_Cart ([ID],[GUID],[UserName],[ProductID],[CategoryID],[Number],[Count],[Date],[Name],[MarketPrice],[MemberPrice],[OrderPrice],[Score],[Weight],[ActivityID],[IsChangeSale],[WholeSaleID],[UseScore],[PropertysText],[PropertysID],[IsEntity],[GroupBuyID],[SnatchID],[Src],[IsFitting],[FittingProductID],[IsScore]) SELECT [ID],[GUID],[UserName],[ProductID],[CategoryID],[Number],[Count],[Date],[Name],[MarketPrice],[MemberPrice],[OrderPrice],[Score],[Weight],[ActivityID],[IsChangeSale],[WholeSaleID],[UseScore],[PropertysText],[PropertysID],[IsEntity],[GroupBuyID],[SnatchID],[Src],[IsFitting],[FittingProductID],[IsScore] FROM dbo.Web_Cart WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Cart OFF
 
DROP TABLE dbo.Web_Cart
 
EXECUTE sp_rename N'dbo.Tmp_Web_Cart', N'Web_Cart', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_ProductValuePlus]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_ProductValuePlus] 
 
CREATE TABLE dbo.Web_ProductValuePlus([ProductID] [int]  NOT NULL,[PropertyID] [int]  NOT NULL,[Value] [nvarchar] (50)  NOT NULL)  ON [PRIMARY] 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_HelpCategory]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_HelpCategory] 
 
CREATE TABLE dbo.Web_HelpCategory([ID] [int]  NOT NULL,[Name] [nvarchar] (50)  NULL,[OrderID] [int]  NOT NULL,[Level] [int]  NOT NULL,[HeadID] [int]  NOT NULL,[Family] [nvarchar] (250)  NULL,[Template] [nvarchar] (50)  NULL,[SearchKey] [nvarchar] (50)  NULL,[Description] [nvarchar] (100)  NULL,[SeoTitle] [nvarchar] (150)  NULL,[SeoKeywords] [nvarchar] (150)  NULL,[SeoDescription] [nvarchar] (300)  NULL)  ON [PRIMARY] 
 
INSERT INTO Web_HelpCategory VALUES ('1','公司信息','1','0','0','0','',NULL,NULL,NULL,'公司信息','公司信息')
 
INSERT INTO Web_HelpCategory VALUES ('2','客户服务','2','0','0','0','',NULL,NULL,NULL,'客户服务','客户服务')
 
INSERT INTO Web_HelpCategory VALUES ('3','服务保证','3','0','0','0','',NULL,NULL,NULL,'服务保证','服务保证')
 
INSERT INTO Web_HelpCategory VALUES ('4','付款方式','4','0','0','0','',NULL,NULL,NULL,'付款方式','付款方式')
 
INSERT INTO Web_HelpCategory VALUES ('5','配送方式','5','0','0','0','',NULL,NULL,NULL,'配送方式','配送方式')
 
INSERT INTO Web_HelpCategory VALUES ('6','购买方式','6','0','0','0','',NULL,NULL,NULL,'购买方式','购买方式')
 
CREATE TABLE dbo.Tmp_Web_HelpCategory([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NULL,[OrderID] [int]  NOT NULL,[Level] [int]  NOT NULL,[HeadID] [int]  NOT NULL,[Family] [nvarchar] (250)  NULL,[Template] [nvarchar] (50)  NULL,[SearchKey] [nvarchar] (50)  NULL,[Description] [nvarchar] (100)  NULL,[SeoTitle] [nvarchar] (150)  NULL,[SeoKeywords] [nvarchar] (150)  NULL,[SeoDescription] [nvarchar] (300)  NULL)  ON [PRIMARY] 
 
SET IDENTITY_INSERT dbo.Tmp_Web_HelpCategory ON
 
IF EXISTS(SELECT * FROM dbo.Web_HelpCategory) EXEC('INSERT INTO dbo.Tmp_Web_HelpCategory ([ID],[Name],[OrderID],[Level],[HeadID],[Family],[Template],[SearchKey],[Description],[SeoTitle],[SeoKeywords],[SeoDescription]) SELECT [ID],[Name],[OrderID],[Level],[HeadID],[Family],[Template],[SearchKey],[Description],[SeoTitle],[SeoKeywords],[SeoDescription] FROM dbo.Web_HelpCategory WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_HelpCategory OFF
 
DROP TABLE dbo.Web_HelpCategory
 
EXECUTE sp_rename N'dbo.Tmp_Web_HelpCategory', N'Web_HelpCategory', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_PictureCategory]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_PictureCategory] 
 
CREATE TABLE dbo.Web_PictureCategory([ID] [int]  NOT NULL,[Name] [nvarchar] (20)  NULL,[OrderID] [int]  NOT NULL,[Level] [int]  NOT NULL,[HeadID] [int]  NOT NULL,[Family] [nvarchar] (250)  NULL,[Description] [nvarchar] (100)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_PictureCategory ADD CONSTRAINT DF_Web_PictureCategory_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Web_PictureCategory ADD CONSTRAINT DF_Web_PictureCategory_Level DEFAULT ((0)) FOR [Level]
 
ALTER TABLE dbo.Web_PictureCategory ADD CONSTRAINT DF_Web_PictureCategory_HeadID DEFAULT ((0)) FOR [HeadID]
 
CREATE TABLE dbo.Tmp_Web_PictureCategory([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (20)  NULL,[OrderID] [int]  NOT NULL,[Level] [int]  NOT NULL,[HeadID] [int]  NOT NULL,[Family] [nvarchar] (250)  NULL,[Description] [nvarchar] (100)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_PictureCategory ADD CONSTRAINT DF_Tmp_Web_PictureCategory_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Tmp_Web_PictureCategory ADD CONSTRAINT DF_Tmp_Web_PictureCategory_Level DEFAULT ((0)) FOR [Level]
 
ALTER TABLE dbo.Tmp_Web_PictureCategory ADD CONSTRAINT DF_Tmp_Web_PictureCategory_HeadID DEFAULT ((0)) FOR [HeadID]
 
SET IDENTITY_INSERT dbo.Tmp_Web_PictureCategory ON
 
IF EXISTS(SELECT * FROM dbo.Web_PictureCategory) EXEC('INSERT INTO dbo.Tmp_Web_PictureCategory ([ID],[Name],[OrderID],[Level],[HeadID],[Family],[Description]) SELECT [ID],[Name],[OrderID],[Level],[HeadID],[Family],[Description] FROM dbo.Web_PictureCategory WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_PictureCategory OFF
 
DROP TABLE dbo.Web_PictureCategory
 
EXECUTE sp_rename N'dbo.Tmp_Web_PictureCategory', N'Web_PictureCategory', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_UserScoreLog]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_UserScoreLog] 
 
CREATE TABLE dbo.Web_UserScoreLog([Id] [int]  NOT NULL,[UserName] [nvarchar] (50)  NOT NULL,[IsOut] [int]  NOT NULL,[OldScore] [int]  NOT NULL,[Sum] [int]  NOT NULL,[OperateType] [nvarchar] (50)  NOT NULL,[Description] [nvarchar] (100)  NOT NULL,[Date] [datetime]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_UserScoreLog ADD CONSTRAINT DF_Web_UserScoreLog_IsOut DEFAULT ((0)) FOR [IsOut]
 
ALTER TABLE dbo.Web_UserScoreLog ADD CONSTRAINT DF_Web_UserScoreLog_OldScore DEFAULT ((0)) FOR [OldScore]
 
ALTER TABLE dbo.Web_UserScoreLog ADD CONSTRAINT DF_Web_UserScoreLog_OperateType DEFAULT ('') FOR [OperateType]
 
ALTER TABLE dbo.Web_UserScoreLog ADD CONSTRAINT DF_Web_UserScoreLog_Description DEFAULT ('') FOR [Description]
 
ALTER TABLE dbo.Web_UserScoreLog ADD CONSTRAINT DF_Web_UserScoreLog_Date DEFAULT (getdate()) FOR [Date]
 
CREATE TABLE dbo.Tmp_Web_UserScoreLog([Id] [int]  NOT NULL IDENTITY (1, 1),[UserName] [nvarchar] (50)  NOT NULL,[IsOut] [int]  NOT NULL,[OldScore] [int]  NOT NULL,[Sum] [int]  NOT NULL,[OperateType] [nvarchar] (50)  NOT NULL,[Description] [nvarchar] (100)  NOT NULL,[Date] [datetime]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_UserScoreLog ADD CONSTRAINT DF_Tmp_Web_UserScoreLog_IsOut DEFAULT ((0)) FOR [IsOut]
 
ALTER TABLE dbo.Tmp_Web_UserScoreLog ADD CONSTRAINT DF_Tmp_Web_UserScoreLog_OldScore DEFAULT ((0)) FOR [OldScore]
 
ALTER TABLE dbo.Tmp_Web_UserScoreLog ADD CONSTRAINT DF_Tmp_Web_UserScoreLog_OperateType DEFAULT ('') FOR [OperateType]
 
ALTER TABLE dbo.Tmp_Web_UserScoreLog ADD CONSTRAINT DF_Tmp_Web_UserScoreLog_Description DEFAULT ('') FOR [Description]
 
ALTER TABLE dbo.Tmp_Web_UserScoreLog ADD CONSTRAINT DF_Tmp_Web_UserScoreLog_Date DEFAULT (getdate()) FOR [Date]
 
SET IDENTITY_INSERT dbo.Tmp_Web_UserScoreLog ON
 
IF EXISTS(SELECT * FROM dbo.Web_UserScoreLog) EXEC('INSERT INTO dbo.Tmp_Web_UserScoreLog ([Id],[UserName],[IsOut],[OldScore],[Sum],[OperateType],[Description],[Date]) SELECT [Id],[UserName],[IsOut],[OldScore],[Sum],[OperateType],[Description],[Date] FROM dbo.Web_UserScoreLog WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_UserScoreLog OFF
 
DROP TABLE dbo.Web_UserScoreLog
 
EXECUTE sp_rename N'dbo.Tmp_Web_UserScoreLog', N'Web_UserScoreLog', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_FrozenLog]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_FrozenLog] 
 
CREATE TABLE dbo.Web_FrozenLog([Id] [int]  NOT NULL,[UserName] [nvarchar] (50)  NOT NULL,[FrozenDeposit] [decimal]  (18,3) NOT NULL,[Score] [int]  NULL,[FrozenScore] [int]  NULL,[Price] [decimal]  (18,3) NOT NULL,[Date] [datetime]  NOT NULL,[Causation] [nvarchar] (250)  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_FrozenLog ADD CONSTRAINT DF_Web_FrozenLog_FrozenDeposit DEFAULT ((0)) FOR [FrozenDeposit]
 
ALTER TABLE dbo.Web_FrozenLog ADD CONSTRAINT DF_Web_FrozenLog_Score DEFAULT ((0)) FOR [Score]
 
ALTER TABLE dbo.Web_FrozenLog ADD CONSTRAINT DF_Web_FrozenLog_FrozenScore DEFAULT ((0)) FOR [FrozenScore]
 
ALTER TABLE dbo.Web_FrozenLog ADD CONSTRAINT DF_Web_FrozenLog_Price DEFAULT ((0)) FOR [Price]
 
ALTER TABLE dbo.Web_FrozenLog ADD CONSTRAINT DF_Web_FrozenLog_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Web_FrozenLog ADD CONSTRAINT DF_Web_FrozenLog_Causation DEFAULT ((0)) FOR [Causation]
 
CREATE TABLE dbo.Tmp_Web_FrozenLog([Id] [int]  NOT NULL IDENTITY (1, 1),[UserName] [nvarchar] (50)  NOT NULL,[FrozenDeposit] [decimal]  (18,3) NOT NULL,[Score] [int]  NULL,[FrozenScore] [int]  NULL,[Price] [decimal]  (18,3) NOT NULL,[Date] [datetime]  NOT NULL,[Causation] [nvarchar] (250)  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_FrozenLog ADD CONSTRAINT DF_Tmp_Web_FrozenLog_FrozenDeposit DEFAULT ((0)) FOR [FrozenDeposit]
 
ALTER TABLE dbo.Tmp_Web_FrozenLog ADD CONSTRAINT DF_Tmp_Web_FrozenLog_Score DEFAULT ((0)) FOR [Score]
 
ALTER TABLE dbo.Tmp_Web_FrozenLog ADD CONSTRAINT DF_Tmp_Web_FrozenLog_FrozenScore DEFAULT ((0)) FOR [FrozenScore]
 
ALTER TABLE dbo.Tmp_Web_FrozenLog ADD CONSTRAINT DF_Tmp_Web_FrozenLog_Price DEFAULT ((0)) FOR [Price]
 
ALTER TABLE dbo.Tmp_Web_FrozenLog ADD CONSTRAINT DF_Tmp_Web_FrozenLog_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Tmp_Web_FrozenLog ADD CONSTRAINT DF_Tmp_Web_FrozenLog_Causation DEFAULT ((0)) FOR [Causation]
 
SET IDENTITY_INSERT dbo.Tmp_Web_FrozenLog ON
 
IF EXISTS(SELECT * FROM dbo.Web_FrozenLog) EXEC('INSERT INTO dbo.Tmp_Web_FrozenLog ([Id],[UserName],[FrozenDeposit],[Score],[FrozenScore],[Price],[Date],[Causation]) SELECT [Id],[UserName],[FrozenDeposit],[Score],[FrozenScore],[Price],[Date],[Causation] FROM dbo.Web_FrozenLog WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_FrozenLog OFF
 
DROP TABLE dbo.Web_FrozenLog
 
EXECUTE sp_rename N'dbo.Tmp_Web_FrozenLog', N'Web_FrozenLog', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_AdminLog]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_AdminLog] 
 
CREATE TABLE dbo.Web_AdminLog([ID] [int]  NOT NULL,[Record] [nvarchar] (150)  NULL,[Date] [datetime]  NOT NULL,[AdminID] [int]  NOT NULL,[Type] [nvarchar] (50)  NULL,[IP] [nvarchar] (50)  NULL,[Page] [nvarchar] (150)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_AdminLog ADD CONSTRAINT DF_Web_AdminLog_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Web_AdminLog ADD CONSTRAINT DF_Web_AdminLog_AdminID DEFAULT ((0)) FOR [AdminID]
 
INSERT INTO Web_AdminLog VALUES ('49','Edit_Tool_Page_Manage:ID={92}','2008-8-27 18:22:10','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('50','Login_login:LoginID = {admin}','2008-8-27 20:21:37','0','Login','192.168.1.241','login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('51','Edit_Tool_PagePower_Manage:Role ID={1}, ','2008-8-27 20:22:44','0','Edit','192.168.1.241','Tool_PagePower_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('52','Login_login:LoginID = {admin}','2008-8-28 10:17:22','0','Login','192.168.1.241','login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('53','Login_Login:LoginID = {admin}','2008-8-28 10:23:52','0','Login','192.168.1.186','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('54','Edit_Tool_Page_Manage:ID={38}','2008-8-28 10:56:02','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('55','Edit_Tool_Page_Manage:ID={39}','2008-8-28 10:56:26','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('56','Edit_Tool_Page_Manage:ID={44}','2008-8-28 10:56:46','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('57','Edit_Tool_Page_Manage:ID={49}','2008-8-28 10:57:20','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('58','Edit_Tool_Page_Manage:ID={51}','2008-8-28 10:57:34','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('59','Edit_Tool_Page_Manage:ID={212}','2008-8-28 10:57:48','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('60','Edit_Tool_Page_Manage:ID={53}','2008-8-28 10:58:00','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('61','Edit_Tool_Page_Manage:ID={90}','2008-8-28 10:58:14','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('62','Edit_Tool_Page_Manage:ID={91}','2008-8-28 10:58:26','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('63','Edit_Tool_Page_Manage:ID={83}','2008-8-28 11:04:28','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('64','Edit_Tool_Page_Manage:ID={85}','2008-8-28 11:04:40','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('65','Edit_Tool_Page_Manage:ID={87}','2008-8-28 11:04:51','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('66','Edit_Tool_Page_Manage:ID={89}','2008-8-28 11:05:01','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('67','Edit_Tool_Page_Manage:ID={92}','2008-8-28 11:05:25','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('68','Edit_Tool_Page_Manage:ID={93}','2008-8-28 11:05:53','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('69','Edit_Tool_Page_Manage:ID={94}','2008-8-28 11:06:06','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('70','Edit_Tool_Page_Manage:ID={70}','2008-8-28 11:08:47','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('71','Edit_Tool_Page_Manage:ID={73}','2008-8-28 11:08:58','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('72','Edit_Tool_Page_Manage:ID={76}','2008-8-28 11:09:10','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('73','Edit_Tool_Page_Manage:ID={80}','2008-8-28 11:09:20','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('74','Edit_Tool_Page_Manage:ID={81}','2008-8-28 11:09:32','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('75','Edit_Tool_Page_Manage:ID={74}','2008-8-28 11:09:43','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('76','Edit_Tool_Page_Manage:ID={196}','2008-8-28 11:11:00','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('77','Edit_Tool_Page_Manage:ID={223}','2008-8-28 11:11:10','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('78','Edit_Tool_Page_Manage:ID={229}','2008-8-28 11:11:23','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('79','Edit_Tool_Page_Manage:ID={3}','2008-8-28 12:54:46','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('80','Edit_Tool_Page_Manage:ID={4}','2008-8-28 12:55:07','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('81','Edit_Tool_Page_Manage:ID={16}','2008-8-28 12:55:51','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('82','Edit_Tool_Page_Manage:ID={17}','2008-8-28 12:56:07','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('83','Edit_Tool_Page_Manage:ID={8}','2008-8-28 12:59:15','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('84','Edit_Tool_Page_Manage:ID={9}','2008-8-28 12:59:27','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('85','Edit_Tool_Page_Manage:ID={6}','2008-8-28 13:00:12','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('86','Edit_Tool_Page_Manage:ID={62}','2008-8-28 13:00:52','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('87','Edit_Tool_Page_Manage:ID={60}','2008-8-28 13:07:20','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('88','Edit_Tool_Page_Manage:ID={61}','2008-8-28 13:07:32','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('89','Edit_Tool_Page_Manage:ID={68}','2008-8-28 13:07:42','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('90','Edit_Tool_Page_Manage:ID={58}','2008-8-28 13:09:49','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('91','Edit_Tool_Page_Manage:ID={63}','2008-8-28 13:10:04','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('92','Edit_Tool_Page_Manage:ID={64}','2008-8-28 13:10:19','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('93','Edit_Tool_Page_Manage:ID={231}','2008-8-28 13:11:25','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('94','Edit_Tool_Page_Manage:ID={232}','2008-8-28 13:11:37','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('95','Edit_Tool_Page_Manage:ID={22}','2008-8-28 13:13:49','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('96','Edit_Tool_Page_Manage:ID={23}','2008-8-28 13:13:59','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('97','Edit_Tool_Page_Manage:ID={25}','2008-8-28 13:14:14','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('98','Edit_Tool_Page_Manage:ID={54}','2008-8-28 13:14:28','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('99','Edit_Tool_Page_Manage:ID={235}','2008-8-28 13:14:41','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('100','Edit_Tool_Page_Manage:ID={202}','2008-8-28 13:14:53','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('101','Edit_Tool_Page_Manage:ID={55}','2008-8-28 13:15:03','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('102','Edit_Tool_Page_Manage:ID={56}','2008-8-28 13:15:20','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('103','Edit_Tool_Page_Manage:ID={55}','2008-8-28 13:15:29','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('104','Edit_Tool_Page_Manage:ID={41}','2008-8-28 15:37:34','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('105','Edit_Tool_Page_Manage:ID={46}','2008-8-28 15:37:44','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('106','Edit_Tool_Page_Manage:ID={42}','2008-8-28 15:37:56','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('107','Edit_Tool_Page_Manage:ID={98}','2008-8-28 15:38:06','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('108','Edit_Tool_Page_Manage:ID={43}','2008-8-28 15:38:16','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('109','Edit_Tool_Page_Manage:ID={47}','2008-8-28 15:38:26','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('110','Edit_Tool_Page_Manage:ID={52}','2008-8-28 15:38:35','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('111','Edit_Tool_Page_Manage:ID={48}','2008-8-28 15:38:49','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('112','Edit_Tool_Page_Manage:ID={234}','2008-8-28 15:38:58','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('113','LoginErr_Login:ID={admin} 密码不正确！','2008-8-28 17:18:13','0','LoginErr','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('114','LoginErr_Login:ID={admin} 系统异常， 请与管理员联系！\\n Error ID:0x100001。','2008-8-28 17:18:13','0','LoginErr','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('115','Login_login:LoginID = {admin}','2008-8-28 17:18:22','0','Login','192.168.1.241','login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('116','Edit_Tool_Page_Manage:ID={32}','2008-8-28 19:08:13','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('117','Edit_Tool_Page_Manage:ID={34}','2008-8-28 19:09:21','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('118','Edit_Tool_Page_Manage:ID={34}','2008-8-28 19:13:28','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('119','Login_Login:LoginID = {admin}','2008-8-30 11:39:23','0','Login','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('120','Edit_Tool_Page_Manage:ID={29}','2008-8-30 11:40:42','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('121','Edit_Tool_Page_Manage:ID={45}','2008-8-30 11:41:13','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('122','Add_Tool_Page_Manage.','2008-8-30 20:31:08','0','Add','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('123','Add_Tool_Page_Manage.','2008-8-30 20:31:23','0','Add','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('124','Edit_Tool_PagePower_Manage:Role ID={1}, ','2008-8-30 20:31:52','0','Edit','192.168.1.241','Tool_PagePower_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('125','Login_Login:LoginID = {admin}','2008-9-1 10:00:13','0','Login','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('126','Login_Login:AdminID={admin}','2008-9-1 13:56:38','1','Login','127.0.0.1','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('127','Add_Template_Template_Operate:ID={1}','2008-9-1 14:00:58','0','Add','127.0.0.1','Template_Template_Operate.aspx')
 
INSERT INTO Web_AdminLog VALUES ('128','Logout_Logout:AdminID={}','2008-9-1 14:03:37','0','Logout','127.0.0.1','Logout.apx')
 
INSERT INTO Web_AdminLog VALUES ('129','Login_Login:AdminID={admin}','2008-9-1 14:03:45','1','Login','127.0.0.1','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('130','LoginErr_Login:AdminID={admin}','2008-9-1 14:33:30','0','LoginErr','127.0.0.1','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('131','LoginErr_Login:AdminID={admin}','2008-9-1 14:33:31','0','LoginErr','127.0.0.1','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('132','LoginErr_Login:AdminID={admin}','2008-9-1 14:33:38','0','LoginErr','127.0.0.1','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('133','LoginErr_Login:AdminID={admin}','2008-9-1 14:33:38','0','LoginErr','127.0.0.1','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('134','Login_Login:AdminID={admin}','2008-9-1 14:33:47','1','Login','127.0.0.1','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('135','Login_Login:AdminID={admin}','2008-9-1 14:35:00','1','Login','127.0.0.1','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('136','Login_Login:AdminID={admin}','2008-9-2 10:38:32','1','Login','127.0.0.1','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('137','Logout_Logout:AdminID={}','2008-9-2 10:38:58','0','Logout','127.0.0.1','Logout.apx')
 
INSERT INTO Web_AdminLog VALUES ('138','LoginErr_Login:AdminID={admin}','2008-9-2 10:39:08','0','LoginErr','127.0.0.1','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('139','LoginErr_Login:AdminID={admin}','2008-9-2 10:39:08','0','LoginErr','127.0.0.1','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('140','Login_Login:AdminID={admin}','2008-9-2 10:39:16','1','Login','127.0.0.1','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('141','Login_Login:AdminID={admin}','2008-9-3 16:21:32','1','Login','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('142','Edit_Tool_Page_Manage:ID={47}','2008-9-3 16:29:31','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('143','Edit_Tool_Page_Manage:ID={52}','2008-9-3 16:29:49','0','Edit','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('144','LoginErr_Login:AdminID={admin}','2008-9-3 18:22:48','0','LoginErr','192.168.1.119','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('145','LoginErr_Login:AdminID={admin}','2008-9-3 18:22:49','0','LoginErr','192.168.1.119','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('146','LoginErr_Login:AdminID={admin}','2008-9-3 18:23:00','0','LoginErr','192.168.1.119','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('147','LoginErr_Login:AdminID={admin}','2008-9-3 18:23:00','0','LoginErr','192.168.1.119','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('148','LoginErr_Login:AdminID={123456}','2008-9-3 18:23:12','0','LoginErr','192.168.1.119','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('149','LoginErr_Login:AdminID={123456}','2008-9-3 18:23:12','0','LoginErr','192.168.1.119','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('150','LoginErr_Login:AdminID={admin}','2008-9-3 18:23:24','0','LoginErr','192.168.1.119','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('151','LoginErr_Login:AdminID={admin}','2008-9-3 18:23:24','0','LoginErr','192.168.1.119','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('152','LoginErr_Login:AdminID={123456}','2008-9-3 18:23:39','0','LoginErr','192.168.1.119','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('153','LoginErr_Login:AdminID={123456}','2008-9-3 18:23:39','0','LoginErr','192.168.1.119','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('154','Logout_Logout:AdminID={}','2008-9-3 18:24:06','0','Logout','192.168.1.241','Logout.apx')
 
INSERT INTO Web_AdminLog VALUES ('155','Login_Login:AdminID={admin}','2008-9-3 18:24:13','1','Login','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('156','Login_Login:AdminID={admin}','2008-9-3 18:24:51','1','Login','192.168.1.119','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('157','LoginErr_Login:AdminID={a}','2008-9-5 10:44:32','0','LoginErr','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('158','LoginErr_Login:AdminID={a}','2008-9-5 10:44:32','0','LoginErr','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('159','LoginErr_Login:AdminID={admin}','2008-9-5 10:44:40','0','LoginErr','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('160','LoginErr_Login:AdminID={admin}','2008-9-5 10:44:40','0','LoginErr','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('161','Login_Login:AdminID={admin}','2008-9-5 10:44:49','1','Login','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('162','Add_Other_MenuCategory_Manage:MenuCategoryCode={UserCardOverTime}','2008-9-5 11:11:55','0','Add','192.168.1.241','Other_MenuCategory_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('163','Add_Other_Menu_Manage:ID={58}','2008-9-5 11:13:11','0','Add','192.168.1.241','Other_Menu_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('164','Add_Other_Menu_Manage:ID={59}','2008-9-5 11:14:04','0','Add','192.168.1.241','Other_Menu_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('165','Add_Other_Menu_Manage:ID={60}','2008-9-5 11:14:54','0','Add','192.168.1.241','Other_Menu_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('166','Add_Other_Menu_Manage:ID={61}','2008-9-5 11:16:40','0','Add','192.168.1.241','Other_Menu_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('167','Add_Other_Menu_Manage:ID={62}','2008-9-5 11:17:25','0','Add','192.168.1.241','Other_Menu_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('168','Add_Other_Menu_Manage:ID={63}','2008-9-5 11:17:50','0','Add','192.168.1.241','Other_Menu_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('169','Add_Tool_Page_Manage.','2008-9-10 16:26:13','0','Add','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('170','Add_Tool_Page_Manage.','2008-9-10 16:26:55','0','Add','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('171','Edit_Tool_PagePower_Manage:Role ID={1}, ','2008-9-10 16:28:29','0','Edit','192.168.1.241','Tool_PagePower_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('172','LoginErr_Login:AdminID={admin}','2008-9-17 17:42:02','0','LoginErr','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('173','LoginErr_Login:AdminID={admin}','2008-9-17 17:42:02','0','LoginErr','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('174','Login_Login:AdminID={admin}','2008-9-17 17:42:09','1','Login','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('175','Login_Login:AdminID={admin}','2008-9-22 9:10:41','1','Login','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('176','Add_Tool_Page_Manage.','2008-9-22 9:17:27','0','Add','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('177','Add_Tool_Page_Manage.','2008-9-22 9:18:31','0','Add','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('178','Add_Tool_Page_Manage.','2008-9-22 9:20:09','0','Add','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('179','Add_Tool_Page_Manage.','2008-9-22 9:20:32','0','Add','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('180','Add_Tool_Page_Manage.','2008-9-22 9:20:57','0','Add','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('181','Add_Tool_Page_Manage.','2008-9-22 9:21:17','0','Add','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('182','Add_Tool_Page_Manage.','2008-9-22 9:22:30','0','Add','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('183','Add_Tool_Page_Manage.','2008-9-22 9:22:49','0','Add','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('184','Add_Tool_Page_Manage.','2008-9-22 9:23:23','0','Add','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('185','Edit_Tool_PagePower_Manage:Role ID={1}, ','2008-9-22 9:27:31','0','Edit','192.168.1.241','Tool_PagePower_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('186','Add_Tool_Page_Manage.','2008-9-22 9:31:24','0','Add','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('187','Add_Tool_Page_Manage.','2008-9-22 9:32:48','0','Add','192.168.1.241','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('188','Edit_Tool_PagePower_Manage:Role ID={1}, ','2008-9-22 9:33:43','0','Edit','192.168.1.241','Tool_PagePower_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('189','Add_Other_MenuCategory_Manage:MenuCategoryCode={SiteMode}','2008-9-22 9:40:38','0','Add','192.168.1.241','Other_MenuCategory_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('190','Add_Other_Menu_Manage:ID={64}','2008-9-22 9:41:16','0','Add','192.168.1.241','Other_Menu_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('191','Add_Other_Menu_Manage:ID={65}','2008-9-22 9:41:38','0','Add','192.168.1.241','Other_Menu_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('192','Add_Other_Menu_Manage:ID={66}','2008-9-22 9:41:58','0','Add','192.168.1.241','Other_Menu_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('193','LoginErr_Login:AdminID={admin}','2008-9-23 10:08:08','0','LoginErr','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('194','LoginErr_Login:AdminID={admin}','2008-9-23 10:08:08','0','LoginErr','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('195','Login_Login:AdminID={admin}','2008-9-23 10:08:16','1','Login','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('196','Edit_Other_Menu_Manage:ID={13}','2008-9-23 10:09:54','0','Edit','192.168.1.241','Other_Menu_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('197','Disp_Other_Menu_Manage:ID={13}','2008-9-23 10:10:01','0','Disp','192.168.1.241','Other_Menu_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('198','Login_Login:AdminID={admin}','2008-9-23 10:10:49','1','Login','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('199','Login_Login:AdminID={admin}','2008-9-23 14:07:44','1','Login','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('200','Login_Login:AdminID={admin}','2008-9-23 14:16:11','1','Login','192.168.1.102','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('201','Edit_Tool_PageHelp_Manage:PageID={1}','2008-9-23 14:20:21','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('202','Edit_Tool_PageHelp_Manage:PageID={11}','2008-9-23 14:29:40','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('203','Edit_Tool_PageHelp_Manage:PageID={214}','2008-9-23 14:31:40','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('204','Edit_Tool_PageHelp_Manage:PageID={12}','2008-9-23 14:34:42','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('205','Edit_Tool_PageHelp_Manage:PageID={19}','2008-9-23 14:35:52','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('206','Edit_Tool_PageHelp_Manage:PageID={219}','2008-9-23 14:37:16','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('207','Edit_Tool_PageHelp_Manage:PageID={14}','2008-9-23 14:40:36','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('208','Edit_Tool_PageHelp_Manage:PageID={18}','2008-9-23 14:43:21','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('209','Edit_Tool_PageHelp_Manage:PageID={20}','2008-9-23 14:47:34','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('210','Edit_Tool_PageHelp_Manage:PageID={24}','2008-9-23 14:55:19','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('211','Edit_Tool_PageHelp_Manage:PageID={201}','2008-9-23 14:57:24','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('212','Login_Login:AdminID={admin}','2008-9-23 15:04:12','1','Login','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('213','Edit_Tool_PageHelp_Manage:PageID={253}','2008-9-23 15:07:38','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('214','Edit_Tool_PageHelp_Manage:PageID={78}','2008-9-23 15:09:44','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('215','Edit_Tool_PageHelp_Manage:PageID={71}','2008-9-23 15:14:04','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('216','Edit_Tool_PageHelp_Manage:PageID={67}','2008-9-23 15:19:40','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('217','Edit_Tool_PageHelp_Manage:PageID={75}','2008-9-23 15:23:56','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('218','Edit_Tool_PageHelp_Manage:PageID={77}','2008-9-23 15:26:05','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('219','Login_Login:AdminID={admin}','2008-9-23 15:28:57','1','Login','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('220','Edit_Tool_PageHelp_Manage:PageID={97}','2008-9-23 15:29:53','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('221','Edit_Tool_PageHelp_Manage:PageID={178}','2008-9-23 15:45:35','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('222','Edit_Tool_PageHelp_Manage:PageID={179}','2008-9-23 15:48:43','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('223','Edit_Tool_PageHelp_Manage:PageID={175}','2008-9-23 15:51:36','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('224','Edit_Tool_PageHelp_Manage:PageID={180}','2008-9-23 15:54:43','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('225','Edit_Tool_PageHelp_Manage:PageID={183}','2008-9-23 15:57:57','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('226','Edit_Tool_PageHelp_Manage:PageID={186}','2008-9-23 16:00:24','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('227','Edit_Tool_PageHelp_Manage:PageID={188}','2008-9-23 16:01:36','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('228','Edit_Tool_PageHelp_Manage:PageID={197}','2008-9-23 16:02:56','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('229','Edit_Tool_PageHelp_Manage:PageID={70}','2008-9-23 16:10:34','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('230','Edit_Tool_PageHelp_Manage:PageID={73}','2008-9-23 16:17:33','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('231','Edit_Tool_PageHelp_Manage:PageID={76}','2008-9-23 16:25:34','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('232','Edit_Tool_PageHelp_Manage:PageID={80}','2008-9-23 16:28:40','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('233','Edit_Tool_PageHelp_Manage:PageID={81}','2008-9-23 16:34:02','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('234','Edit_Tool_PageHelp_Manage:PageID={74}','2008-9-23 16:36:54','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('235','Edit_Tool_PageHelp_Manage:PageID={196}','2008-9-23 16:42:38','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('236','Edit_Tool_PageHelp_Manage:PageID={223}','2008-9-23 16:45:04','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('237','Edit_Tool_PageHelp_Manage:PageID={229}','2008-9-23 16:47:07','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('238','Edit_Tool_PageHelp_Manage:PageID={83}','2008-9-23 16:52:47','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('239','Edit_Tool_PageHelp_Manage:PageID={85}','2008-9-23 16:54:42','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('240','Edit_Tool_PageHelp_Manage:PageID={87}','2008-9-23 16:56:47','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('241','Edit_Tool_PageHelp_Manage:PageID={89}','2008-9-23 16:58:46','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('242','Edit_Tool_PageHelp_Manage:PageID={92}','2008-9-23 17:01:27','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('243','Edit_Tool_PageHelp_Manage:PageID={93}','2008-9-23 17:03:14','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('244','Edit_Tool_PageHelp_Manage:PageID={94}','2008-9-23 17:06:55','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('245','Edit_Tool_PageHelp_Manage:PageID={3}','2008-9-23 17:09:42','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('246','Edit_Tool_PageHelp_Manage:PageID={4}','2008-9-23 17:11:13','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('247','Edit_Tool_PageHelp_Manage:PageID={16}','2008-9-23 17:13:12','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('248','Edit_Tool_PageHelp_Manage:PageID={17}','2008-9-23 17:20:30','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('249','Edit_Tool_PageHelp_Manage:PageID={8}','2008-9-23 17:22:51','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('250','Edit_Tool_PageHelp_Manage:PageID={9}','2008-9-23 17:24:39','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('251','Edit_Tool_PageHelp_Manage:PageID={6}','2008-9-23 17:26:58','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('252','Edit_Tool_PageHelp_Manage:PageID={60}','2008-9-23 17:29:24','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('253','Edit_Tool_PageHelp_Manage:PageID={61}','2008-9-23 17:31:05','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('254','Edit_Tool_PageHelp_Manage:PageID={68}','2008-9-23 17:33:07','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('255','Edit_Tool_PageHelp_Manage:PageID={38}','2008-9-23 17:35:16','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('256','Edit_Tool_PageHelp_Manage:PageID={39}','2008-9-23 17:36:58','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('257','Edit_Tool_PageHelp_Manage:PageID={44}','2008-9-23 17:39:02','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('258','Edit_Tool_PageHelp_Manage:PageID={49}','2008-9-23 17:40:45','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('259','Edit_Tool_PageHelp_Manage:PageID={51}','2008-9-23 17:43:17','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('260','Edit_Tool_PageHelp_Manage:PageID={212}','2008-9-23 17:46:09','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('261','Edit_Tool_PageHelp_Manage:PageID={53}','2008-9-23 17:48:18','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('262','Edit_Tool_PageHelp_Manage:PageID={90}','2008-9-23 17:50:44','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('263','Edit_Tool_PageHelp_Manage:PageID={91}','2008-9-23 17:52:35','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('264','Edit_Tool_PageHelp_Manage:PageID={58}','2008-9-23 17:56:49','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('265','Edit_Tool_PageHelp_Manage:PageID={63}','2008-9-23 17:57:25','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('266','Edit_Tool_PageHelp_Manage:PageID={64}','2008-9-23 17:57:37','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('267','Edit_Tool_PageHelp_Manage:PageID={27}','2008-9-23 18:00:58','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('268','Edit_Tool_PageHelp_Manage:PageID={33}','2008-9-23 18:03:40','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('269','Edit_Tool_PageHelp_Manage:PageID={34}','2008-9-23 18:05:29','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('270','Edit_Tool_PageHelp_Manage:PageID={36}','2008-9-23 18:08:48','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('271','Edit_Tool_PageHelp_Manage:PageID={32}','2008-9-23 18:10:06','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('272','Edit_Tool_PageHelp_Manage:PageID={29}','2008-9-23 18:11:43','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('273','Edit_Tool_PageHelp_Manage:PageID={30}','2008-9-23 18:13:54','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('274','Edit_Tool_PageHelp_Manage:PageID={35}','2008-9-23 18:16:06','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('275','Edit_Tool_PageHelp_Manage:PageID={45}','2008-9-23 18:17:24','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('276','Edit_Tool_PageHelp_Manage:PageID={181}','2008-9-23 18:18:30','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('277','Edit_Tool_PageHelp_Manage:PageID={50}','2008-9-23 18:20:13','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('278','Edit_Tool_PageHelp_Manage:PageID={28}','2008-9-23 18:21:56','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('279','Login_Login:AdminID={admin}','2008-9-24 8:52:59','1','Login','192.168.1.102','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('280','Edit_Tool_PageHelp_Manage:PageID={22}','2008-9-24 8:59:42','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('281','Edit_Tool_PageHelp_Manage:PageID={23}','2008-9-24 9:01:27','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('282','Edit_Tool_PageHelp_Manage:PageID={25}','2008-9-24 9:03:19','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('283','Edit_Tool_PageHelp_Manage:PageID={54}','2008-9-24 9:05:34','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('284','Edit_Tool_PageHelp_Manage:PageID={202}','2008-9-24 9:07:08','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('285','Edit_Tool_PageHelp_Manage:PageID={56}','2008-9-24 9:09:20','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('286','Edit_Tool_PageHelp_Manage:PageID={55}','2008-9-24 9:11:09','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('287','Edit_Tool_PageHelp_Manage:PageID={66}','2008-9-24 9:16:37','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('288','LoginErr_Login:AdminID={admin}','2008-9-24 9:21:05','0','LoginErr','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('289','LoginErr_Login:AdminID={admin}','2008-9-24 9:21:05','0','LoginErr','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('290','LoginErr_Login:AdminID={admin}','2008-9-24 9:21:13','0','LoginErr','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('291','LoginErr_Login:AdminID={admin}','2008-9-24 9:21:13','0','LoginErr','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('292','Login_Login:AdminID={admin}','2008-9-24 9:21:20','1','Login','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('293','Edit_Tool_PageHelp_Manage:PageID={11}','2008-9-24 9:41:42','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('294','Edit_Tool_PageHelp_Manage:PageID={214}','2008-9-24 9:43:20','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('295','Edit_Tool_PageHelp_Manage:PageID={12}','2008-9-24 9:45:42','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('296','Edit_Tool_PageHelp_Manage:PageID={19}','2008-9-24 9:47:41','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('297','Edit_Tool_PageHelp_Manage:PageID={219}','2008-9-24 9:50:19','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('298','Edit_Tool_PageHelp_Manage:PageID={73}','2008-9-24 10:19:07','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('299','Edit_Tool_PageHelp_Manage:PageID={76}','2008-9-24 10:20:58','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('300','Edit_Tool_PageHelp_Manage:PageID={81}','2008-9-24 10:21:40','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('301','Edit_Tool_PageHelp_Manage:PageID={62}','2008-9-24 10:26:12','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('302','Edit_Tool_PageHelp_Manage:PageID={32}','2008-9-24 10:30:55','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('303','Edit_Tool_PageHelp_Manage:PageID={45}','2008-9-24 10:33:13','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('304','Login_Login:AdminID={admin}','2008-9-24 11:18:45','1','Login','192.168.1.102','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('305','Login_Login:AdminID={admin}','2008-9-24 11:20:44','1','Login','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('306','Edit_Tool_PageHelp_Manage:PageID={214}','2008-9-24 13:47:48','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('307','Edit_Tool_PageHelp_Manage:PageID={20}','2008-9-24 13:48:45','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('308','Edit_Tool_PageHelp_Manage:PageID={231}','2008-9-24 14:36:53','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('309','Edit_Tool_PageHelp_Manage:PageID={231}','2008-9-24 14:37:20','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('310','Edit_Tool_PageHelp_Manage:PageID={232}','2008-9-24 14:45:46','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('311','Edit_Tool_PageHelp_Manage:PageID={245}','2008-9-24 15:03:39','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('312','Edit_Tool_PageHelp_Manage:PageID={246}','2008-9-24 15:07:20','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('313','Edit_Tool_PageHelp_Manage:PageID={67}','2008-9-24 15:15:32','0','Edit','192.168.1.102','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('314','Login_Login:AdminID={admin}','2008-9-24 15:58:12','1','Login','192.168.1.102','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('315','Login_Login:AdminID={admin}','2008-9-24 16:22:14','1','Login','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('316','Login_Login:AdminID={admin}','2008-9-24 16:25:13','1','Login','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('317','Login_Login:AdminID={admin}','2008-9-24 17:20:51','1','Login','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('318','Edit_Tool_PageHelp_Manage:PageID={251}','2008-9-25 18:19:13','0','Edit','192.168.1.113','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('319','Edit_Tool_PageHelp_Manage:PageID={252}','2008-9-25 18:22:18','0','Edit','192.168.1.113','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('320','Edit_Tool_PageHelp_Manage:PageID={247}','2008-9-25 18:26:51','0','Edit','192.168.1.113','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('321','Edit_Tool_PageHelp_Manage:PageID={248}','2008-9-25 18:27:53','0','Edit','192.168.1.113','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('322','Login_Login:AdminID={admin}','2008-9-26 10:42:34','1','Login','192.168.1.110','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('323','Edit_Tool_PageHelp_Manage:PageID={246}','2008-9-26 10:50:19','0','Edit','192.168.1.110','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('324','Login_Login:AdminID={admin}','2008-9-27 8:44:21','1','Login','192.168.1.104','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('325','Login_Login:AdminID={admin}','2008-10-6 14:41:03','1','Login','192.168.1.107','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('326','Edit_Tool_PageHelp_Manage:PageID={58}','2008-10-6 14:49:39','0','Edit','192.168.1.107','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('327','Edit_Tool_PageHelp_Manage:PageID={63}','2008-10-6 14:49:54','0','Edit','192.168.1.107','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('328','Edit_Tool_PageHelp_Manage:PageID={64}','2008-10-6 14:50:06','0','Edit','192.168.1.107','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('329','Edit_Tool_PageHelp_Manage:PageID={246}','2008-10-6 14:57:03','0','Edit','192.168.1.107','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('330','Edit_Tool_PageHelp_Manage:PageID={10}','2008-10-6 14:59:03','0','Edit','192.168.1.107','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('331','Edit_Tool_PageHelp_Manage:PageID={79}','2008-10-6 15:02:46','0','Edit','192.168.1.107','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('332','Edit_Tool_PageHelp_Manage:PageID={41}','2008-10-6 15:07:15','0','Edit','192.168.1.107','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('333','Edit_Tool_PageHelp_Manage:PageID={46}','2008-10-6 15:07:42','0','Edit','192.168.1.107','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('334','Edit_Tool_PageHelp_Manage:PageID={42}','2008-10-6 15:08:16','0','Edit','192.168.1.107','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('335','Edit_Tool_PageHelp_Manage:PageID={98}','2008-10-6 15:08:41','0','Edit','192.168.1.107','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('336','Edit_Tool_PageHelp_Manage:PageID={43}','2008-10-6 15:09:29','0','Edit','192.168.1.107','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('337','Edit_Tool_PageHelp_Manage:PageID={47}','2008-10-6 15:10:01','0','Edit','192.168.1.107','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('338','Edit_Tool_PageHelp_Manage:PageID={52}','2008-10-6 15:10:25','0','Edit','192.168.1.107','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('339','Edit_Tool_PageHelp_Manage:PageID={48}','2008-10-6 15:10:49','0','Edit','192.168.1.107','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('340','Edit_Tool_PageHelp_Manage:PageID={234}','2008-10-6 15:11:00','0','Edit','192.168.1.107','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('341','Edit_Tool_PageHelp_Manage:PageID={235}','2008-10-6 15:13:51','0','Edit','192.168.1.107','Tool_PageHelp_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('342','LoginErr_Login:AdminID={admin}','2008-10-15 17:14:41','0','LoginErr','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('343','LoginErr_Login:AdminID={admin}','2008-10-15 17:14:41','0','LoginErr','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('344','Login_Login:AdminID={admin}','2008-10-15 17:14:53','1','Login','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('345','Edit_Other_MenuCategory_Manage:MenuCategoryCode={UserCardOverTime}','2008-10-15 17:19:33','0','Edit','192.168.1.241','Other_MenuCategory_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('346','Add_Tool_PageControl_Manage.','2008-10-17 10:37:05','0','Add','192.168.1.241','Tool_PageControl_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('347','Add_Tool_PageControl_Manage.','2008-10-17 10:37:54','0','Add','192.168.1.241','Tool_PageControl_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('348','Login_Login:AdminID={admin}','2008-10-21 8:38:28','1','Login','192.168.1.186','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('349','LoginErr_Login:AdminID={admin}','2008-10-21 18:06:22','0','LoginErr','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('350','LoginErr_Login:AdminID={admin}','2008-10-21 18:06:22','0','LoginErr','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('351','Login_Login:AdminID={admin}','2008-10-21 18:06:30','1','Login','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('352','Login_Login:AdminID={admin}','2008-10-21 18:11:24','1','Login','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('353','Login_Login:AdminID={admin}','2008-10-23 10:15:03','1','Login','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('354','LoginErr_Login:AdminID={admin}','2008-10-23 10:21:01','0','LoginErr','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('355','LoginErr_Login:AdminID={admin}','2008-10-23 10:21:01','0','LoginErr','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('356','Login_Login:AdminID={admin}','2008-10-23 10:21:07','1','Login','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('357','Login_Login:AdminID={admin}','2008-10-23 14:11:08','1','Login','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('358','Login_Login:AdminID={admin}','2008-10-23 14:19:26','1','Login','192.168.1.241','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('359','Login_Login:AdminID={admin}','2008-11-30 5:08:04','1','Login','192.168.1.154','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('360','Add_Tool_Page_Manage.','2008-11-30 5:10:27','0','Add','192.168.1.154','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('361','Add_Tool_Page_Manage.','2008-11-30 5:12:05','0','Add','192.168.1.154','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('362','Edit_Tool_PagePower_Manage:Role ID={1}, ','2008-11-30 5:12:32','0','Edit','192.168.1.154','Tool_PagePower_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('363','Add_Product_FittingType_Operate:ID={1}','2008-11-30 5:13:07','0','Add','192.168.1.154','Product_FittingType_Operate.aspx')
 
INSERT INTO Web_AdminLog VALUES ('364','Del_Product_FittingType_Manage:ID={1}','2008-11-30 5:17:32','0','Del','192.168.1.154','Product_FittingType_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('365','Edit_Email_EmailContent_Operate:ID={5}','2008-11-30 5:18:23','0','Edit','192.168.1.154','Email_EmailContent_Operate.aspx')
 
INSERT INTO Web_AdminLog VALUES ('366','Edit_Tool_PagePower_Manage:Role ID={1}, ','2008-11-30 5:18:49','0','Edit','192.168.1.154','Tool_PagePower_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('367','Login_Login:AdminID={admin}','2008-12-12 23:34:17','1','Login','192.168.1.232','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('368','Add_Tool_Page_Manage.','2008-12-13 0:26:19','0','Add','192.168.1.232','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('369','Edit_Tool_Page_Manage:ID={257}','2008-12-13 0:31:21','0','Edit','192.168.1.232','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('370','Edit_Tool_PagePower_Manage:Role ID={1}, ','2008-12-13 0:31:37','0','Edit','192.168.1.232','Tool_PagePower_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('371','Login_Login:AdminID={admin}','2008-12-13 0:32:29','1','Login','192.168.1.232','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('372','Login_Login:AdminID={admin}','2008-12-13 3:29:48','1','Login','192.168.1.232','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('377','Edit_Advertisement_Ads_Operate:ID={d88c7791-6eb4-4c62-9d67-b5afa059a2c8}','2008-12-13 3:32:45','0','Edit','192.168.1.232','Advertisement_Ads_Operate.aspx')
 
INSERT INTO Web_AdminLog VALUES ('373','Edit_Advertisement_Ads_Operate:ID={2136c243-936e-47c6-9aa6-b9643cbc358d}','2008-12-13 3:31:10','0','Edit','192.168.1.232','Advertisement_Ads_Operate.aspx')
 
INSERT INTO Web_AdminLog VALUES ('374','Edit_Advertisement_Ads_Operate:ID={e598f294-5d0a-4b1f-833d-fa8ecd2016bf}','2008-12-13 3:31:58','0','Edit','192.168.1.232','Advertisement_Ads_Operate.aspx')
 
INSERT INTO Web_AdminLog VALUES ('375','Edit_Advertisement_Ads_Operate:ID={5b22b32e-ed04-425d-aa08-0fbd84f29536}','2008-12-13 3:32:18','0','Edit','192.168.1.232','Advertisement_Ads_Operate.aspx')
 
INSERT INTO Web_AdminLog VALUES ('376','Edit_Advertisement_Ads_Operate:ID={5adab5b9-92d1-472b-a59e-5c6cc0223f1c}','2008-12-13 3:32:31','0','Edit','192.168.1.232','Advertisement_Ads_Operate.aspx')
 
INSERT INTO Web_AdminLog VALUES ('378','LoginErr_Login:AdminID={admin}','2009-1-23 19:38:49','0','LoginErr','192.168.1.232','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('379','LoginErr_Login:AdminID={admin}','2009-1-23 19:38:49','0','LoginErr','192.168.1.232','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('380','Login_Login:AdminID={admin}','2009-1-23 19:38:56','1','Login','192.168.1.232','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('381','Edit_Tool_Page_Manage:ID={57}','2009-1-23 19:40:26','0','Edit','192.168.1.232','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('382','Add_Tool_Page_Manage.','2009-1-23 19:41:08','0','Add','192.168.1.232','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('383','Edit_Tool_PagePower_Manage:Role ID={1}, ','2009-1-23 19:41:16','0','Edit','192.168.1.232','Tool_PagePower_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('385','Install_System_Payment_Manage:DllName={Alipay_Instant}','2009-2-5 17:58:40','0','Install','192.168.1.232','System_Payment_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('386','Install_System_Payment_Manage:DllName={Alipay_Instant_Year}','2009-2-5 17:58:41','0','Install','192.168.1.232','System_Payment_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('387','Install_System_Payment_Manage:DllName={Alipay_Standard}','2009-2-5 17:58:42','0','Install','192.168.1.232','System_Payment_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('388','Install_System_Payment_Manage:DllName={Alipay_Standard_Year}','2009-2-5 17:58:49','0','Install','192.168.1.232','System_Payment_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('389','Install_System_Payment_Manage:DllName={Bank}','2009-2-5 17:58:58','0','Install','192.168.1.232','System_Payment_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('390','Install_System_Payment_Manage:DllName={Bill99}','2009-2-5 17:59:05','0','Install','192.168.1.232','System_Payment_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('391','Install_System_Payment_Manage:DllName={ChinaBank}','2009-2-5 17:59:08','0','Install','192.168.1.232','System_Payment_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('392','Install_System_Payment_Manage:DllName={ShopCard}','2009-2-5 17:59:10','0','Install','192.168.1.232','System_Payment_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('393','Install_System_Payment_Manage:DllName={Tenpay}','2009-2-5 17:59:18','0','Install','192.168.1.232','System_Payment_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('394','Install_System_Payment_Manage:DllName={UserCard}','2009-2-5 17:59:21','0','Install','192.168.1.232','System_Payment_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('395','Install_System_Payment_Manage:DllName={Yeepay}','2009-2-5 17:59:24','0','Install','192.168.1.232','System_Payment_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('396','LoginErr_Login:AdminID={admin}','2009-2-5 18:53:03','0','LoginErr','192.168.1.232','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('397','LoginErr_Login:AdminID={admin}','2009-2-5 18:53:03','0','LoginErr','192.168.1.232','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('398','Login_Login:AdminID={admin}','2009-2-5 18:53:11','1','Login','192.168.1.232','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('384','Login_Login:AdminID={admin}','2009-2-5 17:58:30','1','Login','192.168.1.232','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('399','Edit_System_Payment_Operate:DllName={Alipay_Instant}','2009-2-5 18:55:12','0','Edit','192.168.1.232','System_Payment_Operate.aspx')
 
INSERT INTO Web_AdminLog VALUES ('400','Edit_System_Payment_Operate:DllName={Alipay_Instant_Year}','2009-2-5 18:55:43','0','Edit','192.168.1.232','System_Payment_Operate.aspx')
 
INSERT INTO Web_AdminLog VALUES ('401','Edit_System_Payment_Operate:DllName={Alipay_Standard}','2009-2-5 18:56:06','0','Edit','192.168.1.232','System_Payment_Operate.aspx')
 
INSERT INTO Web_AdminLog VALUES ('402','Edit_System_Payment_Operate:DllName={Alipay_Standard_Year}','2009-2-5 18:56:45','0','Edit','192.168.1.232','System_Payment_Operate.aspx')
 
INSERT INTO Web_AdminLog VALUES ('403','Edit_System_Payment_Operate:DllName={Bill99}','2009-2-5 19:06:31','0','Edit','192.168.1.232','System_Payment_Operate.aspx')
 
INSERT INTO Web_AdminLog VALUES ('404','Edit_System_Payment_Operate:DllName={ChinaBank}','2009-2-5 19:06:48','0','Edit','192.168.1.232','System_Payment_Operate.aspx')
 
INSERT INTO Web_AdminLog VALUES ('405','Edit_System_Payment_Operate:DllName={Yeepay}','2009-2-5 19:07:13','0','Edit','192.168.1.232','System_Payment_Operate.aspx')
 
INSERT INTO Web_AdminLog VALUES ('407','Add_Tool_Page_Manage.','2009-2-21 16:52:34','0','Add','192.168.1.232','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('408','Edit_Tool_PagePower_Manage:Role ID={1}, ','2009-2-21 16:55:28','0','Edit','192.168.1.232','Tool_PagePower_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('409','Edit_Tool_PagePower_Manage:Role ID={1}, ','2009-2-21 16:55:35','0','Edit','192.168.1.232','Tool_PagePower_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('406','Login_Login:AdminID={admin}','2009-2-21 16:45:33','1','Login','192.168.1.232','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('410','Add_Tool_Page_Manage.','2009-2-21 16:57:44','0','Add','192.168.1.232','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('411','Edit_Tool_PagePower_Manage:Role ID={1}, ','2009-2-21 16:58:28','0','Edit','192.168.1.232','Tool_PagePower_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('412','Login_Login:AdminID={admin}','2009-2-21 20:01:15','1','Login','192.168.1.232','Login.aspx')
 
INSERT INTO Web_AdminLog VALUES ('413','Add_Tool_Page_Manage.','2009-2-21 20:02:30','0','Add','192.168.1.232','Tool_Page_Manage.aspx')
 
INSERT INTO Web_AdminLog VALUES ('414','Edit_Tool_PagePower_Manage:Role ID={1}, ','2009-2-21 20:02:53','0','Edit','192.168.1.232','Tool_PagePower_Manage.aspx')
 
CREATE TABLE dbo.Tmp_Web_AdminLog([ID] [int]  NOT NULL IDENTITY (1, 1),[Record] [nvarchar] (150)  NULL,[Date] [datetime]  NOT NULL,[AdminID] [int]  NOT NULL,[Type] [nvarchar] (50)  NULL,[IP] [nvarchar] (50)  NULL,[Page] [nvarchar] (150)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_AdminLog ADD CONSTRAINT DF_Tmp_Web_AdminLog_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Tmp_Web_AdminLog ADD CONSTRAINT DF_Tmp_Web_AdminLog_AdminID DEFAULT ((0)) FOR [AdminID]
 
SET IDENTITY_INSERT dbo.Tmp_Web_AdminLog ON
 
IF EXISTS(SELECT * FROM dbo.Web_AdminLog) EXEC('INSERT INTO dbo.Tmp_Web_AdminLog ([ID],[Record],[Date],[AdminID],[Type],[IP],[Page]) SELECT [ID],[Record],[Date],[AdminID],[Type],[IP],[Page] FROM dbo.Web_AdminLog WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_AdminLog OFF
 
DROP TABLE dbo.Web_AdminLog
 
EXECUTE sp_rename N'dbo.Tmp_Web_AdminLog', N'Web_AdminLog', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_EmailVariableTable]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_EmailVariableTable] 
 
CREATE TABLE dbo.Web_EmailVariableTable([ID] [int]  NOT NULL,[Name] [nvarchar] (100)  NOT NULL,[Description] [nvarchar] (250)  NOT NULL,[OrderID] [int]  NOT NULL,[CanDel] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_EmailVariableTable ADD CONSTRAINT DF_Web_EmailVariableTable_Description DEFAULT ('') FOR [Description]
 
ALTER TABLE dbo.Web_EmailVariableTable ADD CONSTRAINT DF_Web_EmailVariableTable_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Web_EmailVariableTable ADD CONSTRAINT DF_Web_EmailVariableTable_CanDel DEFAULT ((0)) FOR [CanDel]
 
INSERT INTO Web_EmailVariableTable VALUES ('1','Web_User','会员表','1','0')
 
INSERT INTO Web_EmailVariableTable VALUES ('2','Web_Product','产品表','2','0')
 
INSERT INTO Web_EmailVariableTable VALUES ('3','Web_Order','订单表','3','0')
 
INSERT INTO Web_EmailVariableTable VALUES ('4','Web_ShippingAdvice','发货通知表','4','0')
 
INSERT INTO Web_EmailVariableTable VALUES ('5','Web_OutStock','缺货登记','5','0')
 
CREATE TABLE dbo.Tmp_Web_EmailVariableTable([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (100)  NOT NULL,[Description] [nvarchar] (250)  NOT NULL,[OrderID] [int]  NOT NULL,[CanDel] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_EmailVariableTable ADD CONSTRAINT DF_Tmp_Web_EmailVariableTable_Description DEFAULT ('') FOR [Description]
 
ALTER TABLE dbo.Tmp_Web_EmailVariableTable ADD CONSTRAINT DF_Tmp_Web_EmailVariableTable_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Tmp_Web_EmailVariableTable ADD CONSTRAINT DF_Tmp_Web_EmailVariableTable_CanDel DEFAULT ((0)) FOR [CanDel]
 
SET IDENTITY_INSERT dbo.Tmp_Web_EmailVariableTable ON
 
IF EXISTS(SELECT * FROM dbo.Web_EmailVariableTable) EXEC('INSERT INTO dbo.Tmp_Web_EmailVariableTable ([ID],[Name],[Description],[OrderID],[CanDel]) SELECT [ID],[Name],[Description],[OrderID],[CanDel] FROM dbo.Web_EmailVariableTable WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_EmailVariableTable OFF
 
DROP TABLE dbo.Web_EmailVariableTable
 
EXECUTE sp_rename N'dbo.Tmp_Web_EmailVariableTable', N'Web_EmailVariableTable', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_OutStock]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_OutStock] 
 
CREATE TABLE dbo.Web_OutStock([ID] [int]  NOT NULL,[ProductID] [int]  NOT NULL,[Count] [int]  NOT NULL,[UserName] [nvarchar] (50)  NULL,[Date] [datetime]  NULL,[Remark] [nvarchar] (250)  NULL,[Mobile] [nvarchar] (50)  NULL,[Email] [nvarchar] (50)  NULL,[TrueName] [nvarchar] (50)  NULL,[Telephone] [nvarchar] (50)  NULL,[Address] [nvarchar] (50)  NULL,[IsSendByEmail] [int]  NOT NULL,[IsSendByMobile] [int]  NOT NULL,[IsSendByMessage] [int]  NOT NULL,[IsDeal] [int]  NOT NULL,[DealName] [nvarchar] (50)  NULL,[DealDate] [datetime]  NULL,[DealRemark] [nvarchar] (200)  NULL,[LatestDate] [datetime]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_OutStock ADD CONSTRAINT DF_Web_OutStock_ProductID DEFAULT ((0)) FOR [ProductID]
 
ALTER TABLE dbo.Web_OutStock ADD CONSTRAINT DF_Web_OutStock_Count DEFAULT ((0)) FOR [Count]
 
ALTER TABLE dbo.Web_OutStock ADD CONSTRAINT DF_Web_OutStock_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Web_OutStock ADD CONSTRAINT DF_Web_OutStock_IsSendByEmail DEFAULT ((0)) FOR [IsSendByEmail]
 
ALTER TABLE dbo.Web_OutStock ADD CONSTRAINT DF_Web_OutStock_IsSendByMobile DEFAULT ((0)) FOR [IsSendByMobile]
 
ALTER TABLE dbo.Web_OutStock ADD CONSTRAINT DF_Web_OutStock_IsSendByMessage DEFAULT ((0)) FOR [IsSendByMessage]
 
ALTER TABLE dbo.Web_OutStock ADD CONSTRAINT DF_Web_OutStock_IsDeal DEFAULT ((0)) FOR [IsDeal]
 
ALTER TABLE dbo.Web_OutStock ADD CONSTRAINT DF_Web_OutStock_LatestDate DEFAULT (getdate()) FOR [LatestDate]
 
CREATE TABLE dbo.Tmp_Web_OutStock([ID] [int]  NOT NULL IDENTITY (1, 1),[ProductID] [int]  NOT NULL,[Count] [int]  NOT NULL,[UserName] [nvarchar] (50)  NULL,[Date] [datetime]  NULL,[Remark] [nvarchar] (250)  NULL,[Mobile] [nvarchar] (50)  NULL,[Email] [nvarchar] (50)  NULL,[TrueName] [nvarchar] (50)  NULL,[Telephone] [nvarchar] (50)  NULL,[Address] [nvarchar] (50)  NULL,[IsSendByEmail] [int]  NOT NULL,[IsSendByMobile] [int]  NOT NULL,[IsSendByMessage] [int]  NOT NULL,[IsDeal] [int]  NOT NULL,[DealName] [nvarchar] (50)  NULL,[DealDate] [datetime]  NULL,[DealRemark] [nvarchar] (200)  NULL,[LatestDate] [datetime]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_OutStock ADD CONSTRAINT DF_Tmp_Web_OutStock_ProductID DEFAULT ((0)) FOR [ProductID]
 
ALTER TABLE dbo.Tmp_Web_OutStock ADD CONSTRAINT DF_Tmp_Web_OutStock_Count DEFAULT ((0)) FOR [Count]
 
ALTER TABLE dbo.Tmp_Web_OutStock ADD CONSTRAINT DF_Tmp_Web_OutStock_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Tmp_Web_OutStock ADD CONSTRAINT DF_Tmp_Web_OutStock_IsSendByEmail DEFAULT ((0)) FOR [IsSendByEmail]
 
ALTER TABLE dbo.Tmp_Web_OutStock ADD CONSTRAINT DF_Tmp_Web_OutStock_IsSendByMobile DEFAULT ((0)) FOR [IsSendByMobile]
 
ALTER TABLE dbo.Tmp_Web_OutStock ADD CONSTRAINT DF_Tmp_Web_OutStock_IsSendByMessage DEFAULT ((0)) FOR [IsSendByMessage]
 
ALTER TABLE dbo.Tmp_Web_OutStock ADD CONSTRAINT DF_Tmp_Web_OutStock_IsDeal DEFAULT ((0)) FOR [IsDeal]
 
ALTER TABLE dbo.Tmp_Web_OutStock ADD CONSTRAINT DF_Tmp_Web_OutStock_LatestDate DEFAULT (getdate()) FOR [LatestDate]
 
SET IDENTITY_INSERT dbo.Tmp_Web_OutStock ON
 
IF EXISTS(SELECT * FROM dbo.Web_OutStock) EXEC('INSERT INTO dbo.Tmp_Web_OutStock ([ID],[ProductID],[Count],[UserName],[Date],[Remark],[Mobile],[Email],[TrueName],[Telephone],[Address],[IsSendByEmail],[IsSendByMobile],[IsSendByMessage],[IsDeal],[DealName],[DealDate],[DealRemark],[LatestDate]) SELECT [ID],[ProductID],[Count],[UserName],[Date],[Remark],[Mobile],[Email],[TrueName],[Telephone],[Address],[IsSendByEmail],[IsSendByMobile],[IsSendByMessage],[IsDeal],[DealName],[DealDate],[DealRemark],[LatestDate] FROM dbo.Web_OutStock WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_OutStock OFF
 
DROP TABLE dbo.Web_OutStock
 
EXECUTE sp_rename N'dbo.Tmp_Web_OutStock', N'Web_OutStock', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_ArticleLink]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_ArticleLink] 
 
CREATE TABLE dbo.Web_ArticleLink([ID] [int]  NOT NULL,[ArticleID] [int]  NOT NULL,[LinkTo] [int]  NOT NULL,[IsSingle] [int]  NOT NULL,[OrderID] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_ArticleLink ADD CONSTRAINT DF_Web_ArticleLink_OrderID DEFAULT ((1000)) FOR [OrderID]
 
CREATE TABLE dbo.Tmp_Web_ArticleLink([ID] [int]  NOT NULL IDENTITY (1, 1),[ArticleID] [int]  NOT NULL,[LinkTo] [int]  NOT NULL,[IsSingle] [int]  NOT NULL,[OrderID] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_ArticleLink ADD CONSTRAINT DF_Tmp_Web_ArticleLink_OrderID DEFAULT ((1000)) FOR [OrderID]
 
SET IDENTITY_INSERT dbo.Tmp_Web_ArticleLink ON
 
IF EXISTS(SELECT * FROM dbo.Web_ArticleLink) EXEC('INSERT INTO dbo.Tmp_Web_ArticleLink ([ID],[ArticleID],[LinkTo],[IsSingle],[OrderID]) SELECT [ID],[ArticleID],[LinkTo],[IsSingle],[OrderID] FROM dbo.Web_ArticleLink WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_ArticleLink OFF
 
DROP TABLE dbo.Web_ArticleLink
 
EXECUTE sp_rename N'dbo.Tmp_Web_ArticleLink', N'Web_ArticleLink', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Delivery]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Delivery] 
 
CREATE TABLE dbo.Web_Delivery([DllName] [nvarchar] (50)  NOT NULL,[Name] [nvarchar] (50)  NULL,[Description] [nvarchar] (250)  NULL,[OrderID] [int]  NOT NULL,[Freight] [decimal]  (18,1) NOT NULL,[IsCOD] [int]  NOT NULL,[IsACT] [int]  NOT NULL,[Version] [nvarchar] (50)  NULL,[Author] [nvarchar] (50)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Delivery ADD CONSTRAINT DF_Web_Delivery_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Web_Delivery ADD CONSTRAINT DF_Web_Delivery_Freight DEFAULT ((0)) FOR [Freight]
 
ALTER TABLE dbo.Web_Delivery ADD CONSTRAINT DF_Web_Delivery_IsCOD DEFAULT ((0)) FOR [IsCOD]
 
ALTER TABLE dbo.Web_Delivery ADD CONSTRAINT DF_Web_Delivery_IsACT DEFAULT ((0)) FOR [IsACT]
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Vote]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Vote] 
 
CREATE TABLE dbo.Web_Vote([Id] [int]  NOT NULL,[Title] [nvarchar] (50)  NULL,[StartDate] [datetime]  NULL,[EndDate] [datetime]  NULL,[IsRadio] [int]  NOT NULL,[Stat] [nvarchar] (250)  NULL,[Count] [int]  NOT NULL)  ON [PRIMARY] 
 
CREATE TABLE dbo.Tmp_Web_Vote([Id] [int]  NOT NULL IDENTITY (1, 1),[Title] [nvarchar] (50)  NULL,[StartDate] [datetime]  NULL,[EndDate] [datetime]  NULL,[IsRadio] [int]  NOT NULL,[Stat] [nvarchar] (250)  NULL,[Count] [int]  NOT NULL)  ON [PRIMARY] 
 
SET IDENTITY_INSERT dbo.Tmp_Web_Vote ON
 
IF EXISTS(SELECT * FROM dbo.Web_Vote) EXEC('INSERT INTO dbo.Tmp_Web_Vote ([Id],[Title],[StartDate],[EndDate],[IsRadio],[Stat],[Count]) SELECT [Id],[Title],[StartDate],[EndDate],[IsRadio],[Stat],[Count] FROM dbo.Web_Vote WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Vote OFF
 
DROP TABLE dbo.Web_Vote
 
EXECUTE sp_rename N'dbo.Tmp_Web_Vote', N'Web_Vote', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_UserMsg]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_UserMsg] 
 
CREATE TABLE dbo.Web_UserMsg([ID] [int]  NOT NULL,[SendName] [nvarchar] (50)  NULL,[MsgTo] [nvarchar] (50)  NULL,[Title] [nvarchar] (50)  NULL,[Content] [nvarchar] (200)  NULL,[Date] [datetime]  NOT NULL,[IsRead] [int]  NOT NULL,[IsDel] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_UserMsg ADD CONSTRAINT DF_Web_UserMsg_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Web_UserMsg ADD CONSTRAINT DF_Web_UserMsg_IsRead DEFAULT ((0)) FOR [IsRead]
 
ALTER TABLE dbo.Web_UserMsg ADD CONSTRAINT DF_Web_UserMsg_IsDel DEFAULT ((0)) FOR [IsDel]
 
CREATE TABLE dbo.Tmp_Web_UserMsg([ID] [int]  NOT NULL IDENTITY (1, 1),[SendName] [nvarchar] (50)  NULL,[MsgTo] [nvarchar] (50)  NULL,[Title] [nvarchar] (50)  NULL,[Content] [nvarchar] (200)  NULL,[Date] [datetime]  NOT NULL,[IsRead] [int]  NOT NULL,[IsDel] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_UserMsg ADD CONSTRAINT DF_Tmp_Web_UserMsg_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Tmp_Web_UserMsg ADD CONSTRAINT DF_Tmp_Web_UserMsg_IsRead DEFAULT ((0)) FOR [IsRead]
 
ALTER TABLE dbo.Tmp_Web_UserMsg ADD CONSTRAINT DF_Tmp_Web_UserMsg_IsDel DEFAULT ((0)) FOR [IsDel]
 
SET IDENTITY_INSERT dbo.Tmp_Web_UserMsg ON
 
IF EXISTS(SELECT * FROM dbo.Web_UserMsg) EXEC('INSERT INTO dbo.Tmp_Web_UserMsg ([ID],[SendName],[MsgTo],[Title],[Content],[Date],[IsRead],[IsDel]) SELECT [ID],[SendName],[MsgTo],[Title],[Content],[Date],[IsRead],[IsDel] FROM dbo.Web_UserMsg WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_UserMsg OFF
 
DROP TABLE dbo.Web_UserMsg
 
EXECUTE sp_rename N'dbo.Tmp_Web_UserMsg', N'Web_UserMsg', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_ArticleProduct]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_ArticleProduct] 
 
CREATE TABLE dbo.Web_ArticleProduct([ProductID] [int]  NOT NULL,[ArticleID] [int]  NOT NULL)  ON [PRIMARY] 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_AdsStat]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_AdsStat] 
 
CREATE TABLE dbo.Web_AdsStat([ID] [int]  NOT NULL,[AdsID] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[Href] [nvarchar] (250)  NULL,[UserName] [nvarchar] (50)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_AdsStat ADD CONSTRAINT DF_Web_AdsStat_AdsID DEFAULT ((0)) FOR [AdsID]
 
ALTER TABLE dbo.Web_AdsStat ADD CONSTRAINT DF_Web_AdsStat_Date DEFAULT (getdate()) FOR [Date]
 
CREATE TABLE dbo.Tmp_Web_AdsStat([ID] [int]  NOT NULL IDENTITY (1, 1),[AdsID] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[Href] [nvarchar] (250)  NULL,[UserName] [nvarchar] (50)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_AdsStat ADD CONSTRAINT DF_Tmp_Web_AdsStat_AdsID DEFAULT ((0)) FOR [AdsID]
 
ALTER TABLE dbo.Tmp_Web_AdsStat ADD CONSTRAINT DF_Tmp_Web_AdsStat_Date DEFAULT (getdate()) FOR [Date]
 
SET IDENTITY_INSERT dbo.Tmp_Web_AdsStat ON
 
IF EXISTS(SELECT * FROM dbo.Web_AdsStat) EXEC('INSERT INTO dbo.Tmp_Web_AdsStat ([ID],[AdsID],[Date],[Href],[UserName]) SELECT [ID],[AdsID],[Date],[Href],[UserName] FROM dbo.Web_AdsStat WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_AdsStat OFF
 
DROP TABLE dbo.Web_AdsStat
 
EXECUTE sp_rename N'dbo.Tmp_Web_AdsStat', N'Web_AdsStat', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_PageControlPower]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_PageControlPower] 
 
CREATE TABLE dbo.Web_PageControlPower([PageControlID] [int]  NOT NULL,[RoleID] [int]  NOT NULL,[IsEnable] [int]  NOT NULL,[IsVisible] [int]  NOT NULL,[PageID] [int]  NOT NULL,[ControlID] [nvarchar] (50)  NOT NULL,[Type] [nvarchar] (200)  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_PageControlPower ADD CONSTRAINT DF_Web_PageControlPower_PageControlID DEFAULT ((0)) FOR [PageControlID]
 
ALTER TABLE dbo.Web_PageControlPower ADD CONSTRAINT DF_Web_PageControlPower_RoleID DEFAULT ((0)) FOR [RoleID]
 
ALTER TABLE dbo.Web_PageControlPower ADD CONSTRAINT DF_Web_PageControlPower_IsEnable DEFAULT ((1)) FOR [IsEnable]
 
ALTER TABLE dbo.Web_PageControlPower ADD CONSTRAINT DF_Web_PageControlPower_IsVisible DEFAULT ((1)) FOR [IsVisible]
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_UserFields]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_UserFields] 
 
CREATE TABLE dbo.Web_UserFields([ID] [int]  NOT NULL,[UserName] [nvarchar] (50)  NULL,[Fields] [nvarchar] (4000)  NULL)  ON [PRIMARY] 
 
INSERT INTO Web_UserFields VALUES ('1','3123123','{公司名称:''123123123123123123'',公司网址:''12312312'',testaaa:''''}')
 
CREATE TABLE dbo.Tmp_Web_UserFields([ID] [int]  NOT NULL IDENTITY (1, 1),[UserName] [nvarchar] (50)  NULL,[Fields] [nvarchar] (4000)  NULL)  ON [PRIMARY] 
 
SET IDENTITY_INSERT dbo.Tmp_Web_UserFields ON
 
IF EXISTS(SELECT * FROM dbo.Web_UserFields) EXEC('INSERT INTO dbo.Tmp_Web_UserFields ([ID],[UserName],[Fields]) SELECT [ID],[UserName],[Fields] FROM dbo.Web_UserFields WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_UserFields OFF
 
DROP TABLE dbo.Web_UserFields
 
EXECUTE sp_rename N'dbo.Tmp_Web_UserFields', N'Web_UserFields', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_WholeSaleProduct]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_WholeSaleProduct] 
 
CREATE TABLE dbo.Web_WholeSaleProduct([WholeSaleID] [int]  NOT NULL,[ProductID] [int]  NOT NULL)  ON [PRIMARY] 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Category]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Category] 
 
CREATE TABLE dbo.Web_Category([ID] [int]  NOT NULL,[Name] [nvarchar] (50)  NOT NULL,[EnglishName] [nvarchar] (100)  NULL,[HeadID] [int]  NOT NULL,[Level] [int]  NOT NULL,[OrderID] [int]  NOT NULL,[Family] [nvarchar] (255)  NULL,[Title] [nvarchar] (255)  NULL,[Keywords] [nvarchar] (255)  NULL,[Description] [nvarchar] (255)  NULL,[TypeID] [int]  NOT NULL,[IsShow] [int]  NULL,[SrcDetail] [nvarchar] (200)  NULL,[SrcList] [nvarchar] (200)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Category ADD CONSTRAINT DF_Web_Category_HeadID DEFAULT ((0)) FOR [HeadID]
 
ALTER TABLE dbo.Web_Category ADD CONSTRAINT DF_Web_Category_Level DEFAULT ((0)) FOR [Level]
 
ALTER TABLE dbo.Web_Category ADD CONSTRAINT DF_Web_Category_OrderID DEFAULT ((10000)) FOR [OrderID]
 
ALTER TABLE dbo.Web_Category ADD CONSTRAINT DF_Web_Category_TypeID DEFAULT ((0)) FOR [TypeID]
 
CREATE TABLE dbo.Tmp_Web_Category([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NOT NULL,[EnglishName] [nvarchar] (100)  NULL,[HeadID] [int]  NOT NULL,[Level] [int]  NOT NULL,[OrderID] [int]  NOT NULL,[Family] [nvarchar] (255)  NULL,[Title] [nvarchar] (255)  NULL,[Keywords] [nvarchar] (255)  NULL,[Description] [nvarchar] (255)  NULL,[TypeID] [int]  NOT NULL,[IsShow] [int]  NULL,[SrcDetail] [nvarchar] (200)  NULL,[SrcList] [nvarchar] (200)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_Category ADD CONSTRAINT DF_Tmp_Web_Category_HeadID DEFAULT ((0)) FOR [HeadID]
 
ALTER TABLE dbo.Tmp_Web_Category ADD CONSTRAINT DF_Tmp_Web_Category_Level DEFAULT ((0)) FOR [Level]
 
ALTER TABLE dbo.Tmp_Web_Category ADD CONSTRAINT DF_Tmp_Web_Category_OrderID DEFAULT ((10000)) FOR [OrderID]
 
ALTER TABLE dbo.Tmp_Web_Category ADD CONSTRAINT DF_Tmp_Web_Category_TypeID DEFAULT ((0)) FOR [TypeID]
 
SET IDENTITY_INSERT dbo.Tmp_Web_Category ON
 
IF EXISTS(SELECT * FROM dbo.Web_Category) EXEC('INSERT INTO dbo.Tmp_Web_Category ([ID],[Name],[EnglishName],[HeadID],[Level],[OrderID],[Family],[Title],[Keywords],[Description],[TypeID],[IsShow],[SrcDetail],[SrcList]) SELECT [ID],[Name],[EnglishName],[HeadID],[Level],[OrderID],[Family],[Title],[Keywords],[Description],[TypeID],[IsShow],[SrcDetail],[SrcList] FROM dbo.Web_Category WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Category OFF
 
DROP TABLE dbo.Web_Category
 
EXECUTE sp_rename N'dbo.Tmp_Web_Category', N'Web_Category', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_ShopCardLog]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_ShopCardLog] 
 
CREATE TABLE dbo.Web_ShopCardLog([Id] [int]  NOT NULL,[Number] [nvarchar] (100)  NOT NULL,[OrderNumber] [nvarchar] (50)  NOT NULL,[Price] [decimal]  (18,2) NOT NULL,[Order] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[UserName] [nvarchar] (50)  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_ShopCardLog ADD CONSTRAINT DF_Web_ShopCardLog_Date DEFAULT (getdate()) FOR [Date]
 
CREATE TABLE dbo.Tmp_Web_ShopCardLog([Id] [int]  NOT NULL IDENTITY (1, 1),[Number] [nvarchar] (100)  NOT NULL,[OrderNumber] [nvarchar] (50)  NOT NULL,[Price] [decimal]  (18,2) NOT NULL,[Order] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[UserName] [nvarchar] (50)  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_ShopCardLog ADD CONSTRAINT DF_Tmp_Web_ShopCardLog_Date DEFAULT (getdate()) FOR [Date]
 
SET IDENTITY_INSERT dbo.Tmp_Web_ShopCardLog ON
 
IF EXISTS(SELECT * FROM dbo.Web_ShopCardLog) EXEC('INSERT INTO dbo.Tmp_Web_ShopCardLog ([Id],[Number],[OrderNumber],[Price],[Order],[Date],[UserName]) SELECT [Id],[Number],[OrderNumber],[Price],[Order],[Date],[UserName] FROM dbo.Web_ShopCardLog WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_ShopCardLog OFF
 
DROP TABLE dbo.Web_ShopCardLog
 
EXECUTE sp_rename N'dbo.Tmp_Web_ShopCardLog', N'Web_ShopCardLog', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_UserAddress]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_UserAddress] 
 
CREATE TABLE dbo.Web_UserAddress([Id] [int]  NOT NULL,[UserName] [nvarchar] (50)  NOT NULL,[Name] [nvarchar] (20)  NOT NULL,[NickName] [int]  NOT NULL,[Email] [nvarchar] (50)  NOT NULL,[Address] [nvarchar] (150)  NOT NULL,[PostCode] [nvarchar] (50)  NOT NULL,[Tel] [nvarchar] (50)  NOT NULL,[Moblie] [nvarchar] (50)  NOT NULL,[Flag] [nvarchar] (100)  NOT NULL,[BestTime] [nvarchar] (100)  NOT NULL,[IsDefault] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_UserAddress ADD CONSTRAINT DF_Web_UserAddress_UserName DEFAULT ('') FOR [UserName]
 
ALTER TABLE dbo.Web_UserAddress ADD CONSTRAINT DF_Web_UserAddress_NickName DEFAULT ((1)) FOR [NickName]
 
ALTER TABLE dbo.Web_UserAddress ADD CONSTRAINT DF_Web_UserAddress_Email DEFAULT ('') FOR [Email]
 
ALTER TABLE dbo.Web_UserAddress ADD CONSTRAINT DF_Web_UserAddress_Address DEFAULT ('') FOR [Address]
 
ALTER TABLE dbo.Web_UserAddress ADD CONSTRAINT DF_Web_UserAddress_PostCode DEFAULT ('‘’') FOR [PostCode]
 
ALTER TABLE dbo.Web_UserAddress ADD CONSTRAINT DF_Web_UserAddress_Tel DEFAULT ('‘’') FOR [Tel]
 
ALTER TABLE dbo.Web_UserAddress ADD CONSTRAINT DF_Web_UserAddress_Moblie DEFAULT ('‘’') FOR [Moblie]
 
ALTER TABLE dbo.Web_UserAddress ADD CONSTRAINT DF_Web_UserAddress_Flag DEFAULT (N'‘’') FOR [Flag]
 
ALTER TABLE dbo.Web_UserAddress ADD CONSTRAINT DF_Web_UserAddress_BestTime DEFAULT ('') FOR [BestTime]
 
ALTER TABLE dbo.Web_UserAddress ADD CONSTRAINT DF_Web_UserAddress_IsDefault DEFAULT ((0)) FOR [IsDefault]
 
CREATE TABLE dbo.Tmp_Web_UserAddress([Id] [int]  NOT NULL IDENTITY (1, 1),[UserName] [nvarchar] (50)  NOT NULL,[Name] [nvarchar] (20)  NOT NULL,[NickName] [int]  NOT NULL,[Email] [nvarchar] (50)  NOT NULL,[Address] [nvarchar] (150)  NOT NULL,[PostCode] [nvarchar] (50)  NOT NULL,[Tel] [nvarchar] (50)  NOT NULL,[Moblie] [nvarchar] (50)  NOT NULL,[Flag] [nvarchar] (100)  NOT NULL,[BestTime] [nvarchar] (100)  NOT NULL,[IsDefault] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_UserAddress ADD CONSTRAINT DF_Tmp_Web_UserAddress_UserName DEFAULT ('') FOR [UserName]
 
ALTER TABLE dbo.Tmp_Web_UserAddress ADD CONSTRAINT DF_Tmp_Web_UserAddress_NickName DEFAULT ((1)) FOR [NickName]
 
ALTER TABLE dbo.Tmp_Web_UserAddress ADD CONSTRAINT DF_Tmp_Web_UserAddress_Email DEFAULT ('') FOR [Email]
 
ALTER TABLE dbo.Tmp_Web_UserAddress ADD CONSTRAINT DF_Tmp_Web_UserAddress_Address DEFAULT ('') FOR [Address]
 
ALTER TABLE dbo.Tmp_Web_UserAddress ADD CONSTRAINT DF_Tmp_Web_UserAddress_PostCode DEFAULT ('‘’') FOR [PostCode]
 
ALTER TABLE dbo.Tmp_Web_UserAddress ADD CONSTRAINT DF_Tmp_Web_UserAddress_Tel DEFAULT ('‘’') FOR [Tel]
 
ALTER TABLE dbo.Tmp_Web_UserAddress ADD CONSTRAINT DF_Tmp_Web_UserAddress_Moblie DEFAULT ('‘’') FOR [Moblie]
 
ALTER TABLE dbo.Tmp_Web_UserAddress ADD CONSTRAINT DF_Tmp_Web_UserAddress_Flag DEFAULT (N'‘’') FOR [Flag]
 
ALTER TABLE dbo.Tmp_Web_UserAddress ADD CONSTRAINT DF_Tmp_Web_UserAddress_BestTime DEFAULT ('') FOR [BestTime]
 
ALTER TABLE dbo.Tmp_Web_UserAddress ADD CONSTRAINT DF_Tmp_Web_UserAddress_IsDefault DEFAULT ((0)) FOR [IsDefault]
 
SET IDENTITY_INSERT dbo.Tmp_Web_UserAddress ON
 
IF EXISTS(SELECT * FROM dbo.Web_UserAddress) EXEC('INSERT INTO dbo.Tmp_Web_UserAddress ([Id],[UserName],[Name],[NickName],[Email],[Address],[PostCode],[Tel],[Moblie],[Flag],[BestTime],[IsDefault]) SELECT [Id],[UserName],[Name],[NickName],[Email],[Address],[PostCode],[Tel],[Moblie],[Flag],[BestTime],[IsDefault] FROM dbo.Web_UserAddress WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_UserAddress OFF
 
DROP TABLE dbo.Web_UserAddress
 
EXECUTE sp_rename N'dbo.Tmp_Web_UserAddress', N'Web_UserAddress', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_SpecialTpl]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_SpecialTpl] 
 
CREATE TABLE dbo.Web_SpecialTpl([ID] [int]  NOT NULL,[TableID] [int]  NOT NULL,[TableName] [nvarchar] (50)  NULL,[FieldName] [nvarchar] (50)  NULL,[TplPage] [nvarchar] (50)  NULL,[IsAct] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_SpecialTpl ADD CONSTRAINT DF_Web_SpecialTpl_TableID DEFAULT ((0)) FOR [TableID]
 
ALTER TABLE dbo.Web_SpecialTpl ADD CONSTRAINT DF_Web_SpecialTpl_IsAct DEFAULT ((0)) FOR [IsAct]
 
CREATE TABLE dbo.Tmp_Web_SpecialTpl([ID] [int]  NOT NULL IDENTITY (1, 1),[TableID] [int]  NOT NULL,[TableName] [nvarchar] (50)  NULL,[FieldName] [nvarchar] (50)  NULL,[TplPage] [nvarchar] (50)  NULL,[IsAct] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_SpecialTpl ADD CONSTRAINT DF_Tmp_Web_SpecialTpl_TableID DEFAULT ((0)) FOR [TableID]
 
ALTER TABLE dbo.Tmp_Web_SpecialTpl ADD CONSTRAINT DF_Tmp_Web_SpecialTpl_IsAct DEFAULT ((0)) FOR [IsAct]
 
SET IDENTITY_INSERT dbo.Tmp_Web_SpecialTpl ON
 
IF EXISTS(SELECT * FROM dbo.Web_SpecialTpl) EXEC('INSERT INTO dbo.Tmp_Web_SpecialTpl ([ID],[TableID],[TableName],[FieldName],[TplPage],[IsAct]) SELECT [ID],[TableID],[TableName],[FieldName],[TplPage],[IsAct] FROM dbo.Web_SpecialTpl WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_SpecialTpl OFF
 
DROP TABLE dbo.Web_SpecialTpl
 
EXECUTE sp_rename N'dbo.Tmp_Web_SpecialTpl', N'Web_SpecialTpl', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_GroupBuyLog]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_GroupBuyLog] 
 
CREATE TABLE dbo.Web_GroupBuyLog([ID] [int]  NOT NULL,[GroupBuyID] [int]  NOT NULL,[UserName] [nvarchar] (50)  NOT NULL,[Count] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[SendName] [nvarchar] (50)  NOT NULL,[SendTel] [nvarchar] (100)  NOT NULL,[SendMobile] [nvarchar] (100)  NOT NULL,[SendEmail] [nvarchar] (100)  NOT NULL,[ReceiveName] [nvarchar] (100)  NOT NULL,[ReceiveTel] [nvarchar] (100)  NOT NULL,[ReceiveMobile] [nvarchar] (150)  NOT NULL,[ReceivePostCode] [nvarchar] (100)  NOT NULL,[ReceiveAddress] [nvarchar] (250)  NOT NULL,[ReceiveDate] [datetime]  NOT NULL,[ReceiveSex] [int]  NOT NULL,[Payment] [nvarchar] (50)  NOT NULL,[Delivery] [nvarchar] (50)  NOT NULL,[Remark] [nvarchar] (250)  NOT NULL,[Fee] [decimal]  (18,2) NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_GroupBuyLog ADD CONSTRAINT DF_Web_GroupBuyLog_GroupBuyID DEFAULT ((0)) FOR [GroupBuyID]
 
ALTER TABLE dbo.Web_GroupBuyLog ADD CONSTRAINT DF_Web_GroupBuyLog_Count DEFAULT ((1)) FOR [Count]
 
ALTER TABLE dbo.Web_GroupBuyLog ADD CONSTRAINT DF_Web_GroupBuyLog_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Web_GroupBuyLog ADD CONSTRAINT DF_Web_GroupBuyLog_SendName DEFAULT (N'匿名用户') FOR [SendName]
 
ALTER TABLE dbo.Web_GroupBuyLog ADD CONSTRAINT DF_Web_GroupBuyLog_SendTel DEFAULT (N'‘’') FOR [SendTel]
 
ALTER TABLE dbo.Web_GroupBuyLog ADD CONSTRAINT DF_Web_GroupBuyLog_SendMobile DEFAULT (N'‘’') FOR [SendMobile]
 
ALTER TABLE dbo.Web_GroupBuyLog ADD CONSTRAINT DF_Web_GroupBuyLog_SendEmail DEFAULT (N'‘’') FOR [SendEmail]
 
ALTER TABLE dbo.Web_GroupBuyLog ADD CONSTRAINT DF_Web_GroupBuyLog_ReceiveName DEFAULT (N'‘’') FOR [ReceiveName]
 
ALTER TABLE dbo.Web_GroupBuyLog ADD CONSTRAINT DF_Web_GroupBuyLog_ReceiveTel DEFAULT (N'‘’') FOR [ReceiveTel]
 
ALTER TABLE dbo.Web_GroupBuyLog ADD CONSTRAINT DF_Web_GroupBuyLog_ReceiveMobile DEFAULT (N'‘’') FOR [ReceiveMobile]
 
ALTER TABLE dbo.Web_GroupBuyLog ADD CONSTRAINT DF_Web_GroupBuyLog_ReceivePostCode DEFAULT (N'‘’') FOR [ReceivePostCode]
 
ALTER TABLE dbo.Web_GroupBuyLog ADD CONSTRAINT DF_Web_GroupBuyLog_ReceiveAddress DEFAULT (N'‘’') FOR [ReceiveAddress]
 
ALTER TABLE dbo.Web_GroupBuyLog ADD CONSTRAINT DF_Web_GroupBuyLog_ReceiveDate DEFAULT (getdate()) FOR [ReceiveDate]
 
ALTER TABLE dbo.Web_GroupBuyLog ADD CONSTRAINT DF_Web_GroupBuyLog_ReceiveSex DEFAULT ((0)) FOR [ReceiveSex]
 
ALTER TABLE dbo.Web_GroupBuyLog ADD CONSTRAINT DF_Web_GroupBuyLog_Payment DEFAULT (N'‘’') FOR [Payment]
 
ALTER TABLE dbo.Web_GroupBuyLog ADD CONSTRAINT DF_Web_GroupBuyLog_Delivery DEFAULT (N'‘’') FOR [Delivery]
 
ALTER TABLE dbo.Web_GroupBuyLog ADD CONSTRAINT DF_Web_GroupBuyLog_Remark DEFAULT (N'‘’') FOR [Remark]
 
ALTER TABLE dbo.Web_GroupBuyLog ADD CONSTRAINT DF_Web_GroupBuyLog_Fee DEFAULT ((0)) FOR [Fee]
 
CREATE TABLE dbo.Tmp_Web_GroupBuyLog([ID] [int]  NOT NULL IDENTITY (1, 1),[GroupBuyID] [int]  NOT NULL,[UserName] [nvarchar] (50)  NOT NULL,[Count] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[SendName] [nvarchar] (50)  NOT NULL,[SendTel] [nvarchar] (100)  NOT NULL,[SendMobile] [nvarchar] (100)  NOT NULL,[SendEmail] [nvarchar] (100)  NOT NULL,[ReceiveName] [nvarchar] (100)  NOT NULL,[ReceiveTel] [nvarchar] (100)  NOT NULL,[ReceiveMobile] [nvarchar] (150)  NOT NULL,[ReceivePostCode] [nvarchar] (100)  NOT NULL,[ReceiveAddress] [nvarchar] (250)  NOT NULL,[ReceiveDate] [datetime]  NOT NULL,[ReceiveSex] [int]  NOT NULL,[Payment] [nvarchar] (50)  NOT NULL,[Delivery] [nvarchar] (50)  NOT NULL,[Remark] [nvarchar] (250)  NOT NULL,[Fee] [decimal]  (18,2) NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_GroupBuyLog ADD CONSTRAINT DF_Tmp_Web_GroupBuyLog_GroupBuyID DEFAULT ((0)) FOR [GroupBuyID]
 
ALTER TABLE dbo.Tmp_Web_GroupBuyLog ADD CONSTRAINT DF_Tmp_Web_GroupBuyLog_Count DEFAULT ((1)) FOR [Count]
 
ALTER TABLE dbo.Tmp_Web_GroupBuyLog ADD CONSTRAINT DF_Tmp_Web_GroupBuyLog_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Tmp_Web_GroupBuyLog ADD CONSTRAINT DF_Tmp_Web_GroupBuyLog_SendName DEFAULT (N'匿名用户') FOR [SendName]
 
ALTER TABLE dbo.Tmp_Web_GroupBuyLog ADD CONSTRAINT DF_Tmp_Web_GroupBuyLog_SendTel DEFAULT (N'‘’') FOR [SendTel]
 
ALTER TABLE dbo.Tmp_Web_GroupBuyLog ADD CONSTRAINT DF_Tmp_Web_GroupBuyLog_SendMobile DEFAULT (N'‘’') FOR [SendMobile]
 
ALTER TABLE dbo.Tmp_Web_GroupBuyLog ADD CONSTRAINT DF_Tmp_Web_GroupBuyLog_SendEmail DEFAULT (N'‘’') FOR [SendEmail]
 
ALTER TABLE dbo.Tmp_Web_GroupBuyLog ADD CONSTRAINT DF_Tmp_Web_GroupBuyLog_ReceiveName DEFAULT (N'‘’') FOR [ReceiveName]
 
ALTER TABLE dbo.Tmp_Web_GroupBuyLog ADD CONSTRAINT DF_Tmp_Web_GroupBuyLog_ReceiveTel DEFAULT (N'‘’') FOR [ReceiveTel]
 
ALTER TABLE dbo.Tmp_Web_GroupBuyLog ADD CONSTRAINT DF_Tmp_Web_GroupBuyLog_ReceiveMobile DEFAULT (N'‘’') FOR [ReceiveMobile]
 
ALTER TABLE dbo.Tmp_Web_GroupBuyLog ADD CONSTRAINT DF_Tmp_Web_GroupBuyLog_ReceivePostCode DEFAULT (N'‘’') FOR [ReceivePostCode]
 
ALTER TABLE dbo.Tmp_Web_GroupBuyLog ADD CONSTRAINT DF_Tmp_Web_GroupBuyLog_ReceiveAddress DEFAULT (N'‘’') FOR [ReceiveAddress]
 
ALTER TABLE dbo.Tmp_Web_GroupBuyLog ADD CONSTRAINT DF_Tmp_Web_GroupBuyLog_ReceiveDate DEFAULT (getdate()) FOR [ReceiveDate]
 
ALTER TABLE dbo.Tmp_Web_GroupBuyLog ADD CONSTRAINT DF_Tmp_Web_GroupBuyLog_ReceiveSex DEFAULT ((0)) FOR [ReceiveSex]
 
ALTER TABLE dbo.Tmp_Web_GroupBuyLog ADD CONSTRAINT DF_Tmp_Web_GroupBuyLog_Payment DEFAULT (N'‘’') FOR [Payment]
 
ALTER TABLE dbo.Tmp_Web_GroupBuyLog ADD CONSTRAINT DF_Tmp_Web_GroupBuyLog_Delivery DEFAULT (N'‘’') FOR [Delivery]
 
ALTER TABLE dbo.Tmp_Web_GroupBuyLog ADD CONSTRAINT DF_Tmp_Web_GroupBuyLog_Remark DEFAULT (N'‘’') FOR [Remark]
 
ALTER TABLE dbo.Tmp_Web_GroupBuyLog ADD CONSTRAINT DF_Tmp_Web_GroupBuyLog_Fee DEFAULT ((0)) FOR [Fee]
 
SET IDENTITY_INSERT dbo.Tmp_Web_GroupBuyLog ON
 
IF EXISTS(SELECT * FROM dbo.Web_GroupBuyLog) EXEC('INSERT INTO dbo.Tmp_Web_GroupBuyLog ([ID],[GroupBuyID],[UserName],[Count],[Date],[SendName],[SendTel],[SendMobile],[SendEmail],[ReceiveName],[ReceiveTel],[ReceiveMobile],[ReceivePostCode],[ReceiveAddress],[ReceiveDate],[ReceiveSex],[Payment],[Delivery],[Remark],[Fee]) SELECT [ID],[GroupBuyID],[UserName],[Count],[Date],[SendName],[SendTel],[SendMobile],[SendEmail],[ReceiveName],[ReceiveTel],[ReceiveMobile],[ReceivePostCode],[ReceiveAddress],[ReceiveDate],[ReceiveSex],[Payment],[Delivery],[Remark],[Fee] FROM dbo.Web_GroupBuyLog WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_GroupBuyLog OFF
 
DROP TABLE dbo.Web_GroupBuyLog
 
EXECUTE sp_rename N'dbo.Tmp_Web_GroupBuyLog', N'Web_GroupBuyLog', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_SearchKey]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_SearchKey] 
 
CREATE TABLE dbo.Web_SearchKey([ID] [int]  NOT NULL,[Name] [nvarchar] (150)  NOT NULL,[Count] [int]  NOT NULL,[IsShow] [int]  NOT NULL,[Type] [int]  NOT NULL,[IsDel] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_SearchKey ADD CONSTRAINT DF_Web_SearchKey_Count DEFAULT ((0)) FOR [Count]
 
ALTER TABLE dbo.Web_SearchKey ADD CONSTRAINT DF_Web_SearchKey_IsShow DEFAULT ((0)) FOR [IsShow]
 
ALTER TABLE dbo.Web_SearchKey ADD CONSTRAINT DF_Web_SearchKey_Type DEFAULT ((0)) FOR [Type]
 
ALTER TABLE dbo.Web_SearchKey ADD CONSTRAINT DF_Web_SearchKey_IsDel DEFAULT ((0)) FOR [IsDel]
 
CREATE TABLE dbo.Tmp_Web_SearchKey([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (150)  NOT NULL,[Count] [int]  NOT NULL,[IsShow] [int]  NOT NULL,[Type] [int]  NOT NULL,[IsDel] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_SearchKey ADD CONSTRAINT DF_Tmp_Web_SearchKey_Count DEFAULT ((0)) FOR [Count]
 
ALTER TABLE dbo.Tmp_Web_SearchKey ADD CONSTRAINT DF_Tmp_Web_SearchKey_IsShow DEFAULT ((0)) FOR [IsShow]
 
ALTER TABLE dbo.Tmp_Web_SearchKey ADD CONSTRAINT DF_Tmp_Web_SearchKey_Type DEFAULT ((0)) FOR [Type]
 
ALTER TABLE dbo.Tmp_Web_SearchKey ADD CONSTRAINT DF_Tmp_Web_SearchKey_IsDel DEFAULT ((0)) FOR [IsDel]
 
SET IDENTITY_INSERT dbo.Tmp_Web_SearchKey ON
 
IF EXISTS(SELECT * FROM dbo.Web_SearchKey) EXEC('INSERT INTO dbo.Tmp_Web_SearchKey ([ID],[Name],[Count],[IsShow],[Type],[IsDel]) SELECT [ID],[Name],[Count],[IsShow],[Type],[IsDel] FROM dbo.Web_SearchKey WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_SearchKey OFF
 
DROP TABLE dbo.Web_SearchKey
 
EXECUTE sp_rename N'dbo.Tmp_Web_SearchKey', N'Web_SearchKey', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Coupon]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Coupon] 
 
CREATE TABLE dbo.Web_Coupon([Id] [int]  NOT NULL,[Name] [nvarchar] (50)  NOT NULL,[Src] [nvarchar] (250)  NOT NULL,[NeedPrice] [decimal]  (18,2) NOT NULL,[MinusPrice] [decimal]  (18,2) NOT NULL,[StartDate] [datetime]  NOT NULL,[EndDate] [datetime]  NOT NULL,[Count] [int]  NOT NULL,[IsDel] [int]  NOT NULL,[OrderID] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Coupon ADD CONSTRAINT DF_Web_Coupon_Src DEFAULT ('') FOR [Src]
 
ALTER TABLE dbo.Web_Coupon ADD CONSTRAINT DF_Web_Coupon_NeedPrice DEFAULT ((0)) FOR [NeedPrice]
 
ALTER TABLE dbo.Web_Coupon ADD CONSTRAINT DF_Web_Coupon_MinusPrice DEFAULT ((0)) FOR [MinusPrice]
 
ALTER TABLE dbo.Web_Coupon ADD CONSTRAINT DF_Web_Coupon_StartDate DEFAULT (getdate()) FOR [StartDate]
 
ALTER TABLE dbo.Web_Coupon ADD CONSTRAINT DF_Web_Coupon_EndDate DEFAULT (getdate()) FOR [EndDate]
 
ALTER TABLE dbo.Web_Coupon ADD CONSTRAINT DF_Web_Coupon_Count DEFAULT ((0)) FOR [Count]
 
ALTER TABLE dbo.Web_Coupon ADD CONSTRAINT DF_Web_Coupon_IsDel DEFAULT ((0)) FOR [IsDel]
 
ALTER TABLE dbo.Web_Coupon ADD CONSTRAINT DF_Web_Coupon_OrderID DEFAULT ((1000)) FOR [OrderID]
 
CREATE TABLE dbo.Tmp_Web_Coupon([Id] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NOT NULL,[Src] [nvarchar] (250)  NOT NULL,[NeedPrice] [decimal]  (18,2) NOT NULL,[MinusPrice] [decimal]  (18,2) NOT NULL,[StartDate] [datetime]  NOT NULL,[EndDate] [datetime]  NOT NULL,[Count] [int]  NOT NULL,[IsDel] [int]  NOT NULL,[OrderID] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_Coupon ADD CONSTRAINT DF_Tmp_Web_Coupon_Src DEFAULT ('') FOR [Src]
 
ALTER TABLE dbo.Tmp_Web_Coupon ADD CONSTRAINT DF_Tmp_Web_Coupon_NeedPrice DEFAULT ((0)) FOR [NeedPrice]
 
ALTER TABLE dbo.Tmp_Web_Coupon ADD CONSTRAINT DF_Tmp_Web_Coupon_MinusPrice DEFAULT ((0)) FOR [MinusPrice]
 
ALTER TABLE dbo.Tmp_Web_Coupon ADD CONSTRAINT DF_Tmp_Web_Coupon_StartDate DEFAULT (getdate()) FOR [StartDate]
 
ALTER TABLE dbo.Tmp_Web_Coupon ADD CONSTRAINT DF_Tmp_Web_Coupon_EndDate DEFAULT (getdate()) FOR [EndDate]
 
ALTER TABLE dbo.Tmp_Web_Coupon ADD CONSTRAINT DF_Tmp_Web_Coupon_Count DEFAULT ((0)) FOR [Count]
 
ALTER TABLE dbo.Tmp_Web_Coupon ADD CONSTRAINT DF_Tmp_Web_Coupon_IsDel DEFAULT ((0)) FOR [IsDel]
 
ALTER TABLE dbo.Tmp_Web_Coupon ADD CONSTRAINT DF_Tmp_Web_Coupon_OrderID DEFAULT ((1000)) FOR [OrderID]
 
SET IDENTITY_INSERT dbo.Tmp_Web_Coupon ON
 
IF EXISTS(SELECT * FROM dbo.Web_Coupon) EXEC('INSERT INTO dbo.Tmp_Web_Coupon ([Id],[Name],[Src],[NeedPrice],[MinusPrice],[StartDate],[EndDate],[Count],[IsDel],[OrderID]) SELECT [Id],[Name],[Src],[NeedPrice],[MinusPrice],[StartDate],[EndDate],[Count],[IsDel],[OrderID] FROM dbo.Web_Coupon WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Coupon OFF
 
DROP TABLE dbo.Web_Coupon
 
EXECUTE sp_rename N'dbo.Tmp_Web_Coupon', N'Web_Coupon', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_ProductThanksgiver]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_ProductThanksgiver] 
 
CREATE TABLE dbo.Web_ProductThanksgiver([ID] [int]  NOT NULL,[ProductID] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[Username] [nvarchar] (50)  NOT NULL,[Star] [int]  NOT NULL,[Title] [nvarchar] (50)  NOT NULL,[Content] [nvarchar] (250)  NOT NULL,[IP] [nvarchar] (20)  NOT NULL,[PassDate] [datetime]  NOT NULL,[IsRecommand] [int]  NOT NULL,[IsPass] [int]  NOT NULL,[IsScore] [int]  NOT NULL,[Score] [int]  NOT NULL,[IsDel] [int]  NOT NULL,[ReviewTo] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_ProductThanksgiver ADD CONSTRAINT DF_Web_ProductThanksgiver_ProductID DEFAULT ((0)) FOR [ProductID]
 
ALTER TABLE dbo.Web_ProductThanksgiver ADD CONSTRAINT DF_Web_ProductThanksgiver_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Web_ProductThanksgiver ADD CONSTRAINT DF_Web_ProductThanksgiver_Username DEFAULT ('') FOR [Username]
 
ALTER TABLE dbo.Web_ProductThanksgiver ADD CONSTRAINT DF_Web_ProductThanksgiver_Star DEFAULT ((0)) FOR [Star]
 
ALTER TABLE dbo.Web_ProductThanksgiver ADD CONSTRAINT DF_Web_ProductThanksgiver_Title DEFAULT ('') FOR [Title]
 
ALTER TABLE dbo.Web_ProductThanksgiver ADD CONSTRAINT DF_Web_ProductThanksgiver_Content DEFAULT ('') FOR [Content]
 
ALTER TABLE dbo.Web_ProductThanksgiver ADD CONSTRAINT DF_Web_ProductThanksgiver_IP DEFAULT ('') FOR [IP]
 
ALTER TABLE dbo.Web_ProductThanksgiver ADD CONSTRAINT DF_Web_ProductThanksgiver_PassDate DEFAULT (getdate()) FOR [PassDate]
 
ALTER TABLE dbo.Web_ProductThanksgiver ADD CONSTRAINT DF_Web_ProductThanksgiver_IsRecommand DEFAULT ((0)) FOR [IsRecommand]
 
ALTER TABLE dbo.Web_ProductThanksgiver ADD CONSTRAINT DF_Web_ProductThanksgiver_IsPass DEFAULT ((0)) FOR [IsPass]
 
ALTER TABLE dbo.Web_ProductThanksgiver ADD CONSTRAINT DF_Web_ProductThanksgiver_IsScore DEFAULT ((0)) FOR [IsScore]
 
ALTER TABLE dbo.Web_ProductThanksgiver ADD CONSTRAINT DF_Web_ProductThanksgiver_Score DEFAULT ((0)) FOR [Score]
 
ALTER TABLE dbo.Web_ProductThanksgiver ADD CONSTRAINT DF_Web_ProductThanksgiver_IsDel DEFAULT ((0)) FOR [IsDel]
 
ALTER TABLE dbo.Web_ProductThanksgiver ADD CONSTRAINT DF_Web_ProductThanksgiver_ReviewTo DEFAULT ((0)) FOR [ReviewTo]
 
CREATE TABLE dbo.Tmp_Web_ProductThanksgiver([ID] [int]  NOT NULL IDENTITY (1, 1),[ProductID] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[Username] [nvarchar] (50)  NOT NULL,[Star] [int]  NOT NULL,[Title] [nvarchar] (50)  NOT NULL,[Content] [nvarchar] (250)  NOT NULL,[IP] [nvarchar] (20)  NOT NULL,[PassDate] [datetime]  NOT NULL,[IsRecommand] [int]  NOT NULL,[IsPass] [int]  NOT NULL,[IsScore] [int]  NOT NULL,[Score] [int]  NOT NULL,[IsDel] [int]  NOT NULL,[ReviewTo] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_ProductThanksgiver ADD CONSTRAINT DF_Tmp_Web_ProductThanksgiver_ProductID DEFAULT ((0)) FOR [ProductID]
 
ALTER TABLE dbo.Tmp_Web_ProductThanksgiver ADD CONSTRAINT DF_Tmp_Web_ProductThanksgiver_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Tmp_Web_ProductThanksgiver ADD CONSTRAINT DF_Tmp_Web_ProductThanksgiver_Username DEFAULT ('') FOR [Username]
 
ALTER TABLE dbo.Tmp_Web_ProductThanksgiver ADD CONSTRAINT DF_Tmp_Web_ProductThanksgiver_Star DEFAULT ((0)) FOR [Star]
 
ALTER TABLE dbo.Tmp_Web_ProductThanksgiver ADD CONSTRAINT DF_Tmp_Web_ProductThanksgiver_Title DEFAULT ('') FOR [Title]
 
ALTER TABLE dbo.Tmp_Web_ProductThanksgiver ADD CONSTRAINT DF_Tmp_Web_ProductThanksgiver_Content DEFAULT ('') FOR [Content]
 
ALTER TABLE dbo.Tmp_Web_ProductThanksgiver ADD CONSTRAINT DF_Tmp_Web_ProductThanksgiver_IP DEFAULT ('') FOR [IP]
 
ALTER TABLE dbo.Tmp_Web_ProductThanksgiver ADD CONSTRAINT DF_Tmp_Web_ProductThanksgiver_PassDate DEFAULT (getdate()) FOR [PassDate]
 
ALTER TABLE dbo.Tmp_Web_ProductThanksgiver ADD CONSTRAINT DF_Tmp_Web_ProductThanksgiver_IsRecommand DEFAULT ((0)) FOR [IsRecommand]
 
ALTER TABLE dbo.Tmp_Web_ProductThanksgiver ADD CONSTRAINT DF_Tmp_Web_ProductThanksgiver_IsPass DEFAULT ((0)) FOR [IsPass]
 
ALTER TABLE dbo.Tmp_Web_ProductThanksgiver ADD CONSTRAINT DF_Tmp_Web_ProductThanksgiver_IsScore DEFAULT ((0)) FOR [IsScore]
 
ALTER TABLE dbo.Tmp_Web_ProductThanksgiver ADD CONSTRAINT DF_Tmp_Web_ProductThanksgiver_Score DEFAULT ((0)) FOR [Score]
 
ALTER TABLE dbo.Tmp_Web_ProductThanksgiver ADD CONSTRAINT DF_Tmp_Web_ProductThanksgiver_IsDel DEFAULT ((0)) FOR [IsDel]
 
ALTER TABLE dbo.Tmp_Web_ProductThanksgiver ADD CONSTRAINT DF_Tmp_Web_ProductThanksgiver_ReviewTo DEFAULT ((0)) FOR [ReviewTo]
 
SET IDENTITY_INSERT dbo.Tmp_Web_ProductThanksgiver ON
 
IF EXISTS(SELECT * FROM dbo.Web_ProductThanksgiver) EXEC('INSERT INTO dbo.Tmp_Web_ProductThanksgiver ([ID],[ProductID],[Date],[Username],[Star],[Title],[Content],[IP],[PassDate],[IsRecommand],[IsPass],[IsScore],[Score],[IsDel],[ReviewTo]) SELECT [ID],[ProductID],[Date],[Username],[Star],[Title],[Content],[IP],[PassDate],[IsRecommand],[IsPass],[IsScore],[Score],[IsDel],[ReviewTo] FROM dbo.Web_ProductThanksgiver WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_ProductThanksgiver OFF
 
DROP TABLE dbo.Web_ProductThanksgiver
 
EXECUTE sp_rename N'dbo.Tmp_Web_ProductThanksgiver', N'Web_ProductThanksgiver', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_AttachmentCategory]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_AttachmentCategory] 
 
CREATE TABLE dbo.Web_AttachmentCategory([ID] [int]  NOT NULL,[Name] [nvarchar] (20)  NULL,[OrderID] [int]  NULL,[Level] [int]  NULL,[HeadID] [int]  NULL,[Family] [nvarchar] (250)  NULL,[Description] [nvarchar] (100)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_AttachmentCategory ADD CONSTRAINT DF_Web_AttachmentCategory_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Web_AttachmentCategory ADD CONSTRAINT DF_Web_AttachmentCategory_Level DEFAULT ((0)) FOR [Level]
 
ALTER TABLE dbo.Web_AttachmentCategory ADD CONSTRAINT DF_Web_AttachmentCategory_HeadID DEFAULT ((0)) FOR [HeadID]
 
CREATE TABLE dbo.Tmp_Web_AttachmentCategory([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (20)  NULL,[OrderID] [int]  NULL,[Level] [int]  NULL,[HeadID] [int]  NULL,[Family] [nvarchar] (250)  NULL,[Description] [nvarchar] (100)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_AttachmentCategory ADD CONSTRAINT DF_Tmp_Web_AttachmentCategory_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Tmp_Web_AttachmentCategory ADD CONSTRAINT DF_Tmp_Web_AttachmentCategory_Level DEFAULT ((0)) FOR [Level]
 
ALTER TABLE dbo.Tmp_Web_AttachmentCategory ADD CONSTRAINT DF_Tmp_Web_AttachmentCategory_HeadID DEFAULT ((0)) FOR [HeadID]
 
SET IDENTITY_INSERT dbo.Tmp_Web_AttachmentCategory ON
 
IF EXISTS(SELECT * FROM dbo.Web_AttachmentCategory) EXEC('INSERT INTO dbo.Tmp_Web_AttachmentCategory ([ID],[Name],[OrderID],[Level],[HeadID],[Family],[Description]) SELECT [ID],[Name],[OrderID],[Level],[HeadID],[Family],[Description] FROM dbo.Web_AttachmentCategory WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_AttachmentCategory OFF
 
DROP TABLE dbo.Web_AttachmentCategory
 
EXECUTE sp_rename N'dbo.Tmp_Web_AttachmentCategory', N'Web_AttachmentCategory', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Card]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Card] 
 
CREATE TABLE dbo.Web_Card([Id] [int]  NOT NULL,[Number] [nvarchar] (20)  NOT NULL,[UserName] [nvarchar] (50)  NOT NULL,[Price] [decimal]  (18,2) NOT NULL,[Password] [nvarchar] (50)  NOT NULL,[AdminName] [nvarchar] (20)  NOT NULL,[Date] [datetime]  NOT NULL,[EndDate] [datetime]  NOT NULL,[DispenseOrder] [int]  NOT NULL,[DispenseCount] [int]  NOT NULL,[IsValidate] [int]  NOT NULL,[RechargeStatus] [int]  NOT NULL,[RechargeDate] [datetime]  NULL,[SaleStatus] [int]  NOT NULL,[IsSale] [int]  NOT NULL,[IsDel] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Card ADD CONSTRAINT DF_Web_Card_UserName DEFAULT ('') FOR [UserName]
 
ALTER TABLE dbo.Web_Card ADD CONSTRAINT DF_Web_Card_Price DEFAULT ((0)) FOR [Price]
 
ALTER TABLE dbo.Web_Card ADD CONSTRAINT DF_Web_Card_Password DEFAULT ('') FOR [Password]
 
ALTER TABLE dbo.Web_Card ADD CONSTRAINT DF_Web_Card_AdminName DEFAULT ('') FOR [AdminName]
 
ALTER TABLE dbo.Web_Card ADD CONSTRAINT DF_Web_Card_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Web_Card ADD CONSTRAINT DF_Web_Card_EndDate DEFAULT (getdate()) FOR [EndDate]
 
ALTER TABLE dbo.Web_Card ADD CONSTRAINT DF_Web_Card_DispenseOrder DEFAULT ((0)) FOR [DispenseOrder]
 
ALTER TABLE dbo.Web_Card ADD CONSTRAINT DF_Web_Card_DispenseCount DEFAULT ((0)) FOR [DispenseCount]
 
ALTER TABLE dbo.Web_Card ADD CONSTRAINT DF_Web_Card_IsValidate DEFAULT ((0)) FOR [IsValidate]
 
ALTER TABLE dbo.Web_Card ADD CONSTRAINT DF_Web_Card_RechargeStatus DEFAULT ((0)) FOR [RechargeStatus]
 
ALTER TABLE dbo.Web_Card ADD CONSTRAINT DF_Web_Card_SaleStatus DEFAULT ((0)) FOR [SaleStatus]
 
ALTER TABLE dbo.Web_Card ADD CONSTRAINT DF_Web_Card_IsSale DEFAULT ((0)) FOR [IsSale]
 
ALTER TABLE dbo.Web_Card ADD CONSTRAINT DF_Web_Card_IsDel DEFAULT ((0)) FOR [IsDel]
 
CREATE TABLE dbo.Tmp_Web_Card([Id] [int]  NOT NULL IDENTITY (1, 1),[Number] [nvarchar] (20)  NOT NULL,[UserName] [nvarchar] (50)  NOT NULL,[Price] [decimal]  (18,2) NOT NULL,[Password] [nvarchar] (50)  NOT NULL,[AdminName] [nvarchar] (20)  NOT NULL,[Date] [datetime]  NOT NULL,[EndDate] [datetime]  NOT NULL,[DispenseOrder] [int]  NOT NULL,[DispenseCount] [int]  NOT NULL,[IsValidate] [int]  NOT NULL,[RechargeStatus] [int]  NOT NULL,[RechargeDate] [datetime]  NULL,[SaleStatus] [int]  NOT NULL,[IsSale] [int]  NOT NULL,[IsDel] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_Card ADD CONSTRAINT DF_Tmp_Web_Card_UserName DEFAULT ('') FOR [UserName]
 
ALTER TABLE dbo.Tmp_Web_Card ADD CONSTRAINT DF_Tmp_Web_Card_Price DEFAULT ((0)) FOR [Price]
 
ALTER TABLE dbo.Tmp_Web_Card ADD CONSTRAINT DF_Tmp_Web_Card_Password DEFAULT ('') FOR [Password]
 
ALTER TABLE dbo.Tmp_Web_Card ADD CONSTRAINT DF_Tmp_Web_Card_AdminName DEFAULT ('') FOR [AdminName]
 
ALTER TABLE dbo.Tmp_Web_Card ADD CONSTRAINT DF_Tmp_Web_Card_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Tmp_Web_Card ADD CONSTRAINT DF_Tmp_Web_Card_EndDate DEFAULT (getdate()) FOR [EndDate]
 
ALTER TABLE dbo.Tmp_Web_Card ADD CONSTRAINT DF_Tmp_Web_Card_DispenseOrder DEFAULT ((0)) FOR [DispenseOrder]
 
ALTER TABLE dbo.Tmp_Web_Card ADD CONSTRAINT DF_Tmp_Web_Card_DispenseCount DEFAULT ((0)) FOR [DispenseCount]
 
ALTER TABLE dbo.Tmp_Web_Card ADD CONSTRAINT DF_Tmp_Web_Card_IsValidate DEFAULT ((0)) FOR [IsValidate]
 
ALTER TABLE dbo.Tmp_Web_Card ADD CONSTRAINT DF_Tmp_Web_Card_RechargeStatus DEFAULT ((0)) FOR [RechargeStatus]
 
ALTER TABLE dbo.Tmp_Web_Card ADD CONSTRAINT DF_Tmp_Web_Card_SaleStatus DEFAULT ((0)) FOR [SaleStatus]
 
ALTER TABLE dbo.Tmp_Web_Card ADD CONSTRAINT DF_Tmp_Web_Card_IsSale DEFAULT ((0)) FOR [IsSale]
 
ALTER TABLE dbo.Tmp_Web_Card ADD CONSTRAINT DF_Tmp_Web_Card_IsDel DEFAULT ((0)) FOR [IsDel]
 
SET IDENTITY_INSERT dbo.Tmp_Web_Card ON
 
IF EXISTS(SELECT * FROM dbo.Web_Card) EXEC('INSERT INTO dbo.Tmp_Web_Card ([Id],[Number],[UserName],[Price],[Password],[AdminName],[Date],[EndDate],[DispenseOrder],[DispenseCount],[IsValidate],[RechargeStatus],[RechargeDate],[SaleStatus],[IsSale],[IsDel]) SELECT [Id],[Number],[UserName],[Price],[Password],[AdminName],[Date],[EndDate],[DispenseOrder],[DispenseCount],[IsValidate],[RechargeStatus],[RechargeDate],[SaleStatus],[IsSale],[IsDel] FROM dbo.Web_Card WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Card OFF
 
DROP TABLE dbo.Web_Card
 
EXECUTE sp_rename N'dbo.Tmp_Web_Card', N'Web_Card', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Admin]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Admin] 
 
CREATE TABLE dbo.Web_Admin([ID] [int]  NOT NULL,[Name] [nvarchar] (50)  NOT NULL,[Pass] [nvarchar] (50)  NOT NULL,[DeptID] [int]  NOT NULL,[AddDate] [datetime]  NOT NULL,[LoginDate] [datetime]  NOT NULL,[LoginTimes] [int]  NOT NULL,[LoginIP] [nvarchar] (50)  NULL,[LastLoginDate] [datetime]  NULL,[LastLoginIP] [nvarchar] (50)  NULL,[TrueName] [nvarchar] (50)  NULL,[Number] [nvarchar] (50)  NULL,[Sex] [int]  NOT NULL,[Age] [int]  NOT NULL,[Email] [nvarchar] (50)  NULL,[Tel] [nvarchar] (50)  NULL,[IsLock] [int]  NOT NULL,[IsDel] [int]  NOT NULL,[Creator] [nvarchar] (50)  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Admin ADD CONSTRAINT DF_Web_Admin_DeptID DEFAULT ((0)) FOR [DeptID]
 
ALTER TABLE dbo.Web_Admin ADD CONSTRAINT DF_Web_Admin_AddDate DEFAULT (getdate()) FOR [AddDate]
 
ALTER TABLE dbo.Web_Admin ADD CONSTRAINT DF_Web_Admin_LoginDate DEFAULT (getdate()) FOR [LoginDate]
 
ALTER TABLE dbo.Web_Admin ADD CONSTRAINT DF_Web_Admin_LoginTimes DEFAULT ((0)) FOR [LoginTimes]
 
ALTER TABLE dbo.Web_Admin ADD CONSTRAINT DF_Web_Admin_Sex DEFAULT ((0)) FOR [Sex]
 
ALTER TABLE dbo.Web_Admin ADD CONSTRAINT DF_Web_Admin_Age DEFAULT ((0)) FOR [Age]
 
ALTER TABLE dbo.Web_Admin ADD CONSTRAINT DF_Web_Admin_IsLock DEFAULT ((0)) FOR [IsLock]
 
ALTER TABLE dbo.Web_Admin ADD CONSTRAINT DF_Web_Admin_IsDel DEFAULT ((0)) FOR [IsDel]
 
INSERT INTO Web_Admin VALUES ('1','admin','E10ADC3949BA59ABBE56E057F20F883E','1','2008-5-21 16:21:00','2009-2-21 20:01:15','60','192.168.1.232','2009-2-21 16:45:33','192.168.1.232','管理员','0001','0','24','admin@163.com','55520018','0','0','admin')
 
CREATE TABLE dbo.Tmp_Web_Admin([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NOT NULL,[Pass] [nvarchar] (50)  NOT NULL,[DeptID] [int]  NOT NULL,[AddDate] [datetime]  NOT NULL,[LoginDate] [datetime]  NOT NULL,[LoginTimes] [int]  NOT NULL,[LoginIP] [nvarchar] (50)  NULL,[LastLoginDate] [datetime]  NULL,[LastLoginIP] [nvarchar] (50)  NULL,[TrueName] [nvarchar] (50)  NULL,[Number] [nvarchar] (50)  NULL,[Sex] [int]  NOT NULL,[Age] [int]  NOT NULL,[Email] [nvarchar] (50)  NULL,[Tel] [nvarchar] (50)  NULL,[IsLock] [int]  NOT NULL,[IsDel] [int]  NOT NULL,[Creator] [nvarchar] (50)  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_Admin ADD CONSTRAINT DF_Tmp_Web_Admin_DeptID DEFAULT ((0)) FOR [DeptID]
 
ALTER TABLE dbo.Tmp_Web_Admin ADD CONSTRAINT DF_Tmp_Web_Admin_AddDate DEFAULT (getdate()) FOR [AddDate]
 
ALTER TABLE dbo.Tmp_Web_Admin ADD CONSTRAINT DF_Tmp_Web_Admin_LoginDate DEFAULT (getdate()) FOR [LoginDate]
 
ALTER TABLE dbo.Tmp_Web_Admin ADD CONSTRAINT DF_Tmp_Web_Admin_LoginTimes DEFAULT ((0)) FOR [LoginTimes]
 
ALTER TABLE dbo.Tmp_Web_Admin ADD CONSTRAINT DF_Tmp_Web_Admin_Sex DEFAULT ((0)) FOR [Sex]
 
ALTER TABLE dbo.Tmp_Web_Admin ADD CONSTRAINT DF_Tmp_Web_Admin_Age DEFAULT ((0)) FOR [Age]
 
ALTER TABLE dbo.Tmp_Web_Admin ADD CONSTRAINT DF_Tmp_Web_Admin_IsLock DEFAULT ((0)) FOR [IsLock]
 
ALTER TABLE dbo.Tmp_Web_Admin ADD CONSTRAINT DF_Tmp_Web_Admin_IsDel DEFAULT ((0)) FOR [IsDel]
 
SET IDENTITY_INSERT dbo.Tmp_Web_Admin ON
 
IF EXISTS(SELECT * FROM dbo.Web_Admin) EXEC('INSERT INTO dbo.Tmp_Web_Admin ([ID],[Name],[Pass],[DeptID],[AddDate],[LoginDate],[LoginTimes],[LoginIP],[LastLoginDate],[LastLoginIP],[TrueName],[Number],[Sex],[Age],[Email],[Tel],[IsLock],[IsDel],[Creator]) SELECT [ID],[Name],[Pass],[DeptID],[AddDate],[LoginDate],[LoginTimes],[LoginIP],[LastLoginDate],[LastLoginIP],[TrueName],[Number],[Sex],[Age],[Email],[Tel],[IsLock],[IsDel],[Creator] FROM dbo.Web_Admin WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Admin OFF
 
DROP TABLE dbo.Web_Admin
 
EXECUTE sp_rename N'dbo.Tmp_Web_Admin', N'Web_Admin', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_PropertyValue]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_PropertyValue] 
 
CREATE TABLE dbo.Web_PropertyValue([ID] [int]  NOT NULL,[PropertyID] [int]  NOT NULL,[Value] [nvarchar] (50)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_PropertyValue ADD CONSTRAINT DF_Web_PropertyValue_PropertyID DEFAULT ((0)) FOR [PropertyID]
 
CREATE TABLE dbo.Tmp_Web_PropertyValue([ID] [int]  NOT NULL IDENTITY (1, 1),[PropertyID] [int]  NOT NULL,[Value] [nvarchar] (50)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_PropertyValue ADD CONSTRAINT DF_Tmp_Web_PropertyValue_PropertyID DEFAULT ((0)) FOR [PropertyID]
 
SET IDENTITY_INSERT dbo.Tmp_Web_PropertyValue ON
 
IF EXISTS(SELECT * FROM dbo.Web_PropertyValue) EXEC('INSERT INTO dbo.Tmp_Web_PropertyValue ([ID],[PropertyID],[Value]) SELECT [ID],[PropertyID],[Value] FROM dbo.Web_PropertyValue WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_PropertyValue OFF
 
DROP TABLE dbo.Web_PropertyValue
 
EXECUTE sp_rename N'dbo.Tmp_Web_PropertyValue', N'Web_PropertyValue', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_EmailGroup]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_EmailGroup] 
 
CREATE TABLE dbo.Web_EmailGroup([Id] [int]  NOT NULL,[Name] [nvarchar] (50)  NULL,[Description] [nvarchar] (250)  NULL)  ON [PRIMARY] 
 
CREATE TABLE dbo.Tmp_Web_EmailGroup([Id] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NULL,[Description] [nvarchar] (250)  NULL)  ON [PRIMARY] 
 
SET IDENTITY_INSERT dbo.Tmp_Web_EmailGroup ON
 
IF EXISTS(SELECT * FROM dbo.Web_EmailGroup) EXEC('INSERT INTO dbo.Tmp_Web_EmailGroup ([Id],[Name],[Description]) SELECT [Id],[Name],[Description] FROM dbo.Web_EmailGroup WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_EmailGroup OFF
 
DROP TABLE dbo.Web_EmailGroup
 
EXECUTE sp_rename N'dbo.Tmp_Web_EmailGroup', N'Web_EmailGroup', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_ProductValue]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_ProductValue] 
 
CREATE TABLE dbo.Web_ProductValue([ProductID] [int]  NOT NULL,[ValueID] [int]  NOT NULL,[IsSelect] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_ProductValue ADD CONSTRAINT DF_Web_ProductValue_ProductID DEFAULT ((0)) FOR [ProductID]
 
ALTER TABLE dbo.Web_ProductValue ADD CONSTRAINT DF_Web_ProductValue_ValueID DEFAULT ((0)) FOR [ValueID]
 
ALTER TABLE dbo.Web_ProductValue ADD CONSTRAINT DF_Web_ProductValue_IsSelect DEFAULT ((0)) FOR [IsSelect]
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Link]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Link] 
 
CREATE TABLE dbo.Web_Link([Id] [int]  NOT NULL,[Name] [nvarchar] (50)  NULL,[Src] [nvarchar] (250)  NULL,[Href] [nvarchar] (250)  NULL,[ImgType] [int]  NOT NULL,[OrderID] [int]  NOT NULL,[Type] [int]  NOT NULL,[Description] [nvarchar] (250)  NULL,[Remark] [nvarchar] (150)  NULL)  ON [PRIMARY] 
 
CREATE TABLE dbo.Tmp_Web_Link([Id] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NULL,[Src] [nvarchar] (250)  NULL,[Href] [nvarchar] (250)  NULL,[ImgType] [int]  NOT NULL,[OrderID] [int]  NOT NULL,[Type] [int]  NOT NULL,[Description] [nvarchar] (250)  NULL,[Remark] [nvarchar] (150)  NULL)  ON [PRIMARY] 
 
SET IDENTITY_INSERT dbo.Tmp_Web_Link ON
 
IF EXISTS(SELECT * FROM dbo.Web_Link) EXEC('INSERT INTO dbo.Tmp_Web_Link ([Id],[Name],[Src],[Href],[ImgType],[OrderID],[Type],[Description],[Remark]) SELECT [Id],[Name],[Src],[Href],[ImgType],[OrderID],[Type],[Description],[Remark] FROM dbo.Web_Link WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Link OFF
 
DROP TABLE dbo.Web_Link
 
EXECUTE sp_rename N'dbo.Tmp_Web_Link', N'Web_Link', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Gbook]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Gbook] 
 
CREATE TABLE dbo.Web_Gbook([ID] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[UserName] [varchar] (1) NOT NULL,[Title] [nvarchar] (50)  NOT NULL,[Content] [nvarchar] (250)  NOT NULL,[MenuID] [nvarchar] (50)  NOT NULL,[Email] [nvarchar] (50)  NOT NULL,[Telephone] [nvarchar] (50)  NOT NULL,[IP] [nvarchar] (20)  NOT NULL,[Remark] [nvarchar] (250)  NOT NULL,[RemarkDate] [datetime]  NOT NULL,[IsRemark] [int]  NOT NULL,[IsPass] [int]  NOT NULL,[IsHidden] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Gbook ADD CONSTRAINT DF_Web_Gbook_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Web_Gbook ADD CONSTRAINT DF_Web_Gbook_Title DEFAULT ('') FOR [Title]
 
ALTER TABLE dbo.Web_Gbook ADD CONSTRAINT DF_Web_Gbook_Content DEFAULT ('') FOR [Content]
 
ALTER TABLE dbo.Web_Gbook ADD CONSTRAINT DF_Web_Gbook_MenuID DEFAULT ((0)) FOR [MenuID]
 
ALTER TABLE dbo.Web_Gbook ADD CONSTRAINT DF_Web_Gbook_Email DEFAULT ('') FOR [Email]
 
ALTER TABLE dbo.Web_Gbook ADD CONSTRAINT DF_Web_Gbook_Telephone DEFAULT ('') FOR [Telephone]
 
ALTER TABLE dbo.Web_Gbook ADD CONSTRAINT DF_Web_Gbook_IP DEFAULT (N'0.0.0.0') FOR [IP]
 
ALTER TABLE dbo.Web_Gbook ADD CONSTRAINT DF_Web_Gbook_Remark DEFAULT ('') FOR [Remark]
 
ALTER TABLE dbo.Web_Gbook ADD CONSTRAINT DF_Web_Gbook_RemarkDate DEFAULT (getdate()) FOR [RemarkDate]
 
ALTER TABLE dbo.Web_Gbook ADD CONSTRAINT DF_Web_Gbook_IsRemark DEFAULT ((0)) FOR [IsRemark]
 
ALTER TABLE dbo.Web_Gbook ADD CONSTRAINT DF_Web_Gbook_IsPass DEFAULT ((0)) FOR [IsPass]
 
ALTER TABLE dbo.Web_Gbook ADD CONSTRAINT DF_Web_Gbook_IsHidden DEFAULT ((0)) FOR [IsHidden]
 
CREATE TABLE dbo.Tmp_Web_Gbook([ID] [int]  NOT NULL IDENTITY (1, 1),[Date] [datetime]  NOT NULL,[UserName] [varchar] (1) NOT NULL,[Title] [nvarchar] (50)  NOT NULL,[Content] [nvarchar] (250)  NOT NULL,[MenuID] [nvarchar] (50)  NOT NULL,[Email] [nvarchar] (50)  NOT NULL,[Telephone] [nvarchar] (50)  NOT NULL,[IP] [nvarchar] (20)  NOT NULL,[Remark] [nvarchar] (250)  NOT NULL,[RemarkDate] [datetime]  NOT NULL,[IsRemark] [int]  NOT NULL,[IsPass] [int]  NOT NULL,[IsHidden] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_Gbook ADD CONSTRAINT DF_Tmp_Web_Gbook_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Tmp_Web_Gbook ADD CONSTRAINT DF_Tmp_Web_Gbook_Title DEFAULT ('') FOR [Title]
 
ALTER TABLE dbo.Tmp_Web_Gbook ADD CONSTRAINT DF_Tmp_Web_Gbook_Content DEFAULT ('') FOR [Content]
 
ALTER TABLE dbo.Tmp_Web_Gbook ADD CONSTRAINT DF_Tmp_Web_Gbook_MenuID DEFAULT ((0)) FOR [MenuID]
 
ALTER TABLE dbo.Tmp_Web_Gbook ADD CONSTRAINT DF_Tmp_Web_Gbook_Email DEFAULT ('') FOR [Email]
 
ALTER TABLE dbo.Tmp_Web_Gbook ADD CONSTRAINT DF_Tmp_Web_Gbook_Telephone DEFAULT ('') FOR [Telephone]
 
ALTER TABLE dbo.Tmp_Web_Gbook ADD CONSTRAINT DF_Tmp_Web_Gbook_IP DEFAULT (N'0.0.0.0') FOR [IP]
 
ALTER TABLE dbo.Tmp_Web_Gbook ADD CONSTRAINT DF_Tmp_Web_Gbook_Remark DEFAULT ('') FOR [Remark]
 
ALTER TABLE dbo.Tmp_Web_Gbook ADD CONSTRAINT DF_Tmp_Web_Gbook_RemarkDate DEFAULT (getdate()) FOR [RemarkDate]
 
ALTER TABLE dbo.Tmp_Web_Gbook ADD CONSTRAINT DF_Tmp_Web_Gbook_IsRemark DEFAULT ((0)) FOR [IsRemark]
 
ALTER TABLE dbo.Tmp_Web_Gbook ADD CONSTRAINT DF_Tmp_Web_Gbook_IsPass DEFAULT ((0)) FOR [IsPass]
 
ALTER TABLE dbo.Tmp_Web_Gbook ADD CONSTRAINT DF_Tmp_Web_Gbook_IsHidden DEFAULT ((0)) FOR [IsHidden]
 
SET IDENTITY_INSERT dbo.Tmp_Web_Gbook ON
 
IF EXISTS(SELECT * FROM dbo.Web_Gbook) EXEC('INSERT INTO dbo.Tmp_Web_Gbook ([ID],[Date],[UserName],[Title],[Content],[MenuID],[Email],[Telephone],[IP],[Remark],[RemarkDate],[IsRemark],[IsPass],[IsHidden]) SELECT [ID],[Date],[UserName],[Title],[Content],[MenuID],[Email],[Telephone],[IP],[Remark],[RemarkDate],[IsRemark],[IsPass],[IsHidden] FROM dbo.Web_Gbook WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Gbook OFF
 
DROP TABLE dbo.Web_Gbook
 
EXECUTE sp_rename N'dbo.Tmp_Web_Gbook', N'Web_Gbook', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_ArticleCategory]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_ArticleCategory] 
 
CREATE TABLE dbo.Web_ArticleCategory([ID] [bigint]  NOT NULL,[Name] [nvarchar] (50)  NOT NULL,[EnglishName] [varchar] (3) NOT NULL,[OrderID] [int]  NOT NULL,[Level] [int]  NOT NULL,[HeadID] [int]  NOT NULL,[Family] [nvarchar] (2000)  NULL,[SearchKey] [nvarchar] (100)  NULL,[Description] [nvarchar] (300)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_ArticleCategory ADD CONSTRAINT DF_Web_ArticleCategory_EnglishName DEFAULT ('') FOR [EnglishName]
 
ALTER TABLE dbo.Web_ArticleCategory ADD CONSTRAINT DF_Web_ArticleCategory_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Web_ArticleCategory ADD CONSTRAINT DF_Web_ArticleCategory_Level DEFAULT ((0)) FOR [Level]
 
ALTER TABLE dbo.Web_ArticleCategory ADD CONSTRAINT DF_Web_ArticleCategory_HeadID DEFAULT ((0)) FOR [HeadID]
 
CREATE TABLE dbo.Tmp_Web_ArticleCategory([ID] [bigint]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NOT NULL,[EnglishName] [varchar] (3) NOT NULL,[OrderID] [int]  NOT NULL,[Level] [int]  NOT NULL,[HeadID] [int]  NOT NULL,[Family] [nvarchar] (2000)  NULL,[SearchKey] [nvarchar] (100)  NULL,[Description] [nvarchar] (300)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_ArticleCategory ADD CONSTRAINT DF_Tmp_Web_ArticleCategory_EnglishName DEFAULT ('') FOR [EnglishName]
 
ALTER TABLE dbo.Tmp_Web_ArticleCategory ADD CONSTRAINT DF_Tmp_Web_ArticleCategory_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Tmp_Web_ArticleCategory ADD CONSTRAINT DF_Tmp_Web_ArticleCategory_Level DEFAULT ((0)) FOR [Level]
 
ALTER TABLE dbo.Tmp_Web_ArticleCategory ADD CONSTRAINT DF_Tmp_Web_ArticleCategory_HeadID DEFAULT ((0)) FOR [HeadID]
 
SET IDENTITY_INSERT dbo.Tmp_Web_ArticleCategory ON
 
IF EXISTS(SELECT * FROM dbo.Web_ArticleCategory) EXEC('INSERT INTO dbo.Tmp_Web_ArticleCategory ([ID],[Name],[EnglishName],[OrderID],[Level],[HeadID],[Family],[SearchKey],[Description]) SELECT [ID],[Name],[EnglishName],[OrderID],[Level],[HeadID],[Family],[SearchKey],[Description] FROM dbo.Web_ArticleCategory WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_ArticleCategory OFF
 
DROP TABLE dbo.Web_ArticleCategory
 
EXECUTE sp_rename N'dbo.Tmp_Web_ArticleCategory', N'Web_ArticleCategory', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_EmailContent]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_EmailContent] 
 
CREATE TABLE dbo.Web_EmailContent([Id] [int]  NOT NULL,[Title] [nvarchar] (50)  NULL,[Content] [ntext]  NULL,[IsAct] [int]  NOT NULL,[EmailCategoryID] [int]  NOT NULL,[Description] [nvarchar] (250)  NULL)  ON [PRIMARY] 
 
INSERT INTO Web_EmailContent VALUES ('1','您的注册资料','<p>
<table cellspacing="0" cellpadding="2" width="100%" border="0">
    <tbody>
        <tr>
            <td height="25"><strong>亲爱的{user.Name}，您好：</strong></td>
        </tr>
        <tr>
            <td height="25"><strong><font color="#000000">感谢您注册成为{Const.SiteName}的会员。以下是您的注册资料：</font></strong></td>
        </tr>
        <tr>
            <td align="left" height="25"><strong><font color="#009900">用 户 名：</font></strong>&nbsp;{user.Name}</td>
        </tr>
        <tr>
            <td align="left" height="25"><strong><font color="#009900">会员密码：</font></strong>&nbsp;********(安全起见，密码不显示。如您忘记密码，请<a target="_blank" href="{Const.SiteUrl}pswback.aspx">按此找回</a>)</td>
        </tr>
        <tr>
            <td align="left" height="25"><strong><font color="#009900">E - mail：</font></strong>&nbsp;{user.Email}</td>
        </tr>
        <tr>
            <td align="left" height="25"><strong><font color="#009900">保护问题： </font></strong>&nbsp;{user.Question}</td>
        </tr>
        <tr>
            <td align="left" height="25"><font color="#009900"><strong>保护答案：</strong></font>&nbsp;{user.Answer}</td>
        </tr>
        <tr>
            <td align="left" height="25"><strong><font color="#009900">真实姓名：</font></strong>&nbsp;{user.TrueName}</td>
        </tr>
        <tr>
            <td align="left" height="25"><strong><font color="#009900">身份证号：</font></strong>&nbsp;{user.IdentityCard}</td>
        </tr>
        <tr>
            <td align="left" height="25"><strong><font color="#009900">联系地址：</font></strong>&nbsp;{user.Address}</td>
        </tr>
        <tr>
            <td align="left" height="25"><strong><font color="#009900">联系电话：</font></strong>&nbsp;{user.Telephone}</td>
        </tr>
        <tr>
            <td align="left" height="25"><strong><font color="#009900">QQ,MSN：</font></strong>&nbsp;{user.QQ}</td>
        </tr>
        <tr>
            <td align="left" height="25"><strong><font color="#009900">推荐人：</font></strong>&nbsp;{user.CommendUser}</td>
        </tr>
        <tr>
            <td align="left" height="30">您可以： <a target="_blank" href="{Const.SiteUrl}member/">登录会员中心 </a>&nbsp;&nbsp; <a target="_blank" href="{Const.SiteUrl}">访问{Const.SiteName}</a></td>
        </tr>
        <tr>
            <td align="left" height="30"><strong>此邮件为系统自动发送 请勿回复，谢谢 给您带来不便，敬请见谅！</strong></td>
        </tr>
        <tr>
            <td align="right" height="30">{Const.SiteName}</td>
        </tr>
        <tr>
            <td align="right" height="30">{Const.SendTime}&nbsp;</td>
        </tr>
    </tbody>
</table>
</p>','1','1','会员注册成功时发送此邮件(完成)')
 
INSERT INTO Web_EmailContent VALUES ('2','密码保护答案修改成功','<p>
<table cellspacing="0" cellpadding="0" width="100%" border="0">
    <tbody>
        <tr>
            <td height="25">尊敬的{user.Name}，您好：</td>
        </tr>
        <tr>
            <td height="25">您于{Const.SendTime}修改了您的密码保护答案！以下是您修改后的相关信息：</td>
        </tr>
        <tr>
            <td height="25">用户名：{user.Name}</td>
        </tr>
        <tr>
            <td height="25">保护问题：&nbsp;{user.Question}</td>
        </tr>
        <tr>
            <td height="25">保护答案：&nbsp;{user.Answer}</td>
        </tr>
        <tr>
            <td height="25">如果您忘记了密码，可以按此地址找回 <a target="_blank" href="{Const.SiteUrl}pswback.aspx">找回密码</a>{Const.SiteUrl}pswback.aspx</td>
        </tr>
        <tr>
            <td height="25">您可以： <a target="_blank" href="{Const.SiteUrl}member/">登录会员中心 </a>&nbsp;&nbsp; <a target="_blank" href="{Const.SiteUrl}">访问{Const.SiteName}</a></td>
        </tr>
        <tr>
            <td height="25"></td>
        </tr>
        <tr>
            <td height="25"><strong>此邮件为系统自动发送 请勿回复，谢谢 给您带来的不便请见谅</strong></td>
        </tr>
        <tr>
            <td align="right" height="25">{Const.SendTime}</td>
        </tr>
        <tr>
            <td align="right" height="25">{Const.SiteName}</td>
        </tr>
    </tbody>
</table>
</p>','1','1','会员修改密码保护答案时发送此邮件(完成)')
 
INSERT INTO Web_EmailContent VALUES ('3','您的好友向您推荐了一款商品','<p>您好：</p>
<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 您的好友{realname}&nbsp; 向您推荐了一个优秀的网站&nbsp;&nbsp;&nbsp; <a terget="_blank" href="http://192.168.1.100:6111/editor/%7Burl%7D/reg.asp?recommender={userid}">按此注册</a><br />
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 此邮件为系统自动发送，请勿回复，谢谢。如果给您带来不便&nbsp;敬请见谅！<br />
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{sitename}</p>','1','1','推荐商品时发送此邮件')
 
INSERT INTO Web_EmailContent VALUES ('4','您的新密码','<p>
<table cellspacing="0" cellpadding="0" width="100%" border="0">
    <tbody>
        <tr>
            <td height="25">尊敬的{user.Name}，您好：</td>
        </tr>
        <tr>
            <td height="25">您于{Const.SendTime}通过密码保护答案找回新密码，您的新登陆信息如下：</td>
        </tr>
        <tr>
            <td height="25">用户名：{user.Name}</td>
        </tr>
        <tr>
            <td height="25">新密码：{user.NewPassword}</td>
        </tr>
        <tr>
            <td height="25">请您及时登陆网站修改您的密码，为了您的帐户安全，请不要把帐户信息透漏给他人，建议您定期修改密码</td>
        </tr>
        <tr>
            <td height="25">您可以： <a target="_blank" href="{Const.SiteUrl}member/">登录会员中心 </a>&nbsp;&nbsp; <a target="_blank" href="{Const.SiteUrl}">访问{Const.SiteName}</a></td>
        </tr>
        <tr>
            <td height="25"></td>
        </tr>
        <tr>
            <td height="25"><strong>此邮件为系统自动发送 请勿回复，谢谢 给您带来的不便请见谅</strong></td>
        </tr>
        <tr>
            <td align="right" height="25">{Const.SendTime}</td>
        </tr>
        <tr>
            <td align="right" height="25">{Const.SiteName}</td>
        </tr>
    </tbody>
</table>
</p>','1','1','客户重设密码时发送此邮件')
 
INSERT INTO Web_EmailContent VALUES ('5','您的订单信息','<p>
<table style="text-align: center" cellspacing="0" cellpadding="0" width="80%" align="center" border="0">
    <tbody>
        <tr>
            <td align="left" colspan="4" height="25"><strong>尊敬的{order.SendName}：</strong></td>
        </tr>
        <tr>
            <td align="left" colspan="4" height="25"><strong><font color="#000000">感谢您在{Const.SiteName}购物。以下是您的订单信息：</font></strong></td>
        </tr>
        <tr>
            <td align="left" colspan="4" height="25">&nbsp;</td>
        </tr>
        <tr>
            <td style="border-right: #d5d8dd 1px solid; border-top: #d5d8dd 1px solid; border-left: #d5d8dd 1px solid; color: #000000; border-bottom: #d5d8dd 1px solid; height: 30px; background-color: #e4e6e9" align="left" colspan="4">　<b>● 配送/支付/费用信息</b></td>
        </tr>
        <tr>
            <td style="height: 30px" align="right" width="15%"><span id="Label8">配送方式：</span></td>
            <td style="height: 30px" align="left" width="35%">&nbsp;{order.Delivery}</td>
            <td style="height: 30px" align="right" width="15%"><span id="Label13">支付方式：</span></td>
            <td style="height: 30px" align="left" width="35%">&nbsp;{order.Payment}</td>
        </tr>
        <tr>
            <td style="height: 30px" align="right"><span id="Label10">配送费用：</span></td>
            <td style="height: 30px" align="left">&nbsp;{order.Fee}</td>
            <td style="height: 30px" align="right"><span id="Label33">发票费用：</span></td>
            <td style="height: 30px" align="left"><span id="lblSafePrice">￥{order.InvoicePrice}</span></td>
        </tr>
        <tr>
            <td style="height: 30px" align="right"><span id="Label18">贺卡费用：</span></td>
            <td style="height: 30px" align="left"><span id="lblProductPackage">￥{order.GreetingCardPrice}</span></td>
            <td style="height: 30px" align="right"><span id="Label20">包装费用：</span></td>
            <td style="height: 30px" align="left"><span id="lblProductPackagePrice">￥{order.ProductPackagePrice}</span></td>
        </tr>
        <tr>
            <td style="height: 30px" align="right"><span id="Label29">积分优惠：</span></td>
            <td style="height: 30px" align="left"><span id="lblProductPrice">￥{order.ScoreTradePrice}</span></td>
            <td style="height: 30px" align="right"><span id="Label31">使用积分：</span></td>
            <td style="height: 30px" align="left">{order.UsedScore}</td>
        </tr>
        <tr>
            <td style="height: 30px" align="right"><span id="Label29">优惠卷优惠：</span></td>
            <td style="height: 30px" align="left"><span id="lblProductPrice">￥{order.CouponTradePrice}</span></td>
            <td style="height: 30px" align="right"><span id="Label31">优惠卷号：</span></td>
            <td style="height: 30px" align="left">{order.CouponNumber}</td>
        </tr>
        <tr>
            <td style="height: 30px" align="right"><span id="Label29">商品总金额：</span></td>
            <td style="height: 30px" align="left"><span id="lblProductPrice">￥{order.NewProductPrice}</span></td>
            <td style="height: 30px" align="right"><span id="Label31">支付总金额：</span></td>
            <td style="height: 30px" align="left"><span id="lblPrice">￥{order.Price}</span></td>
        </tr>
        <tr>
            <td style="border-right: #d5d8dd 1px solid; border-top: #d5d8dd 1px solid; border-left: #d5d8dd 1px solid; color: #000000; border-bottom: #d5d8dd 1px solid; height: 30px; background-color: #e4e6e9" align="left" colspan="4">　<b>● 收货人信息</b></td>
        </tr>
        <tr>
            <td style="width: 15%; height: 30px" align="right"><span id="Label42">收货人姓名：</span></td>
            <td style="width: 35%; height: 30px" align="left">&nbsp;{order.ReceiveName}</td>
            <td style="width: 15%; height: 30px" align="right"><span id="Label45">E-Mail：</span></td>
            <td style="width: 35%; height: 30px" align="left">&nbsp;{order.SendEmail}</td>
        </tr>
        <tr>
            <td style="height: 30px" align="right"><span id="Label47">性别：</span></td>
            <td style="height: 30px" align="left">&nbsp;{order.ReceiveSex}</td>
            <td style="height: 30px" align="right"><span id="Label55">送货地址：</span></td>
            <td style="height: 30px" align="left">&nbsp;{order.ReceiveAddress}</td>
        </tr>
        <tr>
            <td style="height: 30px" align="right"><span id="Label44">联系电话：</span></td>
            <td style="height: 30px" align="left">&nbsp;{order.ReceiveTel}</td>
            <td style="height: 30px" align="right"><span id="Label58">邮编：</span></td>
            <td style="height: 30px" align="left">&nbsp;{order.ReceivePostCode}</td>
        </tr>
        <tr>
            <td style="height: 30px" align="right"><span id="Label46">手机：</span></td>
            <td style="height: 30px" align="left">&nbsp;{order.ReceiveMobile}</td>
            <td style="height: 30px" align="right"><span id="Label48">标志性建筑：</span></td>
            <td style="height: 30px" align="left"><span id="lblBuilding">{order.Building}</span></td>
        </tr>
        <tr>
            <td style="height: 30px" align="right"><span id="Label37">是否需要发票：</span></td>
            <td style="height: 30px" align="left">&nbsp;{order.IsInvoice}</td>
            <td style="height: 30px" align="right"><span id="Label37">发票抬头：</span></td>
            <td style="height: 30px" align="left">&nbsp;{order.InvoiceHead}</td>
        </tr>
        <tr>
            <td style="height: 30px" align="right"><span id="lblUserRemark">备注信息：</span></td>
            <td style="height: 30px" align="left" colspan="3">&nbsp;{order.Remark}</td>
        </tr>
        <tr>
            <td style="border-right: #d5d8dd 1px solid; border-top: #d5d8dd 1px solid; border-left: #d5d8dd 1px solid; color: #000000; border-bottom: #d5d8dd 1px solid; height: 30px; background-color: #e4e6e9" align="left" colspan="4">　<b>●&nbsp;购货人信息</b></td>
        </tr>
        <tr>
            <td style="width: 15%; height: 30px" align="right"><span id="Label42"><strong>&nbsp;</strong>购货人姓名：</span></td>
            <td style="width: 35%; height: 30px" align="left">&nbsp;{order.SendName}</td>
            <td style="width: 15%; height: 30px" align="right"><span id="Label45">购货人E-Mail：</span></td>
            <td style="width: 35%; height: 30px" align="left">&nbsp;{order.SendEmail}</td>
        </tr>
        <tr>
            <td style="height: 30px" align="right"><span id="Label44">购货人电话：</span></td>
            <td style="height: 30px" align="left">&nbsp;&nbsp;{order.ReceiveTel}</td>
            <td style="height: 30px" align="right"><span id="Label58">购货人手机：</span></td>
            <td style="height: 30px" align="left">{order.SendMobile}</td>
        </tr>
        <tr>
            <td style="border-right: #d5d8dd 1px solid; border-top: #d5d8dd 1px solid; border-left: #d5d8dd 1px solid; color: #000000; border-bottom: #d5d8dd 1px solid; height: 30px; background-color: #e4e6e9" align="left" colspan="4">　<b>● 其他信息</b></td>
        </tr>
        <tr>
            <td style="height: 30px" align="right"><span id="Label18">包装名称：</span></td>
            <td style="height: 30px" align="left">&nbsp;{order.ProductPackageID}</td>
            <td style="height: 30px" align="right"><span id="Label20">包装费用：</span></td>
            <td style="height: 30px" align="left">&nbsp;{order.ProductPackagePrice}</td>
        </tr>
        <tr>
            <td style="height: 30px" align="right"><span id="Label23">贺卡名称：</span></td>
            <td style="height: 30px" align="left">&nbsp;{order.GreetingCardID}</td>
            <td style="height: 30px" align="right"><span id="Label25">贺卡费用：</span></td>
            <td style="height: 30px" align="left">&nbsp;{order.GreetingCardPrice}</td>
        </tr>
        <tr>
            <td style="height: 30px" align="right"><span id="Label27">贺卡内容：</span></td>
            <td style="height: 30px" align="left" colspan="3">&nbsp;{order.GreetingCardInfomation}</td>
        </tr>
        <tr>
            <td style="height: 30px" align="right"></td>
            <td style="height: 30px" align="left" colspan="3">祝您购物愉快！</td>
        </tr>
        <tr>
            <td style="height: 30px" align="right" colspan="4">{Const.SiteName}</td>
        </tr>
        <tr>
            <td style="height: 30px" body=""></td>
        </tr>
    </tbody>
</table>
</p>','1','1','下单成功时发送此邮件')
 
INSERT INTO Web_EmailContent VALUES ('6','您的订单状态有更新','<table style="text-align: center" cellspacing="0" cellpadding="0" width="100%" align="center" border="0">
    <tbody>
        <tr>
            <td align="left" width="100%" height="25"><strong>亲爱的{order.SendName}，您好：</strong></td>
        </tr>
        <tr>
            <td align="left" height="25">您的订单号为：{order.Number}的状态于{Const.SendTime}有更新。</td>
        </tr>
        <tr>
            <td align="left" height="25">当前订单状态：{order.StatusID}</td>
        </tr>
        <tr>
            <td align="left" height="25">管理修改备注：{order.AdminRemark}</td>
        </tr>
        <tr>
            <td align="left" height="25">如有任何问题，请登陆网站（{Const.SiteUrl}）。和网站管理人员进行联系。</td>
        </tr>
        <tr>
            <td align="left" height="25">&nbsp;</td>
        </tr>
        <tr>
            <td align="left" height="25"><strong>此邮件为系统自动发送 请勿回复，谢谢 给您带来不便，敬请见谅！</strong></td>
        </tr>
        <tr>
            <td style="height: 30px" align="right">{Const.SiteName}</td>
        </tr>
        <tr>
            <td style="height: 30px" align="right">{Const.SendTime}</td>
        </tr>
    </tbody>
</table>','1','1','订单状态被更新时发送此邮件(完成)')
 
INSERT INTO Web_EmailContent VALUES ('7','您的发货信息','<p>
<table style="text-align: center" cellspacing="0" cellpadding="0" width="100%" align="center" border="0">
    <tbody>
        <tr>
            <td align="left" width="100%" height="25"><strong>亲爱的</strong>{shippingadvice.TrueName}，您好<strong>：</strong></td>
        </tr>
        <tr>
            <td align="left" height="25">您的订单号为：{shippingadvice.OrderNumber}的已经发货。发货信息如下</td>
        </tr>
        <tr>
            <td align="left" height="25">快递公司：{shippingadvice.ExpressCompany}</td>
        </tr>
        <tr>
            <td align="left" height="25">快递单号：{shippingadvice.ExpressNumber}</td>
        </tr>
        <tr>
            <td align="left" height="25">发货时间：{shippingadvice.SendDate}</td>
        </tr>
        <tr>
            <td align="left" height="25">发货备注：{shippingadvice.Remark}</td>
        </tr>
        <tr>
            <td align="left" height="25">请您注意查收您的货品。温馨提示：查收物品时，请检查包装是否完整。如果有任何产品质量问题，请及时登陆网站()与我们联系。</td>
        </tr>
        <tr>
            <td align="left" height="25">&nbsp;</td>
        </tr>
        <tr>
            <td align="left" height="25"><strong>此邮件为系统自动发送 请勿回复，谢谢 给您带来不便，敬请见谅！</strong></td>
        </tr>
        <tr>
            <td style="height: 30px" align="right">{Const.SiteName}</td>
        </tr>
        <tr>
            <td style="height: 30px" align="right">{Const.SendTime}</td>
        </tr>
    </tbody>
</table>
</p>','1','1','填写发发货通知时发送（完成）')
 
INSERT INTO Web_EmailContent VALUES ('8','您登记的缺货信息已处理','<p>
<table style="text-align: center" cellspacing="0" cellpadding="0" width="100%" align="center" border="0">
    <tbody>
        <tr>
            <td align="left" width="100%" height="25"><strong>尊敬的{outstock.TrueName}：</strong></td>
        </tr>
        <tr>
            <td align="left" height="25">您于{outstock.Date}登记的缺货信息已经处理。处理详情如下：</td>
        </tr>
        <tr>
            <td align="left" height="25">处理人：{outstock.DealName}</td>
        </tr>
        <tr>
            <td align="left" height="25">处理时间：{outstock.DealDate}</td>
        </tr>
        <tr>
            <td align="left" height="25">处理备注：{outstock.DealRemark}</td>
        </tr>
        <tr>
            <td align="left" height="25">&nbsp;</td>
        </tr>
        <tr>
            <td align="left" height="25">以下是您的登记信息：</td>
        </tr>
        <tr>
            <td align="left" height="25">登记商品：{outstock.ProductName}&nbsp;<a target="_blank" href="{Const.SiteUrl}product.aspx?id={outstock.ProductID}">浏览</a></td>
        </tr>
        <tr>
            <td align="left" height="25">需要数量：{outstock.Count}</td>
        </tr>
        <tr>
            <td align="left" height="25">最晚到货时间：{outstock.LatestDate}</td>
        </tr>
        <tr>
            <td align="left" height="25">感谢您对的{Const.SiteName}关注。祝您购物愉快！</td>
        </tr>
        <tr>
            <td align="left" height="25">&nbsp;</td>
        </tr>
        <tr>
            <td align="left" height="25"><strong>此邮件为系统自动发送 请勿回复，谢谢 给您带来不便，敬请见谅！</strong></td>
        </tr>
        <tr>
            <td style="height: 30px" align="right">{Const.SiteName}</td>
        </tr>
        <tr>
            <td style="height: 30px" align="right">{Const.SendTime}</td>
        </tr>
    </tbody>
</table>
</p>','1','1','处理缺货登记时发送此邮件(完成)')
 
INSERT INTO Web_EmailContent VALUES ('9','邮件订阅确认','预留','1','1','预留')
 
INSERT INTO Web_EmailContent VALUES ('10','虚拟卡信息','预留','1','1','预留')
 
INSERT INTO Web_EmailContent VALUES ('11','预留','预留','1','1','预留')
 
INSERT INTO Web_EmailContent VALUES ('12','预留','预留','1','1','预留')
 
CREATE TABLE dbo.Tmp_Web_EmailContent([Id] [int]  NOT NULL IDENTITY (1, 1),[Title] [nvarchar] (50)  NULL,[Content] [ntext]  NULL,[IsAct] [int]  NOT NULL,[EmailCategoryID] [int]  NOT NULL,[Description] [nvarchar] (250)  NULL)  ON [PRIMARY] 
 
SET IDENTITY_INSERT dbo.Tmp_Web_EmailContent ON
 
IF EXISTS(SELECT * FROM dbo.Web_EmailContent) EXEC('INSERT INTO dbo.Tmp_Web_EmailContent ([Id],[Title],[Content],[IsAct],[EmailCategoryID],[Description]) SELECT [Id],[Title],[Content],[IsAct],[EmailCategoryID],[Description] FROM dbo.Web_EmailContent WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_EmailContent OFF
 
DROP TABLE dbo.Web_EmailContent
 
EXECUTE sp_rename N'dbo.Tmp_Web_EmailContent', N'Web_EmailContent', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_VirtualCard]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_VirtualCard] 
 
CREATE TABLE dbo.Web_VirtualCard([ID] [int]  NOT NULL,[ProductID] [int]  NOT NULL,[Number] [nvarchar] (50)  NULL,[Password] [nvarchar] (50)  NULL,[Date] [datetime]  NOT NULL,[OrderNumber] [nvarchar] (50)  NULL,[PrivateKey] [nvarchar] (50)  NULL,[IsSold] [int]  NOT NULL,[Extend] [nvarchar] (50)  NULL,[SoldDate] [datetime]  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_VirtualCard ADD CONSTRAINT DF_Web_VirtualCard_ProductID DEFAULT ((0)) FOR [ProductID]
 
ALTER TABLE dbo.Web_VirtualCard ADD CONSTRAINT DF_Web_VirtualCard_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Web_VirtualCard ADD CONSTRAINT DF_Web_VirtualCard_IsSold DEFAULT ((0)) FOR [IsSold]
 
CREATE TABLE dbo.Tmp_Web_VirtualCard([ID] [int]  NOT NULL IDENTITY (1, 1),[ProductID] [int]  NOT NULL,[Number] [nvarchar] (50)  NULL,[Password] [nvarchar] (50)  NULL,[Date] [datetime]  NOT NULL,[OrderNumber] [nvarchar] (50)  NULL,[PrivateKey] [nvarchar] (50)  NULL,[IsSold] [int]  NOT NULL,[Extend] [nvarchar] (50)  NULL,[SoldDate] [datetime]  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_VirtualCard ADD CONSTRAINT DF_Tmp_Web_VirtualCard_ProductID DEFAULT ((0)) FOR [ProductID]
 
ALTER TABLE dbo.Tmp_Web_VirtualCard ADD CONSTRAINT DF_Tmp_Web_VirtualCard_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Tmp_Web_VirtualCard ADD CONSTRAINT DF_Tmp_Web_VirtualCard_IsSold DEFAULT ((0)) FOR [IsSold]
 
SET IDENTITY_INSERT dbo.Tmp_Web_VirtualCard ON
 
IF EXISTS(SELECT * FROM dbo.Web_VirtualCard) EXEC('INSERT INTO dbo.Tmp_Web_VirtualCard ([ID],[ProductID],[Number],[Password],[Date],[OrderNumber],[PrivateKey],[IsSold],[Extend],[SoldDate]) SELECT [ID],[ProductID],[Number],[Password],[Date],[OrderNumber],[PrivateKey],[IsSold],[Extend],[SoldDate] FROM dbo.Web_VirtualCard WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_VirtualCard OFF
 
DROP TABLE dbo.Web_VirtualCard
 
EXECUTE sp_rename N'dbo.Tmp_Web_VirtualCard', N'Web_VirtualCard', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_UserRegFields]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_UserRegFields] 
 
CREATE TABLE dbo.Web_UserRegFields([ID] [int]  NOT NULL,[FieldName] [nvarchar] (50)  NULL,[Keyword] [nvarchar] (50)  NULL,[OrderID] [int]  NULL,[IsNeed] [int]  NULL,[InputType] [int]  NULL,[InputValue] [nvarchar] (250)  NULL,[IsSystem] [int]  NULL,[Description] [nvarchar] (150)  NULL,[IsShow] [int]  NULL)  ON [PRIMARY] 
 
INSERT INTO Web_UserRegFields VALUES ('1','用户名','username','3','2','0','','1','用户名在2~16字符之间。','1')
 
INSERT INTO Web_UserRegFields VALUES ('2','用户密码','password','4','2','0','','1','长度必须大于6个字符。','1')
 
INSERT INTO Web_UserRegFields VALUES ('3','确认密码','password1','5','2','0','','1','请重新输入您的密码','1')
 
INSERT INTO Web_UserRegFields VALUES ('4','性 别','rblSex','6','0','2','男|女|保密','1','','0')
 
INSERT INTO Web_UserRegFields VALUES ('5','真实姓名','txtTrueName','7','1','0','','1','收货人姓名。','0')
 
INSERT INTO Web_UserRegFields VALUES ('6','E - mail','txtEmail','8','2','0','','1','请您务必填写正确的E-mail地址，便于我们与您联系； ','1')
 
INSERT INTO Web_UserRegFields VALUES ('7','身份证号','txtIdentityCard','9','0','0','','1','此项信息用于必要时以核实身份,不可更改, 请如实填写','0')
 
INSERT INTO Web_UserRegFields VALUES ('8','联系地址','txtAddress','10','1','0','','1',NULL,'1')
 
INSERT INTO Web_UserRegFields VALUES ('9','联系电话','txtTelephone','11','1','0','','1','请填写正确的号码，以便有急事联系。','1')
 
INSERT INTO Web_UserRegFields VALUES ('10','QQ号码','txtQQ','12','0','0','','1','在线联系方式','0')
 
INSERT INTO Web_UserRegFields VALUES ('11','推荐人','txtCommendUser','13','1','0','','1','如有推荐人请填写您推荐人的用户名，没有则为空','1')
 
INSERT INTO Web_UserRegFields VALUES ('12','保护问题','txtQuestion','14','1','4','我的姓名？|我爱人的姓名？|我的生日？','1',NULL,'1')
 
INSERT INTO Web_UserRegFields VALUES ('13','保护答案','txtAnswer','15','1','0','','1',NULL,'1')
 
CREATE TABLE dbo.Tmp_Web_UserRegFields([ID] [int]  NOT NULL IDENTITY (1, 1),[FieldName] [nvarchar] (50)  NULL,[Keyword] [nvarchar] (50)  NULL,[OrderID] [int]  NULL,[IsNeed] [int]  NULL,[InputType] [int]  NULL,[InputValue] [nvarchar] (250)  NULL,[IsSystem] [int]  NULL,[Description] [nvarchar] (150)  NULL,[IsShow] [int]  NULL)  ON [PRIMARY] 
 
SET IDENTITY_INSERT dbo.Tmp_Web_UserRegFields ON
 
IF EXISTS(SELECT * FROM dbo.Web_UserRegFields) EXEC('INSERT INTO dbo.Tmp_Web_UserRegFields ([ID],[FieldName],[Keyword],[OrderID],[IsNeed],[InputType],[InputValue],[IsSystem],[Description],[IsShow]) SELECT [ID],[FieldName],[Keyword],[OrderID],[IsNeed],[InputType],[InputValue],[IsSystem],[Description],[IsShow] FROM dbo.Web_UserRegFields WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_UserRegFields OFF
 
DROP TABLE dbo.Web_UserRegFields
 
EXECUTE sp_rename N'dbo.Tmp_Web_UserRegFields', N'Web_UserRegFields', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Article]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Article] 
 
CREATE TABLE dbo.Web_Article([ID] [int]  NOT NULL,[ShortContent] [nvarchar] (255)  NOT NULL,[Content] [ntext]  NULL,[Auther] [nvarchar] (255)  NOT NULL,[Source] [nvarchar] (255)  NOT NULL,[Hits] [int]  NOT NULL,[CategoryID] [int]  NOT NULL,[CategoryFamily] [nvarchar] (255)  NOT NULL,[SrcList] [nvarchar] (255)  NOT NULL,[IsShow] [int]  NOT NULL,[IsTop] [int]  NOT NULL,[IsComments] [int]  NOT NULL,[SearchKey] [nvarchar] (255)  NOT NULL,[Date] [datetime]  NOT NULL,[Keywords] [nvarchar] (255)  NOT NULL,[Description] [nvarchar] (255)  NOT NULL,[Title] [nvarchar] (255)  NOT NULL,[Type] [int]  NOT NULL,[ArticleReview] [nvarchar] (250)  NOT NULL,[ArticlePropertyCode] [nvarchar] (50)  NOT NULL,[OrderID] [int]  NOT NULL,[catename] [nvarchar] (50)  NOT NULL,[Url] [nvarchar] (250)  NOT NULL,[IsImageArticle] [int]  NOT NULL,[UserGroupAttachementID] [nvarchar] (250)  NOT NULL,[ReviewCount] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Article ADD CONSTRAINT DF_Web_Article_ShortContent DEFAULT ('') FOR [ShortContent]
 
ALTER TABLE dbo.Web_Article ADD CONSTRAINT DF_Web_Article_Auther DEFAULT ('') FOR [Auther]
 
ALTER TABLE dbo.Web_Article ADD CONSTRAINT DF_Web_Article_Source DEFAULT ('') FOR [Source]
 
ALTER TABLE dbo.Web_Article ADD CONSTRAINT DF_Web_Article_Hits DEFAULT ((0)) FOR [Hits]
 
ALTER TABLE dbo.Web_Article ADD CONSTRAINT DF_Web_Article_CategoryID DEFAULT ((0)) FOR [CategoryID]
 
ALTER TABLE dbo.Web_Article ADD CONSTRAINT DF_Web_Article_CategoryFamily DEFAULT ('') FOR [CategoryFamily]
 
ALTER TABLE dbo.Web_Article ADD CONSTRAINT DF_Web_Article_IsShow DEFAULT ((0)) FOR [IsShow]
 
ALTER TABLE dbo.Web_Article ADD CONSTRAINT DF_Web_Article_IsTop DEFAULT ((0)) FOR [IsTop]
 
ALTER TABLE dbo.Web_Article ADD CONSTRAINT DF_Web_Article_IsComments DEFAULT ((1)) FOR [IsComments]
 
ALTER TABLE dbo.Web_Article ADD CONSTRAINT DF_Web_Article_SearchKey DEFAULT ('') FOR [SearchKey]
 
ALTER TABLE dbo.Web_Article ADD CONSTRAINT DF_Web_Article_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Web_Article ADD CONSTRAINT DF_Web_Article_Keywords DEFAULT ('') FOR [Keywords]
 
ALTER TABLE dbo.Web_Article ADD CONSTRAINT DF_Web_Article_Description DEFAULT ('') FOR [Description]
 
ALTER TABLE dbo.Web_Article ADD CONSTRAINT DF_Web_Article_Title DEFAULT ('') FOR [Title]
 
ALTER TABLE dbo.Web_Article ADD CONSTRAINT DF_Web_Article_Type DEFAULT ((0)) FOR [Type]
 
ALTER TABLE dbo.Web_Article ADD CONSTRAINT DF_Web_Article_ArticleReview DEFAULT ('') FOR [ArticleReview]
 
ALTER TABLE dbo.Web_Article ADD CONSTRAINT DF_Web_Article_ArticlePropertyCode DEFAULT ('0') FOR [ArticlePropertyCode]
 
ALTER TABLE dbo.Web_Article ADD CONSTRAINT DF_Web_Article_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Web_Article ADD CONSTRAINT DF_Web_Article_catename DEFAULT ('') FOR [catename]
 
ALTER TABLE dbo.Web_Article ADD CONSTRAINT DF_Web_Article_Url DEFAULT ('') FOR [Url]
 
ALTER TABLE dbo.Web_Article ADD CONSTRAINT DF_Web_Article_IsImageArticle DEFAULT ((0)) FOR [IsImageArticle]
 
ALTER TABLE dbo.Web_Article ADD CONSTRAINT DF_Web_Article_UserGroupAttachementID DEFAULT ('') FOR [UserGroupAttachementID]
 
ALTER TABLE dbo.Web_Article ADD CONSTRAINT DF_Web_Article_ReviewCount DEFAULT ((0)) FOR [ReviewCount]
 
CREATE TABLE dbo.Tmp_Web_Article([ID] [int]  NOT NULL IDENTITY (1, 1),[ShortContent] [nvarchar] (255)  NOT NULL,[Content] [ntext]  NULL,[Auther] [nvarchar] (255)  NOT NULL,[Source] [nvarchar] (255)  NOT NULL,[Hits] [int]  NOT NULL,[CategoryID] [int]  NOT NULL,[CategoryFamily] [nvarchar] (255)  NOT NULL,[SrcList] [nvarchar] (255)  NOT NULL,[IsShow] [int]  NOT NULL,[IsTop] [int]  NOT NULL,[IsComments] [int]  NOT NULL,[SearchKey] [nvarchar] (255)  NOT NULL,[Date] [datetime]  NOT NULL,[Keywords] [nvarchar] (255)  NOT NULL,[Description] [nvarchar] (255)  NOT NULL,[Title] [nvarchar] (255)  NOT NULL,[Type] [int]  NOT NULL,[ArticleReview] [nvarchar] (250)  NOT NULL,[ArticlePropertyCode] [nvarchar] (50)  NOT NULL,[OrderID] [int]  NOT NULL,[catename] [nvarchar] (50)  NOT NULL,[Url] [nvarchar] (250)  NOT NULL,[IsImageArticle] [int]  NOT NULL,[UserGroupAttachementID] [nvarchar] (250)  NOT NULL,[ReviewCount] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_Article ADD CONSTRAINT DF_Tmp_Web_Article_ShortContent DEFAULT ('') FOR [ShortContent]
 
ALTER TABLE dbo.Tmp_Web_Article ADD CONSTRAINT DF_Tmp_Web_Article_Auther DEFAULT ('') FOR [Auther]
 
ALTER TABLE dbo.Tmp_Web_Article ADD CONSTRAINT DF_Tmp_Web_Article_Source DEFAULT ('') FOR [Source]
 
ALTER TABLE dbo.Tmp_Web_Article ADD CONSTRAINT DF_Tmp_Web_Article_Hits DEFAULT ((0)) FOR [Hits]
 
ALTER TABLE dbo.Tmp_Web_Article ADD CONSTRAINT DF_Tmp_Web_Article_CategoryID DEFAULT ((0)) FOR [CategoryID]
 
ALTER TABLE dbo.Tmp_Web_Article ADD CONSTRAINT DF_Tmp_Web_Article_CategoryFamily DEFAULT ('') FOR [CategoryFamily]
 
ALTER TABLE dbo.Tmp_Web_Article ADD CONSTRAINT DF_Tmp_Web_Article_IsShow DEFAULT ((0)) FOR [IsShow]
 
ALTER TABLE dbo.Tmp_Web_Article ADD CONSTRAINT DF_Tmp_Web_Article_IsTop DEFAULT ((0)) FOR [IsTop]
 
ALTER TABLE dbo.Tmp_Web_Article ADD CONSTRAINT DF_Tmp_Web_Article_IsComments DEFAULT ((1)) FOR [IsComments]
 
ALTER TABLE dbo.Tmp_Web_Article ADD CONSTRAINT DF_Tmp_Web_Article_SearchKey DEFAULT ('') FOR [SearchKey]
 
ALTER TABLE dbo.Tmp_Web_Article ADD CONSTRAINT DF_Tmp_Web_Article_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Tmp_Web_Article ADD CONSTRAINT DF_Tmp_Web_Article_Keywords DEFAULT ('') FOR [Keywords]
 
ALTER TABLE dbo.Tmp_Web_Article ADD CONSTRAINT DF_Tmp_Web_Article_Description DEFAULT ('') FOR [Description]
 
ALTER TABLE dbo.Tmp_Web_Article ADD CONSTRAINT DF_Tmp_Web_Article_Title DEFAULT ('') FOR [Title]
 
ALTER TABLE dbo.Tmp_Web_Article ADD CONSTRAINT DF_Tmp_Web_Article_Type DEFAULT ((0)) FOR [Type]
 
ALTER TABLE dbo.Tmp_Web_Article ADD CONSTRAINT DF_Tmp_Web_Article_ArticleReview DEFAULT ('') FOR [ArticleReview]
 
ALTER TABLE dbo.Tmp_Web_Article ADD CONSTRAINT DF_Tmp_Web_Article_ArticlePropertyCode DEFAULT ('0') FOR [ArticlePropertyCode]
 
ALTER TABLE dbo.Tmp_Web_Article ADD CONSTRAINT DF_Tmp_Web_Article_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Tmp_Web_Article ADD CONSTRAINT DF_Tmp_Web_Article_catename DEFAULT ('') FOR [catename]
 
ALTER TABLE dbo.Tmp_Web_Article ADD CONSTRAINT DF_Tmp_Web_Article_Url DEFAULT ('') FOR [Url]
 
ALTER TABLE dbo.Tmp_Web_Article ADD CONSTRAINT DF_Tmp_Web_Article_IsImageArticle DEFAULT ((0)) FOR [IsImageArticle]
 
ALTER TABLE dbo.Tmp_Web_Article ADD CONSTRAINT DF_Tmp_Web_Article_UserGroupAttachementID DEFAULT ('') FOR [UserGroupAttachementID]
 
ALTER TABLE dbo.Tmp_Web_Article ADD CONSTRAINT DF_Tmp_Web_Article_ReviewCount DEFAULT ((0)) FOR [ReviewCount]
 
SET IDENTITY_INSERT dbo.Tmp_Web_Article ON
 
IF EXISTS(SELECT * FROM dbo.Web_Article) EXEC('INSERT INTO dbo.Tmp_Web_Article ([ID],[ShortContent],[Content],[Auther],[Source],[Hits],[CategoryID],[CategoryFamily],[SrcList],[IsShow],[IsTop],[IsComments],[SearchKey],[Date],[Keywords],[Description],[Title],[Type],[ArticleReview],[ArticlePropertyCode],[OrderID],[catename],[Url],[IsImageArticle],[UserGroupAttachementID],[ReviewCount]) SELECT [ID],[ShortContent],[Content],[Auther],[Source],[Hits],[CategoryID],[CategoryFamily],[SrcList],[IsShow],[IsTop],[IsComments],[SearchKey],[Date],[Keywords],[Description],[Title],[Type],[ArticleReview],[ArticlePropertyCode],[OrderID],[catename],[Url],[IsImageArticle],[UserGroupAttachementID],[ReviewCount] FROM dbo.Web_Article WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Article OFF
 
DROP TABLE dbo.Web_Article
 
EXECUTE sp_rename N'dbo.Tmp_Web_Article', N'Web_Article', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_ProductType]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_ProductType] 
 
CREATE TABLE dbo.Web_ProductType([ID] [int]  NOT NULL,[Name] [nvarchar] (50)  NULL,[OrderId] [int]  NOT NULL)  ON [PRIMARY] 
 
CREATE TABLE dbo.Tmp_Web_ProductType([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NULL,[OrderId] [int]  NOT NULL)  ON [PRIMARY] 
 
SET IDENTITY_INSERT dbo.Tmp_Web_ProductType ON
 
IF EXISTS(SELECT * FROM dbo.Web_ProductType) EXEC('INSERT INTO dbo.Tmp_Web_ProductType ([ID],[Name],[OrderId]) SELECT [ID],[Name],[OrderId] FROM dbo.Web_ProductType WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_ProductType OFF
 
DROP TABLE dbo.Web_ProductType
 
EXECUTE sp_rename N'dbo.Tmp_Web_ProductType', N'Web_ProductType', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_ProductDetail]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_ProductDetail] 
 
CREATE TABLE dbo.Web_ProductDetail([ID] [int]  NOT NULL,[ProductID] [int]  NOT NULL,[Number] [nvarchar] (50)  NULL,[Storage] [int]  NOT NULL,[Propertys] [nvarchar] (250)  NULL,[IsDefault] [int]  NOT NULL,[IsValid] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_ProductDetail ADD CONSTRAINT DF_Web_ProductDetail_ProductID DEFAULT ((0)) FOR [ProductID]
 
ALTER TABLE dbo.Web_ProductDetail ADD CONSTRAINT DF_Web_ProductDetail_Storage DEFAULT ((0)) FOR [Storage]
 
CREATE TABLE dbo.Tmp_Web_ProductDetail([ID] [int]  NOT NULL IDENTITY (1, 1),[ProductID] [int]  NOT NULL,[Number] [nvarchar] (50)  NULL,[Storage] [int]  NOT NULL,[Propertys] [nvarchar] (250)  NULL,[IsDefault] [int]  NOT NULL,[IsValid] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_ProductDetail ADD CONSTRAINT DF_Tmp_Web_ProductDetail_ProductID DEFAULT ((0)) FOR [ProductID]
 
ALTER TABLE dbo.Tmp_Web_ProductDetail ADD CONSTRAINT DF_Tmp_Web_ProductDetail_Storage DEFAULT ((0)) FOR [Storage]
 
SET IDENTITY_INSERT dbo.Tmp_Web_ProductDetail ON
 
IF EXISTS(SELECT * FROM dbo.Web_ProductDetail) EXEC('INSERT INTO dbo.Tmp_Web_ProductDetail ([ID],[ProductID],[Number],[Storage],[Propertys],[IsDefault],[IsValid]) SELECT [ID],[ProductID],[Number],[Storage],[Propertys],[IsDefault],[IsValid] FROM dbo.Web_ProductDetail WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_ProductDetail OFF
 
DROP TABLE dbo.Web_ProductDetail
 
EXECUTE sp_rename N'dbo.Tmp_Web_ProductDetail', N'Web_ProductDetail', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Department]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Department] 
 
CREATE TABLE dbo.Web_Department([ID] [int]  NOT NULL,[Name] [nvarchar] (50)  NULL,[ShortName] [nvarchar] (50)  NULL,[CreateDate] [datetime]  NOT NULL,[IsDel] [int]  NOT NULL,[Creator] [nvarchar] (50)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Department ADD CONSTRAINT DF_Web_Department_CreateDate DEFAULT (getdate()) FOR [CreateDate]
 
ALTER TABLE dbo.Web_Department ADD CONSTRAINT DF_Web_Department_IsDel DEFAULT ((0)) FOR [IsDel]
 
INSERT INTO Web_Department VALUES ('1','IT部','IT部','2008-8-27 11:09:55','0','登录用户的姓名')
 
CREATE TABLE dbo.Tmp_Web_Department([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NULL,[ShortName] [nvarchar] (50)  NULL,[CreateDate] [datetime]  NOT NULL,[IsDel] [int]  NOT NULL,[Creator] [nvarchar] (50)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_Department ADD CONSTRAINT DF_Tmp_Web_Department_CreateDate DEFAULT (getdate()) FOR [CreateDate]
 
ALTER TABLE dbo.Tmp_Web_Department ADD CONSTRAINT DF_Tmp_Web_Department_IsDel DEFAULT ((0)) FOR [IsDel]
 
SET IDENTITY_INSERT dbo.Tmp_Web_Department ON
 
IF EXISTS(SELECT * FROM dbo.Web_Department) EXEC('INSERT INTO dbo.Tmp_Web_Department ([ID],[Name],[ShortName],[CreateDate],[IsDel],[Creator]) SELECT [ID],[Name],[ShortName],[CreateDate],[IsDel],[Creator] FROM dbo.Web_Department WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Department OFF
 
DROP TABLE dbo.Web_Department
 
EXECUTE sp_rename N'dbo.Tmp_Web_Department', N'Web_Department', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Ads]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Ads] 
 
CREATE TABLE dbo.Web_Ads([ID] [int]  NOT NULL,[Name] [nvarchar] (50)  NULL,[Src] [nvarchar] (250)  NULL,[Href] [nvarchar] (250)  NULL,[HrefNote] [nvarchar] (250)  NULL,[Mark] [uniqueidentifier]  NOT NULL,[StartDate] [datetime]  NULL,[EndDate] [datetime]  NULL,[PicWidth] [int]  NOT NULL,[PicHeight] [int]  NOT NULL,[Hits] [int]  NOT NULL,[OrderID] [int]  NOT NULL,[TemplatePath] [nvarchar] (250)  NULL,[IsDel] [int]  NOT NULL,[IsAct] [int]  NOT NULL,[Remark] [nvarchar] (150)  NULL,[CategoryID] [int]  NOT NULL,[AdsType] [nvarchar] (50)  NOT NULL,[QueryArray] [nvarchar] (1000)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Ads ADD CONSTRAINT DF_Web_Ads_Mark DEFAULT (newid()) FOR [Mark]
 
ALTER TABLE dbo.Web_Ads ADD CONSTRAINT DF_Web_Ads_StartDate DEFAULT (getdate()) FOR [StartDate]
 
ALTER TABLE dbo.Web_Ads ADD CONSTRAINT DF_Web_Ads_EndDate DEFAULT (getdate()) FOR [EndDate]
 
ALTER TABLE dbo.Web_Ads ADD CONSTRAINT DF_Web_Ads_PicWidth DEFAULT ((0)) FOR [PicWidth]
 
ALTER TABLE dbo.Web_Ads ADD CONSTRAINT DF_Web_Ads_PicHeight DEFAULT ((0)) FOR [PicHeight]
 
ALTER TABLE dbo.Web_Ads ADD CONSTRAINT DF_Web_Ads_Hits DEFAULT ((0)) FOR [Hits]
 
ALTER TABLE dbo.Web_Ads ADD CONSTRAINT DF_Web_Ads_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Web_Ads ADD CONSTRAINT DF_Web_Ads_IsDel DEFAULT ((0)) FOR [IsDel]
 
ALTER TABLE dbo.Web_Ads ADD CONSTRAINT DF_Web_Ads_IsAct DEFAULT ((0)) FOR [IsAct]
 
ALTER TABLE dbo.Web_Ads ADD CONSTRAINT DF_Web_Ads_CategoryID DEFAULT ((0)) FOR [CategoryID]
 
ALTER TABLE dbo.Web_Ads ADD CONSTRAINT DF_Web_Ads_AdsType DEFAULT ((0)) FOR [AdsType]
 
INSERT INTO Web_Ads VALUES ('1','skin1_文章广告6',NULL,NULL,NULL,'1b711fd9-4c7c-4efd-9a1e-29c9f9c36c82','2008-10-22 15:30:14','2108-10-22 0:00:00','250','205','0','1000','default','0','0','','0','普通广告','Images/AD/ad18.gif,http://www.021web.com.cn,')
 
INSERT INTO Web_Ads VALUES ('2','skin1_文章广告5',NULL,NULL,NULL,'e5ab45ab-46f1-4362-ac29-dd707d7af07d','2008-10-22 15:30:14','2108-10-22 0:00:00','176','125','0','1000','default','0','0','','0','普通广告','Images/AD/ad16.gif,http://www.021web.com.cn,')
 
INSERT INTO Web_Ads VALUES ('3','skin1_文章广告4',NULL,NULL,NULL,'6657f405-3b5a-4453-9dd2-ff81ce95601e','2008-10-22 15:30:14','2108-10-22 0:00:00','176','125','0','1000','default','0','0','','0','普通广告','Images/AD/ad17.gif,http://www.021web.com.cn,')
 
INSERT INTO Web_Ads VALUES ('4','skin1_文章广告3',NULL,NULL,NULL,'2559da2b-7737-493c-a106-fa344199d17a','2008-10-22 15:30:14','2108-10-22 0:00:00','176','125','0','1000','default','0','0','','0','普通广告','Images/AD/ad16.gif,http://www.021web.com.cn,')
 
INSERT INTO Web_Ads VALUES ('5','skin1_文章广告1',NULL,NULL,NULL,'d88c7791-6eb4-4c62-9d67-b5afa059a2c8','2008-10-22 15:30:14','2108-10-22 0:00:00','200','100','0','1000','default','0','0','','0','普通广告','Images//ad14.gif,http://www.v5shop.com.cn,')
 
INSERT INTO Web_Ads VALUES ('6','skin1_文章幻灯片',NULL,NULL,NULL,'cb161284-4eb3-4884-83d7-8e0ca6c92b02','2008-10-22 15:30:14','2108-10-22 0:00:00','250','258','0','1000','default','0','0','','0','FLASH轮换广告','Images//banner4a.jpg,http://192.168.1.186/V5Shop/article.aspx?id=223,,Images//banner4b.jpg,http://192.168.1.186/V5Shop/article.aspx?id=214,banner4b,Images//banner4c.jpg,http://192.168.1.186/V5Shop/article.aspx?id=213,banner4c,Images//banner4d.jpg,http://192.168.1.186/V5Shop/article.aspx?id=200,banner4d,Images//banner4e.jpg,http://192.168.1.186/V5Shop/article.aspx?id=160,banner4e,Images//banner4f.jpg,http://192.168.1.186/V5Shop/article.aspx?id=155,banner4f')
 
INSERT INTO Web_Ads VALUES ('7','skin1_注册广告2',NULL,NULL,NULL,'5adab5b9-92d1-472b-a59e-5c6cc0223f1c','2008-10-22 15:30:14','2108-10-22 0:00:00','152','59','0','1000','default','0','0','','0','普通广告','Images/AD/vproad.gif,../register.aspx,')
 
INSERT INTO Web_Ads VALUES ('8','skin1_栏目广告1',NULL,NULL,NULL,'5b22b32e-ed04-425d-aa08-0fbd84f29536','2008-10-22 15:30:14','2108-10-22 0:00:00','512','80','0','1000','default','0','0','','0','普通广告','Images//brandbanner.gif,http://www.v5shop.com.cn,')
 
INSERT INTO Web_Ads VALUES ('9','skin1_注册广告1',NULL,NULL,NULL,'2136c243-936e-47c6-9aa6-b9643cbc358d','2008-10-22 15:30:14','2108-10-22 0:00:00','176','120','0','1000','default','0','0','','0','普通广告','Images//ad14.gif,../register.aspx,')
 
INSERT INTO Web_Ads VALUES ('10','skin1_底部广告',NULL,NULL,NULL,'e598f294-5d0a-4b1f-833d-fa8ecd2016bf','2008-10-22 15:30:14','2108-10-22 0:00:00','920','120','0','1000','default','0','0','','0','普通广告','Images/AD/ad15.gif,http://www.v5shop.com.cn,')
 
INSERT INTO Web_Ads VALUES ('11','skin1_品牌广告2',NULL,NULL,NULL,'5eb9e4c3-04fd-4332-855c-e257ac160025','2008-10-22 15:30:14','2108-10-22 0:00:00','176','206','0','1000','default','0','0','','0','普通广告','Images/AD/ad12.gif,http://www.v5shop.com.cn,')
 
INSERT INTO Web_Ads VALUES ('12','skin1_品牌广告1',NULL,NULL,NULL,'f457f8fd-f7ea-4c9d-8f34-73b277bdeee0','2008-10-22 15:30:14','2108-10-22 0:00:00','176','206','0','1000','default','0','0','','0','普通广告','Images/AD/ad11.gif,http://www.v5shop.com.cn,')
 
INSERT INTO Web_Ads VALUES ('13','skin1_品牌广告3',NULL,NULL,NULL,'d0f0528b-c628-4201-b589-23a2d0bcffb3','2008-10-22 15:30:14','2108-10-22 0:00:00','920','170','0','1000','default','0','0','','0','普通广告','Images/AD/ad13.gif,http://www.v5shop.com.cn,')
 
INSERT INTO Web_Ads VALUES ('14','skin1_购物广告2',NULL,NULL,NULL,'59ae6ce2-bf79-4e7f-9a0f-df2d6e788ba1','2008-10-22 15:30:14','2108-10-22 0:00:00','204','260','0','1000','default','0','0','','0','普通广告','Images/AD/ad7b.gif,http://www.v5shop.com.cn,')
 
INSERT INTO Web_Ads VALUES ('15','skin1_购物广告1',NULL,NULL,NULL,'c88c3c68-4d28-49d6-a8c4-fe0af9e82fb6','2008-10-22 15:30:14','2108-10-22 0:00:00','199','260','0','1000','default','0','0','','0','普通广告','Images/AD/ad7.gif,http://www.v5shop.com.cn,')
 
INSERT INTO Web_Ads VALUES ('16','skin1_购物广告3',NULL,NULL,NULL,'2e7c0d6d-9a86-4de9-acdf-826c90aaeb6f','2008-10-22 15:30:14','2108-10-22 0:00:00','413','172','0','1000','default','0','0','','0','普通广告','Images/AD/ad8.gif,http://www.v5shop.com.cn,')
 
INSERT INTO Web_Ads VALUES ('17','skin1_购物banner',NULL,NULL,NULL,'5fdc4c50-9d21-4a4b-90d1-9a8771d28513','2008-10-22 15:30:15','2108-10-22 0:00:00','310','440','0','1000','default','0','0','购物首页幻灯片','0','FLASH轮换广告','Images/banner/banner3a.jpg,http://www.v5shop.com.cn,,Images/banner/banner3d.jpg,http://www.v5shop.com.cn,banner3d,Images/banner/banner3b.jpg,http://www.v5shop.com.cn,banner3b,Images/banner/banner3e.jpg,http://www.v5shop.com.cn,banner3e,Images/banner/banner3c.jpg,http://www.v5shop.com.cn,banner3c,Images/banner/banner3f.jpg,http://www.v5shop.com.cn,banner3f')
 
INSERT INTO Web_Ads VALUES ('18','skin1_首页BANNER1',NULL,NULL,NULL,'7e8e3a0c-318d-40ee-a8e8-398e7e98fb55','2008-10-22 15:30:15','2108-10-22 0:00:00','550','326','0','1000','default','0','0','','0','FLASH轮换广告','Images/banner/banner1a.jpg,http://www.v5shop.com.cn,,Images/banner/banner1b.jpg,http://www.v5shop.com.cn,BANNER2,Images/banner/banner1c.jpg,http://www.v5shop.com.cn,BANNER3,Images/banner/banner1d.jpg,http://www.v5shop.com.cn,BANNER4,Images/banner/banner1e.jpg,http://www.v5shop.com.cn,BANNER5,Images/banner/banner1f.jpg,http://www.v5shop.com.cn,BANNER6')
 
INSERT INTO Web_Ads VALUES ('19','skin1_首页BANNER2',NULL,NULL,NULL,'e242300b-b7d1-498d-bc9a-fe7a70a1d32b','2008-10-22 15:30:15','2108-10-22 0:00:00','176','223','0','1000','default','0','0','','0','FLASH轮换广告','Images/banner/banner2f.jpg,http://www.v5shop.com.cn,,Images/banner/banner2d.jpg,http://www.v5shop.com.cn,banner2b,Images/banner/banner2b.jpg,http://www.v5shop.com.cn,banner2c,Images/banner/banner2c.jpg,http://www.v5shop.com.cn,banner2d,Images/banner/banner2a.jpg,http://www.v5shop.com.cn,banner2e,Images/banner/banner2e.jpg,http://www.v5shop.com.cn,banner2f')
 
INSERT INTO Web_Ads VALUES ('21','skin1_首页广告4',NULL,NULL,NULL,'cbb2ded1-996d-4edc-bcc8-e111e456df4a','2008-10-22 15:30:15','2108-10-22 0:00:00','176','134','0','1000','default','0','0','dsadsa','0','普通广告','Images/AD/ad6.gif,/v5shop/articleindex.aspx,')
 
INSERT INTO Web_Ads VALUES ('22','skin1_首页广告3',NULL,NULL,NULL,'0be3b3ab-ac58-4654-80ba-c57db5639009','2008-10-22 15:30:18','2108-10-22 0:00:00','176','300','0','1000','default','0','0','321321321','0','普通广告','Images/AD/ad4.gif,/v5shop/index.aspx,')
 
INSERT INTO Web_Ads VALUES ('23','skin1_首页广告2',NULL,NULL,NULL,'a7406032-5d0c-494c-859b-4a4da1a48f91','2008-10-22 15:30:18','2108-10-22 0:00:00','176','134','0','1000','default','0','0','31321321321','0','普通广告','Images/AD/ad5.gif,/v5shop/index.aspx,')
 
INSERT INTO Web_Ads VALUES ('20','skin1_文章首页BANNER',NULL,NULL,NULL,'09a8cad1-f225-4822-9339-dd404a33e006','2008-10-22 15:30:15','2108-10-22 0:00:00','250','258','0','1000','default','0','0','文章首页FLASH广告1,5张轮换','0','FLASH轮换广告','Images//banner.jpg,http://www.021web.com.cn,,Images//item_amount_40_act.gif,http://www.021web.com.cn,2,,,,,,,,,,,,')
 
INSERT INTO Web_Ads VALUES ('24','skin1_首页广告1',NULL,NULL,NULL,'09719df7-9034-4e92-9f74-4411fae68a6c','2008-10-22 15:30:18','2108-10-22 0:00:00','176','300','0','1000','default','0','0','左侧从上往下数第一个广告','0','普通广告','Images/AD/ad3b.gif,/v5shop/index.aspx,')
 
CREATE TABLE dbo.Tmp_Web_Ads([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NULL,[Src] [nvarchar] (250)  NULL,[Href] [nvarchar] (250)  NULL,[HrefNote] [nvarchar] (250)  NULL,[Mark] [uniqueidentifier]  NOT NULL,[StartDate] [datetime]  NULL,[EndDate] [datetime]  NULL,[PicWidth] [int]  NOT NULL,[PicHeight] [int]  NOT NULL,[Hits] [int]  NOT NULL,[OrderID] [int]  NOT NULL,[TemplatePath] [nvarchar] (250)  NULL,[IsDel] [int]  NOT NULL,[IsAct] [int]  NOT NULL,[Remark] [nvarchar] (150)  NULL,[CategoryID] [int]  NOT NULL,[AdsType] [nvarchar] (50)  NOT NULL,[QueryArray] [nvarchar] (1000)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_Ads ADD CONSTRAINT DF_Tmp_Web_Ads_Mark DEFAULT (newid()) FOR [Mark]
 
ALTER TABLE dbo.Tmp_Web_Ads ADD CONSTRAINT DF_Tmp_Web_Ads_StartDate DEFAULT (getdate()) FOR [StartDate]
 
ALTER TABLE dbo.Tmp_Web_Ads ADD CONSTRAINT DF_Tmp_Web_Ads_EndDate DEFAULT (getdate()) FOR [EndDate]
 
ALTER TABLE dbo.Tmp_Web_Ads ADD CONSTRAINT DF_Tmp_Web_Ads_PicWidth DEFAULT ((0)) FOR [PicWidth]
 
ALTER TABLE dbo.Tmp_Web_Ads ADD CONSTRAINT DF_Tmp_Web_Ads_PicHeight DEFAULT ((0)) FOR [PicHeight]
 
ALTER TABLE dbo.Tmp_Web_Ads ADD CONSTRAINT DF_Tmp_Web_Ads_Hits DEFAULT ((0)) FOR [Hits]
 
ALTER TABLE dbo.Tmp_Web_Ads ADD CONSTRAINT DF_Tmp_Web_Ads_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Tmp_Web_Ads ADD CONSTRAINT DF_Tmp_Web_Ads_IsDel DEFAULT ((0)) FOR [IsDel]
 
ALTER TABLE dbo.Tmp_Web_Ads ADD CONSTRAINT DF_Tmp_Web_Ads_IsAct DEFAULT ((0)) FOR [IsAct]
 
ALTER TABLE dbo.Tmp_Web_Ads ADD CONSTRAINT DF_Tmp_Web_Ads_CategoryID DEFAULT ((0)) FOR [CategoryID]
 
ALTER TABLE dbo.Tmp_Web_Ads ADD CONSTRAINT DF_Tmp_Web_Ads_AdsType DEFAULT ((0)) FOR [AdsType]
 
SET IDENTITY_INSERT dbo.Tmp_Web_Ads ON
 
IF EXISTS(SELECT * FROM dbo.Web_Ads) EXEC('INSERT INTO dbo.Tmp_Web_Ads ([ID],[Name],[Src],[Href],[HrefNote],[Mark],[StartDate],[EndDate],[PicWidth],[PicHeight],[Hits],[OrderID],[TemplatePath],[IsDel],[IsAct],[Remark],[CategoryID],[AdsType],[QueryArray]) SELECT [ID],[Name],[Src],[Href],[HrefNote],[Mark],[StartDate],[EndDate],[PicWidth],[PicHeight],[Hits],[OrderID],[TemplatePath],[IsDel],[IsAct],[Remark],[CategoryID],[AdsType],[QueryArray] FROM dbo.Web_Ads WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Ads OFF
 
DROP TABLE dbo.Web_Ads
 
EXECUTE sp_rename N'dbo.Tmp_Web_Ads', N'Web_Ads', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_PageHelp]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_PageHelp] 
 
CREATE TABLE dbo.Web_PageHelp([ID] [int]  NOT NULL,[PageID] [int]  NOT NULL,[Language] [nvarchar] (10)  NULL,[Content] [ntext]  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_PageHelp ADD CONSTRAINT DF_Web_PageHelp_PageID DEFAULT ((0)) FOR [PageID]
 
INSERT INTO Web_PageHelp VALUES ('5','215','cn','sddsdsfdsff')
 
INSERT INTO Web_PageHelp VALUES ('8','13','cn','<span style="color: #40844d"><strong><span style="font-size: small">添加|编辑</span></strong></span><span style="font-size: small"><br />  在&ldquo;配送区域管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到添加配送区域页面在&ldquo;配送区域管理&rdquo;页面中选择要编辑的配送区域，然后点&ldquo;编辑&rdquo;按钮后会链接到配送区域添加页面</span>')
 
INSERT INTO Web_PageHelp VALUES ('53','177','cn','<span style="color: #40844d"><strong><span style="font-size: small">查询</span></strong></span><span style="font-size: small"><br />  查询的条件依次为&ldquo;商品名称|是否审核|是否推荐|评论人&rdquo;，商品名称|评论人为模糊查询，查询点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />  <br />  <span style="color: #40844d"><strong>删除</strong></span><br />  选中需要删除的商品感言 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复 <br />  <br />  <span style="color: #40844d"><strong>推荐|取消推荐商品感言</strong></span><br />  选中需要推荐的商品感言, 点击&ldquo;推&rdquo;按钮即可完成推荐操作 <br />  选中需要取消审推荐的商品感言, 点击&ldquo;取消推荐&rdquo;按钮即可完成取消推荐操作 <br />  <br />  <span style="color: #40844d"><strong>审核|取消审核商品感言</strong></span><br />  选中需要审核的商品感言, 点击&ldquo;审核&rdquo;按钮即可完成审核操作 <br />  选中需要取消审核的商品感言, 点击&ldquo;取消审核&rdquo;按钮即可完成取消审核操作<br />  <br />  <span style="color: #40844d"><strong>查看</strong></span><br />  选中需要查看的商品感言, 点击&ldquo;查看&rdquo;按钮即可查看商品感言</span>')
 
INSERT INTO Web_PageHelp VALUES ('73','96','cn','<span style="color: #40844d"><strong><span style="font-size: small">查询</span></strong></span><span style="font-size: small"><br />  查询的条件依次为&ldquo;方案名称|方案描述|添始时间|是否启用|适用会员等级&rdquo;，方案名称|方案描述使用模糊查询，活动开始时间|活动结束时间都为时间区间查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />  <br />  <span style="color: #40844d"><strong>删除</strong></span> <br />  选中需要删除的批发方案, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复 <br />  <br />  <span style="color: #40844d"><strong>添加|编辑</strong></span><br />  在&ldquo;批发方案管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到优惠方案添加页面<br />  在&ldquo;批发方案管理&rdquo;页面中选择要编辑的批发方案，然后点&ldquo;编辑&rdquo;按钮后会链接到批发方案编辑页面</span>')
 
INSERT INTO Web_PageHelp VALUES ('74','1','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">公告管理可以对商城首页公告进行管理，是商家和会员交流的一种方式，前台显示公告是按公告的排序号降序排列,即排序号越大就会显示在越前面<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">公告在前台显示的时候是以排序号的降序来排的</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;公告标题|发布|发表时间&rdquo;，公告标题|发布人为模糊查询，发表时间为时间区间查询，默认为最近3天，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的公告, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复向上|向下选中要移动的项，然后点&ldquo;向上|向下&rdquo;按钮会对记录进行排序 <br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;公告管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到公告添加页面在&ldquo;公告管理&rdquo;页面中选择要编辑的公告，然后点&ldquo;编辑&rdquo;按钮后会链接到公告编辑页面添加页面和编辑页面是同一个页面</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('80','14','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">帮助分类对应的是前台帮助中心的分类，商家可以为商城添加帮助分类以及帮助，从而让客户更快的了解商城的操作流程，后台对帮助分类进行管理<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">此处的帮助分类是对前台帮助的一个分类,一个帮助只能属于一个帮助分类</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件为&ldquo;分类名称&rdquo;，分类名称为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的帮助分类, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复<br />
<br />
<span style="color: #40844d"><strong>向上|向下</strong></span><br />
选中要移动的项，然后点&ldquo;向上|向下&rdquo;按钮会对记录进行排序<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;帮助分类管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到帮助分类添加页面在&ldquo;帮助分类管理&rdquo;页面中选择要编辑的帮助分类，然后点&ldquo;编辑&rdquo;按钮后会链接到帮助分类编辑页面</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('81','18','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">帮助对应的是前台帮助中心的帮助，商家可以为商城添加帮助分类以及帮助，从而让客户更快的了解商城的操作流程，后台对帮助进行管理<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">此处的帮助是添加给前台会员看的，而不是这个系统的后台帮助</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;帮助标题|帮助分类&rdquo;，帮助标题为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的帮助, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复<br />
<br />
<span style="color: #40844d"><strong>向上|向下</strong></span><strong><br />
</strong>选中要移动的项，然后点&ldquo;向上|向下&rdquo;按钮会对记录进行排序<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;帮助管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到帮助添加页面在&ldquo;帮助管理&rdquo;页面中选择要编辑的帮助，然后点&ldquo;编辑&rdquo;按钮后会链接到帮助编辑页面</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('83','24','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">商城会员在商城中使用任何关键字进行搜索的一个记录，可以反映会员对商城商品、文章的关注程度。管理员还可自定义热门关键字，包括商城首页以及其他页面搜索栏目下的热门关键字。关键字的排序采用降序排列，被搜索的次数越多则此关键字就越靠前。可以修改关键字的次数，只有显示的关键字才能被搜索，隐藏的关键字不能被搜索<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">后台未添加的关健字如果在前台被搜索掉一样会被记录；前台显示关健字的顺序是按搜索次数来排列的，搜索的次数越多就越前，当然标为不显示的关健字不会在前台显示</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;关键字|搜索次数|搜索类型|是否显示&rdquo;，关键字为模糊查询，搜索次数为精确查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的搜索关键字, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复<br />
<br />
<span style="color: #40844d"><strong>显示|隐藏</strong></span><strong><br />
</strong>选中需要显示的关键字，点击&ldquo;显示&rdquo;按钮即可。选中需要隐藏的关键字，点击&ldquo;隐藏&rdquo;按钮即可<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;搜索关键字管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到搜索关键字添加页面<br />
在&ldquo;搜索关键字管理&rdquo;页面中选择要编辑的搜索关键字，然后点&ldquo;编辑&rdquo;按钮后会链接到搜索关键字编辑页面<br />
添加页面和编辑页面是同一个页面 </span></p>')
 
INSERT INTO Web_PageHelp VALUES ('84','201','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">Sitemaps 服务旨在使用 Feed 文件 sitemap.xml 通知 Google、Yahoo! 以及 Microsoft 等 Crawler(爬虫)网站上哪些文件需要索引、这些文件的最后修订时间、更改频度、文件位置、相对优先索引权，这些信息将帮助他们建立索引范围和索引的行为习惯。详细信息请查看 sitemaps.org 网站上的说明。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">品牌可以和商品分类关联，但只能和顶级商品分类关联。添加的品牌只有标记为在前台显示才会在前台看到</font></span></span></p>')
 
INSERT INTO Web_PageHelp VALUES ('85','253','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">对商品添加页面的的配置，可控制商品添加页面的显示情况。<br />
品牌管理可以对商品品牌进行添加，编辑，删除操作。一个商品只能属于一个品牌，在添加品牌的时候可以为品牌关联多个商品分类<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">不同的操作员（管理员）进入系统后共用一个商品添加配置。<br />
如果选择模块功能，则商品在添及或编辑时会相应显示。否则则不显示。如：商品配件如果添加功能未选中，则在加商品时不会显示商品配件一项。</font></span></span></p>')
 
INSERT INTO Web_PageHelp VALUES ('86','78','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">品牌管理可以对商品品牌进行添加，编辑，删除操作。一个商品只能属于一个品牌，在添加品牌的时候可以为品牌关联多个商品分类<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">品牌可以和商品分类关联，但只能和顶级商品分类关联。添加的品牌只有标记为在前台显示才会在前台看到 </font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件为&ldquo;品牌名称&rdquo;，牌名称使用模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的品牌, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复 <br />
<br />
<span style="color: #40844d"><strong>向上|向下</strong></span><strong><br />
</strong>选中要移动的品牌，然后点&ldquo;向上|向下&rdquo;按钮会对品牌进行排序<br />
<span style="color: #40844d"><strong><br />
添加|编辑</strong></span><br />
在&ldquo;品牌管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到优惠方案添加页面（如图12.2）<br />
在&ldquo;品牌管理&rdquo;页面中选择要编辑的品牌，然后点&ldquo;编辑&rdquo;按钮后会链接到品牌编辑页面（如图12.2）<br />
添加页面和编辑页面是同一个页面</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('87','71','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">商品类型是分类来管理商品的属性，包括添加，编辑，删除操作。一个商品类型包多个商品属性<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">我们可以把商品类型理解为对商品属性的一个分类，例如，如果我要卖书籍这类商品，因为书都有作者，出版社，出版日期这些属性,那么我们可以添加一个商品类型名为&ldquo;书籍类&rdquo;这样的商品类型，并在&ldquo;书籍类&rdquo;这个商品类型下建立作者，出版社，出版日期三个属性，在添加商品分类的时候，我们把书类这样的一个商品分类关联到&ldquo;书籍类&rdquo;这个商品类型上，那么在添加商品的时候会有以上三种属性让我们来输入或选择</font><br />
</span><br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的商品类型, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复<br />
<br />
<span style="color: #40844d"><strong>向上|向下<br />
</strong></span>选中要移动的商品类型，然后点击&ldquo;向上|向下&rdquo;按钮会对商品类型进行排序<br />
<br />
<span style="color: #40844d"><strong>属性列表</strong></span><strong><br />
</strong>选中商品类型，点击属性列表会链接到属性列表管理页面，可以添加|编辑|删除属性列表<br />
<br />
<span style="color: #40844d"><strong>配件类型列表</strong></span><br />
选中商品类型，点击配件类型列表会链接到配件类型列表管理页面，可以添加|编辑|删除属性列表<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;商品类型管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到商品类型添加页面<br />
在&ldquo;商品类型管理&rdquo;页面中选择要编辑的商品类型，然后点&ldquo;编辑&rdquo;按钮后会链接到商品类型编辑页面<br />
添加页面和编辑页面是同一个页面</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('89','75','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">每一个商品都有一个商品编号，可以在添加商品的时候随机取得，也可以利用编号规则来生成商品编号，编号规则管理可以添加，编辑，删除编号规则，也可以为编号规则添加规则内容<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">规则级别名称只是起标识作用，并不会真正记录到产品标号中去。</font><br />
<br />
<strong>删除<br />
</strong></span>选中需要删除的属性, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复 <br />
<br />
<span style="color: #40844d"><strong>管理规则内容<br />
</strong></span>在&ldquo;配件列表&rdquo;页面点&ldquo;管理规则内容&rdquo;按钮后会链接到规则内容列表页面<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;配件列表&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到配件添加页面<br />
在&ldquo;配件列表&rdquo;页面中选择要编辑的属性，然后点&ldquo;编辑&rdquo;按钮后会链接到配件列表编辑页面<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的属性, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;规则内容列表&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到规则内容添加页面<br />
在&ldquo;规则内容列表&rdquo;页面中选择要编辑的属性，然后点&ldquo;编辑&rdquo;按钮后会链接到规则内容列表编辑页面</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('90','77','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">商品单位是对商品计量的一个描述，商品单位管理可以添加，编辑，删除商品单位<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">单位代码只是一个标识，用于系统扩展，建议用中文单位的英文简写，例如，单位名称为千克，单位代码可写成KG。单位代码不能重复</font><br />
<br />
<strong>删除<br />
</strong></span>选中需要删除的商品单位, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><strong><br />
</strong>在&ldquo;商品单位列表&rdquo;页面点&ldquo;添加&rdquo;按钮后会弹出商品单位添加页面<br />
在&ldquo;商品单位列表&rdquo;页面中选择要编辑的属性，然后点&ldquo;编辑&rdquo;按钮后会弹出商品单位列表编辑页面</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('91','97','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">当商品绑定了虚拟卡后可作为虚拟商品买卖，虚拟卡管理包括添加，编辑，删除。在商品管理里面查询虚拟商品，然后选中商品点击&ldquo;补货&rdquo;可完成补货操作<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">虚拟卡的面值就是商品的商城价格; 注意，虚拟商品不能通过入库操作修改库存，只能通过补货来改变库存。<br />
</font><br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;订单号|卡号|商品名称&rdquo;，订单号|卡号|商品名称为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<span style="color: #40844d"><strong><br />
删除</strong></span><strong><br />
</strong>选中需要删除的商品, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;虚拟卡列表&rdquo;页面点&ldquo;添加&rdquo;按钮后会弹出到虚拟卡添加页面<br />
在&ldquo;虚拟卡列表&rdquo;页面中选择要编辑的虚拟卡，然后点&ldquo;编辑&rdquo;按钮后会弹出虚拟卡添加的页面</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('92','178','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">换购商品管理是对商城系统中的换购商品进行统一管理，包括添加，编辑，删除，将换购商品转为普通商品<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">换购商品列中的商品也会在商品列表中显示，换购商品实际上就是一种特殊的商品</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;商品名称|商品编号|商品分类&rdquo;，商品名称|商品编号为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的商品, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复<br />
<br />
<span style="color: #40844d"><strong>向上|向下</strong></span><br />
选中要移动的商品，然后点&ldquo;向上|向下&rdquo;按钮会对商品进行排序<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;换购商品管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到商品添加页面<br />
在&ldquo;换购商品管理&rdquo;页面中选择要编辑的商品，然后点&ldquo;编辑&rdquo;按钮后链接到商品添加的页面添加页面和编辑页面是同一个页<br />
<br />
<span style="color: #40844d"><strong>转为普通商品</strong></span><br />
选中要转化的商品点击&ldquo;转为普通商品&rdquo;按钮会将商品转为普通商品</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('93','179','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">积分商品管理是对商城系统中的积分商品进行统一管理，包括添加，编辑，删除，将积分商品转为普通商品<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">积分商品列中的商品也会在商品列表中显示，积分商品实际上就是一种特殊的商品<br />
</font><br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;商品名称|商品编号|商品分类&rdquo;，商品名称|商品编号为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的商品, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复 <br />
<br />
<span style="color: #40844d"><strong>向上|向下</strong></span><br />
选中要移动的商品，然后点&ldquo;向上|向下&rdquo;按钮会对商品进行排序<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;积分商品管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到商品添加页面<br />
在&ldquo;积分商品管理&rdquo;页面中选择要编辑的商品，然后点&ldquo;编辑&rdquo;按钮后链接到商品添加的页面<br />
添加页面和编辑页面是同一个页面</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('94','175','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">商城前台，可以给商品添加评论，后台商品评论管理可以管理商品的评论,包括审核，回复评论.<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">只有审核过的商品评论前台才会显示。参加商品评论的条件要根据参数设置里面的来判断，商品评论的条件有4种， 所有用户、仅登录用户、有过一次以上购买行为用户、仅购买过该商品用户。设置为&ldquo;所有用户&rdquo;后无论是注册会员还是未注册的游客都能发表商品评论，设置为&ldquo;仅登录用户&rdquo;后只有登录的会员才能发表评论，设置为&ldquo;有过一次购买行为用户&rdquo;后只有在商城买过商品的会员才能发表评论，设置为&ldquo;仅购买过该商品用户&rdquo;后只有购买过该商品的会员才能发表评论<br />
</font><br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;评论标题|评论人|评论商品|是否审核|是否回复|评论时间&rdquo;，评论标题|评论人|评论商品为模糊查询，评论时间为区间查询点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的评论, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复<br />
<br />
<span style="color: #40844d"><strong>审核|取消审核商品评论</strong></span><br />
选中需要审核的商品评论, 点击&ldquo;审核&rdquo;按钮即可完成审核操作<br />
选中需要取消审核的商品评论, 点击&ldquo;取消审核&rdquo;按钮即可完成取消审核操作<br />
<br />
<span style="color: #40844d"><strong>查看商品评论</strong></span><strong><br />
</strong>选中需要查看的商品评论, 点击&ldquo;查看评论&rdquo;按钮即可查看商品评论</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('95','180','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">库存管理是对商品库存的操作，包括入库，出库，并对入库，出库操作进行记录<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">当要对商品入库的时候可以由缺货登记管理模块进入</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;商品名称|操作时间|操作类型&rdquo;，商品名称为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的商品感言 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复 <br />
<br />
<span style="color: #40844d"><strong>添加<br />
</strong></span>在&ldquo;库存操作列表&rdquo;页面点&ldquo;添加&rdquo;按钮后会弹出到库存操作页面<br />
<br />
<span style="color: #40844d"><strong>搜索商品</strong></span><br />
输入商品的名称，点&ldquo;搜索&rdquo;按钮会把查询出来的商品列在&ldquo;选择商品&rdquo;列表中</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('96','183','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">缺货登记是对会员在前台添加的缺货信息进行管理，通过缺货信息，商家可以更快的了解到商城的商品信息，并即时更新商品的库存<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">只有当参数设置里面的&ldquo;是否使用缺货处理&rdquo;选择了使用时前台才可以进行缺货登记操作;后台只能处理缺货登记，而不能在后台添加缺货登记</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;商品名称|登记时间|登记人姓名|最晚到货时间|是否处理&rdquo;，商品名称|登记人姓名为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的登记记录 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复<br />
<br />
<span style="color: #40844d"><strong>缺货登记处理|详细</strong></span><br />
在&ldquo;缺货登记列表&rdquo;页面点&ldquo;处理|详细&rdquo;按钮后会弹出到缺货登记处理|详细页面<br />
<br />
<span style="color: #40844d"><strong>入库</strong></span><br />
在&ldquo;缺货登记列表&rdquo;页面点&ldquo;入库&rdquo;按钮后会弹出到库存操作页面</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('97','186','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">发货通知管理可以管理对会员发货的操作，包括添加，编辑，删除。从而通知客户。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">当我们修改订单状态为已发货的时候可以添加发货通知。<br />
</font><br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;会员ID|发货时间|是否已读|是否显示&rdquo;，会员ID为模糊查询，发货时间为时间区间查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的发货通知 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。<br />
<br />
<span style="color: #40844d"><strong>显示|隐藏</strong></span><br />
选中需要显示的发货通知，点击&ldquo;显示&rdquo;按钮即可。选中需要隐藏的发货通知，点击&ldquo;隐藏&rdquo;按钮即可。<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;发货通知列表&rdquo;页面点&ldquo;添加&rdquo;按钮后会弹出到发货通知页面<br />
在&ldquo;发货通知列表&rdquo;页面点&ldquo;编辑&rdquo;按钮后会弹出到发货通知页面<br />
添加和编辑是同一个页面</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('98','188','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">下载CSV文件，填写相应的商品属性，上传后即可将数据批量插入到数据库中，实现商品的批量导入<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">下载CSV文件的时候要根据自己操作系统的版本来选择</font></span></span></p>')
 
INSERT INTO Web_PageHelp VALUES ('99','197','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">完成对不同商品的不同属性实现同一编辑<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">批量编辑时无法编辑商品的分类和品牌</font></span></span></p>')
 
INSERT INTO Web_PageHelp VALUES ('100','70','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">管理商城的会员，包括添加|编辑|删除会员，锁定会员，对会员积分操作，查看会员的收货地址，查看会员订单，给会员分配会员卡，给会员分配充值卡,分配优惠卷。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">锁定过的商城会员不能在前台登录。<br />
</font><br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;会员名|性别|所在城市|会员等级|信用额度|积分|锁定状态|注册日期&rdquo;，会员名为模糊查询，信用额度为区间查询，注册日期为时间区间查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的会员, 点击&ldquo;删除&rdquo;按钮即可。删除后不可以恢复。<br />
<br />
<span style="color: #40844d"><strong>分配会员卡</strong></span><br />
选择会员，点击&ldquo;分配会员卡&rdquo;按钮，会链接到分配会员卡的页面（详细请查看会员卡管理页面），选择会员卡号点击&ldquo;分配给会员&rdquo;即可。<br />
<br />
<span style="color: #40844d"><strong>分配充值卡</strong></span><br />
选择会员，点击&ldquo;分配充值卡&rdquo;按钮，会链接到分配充值卡的页面（详细请查看充值卡管理页面），选择充值卡号点击&ldquo;分配给会员&rdquo;即可。<br />
<br />
<span style="color: #40844d"><strong>分配购物卡</strong></span><br />
选择会员，点击&ldquo;分配购物卡&rdquo;按钮，会链接到分配购物卡的页面（详细请查看购物卡管理页面），选择购物卡号点击&ldquo;分配给会员&rdquo;即可 。<br />
<br />
<span style="color: #40844d"><strong>分配优惠卷</strong></span><br />
选择会员，点击&ldquo;分配优惠卷&rdquo;按钮，会链接到分配优惠卷的页面（详细请查看优惠卷管理页面），选择优惠卷号点击&ldquo;分配给会员&rdquo;即可。<br />
<br />
<span style="color: #40844d"><strong>锁定|取消锁定用户</strong></span><br />
如果想让会员不能登录但又想保存会员的信息，可以使用锁定功能，锁定过的用户将不能在前台登录，未锁定的会员才能在前台登录，选择要锁定的用户，一次可以选择多个，然后点击&ldquo;锁定&rdquo;即可完成锁定操作，取消锁定的操作和锁定操作一样。<br />
<br />
<span style="color: #40844d"><strong>冻结资金/积分</strong></span><br />
选择会员，点击&ldquo;冻结资金|积分&rdquo;按钮，会链接到冻结资金|积分的页面（详细请查看冻结资金|积分页面）。<br />
<br />
<span style="color: #40844d"><strong>查看收货地址</strong></span><br />
我们可以查看会员的收货地址，选择会员，点击&ldquo;查看收货地址&rdquo;按钮，会链接到查看收货地址的页面。<br />
<br />
<span style="color: #40844d"><strong>查看订单</strong></span><br />
我们可以查看会员的订单信息，选择会员，点击&ldquo;查看订单&rdquo;按钮，会链接到订单页面，并且定位到该用户。<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;会员管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到会员添加的页面<br />
在&ldquo;会员管理&rdquo;页面中选择要编辑的会员，然后点&ldquo;编辑&rdquo;按钮后链接到会员编辑的页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('103','80','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">管理购物卡，包括添加|删除购物卡，锁定购物卡，查看购物卡使用记录。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">锁定过的购物卡不能被使用；个会员可分配多张会员卡；一张购物卡可以被多次使用。<br />
</font><br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;卡号|发卡人|持卡人|发放批次|分配状态|锁定状态|发卡时间&rdquo;，卡号|发卡人|持卡人为模糊查询，发放批次为精确查询，发卡时间为时间区间查询,点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的购物卡, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。<br />
<br />
<span style="color: #40844d"><strong>锁定|取消锁定</strong></span><br />
可以将购物卡锁定，如果该购物卡未被分配给会员并且处于锁定状态，此时将无法分配给会员，只有未被锁定的购物卡才能分配给会员，选择要锁定的购物卡，点击&ldquo;锁定&rdquo;按钮可锁定购物卡，取消锁定和锁定操作相同。<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;会员卡管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到会员卡添加页面<br />
在&ldquo;会员卡管理&rdquo;页面中选择要编辑的会员卡，然后点&ldquo;编辑&rdquo;按钮后会链接到会员卡编辑页面<br />
添加页面和编辑页面是同一个页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('105','74','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">管理商城会员的留言，包括查看留言，回复留言，删除留言。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">只有审核过的留言才能在前台显示；如果参数设置中的&ldquo;留言审核&rdquo;设为&ldquo;开启&rdquo;时审核才有用，当设为&ldquo;关闭&rdquo;时留言就不需要审核。<br />
</font><br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;留言标题|留言类型|留言人|是否回复|留言时间&rdquo;，留言标题|留言人为模糊查询，留言时间为时间区间查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的留言, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。 <br />
<br />
<span style="color: #40844d"><strong>详细|回复</strong></span><br />
选中要回复的留言，然后点&ldquo;详细|回复&rdquo;按钮会链接到回复页面，回复过的留言不能再修改。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('106','196','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">商家可以通过订单管理功能来管理订单，包括添加订单，修改订单，清理无效订单，操作订单状态。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">查询的条件依次为&ldquo;订单单号|用户名|购物人|收货人|邮编|手机号码|联系电话 |电子邮件|订单金额|配送方式|支付方式|订单状态|订单日期|收货地址&rdquo;，订单单号|用户名|购物人|收货人|邮编|手机号码|联系电话 |电子邮件|收货地址为模糊查询，发|订单日期为时间区间查询，订单金额为价格区间查询,点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。</font><br />
<br />
<strong>删除<br />
</strong></span>选中需要删除的订单 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。<br />
<br />
<span style="color: #40844d"><strong>导出订单</strong></span><strong><br />
</strong>选中需要导出的订单 点击&ldquo;导出订单&rdquo;按钮即可，可以同时选择多个订单。<br />
<br />
<span style="color: #40844d"><strong>清理无效订单</strong></span><br />
选中需要清理的无效订单 点击&ldquo;清理无效订单&rdquo;按钮即可。删除后不可恢复。<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;订单管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到订单添加页面。<br />
在&ldquo;订单管理&rdquo;页面点&ldquo;编辑&rdquo;按钮后会链接到订单详细页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('107','223','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">在订单还没有完成后，我们可以修改订单的价格，针对每一次修改，我们会记录。<br />
<br />
</font><strong><span style="color: #40844d">订单编号</span><br />
</strong><font color="#000000">可以按订单编号来查询该订单的修改记录。</font><br />
<br />
<strong>删除<br />
</strong></span>可以选择订单的修改记录。点&ldquo;删除&rdquo;即可删除订单的修改记录。<br />
</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('108','229','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">您可以合并两个&ldquo;未付款&rdquo;并且&ldquo;未发货&rdquo;的订单，分别输入两个订单号即可。当这两个订单的配送、支付、包装、贺卡等信息不一致时，将以第二个订单为准。合并后的订单将重新计算运费、包装费、贺卡费等。合并后，原来的两个订单将被删除。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">合并订单只能和平同一个会员的订单，且不能合并已付款的订单。合并后的订单信息以主订单为主。如收货地址、配送支付方式、包装、贺卡等。</font><br />
<br />
<strong>选择用户<br />
</strong></span>选择订单所属人。<br />
<br />
<span style="color: #40844d"><strong>主订单</strong></span><strong><br />
</strong>选择主订单。<br />
<br />
<span style="color: #40844d"><strong>从订单</strong></span><br />
选择从订单。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('109','83','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">夺宝奇兵是一种促销的方式，关联夺宝奇兵的商品将以最小的唯一价出售。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">夺宝奇兵有开始时间和结束时间，到了结束时间后活动自动会结束。</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;活动名称|活动开始时间|商品名称|活动结束时间&rdquo;，活动名称|商品名称为模糊查询，活动开始时间|活动结束时间为时间区间查询,点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的夺宝奇兵, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。<br />
<br />
<span style="color: #40844d"><strong>详细</strong></span><br />
如果要查看每一个夺宝奇兵具体情况，可以选中夺宝奇兵，点击&ldquo;详细&rdquo;按钮即可链接到夺宝奇兵详细页面。<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;夺宝奇兵管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到夺宝奇兵添加页面<br />
在&ldquo;夺宝奇兵管理&rdquo;页面中选择要编辑的夺宝奇兵,，然后点&ldquo;编辑&rdquo;按钮后会链接到夺宝奇兵编辑页面<br />
添加页面和编辑页面是同一个页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('110','85','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">添加的的商品包装可让客户在订购的时候选择是否需要商品包装，管理包装，包括添加|编辑|删除，会员在下订单时可以根据自己的需要选择是否需要包装。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">免费额度是指当客户购买金额达到这个金额时会免费包装，不计算包装的费用。</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件为&ldquo;商品包装名称&rdquo;，品包装名称为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的商品包装, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;商品包装管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到商品包装添加页面<br />
在&ldquo;商品包装管理&rdquo;页面中选择要编辑的商品包装,，然后点&ldquo;编辑&rdquo;按钮后会链接到商品包装编辑页面<br />
添加页面和编辑页面是同一个页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('111','87','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">添加的的祝福贺卡让客户在订购的时候选择是否需要祝福贺卡,管理祝福贺卡，包括添加|编辑|删除，会员在下订单时可以根据自己的需要选择是否需要祝福贺卡。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">免费额度是指当客户购买金额达到这个金额时会免费赠送祝福贺卡，不计算贺卡的费用。<br />
</font><br />
<strong>查询<br />
</strong></span>查询的条件为&ldquo;贺卡名称&rdquo;，贺卡名称为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的祝福贺卡, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;祝福贺卡管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到祝福贺卡添加页面<br />
在&ldquo;祝福贺卡管理&rdquo;页面中选择要编辑的祝福贺卡，然后点&ldquo;编辑&rdquo;按钮后会链接到祝福贺卡编辑页面<br />
添加页面和编辑页面是同一个页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('112','89','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">导购是一种促销的方式，商品导购是为商家提供一个向顾客展示商品的平台，对顾客购买起一个引导的作用，商品导购包括添加|编辑|删除。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">导购只起宣传目的。<br />
</font><br />
<strong>查询<br />
</strong></span>查询的条件为&ldquo;导购名称&rdquo;，导购名称为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的商品导购, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;商品导购管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到商品导购添加页面<br />
在&ldquo;商品导购管理&rdquo;页面中选择要编辑的祝福贺卡，然后点&ldquo;编辑&rdquo;按钮后会链接到商品导购编辑页面<br />
添加页面和编辑页面是同一个页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('113','92','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">优惠券可以用来消费，优惠券管理对优惠券进行添加，删除操作，也可以禁用优惠券,, 优惠券一旦生成将无法更改，每张优惠券只能使用一次, 优惠券必需绑定到会员，禁用过的优惠券将不能被使用。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">在添加优惠券的时候如没有关联任何商品表示该优惠券可以购买所有商品，如果没有关联任何会员等级表示所有的会员都可以使用该优惠券。</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件为&ldquo;优惠券名|优惠券号|使用会员|开始时间|结束时间|是否分配|是否使用&rdquo;，优惠券名|优惠券号|使用会员为模糊查询，开始时间|结束时间为时间区间查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的优惠券, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。<br />
<br />
<span style="color: #40844d"><strong>添加</strong></span><br />
在&ldquo;优惠券管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到优惠券添加页面。<br />
<br />
<span style="color: #40844d"><strong>启用|禁用</strong></span><br />
选中需要禁用的优惠券, 点击&ldquo;禁用&rdquo;按钮即可。禁用后的优惠券不能会被使用，也可以对禁用过的优惠券启用。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('114','93','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">团购是一种促销的方式，团购管理对团购进行添加，编辑，删除操作，团购有时间限制，会员只能在规定的时间内参加团购，团购也有商品数据的限制和对每人购买数量的限制。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">价格阶梯是对数据和价格的控制，不同的数量享有不同的价格。</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件为&ldquo;团购名称|开始时间|商品名称|结束时间&rdquo;，团购名称|商品名称使用模糊查询，开始时间|结束时间为时间区间查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的团购, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。 <br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;团购管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到团购添加页面<br />
在&ldquo;团购管理&rdquo;页面中选择要编辑的团购，然后点&ldquo;编辑&rdquo;按钮后会链接到团购编辑页面<br />
添加页面和编辑页面是同一个页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('115','94','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">优惠活动是一种促销的方式，优惠活动是针对商城的商品进行的买赠活动，通过送礼品、积分、优惠券等，达到商品促销的目的。优惠活动管理对优惠活动进行添加，编辑，删除操作。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">优惠活动有时间限制，在达到活动结束时间的时候活动会结束。优軎范围是限定购买的商品,不选择商品的时候只针对所有商品有效。<br />
</font><br />
<strong>查询<br />
</strong></span>查询的条件为&ldquo;活动名称|活动类型|活动状态|赠送礼品|赠送优惠卷|赠送积分|活动开始时间|活动结束时间&rdquo;，活动名称使用模糊查询，活动开始时间|活动结束时间都为时间区间查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的优惠活动, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。 <br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;优惠活动管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到优惠活动添加页面<br />
在&ldquo;优惠活动管理&rdquo;页面中选择要编辑的优惠活动，然后点&ldquo;编辑&rdquo;按钮后会链接到优惠活动编辑页面<br />
添加页面和编辑页面是同一个页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('116','3','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">图片类别管理是用来对系统中用到的图片进行分类管理。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">图片类别是为了方便图片管理而设的。不会在前台显示。<br />
</font><br />
<strong><span style="color: #40844d"><strong>删除</strong></span><br />
</strong></span>选中需要删除的图片类别, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;图片类别管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会弹出添加图片类别的页面 <br />
在&ldquo;图片类别管理&rdquo;页面中选择要编辑的公告，然后点&ldquo;编辑&rdquo;按钮后弹出添加图片类别的页面 <br />
添加页面和编辑页面是同一个页面<br />
图片类别添加|编辑。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('117','4','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">图片管理是用来管理系统中所有用到的图片，包括，添加|编辑|删除，建议在要用到图片的时候先在图片管理页面来上传图片，在用到图片的地方就可以直接选择图片。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">此处图片不包括广告和模板图片，广告和模板图片可到&ldquo;模板/标签系统&rdquo;里管理。</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;图片名称|图片类别&rdquo;，图片名称为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的图片, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;图片管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会弹出添加图片类别的页面 <br />
在&ldquo;图片管理&rdquo;页面中选择要编辑的图片，然后点&ldquo;编辑&rdquo;按钮后会弹出添加图片类别的页面 <br />
添加页面和编辑页面是同一个页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('118','16','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">广告分类是用来对系统中用到的图片进行分类管理。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">请注意广告分类和广告类型的区别。广告分类只是能广告的一个分类，为了管理方便。而广告类型，是实际存在的，如&ldquo;背景广告|Flash轮换广告|普通广告|文字广告&rdquo;。</font><br />
<br />
<strong>删除<br />
</strong></span>选中需要删除的广告分类, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><strong><br />
</strong>在&ldquo;广告分类管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会弹出添加广告分类的页面 <br />
在&ldquo;广告分类管理&rdquo;页面中选择要编辑的文档，然后点&ldquo;编辑&rdquo;按钮后会弹出广告分类的页面 <br />
添加页面和编辑页面是同一个页面</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('119','17','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">广告管理是用来管理系统中所有用到的广告，包括，添加|编辑|删除,， 包括背景广告,FLASH轮换广告,普通广告,文字广告，生成的广告运用在前台。广告管理以有插件的形式集成到系统中。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">广告有时间限制，只有在开始时间和结束时间之间的广告才有效。</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;广告分类|广告名称|广告类型|是否开启&rdquo;，广告名称为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的广告, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。 <br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;广告管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会弹出添加广告的页面 <br />
在&ldquo;广告管理&rdquo;页面中选择要编辑的广告，然后点&ldquo;编辑&rdquo;按钮后会弹出添加广告的页面 <br />
添加页面和编辑页面是同一个页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('120','8','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">文档管理是用来管理系统中所有用到的文档，包括，添加|编辑|删除，建议在用到文档的时候先在文档管理页面来上传文档，那么在用到文档的地方就可以直接选择文档了，而文档类别管理是对文档的一个归类。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">删除文档类别的时候文档类别里的文档不会被删除，删除后属于该文档类别下的文档所属的文档类另显空。</font><br />
<br />
<strong>删除<br />
</strong></span>选中需要删除的图片, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><strong><br />
</strong>在&ldquo;文档类别管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会弹出添加文档类别的页面 <br />
在&ldquo;文档类别管理&rdquo;页面中选择要编辑的图片，然后点&ldquo;编辑&rdquo;按钮后会弹出文档类别的页面 <br />
添加页面和编辑页面是同一个页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('121','9','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">文档管理是用来管理系统中所有用到的文档，包括，添加|编辑|删除，建议在用到文档的时候先在文档管理页面来上传文档，那么在用到文档的地方就可以直接选择文档了。。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">文档管理不会在前台显示。</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;文档名称|文档类别&rdquo;，图片名称为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的文档, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。 <br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;文档管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会弹出添加文档类别的页面 <br />
在&ldquo;文档管理&rdquo;页面中选择要编辑的文档，然后点&ldquo;编辑&rdquo;按钮后会弹出添加文档类别的页面 <br />
添加页面和编辑页面是同一个页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('122','6','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">商家可以通过来电速记来记录客户的问题，以及一些自己需要处理的事情，从达到快速处理客户问题的目的<br />
可以理解为一个记事本，但比记事本更方便，功能更强。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">来电速记功能是方便商家使用的， 记录的内容不会在商城前台显示。<br />
</font><br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;问题标题|来电姓名|电话号码|来电日期|处理状态&rdquo;，问题标题|来电姓名|电话号码为模糊查询，来电日期为区间查询,点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<span style="color: #40844d"><strong><br />
删除</strong></span><strong><br />
</strong>选中需要删除的来电速记记录, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。 <br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;来电速记管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会弹出添加来电速记的页面 <br />
在&ldquo;来电速记管理&rdquo;页面中选择要编辑的来电速记，然后点&ldquo;编辑&rdquo;按钮后会弹出来电速记的页面 <br />
添加页面和编辑页面是同一个页面 。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('123','60','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">对商城文章进行分类管理，包括添加|编辑|删除。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">文章分类支持无限级。</font><br />
<br />
<strong>删除<br />
</strong></span>选中需要删除的文章分类 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。<br />
<br />
<span style="color: #40844d"><strong><span style="color: #40844d"><strong>添加|编辑</strong></span></strong></span><strong><br />
</strong>在&ldquo;文章分类管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到添加文章分类页面 <br />
在&ldquo;文章分类管理&rdquo;页面中选择要编辑的文章分类，然后点&ldquo;编辑&rdquo;按钮后链接到添加文章分类的页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('124','61','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">管理商城的文章，包括添加|编辑|删除。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">一个文章只能属于一个分类；<br />
外部文章是指其它网站上面的文章，只需添加一个外部链接即可；<br />
只有在标记为&ldquo;在前台显示&rdquo;才会在前台显示；</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;文章标题|文章类别|文章属性|文章类型 |作者/发布人|是否在前台显示|是否置顶|是否允许评论|发布时间&rdquo;，文章标题|作者/发布人为模糊查询，发布时间为区间查询点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的文章, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;文章管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到添加文章页面 <br />
在&ldquo;文章管理&rdquo;页面中选择要编辑的文章，然后点&ldquo;编辑&rdquo;按钮后链接到添加文章的页面 <br />
添加页面和编辑页面是同一个页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('125','68','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">管理商城文章的评论，包括回复|审核|取消审核|删除文章评论。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">只有审核过的文章评论才能在才台显示；<br />
如果参数设置里面&ldquo;文章评论审核&rdquo;设置为开启则文章评论必需需要审核才能显示，设为关闭文章评论不需要审核也能显示；</font><br />
<br />
<strong>审核|取消审核文章评论<br />
</strong></span>选中需要审核的文章评论, 点击&ldquo;审核&rdquo;按钮即可完成审核操作<br />
选中需要取消审核的文章评论, 点击&ldquo;取消审核&rdquo;按钮即可完成取消审核操作。<br />
<br />
<span style="color: #40844d"><strong>查看文章评论</strong></span><strong><br />
</strong>选中需要查看的文章评论, 点击&ldquo;查看评论&rdquo;按钮即可查看文章评论。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('126','38','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">订阅类型只是为了方便客户订阅的时候可以选择订阅不同的邮件的一个说明，例如，报刊，杂志。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">此处的订阅类型只是在前台邮件订阅的地方的一个显示，实际上并没有对订阅邮件分类。</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件为&ldquo;订阅类型名称&rdquo;，订阅类型名称为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的订阅类型名称, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。 <br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;订阅类型管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会弹出添加订阅类型的页面。 <br />
在&ldquo;订阅类型管理&rdquo;页面中选择要编辑的菜单，然后点&ldquo;编辑&rdquo;按钮后会弹出添加订阅类型的页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('127','39','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">商家可以管理邮件订阅列表，包括确认，退订，删除。只有确认过的订阅请求才有效。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">只有已确认过的订阅人才能发送订阅邮件。<br />
</font><br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;邮件地址|订阅人姓名|订阅类型|订阅状态&rdquo;，邮件地址|订阅人姓名为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的订阅人名称, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。 <br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
选中需要的订阅人, 点击&ldquo;确认&rdquo;按钮即可完成确认订阅操作。<br />
选中需要的订阅人, 点击&ldquo;退订&rdquo;按钮即可完成退订操作。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('128','44','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">分类管理系统中的邮件，包括添加|编辑|删除。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">一个邮件只能属于一个邮件类别，邮件类别只是为了方便管理邮件用，系统邮件这个邮件类别是默认的邮件类别，不能删除。<br />
</font><br />
<strong>查询<br />
</strong></span>查询的条件为&ldquo;邮件类别名称&rdquo;，邮件类别名称为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的邮件类别, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。 <br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;邮件类别管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到邮件类别添加的页面。 <br />
在&ldquo;邮件类别管理&rdquo;页面中选择要编辑的邮件类别，然后点&ldquo;编辑&rdquo;按钮后会链接到邮件类别添加的页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('129','49','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">管理系统中的邮件，包括添加|编辑|删除，可以根据自已的需要添加添加新的邮件。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">系统中包括一些自带的邮件，不能删除。<br />
</font><br />
<strong>查询<br />
</strong></span>查询的条件为&ldquo;邮件类别名称&rdquo;，邮件类别名称为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的邮件类别, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。 <br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;邮件内容管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到邮件内容添加的页面。 <br />
在&ldquo;邮件内容管理&rdquo;页面中选择要编辑的邮件内容，然后点&ldquo;编辑&rdquo;按钮后会链接到邮件内容添加的页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('130','51','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">邮件组是为了方便群发邮件而对会员进行分组，对会员的一个重新分组，包括添加|编辑|删除 ，一个邮件组可以添加多个会员，一个会员可以属于多个邮件组。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">一个会员可以属于多个邮件组；删除邮件组后会员并没有删除。</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件为&ldquo;邮件组名称&rdquo;，邮件组名称为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的邮件组, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;邮件组管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到邮件组添加的页面。 <br />
在&ldquo;邮件组管理&rdquo;页面中选择要编辑的邮件组，然后点&ldquo;编辑&rdquo;按钮后会链接到邮件组添加的页面。<br />
<br />
<span style="color: #40844d"><strong>添加组会员</strong></span><br />
选中会员组, 点击&ldquo;添加组会员&rdquo;按钮链接到给邮件组添加会员页面 </span></p>')
 
INSERT INTO Web_PageHelp VALUES ('131','212','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">邮件群发中包括4种发送对象，分别为&ldquo;所有会员|邮件组会员|等级会员|订阅会员&rdquo;。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">订阅会员是指在前台订阅会员。<br />
</font></span><br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
发送对象为所有会员在&ldquo;邮件内容管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到邮件内容添加的页面。 <br />
在&ldquo;邮件内容管理&rdquo;页面中选择要编辑的邮件内容，然后点&ldquo;编辑&rdquo;按钮后会链接到邮件内容添加的页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('132','53','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">查看邮件发送记录,查看邮件的发送情况。系统会记录每一次的邮件发送情况，可以查看邮件是否发送成功，可以对没有发送成功的邮件进行重发，删除邮件发送记录。<br />
<br />
</font><strong><span style="color: #40844d">查询</span><br />
</strong><font color="#000000">查询的条件依次为&ldquo;邮件标题|发送对象|Email地址|发送日期|发送状态|定时发送&rdquo;，邮件标题|发送对象|Email地址为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
</font><br />
<strong><span style="color: #40844d"><strong>删除</strong></span><br />
</strong></span>选中需要删除的记录, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。<br />
<br />
<span style="color: #40844d"><strong>发送</strong></span><strong><br />
</strong>选中需要发送的邮件, 点击&ldquo;发送&rdquo;按钮即可。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('133','90','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">邮件变量表是对变量字段的一个分类，用于系统扩展，系统默认有&ldquo;邮件订阅|拟卡|缺货登记|发货通知表|订单表|产品表|会员表&rdquo;这些邮件变量表。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">标为不可删除的邮件变量表是不能被删除，此模块用于系统扩展。</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;表名|是否可删除&rdquo;，表名为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的邮件变量表, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。 <br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;邮件变量列表&rdquo;页面点&ldquo;添加&rdquo;按钮后会弹出添加邮件变量表页面。 <br />
在&ldquo;邮件变量列表&rdquo;页面中选择要编辑的邮件变量，然后点&ldquo;编辑&rdquo;按钮后弹出添加邮件变量的页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('134','91','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">邮件变量字段是用于邮件模板中，管理邮件变量表中的字段，用于系统扩展。<br />
<br />
</font><strong><span style="color: #40844d">查询</span><br />
</strong><font color="#000000">查询的条件依次为&ldquo;表名&rdquo;，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。</font><br />
</span><br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的邮件变量表字段 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;邮件变量字段&rdquo;页面点&ldquo;添加&rdquo;按钮后会弹出添加邮件变量字段页面。<br />
在&ldquo;邮件变量字段&rdquo;页面中选择要编辑的邮件变量字段，然后点&ldquo;编辑&rdquo;按钮后弹出添加邮件变量字段的页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('138','27','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">管理商城后台的登录用户，包括添加，编辑，删除，彻底删除。锁定过的用户是不能登录。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">一个操作员只能属于一个部门。一个操作员可以拥有多个权限组的权限。</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;姓名|部门|状态|锁定状态&rdquo;，姓名为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的用户, 点击&ldquo;删除&rdquo;按钮即可。删除后可以恢复，此处的删除把数据放入了回收站，删除过的用户是不可以再登录。<br />
<br />
<span style="color: #40844d"><strong>彻底删除</strong></span><br />
选中需要彻底删除的用户, 点击&ldquo;彻底删除&rdquo;按钮即可。删除后不可以恢复。<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;用户管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会弹出用户添加的页面 <br />
在&ldquo;用户管理&rdquo;页面中选择要编辑的用户，然后点&ldquo;编辑&rdquo;按钮后弹出用户编辑的页面 <br />
添加页面和编辑页面是同一个页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('139','33','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">对后台登录用户进行部分划分，包括添加，编辑，删除，一个部门可以包括多个用户，一个用户只能属于一个部门。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">这里的部门我们可以理解为一个用户的分类，当然我们也可以理解为一般公司的部门，对于个人用户来说，如果不需要多个管理员来操作商城后台的话，可以只分一个部门即可。</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;部门名称|状态&rdquo;，部门名称为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的部门, 点击&ldquo;删除&rdquo;按钮即可。删除后可以恢复，此处的删除把数据放入了回收站。 <br />
<br />
<span style="color: #40844d"><strong>彻底删除</strong></span><br />
在选中需要彻底删除的部门, 点击&ldquo;彻底删除&rdquo;按钮即可。删除后不可以恢复。<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在在&ldquo;部门管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会弹出用户添加的页面 <br />
在&ldquo;部门管理&rdquo;页面中选择要编辑的部门，然后点&ldquo;编辑&rdquo;按钮后弹出部门编辑的页面 <br />
添加页面和编辑页面是同一个页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('140','34','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">部门分配用户管理是用于批量改变用户所属的部门。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">如果我们只想改变某个操作员所属的部门，只需要在操作员管理模板编辑操作员，然后分配新的部门。当然也可以在部分配里操作。如果我们要改变多个操作员的部门，可以选择使用此功能。</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;用户姓名|部门&rdquo;，用户姓名为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('141','36','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">权限组是对功能的一个分类，管理员可以根据系统的需要添加多权限组，包括添加，编辑，删除。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">添加权限组后需要分配权限组。</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;权限组名称|状态&rdquo;，权限组名称为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的权限组, 点击&ldquo;删除&rdquo;按钮即可。删除后可以恢复，此处的删除把数据放入了回收站。<br />
<br />
<span style="color: #40844d"><strong>彻底<span style="color: #40844d"><strong>删除</strong></span></strong></span><br />
选中需要删除的权限组, 点击&ldquo;删除&rdquo;按钮即可。删除后可以恢复，此处的删除把数据放入了回收站。<br />
<br />
<span style="color: #40844d"><strong><span style="color: #40844d"><strong>添加|编辑</strong></span></strong></span><br />
在&ldquo;权限组管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会弹出权限组添加的页面 <br />
在&ldquo;权限组管理&rdquo;页面中选择要编辑的部门，然后点&ldquo;编辑&rdquo;按钮后弹出权限组编辑的页面 <br />
添加页面和编辑页面是同一个页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('143','29','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">权限组功能是给相应的权限组分配相应的功能，即相应的页面权限。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">给权限组分配了功能后，只要给操作员分配了该权限组该操作员就拥用了该权限组对应功能的权限了。<br />
</font><br />
<strong>查询<br />
</strong></span>查询的条件为&ldquo;权限组名&rdquo;，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<span style="color: #40844d"><strong><br />
删除</strong></span><strong><br />
</strong>选中需要删除的权限组功能 点击&ldquo;删除&rdquo;按钮即可。删除后不可以恢复。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('144','30','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">管理系统中的页面，包括添加，编辑，删除。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">目前系统中我们能访问的页面都是通过此页面添加到数据库中，此功能为了方便系统的扩展。</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;一级目录|二级目录|状态|页面名称|源文件名称&rdquo;，页面名称|源文件名称为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的页面, 点击&ldquo;删除&rdquo;按钮即可。删除后可以恢复，此处的删除把数据放入了回收站。<br />
<br />
<span style="color: #40844d"><strong>彻底删除</strong></span><br />
选中需要彻底删除的页面, 点击&ldquo;彻底删除&rdquo;按钮即可。删除后不可以恢复。<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;页面管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会弹出页面添加的页面 <br />
在&ldquo;页面管理&rdquo;页面中选择要编辑的页面，然后点&ldquo;编辑&rdquo;按钮后弹出页面编辑的页面 <br />
添加页面和编辑页面是同一个页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('145','35','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">管理系统中页的的控件，包括添加，编辑，删除。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">被添加过的页面中的控件我们才可以设置该控件的访问权限。</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件为&ldquo;页面名&rdquo;，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的页面控件 点击&ldquo;删除&rdquo;按钮即可。删除后可以恢复，此处的删除把数据放入了回收站。<br />
<br />
<span style="color: #40844d"><strong>彻底删除</strong></span><br />
选中需要彻底删除的页面控件, 点击&ldquo;彻底删除&rdquo;按钮即可。删除后不可以恢复。<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;页面控件管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会弹出页面控件添加的页面 <br />
在&ldquo;页面控件管理&rdquo;页面中选择要编辑的页面控件，然后点&ldquo;编辑&rdquo;按钮后弹出页面控件编辑的页面 <br />
添加页面和编辑页面是同一个页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('147','181','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">登录的管理员可以修改密码，在输入密码前要先输入旧密码，然后输入新密码和确认新密码。</font></span></span></p>')
 
INSERT INTO Web_PageHelp VALUES ('148','50','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">管理不同页面的帮助内容。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">此处的帮助显示在左边菜单中，可以自己修改。系统默认会有帮助。<br />
</font><br />
<strong>查询<br />
</strong></span>查询的条件为&ldquo;一级目录|二级目录|页面名称|源文件名称&rdquo;，页面名称|源文件名称为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>编辑</strong></span><strong><br />
</strong>在&ldquo;页面控件管理&rdquo;页面中选择要编辑的页面帮助，然后点&ldquo;编辑&rdquo;按钮后弹出后台帮助的页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('149','28','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">系统会记录管理员的每一次操作，可以按照自己的需要查看日志，清除日志。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">目前日志只起记录作用，不能对日志中的操作进行撤消操作。</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;操作者|操作IP|操作日期&rdquo;，操作者|操作IP为模糊查询，操作日期为区间查询,点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的日志, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。 <br />
<br />
<span style="color: #40844d"><strong>按时区间删除</strong></span><br />
勾选按时间清除日志，输入开始日期和结束，击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('150','22','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">短信管理是实现商家和会员之间的一个交流方式，商家可以通过短信管理模块来发送短信，阅读短信，删除短信。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">此处的短信只是站内短信，不是指手机短信。<br />
</font><br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;发件人|收件人|发送时间|标题&rdquo;，发件人|收件人|发送时间|标题为模糊查询，发送时间为区间查询,点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的来电速记记录, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。 <br />
<br />
<span style="color: #40844d"><strong>发送短信|阅读短信</strong></span><br />
在&ldquo;短信收件箱&rdquo;页面点&ldquo;发送短信&rdquo;按钮后会弹出发送短信的页面。 <br />
在&ldquo;短信收件箱&rdquo;页面中选择要阅读的短信，然后点&ldquo;阅读短信&rdquo;按钮后会弹出阅读短信的页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('151','23','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">商城管理员可以给会员添加短信。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">此处的短信只是站内短信，不是指手机短信。</font><br />
</span></span></p>')
 
INSERT INTO Web_PageHelp VALUES ('152','25','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">商家可以利用在线调查来对商城的一些功能进行调查，让商家更好的了解客户的需求，在线调查管理管理商城的所有在线调查，包括添加|编辑|删除在线调查|<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">在线调查有时间限制，结束的在线调查不会在前台显示</font><br />
<br />
<strong>查询<br />
</strong></span>选中需要删除的来电速记记录, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;在线调查管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会弹出添加在线调查的页面 <br />
在&ldquo;在线调查管理&rdquo;页面中选择要编辑的在线调查，然后点&ldquo;编辑&rdquo;按钮后会链接到在线调查的添加页面 <br />
添加页面和编辑页面是同一个页面</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('153','54','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">商家可以对访问商城的用户进行限制，包括商城页面和后台页面，限制过的用户或IP将无法登录系统。包括添加|编辑|删除IP过滤。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">IP过滤有时间限制，在屏蔽开始日期和屏蔽结束日期之内的才有效。</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;屏蔽用户|屏蔽开始日期|屏蔽结束日期&rdquo;，屏蔽用户|屏蔽开始日期|屏蔽结束日期为模糊查询，屏蔽开始日期|屏蔽结束日期为区间查询,点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<span style="color: #40844d"><strong><br />
删除</strong></span><strong><br />
</strong>选中需要删除的IP, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;IP过滤管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会弹出添加过滤IP的页面 <br />
在&ldquo;IP过滤管理&rdquo;页面中选择要编辑的IP，然后点&ldquo;编辑&rdquo;按钮后会弹链接到添加IP的页面 <br />
添加页面和编辑页面是同一个页面</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('154','202','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>网站空间查看<br />
</strong><font color="#000000">可以查看网站的目录空间占用情况，即查看每一个目录所占用空间的大小。<br />
</font><strong><span style="color: #40844d"><br />
注意</span><br />
</strong><font color="#000000">只能查看服务器上面的文件夹占用资源的大小。</font></span></span></p>')
 
INSERT INTO Web_PageHelp VALUES ('155','56','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">菜单类别是对系统中用到的菜单进行分类管理，包括添加|编辑|删除，菜单类别管理用于系统扩展。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">菜单类别是对菜单的一个分类，为了方便系统扩展而设计的，不会在前台的页面显示。默认安装后系统中的有一些默认的菜单,状态都标为&ldquo;不可删除&rdquo;，请不要删除这些默认的菜单。</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;类别名称|是否可删除&rdquo;，类别名称为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的菜单类别, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。 <br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;菜单类别管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会弹出添加菜单类别的页面 <br />
在&ldquo;菜单类别管理&rdquo;页面中选择要编辑的菜单，然后点&ldquo;编辑&rdquo;按钮后会弹出添加菜单类别的页面 <br />
添加页面和编辑页面是同一个页面</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('156','55','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">菜单管理是对系统中用到的菜单进行管理，包括添加|编辑|删除，菜单管理用于系统扩展。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">菜单是为了方便系统扩展而设计的，不会在前台的页面显示。默认安装后系统中的有一些默认的菜单,状态都标为&ldquo;不可删除&rdquo;，请不要删除这些默认的菜单。</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;菜单名称|菜单类别|是否可删除&rdquo;，菜单名称为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的菜单, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;菜单管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会弹出添加菜单的页面 <br />
在&ldquo;菜单管理&rdquo;页面中选择要编辑的菜单，然后点&ldquo;编辑&rdquo;按钮后会弹出添加菜单的页面 <br />
添加页面和编辑页面是同一个页面</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('157','66','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">品牌管理可以对商品品牌进行添加，编辑，删除操作。一个商品只能属于一个品牌，在添加品牌的时候可以为品牌关联多个商品分类。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">品牌可以和商品分类关联，但只能和顶级商品分类关联。添加的品牌只有标记为在前台显示才会在前台看到。</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件为&ldquo;品牌名称&rdquo;，牌名称使用模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的品牌, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。<br />
&nbsp;<br />
<span style="color: #40844d"><strong>向上|向下</strong></span><br />
选中要移动的品牌，然后点&ldquo;向上|向下&rdquo;按钮会对品牌进行排序。<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;品牌管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到优惠方案添加页面 <br />
在&ldquo;品牌管理&rdquo;页面中选择要编辑的品牌，然后点&ldquo;编辑&rdquo;按钮后会链接到品牌编辑页面 <br />
添加页面和编辑页面是同一个页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('158','11','','<span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">管理系统中用到的地区，支持4级地区。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">在添加一级地区的时候,要选中&ldquo;是否为一级地区&rdquo;勾选框。<br />
<br />
<span style="font-size: 12px"><span style="color: #40844d"><strong>地区管理<br />
</strong><font color="#000000">地区分为一级地区|二级地区|三级地区|四级地区，即表示国家|省份|城市|区/县，在参数设置的能修改地区的名称。<br />
<br />
</font><strong><span style="color: #40844d">添加|编辑</span><br />
</strong><font color="#000000">描述添加地区的时候只要选中它的上级地区，然后输入地区的名称，点&ldquo;确定&rdquo;可完成操作，如果添加的是一级地区，需要勾选&ldquo;是否为一级地区&rdquo;框。编辑的时候只要选中要编辑的地区，点编辑按钮，修改地区的名称，点更新按钮完成操作。<br />
地区名称：<br />
地区的名称<br />
是否为一级地区：<br />
当添加地区的时候如果勾选了此项，表示为一级地区&rdquo;。<br />
<br />
<span style="font-size: 12px"><span style="color: #40844d"><strong>删除<br />
</strong><font color="#000000">选中需要删除的地区,点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。</font></span></span></font></span></span></font></span></span>')
 
INSERT INTO Web_PageHelp VALUES ('160','12','','<span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">系统中集成了国内一些配送方式，商家可以根据自己的需要安装|卸载配送方式，不同的配送方式的计算费用不一样，可以为一种配送方式添加多个配送区域.<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">威博官方提供配送方式插件的下载（免费）。可以每一种配送方式设置不同的配送区域，具体的请见配送区域设置<br />
<br />
<strong><span style="color: #40844d">安装|卸载</span><br />
</strong><font color="#000000">选中未安装的配送方式，点击&ldquo;安装&rdquo;按钮即可。选中已安装的配送方式，点击&ldquo;卸载&rdquo;按钮即可。<br />
<br />
<strong><span style="color: #40844d">设置配送区域</span><br />
</strong><font color="#000000">选中配送方式，点击&ldquo;设置配送区域&rdquo;按钮会跳转到&ldquo;配送区域管理&rdquo;页面，在配送区域管理页面可添加该配送方式的配送区域，具体操作见配送区域管理。</font></font></font></span></span>')
 
INSERT INTO Web_PageHelp VALUES ('161','19','','<span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">系统可以设置多个邮件服务器的帐号，以及每一个帐户的邮件发送方式，但每次只能有一个帐号是启用的。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">当添加了多个邮件服务器的帐号后，其中只有一个是启用的，当在发送邮件的时候失败的时候请检查设置是否正确。<br />
<br />
<strong><span style="color: #40844d">删除</span><br />
</strong><font color="#000000">选中需要删除的邮件服务器, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。<br />
<br />
<strong><span style="color: #40844d">添加|编辑</span><br />
</strong><font color="#000000">在&ldquo;邮件服务器管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到邮件服务器添加页面 <br />
在&ldquo;邮件服务器管理&rdquo;页面中选择要编辑的邮件服务器，然后点&ldquo;编辑&rdquo;按钮后会链接到邮件服务器编辑页面 <br />
添加页面和编辑页面是同一个页面。</font></font></font></span></span>')
 
INSERT INTO Web_PageHelp VALUES ('162','219','','<span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">商城的信息，在底部显示，包括添加，编辑，删除。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">底部栏目是显示在商城的底部。<br />
<br />
<strong><span style="color: #40844d">查询</span><br />
</strong><font color="#000000">查询的条件为&ldquo;信息标题&rdquo;，信息标题为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<strong><span style="color: #40844d">删除</span><br />
</strong><font color="#000000">选中需要删除的信息, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。<br />
<br />
<strong><span style="color: #40844d">向上|向下</span><br />
</strong><font color="#000000">选中要移动的信息，然后点&ldquo;向上|向下&rdquo;按钮会对信息进行排序。<br />
<br />
<strong><span style="color: #40844d">添加|编辑</span><br />
</strong><font color="#000000">在&ldquo;底部栏目管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到信息设置添加页面 <br />
在&ldquo;底部栏目管理&rdquo;页面中选择要编辑的信息，然后点&ldquo;编辑&rdquo;按钮后会链接到信息编辑页面 。</font></font></font></font></font></span></span>')
 
INSERT INTO Web_PageHelp VALUES ('163','73','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">商家可以对会员进行等级划分，包括添加|编辑|删除。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">系统中只有一个会员等级是默认的。</font><br />
<br />
<strong>删除<br />
</strong></span>选中需要删除的会中员等级, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><strong><br />
</strong>在&ldquo;会员等级管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到添加会员等级的页面<br />
在&ldquo;会员等级管理&rdquo;页面中选择要编辑的会员等级，然后点&ldquo;编辑&rdquo;按钮后会链接到会员等级添加的页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('164','76','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">管理会员卡，包括添加|删除会员卡，锁定会员卡，查看会员卡使用记录。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">锁定过的会员卡不能被使用；每一个会员只能分配一个会员卡；前台会员注册的时候会自动为会员分配一个金额为0的会员卡。</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;卡号|发卡人|持卡人|发放批次|分配状态|锁定状态|发卡时间&rdquo;，卡号|发卡人|持卡人为模糊查询，发放批次为精确查询，发卡时间为时间区间查询,点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的会员卡, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。 <br />
<br />
<span style="color: #40844d"><strong>锁定|取消锁定</strong></span><br />
当我们想禁止会员使用会员卡。可以将会员卡锁定，如果该会员卡未被分配给会员并且处于锁定状态，此时将无法分配给会员，只有未被锁定的会员卡才能分配给会员，选择要锁定的会员卡，点击&ldquo;锁定&rdquo;按钮可锁定会员卡，取消锁定和锁定操作相同。<br />
<br />
<span style="font-size: 12px"><span style="color: #40844d"><strong>添加|编辑<br />
</strong><font color="#000000">在&ldquo;会员卡管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到会员卡添加页面<br />
在&ldquo;会员卡管理&rdquo;页面中选择要编辑的会员卡，然后点&ldquo;编辑&rdquo;按钮后会链接到会员卡编辑页面<br />
添加页面和编辑页面是同一个页面。<br />
</font></span></span></span></p>')
 
INSERT INTO Web_PageHelp VALUES ('165','81','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">管理充值卡，包括添加|删除充值卡，充值卡可以给会员卡里面充值。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">一个充值卡只能充一次。<br />
</font><br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;卡号|发卡人|持卡人|发放批次|出售状态|充值状态|发卡时间|是否需要验|是否实体发售&rdquo;，卡号|发卡人|持卡人为模糊查询，发放批次为精确查询，发卡时间为时间区间查询,点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的充值卡, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('166','62','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>问题标题<br />
</strong><font color="#000000">问题的标题来电人姓名 来电人的姓名来电号码 来电的电话来电时间 来电的时间问题内容 来电者提的问题接待人姓名 接待人的姓名。<br />
<br />
</font><strong><span style="color: #40844d">默认为登录的用户说明</span><br />
</strong><font color="#000000">一些说明，记录一些基本的信息处理状态 包括&ldquo;未处理|已处理|无法处理&rdquo;，可以选择此次操作处理状态。</font></span></span></p>')
 
INSERT INTO Web_PageHelp VALUES ('167','32','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">可以为用户分配权限组，但给用户分配了权限组后，该用户就拥有了该权限组的功能。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">可以给一个操作员分配多个权限组，那么该操作员就拥有了被分配的权限组对应的权限了。<br />
<br />
<strong><span style="color: #40844d">查询</span><br />
</strong><font color="#000000">查询的条件依次为&ldquo;用户名称|权限组&rdquo;，用户名称为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据。</font></font></span></span></p>')
 
INSERT INTO Web_PageHelp VALUES ('168','45','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">为不同的权限组分配不同页面的控件的操作权限。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">被添加过的页面中的控件我们才可以设置该控件的访问权限。<br />
<br />
</font></span></span></p>
<p><span style="font-size: 12px"><span style="color: #40844d"><strong>权限组名称<br />
</strong><font color="#000000">列表了系统中的角色，选择要设置权限的权限组。<br />
<br />
</font><strong><span style="color: #40844d">页面名称</span><br />
</strong><font color="#000000">当选择了权限组后，列表中会列出该权限组能控制的页面。<br />
<br />
<strong><span style="color: #40844d">页面控件功能</span><br />
</strong><font color="#000000">当选择了页面后，会列出该页面中能控制权限的控件，可以通过修改控件的&ldquo;是否可见&rdquo;和&ldquo;是否可用&rdquo;来控制控件的权限。</font><br />
</font></span></span></p>
<p><br />
</p>')
 
INSERT INTO Web_PageHelp VALUES ('169','214','','<span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">系统中集成了国内一些常用的支付方式，商家可以根据自己的需要安装|卸载支付方式，第一种支付方式的使用说明请见支付方式说明。.<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">会员卡和购物卡支付方式是V5Shop独有的支付方式，当选择了会员卡支付后可在前台会员中心用会员卡支付，当选择了购物卡支付的时候可在前台用购物卡支付。<br />
<br />
<strong><span style="color: #40844d">安装|卸载</span><br />
</strong><font color="#000000">选中未安装的支付方式，点击&ldquo;安装&rdquo;按钮即可。选中已安装的支付方式，点击&ldquo;卸载&rdquo;按钮即可。<br />
<br />
<strong><span style="color: #40844d">编辑支付方式<br />
</span></strong><font color="#000000">选中支付方式，点击&ldquo;编辑&rdquo;按钮会跳转到&ldquo;支付方式编辑&rdquo;页面，在支付方式编辑页面可修改该支付方式的相关信息。</font></font></font><br />
</span></span>')
 
INSERT INTO Web_PageHelp VALUES ('170','20','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">商家可以为商城添加友情链接。友情链接分为文字链接和图片链接，后台的友情链接管理专门用于管理友情链接<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">友情链接包括图片链接和文字链接，两者的区别在于图片链接在前台展示的时候是显示图片，而文字链接在前台展示的时候是文字</font><br />
<br />
<strong>查询<br />
</strong></span>查询的条件依次为&ldquo;链接标题|链接分类&rdquo;，链接标题为模糊查询，点查询按钮后会在列表中显示相关的数据，如果没有数据显示&ldquo;无相关数据<br />
<br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的友情链接, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复<br />
<br />
<span style="color: #40844d"><strong>向上&gt;|向下</strong></span><strong><br />
</strong>选中要移动的项，然后点&ldquo;向上|向下&rdquo;按钮会对记录进行排序<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在在&ldquo;友情链接管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到友情链接添加页面<br />
在&ldquo;友情链接管理&rdquo;页面中选择要编辑的友情链接，然后点&ldquo;编辑&rdquo;按钮后会链接到友情链接编辑页面<br />
添加页面和编辑页面是同一个页面<br />
友情链接添加|编辑 </span></p>')
 
INSERT INTO Web_PageHelp VALUES ('172','231','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">可以统计在一个地区的一段时间的会员注册情况。<br />
<br />
</font><strong><span style="color: #40844d">统计</span><br />
</strong><font color="#000000">可根据会员等级，会员性别，和注册时间来查询并统计，统计页面如[图18.2]。<br />
</font><br />
<strong>保存到Excel<br />
</strong></span>选择要导出到Excel的记录点&ldquo;保存到Excel&rdquo;按钮会保存到Excel。<br />
<br />
<span style="color: #40844d"><strong>会员统计概况</strong></span><strong><br />
</strong>在图所示的页面中点&ldquo;统计概况&rdquo;会链接到所示页面，统计概况中包括会员购买率|每会员平均订单数及购物额|非会员购买率|综合统计。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('173','232','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">可以统计在一个地区的一段时间的会员注册情。<br />
<br />
</font><strong><span style="color: #40844d">统计</span><br />
</strong><font color="#000000">可根据会员等级，会员性别，和注册时间，购买城市来查询并统计，统计页面如。</font><br />
<br />
<strong>保存到Excel<br />
</strong></span>选择要导出到Excel的记录点&ldquo;保存到Excel&rdquo;按钮会保存到Excel。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('174','245','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">当站点访问模式设为&ldquo;动态模式&rdquo;时，系统中运用了缓存，如果需要手动清理缓存可运用此功能。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">只有当站点访问模式设为&ldquo;动态模式&rdquo;时，才需要清理缓存。</font></span></span></p>')
 
INSERT INTO Web_PageHelp VALUES ('176','67','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">商品分类管理是对商品进行分类管理，包括添加，编辑，删除操作，一个商品只能属于一个分类，在添加分类的时候可以为分类关联多个商品品牌。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">添加商品分类的时候可以和商品品牌关联，只有一级分类可以和商品品牌关联;只有标为显示的分类才会在前台显示。</font><br />
</span><br />
<span style="color: #40844d"><strong>删除</strong></span><strong><br />
</strong>选中需要删除的商品分类, 点击&ldquo;删除&rdquo;按钮即可。删除后不可恢复。<br />
<br />
<span style="color: #40844d"><strong>添加|编辑</strong></span><br />
在&ldquo;商品分类管理&rdquo;页面点&ldquo;添加&rdquo;按钮后会链接到商品分类添加页面<br />
在&ldquo;商品分类管理&rdquo;页面中选择要编辑的商品分类，然后点&ldquo;编辑&rdquo;按钮后会链接到商品分类编辑页面<br />
添加页面和编辑页面是同一个页面。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('177','251','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">为了保护系统的数据，V5Shop提供了数据库备份和还原功能。点&ldquo;立即备份&rdquo;按钮即可完成备份功能。<br />
<br />
</font></span></span></p>')
 
INSERT INTO Web_PageHelp VALUES ('178','252','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">备份过的数据库可以选择性的恢复。<br />
<span style="font-size: 12px"><span style="color: #40844d"><strong><br />
注意<br />
</strong><font color="#000000">如果要恢复数据库，只需选择要恢复的数据库备份卷即可。<br />
</font></span></span><br />
<br />
</font></span></span></p>')
 
INSERT INTO Web_PageHelp VALUES ('179','247','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">页面发布是按照系统的功能来分开发布，包括主站发布，商城系统，文章系统，其它系统，当我们只需要更新部分页面的时候才会用到此功能。<br />
<br />
</font><strong><span style="color: #40844d">主站发布</span><br />
</strong><font color="#000000">在发布首页列表中选择需要发布的页面点发布按钮即可发布。</font><br />
<br />
<strong>商城发布<br />
</strong></span>包括&ldquo;系统商品发布&rdquo;和&ldquo;系统分类发布&rdquo;；系统商品发布包括&ldquo;发布所有商品|发布最新商品|按ID发布|按日期发布|按分类发布&rdquo;；系统分类发布包括&ldquo;发布所有分类|发布选择分类&rdquo;。<br />
<br />
<span style="color: #40844d"><strong>注意</strong></span><strong><br />
</strong>发布最新商品中输入的数字是指最新的前多少个商品，例如为20，则发布前20个最新的商品；按ID发布是输入ID的编号区间，例如如果要发布ID在2000至2500之间，则只需输入2000,2500即可；按日期发布只需输入添加商品的日期区间即可，例如如果要发布2008-5-1到2008-5-31，则只需输入日期区间即可。<br />
<br />
<span style="color: #40844d"><strong>其它系统</strong></span><br />
包括&ldquo;发布所有品牌|发布所有帮助类别|发布所有帮助|发布所有活动|发布所有团购|发布所有夺宝骑兵|发布所有公告|发布所有信息|发布所有导购&rdquo;。</span></p>')
 
INSERT INTO Web_PageHelp VALUES ('180','248','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">当我们需要全站发布时，可以使用一键发布功能。<br />
</font></span></span></p>')
 
INSERT INTO Web_PageHelp VALUES ('182','58','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>暂时还没有该部分内容</strong></span></span></p>')
 
INSERT INTO Web_PageHelp VALUES ('183','63','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>暂时还没有该部分内容</strong></span></span></p>')
 
INSERT INTO Web_PageHelp VALUES ('184','64','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>暂时还没有该部分内容</strong></span></span></p>')
 
INSERT INTO Web_PageHelp VALUES ('185','246','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>描述<br />
</strong><font color="#000000">站点支持三种访问模式动态模式，静态HTML模式，URL重写模式。<br />
<br />
</font><strong>动态模式：</strong><font color="#000000">动态模式下网站页面实际上并不是独立存在于服务器上，只有当用户请求时服务器才返回一个完整的网页，优点是交互性强，添加的数据能立即显示在前台。缺点是目前为止搜索引擎对动态页面的抓取仍然不太理想，但我们采用了相应的技术优化了搜索。<br />
<br />
</font><strong>静态HTML模式：</strong><font color="#000000">设置生效后网站页面会被转换为独立的网页文件，以HTML文件形式存储在服务器上；从而促进搜索引擎抓取，提升网站排名。<br />
<br />
</font><strong>URL重写模式：</strong><font color="#000000">通常又被称为伪静态，是截取传入 Web 请求并自动将请求重定向到其他 URL 的过程。比如浏览器发来请求 hostname/123.aspx ，服务器自动将这个请求中定向为<a href="http://hostname/list.aspx">http://hostname/list.aspx</a> ?id=123。url重写的优点是缩短url，隐藏实际路径提高安全性,易于用户记忆和键入,易于被搜索引擎收录。<br />
<br />
</font><strong><span style="color: #40844d">注意</span><br />
</strong><font color="#000000">1、站点模试设为&ldquo;动态模式&rdquo;或&ldquo;URL重写模式&rdquo;时，操作任何步骤，必须清空缓存否则在前台界面不会显示。同时可以到缓存文件清理页面清理缓存文件。</font></span></span></p>
<p><span style="font-size: 12px"><span style="color: #40844d"><font color="#000000">2、站点模式设为&ldquo;静态HTML模式&rdquo;时，操作任何步骤，必须把页面发布或者整站发布，否则前台界面不会显示。<br />
</font></span></span></p>')
 
INSERT INTO Web_PageHelp VALUES ('186','10','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>暂时还没有该部分内容</strong></span></span></p>')
 
INSERT INTO Web_PageHelp VALUES ('187','79','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>暂时还没有该部分内容</strong></span></span></p>')
 
INSERT INTO Web_PageHelp VALUES ('188','41','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>暂时还没有该部分内容</strong></span></span></p>')
 
INSERT INTO Web_PageHelp VALUES ('189','46','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>暂时还没有该部分内容</strong></span></span></p>')
 
INSERT INTO Web_PageHelp VALUES ('190','42','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>暂时还没有该部分内容</strong></span></span></p>')
 
INSERT INTO Web_PageHelp VALUES ('191','98','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>暂时还没有该部分内容</strong></span></span></p>')
 
INSERT INTO Web_PageHelp VALUES ('192','43','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>暂时还没有该部分内容</strong></span></span></p>')
 
INSERT INTO Web_PageHelp VALUES ('193','47','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>暂时还没有该部分内容</strong></span></span></p>')
 
INSERT INTO Web_PageHelp VALUES ('194','52','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>暂时还没有该部分内容</strong></span></span></p>')
 
INSERT INTO Web_PageHelp VALUES ('195','48','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>暂时还没有该部分内容</strong></span></span></p>')
 
INSERT INTO Web_PageHelp VALUES ('196','234','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>暂时还没有该部分内容</strong></span></span></p>')
 
INSERT INTO Web_PageHelp VALUES ('197','235','','<p><span style="font-size: 12px"><span style="color: #40844d"><strong>暂时还没有该部分内容</strong></span></span></p>')
 
CREATE TABLE dbo.Tmp_Web_PageHelp([ID] [int]  NOT NULL IDENTITY (1, 1),[PageID] [int]  NOT NULL,[Language] [nvarchar] (10)  NULL,[Content] [ntext]  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_PageHelp ADD CONSTRAINT DF_Tmp_Web_PageHelp_PageID DEFAULT ((0)) FOR [PageID]
 
SET IDENTITY_INSERT dbo.Tmp_Web_PageHelp ON
 
IF EXISTS(SELECT * FROM dbo.Web_PageHelp) EXEC('INSERT INTO dbo.Tmp_Web_PageHelp ([ID],[PageID],[Language],[Content]) SELECT [ID],[PageID],[Language],[Content] FROM dbo.Web_PageHelp WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_PageHelp OFF
 
DROP TABLE dbo.Web_PageHelp
 
EXECUTE sp_rename N'dbo.Tmp_Web_PageHelp', N'Web_PageHelp', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_ShippingAdvice]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_ShippingAdvice] 
 
CREATE TABLE dbo.Web_ShippingAdvice([ID] [int]  NOT NULL,[UserName] [nvarchar] (50)  NOT NULL,[TrueName] [nvarchar] (50)  NOT NULL,[OrderNumber] [nvarchar] (100)  NOT NULL,[ExpressCompany] [nvarchar] (50)  NOT NULL,[ExpressNumber] [nvarchar] (50)  NOT NULL,[SendDate] [datetime]  NOT NULL,[Remark] [nvarchar] (250)  NOT NULL,[IsShow] [int]  NOT NULL,[IsRead] [int]  NOT NULL,[IsDel] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_ShippingAdvice ADD CONSTRAINT DF_Web_ShippingAdvice_UserName DEFAULT ('') FOR [UserName]
 
ALTER TABLE dbo.Web_ShippingAdvice ADD CONSTRAINT DF_Web_ShippingAdvice_TrueName DEFAULT ('') FOR [TrueName]
 
ALTER TABLE dbo.Web_ShippingAdvice ADD CONSTRAINT DF_Web_ShippingAdvice_OrderNumber DEFAULT ('') FOR [OrderNumber]
 
ALTER TABLE dbo.Web_ShippingAdvice ADD CONSTRAINT DF_Web_ShippingAdvice_ExpressCompany DEFAULT ('') FOR [ExpressCompany]
 
ALTER TABLE dbo.Web_ShippingAdvice ADD CONSTRAINT DF_Web_ShippingAdvice_ExpressNumber DEFAULT ('') FOR [ExpressNumber]
 
ALTER TABLE dbo.Web_ShippingAdvice ADD CONSTRAINT DF_Web_ShippingAdvice_SendDate DEFAULT (getdate()) FOR [SendDate]
 
ALTER TABLE dbo.Web_ShippingAdvice ADD CONSTRAINT DF_Web_ShippingAdvice_Remark DEFAULT ('') FOR [Remark]
 
ALTER TABLE dbo.Web_ShippingAdvice ADD CONSTRAINT DF_Web_ShippingAdvice_IsShow DEFAULT ((1)) FOR [IsShow]
 
ALTER TABLE dbo.Web_ShippingAdvice ADD CONSTRAINT DF_Web_ShippingAdvice_IsRead DEFAULT ((0)) FOR [IsRead]
 
ALTER TABLE dbo.Web_ShippingAdvice ADD CONSTRAINT DF_Web_ShippingAdvice_IsDel DEFAULT ((0)) FOR [IsDel]
 
CREATE TABLE dbo.Tmp_Web_ShippingAdvice([ID] [int]  NOT NULL IDENTITY (1, 1),[UserName] [nvarchar] (50)  NOT NULL,[TrueName] [nvarchar] (50)  NOT NULL,[OrderNumber] [nvarchar] (100)  NOT NULL,[ExpressCompany] [nvarchar] (50)  NOT NULL,[ExpressNumber] [nvarchar] (50)  NOT NULL,[SendDate] [datetime]  NOT NULL,[Remark] [nvarchar] (250)  NOT NULL,[IsShow] [int]  NOT NULL,[IsRead] [int]  NOT NULL,[IsDel] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_ShippingAdvice ADD CONSTRAINT DF_Tmp_Web_ShippingAdvice_UserName DEFAULT ('') FOR [UserName]
 
ALTER TABLE dbo.Tmp_Web_ShippingAdvice ADD CONSTRAINT DF_Tmp_Web_ShippingAdvice_TrueName DEFAULT ('') FOR [TrueName]
 
ALTER TABLE dbo.Tmp_Web_ShippingAdvice ADD CONSTRAINT DF_Tmp_Web_ShippingAdvice_OrderNumber DEFAULT ('') FOR [OrderNumber]
 
ALTER TABLE dbo.Tmp_Web_ShippingAdvice ADD CONSTRAINT DF_Tmp_Web_ShippingAdvice_ExpressCompany DEFAULT ('') FOR [ExpressCompany]
 
ALTER TABLE dbo.Tmp_Web_ShippingAdvice ADD CONSTRAINT DF_Tmp_Web_ShippingAdvice_ExpressNumber DEFAULT ('') FOR [ExpressNumber]
 
ALTER TABLE dbo.Tmp_Web_ShippingAdvice ADD CONSTRAINT DF_Tmp_Web_ShippingAdvice_SendDate DEFAULT (getdate()) FOR [SendDate]
 
ALTER TABLE dbo.Tmp_Web_ShippingAdvice ADD CONSTRAINT DF_Tmp_Web_ShippingAdvice_Remark DEFAULT ('') FOR [Remark]
 
ALTER TABLE dbo.Tmp_Web_ShippingAdvice ADD CONSTRAINT DF_Tmp_Web_ShippingAdvice_IsShow DEFAULT ((1)) FOR [IsShow]
 
ALTER TABLE dbo.Tmp_Web_ShippingAdvice ADD CONSTRAINT DF_Tmp_Web_ShippingAdvice_IsRead DEFAULT ((0)) FOR [IsRead]
 
ALTER TABLE dbo.Tmp_Web_ShippingAdvice ADD CONSTRAINT DF_Tmp_Web_ShippingAdvice_IsDel DEFAULT ((0)) FOR [IsDel]
 
SET IDENTITY_INSERT dbo.Tmp_Web_ShippingAdvice ON
 
IF EXISTS(SELECT * FROM dbo.Web_ShippingAdvice) EXEC('INSERT INTO dbo.Tmp_Web_ShippingAdvice ([ID],[UserName],[TrueName],[OrderNumber],[ExpressCompany],[ExpressNumber],[SendDate],[Remark],[IsShow],[IsRead],[IsDel]) SELECT [ID],[UserName],[TrueName],[OrderNumber],[ExpressCompany],[ExpressNumber],[SendDate],[Remark],[IsShow],[IsRead],[IsDel] FROM dbo.Web_ShippingAdvice WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_ShippingAdvice OFF
 
DROP TABLE dbo.Web_ShippingAdvice
 
EXECUTE sp_rename N'dbo.Tmp_Web_ShippingAdvice', N'Web_ShippingAdvice', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_ProductLink]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_ProductLink] 
 
CREATE TABLE dbo.Web_ProductLink([ProductID] [int]  NOT NULL,[LinkTo] [int]  NOT NULL,[IsSingle] [int]  NOT NULL,[OrderID] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_ProductLink ADD CONSTRAINT DF_Web_ProductLink_ProductID DEFAULT ((0)) FOR [ProductID]
 
ALTER TABLE dbo.Web_ProductLink ADD CONSTRAINT DF_Web_ProductLink_LinkTo DEFAULT ((0)) FOR [LinkTo]
 
ALTER TABLE dbo.Web_ProductLink ADD CONSTRAINT DF_Web_ProductLink_IsSingle DEFAULT ((0)) FOR [IsSingle]
 
ALTER TABLE dbo.Web_ProductLink ADD CONSTRAINT DF_Web_ProductLink_OrderID DEFAULT ((10000)) FOR [OrderID]
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_ArticleReview]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_ArticleReview] 
 
CREATE TABLE dbo.Web_ArticleReview([ID] [int]  NOT NULL,[ArticleID] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[UserName] [nvarchar] (50)  NULL,[Star] [int]  NOT NULL,[Title] [nvarchar] (50)  NULL,[Content] [nvarchar] (250)  NULL,[IP] [nvarchar] (20)  NULL,[Remark] [nvarchar] (250)  NULL,[RemarkDate] [datetime]  NOT NULL,[IsRemark] [int]  NOT NULL,[IsPass] [int]  NOT NULL,[ReviewTo] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_ArticleReview ADD CONSTRAINT DF_Web_ArticleReview_ArticleID DEFAULT ((0)) FOR [ArticleID]
 
ALTER TABLE dbo.Web_ArticleReview ADD CONSTRAINT DF_Web_ArticleReview_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Web_ArticleReview ADD CONSTRAINT DF_Web_ArticleReview_Star DEFAULT ((0)) FOR [Star]
 
ALTER TABLE dbo.Web_ArticleReview ADD CONSTRAINT DF_Web_ArticleReview_RemarkDate DEFAULT (getdate()) FOR [RemarkDate]
 
ALTER TABLE dbo.Web_ArticleReview ADD CONSTRAINT DF_Web_ArticleReview_IsRemark DEFAULT ((0)) FOR [IsRemark]
 
ALTER TABLE dbo.Web_ArticleReview ADD CONSTRAINT DF_Web_ArticleReview_IsPass DEFAULT ((0)) FOR [IsPass]
 
ALTER TABLE dbo.Web_ArticleReview ADD CONSTRAINT DF_Web_ArticleReview_ReviewTo DEFAULT ((0)) FOR [ReviewTo]
 
CREATE TABLE dbo.Tmp_Web_ArticleReview([ID] [int]  NOT NULL IDENTITY (1, 1),[ArticleID] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[UserName] [nvarchar] (50)  NULL,[Star] [int]  NOT NULL,[Title] [nvarchar] (50)  NULL,[Content] [nvarchar] (250)  NULL,[IP] [nvarchar] (20)  NULL,[Remark] [nvarchar] (250)  NULL,[RemarkDate] [datetime]  NOT NULL,[IsRemark] [int]  NOT NULL,[IsPass] [int]  NOT NULL,[ReviewTo] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_ArticleReview ADD CONSTRAINT DF_Tmp_Web_ArticleReview_ArticleID DEFAULT ((0)) FOR [ArticleID]
 
ALTER TABLE dbo.Tmp_Web_ArticleReview ADD CONSTRAINT DF_Tmp_Web_ArticleReview_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Tmp_Web_ArticleReview ADD CONSTRAINT DF_Tmp_Web_ArticleReview_Star DEFAULT ((0)) FOR [Star]
 
ALTER TABLE dbo.Tmp_Web_ArticleReview ADD CONSTRAINT DF_Tmp_Web_ArticleReview_RemarkDate DEFAULT (getdate()) FOR [RemarkDate]
 
ALTER TABLE dbo.Tmp_Web_ArticleReview ADD CONSTRAINT DF_Tmp_Web_ArticleReview_IsRemark DEFAULT ((0)) FOR [IsRemark]
 
ALTER TABLE dbo.Tmp_Web_ArticleReview ADD CONSTRAINT DF_Tmp_Web_ArticleReview_IsPass DEFAULT ((0)) FOR [IsPass]
 
ALTER TABLE dbo.Tmp_Web_ArticleReview ADD CONSTRAINT DF_Tmp_Web_ArticleReview_ReviewTo DEFAULT ((0)) FOR [ReviewTo]
 
SET IDENTITY_INSERT dbo.Tmp_Web_ArticleReview ON
 
IF EXISTS(SELECT * FROM dbo.Web_ArticleReview) EXEC('INSERT INTO dbo.Tmp_Web_ArticleReview ([ID],[ArticleID],[Date],[UserName],[Star],[Title],[Content],[IP],[Remark],[RemarkDate],[IsRemark],[IsPass],[ReviewTo]) SELECT [ID],[ArticleID],[Date],[UserName],[Star],[Title],[Content],[IP],[Remark],[RemarkDate],[IsRemark],[IsPass],[ReviewTo] FROM dbo.Web_ArticleReview WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_ArticleReview OFF
 
DROP TABLE dbo.Web_ArticleReview
 
EXECUTE sp_rename N'dbo.Tmp_Web_ArticleReview', N'Web_ArticleReview', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Activity]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Activity] 
 
CREATE TABLE dbo.Web_Activity([ID] [int]  NOT NULL,[Name] [nvarchar] (50)  NOT NULL,[Content] [nvarchar] (2000)  NOT NULL,[StartDate] [datetime]  NOT NULL,[EndDate] [datetime]  NOT NULL,[SrcList] [nvarchar] (250)  NOT NULL,[SrcDetail] [nvarchar] (250)  NOT NULL,[IsBindProduct] [int]  NOT NULL,[IsAct] [int]  NOT NULL,[Count] [int]  NOT NULL,[SpecialDate] [nvarchar] (200)  NOT NULL,[UserGroupName] [nvarchar] (200)  NOT NULL,[Score] [int]  NOT NULL,[BonusGift] [int]  NOT NULL,[BonusCard] [int]  NOT NULL,[BonusScore] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[IsFinish] [int]  NOT NULL,[OrderID] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Activity ADD CONSTRAINT DF_Web_Activity_Name DEFAULT ('') FOR [Name]
 
ALTER TABLE dbo.Web_Activity ADD CONSTRAINT DF_Web_Activity_Content DEFAULT ('') FOR [Content]
 
ALTER TABLE dbo.Web_Activity ADD CONSTRAINT DF_Web_Activity_StartDate DEFAULT (getdate()) FOR [StartDate]
 
ALTER TABLE dbo.Web_Activity ADD CONSTRAINT DF_Web_Activity_EndDate DEFAULT (getdate()) FOR [EndDate]
 
ALTER TABLE dbo.Web_Activity ADD CONSTRAINT DF_Web_Activity_SrcList DEFAULT ('') FOR [SrcList]
 
ALTER TABLE dbo.Web_Activity ADD CONSTRAINT DF_Web_Activity_SrcDetail DEFAULT ('') FOR [SrcDetail]
 
ALTER TABLE dbo.Web_Activity ADD CONSTRAINT DF_Web_Activity_IsBindProduct DEFAULT ((0)) FOR [IsBindProduct]
 
ALTER TABLE dbo.Web_Activity ADD CONSTRAINT DF_Web_Activity_IsAct DEFAULT ((0)) FOR [IsAct]
 
ALTER TABLE dbo.Web_Activity ADD CONSTRAINT DF_Web_Activity_Count DEFAULT ((0)) FOR [Count]
 
ALTER TABLE dbo.Web_Activity ADD CONSTRAINT DF_Web_Activity_SpecialDate DEFAULT ('') FOR [SpecialDate]
 
ALTER TABLE dbo.Web_Activity ADD CONSTRAINT DF_Web_Activity_UserGroupName DEFAULT ('') FOR [UserGroupName]
 
ALTER TABLE dbo.Web_Activity ADD CONSTRAINT DF_Web_Activity_Score DEFAULT ((0)) FOR [Score]
 
ALTER TABLE dbo.Web_Activity ADD CONSTRAINT DF_Web_Activity_BonusGift DEFAULT ((0)) FOR [BonusGift]
 
ALTER TABLE dbo.Web_Activity ADD CONSTRAINT DF_Web_Activity_BonusCard DEFAULT ((0)) FOR [BonusCard]
 
ALTER TABLE dbo.Web_Activity ADD CONSTRAINT DF_Web_Activity_BonusScore DEFAULT ((0)) FOR [BonusScore]
 
ALTER TABLE dbo.Web_Activity ADD CONSTRAINT DF_Web_Activity_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Web_Activity ADD CONSTRAINT DF_Web_Activity_IsFinish DEFAULT ((0)) FOR [IsFinish]
 
ALTER TABLE dbo.Web_Activity ADD CONSTRAINT DF_Web_Activity_OrderID DEFAULT ((1000)) FOR [OrderID]
 
CREATE TABLE dbo.Tmp_Web_Activity([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NOT NULL,[Content] [nvarchar] (2000)  NOT NULL,[StartDate] [datetime]  NOT NULL,[EndDate] [datetime]  NOT NULL,[SrcList] [nvarchar] (250)  NOT NULL,[SrcDetail] [nvarchar] (250)  NOT NULL,[IsBindProduct] [int]  NOT NULL,[IsAct] [int]  NOT NULL,[Count] [int]  NOT NULL,[SpecialDate] [nvarchar] (200)  NOT NULL,[UserGroupName] [nvarchar] (200)  NOT NULL,[Score] [int]  NOT NULL,[BonusGift] [int]  NOT NULL,[BonusCard] [int]  NOT NULL,[BonusScore] [int]  NOT NULL,[Date] [datetime]  NOT NULL,[IsFinish] [int]  NOT NULL,[OrderID] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_Activity ADD CONSTRAINT DF_Tmp_Web_Activity_Name DEFAULT ('') FOR [Name]
 
ALTER TABLE dbo.Tmp_Web_Activity ADD CONSTRAINT DF_Tmp_Web_Activity_Content DEFAULT ('') FOR [Content]
 
ALTER TABLE dbo.Tmp_Web_Activity ADD CONSTRAINT DF_Tmp_Web_Activity_StartDate DEFAULT (getdate()) FOR [StartDate]
 
ALTER TABLE dbo.Tmp_Web_Activity ADD CONSTRAINT DF_Tmp_Web_Activity_EndDate DEFAULT (getdate()) FOR [EndDate]
 
ALTER TABLE dbo.Tmp_Web_Activity ADD CONSTRAINT DF_Tmp_Web_Activity_SrcList DEFAULT ('') FOR [SrcList]
 
ALTER TABLE dbo.Tmp_Web_Activity ADD CONSTRAINT DF_Tmp_Web_Activity_SrcDetail DEFAULT ('') FOR [SrcDetail]
 
ALTER TABLE dbo.Tmp_Web_Activity ADD CONSTRAINT DF_Tmp_Web_Activity_IsBindProduct DEFAULT ((0)) FOR [IsBindProduct]
 
ALTER TABLE dbo.Tmp_Web_Activity ADD CONSTRAINT DF_Tmp_Web_Activity_IsAct DEFAULT ((0)) FOR [IsAct]
 
ALTER TABLE dbo.Tmp_Web_Activity ADD CONSTRAINT DF_Tmp_Web_Activity_Count DEFAULT ((0)) FOR [Count]
 
ALTER TABLE dbo.Tmp_Web_Activity ADD CONSTRAINT DF_Tmp_Web_Activity_SpecialDate DEFAULT ('') FOR [SpecialDate]
 
ALTER TABLE dbo.Tmp_Web_Activity ADD CONSTRAINT DF_Tmp_Web_Activity_UserGroupName DEFAULT ('') FOR [UserGroupName]
 
ALTER TABLE dbo.Tmp_Web_Activity ADD CONSTRAINT DF_Tmp_Web_Activity_Score DEFAULT ((0)) FOR [Score]
 
ALTER TABLE dbo.Tmp_Web_Activity ADD CONSTRAINT DF_Tmp_Web_Activity_BonusGift DEFAULT ((0)) FOR [BonusGift]
 
ALTER TABLE dbo.Tmp_Web_Activity ADD CONSTRAINT DF_Tmp_Web_Activity_BonusCard DEFAULT ((0)) FOR [BonusCard]
 
ALTER TABLE dbo.Tmp_Web_Activity ADD CONSTRAINT DF_Tmp_Web_Activity_BonusScore DEFAULT ((0)) FOR [BonusScore]
 
ALTER TABLE dbo.Tmp_Web_Activity ADD CONSTRAINT DF_Tmp_Web_Activity_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Tmp_Web_Activity ADD CONSTRAINT DF_Tmp_Web_Activity_IsFinish DEFAULT ((0)) FOR [IsFinish]
 
ALTER TABLE dbo.Tmp_Web_Activity ADD CONSTRAINT DF_Tmp_Web_Activity_OrderID DEFAULT ((1000)) FOR [OrderID]
 
SET IDENTITY_INSERT dbo.Tmp_Web_Activity ON
 
IF EXISTS(SELECT * FROM dbo.Web_Activity) EXEC('INSERT INTO dbo.Tmp_Web_Activity ([ID],[Name],[Content],[StartDate],[EndDate],[SrcList],[SrcDetail],[IsBindProduct],[IsAct],[Count],[SpecialDate],[UserGroupName],[Score],[BonusGift],[BonusCard],[BonusScore],[Date],[IsFinish],[OrderID]) SELECT [ID],[Name],[Content],[StartDate],[EndDate],[SrcList],[SrcDetail],[IsBindProduct],[IsAct],[Count],[SpecialDate],[UserGroupName],[Score],[BonusGift],[BonusCard],[BonusScore],[Date],[IsFinish],[OrderID] FROM dbo.Web_Activity WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Activity OFF
 
DROP TABLE dbo.Web_Activity
 
EXECUTE sp_rename N'dbo.Tmp_Web_Activity', N'Web_Activity', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_ShopCard]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_ShopCard] 
 
CREATE TABLE dbo.Web_ShopCard([Id] [int]  NOT NULL,[Number] [nvarchar] (100)  NOT NULL,[Password] [nvarchar] (50)  NOT NULL,[Discount] [int]  NOT NULL,[UserName] [nvarchar] (50)  NOT NULL,[Price] [decimal]  (18,2) NOT NULL,[DispenseCount] [int]  NOT NULL,[EndDate] [datetime]  NOT NULL,[DispenseOrder] [int]  NOT NULL,[DistributeStatus] [int]  NOT NULL,[CardPrise] [decimal]  (18,2) NOT NULL,[AdminName] [nvarchar] (20)  NOT NULL,[Date] [datetime]  NOT NULL,[IsLock] [int]  NOT NULL,[IsDel] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_ShopCard ADD CONSTRAINT DF_Web_ShopCard_Number DEFAULT ('') FOR [Number]
 
ALTER TABLE dbo.Web_ShopCard ADD CONSTRAINT DF_Web_ShopCard_Password DEFAULT ('') FOR [Password]
 
ALTER TABLE dbo.Web_ShopCard ADD CONSTRAINT DF_Web_ShopCard_Discount DEFAULT ((0)) FOR [Discount]
 
ALTER TABLE dbo.Web_ShopCard ADD CONSTRAINT DF_Web_ShopCard_UserName DEFAULT ('') FOR [UserName]
 
ALTER TABLE dbo.Web_ShopCard ADD CONSTRAINT DF_Web_ShopCard_Price DEFAULT ((0)) FOR [Price]
 
ALTER TABLE dbo.Web_ShopCard ADD CONSTRAINT DF_Web_ShopCard_DispenseCount DEFAULT ((0)) FOR [DispenseCount]
 
ALTER TABLE dbo.Web_ShopCard ADD CONSTRAINT DF_Web_ShopCard_EndDate DEFAULT (getdate()) FOR [EndDate]
 
ALTER TABLE dbo.Web_ShopCard ADD CONSTRAINT DF_Web_ShopCard_DispenseOrder DEFAULT ((0)) FOR [DispenseOrder]
 
ALTER TABLE dbo.Web_ShopCard ADD CONSTRAINT DF_Web_ShopCard_DistributeStatus DEFAULT ((0)) FOR [DistributeStatus]
 
ALTER TABLE dbo.Web_ShopCard ADD CONSTRAINT DF_Web_ShopCard_CardPrise DEFAULT ((0)) FOR [CardPrise]
 
ALTER TABLE dbo.Web_ShopCard ADD CONSTRAINT DF_Web_ShopCard_AdminName DEFAULT ('') FOR [AdminName]
 
ALTER TABLE dbo.Web_ShopCard ADD CONSTRAINT DF_Web_ShopCard_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Web_ShopCard ADD CONSTRAINT DF_Web_ShopCard_IsLock DEFAULT ((0)) FOR [IsLock]
 
ALTER TABLE dbo.Web_ShopCard ADD CONSTRAINT DF_Web_ShopCard_IsDel DEFAULT ((0)) FOR [IsDel]
 
CREATE TABLE dbo.Tmp_Web_ShopCard([Id] [int]  NOT NULL IDENTITY (1, 1),[Number] [nvarchar] (100)  NOT NULL,[Password] [nvarchar] (50)  NOT NULL,[Discount] [int]  NOT NULL,[UserName] [nvarchar] (50)  NOT NULL,[Price] [decimal]  (18,2) NOT NULL,[DispenseCount] [int]  NOT NULL,[EndDate] [datetime]  NOT NULL,[DispenseOrder] [int]  NOT NULL,[DistributeStatus] [int]  NOT NULL,[CardPrise] [decimal]  (18,2) NOT NULL,[AdminName] [nvarchar] (20)  NOT NULL,[Date] [datetime]  NOT NULL,[IsLock] [int]  NOT NULL,[IsDel] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_ShopCard ADD CONSTRAINT DF_Tmp_Web_ShopCard_Number DEFAULT ('') FOR [Number]
 
ALTER TABLE dbo.Tmp_Web_ShopCard ADD CONSTRAINT DF_Tmp_Web_ShopCard_Password DEFAULT ('') FOR [Password]
 
ALTER TABLE dbo.Tmp_Web_ShopCard ADD CONSTRAINT DF_Tmp_Web_ShopCard_Discount DEFAULT ((0)) FOR [Discount]
 
ALTER TABLE dbo.Tmp_Web_ShopCard ADD CONSTRAINT DF_Tmp_Web_ShopCard_UserName DEFAULT ('') FOR [UserName]
 
ALTER TABLE dbo.Tmp_Web_ShopCard ADD CONSTRAINT DF_Tmp_Web_ShopCard_Price DEFAULT ((0)) FOR [Price]
 
ALTER TABLE dbo.Tmp_Web_ShopCard ADD CONSTRAINT DF_Tmp_Web_ShopCard_DispenseCount DEFAULT ((0)) FOR [DispenseCount]
 
ALTER TABLE dbo.Tmp_Web_ShopCard ADD CONSTRAINT DF_Tmp_Web_ShopCard_EndDate DEFAULT (getdate()) FOR [EndDate]
 
ALTER TABLE dbo.Tmp_Web_ShopCard ADD CONSTRAINT DF_Tmp_Web_ShopCard_DispenseOrder DEFAULT ((0)) FOR [DispenseOrder]
 
ALTER TABLE dbo.Tmp_Web_ShopCard ADD CONSTRAINT DF_Tmp_Web_ShopCard_DistributeStatus DEFAULT ((0)) FOR [DistributeStatus]
 
ALTER TABLE dbo.Tmp_Web_ShopCard ADD CONSTRAINT DF_Tmp_Web_ShopCard_CardPrise DEFAULT ((0)) FOR [CardPrise]
 
ALTER TABLE dbo.Tmp_Web_ShopCard ADD CONSTRAINT DF_Tmp_Web_ShopCard_AdminName DEFAULT ('') FOR [AdminName]
 
ALTER TABLE dbo.Tmp_Web_ShopCard ADD CONSTRAINT DF_Tmp_Web_ShopCard_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Tmp_Web_ShopCard ADD CONSTRAINT DF_Tmp_Web_ShopCard_IsLock DEFAULT ((0)) FOR [IsLock]
 
ALTER TABLE dbo.Tmp_Web_ShopCard ADD CONSTRAINT DF_Tmp_Web_ShopCard_IsDel DEFAULT ((0)) FOR [IsDel]
 
SET IDENTITY_INSERT dbo.Tmp_Web_ShopCard ON
 
IF EXISTS(SELECT * FROM dbo.Web_ShopCard) EXEC('INSERT INTO dbo.Tmp_Web_ShopCard ([Id],[Number],[Password],[Discount],[UserName],[Price],[DispenseCount],[EndDate],[DispenseOrder],[DistributeStatus],[CardPrise],[AdminName],[Date],[IsLock],[IsDel]) SELECT [Id],[Number],[Password],[Discount],[UserName],[Price],[DispenseCount],[EndDate],[DispenseOrder],[DistributeStatus],[CardPrise],[AdminName],[Date],[IsLock],[IsDel] FROM dbo.Web_ShopCard WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_ShopCard OFF
 
DROP TABLE dbo.Web_ShopCard
 
EXECUTE sp_rename N'dbo.Tmp_Web_ShopCard', N'Web_ShopCard', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_GreetingCard]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_GreetingCard] 
 
CREATE TABLE dbo.Web_GreetingCard([ID] [int]  NOT NULL,[Name] [nvarchar] (50)  NOT NULL,[SrcList] [nvarchar] (250)  NOT NULL,[SrcDetail] [nvarchar] (250)  NOT NULL,[Date] [datetime]  NOT NULL,[Price] [decimal]  (18,2) NOT NULL,[FreePrice] [decimal]  (18,2) NOT NULL,[OrderID] [int]  NOT NULL,[Description] [nvarchar] (250)  NOT NULL,[IsDel] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_GreetingCard ADD CONSTRAINT DF_Web_GreetingCard_SrcList DEFAULT ('') FOR [SrcList]
 
ALTER TABLE dbo.Web_GreetingCard ADD CONSTRAINT DF_Web_GreetingCard_SrcDetail DEFAULT ('') FOR [SrcDetail]
 
ALTER TABLE dbo.Web_GreetingCard ADD CONSTRAINT DF_Web_GreetingCard_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Web_GreetingCard ADD CONSTRAINT DF_Web_GreetingCard_Price DEFAULT ((0)) FOR [Price]
 
ALTER TABLE dbo.Web_GreetingCard ADD CONSTRAINT DF_Web_GreetingCard_FreePrice DEFAULT ((0)) FOR [FreePrice]
 
ALTER TABLE dbo.Web_GreetingCard ADD CONSTRAINT DF_Web_GreetingCard_OrderID DEFAULT ((0)) FOR [OrderID]
 
ALTER TABLE dbo.Web_GreetingCard ADD CONSTRAINT DF_Web_GreetingCard_Description DEFAULT ('') FOR [Description]
 
ALTER TABLE dbo.Web_GreetingCard ADD CONSTRAINT DF_Web_GreetingCard_IsDel DEFAULT ((0)) FOR [IsDel]
 
CREATE TABLE dbo.Tmp_Web_GreetingCard([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NOT NULL,[SrcList] [nvarchar] (250)  NOT NULL,[SrcDetail] [nvarchar] (250)  NOT NULL,[Date] [datetime]  NOT NULL,[Price] [decimal]  (18,2) NOT NULL,[FreePrice] [decimal]  (18,2) NOT NULL,[OrderID] [int]  NOT NULL,[Description] [nvarchar] (250)  NOT NULL,[IsDel] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_GreetingCard ADD CONSTRAINT DF_Tmp_Web_GreetingCard_SrcList DEFAULT ('') FOR [SrcList]
 
ALTER TABLE dbo.Tmp_Web_GreetingCard ADD CONSTRAINT DF_Tmp_Web_GreetingCard_SrcDetail DEFAULT ('') FOR [SrcDetail]
 
ALTER TABLE dbo.Tmp_Web_GreetingCard ADD CONSTRAINT DF_Tmp_Web_GreetingCard_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Tmp_Web_GreetingCard ADD CONSTRAINT DF_Tmp_Web_GreetingCard_Price DEFAULT ((0)) FOR [Price]
 
ALTER TABLE dbo.Tmp_Web_GreetingCard ADD CONSTRAINT DF_Tmp_Web_GreetingCard_FreePrice DEFAULT ((0)) FOR [FreePrice]
 
ALTER TABLE dbo.Tmp_Web_GreetingCard ADD CONSTRAINT DF_Tmp_Web_GreetingCard_OrderID DEFAULT ((0)) FOR [OrderID]
 
ALTER TABLE dbo.Tmp_Web_GreetingCard ADD CONSTRAINT DF_Tmp_Web_GreetingCard_Description DEFAULT ('') FOR [Description]
 
ALTER TABLE dbo.Tmp_Web_GreetingCard ADD CONSTRAINT DF_Tmp_Web_GreetingCard_IsDel DEFAULT ((0)) FOR [IsDel]
 
SET IDENTITY_INSERT dbo.Tmp_Web_GreetingCard ON
 
IF EXISTS(SELECT * FROM dbo.Web_GreetingCard) EXEC('INSERT INTO dbo.Tmp_Web_GreetingCard ([ID],[Name],[SrcList],[SrcDetail],[Date],[Price],[FreePrice],[OrderID],[Description],[IsDel]) SELECT [ID],[Name],[SrcList],[SrcDetail],[Date],[Price],[FreePrice],[OrderID],[Description],[IsDel] FROM dbo.Web_GreetingCard WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_GreetingCard OFF
 
DROP TABLE dbo.Web_GreetingCard
 
EXECUTE sp_rename N'dbo.Tmp_Web_GreetingCard', N'Web_GreetingCard', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Template]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Template] 
 
CREATE TABLE dbo.Web_Template([ID] [int]  NOT NULL,[Name] [nvarchar] (50)  NULL,[Path] [nvarchar] (50)  NULL,[Src] [nvarchar] (50)  NULL,[Author] [nvarchar] (50)  NULL,[Version] [nvarchar] (50)  NULL,[IsAct] [int]  NOT NULL,[Number] [nvarchar] (50)  NULL,[Type] [nvarchar] (50)  NULL,[Date] [datetime]  NOT NULL,[Size] [nvarchar] (50)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Template ADD CONSTRAINT DF_Web_Template_IsAct DEFAULT ((0)) FOR [IsAct]
 
ALTER TABLE dbo.Web_Template ADD CONSTRAINT DF_Web_Template_Date DEFAULT (getdate()) FOR [Date]
 
INSERT INTO Web_Template VALUES ('1','默认风格','default','','V5Shop Team','V1.0','1','NO.00001',NULL,'2008-9-1 14:00:58',NULL)
 
CREATE TABLE dbo.Tmp_Web_Template([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NULL,[Path] [nvarchar] (50)  NULL,[Src] [nvarchar] (50)  NULL,[Author] [nvarchar] (50)  NULL,[Version] [nvarchar] (50)  NULL,[IsAct] [int]  NOT NULL,[Number] [nvarchar] (50)  NULL,[Type] [nvarchar] (50)  NULL,[Date] [datetime]  NOT NULL,[Size] [nvarchar] (50)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_Template ADD CONSTRAINT DF_Tmp_Web_Template_IsAct DEFAULT ((0)) FOR [IsAct]
 
ALTER TABLE dbo.Tmp_Web_Template ADD CONSTRAINT DF_Tmp_Web_Template_Date DEFAULT (getdate()) FOR [Date]
 
SET IDENTITY_INSERT dbo.Tmp_Web_Template ON
 
IF EXISTS(SELECT * FROM dbo.Web_Template) EXEC('INSERT INTO dbo.Tmp_Web_Template ([ID],[Name],[Path],[Src],[Author],[Version],[IsAct],[Number],[Type],[Date],[Size]) SELECT [ID],[Name],[Path],[Src],[Author],[Version],[IsAct],[Number],[Type],[Date],[Size] FROM dbo.Web_Template WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Template OFF
 
DROP TABLE dbo.Web_Template
 
EXECUTE sp_rename N'dbo.Tmp_Web_Template', N'Web_Template', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Fitting]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Fitting] 
 
CREATE TABLE dbo.Web_Fitting([ProductID] [int]  NOT NULL,[FittingID] [int]  NOT NULL,[OrderID] [int]  NOT NULL,[IsNeed] [int]  NOT NULL,[FittingTypeID] [int]  NOT NULL,[Price] [decimal]  (18,2) NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Fitting ADD CONSTRAINT DF_Web_Fitting_ProductID DEFAULT ((0)) FOR [ProductID]
 
ALTER TABLE dbo.Web_Fitting ADD CONSTRAINT DF_Web_Fitting_FittingID DEFAULT ((0)) FOR [FittingID]
 
ALTER TABLE dbo.Web_Fitting ADD CONSTRAINT DF_Web_Fitting_OrderID DEFAULT ((1000)) FOR [OrderID]
 
ALTER TABLE dbo.Web_Fitting ADD CONSTRAINT DF_Web_Fitting_IsNeed DEFAULT ((0)) FOR [IsNeed]
 
ALTER TABLE dbo.Web_Fitting ADD CONSTRAINT DF_Web_Fitting_FittingTypeID DEFAULT ((0)) FOR [FittingTypeID]
 
ALTER TABLE dbo.Web_Fitting ADD CONSTRAINT DF_Web_Fitting_Price DEFAULT ((0)) FOR [Price]
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Help]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Help] 
 
CREATE TABLE dbo.Web_Help([ID] [int]  NOT NULL,[Title] [nvarchar] (100)  NULL,[Content] [ntext]  NULL,[OrderID] [int]  NULL,[Hits] [int]  NULL,[CategoryID] [int]  NULL,[Template] [nvarchar] (150)  NULL,[SearchKey] [nvarchar] (100)  NULL,[Description] [nvarchar] (200)  NULL)  ON [PRIMARY] 
 
INSERT INTO Web_Help VALUES ('1','配送方式','目前，威博公司支持以下几种送货方式： <br />
<br />
国内： <br />
送货上门 <br />
普通邮寄 <br />
EMS快递 <br />
<br />
国际： <br />
国际特快专递（EMS） <br />
国际空运路包裹 <br />
国际水陆路包裹 <br />
<br />
点击此处查看各种送货方式的配送范围、费用及时间
<p></p>','1','0','5','','配送方式','配送方式')
 
INSERT INTO Web_Help VALUES ('2','送货范围','<p>1、送货上门 <br />
威博公司已在全国1767个城市(地区)实现送货上门服务。 <br />
送货上门订单的配送范围、费用及时间请点击</p>
<p>2、普通邮寄 <br />
送货范围：全国所有通邮地区 <br />
送货方式：邮局投递 <br />
送达时间：发货后7-15个工作日 <br />
收费标准：购物200元以内收费8元，购物200元以上免费。</p>
<p><br />
我们在收到您的汇款后会立即给您发货。</p>
<p>3、EMS快递 <br />
送货范围：全国所有开通快递业务的地区 <br />
送达时间：发货后3-5个工作日 <br />
收费标准：购物300元以下每单收配送费20元，300(含)元以上免收配送费。 <br />
点击此处，查看详细信息</p>','2','0','5','','送货范围','送货范围')
 
INSERT INTO Web_Help VALUES ('3','关于我们','<div style="padding-right: 10px; padding-left: 10px; padding-bottom: 10px; line-height: 18px; padding-top: 10px" align="left"><strong><font color="#333333"><strong><a href="http://www.021web.com.cn/about.html#"><font color="#333333">上海威博网络技术有限公司</font></a></strong><font color="#ffffff">:</font><br />
<br />
<font color="#696969">　　</font><font color="#858585">是一家致力于网上购物系统开发的科技型企业。创始于1997年，早期从事办公自动化、电子商务软件的研发。1998年，威博网络全面进入电子商务服务市场。在为企业提供电子商务服务的不断摸索中，威博网络逐步探索出一套成熟的发展模式。做为国内网上购物系统开发的先行者，上海威博网络技术有限公司拥有一支专业的技术团队，他们用智慧与勤奋打造出了一系列拥有完全著作知识产权的网上购物系统，包括：中英文、英文版、专卖店版、企业版、普及版Ⅱ、多用户版、单用户等。这一系列购物系统自面世以来深受广大用户的好评，为广大致力于网上营销的企业和个人提供了最佳的电子商务解决方案。<br />
<br />
　　<font color="#000000">威博公司</font>成立至今，在国内外拥有近7万家客户，并且在业内拥有良好的信誉和口碑。这是对威博网络的肯定，同时也是威博网络发展的动力。&ldquo;做最好的购物系统&rdquo;是威博网络的一贯的信念。在这一信念的指引下，威博网络开拓进取，才有了今天的蓬勃发展。现在威博网上购物系统各地代理商遍布国内外。国内代理主要分布在华东、华北、华南、华中地区；国外代理主要分布在澳大利亚、新西兰等地。威博网络坚持&ldquo;服务至上、客户为本&rdquo;的宗旨。为更好的服务广大用户，威博网络在山东、浙江等地建立了办事处，并将进一步全方位、多层次的服务体系。 </font></font></strong></div>','3','0','2','','由上海威博网络技术有限公司和澳大利亚Minerva Corporate有限公司共同开发的合作项目','由上海威博网络技术有限公司和澳大利亚Minerva Corporate有限公司共同开发的合作项目')
 
INSERT INTO Web_Help VALUES ('4','技术力量','<a href="http://www.021web.com.cn/Technology.html#"><font color="#333333"><strong>技术力量</strong></font></a><br />
<br />
<font color="#858585">　　</font><font color="#004e73">上海威博网络技术有限公司</font><font color="#858585">坐落于上海国家级科技楼(上海复旦大学对面),聚拢国内一批具有丰富的管理经验、互联网技术的优秀职业经理人才和年轻而极富实践经验复旦大学的技术人才，将多年的传统商业企业运作经验和21世纪先进的电子商务、网络营销推广技术紧密结合，缔造了中国电子商务全新的运营模式!目前现拥有30名资深编程开发人员，已开发出国内最为完善的电子商务购物系统，企业建站模块、会员管理系统、大型电子商务平台、高级功能模块...我们所开发的产品已用于国内上万家企业之中并深受客户好评。<br />
<br />
　　另外，公司在严密管理的运作中不断总结国内外先进企业的经验，在本领域中不断导入新的设计概念及科学有序的运作方式，力臻给予客户带来超出预期想象的价值。</font>','4','0','1','','技术力量','技术力量')
 
INSERT INTO Web_Help VALUES ('5','威博精神','<div><font color="#006699">我们的<strong> 精神 </strong>是：最优价值，不赚暴利 ！</font>
<p><font color="#006699">我们的<strong> 口号 </strong>是：诚信为本,长期服务 ！</font></p>
<p><font color="#006699">我们的<strong> 目标 </strong>是：做专业,勤奋,诚实,踏实的软件开发商 ！</font></p>
<p><font color="#006699">我们的<strong> 信念</strong> 是：软件创造价值 ！</font></p>
<p><strong><font color="#333333">我们为什么而努力:</font></strong><br />
<br />
<font color="#000000"><strong>1.</strong></font> 为客户提供及时、周到的技术支持和服务，让客户真正做到只会打字就可以轻松建立网上商店。 <br />
<font color="#000000"><strong>2.</strong></font> 客户的需求是我们开发新系统的最终方向。让每套购物系统做到国际化、人性化。 <br />
<strong><font color="#000000">3.</font></strong> 以低姿态、高要求为中国的电子商务事业发展竭力奉献,让电子商务进入到普通人的生活。 <br />
<strong><font color="#000000">4.</font></strong> &ldquo;将先进的电子商务理念融入用户的管理，将实用的电子商务技术应用于用户的实践。&rdquo;使得用户在享受信息科技最新成果的同时获得最大的经济收益。<br />
<br />
<font color="#333333"><strong>客户为什么选择我们:</strong></font><br />
<br />
<strong><font color="#333333">1.</font></strong> 从最初的2.0购物系统到5.0整合BBS然后到7.2的对比、还有生成HTML购物系统,我们的技术一直领先着! <br />
<strong><font color="#000000">2.</font></strong> 网络服务客服质量一直是客户最担心的问题,这也是我们最注重的问题,我们一直做的很好! <br />
<strong><font color="#000000">3.</font></strong> 自02年起威博网络一直在研究搜索引擎优化,目前我们的系统搜索引擎优化在同类系统一直处理第一 。<br />
<font color="#000000"><strong>4.</strong></font> 客户具有很强的版权意识,为了自己网络事业的长期发展,正版才明确选择! <br />
<strong><font color="#000000">5.</font></strong> 网上复杂的程序让客户眼花缭乱,我们所提供系统的简单操作、合理构架会让客户惊呼:就是威博网络了。</p>
</div>','5','0','1','','威博精神','威博精神')
 
INSERT INTO Web_Help VALUES ('6','短信订购','<table cellspacing="0" cellpadding="0">
    <tbody>
        <tr>
            <td width="352">推荐以下情况使用&ldquo;短信订购&rdquo;： <br />
            1、在不方便上网或上网条件差的情况下； <br />
            2、在不方便拨打订购热线的情况下； <br />
            3、节约时间，省时购买，只需把您的姓名、要购买的商品发 <br />
            　 短信至 1XXXXXXX 即可等待客服服务； <br />
            4、详细咨询某款商品时，可直接把商品编号或商品名称以及 <br />
            　 想要咨询的内容发短信至 1XXXXXXXX 。 <br />
            <br />
            注意事项： <br />
            1、短信订购号码 1XXXXXXXXX 只接收客户发来的订购或咨询短信，不接听电话，不打出电话； <br />
            2、客服人员在接到客户短信的24小时内为您提供服务，请耐 <br />
            　 心等待； <br />
            3、任何个人或团体不得随意发送色情、暴力、犯罪等国家法 <br />
            　 律明令禁止的短信内容或垃圾短信至 1XXXXXXXXX，否则依法必究。 <br />
            * 客户发送短信按电信、联通常规短信资费标准执行，不另 <br />
            外加收其他费用，敬请放心。</td>
            <td width="7"></td>
        </tr>
        <tr>
            <td></td>
            <td align="center">网上订购 电话订购 邮寄订购 传真订单 e-mail订单 <br />
            我们期待您的光临！ 祝您购物愉快！</td>
        </tr>
    </tbody>
</table>','6','0','6','','短信订购','短信订购')
 
INSERT INTO Web_Help VALUES ('7','邮件订购','您也可以直接发E-mail至我们的信箱：<font color="#336699">webxs08@hotmail.com</font> ，将您要购买的商品名称（或商品编号）、数量、尺码、颜色、您的联系电话， 以及您选择的送货方式等在信中写明，我们在收到您的邮件后，会立即与您联系。','7','0','6','','邮件订购','邮件订购')
 
INSERT INTO Web_Help VALUES ('8','电话订购','<table cellspacing="0" cellpadding="0" width="98%" border="0">
    <tbody>
        <tr>
            <td align="right" height="20"><font color="#000000">客户咨询服务热线：</font></td>
            <td><font color="#0066cc">&middot;</font>021-<strong>55520018</strong><font color="#0066cc">　&middot;</font> <strong>65104220</strong></td>
        </tr>
        <tr>
            <td align="right" height="20"><font color="#000000">客户加盟咨询热线：</font></td>
            <td><font color="#0066cc">&middot;</font>021-<strong>55520018</strong><font color="#0066cc">　&middot;</font> <strong>65104220</strong></td>
        </tr>
        <tr>
            <td align="right" height="20"><font color="#000000">客户技术支持热线：</font></td>
            <td><font color="#0066cc">&middot;</font>021-<strong>55520018-605</strong><font color="#0066cc">　&middot;</font> <strong>65104220-613</strong><font color="#0066cc">　</font></td>
        </tr>
        <tr>
            <td align="right" height="20"><font color="#000000">设计部热线：</font></td>
            <td><font color="#0066cc">&middot;</font>021-<strong>55520018</strong></td>
        </tr>
        <tr>
            <td align="right" height="20"><font color="#000000">公司传真：</font></td>
            <td><font color="#0066cc">&middot;</font>021-<strong>55520018</strong>-610</td>
        </tr>
        <tr>
            <td align="right" height="20"><font color="#000000">客户咨询购买QQ：</font></td>
            <td><font color="#0066cc">&middot;</font><strong>475980829</strong>　<font color="#0066cc">&middot;</font><strong>584706681</strong>　<font color="#0066cc">&middot;</font><strong>645095282</strong></td>
        </tr>
        <tr>
            <td align="right" height="20"><font color="#000000">代理加盟咨询QQ：</font></td>
            <td><font color="#0066cc">&middot;</font><strong>407339098</strong></td>
        </tr>
        <tr>
            <td align="right" height="20"><font color="#000000">技术支持服务QQ：</font></td>
            <td><font color="#0066cc">&middot;</font><strong>502123813</strong>　<font color="#0066cc">&middot;</font><strong>470182248</strong></td>
        </tr>
        <tr>
            <td align="right" height="20"><font color="#000000">设计支持服务QQ：</font></td>
            <td><font color="#0066cc">&middot;</font><strong>421476773</strong>　<font color="#0066cc">&middot;</font><strong>527456496</strong></td>
        </tr>
        <tr>
            <td align="right" height="20"><font color="#000000">客户咨询购买MSN：</font></td>
            <td><font color="#0066cc">&middot;</font>webxs08@hotmail.com <font color="#0066cc">&middot;</font>web08xsjl@hotmail.com</td>
        </tr>
        <tr>
            <td align="right" height="20"><font color="#000000">代理加盟咨询MSN：</font></td>
            <td><font color="#0066cc">&middot;</font>shweb08@hotmail.com</td>
        </tr>
        <tr>
            <td align="right" height="20"><font color="#000000">邮政编码：</font></td>
            <td><strong>　200433 </strong></td>
        </tr>
        <tr>
            <td align="right" height="20"><font color="#000000">地址：</font></td>
            <td>上海市杨浦区国定路335号1号楼13层(复旦大学对面)</td>
        </tr>
    </tbody>
</table>','8','0','6','','电话订购','电话订购 ')
 
INSERT INTO Web_Help VALUES ('9','网上订购','您可以通过以下方式完成网上购物： 登录我们的网站:http://www.021web.com.cn,在页面最上方或页面左侧的导航中选中某个类别，选择您喜爱的商品，然后放入购物车，根据页面提示，修改商品数量，或者填写你的收货信息，去收银台结账。您也可以利用威博网站页面上的搜索栏，直接搜索您感兴趣的商品，进行购买。 您对网上购物不够熟悉？请查看 网上购物示意图 ，它们可以帮助您充分了解网上购物的流程，使您轻松完成网上购物。','9','0','6','','网上订购','网上订购')
 
INSERT INTO Web_Help VALUES ('10','银行汇款','<table cellspacing="0" cellpadding="0" width="100%" border="0">
    <tbody>
        <tr>
            <td>
            <table cellspacing="0" cellpadding="0" width="100%" border="0">
                <tbody>
                    <tr>
                        <td><font color="#000000">开户行:</font> <b><font color="#006699">交通银行上海五角场支行</font></b><br />
                        <font color="#000000">帐号:</font> 310066 1820180 10036636 <br />
                        <font color="#000000">公司名称:</font> 上海威博网络技术有限公司<br />
                        <span style="font-size: 11px; font-family: Verdana"><font color="#000000">Swift:</font> <b><font color="#006699">COMMCNSHSHI</font></b><br />
                        <font color="#000000">Account number:</font> 310066 1820180 10036636<br />
                        <font color="#000000">Company:</font> Shanghai Weibo Technology Limited Corporation </span></td>
                        <td width="200"><img height="40" alt="" width="170" border="0" src="http://www.021web.com.cn/images/payment/qiye.jpg" /></td>
                    </tr>
                </tbody>
            </table>
            </td>
        </tr>
        <tr>
            <td>&nbsp;</td>
        </tr>
        <tr>
            <td background="images/dots.gif" height="1"><img height="1" alt="" width="1" src="http://www.021web.com.cn/images/NULL.gif" /></td>
        </tr>
        <tr>
            <td>&nbsp;</td>
        </tr>
        <tr>
            <td>
            <table cellspacing="0" cellpadding="0" width="100%" border="0">
                <tbody>
                    <tr>
                        <td><font color="#000000">开户行:</font> <strong><font color="#006699">中国工商银行黄兴路支行</font> </strong><br />
                        <font color="#000000">帐号:</font> 622202 100101 4015306 <br />
                        <font color="#000000">姓名:</font> 吴卫华</td>
                        <td width="200"><img height="40" alt="" width="170" border="0" src="http://www.021web.com.cn/images/payment/gs.jpg" /></td>
                    </tr>
                </tbody>
            </table>
            </td>
        </tr>
        <tr>
            <td>&nbsp;</td>
        </tr>
        <tr>
            <td background="images/dots.gif" height="1"><img height="1" alt="" width="1" src="http://www.021web.com.cn/images/NULL.gif" /></td>
        </tr>
        <tr>
            <td>&nbsp;</td>
        </tr>
        <tr>
            <td>
            <table cellspacing="0" cellpadding="0" width="100%" border="0">
                <tbody>
                    <tr>
                        <td><font color="#000000">开户行:</font> <strong><font color="#006699">中国招商银行上海分行</font></strong> <br />
                        <font color="#000000">卡号:</font> 6225 8812 1142 0699 <br />
                        <font color="#000000">姓名:</font> 吴卫华</td>
                        <td width="200"><img height="40" alt="" width="170" border="0" src="http://www.021web.com.cn/images/payment/zs.jpg" /></td>
                    </tr>
                </tbody>
            </table>
            </td>
        </tr>
        <tr>
            <td>&nbsp;</td>
        </tr>
        <tr>
            <td background="images/dots.gif" height="1"><img height="1" alt="" width="1" src="http://www.021web.com.cn/images/NULL.gif" /></td>
        </tr>
        <tr>
            <td>&nbsp;</td>
        </tr>
        <tr>
            <td>
            <table cellspacing="0" cellpadding="0" width="100%" border="0">
                <tbody>
                    <tr>
                        <td><font color="#000000">开户行:</font> <strong><font color="#006699">中国农业银行上海市五角场复旦支行</font> </strong><br />
                        <font color="#000000">帐号:</font> 622848 0030554300019 <br />
                        <font color="#000000">姓名:</font> 吴卫华</td>
                        <td width="200"><img height="40" alt="" width="170" border="0" src="http://www.021web.com.cn/images/payment/ny.jpg" /></td>
                    </tr>
                </tbody>
            </table>
            </td>
        </tr>
        <tr>
            <td>&nbsp;</td>
        </tr>
        <tr>
            <td background="images/dots.gif" height="1"><img height="1" alt="" width="1" src="http://www.021web.com.cn/images/NULL.gif" /></td>
        </tr>
        <tr>
            <td>&nbsp;</td>
        </tr>
        <tr>
            <td>
            <table cellspacing="0" cellpadding="0" width="100%" border="0">
                <tbody>
                    <tr>
                        <td><font color="#000000">开户行:</font> <strong><font color="#006699">中国银行国定路支行</font></strong> <br />
                        <font color="#000000">帐号:</font> 6013820800074170653 <br />
                        <font color="#000000">姓名:</font> 吴卫华</td>
                        <td width="200"><img height="40" alt="" width="170" border="0" src="http://www.021web.com.cn/images/payment/zg.jpg" /></td>
                    </tr>
                </tbody>
            </table>
            </td>
        </tr>
        <tr>
            <td>&nbsp;</td>
        </tr>
        <tr>
            <td background="images/dots.gif" height="1"><img height="1" alt="" width="1" src="http://www.021web.com.cn/images/NULL.gif" /></td>
        </tr>
        <tr>
            <td>&nbsp;</td>
        </tr>
        <tr>
            <td>
            <table cellspacing="0" cellpadding="0" width="100%" border="0">
                <tbody>
                    <tr>
                        <td><font color="#000000">开户行:</font> <strong><font color="#006699">中国建设银行上海国定路支行</font></strong> <br />
                        <font color="#000000">帐号:</font> 4367 4212 1772 4321 963 <br />
                        <font color="#000000">姓名:</font> 吴卫华</td>
                        <td width="200"><img height="40" alt="" width="170" border="0" src="http://www.021web.com.cn/images/payment/js.jpg" /></td>
                    </tr>
                </tbody>
            </table>
            </td>
        </tr>
        <tr>
            <td>&nbsp;</td>
        </tr>
        <tr>
            <td background="images/dots.gif" height="1"><img height="1" alt="" width="1" src="http://www.021web.com.cn/images/NULL.gif" /></td>
        </tr>
        <tr>
            <td>&nbsp;</td>
        </tr>
        <tr>
            <td>
            <table cellspacing="0" cellpadding="0" width="100%" border="0">
                <tbody>
                    <tr>
                        <td><font color="#000000">公司名称:</font> <strong><font color="#006699">上海威博网络技术有限公司</font></strong> <br />
                        <font color="#000000">公司地址:</font> 上海市杨浦区国定路335号1号楼13层<br />
                        (复旦大学对面)<br />
                        <font color="#000000">公司电话:</font> &middot;021-65104220 &middot;021-55520018 <br />
                        <font color="#000000">邮政编码</font>: 200433</td>
                        <td width="200"><img height="40" alt="" width="170" border="0" src="http://www.021web.com.cn/images/payment/sm.jpg" /></td>
                    </tr>
                </tbody>
            </table>
            </td>
        </tr>
    </tbody>
</table>','10','0','4','','银行汇款','银行汇款')
 
INSERT INTO Web_Help VALUES ('11','邮政汇款','<p>您选择好要购买的商品后，根据您选择的送货方式计算出您需要支付的款项总额，填写汇款单，并在汇款单的备注栏内注明您所订购的商品名称（或商品编号）、数量(如果您购买的是内衣， 请务必注明所购内衣的尺码和颜色)，您的联系电话，以及您需要我们用EMS快递给您还是用普通包裹邮寄。如果您需要发票，也请注明。 请注意，不要在平信中夹带货款，以免丢失。如汇款人与收货人不同，请在订单中注明，或在汇款单上，或来电话说明。以免影响到您的订单收款及发货时间。</p>
<p>我们的地址是：</p>
<p>收款人： 上海威博网络技术有限公司: <br />
邮政信箱：上海市杨浦区国定路335号1号楼13层(复旦大学对面)</p>','11','0','4','','邮政汇款','邮政汇款')
 
INSERT INTO Web_Help VALUES ('12','网上支付','人民币卡支付 <br />
<br />
1、使用全国范围适用的人民币卡支付，到帐时间：24小时 <br />
&middot;中国银行长城信用卡(到帐时间：24小时) <br />
&middot;中国银行长城借记卡(到帐时间：实时) <br />
&middot;中国工商银行牡丹信用卡(到帐时间：实时) <br />
&middot;中国工商银行牡丹灵通卡(到帐时间：实时) <br />
&middot;招商银行一网通(到帐时间：实时) <br />
<br />
2、使用.广银联支付(广州市用户使用)，到帐时间：48小时 <br />
<table>
    <tbody>
        <tr bgcolor="#d8e9f5">
            <td width="109">建行龙卡金卡</td>
            <td width="134">工商银行牡丹灵通卡</td>
            <td width="125">农行星座卡</td>
            <td width="182">招商银行卡农行信用卡</td>
        </tr>
        <tr bgcolor="#d8e9f5">
            <td>农行储蓄提款卡</td>
            <td>中行长城电子借记卡</td>
            <td>中行长城信用卡</td>
            <td>工商银行牡丹信用卡</td>
        </tr>
        <tr bgcolor="#d8e9f5">
            <td>建行万事达龙卡</td>
            <td>建行VISA龙卡</td>
            <td>建行万事达彩照卡</td>
            <td>交通银行太平洋万事顺借记卡</td>
        </tr>
        <tr bgcolor="#d8e9f5">
            <td>深圳发展银行卡</td>
            <td>华夏银行卡</td>
            <td>民生银行卡</td>
            <td>交通银行太平洋维萨信用卡</td>
        </tr>
        <tr bgcolor="#d8e9f5">
            <td>中信实业银行卡</td>
            <td>广发行广发理财通卡</td>
            <td>广发行广发信用卡</td>
            <td>交通银行太平洋万事达信用卡</td>
        </tr>
        <tr bgcolor="#d8e9f5">
            <td>光大银行阳光卡</td>
            <td>广东邮政储蓄卡</td>
            <td>建行VISA彩照卡</td>
            <td>交通银行太平洋互联借记卡</td>
        </tr>
    </tbody>
</table>
<br />
3、使用厦门金卡支付(厦门市用户使用)，到帐时间：48小时 <br />
<table>
    <tbody>
        <tr bgcolor="#d8e9f5">
            <td width="132">工商银行牡丹信用卡</td>
            <td width="119">工商银行牡丹国际卡</td>
            <td width="113">工商银行灵通卡</td>
            <td width="136">工商银行储蓄卡</td>
        </tr>
        <tr bgcolor="#d8e9f5">
            <td>农业银行金穗信用卡</td>
            <td>农业银行金穗借记卡</td>
            <td>中国银行长城信用卡</td>
            <td>中国银行长城借记卡</td>
        </tr>
        <tr bgcolor="#d8e9f5">
            <td>建设银行龙卡信用卡</td>
            <td>建设银行龙卡转帐卡</td>
            <td>建设银行龙卡储蓄卡</td>
            <td>兴业银行顺通卡</td>
        </tr>
        <tr bgcolor="#d8e9f5">
            <td>交通银行太平洋信用卡</td>
            <td>邮政储汇局绿卡</td>
            <td></td>
            <td></td>
        </tr>
    </tbody>
</table>
<br />
4、使用ChinaPay支付(上海市用户使用)，到帐时间：48小时 <br />
<table>
    <tbody>
        <tr bgcolor="#d8e9f5">
            <td width="96">中行长城信用卡</td>
            <td width="130">招商银行一卡通</td>
            <td width="126">建行龙卡借记卡</td>
            <td width="148">建行龙卡信用卡</td>
        </tr>
        <tr bgcolor="#d8e9f5">
            <td>农行白玉兰卡</td>
            <td>华夏银行卡</td>
            <td>深圳发展银行卡</td>
            <td>民生银行卡</td>
        </tr>
        <tr bgcolor="#d8e9f5">
            <td>光大银行阳光卡</td>
            <td>交通银行太平洋借记卡</td>
            <td>交通银行太平洋信用卡</td>
            <td></td>
        </tr>
    </tbody>
</table>
<br />
5、使用其它人民币卡支付，到帐时间：24小时 <br />
&middot;上海浦东发展银行东方卡(到帐时间：1天；使用范围：北京) <br />
&middot;上海浦东发展银行存折(到帐时间：1天；使用范围：北京) <br />
&middot;深圳发展银行万事顺卡(到帐时间：1天；使用范围：深圳) <br />
&middot;建设银行龙卡(使用范围：北京，深圳，青岛，江苏，大连；到帐时间：北京实时，其他地区1天) <br />
<br />
<br />
<br />
注意事项 <br />
<br />
(1) 加密方式可参见银通代理方式（详细请点击网银在线支付页面 <br />
　　 http://www.chinabank.com.cn）。 <br />
(2) 备注中在首信填写的信息（未发出时），可以使用back(后退)进行返回操作；在银行填 <br />
　　 写的信息不能进行此项操作。 <br />
(3) 如果您在操作的时候遇到网络中断或者填写错误并发送时，请重新下订单填写支付信 <br />
　　 息， 否则系统提示：&ldquo;该订单已进行过支付操作，拒绝重复支付!&rdquo;。该设置是为防止 <br />
　　 网上的一些不正规的行为导致银行结算的发生。 <br />
(4) 如果您查询款项已经划拨，但订单却显示实收金额为零，是由于从首信转到奇品网帐上 <br />
　　 还需一定时间， 我们会根据网银在线支付提供的信息每天统一安排收款。如果您的订单信 <br />
　　 息详细无误，我们将在应收款金额全额到帐后24小时内为您将货物发出。','12','0','4','','网上支付','网上支付')
 
INSERT INTO Web_Help VALUES ('13','货到付款','<p>按照顾客提交的订单内容，在承诺配送时限内送达顾客指定交货地点后，双方当时验收商品、当时交纳货款(现金形式)的一种结算支付方式。</p>
<p>威博公司已在全国1653个城市(地区)实现货到付款服务。 货到付款的城市(地区)详情请点击</p>','13','0','4','','货到付款   ','货到付款   ')
 
INSERT INTO Web_Help VALUES ('15','隐私保护','<p>为了保护广大客户的隐私权，顾客的用户资料只在威博公司内部使用，不会泄露给第三方。对客户的所有订购、咨询严格保密。对于顾客所购买的商品，我们采取保密邮寄，您在取货时将看不到任何敏感性标志。并在送货时禁止一切可能暴露客户隐私的包装、标识。</p>
<p>我们用来邮寄货品的包装均采用邮局的统一包装(邮政管理局监制的标准包装箱，就象邮政管理局监制的标准信封一样没有任何特殊标志)，外观与普通包裹无异，落款的货物名称是&ldquo;礼品&rdquo;或&ldquo;日用品&rdquo;或您指定的其它字样。</p>
<p>我们邮寄的包裹享有邮局免验权，所以，邮递员送货时并不知道包裹内的商品内容。您若选择送货上门，也不必担心送货员会知道您购买了什么商品。为您送货的送货员均为与我们签约的速递公司的员工，他们看到的只是包装好的商品，并不会了解包装内的具体商品。</p>
<p>客户的任何资料只在我公司内部使用，绝无可能外泄或被用作其它用途。如果您对&ldquo;隐私保护&rdquo;方面有任何疑问，欢迎致威博公司北京公司。</p>','15','0','3','','隐私保护 ','隐私保护 ')
 
INSERT INTO Web_Help VALUES ('16','发票制度','<p>1、发票格式：威博公司根据每一位顾客的需求开具发票。威博公司提供的发票类型是：北京市商业企业专用发票。此发票可用作单位报销凭证，形式为手写。</p>
<p>2、发票内容：可根据顾客要求填写，一般为办公用品或礼品。</p>
<p>3、发票金额：发票金额为订单中的商品本身金额，不包含订单的配送和邮寄费用以及礼券金额。 运输费用的发票由配送公司负责提供，请您在签收商品时向配送人员索取。如果您的订单选择了礼品包装，礼品包装费用将与商品金额开在一起。</p>
<p>4、补开发票：如果在您提交订单时没有填写发票需求，威博公司可以提供补开本年度订单的发票服务(订单的有效期为一年，过期的订单不再提供补开发票服务。如2007年只能补开2007年订单的发票。)。请提供您的订单号（如果是两张订单或者更多张订单，请您注明是分别开具还是合并开具）、发票抬头（客户名称）、 发票内容以及邮寄地址，威博公司将按您的要求开具发票并为您邮寄。</p>
<p>5、换发票：收到发票后如果发现票据抬头、内容或金额错误，您可将发票寄至以下地址，并附上一张说明记录您的订单号以及开具发票的具体要求， 威博公司在收到您寄回的发票当天，即可为您办理换发票事宜。</p>
<p><br />
６.威博公司所有商品报价中未含税，如需开具发票，需缴纳所购商品价格的4%为税款．</p>','16','0','3','','发票制度','发票制度')
 
INSERT INTO Web_Help VALUES ('17','换货流程 ','<p>1、换货</p>
<p>(1)、在您收到货物的30天内(以当地邮戳为准)，如发现商品有质量问题，或脏、残、破、损等情况，要求换货，请您通过电话、Email 或者传真与威博公司客服联系,告知换货的订单号、商品名称、换货原因等信息。</p>
<p>(2)、如果您是北京地区送货上门的客户：在确认商品需换货后三天内送达。如果您是广州地区或上海地区送货上门的客户：如果所购商品为威博公司广州站或上海站所发，则在确认商品需换货后三天内送达；如果所购商品为威博公司北京站所发，则在确认商品需换货后10-15天内送达。</p>
<p>(3)、如果您是选择普通邮寄的客户，请您将要求换的货物通过平邮方式寄送至威博公司公司（如果该订单开过发票，请同时附上发票），并说明换货原因、注明换货，请在寄回时注意使用简易并且正确的包装，以保证货物在运输途中保持原状，我公司在收到货物并检验后，会按您的要求，为您办理换货事宜。</p>
<p>(4)、海外订单如出现质量问题，请您先与我们联系确认后将要求换的货物通过平邮的方式发送至威博公司公司，经确认后我们将按您的要求为您办理换货事宜。</p>
<p>2、退货</p>
<p>(1)、退货：在您收到货物7天内(以当地邮戳为准)，如果您发现所收到的商品有破损脏残或质量问题，要求退货，我们将按您的要求免费为您办理。</p>
<p>(2)、办理退货前，请您通过电话、E-mail或传真与威博公司客服联系，告知退货的订单号、商品名称、退货原因等信息。</p>
<p>(3)、请您将要退的商品邮寄给威博公司公司，如果所购商品有赠品或开具有发票，请您将赠品和发票一并寄回。</p>
<p>(4)、在威博公司收到您退回的商品，并且在商品未发生人为损坏的情况下，一周内为您办理退货事宜。与您协商后，经您同意，货款留在您在威博公司的虚拟账户中或退回到你的银行卡上(或您要求的退款地址)。如果货款中有通过购物币(或优惠券、购物券)支付的，这部分货款将重新存入您在威博公司的虚拟账户中，以备您下次购物时使用。</p>
<p>请注意，有些小件商品要办理退换货时，请不要夹带在信件中，以免丢失，为用户造成不必要的损失。</p>','17','0','3','','换货流程 ','换货流程 ')
 
INSERT INTO Web_Help VALUES ('18','换货原则','<p>我们保证我们的商品均来源于正规渠道，与您亲临商场选购的商品享受同样的质量保证。</p>
<p>1、如您一旦发现所购商品有质量问题一定要在一周内及时和威博公司客户服务中心取得联系。</p>
<p>2、威博公司保证出货时货物外包装的完好无缺。为了保证您的利益，请您在收到货物时当场验货，如果发现货物在运输途中破损，您有权让配送人员拿回货物重新配送或者要求邮局出示证明，向邮局索赔。</p>
<p>3、如果您在威博公司城购买的商品是成人用品、内衣，鉴于此类商品的特殊性，如果您对收到的商品不满意或发现商品有质量问题，且商品未经使用，请您在商品退换的有效期内与我们取得联系，我们将按您的具体要求为您办理退换货。</p>
<p>4、如果您在威博公司所购的商品是保健品、香水，个人护理类商品，在退换货的有效期内，如果发现商品有质量问题，且未经使用，请及时与我们联系，我们将按您的要求为您办理退换货。</p>
<p>5、如果您要求退/换货，请您在退/换货的有效期内( 具体见退/换货流程 )，与威博公司客服中心联系后，将您要退换的商品寄至威博公司公司。如果您所购的商品中有赠品，请您将赠品一并寄回， 在我们收到您要退换的商品并确认包装完好、商品无缺失的情况下，我们的客户服务人员将为您免费为办理退/换货事宜。。</p>
<p>6、若定单中部分金额采用虚拟账户(购物币或优惠券、购物券)支付，则办理退货时，此部分款额仍旧退回至虚拟帐户中。网上支付、货到付款的订单办理退货时，经协商，货款转入您的虚拟帐户中或退回到您的银行卡上(或您要求的退款地址)。 如果您的付款方式是邮局汇款，退货时请您注明退货金额是否留于您在威博公司的虚拟帐户上。</p>
<p>如发生以下情况，奇品网商城可以拒绝退/换货要求：</p>
<p>1、退/换货物不全或者外观受损。 <br />
2、威博公司客户服务中心没有收到您退回的要退换的商品。 <br />
3、商品并非由威博公司提供。 <br />
4、由于商品使用不当造成的损坏。</p>
<p>威博公司保留对上述全部条款的解释权和修改权。</p>','18','0','3','','换货原则','换货原则')
 
INSERT INTO Web_Help VALUES ('20','新手上路 ','<p>注册成为威博公司的用户，享受个性化服务，优惠多多：</p>
<p>&middot;个性化服务：注册成为威博公司的用户后，每次到威博公司，只要您进行登录 ，在&ldquo;我的账户&rdquo;中便可享受到如下服务：修改您的个人信息、查看您的购物车、查看您的历史订单、查看您的购物币金额、获得最新优惠信息等。</p>
<p>注册新用户有以下几种途径：</p>
<p>&middot;在威博公司页头主导航左侧，点击 注册/登录 <br />
&middot;在威博公司页头主导航，点击 我的账户 <br />
&middot;在购物过程中，选购了商品后，填写基本信息时 <br />
&middot;只要您在威博公司成功购物，即可自动成为我们的注册用户 <br />
&middot;您也可以在本页直接进行注册</p>','20','0','2','','新手上路 ','新手上路 ')
 
INSERT INTO Web_Help VALUES ('21','联系我们','<table cellspacing="0" cellpadding="0" width="98%" border="0">
    <tbody>
        <tr>
            <td align="right" height="20"><font color="#000000">客户咨询服务热线：</font></td>
            <td><font color="#0066cc">&middot;</font>021-<strong>55520018</strong><font color="#0066cc">　&middot;</font> <strong>65104220</strong></td>
        </tr>
        <tr>
            <td align="right" height="20"><font color="#000000">客户加盟咨询热线：</font></td>
            <td><font color="#0066cc">&middot;</font>021-<strong>55520018</strong><font color="#0066cc">　&middot;</font> <strong>65104220</strong></td>
        </tr>
        <tr>
            <td align="right" height="20"><font color="#000000">客户技术支持热线：</font></td>
            <td><font color="#0066cc">&middot;</font>021-<strong>55520018-605</strong><font color="#0066cc">　&middot;</font> <strong>65104220-613</strong><font color="#0066cc">　</font></td>
        </tr>
        <tr>
            <td align="right" height="20"><font color="#000000">设计部热线：</font></td>
            <td><font color="#0066cc">&middot;</font>021-<strong>55520018</strong></td>
        </tr>
        <tr>
            <td align="right" height="20"><font color="#000000">公司传真：</font></td>
            <td><font color="#0066cc">&middot;</font>021-<strong>55520018</strong>-610</td>
        </tr>
        <tr>
            <td align="right" height="20"><font color="#000000">客户咨询购买QQ：</font></td>
            <td><font color="#0066cc">&middot;</font><strong>475980829</strong>　<font color="#0066cc">&middot;</font><strong>584706681</strong>　<font color="#0066cc">&middot;</font><strong>645095282</strong></td>
        </tr>
        <tr>
            <td align="right" height="20"><font color="#000000">代理加盟咨询QQ：</font></td>
            <td><font color="#0066cc">&middot;</font><strong>407339098</strong></td>
        </tr>
        <tr>
            <td align="right" height="20"><font color="#000000">技术支持服务QQ：</font></td>
            <td><font color="#0066cc">&middot;</font><strong>502123813</strong>　<font color="#0066cc">&middot;</font><strong>470182248</strong></td>
        </tr>
        <tr>
            <td align="right" height="20"><font color="#000000">设计支持服务QQ：</font></td>
            <td><font color="#0066cc">&middot;</font><strong>421476773</strong>　<font color="#0066cc">&middot;</font><strong>527456496</strong></td>
        </tr>
        <tr>
            <td align="right" height="20"><font color="#000000">客户咨询购买MSN：</font></td>
            <td><font color="#0066cc">&middot;</font>webxs08@hotmail.com <font color="#0066cc">&middot;</font>web08xsjl@hotmail.com</td>
        </tr>
        <tr>
            <td align="right" height="20"><font color="#000000">代理加盟咨询MSN：</font></td>
            <td><font color="#0066cc">&middot;</font>shweb08@hotmail.com</td>
        </tr>
        <tr>
            <td align="right" height="20"><font color="#000000">邮政编码：</font></td>
            <td><strong>　200433 </strong></td>
        </tr>
        <tr>
            <td align="right" height="20"><font color="#000000">地址：</font></td>
            <td>上海市杨浦区国定路335号1号楼13层(复旦大学对面)</td>
        </tr>
    </tbody>
</table>','21','0','2','','联系我们','联系我们')
 
INSERT INTO Web_Help VALUES ('22','留言建议','尊敬的客户，如果您对我们有什么的建议、意见或需求，请在这里给我们留言，我们会及时回复，谢谢 ！
<p><br />
投诉建议专线：<strong><font color="#009933" size="4">021-55520276</font></strong>　</p>
<p>电子邮件：shweb08@hotmail.com</p>','22','0','2','','留言建议','留言建议')
 
INSERT INTO Web_Help VALUES ('23','配送费用','<table id="f" bordercolor="#d8d8eb" cellspacing="0" cellpadding="5" width="100%" border="1">
    <tbody>
        <tr>
            <td align="center" bgcolor="#ffcc99" colspan="5" height="25"><font color="#000097">送货上门订单的配送范围及时间(全国货到付款地区列表)</font></td>
        </tr>
        <tr>
            <td colspan="5" height="10"></td>
        </tr>
        <tr>
            <td align="center" bgcolor="#f2f2f9" height="25"><font size="2"><b>地 区</b></font></td>
            <td align="center" bgcolor="#f2f2f9" colspan="2"><font size="2"><b>配送范围</b></font></td>
            <td align="center" bgcolor="#f2f2f9"><font size="2"><b>送货时间</b></font></td>
            <td align="center" bgcolor="#f2f2f9"><font size="2"><b>送货费用</b></font></td>
        </tr>
        <tr>
            <td align="center" rowspan="3"><a name="1"><font color="#2a4888">北京市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="50">北京四环以内</td>
            <td align="center">一个工作日内送达</td>
            <td align="center" height="50">购物200元以下每单5元<br />
            200(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2">北京四环以外周边地区：西三旗、酒仙桥、回龙观、天通苑、东高地、石景山、古城等地</td>
            <td align="center">48小时内送达</td>
            <td align="center" height="50">购物300元以下每单15元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2">北京郊县：通县、顺义、大兴、怀柔、密云、门头沟</td>
            <td align="center">72小时内送达</td>
            <td align="center" height="50">购物300元以下每单20元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="3"><a name="2"><font color="#2a4888">上海市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2">上海市区：浦西外环线内(静安区、长宁区、普陀区、徐汇区、虹口区、杨浦区、闸北区、宝山区、黄浦区、<br />
            闵行区)及浦东内环线内所有地区</td>
            <td align="center">1个工作日送达<br />
            (上海发货) <br />
            3-5个工作日送达<br />
            (北京发货)</td>
            <td align="center" height="50">购物100元以下每单6元<br />
            100(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2">上海郊区：浦西外环线外(宝山区、普陀区、徐汇区、闵行区、嘉定区、青浦区、松江区、奉贤区、金山区、<br />
            南汇区)及浦东内环线以外所有地区</td>
            <td align="center">2个工作日送达</td>
            <td align="center" height="50">购物300元以下每单15元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2">崇明、长兴 、横沙三岛</td>
            <td align="center">3-5个工作日送达</td>
            <td align="center" height="50">购物300元以下，每单20元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="3"><font color="#2a4888">天津市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2">天津市区：和平区、河西区、河北区、河东区、南开区、红桥区、塘沽区</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="50">购物300元以下每单10元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2">天津市内其它地区</td>
            <td align="center">3-5个工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="4"><font color="#2a4888">南京市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="70">南京市区：鼓楼区、白下区、秦淮区、下关区、建邺区（双闸镇除外）、 雨花区（梅山，板桥镇除外）、玄武<br />
            区 (马群除外)、栖霞区（南京炼油厂、栖霞镇除外）、江宁区（只送东山镇）、浦口大学城、高新开发区、浦<br />
            口(大厂、六合、珠江镇除外)</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="70">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2">南京市内其它地区</td>
            <td align="center">3-5个工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="5"><font color="#2a4888">苏州市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="90">苏州市内：<br />
            东面：从上星港街延独墅湖路到东兴路止。<br />
            南面：从东兴路往南环路接迎春路、宝带路、盘蠡路,接苏福公路到西环止。<br />
            西面：从上开始滨河路接何山路至珠江路往南至竹园路止。<br />
            北面：从滨河路马运路到虎丘路往虎阜蒲庵路上接312国道至梅花新村向下接<br />
            新苏路、苏虹西路到东面星港街。</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="90">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2">苏州市内其它地区</td>
            <td align="center">3-5个工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="6"><font color="#2a4888">无锡市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="80">无锡市内：<br />
            市区范围：崇安区、南长区、北塘区（通惠路以南、蓉湖路以东） <br />
            市郊范围：滨湖区（梁溪路以南、太湖大道以北、青祁路以东）、锡山区（东亭路以西、<br />
            锡沪路以南、太湖大道以北）、惠山区（青山东路以东、锡惠路以西、锡惠公园以南)</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="80">购物300元以下每单12元，300(含)元以上免配送达</td>
        </tr>
        <tr>
            <td colspan="2">无锡市内其它地区</td>
            <td align="center">3-5个工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="7"><font color="#2a4888">常州市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="80">常州市内：湖塘区、钟楼区、天宁区全部区域； <br />
            戚墅堰区：剑湖、丁埝、潞城镇区派送； <br />
            武进区：湖塘、奔牛、横山桥、遥观、马杭、邹区、横林、鸣凰、青龙镇区可 派送；<br />
            新北区：三井、薛家、龙虎塘、小新桥镇区可派送</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="80">购物300元以下每单12元，<br />
            300(含)元以上免配送达</td>
        </tr>
        <tr>
            <td colspan="2">常州市内其它地区</td>
            <td align="center">3-5个工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="8"><font color="#2a4888">镇江市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2">镇江市区：京口区,润州区</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="50">购物300元以下每单12元，300(含)元以上免配送达</td>
        </tr>
        <tr>
            <td colspan="2">镇江市内其它地区</td>
            <td align="center">3-5个工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="9"><font color="#2a4888">宁波市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="90">宁波市内：<br />
            东面：由北延环城东路到环城南路止。<br />
            南面：从东延环城南路到环城西路止以内。<br />
            西面：接南面从环城西路转丽园路到新星路止。<br />
            北面：接西面从新星路延环城北路到环城东路止。</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="90">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2">宁波市内其它地区</td>
            <td align="center">3-5个工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="3"><a name="50"><font color="#2a4888">杭州市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="90">杭州市内：<br />
            上城区、下城区；<br />
            西湖区：南山路太子湾以东、蒋村商住区紫荆花以东、余杭塘以南；<br />
            拱墅区：莫干山路到石祥路十字路口止、石祥路以南 (不包括石大路停车场)东新路以西； <br />
            江干区：(天城路、新风路、新塘路、秋涛北路）以西 ；<br />
            滨江区：只限于滨江路以北 (滨江四区)</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="90">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="110">杭州郊区：<br />
            西湖区：龙井、灵隐、空疗、古荡至留下、三墩区域 ；<br />
            拱墅区：莫干山路到石祥路十字路口以北、石祥路以北(包括石大路停车场) 、东新路以东、半山镇；<br />
            江干区：（天城路、新风路、新塘路、秋涛北路）以东、机场路、艮山东路、航海路萧山区、半山镇(除镇上<br />
            以外地方)；<br />
            滨江区：滨江路以南（除滨江四区块区）、下沙镇、余杭区</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="110">购物300元以下每单15元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2">杭州市内其它地区</td>
            <td align="center">3-5个工作日送达</td>
            <td align="center" height="25">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="55"><font color="#2a4888">扬州市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="90">扬州市内：<br />
            广陵区、开发区、维扬区、 邗江区、文汇工业园、邗江工业园、江阳工业园、广陵产业园</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="90">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2">扬州市内其它地区</td>
            <td align="center">3-5个工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="56"><font color="#2a4888">南通市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="90">南通市内：<br />
            崇川区，港闸区，经济开发区。（南通所属县级市不送） 邮编：226001--226017</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="90">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2">南通市内其它地区</td>
            <td align="center">3-5个工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="10"><font color="#2a4888">武汉市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="120">市区范围：江汉区、江岸区、硚口区、洪山区、青山区、汉阳区（南至汉阳大道、西至二桥路）、武昌区<br />
            （东南至关山一路，南至楚雄大道、北至青山冶金大道）、汉口区（东北至堤角，北至发展大道，西至古田<br />
            一路）。<br />
            郊区范围：武昌： 白沙洲 、湖北工业大学 、华科大武昌分校 、关山一路特1号 、黄家大湾、关南工业园 <br />
            汉口、汉阳：沌口开发区、东西湖区的吴家山、舵落口、将军路、金桥大道、百步亭、丹水池、汉黄路、<br />
            堤角、工农路、长丰乡</td>
            <td align="center">3-4个工作日送达</td>
            <td align="center" height="120">购物300元以下每单收配送费18元,300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2">武汉地区内其它地区</td>
            <td align="center">3-5个工作日送达</td>
            <td align="center" height="25">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="52"><font color="#2a4888">广<br />
            东<br />
            省<br />
            泛<br />
            珠<br />
            江<br />
            三<br />
            角<br />
            洲<br />
            地<br />
            区</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2">东莞地区：石龙镇、虎门镇、中堂镇、望牛墩、麻涌镇、石碣镇、 高埠镇、洪梅镇、道滘镇、厚街镇、沙田<br />
            镇、长安镇、寮步镇、大岭山、大朗镇、黄江镇、樟木头、凤岗镇、塘夏镇、谢岗镇、清溪镇、常平镇、桥头<br />
            镇、横沥镇 、东坑镇、企石镇、石排镇、茶山镇、莞城、东城、万江、南城 <br />
            珠海地区：香洲区、吉大区拱北区、新香洲区、前山区、湾仔区、斗门县 <br />
            中山地区：南头镇、黄圃镇、东凤镇、小榄镇、阜沙镇、东升镇、横栏镇、港口镇、民众镇、坦洲镇、板芙镇、<br />
            南朗镇、古镇镇、沙溪镇、大涌镇、三乡镇、火炬开发区、五桂山镇、神湾镇、石岐地区、南区、西区<br />
            </td>
            <td align="center">24小时-48小时送达</td>
            <td align="center" height="13">购物300元以下每单8元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2">中山地区三角镇</td>
            <td align="center">24小时-48小时送达</td>
            <td align="center" height="12">购物300元以下每单10元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" height="50" rowspan="4"><a name="11"><font color="#2a4888">广州市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="50">市区：广州市环城高速公路以内可送(即白云区、黄埔区、天河区、海珠 区、荔湾区、越秀区)；<br />
            　　　广州市环城高速公路以外部分可送：新市镇（限黄石路以南）、同和镇（限白云山制药厂以南）、大沙<br />
            　　　镇、开发西区</td>
            <td align="center" rowspan="2">1个工作日送达<br />
            （由广州发货）<br />
            3-5个工作日送达<br />
            （由北京发货)</td>
            <td align="center" rowspan="2">购物100元以下每单6元<br />
            100(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="15">番禺区：可投递区域：大学城、洛溪新城、南浦、市桥镇 、市桥市区、市桥镇周边、迎宾路周边、番广公路、<br />
            　　　钟村、大石镇<br />
            　　　邮编范围：511431，511400，511485、511450、511430、511442</td>
        </tr>
        <tr>
            <td colspan="2" height="7">花都区：新华镇、花东镇、狮岭镇、炭步镇、花山镇、赤坭镇、雅瑶镇、梯面镇</td>
            <td align="center" rowspan="2">1个工作日送达<br />
            （由广州发货）<br />
            3-5个工作日送达<br />
            （由北京发货)</td>
            <td align="center" rowspan="2">购物300元以下每单7元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="8">增城：派潭镇、正果镇、小楼镇、中新镇、新塘镇、石滩镇、朱村街道、荔城街道、增江街道</td>
        </tr>
        <tr>
            <td align="center" height="50"><a name="12"><font color="#2a4888">深圳市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2">罗湖：可投递邮编518001-518025<br />
            　　　可投递区域：全区（梧桐山、大旺山上除外）<br />
            福田：可投递邮编518026-518050<br />
            　　　可投递区域：全区<br />
            南山：可投递邮编：518051-518071<br />
            　　　可投递区域：全区（白芒工业区、南岗工业区、阳光工业区、流城工业区除外）<br />
            龙岗：可投递邮编：518112、518113、518115、518116、518172<br />
            　　　可投递区域：龙岗镇、横岗镇、布吉镇(秀峰工业区、上李朗、下李郎、甘坑村除外)<br />
            　　　不可投递区域：坪山镇、杭梓镇、葵涌镇、大鹏镇、南澳镇、平湖镇 <br />
            宝安：可投递邮编：518109、518101、518102、518128、518131、518133<br />
            　　　可投递区域：新安、西乡、机场, 龙华镇（青湖村、大浪村除外）、坂田<br />
            　　　不可投递区域：沙井、光明、公明、福永、松岗、石岩、观澜<br />
            盐田：可投递邮编：518081、518082、518090<br />
            　　　可投递区域：沙头角镇<br />
            　　　不可投递区域：大小梅沙、中英街内、盐田三、四村、三洲田</td>
            <td align="center" rowspan="2">1-2个工作日送达<br />
            （由广州发货）<br />
            3-5个工作日送达<br />
            （由北京发货)</td>
            <td align="center" rowspan="2">购物100元以下每单6元<br />
            100(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" height="50"><a name="13"><font color="#2a4888">佛山市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2">可投递区域：禅城、南海市区、石湾、平洲镇、南海桂城、盐步、黄岐、张槎镇<br />
            邮编范围：528000、528031、528200、528247、、528248、528051</td>
        </tr>
        <tr>
            <td align="center" height="25"><a name="14"><font color="#2a4888">福州市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2">全区派送（县级，乡村除外）</td>
            <td align="center" rowspan="2">2-3个工作日送达</td>
            <td align="center" rowspan="2">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" height="25"><a name="53"><font color="#2a4888">厦门市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2">全区派送（县级，乡村除外）</td>
        </tr>
        <tr>
            <td align="center" rowspan="3"><a name="43"><font color="#2a4888">青岛市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="35">市南区、市北区、四方区：全境派送</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="35">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="50">崂山区、李沧区、城阳区、黄岛区：仅送市区部分</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="50">购物300元以下每单15元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="50">青岛市内其它地区</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="3"><a name="44"><font color="#2a4888">大连市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="50">市区:中山区,西岗区,沙河口区,甘井子区</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="50">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="50">郊区:高新开发区</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="50">购物300元以下每单15元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="50">大连市内其它地区</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="3"><a name="47"><font color="#2a4888">沈阳市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="50">市区:和平区、沈和区、黄沽区、铁西区、大东区</td>
            <td align="center">2-4个工作日送达</td>
            <td align="center" height="50">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="50">郊区:俞洪区、东陵区</td>
            <td align="center">2-4个工作日送达</td>
            <td align="center" height="50">购物300元以下每单15元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="50">沈阳市内其它地区</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="51"><font color="#2a4888">哈尔滨市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="50">市区:道外、南岗、道里、香坊、动力、平房、松北、呼兰</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="50">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="50">哈尔滨市内其它地区</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="48"><font color="#2a4888">济南市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="50">市区:济南市二环路以内（含二环路）</td>
            <td align="center">2-4个工作日送达</td>
            <td align="center" height="50">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="50">济南市内其它地区</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="45"><font color="#2a4888">郑州市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="50">配送区域：东至 107 国道，南至南三环，西至西环，北至北环， 以内的全部区域(金水区、 二七区、管城区、<br />
            中原区、邙山区)</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="50">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="50">郑州市内其它地区</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="46"><font color="#2a4888">西安市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="50">配送区域：东到纺织城,西到阿房路,北到张家堡,南到华美(067基地)</td>
            <td align="center">3-4个工作日送达</td>
            <td align="center" height="50">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="50">西安市内其它地区</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="3"><a name="49"><font color="#2a4888">太原市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="50">市区：迎泽区、杏花岭区、小店区</td>
            <td align="center">2-4个工作日送达</td>
            <td align="center" height="50">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="50">郊区：尖草坪区、万柏林区、晋源区、中北大学、西山矿务局、小店镇</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center" height="50">购物300元以下每单15元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="50">太原市其它地区</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="15"><font color="#2a4888">重庆市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="70">巴南区、巴县、北碚区、璧山、长寿、大渡口、大足、垫江、合川 、江北区、江津、九龙坡区、梁平、南岸<br />
            区、綦江、荣昌、沙坪坝区、双桥区、铜梁、潼南、万盛区、永川、渝北区、渝中区</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center" height="70">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="4"><a name="54"><font color="#2a4888">石家庄市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="50">市区：新华区、桥西区、裕华东区、桥东区</td>
            <td align="center">2-4个工作日送达</td>
            <td align="center" height="50">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="50">郊区：高新开发区</td>
            <td align="center" rowspan="2">2-4个工作日送达</td>
            <td align="center" rowspan="2">购物300元以下每单15元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="50">经济开发区（县级）：正定、鹿泉、经济开发区</td>
        </tr>
        <tr>
            <td colspan="2" height="50">石家庄市内其它地区</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="16"><font color="#2a4888">河北省</font></a></td>
            <td colspan="2" height="280">安国市、安平县、安新县、霸州市、柏乡县、保定、泊头市、博野县、沧州市、昌黎县、成安县、承德市、承德<br />
            县、崇礼县、磁县、大厂、大城县、大名县、定兴县、定州市、东光县、肥乡县、丰南市、丰宁县、丰润县、<br />
            峰峰、抚宁县、阜城县、阜平县、高碑店市、高阳县、藁城、固安、故城、馆陶县、广平县、广宗县、海兴县、<br />
            邯郸、河间市、衡水、怀安县、怀来县、黄骅市、鸡泽县、冀州市、晋州市、井陉矿区、井陉县、景县、巨鹿<br />
            县、宽城县、涞水县、涞源县、廊坊、乐亭县、蠡县、临城县、临西县、临漳县、隆化县、隆尧县、卢龙县、鹿<br />
            泉市、栾城、滦南县、滦平县、滦县、满城县、孟村县、内邱县、南宫市、南和县、南皮县、宁晋县、平泉县、<br />
            平乡县、迁安县、迁西县、秦皇岛、青龙县、青县、清河县、清苑县、邱县、曲阳县、曲周县、饶阳县、任丘<br />
            市、任县、容城县、三河、沙河市、涉县、深州市、顺平县、肃宁县、唐海县、唐山、唐县、万全县、望都县、<br />
            威县、围场县、蔚县、魏县、文安、无极县、吴桥县、武安市、武强县、武邑县、下花园、献县、香河、辛集<br />
            市、新河县、新乐、兴隆县、行唐、邢台、雄县、徐水县、宣化、盐山县、阳原县、易县、永年县、永清、玉田<br />
            县、元氏、枣强县、张北县、张家口、赵县、正定县、涿鹿县、涿州市、遵化市</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="17"><font color="#2a4888">山西省</font></a></td>
            <td colspan="2" height="140">安泽、长治市、长治县、长子、大宁、大同市、大同县、代县、定襄、繁峙、汾西、汾阳、浮山、高平市、古交<br />
            市、 古县、广灵、河津市、洪洞、侯马、壶关、怀仁、浑源、霍州市、吉县、稷山、绛县、交城、介休、晋城、<br />
            晋中市、 静乐、离石、黎城、临汾、 临猗、灵丘、灵石、陵川、柳林、娄烦、潞城市、孟县、宁武、平定、平<br />
            鲁区、平陆、平顺、平遥、蒲县、祁县、沁水、沁县、沁源、清徐、曲沃、芮城、山阴、寿阳、朔州、太谷、<br />
            太原市、天镇、屯留、万荣、文水、闻喜、五台、五寨、武乡、昔阳、隰县、夏县、乡宁、襄汾、襄垣、孝义<br />
            市、忻州、新绛、阳城、阳高、阳曲、阳泉、翼城、应县、永和、永济市、垣曲、原平市、运城、左云</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="18"><font color="#2a4888">内蒙古自治区</font></a></td>
            <td colspan="2" height="60">阿尔山、阿左旗、包头、赤峰、额尔古纳、鄂尔多斯（东胜）、二连浩特、丰镇市、根河、海拉尔、呼和浩特<br />
            市、霍林郭勒、集宁、临河、满州里、通辽、乌海、乌兰浩特、锡林浩特、牙克石、扎兰屯市</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="19"><font color="#2a4888">辽宁省</font></a></td>
            <td colspan="2" height="100">鞍山市、北宁、北票、本溪市、本溪县、昌图、朝阳市、朝阳县、大石桥、大洼、丹东市、灯塔、东港、法库、<br />
            凤城、抚顺市、抚顺县、阜新市、阜新县、盖州、海城、黑山、葫芦岛 （锦西）市、桓仁、建昌、建平、锦州<br />
            市、喀左、开原、康平、宽甸、辽阳市、辽阳县、辽中、凌海、凌源、盘锦市、盘山、普兰店、清原、沈阳市、<br />
            绥中、台安、铁法、铁岭市、铁 岭县、瓦房店、西丰、新宾、新民、兴城、岫岩、义县、营口市、彰武、庄河</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="20"><font color="#2a4888">吉林省</font></a></td>
            <td colspan="2" height="80">安图、白城市、白山市、长白、长春市、长岭、大安、德惠、东丰、敦化、抚松、公主岭、和龙、桦甸、珲春、<br />
            辉南、吉林市、集安、蛟河、靖宇、九台、梨树、辽源市、临江、柳河、龙井、梅河口、农安、磐石、乾安、<br />
            舒兰、双辽、双阳、四平市、松原市、洮南、通化市、通化县、通榆、图们、汪清、延吉市、伊通、永吉、榆<br />
            树、镇赉</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="21"><font color="#2a4888">黑龙江省</font></a></td>
            <td colspan="2" height="80">阿城、宝清、宾县、大庆市、东宁、方正、富锦、哈尔滨市、海林、海伦、鹤岗市、黑河市、呼兰、虎林、鸡<br />
            东、鸡西市、加格达奇、佳木斯市、建三江、克山、龙江、萝北、密山、牡丹江市、讷河、七台河市、齐齐哈<br />
            尔、尚志、双鸭山市、绥芬河、绥棱、五常、五大连池市、伊春市、依兰、肇东</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="22"><font color="#2a4888">江苏省</font></a></td>
            <td colspan="2" height="90">宝应、滨海、常熟、大丰、丹阳、东海、东台、丰县、阜宁、赣榆、高淳、高邮、灌南、灌云、海安、海门、<br />
            洪泽、淮安、淮阴市、淮阴县、建湖、江都、江宁、江浦、江阴、姜堰、金湖、金坛、靖江、句容、昆山、<br />
            溧水、 溧阳、连云港、涟水、六合、南通、沛县、邳州、启东、如东、如皋、射阳、沭阳、泗洪、泗阳、<br />
            宿迁、睢宁、太仓、泰兴、泰州、通州、吴江、响水、新沂、兴化、盱眙、胥浦、徐州、盐城、扬中、扬州、<br />
            仪征、宜兴、张家港</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="23"><font color="#2a4888">浙江省</font></a></td>
            <td colspan="2" height="100">北仑、苍南、长兴、常山、淳安、慈溪、德清、东阳、奉化、富阳、海宁、海盐、杭州、湖州、嘉善、嘉兴、<br />
            建德、江山、金华、缙云、景宁、开化、兰溪、乐清、丽水、临安、 临海、龙泉、龙游、宁波、宁海、磐安、<br />
            平湖、平阳、浦江、普陀、青田、庆元、衢州、瑞安、三门、上虞、绍兴、嵊州、松阳、遂昌、台州、天台、<br />
            桐庐、桐乡、温岭、 温州、武义、仙居、象山、萧山、新昌、义乌、永嘉、永康、余杭、余姚、玉环、云和、<br />
            镇海、舟山、诸暨</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="24"><font color="#2a4888">安徽省</font></a></td>
            <td colspan="2" height="110">安庆市、蚌埠市、亳州、长丰、巢湖、池州、滁州市、枞阳、当涂、砀山、定远、东至、繁昌、肥东、肥西、<br />
            凤台、凤阳、阜南、阜阳市、固镇、广德、含山、合肥市、和县、怀宁、怀远、淮北市、淮南市、黄山区、黄<br />
            山市、霍邱、霍山、绩溪、嘉山、界首、金寨、泾县、旌德、来安、郎溪、利辛、临泉、灵壁、六安、庐江、<br />
            马鞍山市、蒙城、南陵、宁国、祁门、潜山、青阳、全椒、石台、寿县、舒城、泗县、宿松、宿州、濉溪、太<br />
            和、太湖、天长、桐城、铜陵市、铜陵县、望江、涡阳、无为、芜湖市、芜湖县、五河、歙县、肖县、休宁、<br />
            宣州、黟县、颖上、岳西</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="25"><font color="#2a4888">福建省</font></a></td>
            <td colspan="2" height="100">安溪、长乐、长泰、长汀、大田、德化、东山、福安、福鼎、福清、古田、光泽、华安、惠安、建宁、建瓯、<br />
            建阳、将乐、晋江、连城、连江、龙海、龙岩、罗源、闽侯、闽清、明溪、南安、南靖、南平、宁德、宁化、<br />
            平和、平潭、屏南、莆田、浦城、清流、泉 州、三明、沙县、上杭、邵武、石狮、寿宁、顺昌、松溪、泰宁、<br />
            同安、武平、武夷山、霞浦、仙游、永安、永春、永定、永泰、尤溪、云霄、漳平、漳浦、漳州、诏安、柘<br />
            荣、政和、周宁</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="26"><font color="#2a4888">江西省</font></a></td>
            <td colspan="2" height="130">安福、安义、安远、波阳、崇仁、崇义、大余、德安、德兴、定南、东乡、都昌、分宜、丰城、奉新、浮梁、<br />
            抚州、赣县、赣州、高安、广昌、广丰、贵溪、横峰、湖口、会昌、吉安、吉安县、吉水、金溪、进贤、井岗<br />
            山、景德镇市、靖安、九江市、九江县、乐安、乐平、黎川、莲花、临川、龙南、庐山、南昌市、南昌县、南<br />
            城、南丰、南康、宁都、宁冈、彭泽、萍乡市、铅山、全南、瑞昌、瑞金、上高、上饶、上饶县、上犹、石城、<br />
            遂川、泰和、铜鼓、万安、万年、万载、武宁、婺源、峡江、新干、新建、新余市、信丰、兴国、星子、修水、<br />
            寻乌、宜春、宜丰、宜黄、弋阳、鹰潭市、永丰、永新、永修、于都、余干、余江、玉山、樟树、资溪</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="27"><font color="#2a4888">山东省</font></a></td>
            <td colspan="2">安丘、滨州、博兴、苍山、曹县、昌乐、昌邑、长清、成武、茌平、单县、德州、定陶、东阿、东明、东平、东<br />
            营、肥城、费县、高密、高青、高唐、冠县、广饶、海阳、菏泽、桓台、惠民、即墨、济南、济宁、济阳、嘉<br />
            祥、胶南、胶州、金乡、莒南、莒县、巨野、鄄城、垦利、莱芜、莱西、莱阳、莱州、乐陵、利津、梁山、聊<br />
            城、临清、临朐、临沭、临沂、临邑、陵县、蒙阴、牟平、宁津、宁阳、蓬莱、平度、平邑、平阴、平原、栖<br />
            霞、齐 河、青州、庆云、曲阜、日照、荣城、乳山、商河、寿光、泗水、泰安、郯城、滕州、威 海、微山、<br />
            潍坊、文登、汶上、无棣、五莲、武城、夏津、莘县、新泰、烟台、兖州、阳谷、阳信、沂南、沂水、沂源、<br />
            鱼台、禹城、郓城、枣庄、沾化、章丘、招远、诸城、淄博、邹城、邹平</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="28"><font color="#2a4888">河南省</font></a></td>
            <td colspan="2">安阳市、安阳县、宝丰、博爱、长葛、长垣、郸城、登封市、邓州、范县、方城、封丘、扶 沟、巩义、固始、<br />
            光山、鹤壁市、滑县、淮滨、淮阳、潢川、辉县、获嘉、济源、郏县、焦 作市、浚县、开封市、开封县、兰<br />
            考、林州、临颖、灵宝、卢氏、鲁山、鹿邑、栾川、罗 山、洛宁、洛阳市、漯河市、孟津、孟县、泌阳、民<br />
            权、内黄、内乡、南乐、南阳市、南阳 县、南召、宁陵、平顶山市、平舆、濮阳市、濮阳县、淇县、杞县、沁<br />
            阳、清丰、确山、汝 南、汝阳、汝州、三门峡市、陕县、商城、商丘市、商丘县、商水、上蔡、上街区、社<br />
            旗、 沈丘、渑池、嵩县、睢县、遂平、台前、太康、汤阴、唐河、通许、桐柏、卫辉、尉氏、县、武陟、舞<br />
            钢、舞阳、西华、西平、西峡、息县、淅川、夏邑、襄城、项城、新安、新 蔡、新密、新县、新乡市、新乡<br />
            县、新野、新郑、信阳市、信阳县、修武、许昌市、许昌 县、荥阳、鄢陵、延津、偃师、郾城、叶县、伊川、<br />
            宜阳、义马、永城、虞城、禹州、原阳、柘城、镇平、正阳、中牟、周口市、驻马店市</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="29"><font color="#2a4888">湖北省</font></a></td>
            <td colspan="2">安陆、蔡甸区、长阳、赤壁（蒲圻）、崇阳、大悟、大冶、丹江口、当阳、鄂州市、恩施、房县、公安、谷<br />
            城、广水、汉川、红安、洪湖、黄陂、黄冈市、黄梅、黄石市、嘉鱼、监利、建始、江夏区、京山、荆门市、<br />
            荆州市、老河口、罗田、麻城、南漳、蕲春、潜江、十堰市、石首、松滋、随州、天门、通城、通山、团风、<br />
            武穴、浠水、仙桃、咸宁、咸宁地 区、襄樊市、襄阳、孝昌、孝感市、新洲、宣恩、阳新、宜昌市、宜昌县、<br />
            宜城、宜 都（枝城）、应城、英山、远安、云梦、陨县、枣阳、枝江、钟祥</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="30"><font color="#2a4888">湖南省</font></a></td>
            <td colspan="2">长沙市、常德市、郴州市、衡阳市、怀化市、邵阳市、湘潭市、益阳市、永州市、岳阳市、<br />
            株洲市</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="3"><a name="31"><font color="#2a4888">广东省</font></a></td>
            <td align="center" width="95">广<br />
            东<br />
            省<br />
            泛<br />
            珠<br />
            江<br />
            三<br />
            角<br />
            洲<br />
            其<br />
            它<br />
            地<br />
            区<br />
            </td>
            <td width="663">惠州地区：惠城区、大亚湾区、惠阳区、博罗县、惠东县、龙门县<br />
            江门地区：蓬江区、江海区、新会区、台山市、开平市、恩平市、鹤山市<br />
            肇庆地区：端州区、鼎湖区、高要市、四会市<br />
            湛江地区：赤坎区、霞山区、坡头区、廉江市<br />
            茂名地区：茂南区、茂港区 <br />
            潮汕地区<br />
            汕头地区：金平区、龙湖区、濠江区、潮阳区、潮南区、澄海区、南澳县<br />
            潮州地区：湘桥区、枫溪区、潮安县</td>
            <td align="center">2-3个工作日送达<br />
            （由广州发货）<br />
            3-5个工作日送达 <br />
            （由北京发货)</td>
            <td align="center">购物300元以下每单10元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td width="95">偏远地区</td>
            <td width="663">揭阳（榕城区、揭东、惠来、揭西、普宁市)饶平县、广宁县、德庆县、封开县、怀集县、雷州市、徐闻县、信宜市、高州市、电白县、化州市、阳江市</td>
            <td align="center">2-4个工作日送达<br />
            （由广州发货）<br />
            3-5个工作日送达<br />
            （由北京发货）</td>
            <td align="center">购物300元以下每单收12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2">广东省内其它地区<br />
            潮阳、澄海、从化、大埔、大亚湾、东源、 丰顺、佛冈、高明、海丰、和平、河源、惠阳、蕉岭、乐昌、<br />
            连南、连平、连山、连州、龙川、陆丰、陆河、罗定、梅县、梅州、南海、南雄、平远、清新、清远、曲江、<br />
            仁化、乳源、三水、汕尾、韶关、始兴、顺 德、遂溪 、翁源、吴川、五华、新丰、新会、新兴、兴宁、阳<br />
            春、阳东、阳山、阳西、英 德、郁南、云安、云浮、紫金</td>
            <td align="center">发货后3-5个 <br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="32"><font color="#2a4888">广西自治区</font></a></td>
            <td colspan="2">百色、北海市、北流、宾阳、博白、苍梧、岑溪、崇左、防城港市、扶绥、富川、贵港市、桂林市、桂平、合<br />
            浦、合山、河池、贺州、横县、来宾、荔浦、临桂、灵川、灵山、柳城、柳江、柳州市、龙胜、龙州、陆川、<br />
            鹿寨、蒙山、南宁市、宁明、<span>平</span>果、平乐、平南、凭 祥、浦北、钦州市、全州、容县、融安、融水、三江、<br />
            藤县、田东、田阳、梧州市、武鸣、武宣、象州、兴安、阳朔、宜州、邕宁、永福、玉林、昭平、钟山、资源</td>
            <td align="center">发货后3-5个 <br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="33"><font color="#2a4888">海南省</font></a></td>
            <td colspan="2">保亭、白沙、澄迈、昌江、东方、儋州、定安、海口市、临高、陵水、乐东、琼山市、琼海、琼中、三亚市、<br />
            屯昌、文昌、万宁、五指山市(通什)、洋浦经济开发区</td>
            <td align="center">发货后3-5个 <br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="34"><font color="#2a4888">四川省</font></a></td>
            <td colspan="2">安县、安岳、北川、苍溪、长宁、成都市、崇州、达州、大邑、大竹、丹棱、德阳市、都江堰、峨眉山、富<br />
            顺、高县、珙县、广安、广汉、广元市、洪雅、华蓥、夹江、简阳、剑阁、江安、江油、金堂、筠连、乐山<br />
            市、乐至、邻水、龙泉驿区、隆昌、泸县、泸州市、眉山、 米易、绵阳市、绵竹、名山、内江市、纳溪区、南<br />
            充市 南溪、攀枝花市、彭山、彭州、蓬 安、蓬溪、郫县、屏山、蒲江、青白江区、青川、青神、邛崃、仁寿、<br />
            荣县、三台、射洪、 什邡、双流、遂宁市 、万源、旺苍、威远、温江、五通桥区、武胜、西昌（凉山州）、西<br />
            充、新都、新津、兴文、叙永、雅安、盐亭、宜宾市、宜宾县、荥经、营山、岳池、中江、资阳、资中、梓<br />
            潼、自贡市</td>
            <td align="center">发货后3-5个 <br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="35"><font color="#2a4888">贵州省</font></a></td>
            <td colspan="2">安顺、毕节、都匀、贵阳市、凯里、六盘水、铜仁、兴义、遵义</td>
            <td align="center">发货后3-5个 <br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="36"><font color="#2a4888">陕西省</font></a></td>
            <td colspan="2">安康、白河、白水、宝鸡、宝鸡县、长安、城固、澄城、大荔、丹凤、凤县、凤翔、佛坪、扶风、府谷、富<br />
            平、富县、甘泉、高陵、韩城、汉阴、汉中、合阳、户县、华县、华阴、黄 陵、黄龙 、泾阳、岚皋、蓝田、<br />
            礼泉、临潼、麟游、留坝、陇县、略阳、洛川、洛南、眉 县、米脂、勉县、南郑、宁强、宁陕、平利、蒲城、<br />
            岐山、千阳、乾县、清涧、三原、山 阳、商南、商州、神木、石泉、绥德、太白、铜川、潼关、渭南、吴旗、<br />
            武功 、西乡、咸 阳、兴平、旬阳、延安、延川、阎良、杨凌区、洋县、耀县、宜川、宜君、榆林、镇 安、<br />
            镇巴、镇坪、志丹、周至、紫阳、柞水</td>
            <td align="center">发货后3-5个 <br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="37"><font color="#2a4888">云南省</font> </a></td>
            <td colspan="2">安宁、保山、宾川、呈贡、澄江、楚雄、大理、大姚、迪庆、东川、峨山、洱源、富民、富 源、个旧、鹤庆、<br />
            华宁 、建水、剑川、江川、晋宁、景洪、开远、昆明市、丽江、临沧、 陇川、陆良、禄丰、禄劝、路南、潞<br />
            西、罗平、麻栗坡、马关、马龙、勐海、勐腊、蒙自、 弥渡、弥勒、墨江、牟定、南华、南涧、普洱 、邱<br />
            北、曲靖、瑞丽、师宗、双柏、思茅、 嵩明、通海、畹町、巍山、文山、武定、西畴、新平、宣威、寻旬、砚<br />
            山、漾鼻、姚安、宜 良、易门、永平、永仁、玉溪、元江、元谋、云龙 、昭通</td>
            <td align="center">发货后3-5个 <br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="38"><font color="#2a4888">甘肃省</font></a></td>
            <td colspan="2">安西、白银、成县、崇信、东乡、迭部、宕昌、敦煌 、定西、皋兰、广河、甘南、古浪、 高台、甘谷、<br />
            会宁、和政、徽县、华亭、合水、景泰、靖远、积石山、酒泉、嘉峪关、金塔、金昌、静宁、泾川、康乐、<br />
            兰州、临洮、临夏州、临夏县、碌曲、临潭、临泽、柳园、 礼县、两当、灵台 陇西、玛曲、岷县、民勤、<br />
            民乐、宁县、平凉、清水、秦安、庆阳、山 丹、肃南、天祝、天水、通渭、渭源、武威、武山、武都、夏河、<br />
            西和、西峰、榆中、永 登、永靖、玉门、永昌、卓尼、漳县、张掖、张家川、镇原、庄浪、正宁</td>
            <td align="center">发货后3-5个 <br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="39"><font color="#2a4888">青海省</font></a></td>
            <td colspan="2">大通、格尔木、互助、湟中、湟源、海东、乐都、民和、西宁市</td>
            <td align="center">发货后3-5个 <br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="40"><font color="#2a4888">宁夏自治区</font></a></td>
            <td colspan="2">固原市、贺兰县、惠农区、灵武市、青铜峡市、石嘴山市、吴忠市、银川市、永宁县、 中卫市</td>
            <td align="center">发货后3-5个 <br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="41"><font color="#2a4888">西藏自治区</font></a></td>
            <td colspan="2">达孜县、堆龙德庆县、当雄县、贡嗄县、林芝地区八一镇、拉萨市、墨竹工卡县、那曲地区那曲镇、乃东县、<br />
            尼木县、曲水县、日喀则市、山南地区泽当镇、扎囊县</td>
            <td align="center">发货后3-5个 <br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="42"><font color="#2a4888">新疆自治区</font></a></td>
            <td colspan="2">阿克苏、阿勒泰、阿图什、博乐、昌吉、哈密、和田、克拉玛依、库尔勒、奎屯、石河子、 塔城、吐鲁番、<br />
            乌鲁木齐市、伊宁</td>
            <td align="center">发货后3-5个 <br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
    </tbody>
</table>
<link href="商城-帮助中心- 销售包括：内衣,保健品,个人护理品!.files/indexstyle.css" type="text/css" rel="stylesheet" />
<link href="商城-帮助中心- 销售包括：内衣,保健品,个人护理品!.files/shop_bottom.css" type="text/css" rel="stylesheet" />','23','0','5','','配送费用','配送费用')
 
INSERT INTO Web_Help VALUES ('24','送货上门','<table id="f" bordercolor="#d8d8eb" cellspacing="0" cellpadding="5" width="100%" border="1">
    <tbody>
        <tr>
            <td align="center" bgcolor="#ffcc99" colspan="5" height="25"><font color="#000097">送货上门订单的配送范围及时间(全国货到付款地区列表)</font></td>
        </tr>
        <tr>
            <td colspan="5" height="10"></td>
        </tr>
        <tr>
            <td align="center" bgcolor="#f2f2f9" height="25"><font size="2"><b>地 区</b></font></td>
            <td align="center" bgcolor="#f2f2f9" colspan="2"><font size="2"><b>配送范围</b></font></td>
            <td align="center" bgcolor="#f2f2f9"><font size="2"><b>送货时间</b></font></td>
            <td align="center" bgcolor="#f2f2f9"><font size="2"><b>送货费用</b></font></td>
        </tr>
        <tr>
            <td align="center" rowspan="3"><a name="1"><font color="#2a4888">北京市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="50">北京四环以内</td>
            <td align="center">一个工作日内送达</td>
            <td align="center" height="50">购物200元以下每单5元<br />
            200(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2">北京四环以外周边地区：西三旗、酒仙桥、回龙观、天通苑、东高地、石景山、古城等地</td>
            <td align="center">48小时内送达</td>
            <td align="center" height="50">购物300元以下每单15元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2">北京郊县：通县、顺义、大兴、怀柔、密云、门头沟</td>
            <td align="center">72小时内送达</td>
            <td align="center" height="50">购物300元以下每单20元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="3"><a name="2"><font color="#2a4888">上海市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2">上海市区：浦西外环线内(静安区、长宁区、普陀区、徐汇区、虹口区、杨浦区、闸北区、宝山区、黄浦区、<br />
            闵行区)及浦东内环线内所有地区</td>
            <td align="center">1个工作日送达<br />
            (上海发货) <br />
            3-5个工作日送达<br />
            (北京发货)</td>
            <td align="center" height="50">购物100元以下每单6元<br />
            100(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2">上海郊区：浦西外环线外(宝山区、普陀区、徐汇区、闵行区、嘉定区、青浦区、松江区、奉贤区、金山区、<br />
            南汇区)及浦东内环线以外所有地区</td>
            <td align="center">2个工作日送达</td>
            <td align="center" height="50">购物300元以下每单15元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2">崇明、长兴 、横沙三岛</td>
            <td align="center">3-5个工作日送达</td>
            <td align="center" height="50">购物300元以下，每单20元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="3"><font color="#2a4888">天津市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2">天津市区：和平区、河西区、河北区、河东区、南开区、红桥区、塘沽区</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="50">购物300元以下每单10元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2">天津市内其它地区</td>
            <td align="center">3-5个工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="4"><font color="#2a4888">南京市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="70">南京市区：鼓楼区、白下区、秦淮区、下关区、建邺区（双闸镇除外）、 雨花区（梅山，板桥镇除外）、玄武<br />
            区 (马群除外)、栖霞区（南京炼油厂、栖霞镇除外）、江宁区（只送东山镇）、浦口大学城、高新开发区、浦<br />
            口(大厂、六合、珠江镇除外)</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="70">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2">南京市内其它地区</td>
            <td align="center">3-5个工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="5"><font color="#2a4888">苏州市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="90">苏州市内：<br />
            东面：从上星港街延独墅湖路到东兴路止。<br />
            南面：从东兴路往南环路接迎春路、宝带路、盘蠡路,接苏福公路到西环止。<br />
            西面：从上开始滨河路接何山路至珠江路往南至竹园路止。<br />
            北面：从滨河路马运路到虎丘路往虎阜蒲庵路上接312国道至梅花新村向下接<br />
            新苏路、苏虹西路到东面星港街。</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="90">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2">苏州市内其它地区</td>
            <td align="center">3-5个工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="6"><font color="#2a4888">无锡市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="80">无锡市内：<br />
            市区范围：崇安区、南长区、北塘区（通惠路以南、蓉湖路以东） <br />
            市郊范围：滨湖区（梁溪路以南、太湖大道以北、青祁路以东）、锡山区（东亭路以西、<br />
            锡沪路以南、太湖大道以北）、惠山区（青山东路以东、锡惠路以西、锡惠公园以南)</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="80">购物300元以下每单12元，300(含)元以上免配送达</td>
        </tr>
        <tr>
            <td colspan="2">无锡市内其它地区</td>
            <td align="center">3-5个工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="7"><font color="#2a4888">常州市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="80">常州市内：湖塘区、钟楼区、天宁区全部区域； <br />
            戚墅堰区：剑湖、丁埝、潞城镇区派送； <br />
            武进区：湖塘、奔牛、横山桥、遥观、马杭、邹区、横林、鸣凰、青龙镇区可 派送；<br />
            新北区：三井、薛家、龙虎塘、小新桥镇区可派送</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="80">购物300元以下每单12元，<br />
            300(含)元以上免配送达</td>
        </tr>
        <tr>
            <td colspan="2">常州市内其它地区</td>
            <td align="center">3-5个工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="8"><font color="#2a4888">镇江市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2">镇江市区：京口区,润州区</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="50">购物300元以下每单12元，300(含)元以上免配送达</td>
        </tr>
        <tr>
            <td colspan="2">镇江市内其它地区</td>
            <td align="center">3-5个工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="9"><font color="#2a4888">宁波市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="90">宁波市内：<br />
            东面：由北延环城东路到环城南路止。<br />
            南面：从东延环城南路到环城西路止以内。<br />
            西面：接南面从环城西路转丽园路到新星路止。<br />
            北面：接西面从新星路延环城北路到环城东路止。</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="90">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2">宁波市内其它地区</td>
            <td align="center">3-5个工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="3"><a name="50"><font color="#2a4888">杭州市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="90">杭州市内：<br />
            上城区、下城区；<br />
            西湖区：南山路太子湾以东、蒋村商住区紫荆花以东、余杭塘以南；<br />
            拱墅区：莫干山路到石祥路十字路口止、石祥路以南 (不包括石大路停车场)东新路以西； <br />
            江干区：(天城路、新风路、新塘路、秋涛北路）以西 ；<br />
            滨江区：只限于滨江路以北 (滨江四区)</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="90">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="110">杭州郊区：<br />
            西湖区：龙井、灵隐、空疗、古荡至留下、三墩区域 ；<br />
            拱墅区：莫干山路到石祥路十字路口以北、石祥路以北(包括石大路停车场) 、东新路以东、半山镇；<br />
            江干区：（天城路、新风路、新塘路、秋涛北路）以东、机场路、艮山东路、航海路萧山区、半山镇(除镇上<br />
            以外地方)；<br />
            滨江区：滨江路以南（除滨江四区块区）、下沙镇、余杭区</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="110">购物300元以下每单15元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2">杭州市内其它地区</td>
            <td align="center">3-5个工作日送达</td>
            <td align="center" height="25">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="55"><font color="#2a4888">扬州市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="90">扬州市内：<br />
            广陵区、开发区、维扬区、 邗江区、文汇工业园、邗江工业园、江阳工业园、广陵产业园</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="90">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2">扬州市内其它地区</td>
            <td align="center">3-5个工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="56"><font color="#2a4888">南通市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="90">南通市内：<br />
            崇川区，港闸区，经济开发区。（南通所属县级市不送） 邮编：226001--226017</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="90">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2">南通市内其它地区</td>
            <td align="center">3-5个工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="10"><font color="#2a4888">武汉市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="120">市区范围：江汉区、江岸区、硚口区、洪山区、青山区、汉阳区（南至汉阳大道、西至二桥路）、武昌区<br />
            （东南至关山一路，南至楚雄大道、北至青山冶金大道）、汉口区（东北至堤角，北至发展大道，西至古田<br />
            一路）。<br />
            郊区范围：武昌： 白沙洲 、湖北工业大学 、华科大武昌分校 、关山一路特1号 、黄家大湾、关南工业园 <br />
            汉口、汉阳：沌口开发区、东西湖区的吴家山、舵落口、将军路、金桥大道、百步亭、丹水池、汉黄路、<br />
            堤角、工农路、长丰乡</td>
            <td align="center">3-4个工作日送达</td>
            <td align="center" height="120">购物300元以下每单收配送费18元,300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2">武汉地区内其它地区</td>
            <td align="center">3-5个工作日送达</td>
            <td align="center" height="25">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="52"><font color="#2a4888">广<br />
            东<br />
            省<br />
            泛<br />
            珠<br />
            江<br />
            三<br />
            角<br />
            洲<br />
            地<br />
            区</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2">东莞地区：石龙镇、虎门镇、中堂镇、望牛墩、麻涌镇、石碣镇、 高埠镇、洪梅镇、道滘镇、厚街镇、沙田<br />
            镇、长安镇、寮步镇、大岭山、大朗镇、黄江镇、樟木头、凤岗镇、塘夏镇、谢岗镇、清溪镇、常平镇、桥头<br />
            镇、横沥镇 、东坑镇、企石镇、石排镇、茶山镇、莞城、东城、万江、南城 <br />
            珠海地区：香洲区、吉大区拱北区、新香洲区、前山区、湾仔区、斗门县 <br />
            中山地区：南头镇、黄圃镇、东凤镇、小榄镇、阜沙镇、东升镇、横栏镇、港口镇、民众镇、坦洲镇、板芙镇、<br />
            南朗镇、古镇镇、沙溪镇、大涌镇、三乡镇、火炬开发区、五桂山镇、神湾镇、石岐地区、南区、西区<br />
            </td>
            <td align="center">24小时-48小时送达</td>
            <td align="center" height="13">购物300元以下每单8元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2">中山地区三角镇</td>
            <td align="center">24小时-48小时送达</td>
            <td align="center" height="12">购物300元以下每单10元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" height="50" rowspan="4"><a name="11"><font color="#2a4888">广州市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="50">市区：广州市环城高速公路以内可送(即白云区、黄埔区、天河区、海珠 区、荔湾区、越秀区)；<br />
            　　　广州市环城高速公路以外部分可送：新市镇（限黄石路以南）、同和镇（限白云山制药厂以南）、大沙<br />
            　　　镇、开发西区</td>
            <td align="center" rowspan="2">1个工作日送达<br />
            （由广州发货）<br />
            3-5个工作日送达<br />
            （由北京发货)</td>
            <td align="center" rowspan="2">购物100元以下每单6元<br />
            100(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="15">番禺区：可投递区域：大学城、洛溪新城、南浦、市桥镇 、市桥市区、市桥镇周边、迎宾路周边、番广公路、<br />
            　　　钟村、大石镇<br />
            　　　邮编范围：511431，511400，511485、511450、511430、511442</td>
        </tr>
        <tr>
            <td colspan="2" height="7">花都区：新华镇、花东镇、狮岭镇、炭步镇、花山镇、赤坭镇、雅瑶镇、梯面镇</td>
            <td align="center" rowspan="2">1个工作日送达<br />
            （由广州发货）<br />
            3-5个工作日送达<br />
            （由北京发货)</td>
            <td align="center" rowspan="2">购物300元以下每单7元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="8">增城：派潭镇、正果镇、小楼镇、中新镇、新塘镇、石滩镇、朱村街道、荔城街道、增江街道</td>
        </tr>
        <tr>
            <td align="center" height="50"><a name="12"><font color="#2a4888">深圳市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2">罗湖：可投递邮编518001-518025<br />
            　　　可投递区域：全区（梧桐山、大旺山上除外）<br />
            福田：可投递邮编518026-518050<br />
            　　　可投递区域：全区<br />
            南山：可投递邮编：518051-518071<br />
            　　　可投递区域：全区（白芒工业区、南岗工业区、阳光工业区、流城工业区除外）<br />
            龙岗：可投递邮编：518112、518113、518115、518116、518172<br />
            　　　可投递区域：龙岗镇、横岗镇、布吉镇(秀峰工业区、上李朗、下李郎、甘坑村除外)<br />
            　　　不可投递区域：坪山镇、杭梓镇、葵涌镇、大鹏镇、南澳镇、平湖镇 <br />
            宝安：可投递邮编：518109、518101、518102、518128、518131、518133<br />
            　　　可投递区域：新安、西乡、机场, 龙华镇（青湖村、大浪村除外）、坂田<br />
            　　　不可投递区域：沙井、光明、公明、福永、松岗、石岩、观澜<br />
            盐田：可投递邮编：518081、518082、518090<br />
            　　　可投递区域：沙头角镇<br />
            　　　不可投递区域：大小梅沙、中英街内、盐田三、四村、三洲田</td>
            <td align="center" rowspan="2">1-2个工作日送达<br />
            （由广州发货）<br />
            3-5个工作日送达<br />
            （由北京发货)</td>
            <td align="center" rowspan="2">购物100元以下每单6元<br />
            100(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" height="50"><a name="13"><font color="#2a4888">佛山市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2">可投递区域：禅城、南海市区、石湾、平洲镇、南海桂城、盐步、黄岐、张槎镇<br />
            邮编范围：528000、528031、528200、528247、、528248、528051</td>
        </tr>
        <tr>
            <td align="center" height="25"><a name="14"><font color="#2a4888">福州市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2">全区派送（县级，乡村除外）</td>
            <td align="center" rowspan="2">2-3个工作日送达</td>
            <td align="center" rowspan="2">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" height="25"><a name="53"><font color="#2a4888">厦门市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2">全区派送（县级，乡村除外）</td>
        </tr>
        <tr>
            <td align="center" rowspan="3"><a name="43"><font color="#2a4888">青岛市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="35">市南区、市北区、四方区：全境派送</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="35">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="50">崂山区、李沧区、城阳区、黄岛区：仅送市区部分</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="50">购物300元以下每单15元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="50">青岛市内其它地区</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="3"><a name="44"><font color="#2a4888">大连市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="50">市区:中山区,西岗区,沙河口区,甘井子区</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="50">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="50">郊区:高新开发区</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="50">购物300元以下每单15元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="50">大连市内其它地区</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="3"><a name="47"><font color="#2a4888">沈阳市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="50">市区:和平区、沈和区、黄沽区、铁西区、大东区</td>
            <td align="center">2-4个工作日送达</td>
            <td align="center" height="50">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="50">郊区:俞洪区、东陵区</td>
            <td align="center">2-4个工作日送达</td>
            <td align="center" height="50">购物300元以下每单15元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="50">沈阳市内其它地区</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="51"><font color="#2a4888">哈尔滨市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="50">市区:道外、南岗、道里、香坊、动力、平房、松北、呼兰</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="50">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="50">哈尔滨市内其它地区</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="48"><font color="#2a4888">济南市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="50">市区:济南市二环路以内（含二环路）</td>
            <td align="center">2-4个工作日送达</td>
            <td align="center" height="50">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="50">济南市内其它地区</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="45"><font color="#2a4888">郑州市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="50">配送区域：东至 107 国道，南至南三环，西至西环，北至北环， 以内的全部区域(金水区、 二七区、管城区、<br />
            中原区、邙山区)</td>
            <td align="center">2-3个工作日送达</td>
            <td align="center" height="50">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="50">郑州市内其它地区</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="2"><a name="46"><font color="#2a4888">西安市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="50">配送区域：东到纺织城,西到阿房路,北到张家堡,南到华美(067基地)</td>
            <td align="center">3-4个工作日送达</td>
            <td align="center" height="50">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="50">西安市内其它地区</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="3"><a name="49"><font color="#2a4888">太原市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="50">市区：迎泽区、杏花岭区、小店区</td>
            <td align="center">2-4个工作日送达</td>
            <td align="center" height="50">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="50">郊区：尖草坪区、万柏林区、晋源区、中北大学、西山矿务局、小店镇</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center" height="50">购物300元以下每单15元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="50">太原市其它地区</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="15"><font color="#2a4888">重庆市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="70">巴南区、巴县、北碚区、璧山、长寿、大渡口、大足、垫江、合川 、江北区、江津、九龙坡区、梁平、南岸<br />
            区、綦江、荣昌、沙坪坝区、双桥区、铜梁、潼南、万盛区、永川、渝北区、渝中区</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center" height="70">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="4"><a name="54"><font color="#2a4888">石家庄市</font></a><br />
            （已开通同城<br />
            快递服务）</td>
            <td colspan="2" height="50">市区：新华区、桥西区、裕华东区、桥东区</td>
            <td align="center">2-4个工作日送达</td>
            <td align="center" height="50">购物300元以下每单12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="50">郊区：高新开发区</td>
            <td align="center" rowspan="2">2-4个工作日送达</td>
            <td align="center" rowspan="2">购物300元以下每单15元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2" height="50">经济开发区（县级）：正定、鹿泉、经济开发区</td>
        </tr>
        <tr>
            <td colspan="2" height="50">石家庄市内其它地区</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center" height="50">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="16"><font color="#2a4888">河北省</font></a></td>
            <td colspan="2" height="280">安国市、安平县、安新县、霸州市、柏乡县、保定、泊头市、博野县、沧州市、昌黎县、成安县、承德市、承德<br />
            县、崇礼县、磁县、大厂、大城县、大名县、定兴县、定州市、东光县、肥乡县、丰南市、丰宁县、丰润县、<br />
            峰峰、抚宁县、阜城县、阜平县、高碑店市、高阳县、藁城、固安、故城、馆陶县、广平县、广宗县、海兴县、<br />
            邯郸、河间市、衡水、怀安县、怀来县、黄骅市、鸡泽县、冀州市、晋州市、井陉矿区、井陉县、景县、巨鹿<br />
            县、宽城县、涞水县、涞源县、廊坊、乐亭县、蠡县、临城县、临西县、临漳县、隆化县、隆尧县、卢龙县、鹿<br />
            泉市、栾城、滦南县、滦平县、滦县、满城县、孟村县、内邱县、南宫市、南和县、南皮县、宁晋县、平泉县、<br />
            平乡县、迁安县、迁西县、秦皇岛、青龙县、青县、清河县、清苑县、邱县、曲阳县、曲周县、饶阳县、任丘<br />
            市、任县、容城县、三河、沙河市、涉县、深州市、顺平县、肃宁县、唐海县、唐山、唐县、万全县、望都县、<br />
            威县、围场县、蔚县、魏县、文安、无极县、吴桥县、武安市、武强县、武邑县、下花园、献县、香河、辛集<br />
            市、新河县、新乐、兴隆县、行唐、邢台、雄县、徐水县、宣化、盐山县、阳原县、易县、永年县、永清、玉田<br />
            县、元氏、枣强县、张北县、张家口、赵县、正定县、涿鹿县、涿州市、遵化市</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="17"><font color="#2a4888">山西省</font></a></td>
            <td colspan="2" height="140">安泽、长治市、长治县、长子、大宁、大同市、大同县、代县、定襄、繁峙、汾西、汾阳、浮山、高平市、古交<br />
            市、 古县、广灵、河津市、洪洞、侯马、壶关、怀仁、浑源、霍州市、吉县、稷山、绛县、交城、介休、晋城、<br />
            晋中市、 静乐、离石、黎城、临汾、 临猗、灵丘、灵石、陵川、柳林、娄烦、潞城市、孟县、宁武、平定、平<br />
            鲁区、平陆、平顺、平遥、蒲县、祁县、沁水、沁县、沁源、清徐、曲沃、芮城、山阴、寿阳、朔州、太谷、<br />
            太原市、天镇、屯留、万荣、文水、闻喜、五台、五寨、武乡、昔阳、隰县、夏县、乡宁、襄汾、襄垣、孝义<br />
            市、忻州、新绛、阳城、阳高、阳曲、阳泉、翼城、应县、永和、永济市、垣曲、原平市、运城、左云</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="18"><font color="#2a4888">内蒙古自治区</font></a></td>
            <td colspan="2" height="60">阿尔山、阿左旗、包头、赤峰、额尔古纳、鄂尔多斯（东胜）、二连浩特、丰镇市、根河、海拉尔、呼和浩特<br />
            市、霍林郭勒、集宁、临河、满州里、通辽、乌海、乌兰浩特、锡林浩特、牙克石、扎兰屯市</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="19"><font color="#2a4888">辽宁省</font></a></td>
            <td colspan="2" height="100">鞍山市、北宁、北票、本溪市、本溪县、昌图、朝阳市、朝阳县、大石桥、大洼、丹东市、灯塔、东港、法库、<br />
            凤城、抚顺市、抚顺县、阜新市、阜新县、盖州、海城、黑山、葫芦岛 （锦西）市、桓仁、建昌、建平、锦州<br />
            市、喀左、开原、康平、宽甸、辽阳市、辽阳县、辽中、凌海、凌源、盘锦市、盘山、普兰店、清原、沈阳市、<br />
            绥中、台安、铁法、铁岭市、铁 岭县、瓦房店、西丰、新宾、新民、兴城、岫岩、义县、营口市、彰武、庄河</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="20"><font color="#2a4888">吉林省</font></a></td>
            <td colspan="2" height="80">安图、白城市、白山市、长白、长春市、长岭、大安、德惠、东丰、敦化、抚松、公主岭、和龙、桦甸、珲春、<br />
            辉南、吉林市、集安、蛟河、靖宇、九台、梨树、辽源市、临江、柳河、龙井、梅河口、农安、磐石、乾安、<br />
            舒兰、双辽、双阳、四平市、松原市、洮南、通化市、通化县、通榆、图们、汪清、延吉市、伊通、永吉、榆<br />
            树、镇赉</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="21"><font color="#2a4888">黑龙江省</font></a></td>
            <td colspan="2" height="80">阿城、宝清、宾县、大庆市、东宁、方正、富锦、哈尔滨市、海林、海伦、鹤岗市、黑河市、呼兰、虎林、鸡<br />
            东、鸡西市、加格达奇、佳木斯市、建三江、克山、龙江、萝北、密山、牡丹江市、讷河、七台河市、齐齐哈<br />
            尔、尚志、双鸭山市、绥芬河、绥棱、五常、五大连池市、伊春市、依兰、肇东</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="22"><font color="#2a4888">江苏省</font></a></td>
            <td colspan="2" height="90">宝应、滨海、常熟、大丰、丹阳、东海、东台、丰县、阜宁、赣榆、高淳、高邮、灌南、灌云、海安、海门、<br />
            洪泽、淮安、淮阴市、淮阴县、建湖、江都、江宁、江浦、江阴、姜堰、金湖、金坛、靖江、句容、昆山、<br />
            溧水、 溧阳、连云港、涟水、六合、南通、沛县、邳州、启东、如东、如皋、射阳、沭阳、泗洪、泗阳、<br />
            宿迁、睢宁、太仓、泰兴、泰州、通州、吴江、响水、新沂、兴化、盱眙、胥浦、徐州、盐城、扬中、扬州、<br />
            仪征、宜兴、张家港</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="23"><font color="#2a4888">浙江省</font></a></td>
            <td colspan="2" height="100">北仑、苍南、长兴、常山、淳安、慈溪、德清、东阳、奉化、富阳、海宁、海盐、杭州、湖州、嘉善、嘉兴、<br />
            建德、江山、金华、缙云、景宁、开化、兰溪、乐清、丽水、临安、 临海、龙泉、龙游、宁波、宁海、磐安、<br />
            平湖、平阳、浦江、普陀、青田、庆元、衢州、瑞安、三门、上虞、绍兴、嵊州、松阳、遂昌、台州、天台、<br />
            桐庐、桐乡、温岭、 温州、武义、仙居、象山、萧山、新昌、义乌、永嘉、永康、余杭、余姚、玉环、云和、<br />
            镇海、舟山、诸暨</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="24"><font color="#2a4888">安徽省</font></a></td>
            <td colspan="2" height="110">安庆市、蚌埠市、亳州、长丰、巢湖、池州、滁州市、枞阳、当涂、砀山、定远、东至、繁昌、肥东、肥西、<br />
            凤台、凤阳、阜南、阜阳市、固镇、广德、含山、合肥市、和县、怀宁、怀远、淮北市、淮南市、黄山区、黄<br />
            山市、霍邱、霍山、绩溪、嘉山、界首、金寨、泾县、旌德、来安、郎溪、利辛、临泉、灵壁、六安、庐江、<br />
            马鞍山市、蒙城、南陵、宁国、祁门、潜山、青阳、全椒、石台、寿县、舒城、泗县、宿松、宿州、濉溪、太<br />
            和、太湖、天长、桐城、铜陵市、铜陵县、望江、涡阳、无为、芜湖市、芜湖县、五河、歙县、肖县、休宁、<br />
            宣州、黟县、颖上、岳西</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="25"><font color="#2a4888">福建省</font></a></td>
            <td colspan="2" height="100">安溪、长乐、长泰、长汀、大田、德化、东山、福安、福鼎、福清、古田、光泽、华安、惠安、建宁、建瓯、<br />
            建阳、将乐、晋江、连城、连江、龙海、龙岩、罗源、闽侯、闽清、明溪、南安、南靖、南平、宁德、宁化、<br />
            平和、平潭、屏南、莆田、浦城、清流、泉 州、三明、沙县、上杭、邵武、石狮、寿宁、顺昌、松溪、泰宁、<br />
            同安、武平、武夷山、霞浦、仙游、永安、永春、永定、永泰、尤溪、云霄、漳平、漳浦、漳州、诏安、柘<br />
            荣、政和、周宁</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="26"><font color="#2a4888">江西省</font></a></td>
            <td colspan="2" height="130">安福、安义、安远、波阳、崇仁、崇义、大余、德安、德兴、定南、东乡、都昌、分宜、丰城、奉新、浮梁、<br />
            抚州、赣县、赣州、高安、广昌、广丰、贵溪、横峰、湖口、会昌、吉安、吉安县、吉水、金溪、进贤、井岗<br />
            山、景德镇市、靖安、九江市、九江县、乐安、乐平、黎川、莲花、临川、龙南、庐山、南昌市、南昌县、南<br />
            城、南丰、南康、宁都、宁冈、彭泽、萍乡市、铅山、全南、瑞昌、瑞金、上高、上饶、上饶县、上犹、石城、<br />
            遂川、泰和、铜鼓、万安、万年、万载、武宁、婺源、峡江、新干、新建、新余市、信丰、兴国、星子、修水、<br />
            寻乌、宜春、宜丰、宜黄、弋阳、鹰潭市、永丰、永新、永修、于都、余干、余江、玉山、樟树、资溪</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="27"><font color="#2a4888">山东省</font></a></td>
            <td colspan="2">安丘、滨州、博兴、苍山、曹县、昌乐、昌邑、长清、成武、茌平、单县、德州、定陶、东阿、东明、东平、东<br />
            营、肥城、费县、高密、高青、高唐、冠县、广饶、海阳、菏泽、桓台、惠民、即墨、济南、济宁、济阳、嘉<br />
            祥、胶南、胶州、金乡、莒南、莒县、巨野、鄄城、垦利、莱芜、莱西、莱阳、莱州、乐陵、利津、梁山、聊<br />
            城、临清、临朐、临沭、临沂、临邑、陵县、蒙阴、牟平、宁津、宁阳、蓬莱、平度、平邑、平阴、平原、栖<br />
            霞、齐 河、青州、庆云、曲阜、日照、荣城、乳山、商河、寿光、泗水、泰安、郯城、滕州、威 海、微山、<br />
            潍坊、文登、汶上、无棣、五莲、武城、夏津、莘县、新泰、烟台、兖州、阳谷、阳信、沂南、沂水、沂源、<br />
            鱼台、禹城、郓城、枣庄、沾化、章丘、招远、诸城、淄博、邹城、邹平</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="28"><font color="#2a4888">河南省</font></a></td>
            <td colspan="2">安阳市、安阳县、宝丰、博爱、长葛、长垣、郸城、登封市、邓州、范县、方城、封丘、扶 沟、巩义、固始、<br />
            光山、鹤壁市、滑县、淮滨、淮阳、潢川、辉县、获嘉、济源、郏县、焦 作市、浚县、开封市、开封县、兰<br />
            考、林州、临颖、灵宝、卢氏、鲁山、鹿邑、栾川、罗 山、洛宁、洛阳市、漯河市、孟津、孟县、泌阳、民<br />
            权、内黄、内乡、南乐、南阳市、南阳 县、南召、宁陵、平顶山市、平舆、濮阳市、濮阳县、淇县、杞县、沁<br />
            阳、清丰、确山、汝 南、汝阳、汝州、三门峡市、陕县、商城、商丘市、商丘县、商水、上蔡、上街区、社<br />
            旗、 沈丘、渑池、嵩县、睢县、遂平、台前、太康、汤阴、唐河、通许、桐柏、卫辉、尉氏、县、武陟、舞<br />
            钢、舞阳、西华、西平、西峡、息县、淅川、夏邑、襄城、项城、新安、新 蔡、新密、新县、新乡市、新乡<br />
            县、新野、新郑、信阳市、信阳县、修武、许昌市、许昌 县、荥阳、鄢陵、延津、偃师、郾城、叶县、伊川、<br />
            宜阳、义马、永城、虞城、禹州、原阳、柘城、镇平、正阳、中牟、周口市、驻马店市</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="29"><font color="#2a4888">湖北省</font></a></td>
            <td colspan="2">安陆、蔡甸区、长阳、赤壁（蒲圻）、崇阳、大悟、大冶、丹江口、当阳、鄂州市、恩施、房县、公安、谷<br />
            城、广水、汉川、红安、洪湖、黄陂、黄冈市、黄梅、黄石市、嘉鱼、监利、建始、江夏区、京山、荆门市、<br />
            荆州市、老河口、罗田、麻城、南漳、蕲春、潜江、十堰市、石首、松滋、随州、天门、通城、通山、团风、<br />
            武穴、浠水、仙桃、咸宁、咸宁地 区、襄樊市、襄阳、孝昌、孝感市、新洲、宣恩、阳新、宜昌市、宜昌县、<br />
            宜城、宜 都（枝城）、应城、英山、远安、云梦、陨县、枣阳、枝江、钟祥</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="30"><font color="#2a4888">湖南省</font></a></td>
            <td colspan="2">长沙市、常德市、郴州市、衡阳市、怀化市、邵阳市、湘潭市、益阳市、永州市、岳阳市、<br />
            株洲市</td>
            <td align="center">发货后3-5个<br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center" rowspan="3"><a name="31"><font color="#2a4888">广东省</font></a></td>
            <td align="center" width="95">广<br />
            东<br />
            省<br />
            泛<br />
            珠<br />
            江<br />
            三<br />
            角<br />
            洲<br />
            其<br />
            它<br />
            地<br />
            区<br />
            </td>
            <td width="663">惠州地区：惠城区、大亚湾区、惠阳区、博罗县、惠东县、龙门县<br />
            江门地区：蓬江区、江海区、新会区、台山市、开平市、恩平市、鹤山市<br />
            肇庆地区：端州区、鼎湖区、高要市、四会市<br />
            湛江地区：赤坎区、霞山区、坡头区、廉江市<br />
            茂名地区：茂南区、茂港区 <br />
            潮汕地区<br />
            汕头地区：金平区、龙湖区、濠江区、潮阳区、潮南区、澄海区、南澳县<br />
            潮州地区：湘桥区、枫溪区、潮安县</td>
            <td align="center">2-3个工作日送达<br />
            （由广州发货）<br />
            3-5个工作日送达 <br />
            （由北京发货)</td>
            <td align="center">购物300元以下每单10元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td width="95">偏远地区</td>
            <td width="663">揭阳（榕城区、揭东、惠来、揭西、普宁市)饶平县、广宁县、德庆县、封开县、怀集县、雷州市、徐闻县、信宜市、高州市、电白县、化州市、阳江市</td>
            <td align="center">2-4个工作日送达<br />
            （由广州发货）<br />
            3-5个工作日送达<br />
            （由北京发货）</td>
            <td align="center">购物300元以下每单收12元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td colspan="2">广东省内其它地区<br />
            潮阳、澄海、从化、大埔、大亚湾、东源、 丰顺、佛冈、高明、海丰、和平、河源、惠阳、蕉岭、乐昌、<br />
            连南、连平、连山、连州、龙川、陆丰、陆河、罗定、梅县、梅州、南海、南雄、平远、清新、清远、曲江、<br />
            仁化、乳源、三水、汕尾、韶关、始兴、顺 德、遂溪 、翁源、吴川、五华、新丰、新会、新兴、兴宁、阳<br />
            春、阳东、阳山、阳西、英 德、郁南、云安、云浮、紫金</td>
            <td align="center">发货后3-5个 <br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="32"><font color="#2a4888">广西自治区</font></a></td>
            <td colspan="2">百色、北海市、北流、宾阳、博白、苍梧、岑溪、崇左、防城港市、扶绥、富川、贵港市、桂林市、桂平、合<br />
            浦、合山、河池、贺州、横县、来宾、荔浦、临桂、灵川、灵山、柳城、柳江、柳州市、龙胜、龙州、陆川、<br />
            鹿寨、蒙山、南宁市、宁明、<span>平</span>果、平乐、平南、凭 祥、浦北、钦州市、全州、容县、融安、融水、三江、<br />
            藤县、田东、田阳、梧州市、武鸣、武宣、象州、兴安、阳朔、宜州、邕宁、永福、玉林、昭平、钟山、资源</td>
            <td align="center">发货后3-5个 <br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="33"><font color="#2a4888">海南省</font></a></td>
            <td colspan="2">保亭、白沙、澄迈、昌江、东方、儋州、定安、海口市、临高、陵水、乐东、琼山市、琼海、琼中、三亚市、<br />
            屯昌、文昌、万宁、五指山市(通什)、洋浦经济开发区</td>
            <td align="center">发货后3-5个 <br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="34"><font color="#2a4888">四川省</font></a></td>
            <td colspan="2">安县、安岳、北川、苍溪、长宁、成都市、崇州、达州、大邑、大竹、丹棱、德阳市、都江堰、峨眉山、富<br />
            顺、高县、珙县、广安、广汉、广元市、洪雅、华蓥、夹江、简阳、剑阁、江安、江油、金堂、筠连、乐山<br />
            市、乐至、邻水、龙泉驿区、隆昌、泸县、泸州市、眉山、 米易、绵阳市、绵竹、名山、内江市、纳溪区、南<br />
            充市 南溪、攀枝花市、彭山、彭州、蓬 安、蓬溪、郫县、屏山、蒲江、青白江区、青川、青神、邛崃、仁寿、<br />
            荣县、三台、射洪、 什邡、双流、遂宁市 、万源、旺苍、威远、温江、五通桥区、武胜、西昌（凉山州）、西<br />
            充、新都、新津、兴文、叙永、雅安、盐亭、宜宾市、宜宾县、荥经、营山、岳池、中江、资阳、资中、梓<br />
            潼、自贡市</td>
            <td align="center">发货后3-5个 <br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="35"><font color="#2a4888">贵州省</font></a></td>
            <td colspan="2">安顺、毕节、都匀、贵阳市、凯里、六盘水、铜仁、兴义、遵义</td>
            <td align="center">发货后3-5个 <br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="36"><font color="#2a4888">陕西省</font></a></td>
            <td colspan="2">安康、白河、白水、宝鸡、宝鸡县、长安、城固、澄城、大荔、丹凤、凤县、凤翔、佛坪、扶风、府谷、富<br />
            平、富县、甘泉、高陵、韩城、汉阴、汉中、合阳、户县、华县、华阴、黄 陵、黄龙 、泾阳、岚皋、蓝田、<br />
            礼泉、临潼、麟游、留坝、陇县、略阳、洛川、洛南、眉 县、米脂、勉县、南郑、宁强、宁陕、平利、蒲城、<br />
            岐山、千阳、乾县、清涧、三原、山 阳、商南、商州、神木、石泉、绥德、太白、铜川、潼关、渭南、吴旗、<br />
            武功 、西乡、咸 阳、兴平、旬阳、延安、延川、阎良、杨凌区、洋县、耀县、宜川、宜君、榆林、镇 安、<br />
            镇巴、镇坪、志丹、周至、紫阳、柞水</td>
            <td align="center">发货后3-5个 <br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="37"><font color="#2a4888">云南省</font> </a></td>
            <td colspan="2">安宁、保山、宾川、呈贡、澄江、楚雄、大理、大姚、迪庆、东川、峨山、洱源、富民、富 源、个旧、鹤庆、<br />
            华宁 、建水、剑川、江川、晋宁、景洪、开远、昆明市、丽江、临沧、 陇川、陆良、禄丰、禄劝、路南、潞<br />
            西、罗平、麻栗坡、马关、马龙、勐海、勐腊、蒙自、 弥渡、弥勒、墨江、牟定、南华、南涧、普洱 、邱<br />
            北、曲靖、瑞丽、师宗、双柏、思茅、 嵩明、通海、畹町、巍山、文山、武定、西畴、新平、宣威、寻旬、砚<br />
            山、漾鼻、姚安、宜 良、易门、永平、永仁、玉溪、元江、元谋、云龙 、昭通</td>
            <td align="center">发货后3-5个 <br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="38"><font color="#2a4888">甘肃省</font></a></td>
            <td colspan="2">安西、白银、成县、崇信、东乡、迭部、宕昌、敦煌 、定西、皋兰、广河、甘南、古浪、 高台、甘谷、<br />
            会宁、和政、徽县、华亭、合水、景泰、靖远、积石山、酒泉、嘉峪关、金塔、金昌、静宁、泾川、康乐、<br />
            兰州、临洮、临夏州、临夏县、碌曲、临潭、临泽、柳园、 礼县、两当、灵台 陇西、玛曲、岷县、民勤、<br />
            民乐、宁县、平凉、清水、秦安、庆阳、山 丹、肃南、天祝、天水、通渭、渭源、武威、武山、武都、夏河、<br />
            西和、西峰、榆中、永 登、永靖、玉门、永昌、卓尼、漳县、张掖、张家川、镇原、庄浪、正宁</td>
            <td align="center">发货后3-5个 <br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="39"><font color="#2a4888">青海省</font></a></td>
            <td colspan="2">大通、格尔木、互助、湟中、湟源、海东、乐都、民和、西宁市</td>
            <td align="center">发货后3-5个 <br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="40"><font color="#2a4888">宁夏自治区</font></a></td>
            <td colspan="2">固原市、贺兰县、惠农区、灵武市、青铜峡市、石嘴山市、吴忠市、银川市、永宁县、 中卫市</td>
            <td align="center">发货后3-5个 <br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="41"><font color="#2a4888">西藏自治区</font></a></td>
            <td colspan="2">达孜县、堆龙德庆县、当雄县、贡嗄县、林芝地区八一镇、拉萨市、墨竹工卡县、那曲地区那曲镇、乃东县、<br />
            尼木县、曲水县、日喀则市、山南地区泽当镇、扎囊县</td>
            <td align="center">发货后3-5个 <br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
        <tr>
            <td align="center"><a name="42"><font color="#2a4888">新疆自治区</font></a></td>
            <td colspan="2">阿克苏、阿勒泰、阿图什、博乐、昌吉、哈密、和田、克拉玛依、库尔勒、奎屯、石河子、 塔城、吐鲁番、<br />
            乌鲁木齐市、伊宁</td>
            <td align="center">发货后3-5个 <br />
            工作日送达</td>
            <td align="center">购物300元以下每单25元<br />
            300(含)元以上免配送费</td>
        </tr>
    </tbody>
</table>','24','0','5','','送货上门','送货上门')
 
INSERT INTO Web_Help VALUES ('27','关于我们','<div style="padding-right: 10px; padding-left: 10px; padding-bottom: 10px; line-height: 18px; padding-top: 10px" align="left"><strong><font color="#333333"><strong><a href="http://www.021web.com.cn/about.html#"><font color="#333333">上海威博网络技术有限公司</font></a></strong><font color="#ffffff">:</font><br />
<br />
<font color="#696969">　　</font><font color="#858585">是一家致力于网上购物系统开发的科技型企业。创始于1997年，早期从事办公自动化、电子商务软件的研发。1998年，威博网络全面进入电子商务服务市场。在为企业提供电子商务服务的不断摸索中，威博网络逐步探索出一套成熟的发展模式。做为国内网上购物系统开发的先行者，上海威博网络技术有限公司拥有一支专业的技术团队，他们用智慧与勤奋打造出了一系列拥有完全著作知识产权的网上购物系统，包括：中英文、英文版、专卖店版、企业版、普及版Ⅱ、多用户版、单用户等。这一系列购物系统自面世以来深受广大用户的好评，为广大致力于网上营销的企业和个人提供了最佳的电子商务解决方案。<br />
<br />
　　<font color="#000000">威博公司</font>成立至今，在国内外拥有近7万家客户，并且在业内拥有良好的信誉和口碑。这是对威博网络的肯定，同时也是威博网络发展的动力。&ldquo;做最好的购物系统&rdquo;是威博网络的一贯的信念。在这一信念的指引下，威博网络开拓进取，才有了今天的蓬勃发展。现在威博网上购物系统各地代理商遍布国内外。国内代理主要分布在华东、华北、华南、华中地区；国外代理主要分布在澳大利亚、新西兰等地。威博网络坚持&ldquo;服务至上、客户为本&rdquo;的宗旨。为更好的服务广大用户，威博网络在山东、浙江等地建立了办事处，并将进一步全方位、多层次的服务体系。 </font></font></strong></div>','27','0','1','','由上海威博网络技术有限公司和澳大利亚Minerva Corporate有限公司共同开发的合作项目','由上海威博网络技术有限公司和澳大利亚Minerva Corporate有限公司共同开发的合作项目')
 
CREATE TABLE dbo.Tmp_Web_Help([ID] [int]  NOT NULL IDENTITY (1, 1),[Title] [nvarchar] (100)  NULL,[Content] [ntext]  NULL,[OrderID] [int]  NULL,[Hits] [int]  NULL,[CategoryID] [int]  NULL,[Template] [nvarchar] (150)  NULL,[SearchKey] [nvarchar] (100)  NULL,[Description] [nvarchar] (200)  NULL)  ON [PRIMARY] 
 
SET IDENTITY_INSERT dbo.Tmp_Web_Help ON
 
IF EXISTS(SELECT * FROM dbo.Web_Help) EXEC('INSERT INTO dbo.Tmp_Web_Help ([ID],[Title],[Content],[OrderID],[Hits],[CategoryID],[Template],[SearchKey],[Description]) SELECT [ID],[Title],[Content],[OrderID],[Hits],[CategoryID],[Template],[SearchKey],[Description] FROM dbo.Web_Help WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Help OFF
 
DROP TABLE dbo.Web_Help
 
EXECUTE sp_rename N'dbo.Tmp_Web_Help', N'Web_Help', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Info]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Info] 
 
CREATE TABLE dbo.Web_Info([ID] [int]  NOT NULL,[Title] [nvarchar] (100)  NULL,[Content] [ntext]  NULL,[OrderId] [int]  NOT NULL,[Category] [int]  NOT NULL,[ByName] [nvarchar] (20)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Info ADD CONSTRAINT DF_Web_Info_OrderId DEFAULT ((0)) FOR [OrderId]
 
INSERT INTO Web_Info VALUES ('1','关于我们','<table cellspacing="0" cellpadding="0" width="96%" border="0">
    <tbody>
        <tr>
            <td height="20"></td>
        </tr>
        <tr>
            <td>
            <div style="line-height: 18px"><strong><a href="http://www.021web.com.cn/about.html#"><font color="#333333">上海威博网络技术有限公司</font></a></strong><font color="#ffffff">:</font><br />
            <br />
            　　<font color="#858585">是一家致力于网上购物系统开发的科技型企业。创始于1997年，早期从事办公自动化、电子商务软件的研发。1998年，威博网络全面进入电子商务服务市场。在为企业提供电子商务服务的不断摸索中，威博网络逐步探索出一套成熟的发展模式。做为国内网上购物系统开发的先行者，上海威博网络技术有限公司拥有一支专业的技术团队，他们用智慧与勤奋打造出了一系列拥有完全著作知识产权的网上购物系统，包括：中英文、英文版、专卖店版、企业版、普及版Ⅱ、多用户版、单用户等。这一系列购物系统自面世以来深受广大用户的好评，为广大致力于网上营销的企业和个人提供了最佳的电子商务解决方案。<br />
            <br />
            　　<font color="#000000">威博公司</font>成立至今，在国内外拥有近7万家客户，并且在业内拥有良好的信誉和口碑。这是对威博网络的肯定，同时也是威博网络发展的动力。&ldquo;做最好的购物系统&rdquo;是威博网络的一贯的信念。在这一信念的指引下，威博网络开拓进取，才有了今天的蓬勃发展。现在威博网上购物系统各地代理商遍布国内外。国内代理主要分布在华东、华北、华南、华中地区；国外代理主要分布在澳大利亚、新西兰等地。威博网络坚持&ldquo;服务至上、客户为本&rdquo;的宗旨。为更好的服务广大用户，威博网络在山东、浙江等地建立了办事处，并将进一步全方位、多层次的服务体系。 </font></div>
            </td>
        </tr>
    </tbody>
</table>','1','0','About')
 
INSERT INTO Web_Info VALUES ('9','联系我们','','9','0','Contact')
 
INSERT INTO Web_Info VALUES ('13','人才招聘','<table cellspacing="0" cellpadding="0" width="98%" border="0">','13','0','Hrhr')
 
CREATE TABLE dbo.Tmp_Web_Info([ID] [int]  NOT NULL IDENTITY (1, 1),[Title] [nvarchar] (100)  NULL,[Content] [ntext]  NULL,[OrderId] [int]  NOT NULL,[Category] [int]  NOT NULL,[ByName] [nvarchar] (20)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_Info ADD CONSTRAINT DF_Tmp_Web_Info_OrderId DEFAULT ((0)) FOR [OrderId]
 
SET IDENTITY_INSERT dbo.Tmp_Web_Info ON
 
IF EXISTS(SELECT * FROM dbo.Web_Info) EXEC('INSERT INTO dbo.Tmp_Web_Info ([ID],[Title],[Content],[OrderId],[Category],[ByName]) SELECT [ID],[Title],[Content],[OrderId],[Category],[ByName] FROM dbo.Web_Info WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Info OFF
 
DROP TABLE dbo.Web_Info
 
EXECUTE sp_rename N'dbo.Tmp_Web_Info', N'Web_Info', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_ActivityGift]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_ActivityGift] 
 
CREATE TABLE dbo.Web_ActivityGift([ProductID] [int]  NOT NULL,[ActivityID] [int]  NOT NULL)  ON [PRIMARY] 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_BlackIP]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_BlackIP] 
 
CREATE TABLE dbo.Web_BlackIP([Id] [int]  NOT NULL,[Start] [nvarchar] (250)  NULL,[End] [nvarchar] (150)  NULL,[StartTime] [datetime]  NULL,[EndTime] [datetime]  NULL,[Content] [nvarchar] (250)  NULL)  ON [PRIMARY] 
 
CREATE TABLE dbo.Tmp_Web_BlackIP([Id] [int]  NOT NULL IDENTITY (1, 1),[Start] [nvarchar] (250)  NULL,[End] [nvarchar] (150)  NULL,[StartTime] [datetime]  NULL,[EndTime] [datetime]  NULL,[Content] [nvarchar] (250)  NULL)  ON [PRIMARY] 
 
SET IDENTITY_INSERT dbo.Tmp_Web_BlackIP ON
 
IF EXISTS(SELECT * FROM dbo.Web_BlackIP) EXEC('INSERT INTO dbo.Tmp_Web_BlackIP ([Id],[Start],[End],[StartTime],[EndTime],[Content]) SELECT [Id],[Start],[End],[StartTime],[EndTime],[Content] FROM dbo.Web_BlackIP WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_BlackIP OFF
 
DROP TABLE dbo.Web_BlackIP
 
EXECUTE sp_rename N'dbo.Tmp_Web_BlackIP', N'Web_BlackIP', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_User]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_User] 
 
CREATE TABLE dbo.Web_User([ID] [int]  NOT NULL,[Name] [nvarchar] (50)  NOT NULL,[Password] [nvarchar] (50)  NULL,[RegDate] [datetime]  NOT NULL,[Score] [int]  NOT NULL,[ScoreUsed] [int]  NOT NULL,[Email] [nvarchar] (50)  NULL,[Sex] [int]  NOT NULL,[LoginDate] [datetime]  NOT NULL,[LoginTimes] [int]  NOT NULL,[IdentityCard] [nvarchar] (50)  NULL,[PostCode] [int]  NOT NULL,[AreaID] [int]  NOT NULL,[Address] [nvarchar] (150)  NULL,[IsLock] [int]  NOT NULL,[GroupID] [int]  NOT NULL,[Question] [nvarchar] (50)  NULL,[Answer] [nvarchar] (50)  NULL,[LoginIP] [nvarchar] (50)  NULL,[FrozenDeposit] [decimal]  (18,2) NOT NULL,[FrozenScore] [int]  NOT NULL,[BirthDay] [nvarchar] (50)  NULL,[QQ] [nvarchar] (50)  NULL,[Telephone] [nvarchar] (50)  NULL,[Phone] [nvarchar] (50)  NULL,[TrueName] [nvarchar] (50)  NULL,[Credit] [int]  NOT NULL,[CommendUser] [nvarchar] (50)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_User ADD CONSTRAINT DF_Web_User_RegDate DEFAULT (getdate()) FOR [RegDate]
 
ALTER TABLE dbo.Web_User ADD CONSTRAINT DF_Web_User_Score DEFAULT ((0)) FOR [Score]
 
ALTER TABLE dbo.Web_User ADD CONSTRAINT DF_Web_User_ScoreUsed DEFAULT ((0)) FOR [ScoreUsed]
 
ALTER TABLE dbo.Web_User ADD CONSTRAINT DF_Web_User_Sex DEFAULT ((0)) FOR [Sex]
 
ALTER TABLE dbo.Web_User ADD CONSTRAINT DF_Web_User_LoginDate DEFAULT (getdate()) FOR [LoginDate]
 
ALTER TABLE dbo.Web_User ADD CONSTRAINT DF_Web_User_LoginTimes DEFAULT ((0)) FOR [LoginTimes]
 
ALTER TABLE dbo.Web_User ADD CONSTRAINT DF_Web_User_PostCode DEFAULT ((0)) FOR [PostCode]
 
ALTER TABLE dbo.Web_User ADD CONSTRAINT DF_Web_User_AreaID DEFAULT ((0)) FOR [AreaID]
 
ALTER TABLE dbo.Web_User ADD CONSTRAINT DF_Web_User_IsLock DEFAULT ((0)) FOR [IsLock]
 
ALTER TABLE dbo.Web_User ADD CONSTRAINT DF_Web_User_GroupID DEFAULT ((0)) FOR [GroupID]
 
ALTER TABLE dbo.Web_User ADD CONSTRAINT DF_Web_User_FrozenDeposit DEFAULT ((0)) FOR [FrozenDeposit]
 
ALTER TABLE dbo.Web_User ADD CONSTRAINT DF_Web_User_FrozenScore DEFAULT ((0)) FOR [FrozenScore]
 
ALTER TABLE dbo.Web_User ADD CONSTRAINT DF_Web_User_Credit DEFAULT ((0)) FOR [Credit]
 
CREATE TABLE dbo.Tmp_Web_User([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NOT NULL,[Password] [nvarchar] (50)  NULL,[RegDate] [datetime]  NOT NULL,[Score] [int]  NOT NULL,[ScoreUsed] [int]  NOT NULL,[Email] [nvarchar] (50)  NULL,[Sex] [int]  NOT NULL,[LoginDate] [datetime]  NOT NULL,[LoginTimes] [int]  NOT NULL,[IdentityCard] [nvarchar] (50)  NULL,[PostCode] [int]  NOT NULL,[AreaID] [int]  NOT NULL,[Address] [nvarchar] (150)  NULL,[IsLock] [int]  NOT NULL,[GroupID] [int]  NOT NULL,[Question] [nvarchar] (50)  NULL,[Answer] [nvarchar] (50)  NULL,[LoginIP] [nvarchar] (50)  NULL,[FrozenDeposit] [decimal]  (18,2) NOT NULL,[FrozenScore] [int]  NOT NULL,[BirthDay] [nvarchar] (50)  NULL,[QQ] [nvarchar] (50)  NULL,[Telephone] [nvarchar] (50)  NULL,[Phone] [nvarchar] (50)  NULL,[TrueName] [nvarchar] (50)  NULL,[Credit] [int]  NOT NULL,[CommendUser] [nvarchar] (50)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_User ADD CONSTRAINT DF_Tmp_Web_User_RegDate DEFAULT (getdate()) FOR [RegDate]
 
ALTER TABLE dbo.Tmp_Web_User ADD CONSTRAINT DF_Tmp_Web_User_Score DEFAULT ((0)) FOR [Score]
 
ALTER TABLE dbo.Tmp_Web_User ADD CONSTRAINT DF_Tmp_Web_User_ScoreUsed DEFAULT ((0)) FOR [ScoreUsed]
 
ALTER TABLE dbo.Tmp_Web_User ADD CONSTRAINT DF_Tmp_Web_User_Sex DEFAULT ((0)) FOR [Sex]
 
ALTER TABLE dbo.Tmp_Web_User ADD CONSTRAINT DF_Tmp_Web_User_LoginDate DEFAULT (getdate()) FOR [LoginDate]
 
ALTER TABLE dbo.Tmp_Web_User ADD CONSTRAINT DF_Tmp_Web_User_LoginTimes DEFAULT ((0)) FOR [LoginTimes]
 
ALTER TABLE dbo.Tmp_Web_User ADD CONSTRAINT DF_Tmp_Web_User_PostCode DEFAULT ((0)) FOR [PostCode]
 
ALTER TABLE dbo.Tmp_Web_User ADD CONSTRAINT DF_Tmp_Web_User_AreaID DEFAULT ((0)) FOR [AreaID]
 
ALTER TABLE dbo.Tmp_Web_User ADD CONSTRAINT DF_Tmp_Web_User_IsLock DEFAULT ((0)) FOR [IsLock]
 
ALTER TABLE dbo.Tmp_Web_User ADD CONSTRAINT DF_Tmp_Web_User_GroupID DEFAULT ((0)) FOR [GroupID]
 
ALTER TABLE dbo.Tmp_Web_User ADD CONSTRAINT DF_Tmp_Web_User_FrozenDeposit DEFAULT ((0)) FOR [FrozenDeposit]
 
ALTER TABLE dbo.Tmp_Web_User ADD CONSTRAINT DF_Tmp_Web_User_FrozenScore DEFAULT ((0)) FOR [FrozenScore]
 
ALTER TABLE dbo.Tmp_Web_User ADD CONSTRAINT DF_Tmp_Web_User_Credit DEFAULT ((0)) FOR [Credit]
 
SET IDENTITY_INSERT dbo.Tmp_Web_User ON
 
IF EXISTS(SELECT * FROM dbo.Web_User) EXEC('INSERT INTO dbo.Tmp_Web_User ([ID],[Name],[Password],[RegDate],[Score],[ScoreUsed],[Email],[Sex],[LoginDate],[LoginTimes],[IdentityCard],[PostCode],[AreaID],[Address],[IsLock],[GroupID],[Question],[Answer],[LoginIP],[FrozenDeposit],[FrozenScore],[BirthDay],[QQ],[Telephone],[Phone],[TrueName],[Credit],[CommendUser]) SELECT [ID],[Name],[Password],[RegDate],[Score],[ScoreUsed],[Email],[Sex],[LoginDate],[LoginTimes],[IdentityCard],[PostCode],[AreaID],[Address],[IsLock],[GroupID],[Question],[Answer],[LoginIP],[FrozenDeposit],[FrozenScore],[BirthDay],[QQ],[Telephone],[Phone],[TrueName],[Credit],[CommendUser] FROM dbo.Web_User WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_User OFF
 
DROP TABLE dbo.Web_User
 
EXECUTE sp_rename N'dbo.Tmp_Web_User', N'Web_User', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Attachment]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Attachment] 
 
CREATE TABLE dbo.Web_Attachment([ID] [int]  NOT NULL,[Name] [nvarchar] (50)  NULL,[CategoryID] [int]  NOT NULL,[Src] [nvarchar] (250)  NULL,[Date] [datetime]  NOT NULL,[Description] [nvarchar] (250)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Attachment ADD CONSTRAINT DF_Web_Attachment_CategoryID DEFAULT ((0)) FOR [CategoryID]
 
ALTER TABLE dbo.Web_Attachment ADD CONSTRAINT DF_Web_Attachment_Date DEFAULT (getdate()) FOR [Date]
 
CREATE TABLE dbo.Tmp_Web_Attachment([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NULL,[CategoryID] [int]  NOT NULL,[Src] [nvarchar] (250)  NULL,[Date] [datetime]  NOT NULL,[Description] [nvarchar] (250)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_Attachment ADD CONSTRAINT DF_Tmp_Web_Attachment_CategoryID DEFAULT ((0)) FOR [CategoryID]
 
ALTER TABLE dbo.Tmp_Web_Attachment ADD CONSTRAINT DF_Tmp_Web_Attachment_Date DEFAULT (getdate()) FOR [Date]
 
SET IDENTITY_INSERT dbo.Tmp_Web_Attachment ON
 
IF EXISTS(SELECT * FROM dbo.Web_Attachment) EXEC('INSERT INTO dbo.Tmp_Web_Attachment ([ID],[Name],[CategoryID],[Src],[Date],[Description]) SELECT [ID],[Name],[CategoryID],[Src],[Date],[Description] FROM dbo.Web_Attachment WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Attachment OFF
 
DROP TABLE dbo.Web_Attachment
 
EXECUTE sp_rename N'dbo.Tmp_Web_Attachment', N'Web_Attachment', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_AdminRole]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_AdminRole] 
 
CREATE TABLE dbo.Web_AdminRole([RoleID] [int]  NOT NULL,[AdminID] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_AdminRole ADD CONSTRAINT DF_Web_AdminRole_RoleID DEFAULT ((0)) FOR [RoleID]
 
ALTER TABLE dbo.Web_AdminRole ADD CONSTRAINT DF_Web_AdminRole_AdminID DEFAULT ((0)) FOR [AdminID]
 
INSERT INTO Web_AdminRole VALUES ('1','1')
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Product]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Product] 
 
CREATE TABLE dbo.Web_Product([ID] [int]  NOT NULL,[Name] [nvarchar] (50)  NOT NULL,[ShortName] [nvarchar] (20)  NULL,[MarketPrice] [decimal]  (18,2) NOT NULL,[MemberPrice] [decimal]  (18,2) NOT NULL,[CostPrice] [decimal]  (18,2) NOT NULL,[ShortContent] [nvarchar] (200)  NULL,[Content] [ntext]  NULL,[OrderID] [int]  NOT NULL,[Weight] [decimal]  (18,2) NOT NULL,[IsOnSale] [int]  NOT NULL,[Number] [nvarchar] (100)  NULL,[Unit] [nvarchar] (10)  NULL,[BrandID] [int]  NOT NULL,[BrandName] [nvarchar] (50)  NULL,[SrcDetail] [nvarchar] (200)  NULL,[SrcList] [nvarchar] (200)  NULL,[SeoTitle] [nvarchar] (150)  NULL,[SeoKeywords] [nvarchar] (150)  NULL,[SeoDescription] [nvarchar] (300)  NULL,[ReviewCount] [int]  NOT NULL,[HitCount] [int]  NOT NULL,[CollectCount] [int]  NOT NULL,[BuyCount] [int]  NOT NULL,[StarCount] [int]  NOT NULL,[ModifyDate] [datetime]  NOT NULL,[SearchKey] [nvarchar] (255)  NULL,[GUID] [uniqueidentifier]  NOT NULL,[IsDel] [int]  NOT NULL,[IsVirtual] [int]  NOT NULL,[IsPresent] [int]  NOT NULL,[IsChangedBuy] [int]  NULL,[PresentPrice] [decimal]  (18,2) NOT NULL,[IsChanged] [int]  NOT NULL,[ChangeScore] [int]  NOT NULL,[IsAlert] [int]  NOT NULL,[AlertCount] [int]  NOT NULL,[Score] [int]  NOT NULL,[CategoryID] [int]  NOT NULL,[CategoryFamily] [nvarchar] (250)  NULL,[CategoryName] [nvarchar] (50)  NULL,[CategoryExtend] [nvarchar] (1000)  NULL,[Provider] [nvarchar] (50)  NULL,[Remark] [nvarchar] (250)  NULL,[ShopID] [int]  NULL,[Extend] [nvarchar] (250)  NULL,[NeedPrice] [decimal]  (18,2) NOT NULL,[IsNew] [int]  NOT NULL,[IsRecommond] [int]  NOT NULL,[IsSpecialOffer] [int]  NOT NULL,[IsHot] [int]  NOT NULL,[Storage] [int]  NOT NULL,[BuyNum] [int]  NOT NULL,[VideoUrl] [nvarchar] (150)  NULL,[VideoName] [nvarchar] (100)  NULL,[VideoWidth] [int]  NULL,[VideoHeight] [int]  NULL,[Date] [datetime]  NOT NULL,[IsAutoCount] [int]  NULL,[GoodReview] [int]  NOT NULL,[BadReview] [int]  NOT NULL,[GoodPercent] [int]  NOT NULL,[typeid] [int]  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_MarketPrice DEFAULT ((0)) FOR [MarketPrice]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_MemberPrice DEFAULT ((0)) FOR [MemberPrice]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_CostPrice DEFAULT ((0)) FOR [CostPrice]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_OrderID DEFAULT ((10000)) FOR [OrderID]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_Weight DEFAULT ((0)) FOR [Weight]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_IsOnSale DEFAULT ((0)) FOR [IsOnSale]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_BrandID DEFAULT ((0)) FOR [BrandID]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_ReviewCount DEFAULT ((0)) FOR [ReviewCount]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_HitCount DEFAULT ((0)) FOR [HitCount]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_CollectCount DEFAULT ((0)) FOR [CollectCount]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_BuyCount DEFAULT ((0)) FOR [BuyCount]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_StarCount DEFAULT ((0)) FOR [StarCount]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_ModifyDate DEFAULT (getdate()) FOR [ModifyDate]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_GUID DEFAULT (newid()) FOR [GUID]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_IsDel DEFAULT ((0)) FOR [IsDel]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_IsVirtual DEFAULT ((0)) FOR [IsVirtual]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_IsPresent DEFAULT ((0)) FOR [IsPresent]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_PresentPrice DEFAULT ((0)) FOR [PresentPrice]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_IsChanged DEFAULT ((0)) FOR [IsChanged]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_ChangeScore DEFAULT ((0)) FOR [ChangeScore]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_IsAlert DEFAULT ((0)) FOR [IsAlert]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_AlertCount DEFAULT ((0)) FOR [AlertCount]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_Score DEFAULT ((0)) FOR [Score]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_CategoryID DEFAULT ((0)) FOR [CategoryID]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_NeedPrice DEFAULT ((0)) FOR [NeedPrice]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_IsNew DEFAULT ((0)) FOR [IsNew]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_IsRecommond DEFAULT ((0)) FOR [IsRecommond]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_IsSpecialOffer DEFAULT ((0)) FOR [IsSpecialOffer]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_IsHot DEFAULT ((0)) FOR [IsHot]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_Storage DEFAULT ((0)) FOR [Storage]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_BuyNum DEFAULT ((1)) FOR [BuyNum]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_VideoWidth DEFAULT ((0)) FOR [VideoWidth]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_VideoHeight DEFAULT ((0)) FOR [VideoHeight]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_GoodReview DEFAULT ((0)) FOR [GoodReview]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_BadReview DEFAULT ((0)) FOR [BadReview]
 
ALTER TABLE dbo.Web_Product ADD CONSTRAINT DF_Web_Product_GoodPercent DEFAULT ((100)) FOR [GoodPercent]
 
CREATE TABLE dbo.Tmp_Web_Product([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NOT NULL,[ShortName] [nvarchar] (20)  NULL,[MarketPrice] [decimal]  (18,2) NOT NULL,[MemberPrice] [decimal]  (18,2) NOT NULL,[CostPrice] [decimal]  (18,2) NOT NULL,[ShortContent] [nvarchar] (200)  NULL,[Content] [ntext]  NULL,[OrderID] [int]  NOT NULL,[Weight] [decimal]  (18,2) NOT NULL,[IsOnSale] [int]  NOT NULL,[Number] [nvarchar] (100)  NULL,[Unit] [nvarchar] (10)  NULL,[BrandID] [int]  NOT NULL,[BrandName] [nvarchar] (50)  NULL,[SrcDetail] [nvarchar] (200)  NULL,[SrcList] [nvarchar] (200)  NULL,[SeoTitle] [nvarchar] (150)  NULL,[SeoKeywords] [nvarchar] (150)  NULL,[SeoDescription] [nvarchar] (300)  NULL,[ReviewCount] [int]  NOT NULL,[HitCount] [int]  NOT NULL,[CollectCount] [int]  NOT NULL,[BuyCount] [int]  NOT NULL,[StarCount] [int]  NOT NULL,[ModifyDate] [datetime]  NOT NULL,[SearchKey] [nvarchar] (255)  NULL,[GUID] [uniqueidentifier]  NOT NULL,[IsDel] [int]  NOT NULL,[IsVirtual] [int]  NOT NULL,[IsPresent] [int]  NOT NULL,[IsChangedBuy] [int]  NULL,[PresentPrice] [decimal]  (18,2) NOT NULL,[IsChanged] [int]  NOT NULL,[ChangeScore] [int]  NOT NULL,[IsAlert] [int]  NOT NULL,[AlertCount] [int]  NOT NULL,[Score] [int]  NOT NULL,[CategoryID] [int]  NOT NULL,[CategoryFamily] [nvarchar] (250)  NULL,[CategoryName] [nvarchar] (50)  NULL,[CategoryExtend] [nvarchar] (1000)  NULL,[Provider] [nvarchar] (50)  NULL,[Remark] [nvarchar] (250)  NULL,[ShopID] [int]  NULL,[Extend] [nvarchar] (250)  NULL,[NeedPrice] [decimal]  (18,2) NOT NULL,[IsNew] [int]  NOT NULL,[IsRecommond] [int]  NOT NULL,[IsSpecialOffer] [int]  NOT NULL,[IsHot] [int]  NOT NULL,[Storage] [int]  NOT NULL,[BuyNum] [int]  NOT NULL,[VideoUrl] [nvarchar] (150)  NULL,[VideoName] [nvarchar] (100)  NULL,[VideoWidth] [int]  NULL,[VideoHeight] [int]  NULL,[Date] [datetime]  NOT NULL,[IsAutoCount] [int]  NULL,[GoodReview] [int]  NOT NULL,[BadReview] [int]  NOT NULL,[GoodPercent] [int]  NOT NULL,[typeid] [int]  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_MarketPrice DEFAULT ((0)) FOR [MarketPrice]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_MemberPrice DEFAULT ((0)) FOR [MemberPrice]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_CostPrice DEFAULT ((0)) FOR [CostPrice]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_OrderID DEFAULT ((10000)) FOR [OrderID]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_Weight DEFAULT ((0)) FOR [Weight]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_IsOnSale DEFAULT ((0)) FOR [IsOnSale]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_BrandID DEFAULT ((0)) FOR [BrandID]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_ReviewCount DEFAULT ((0)) FOR [ReviewCount]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_HitCount DEFAULT ((0)) FOR [HitCount]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_CollectCount DEFAULT ((0)) FOR [CollectCount]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_BuyCount DEFAULT ((0)) FOR [BuyCount]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_StarCount DEFAULT ((0)) FOR [StarCount]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_ModifyDate DEFAULT (getdate()) FOR [ModifyDate]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_GUID DEFAULT (newid()) FOR [GUID]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_IsDel DEFAULT ((0)) FOR [IsDel]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_IsVirtual DEFAULT ((0)) FOR [IsVirtual]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_IsPresent DEFAULT ((0)) FOR [IsPresent]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_PresentPrice DEFAULT ((0)) FOR [PresentPrice]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_IsChanged DEFAULT ((0)) FOR [IsChanged]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_ChangeScore DEFAULT ((0)) FOR [ChangeScore]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_IsAlert DEFAULT ((0)) FOR [IsAlert]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_AlertCount DEFAULT ((0)) FOR [AlertCount]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_Score DEFAULT ((0)) FOR [Score]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_CategoryID DEFAULT ((0)) FOR [CategoryID]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_NeedPrice DEFAULT ((0)) FOR [NeedPrice]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_IsNew DEFAULT ((0)) FOR [IsNew]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_IsRecommond DEFAULT ((0)) FOR [IsRecommond]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_IsSpecialOffer DEFAULT ((0)) FOR [IsSpecialOffer]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_IsHot DEFAULT ((0)) FOR [IsHot]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_Storage DEFAULT ((0)) FOR [Storage]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_BuyNum DEFAULT ((1)) FOR [BuyNum]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_VideoWidth DEFAULT ((0)) FOR [VideoWidth]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_VideoHeight DEFAULT ((0)) FOR [VideoHeight]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_GoodReview DEFAULT ((0)) FOR [GoodReview]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_BadReview DEFAULT ((0)) FOR [BadReview]
 
ALTER TABLE dbo.Tmp_Web_Product ADD CONSTRAINT DF_Tmp_Web_Product_GoodPercent DEFAULT ((100)) FOR [GoodPercent]
 
SET IDENTITY_INSERT dbo.Tmp_Web_Product ON
 
IF EXISTS(SELECT * FROM dbo.Web_Product) EXEC('INSERT INTO dbo.Tmp_Web_Product ([ID],[Name],[ShortName],[MarketPrice],[MemberPrice],[CostPrice],[ShortContent],[Content],[OrderID],[Weight],[IsOnSale],[Number],[Unit],[BrandID],[BrandName],[SrcDetail],[SrcList],[SeoTitle],[SeoKeywords],[SeoDescription],[ReviewCount],[HitCount],[CollectCount],[BuyCount],[StarCount],[ModifyDate],[SearchKey],[GUID],[IsDel],[IsVirtual],[IsPresent],[IsChangedBuy],[PresentPrice],[IsChanged],[ChangeScore],[IsAlert],[AlertCount],[Score],[CategoryID],[CategoryFamily],[CategoryName],[CategoryExtend],[Provider],[Remark],[ShopID],[Extend],[NeedPrice],[IsNew],[IsRecommond],[IsSpecialOffer],[IsHot],[Storage],[BuyNum],[VideoUrl],[VideoName],[VideoWidth],[VideoHeight],[Date],[IsAutoCount],[GoodReview],[BadReview],[GoodPercent],[typeid]) SELECT [ID],[Name],[ShortName],[MarketPrice],[MemberPrice],[CostPrice],[ShortContent],[Content],[OrderID],[Weight],[IsOnSale],[Number],[Unit],[BrandID],[BrandName],[SrcDetail],[SrcList],[SeoTitle],[SeoKeywords],[SeoDescription],[ReviewCount],[HitCount],[CollectCount],[BuyCount],[StarCount],[ModifyDate],[SearchKey],[GUID],[IsDel],[IsVirtual],[IsPresent],[IsChangedBuy],[PresentPrice],[IsChanged],[ChangeScore],[IsAlert],[AlertCount],[Score],[CategoryID],[CategoryFamily],[CategoryName],[CategoryExtend],[Provider],[Remark],[ShopID],[Extend],[NeedPrice],[IsNew],[IsRecommond],[IsSpecialOffer],[IsHot],[Storage],[BuyNum],[VideoUrl],[VideoName],[VideoWidth],[VideoHeight],[Date],[IsAutoCount],[GoodReview],[BadReview],[GoodPercent],[typeid] FROM dbo.Web_Product WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Product OFF
 
DROP TABLE dbo.Web_Product
 
EXECUTE sp_rename N'dbo.Tmp_Web_Product', N'Web_Product', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_ProductPackage]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_ProductPackage] 
 
CREATE TABLE dbo.Web_ProductPackage([ID] [int]  NOT NULL,[Name] [nvarchar] (50)  NOT NULL,[Date] [datetime]  NOT NULL,[Price] [decimal]  (18,2) NOT NULL,[FreePrice] [decimal]  (18,2) NOT NULL,[OrderID] [int]  NOT NULL,[Description] [nvarchar] (250)  NOT NULL,[IsDel] [int]  NOT NULL,[SrcList] [nvarchar] (200)  NOT NULL,[SrcDetail] [nvarchar] (200)  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_ProductPackage ADD CONSTRAINT DF_Web_ProductPackage_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Web_ProductPackage ADD CONSTRAINT DF_Web_ProductPackage_Price DEFAULT ((0)) FOR [Price]
 
ALTER TABLE dbo.Web_ProductPackage ADD CONSTRAINT DF_Web_ProductPackage_FreePrice DEFAULT ((0)) FOR [FreePrice]
 
ALTER TABLE dbo.Web_ProductPackage ADD CONSTRAINT DF_Web_ProductPackage_OrderID DEFAULT ((0)) FOR [OrderID]
 
ALTER TABLE dbo.Web_ProductPackage ADD CONSTRAINT DF_Web_ProductPackage_Description DEFAULT ('') FOR [Description]
 
ALTER TABLE dbo.Web_ProductPackage ADD CONSTRAINT DF_Web_ProductPackage_IsDel DEFAULT ((0)) FOR [IsDel]
 
ALTER TABLE dbo.Web_ProductPackage ADD CONSTRAINT DF_Web_ProductPackage_SrcList DEFAULT ('') FOR [SrcList]
 
ALTER TABLE dbo.Web_ProductPackage ADD CONSTRAINT DF_Web_ProductPackage_SrcDetail DEFAULT ('') FOR [SrcDetail]
 
CREATE TABLE dbo.Tmp_Web_ProductPackage([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (50)  NOT NULL,[Date] [datetime]  NOT NULL,[Price] [decimal]  (18,2) NOT NULL,[FreePrice] [decimal]  (18,2) NOT NULL,[OrderID] [int]  NOT NULL,[Description] [nvarchar] (250)  NOT NULL,[IsDel] [int]  NOT NULL,[SrcList] [nvarchar] (200)  NOT NULL,[SrcDetail] [nvarchar] (200)  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_ProductPackage ADD CONSTRAINT DF_Tmp_Web_ProductPackage_Date DEFAULT (getdate()) FOR [Date]
 
ALTER TABLE dbo.Tmp_Web_ProductPackage ADD CONSTRAINT DF_Tmp_Web_ProductPackage_Price DEFAULT ((0)) FOR [Price]
 
ALTER TABLE dbo.Tmp_Web_ProductPackage ADD CONSTRAINT DF_Tmp_Web_ProductPackage_FreePrice DEFAULT ((0)) FOR [FreePrice]
 
ALTER TABLE dbo.Tmp_Web_ProductPackage ADD CONSTRAINT DF_Tmp_Web_ProductPackage_OrderID DEFAULT ((0)) FOR [OrderID]
 
ALTER TABLE dbo.Tmp_Web_ProductPackage ADD CONSTRAINT DF_Tmp_Web_ProductPackage_Description DEFAULT ('') FOR [Description]
 
ALTER TABLE dbo.Tmp_Web_ProductPackage ADD CONSTRAINT DF_Tmp_Web_ProductPackage_IsDel DEFAULT ((0)) FOR [IsDel]
 
ALTER TABLE dbo.Tmp_Web_ProductPackage ADD CONSTRAINT DF_Tmp_Web_ProductPackage_SrcList DEFAULT ('') FOR [SrcList]
 
ALTER TABLE dbo.Tmp_Web_ProductPackage ADD CONSTRAINT DF_Tmp_Web_ProductPackage_SrcDetail DEFAULT ('') FOR [SrcDetail]
 
SET IDENTITY_INSERT dbo.Tmp_Web_ProductPackage ON
 
IF EXISTS(SELECT * FROM dbo.Web_ProductPackage) EXEC('INSERT INTO dbo.Tmp_Web_ProductPackage ([ID],[Name],[Date],[Price],[FreePrice],[OrderID],[Description],[IsDel],[SrcList],[SrcDetail]) SELECT [ID],[Name],[Date],[Price],[FreePrice],[OrderID],[Description],[IsDel],[SrcList],[SrcDetail] FROM dbo.Web_ProductPackage WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_ProductPackage OFF
 
DROP TABLE dbo.Web_ProductPackage
 
EXECUTE sp_rename N'dbo.Tmp_Web_ProductPackage', N'Web_ProductPackage', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_CouponProduct]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_CouponProduct] 
 
CREATE TABLE dbo.Web_CouponProduct([ProductID] [int]  NOT NULL,[CouponID] [int]  NOT NULL)  ON [PRIMARY] 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_ProductArticle]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_ProductArticle] 
 
CREATE TABLE dbo.Web_ProductArticle([ProductID] [int]  NOT NULL,[ArticleID] [int]  NOT NULL,[OrderID] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_ProductArticle ADD CONSTRAINT DF_Web_ProductArticle_OrderID DEFAULT ((1000)) FOR [OrderID]
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Subscription]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Subscription] 
 
CREATE TABLE dbo.Web_Subscription([Id] [int]  NOT NULL,[Email] [nvarchar] (50)  NULL,[Date] [datetime]  NULL,[SubscriptionCategoryID] [int]  NOT NULL,[UserName] [nvarchar] (50)  NULL,[Status] [int]  NOT NULL)  ON [PRIMARY] 
 
CREATE TABLE dbo.Tmp_Web_Subscription([Id] [int]  NOT NULL IDENTITY (1, 1),[Email] [nvarchar] (50)  NULL,[Date] [datetime]  NULL,[SubscriptionCategoryID] [int]  NOT NULL,[UserName] [nvarchar] (50)  NULL,[Status] [int]  NOT NULL)  ON [PRIMARY] 
 
SET IDENTITY_INSERT dbo.Tmp_Web_Subscription ON
 
IF EXISTS(SELECT * FROM dbo.Web_Subscription) EXEC('INSERT INTO dbo.Tmp_Web_Subscription ([Id],[Email],[Date],[SubscriptionCategoryID],[UserName],[Status]) SELECT [Id],[Email],[Date],[SubscriptionCategoryID],[UserName],[Status] FROM dbo.Web_Subscription WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Subscription OFF
 
DROP TABLE dbo.Web_Subscription
 
EXECUTE sp_rename N'dbo.Tmp_Web_Subscription', N'Web_Subscription', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Rule]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Rule] 
 
CREATE TABLE dbo.Web_Rule([ID] [int]  NOT NULL,[Name] [nvarchar] (20)  NULL,[Value] [nvarchar] (50)  NULL,[CategoryId] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Rule ADD CONSTRAINT DF_Web_Rule_CategoryId DEFAULT ((0)) FOR [CategoryId]
 
CREATE TABLE dbo.Tmp_Web_Rule([ID] [int]  NOT NULL IDENTITY (1, 1),[Name] [nvarchar] (20)  NULL,[Value] [nvarchar] (50)  NULL,[CategoryId] [int]  NOT NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_Rule ADD CONSTRAINT DF_Tmp_Web_Rule_CategoryId DEFAULT ((0)) FOR [CategoryId]
 
SET IDENTITY_INSERT dbo.Tmp_Web_Rule ON
 
IF EXISTS(SELECT * FROM dbo.Web_Rule) EXEC('INSERT INTO dbo.Tmp_Web_Rule ([ID],[Name],[Value],[CategoryId]) SELECT [ID],[Name],[Value],[CategoryId] FROM dbo.Web_Rule WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Rule OFF
 
DROP TABLE dbo.Web_Rule
 
EXECUTE sp_rename N'dbo.Tmp_Web_Rule', N'Web_Rule', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_Translation]') AND OBJECTPROPERTY(id, N'IsUserTable') = 1) DROP TABLE [dbo].[Web_Translation] 
 
CREATE TABLE dbo.Web_Translation([ID] [int]  NOT NULL,[TableName] [nvarchar] (50)  NULL,[FieldName] [nvarchar] (50)  NULL,[TableID] [int]  NOT NULL,[Mark] [nvarchar] (50)  NULL,[Content] [nvarchar] (255)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Web_Translation ADD CONSTRAINT DF_Web_Translation_TableID DEFAULT ((0)) FOR [TableID]
 
CREATE TABLE dbo.Tmp_Web_Translation([ID] [int]  NOT NULL IDENTITY (1, 1),[TableName] [nvarchar] (50)  NULL,[FieldName] [nvarchar] (50)  NULL,[TableID] [int]  NOT NULL,[Mark] [nvarchar] (50)  NULL,[Content] [nvarchar] (255)  NULL)  ON [PRIMARY] 
 
ALTER TABLE dbo.Tmp_Web_Translation ADD CONSTRAINT DF_Tmp_Web_Translation_TableID DEFAULT ((0)) FOR [TableID]
 
SET IDENTITY_INSERT dbo.Tmp_Web_Translation ON
 
IF EXISTS(SELECT * FROM dbo.Web_Translation) EXEC('INSERT INTO dbo.Tmp_Web_Translation ([ID],[TableName],[FieldName],[TableID],[Mark],[Content]) SELECT [ID],[TableName],[FieldName],[TableID],[Mark],[Content] FROM dbo.Web_Translation WITH (HOLDLOCK TABLOCKX)')
 
SET IDENTITY_INSERT dbo.Tmp_Web_Translation OFF
 
DROP TABLE dbo.Web_Translation
 
EXECUTE sp_rename N'dbo.Tmp_Web_Translation', N'Web_Translation', 'OBJECT' 
 

 

 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_CouponView]')) DROP VIEW [dbo].[Web_CouponView]
 
CREATE VIEW [dbo].[Web_CouponView] AS SELECT     dbo.Web_UserCoupon.Id, dbo.Web_UserCoupon.CouponID, dbo.Web_UserCoupon.UserName, dbo.Web_UserCoupon.Number, dbo.Web_UserCoupon.IsUsed, dbo.Web_UserCoupon.OrderNumber, dbo.Web_UserCoupon.Date, dbo.Web_UserCoupon.IsActive, dbo.Web_UserCoupon.IsDistribution, dbo.Web_Coupon.Name, dbo.Web_Coupon.Src, dbo.Web_Coupon.NeedPrice, dbo.Web_Coupon.MinusPrice, dbo.Web_Coupon.StartDate, dbo.Web_Coupon.EndDate, dbo.Web_Coupon.Count, dbo.Web_Coupon.IsDel FROM dbo.Web_Coupon INNER JOIN dbo.Web_UserCoupon ON dbo.Web_Coupon.Id = dbo.Web_UserCoupon.CouponID 
 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_AdminPageRoleView]')) DROP VIEW [dbo].[Web_AdminPageRoleView]
 
CREATE VIEW [dbo].[Web_AdminPageRoleView] AS SELECT     A.ID, A.Name, A.DeptID, A.TrueName, C.ID AS RoleID, C.Name AS RoleName, E.ID AS PageID, E.Name AS PageName, E.FilePath, E.FirstID, E.SecondID, E.ThirdID, E.SubSystemID,E.OrderID, E.CategoryCode FROM         dbo.Web_AdminRole AS B INNER JOIN dbo.Web_Admin AS A ON B.AdminID = A.ID INNER JOIN dbo.Web_Role AS C INNER JOIN dbo.Web_PagePower AS D ON C.ID = D.RoleID INNER JOIN dbo.Web_Page AS E ON D.PageID = E.ID ON B.RoleID = C.ID 
 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[Web_PropertyView]')) DROP VIEW [dbo].[Web_PropertyView]
 
CREATE VIEW [dbo].[Web_PropertyView] AS SELECT     dbo.Web_PropertyValue.Value, dbo.Web_Property.Name,dbo.Web_ProductValue.ProductID, dbo.Web_Property.ID AS PID, dbo.Web_PropertyValue.ID AS ValueID FROM dbo.Web_Property INNER JOIN dbo.Web_PropertyValue ON dbo.Web_Property.ID = dbo.Web_PropertyValue.PropertyID INNER JOIN dbo.Web_ProductValue ON dbo.Web_PropertyValue.ID = dbo.Web_ProductValue.ValueID
 
IF EXISTS (SELECT * FROM sysobjects WHERE id = object_id(N'[dbo].[GetAreaById]')) DROP FUNCTION [dbo].[GetAreaById]
 
CREATE FUNCTION [dbo].[GetAreaById](@ID int)
RETURNS nvarchar(2000)
AS
BEGIN
	
		-- ========= 定义变量 =========
	DECLARE @AreaName nvarchar(2000)		-- 返回值
	DECLARE @tmp nvarchar(2000)			-- 临时变量
	DECLARE @HeadID int				    -- 父结点ID
	DECLARE @TmpID int                  -- 临时用ID
	
	-- ========= 初始化变量 =========
	SET @AreaName = ''
	SET @tmp = ''
	SET @TmpID = 0
	SET @HeadID = @ID

	-- ========= 主程序 =========
	WHILE @HeadID > 0
	BEGIN
		-- ========= 定义游标 =========
        DECLARE AreaTBL CURSOR
	    FOR SELECT Name, HeadID
	          FROM Web_Area
             WHERE ID = @HeadID

		-- ========= 打开游标 =========
		OPEN AreaTBL

		-- ========= 获取当前行的值 =========
		FETCH NEXT FROM AreaTBL INTO @tmp, @TmpID
		BEGIN
			-- ========= 对当前行的进行判空操作 =========
			IF @tmp IS NULL BEGIN
				SET @tmp = ''
			END
			
			IF @TmpID IS NULL BEGIN
				SET @TmpID = 0
			END

			-- ========= 生成地区信息 =========
			SET @HeadID = @TmpID
			SET @AreaName = @tmp + ' ' + @AreaName
		END

		-- ========= 关闭游标 =========
		CLOSE AreaTBL
		
		-- ========= 删除游标 =========
		DEALLOCATE AreaTBL
	END

	-- ========= 函数返回 =========
	RETURN @AreaName;
END

 

CREATE PROCEDURE [dbo].[dnt_checkemailandsecques]
@username nchar(20),
@email char(32),
@secques char(8)
AS
SELECT TOP 1 [uid] FROM [dnt_users] WHERE [username]=@username AND [email]=@email AND [secques]=@secques

 

CREATE PROCEDURE [dbo].[dnt_checkpasswordandsecques]
@username nchar(20),
@password char(32),
@secques char(8)
AS
SELECT TOP 1 [uid] FROM [dnt_users] WHERE [username]=@username AND [password]=@password AND [secques]=@secques

 

CREATE PROCEDURE [dbo].[dnt_checkpasswordbyuid]
@uid int,
@password char(32)
AS
SELECT TOP 1 [uid], [groupid], [adminid] FROM [dnt_users] WHERE [uid]=@uid AND [password]=@password

 

CREATE PROCEDURE [dbo].[dnt_checkpasswordbyusername]
@username nchar(20),
@password char(32)
AS
SELECT TOP 1 [uid], [groupid], [adminid] FROM [dnt_users] WHERE [username]=@username AND [password]=@password

 

CREATE PROCEDURE [dbo].[dnt_createadmingroup]
	@admingid smallint,
	@alloweditpost tinyint,
	@alloweditpoll tinyint,
	@allowstickthread tinyint,
	@allowmodpost tinyint,
	@allowdelpost tinyint,
	@allowmassprune tinyint,
	@allowrefund tinyint,
	@allowcensorword tinyint,
	@allowviewip tinyint,
	@allowbanip tinyint,
	@allowedituser tinyint,
	@allowmoduser tinyint,
	@allowbanuser tinyint,
	@allowpostannounce tinyint,
	@allowviewlog tinyint,
	@disablepostctrl tinyint,
	@allowviewrealname tinyint
AS
INSERT INTO dnt_admingroups 
	([admingid],[alloweditpost],[alloweditpoll],[allowstickthread],[allowmodpost],[allowdelpost],[allowmassprune],[allowrefund],[allowcensorword],[allowviewip],[allowbanip],[allowedituser],[allowmoduser],[allowbanuser],[allowpostannounce],[allowviewlog],[disablepostctrl],[allowviewrealname])
VALUES
	(@admingid,@alloweditpost,@alloweditpoll,@allowstickthread,@allowmodpost,@allowdelpost,@allowmassprune,@allowrefund,@allowcensorword,@allowviewip,@allowbanip,@allowedituser,@allowmoduser,@allowbanuser,@allowpostannounce,@allowviewlog,@disablepostctrl,@allowviewrealname)

 

CREATE PROCEDURE [dbo].[dnt_createattachment]
@uid int,
@tid int,
@pid int,
@postdatetime datetime,
@readperm int,
@filename nchar(200),
@description nchar(200),
@filetype nchar(100),
@filesize int,
@attachment nchar(200),
@downloads int,
@extname nvarchar(50),
@attachprice int AS
DECLARE @aid int INSERT INTO [dnt_attachments]([uid],[tid], [pid], [postdatetime], [readperm], [filename], [description], [filetype], [filesize],  [attachment], [downloads],[attachprice]) VALUES(@uid, @tid, @pid, @postdatetime, @readperm, @filename, @description, @filetype, @filesize,  @attachment, @downloads, @attachprice)
SELECT SCOPE_IDENTITY()  AS 'aid'set @aid=(SELECT SCOPE_IDENTITY()  AS 'aid')
UPDATE [dnt_posts1] SET [attachment]=1 WHERE [pid]=@pid
INSERT INTO [dnt_myattachments]([aid],[uid],[attachment],[description],[postdatetime],[downloads],[filename],[pid],[tid],[extname]) VALUES(@aid,@uid,@attachment,@description,@postdatetime,@downloads,@filename,@pid,@tid,@extname)

 

CREATE PROCEDURE [dbo].[dnt_createdebatepostexpand]
	@tid int,
	@pid int,
	@opinion int,
	@diggs int
AS
BEGIN
	INSERT INTO [dnt_postdebatefields] VALUES(@tid, @pid, @opinion, @diggs)
	IF @opinion = 1
		UPDATE [dnt_debates] SET [positivediggs] = [positivediggs] + 1 WHERE [tid] = @tid
	ELSE IF @opinion = 2
		UPDATE [dnt_debates] SET [negativediggs] = [negativediggs] + 1 WHERE [tid] = @tid
END

 

CREATE PROCEDURE [dbo].[dnt_createfavorite]
@uid int,
@tid int,
@type tinyint AS
	
	INSERT INTO [dnt_favorites] ([uid],[tid],[typeid]) VALUES(@uid,@tid,@type)
	RETURN

 

 CREATE PROCEDURE [dbo].[dnt_createnotice]
@uid int,
@type int,
@new  int,
@posterid int,
@poster nchar(20),
@note ntext,
@postdatetime datetime AS INSERT INTO [dnt_notices] ([uid], [type], [new], [posterid], [poster], [note], [postdatetime]) VALUES (@uid, @type, @new, @posterid, @poster, @note, @postdatetime);SELECT SCOPE_IDENTITY()  AS 'nid'

 

CREATE PROCEDURE [dbo].[dnt_createonlineuser] 
@onlinestate int,
@userid int,
@ip varchar(15),
@username nvarchar(40),
@nickname nvarchar(40),
@password char(32),
@groupid smallint,
@olimg varchar(80),
@adminid smallint,
@invisible smallint,
@action smallint,
@lastactivity smallint,
@lastposttime datetime,
@lastpostpmtime datetime,
@lastsearchtime datetime,
@lastupdatetime datetime,
@forumid int,
@forumname nvarchar(50),
@titleid int,
@title nvarchar(80),
@verifycode varchar(10),
@newpms smallint,
@newnotices smallint AS IF @onlinestate = 0
BEGIN
	UPDATE [dnt_users] SET [onlinestate]=1 WHERE [uid]=@userid
END
INSERT INTO [dnt_online] ([userid],[ip],[username],[nickname],[password],[groupid],[olimg],[adminid],[invisible],[action],[lastactivity],[lastposttime],[lastpostpmtime],[lastsearchtime],[lastupdatetime],[forumid],[forumname],[titleid],[title],[verifycode],[newpms],[newnotices])VALUES(@userid,@ip,@username,@nickname,@password,@groupid,@olimg,@adminid,@invisible,@action,@lastactivity,@lastposttime,@lastpostpmtime,@lastsearchtime,@lastupdatetime,@forumid,@forumname,@titleid,@title,@verifycode,@newpms,@newnotices);SELECT SCOPE_IDENTITY()

 

CREATE PROCEDURE [dbo].[dnt_createpm]
@pmid int,
@msgfrom nvarchar(20),
@msgto nvarchar(20),
@msgfromid int,
@msgtoid int,
@folder smallint=0,
@new int=0,
@subject nvarchar(60),
@postdatetime datetime,
@message ntext,
@savetosentbox smallint=1
AS IF @folder<>0
	BEGIN
		SET @msgfrom=@msgto
	END
ELSE
	BEGIN
		UPDATE [dnt_users] SET [newpmcount]=ABS(ISNULL([newpmcount],0)*1)+1,[newpm] = 1 WHERE [uid]=@msgtoid
	END	INSERT INTO [dnt_pms] 
	([msgfrom],[msgfromid],[msgto],[msgtoid],[folder],[new],[subject],[postdatetime],[message])
VALUES
	(@msgfrom,@msgfromid,@msgto,@msgtoid,@folder,@new,@subject,@postdatetime,@message)
	
SELECT SCOPE_IDENTITY() AS 'pmid'IF @savetosentbox=1 AND @folder=0
	BEGIN
		INSERT INTO [dnt_pms]
			([msgfrom],[msgfromid],[msgto],[msgtoid],[folder],[new],[subject],[postdatetime],[message])
		VALUES
			(@msgfrom,@msgfromid,@msgto,@msgtoid,1,@new,@subject,@postdatetime,@message)
	END

 

CREATE PROCEDURE [dbo].[dnt_createpost1]
@fid int,
@tid int,
@parentid int,
@layer int,
@poster varchar(20),
@posterid int,
@title nvarchar(60),
@topictitle nvarchar(60),
@postdatetime char(20),
@message ntext,
@ip varchar(15),
@lastedit varchar(50),
@invisible int,
@usesig int,
@htmlon int,
@smileyoff int,
@bbcodeoff int,
@parseurloff int,
@attachment int,
@rate int,
@ratetimes int AS
DEClARE @postid int DELETE FROM [dnt_postid] WHERE DATEDIFF(n, postdatetime, GETDATE()) >5INSERT INTO [dnt_postid] ([postdatetime]) VALUES(GETDATE())SELECT @postid=SCOPE_IDENTITY()INSERT INTO [dnt_posts1]([pid], [fid], [tid], [parentid], [layer], [poster], [posterid], [title], [postdatetime], [message], [ip], [lastedit], [invisible], [usesig], [htmlon], [smileyoff], [bbcodeoff], [parseurloff], [attachment], [rate], [ratetimes]) VALUES(@postid, @fid, @tid, @parentid, @layer, @poster, @posterid, @title, @postdatetime, @message, @ip, @lastedit, @invisible, @usesig, @htmlon, @smileyoff, @bbcodeoff, @parseurloff, @attachment, @rate, @ratetimes)IF @parentid=0
	BEGIN
		
		UPDATE [dnt_posts1] SET [parentid]=@postid WHERE [pid]=@postid
	END IF @@ERROR=0
	BEGIN
		IF  @invisible = 0
		BEGIN
		
			UPDATE [dnt_statistics] SET [totalpost]=[totalpost] + 1
		
		
		
			DECLARE @fidlist AS VARCHAR(1000)
			DECLARE @strsql AS VARCHAR(4000)
			
			SET @fidlist = '';
			
			SELECT @fidlist = ISNULL([parentidlist],'') FROM [dnt_forums] WHERE [fid] = @fid
			IF RTRIM(@fidlist)<>''
				BEGIN
					SET @fidlist = RTRIM(@fidlist) + ',' + CAST(@fid AS VARCHAR(10))
				END
			ELSE
				BEGIN
					SET @fidlist = CAST(@fid AS VARCHAR(10))
				END
        
			
			UPDATE [dnt_forums] SET 
									[posts]=[posts] + 1, 
									[todayposts]=CASE 
													WHEN DATEDIFF(day, [lastpost], GETDATE())=0 THEN [todayposts]*1 + 1 
												 ELSE 1 
												 END,
									[lasttid]=@tid,	
									[lasttitle]=@topictitle,
									[lastpost]=@postdatetime,
									[lastposter]=@poster,
									[lastposterid]=@posterid 
							
							WHERE (CHARINDEX(',' + RTRIM([fid]) + ',', ',' + (SELECT @fidlist AS [fid]) + ',') > 0)
			
			
			UPDATE [dnt_users] SET
				[lastpost] = @postdatetime,
				[lastpostid] = @postid,
				[lastposttitle] = @title,
				[posts] = [posts] + 1,
				[lastactivity] = GETDATE()
			WHERE [uid] = @posterid
        
        
			IF @layer<=0
				BEGIN
					UPDATE [dnt_topics] SET [replies]=0,[lastposter]=@poster,[lastpost]=@postdatetime,[lastposterid]=@posterid WHERE [tid]=@tid
				END
			ELSE
				BEGIN
					UPDATE [dnt_topics] SET [replies]=[replies] + 1,[lastposter]=@poster,[lastpost]=@postdatetime,[lastposterid]=@posterid WHERE [tid]=@tid
				END
		END		UPDATE [dnt_topics] SET [lastpostid]=@postid WHERE [tid]=@tid		IF @posterid <> -1
		BEGIN
			INSERT [dnt_myposts]([uid], [tid], [pid], [dateline]) VALUES(@posterid, @tid, @postid, @postdatetime)
		END
	END
	
SELECT @postid AS postid

 

CREATE PROCEDURE [dbo].[dnt_createsearchcache]
	@keywords varchar(255),
	@searchstring varchar(255),
	@ip varchar(15),
	@uid int,
	@groupid int,
	@postdatetime varchar(19),
	@expiration varchar(19),
	@topics int,
	@tids text
AS
INSERT INTO dnt_searchcaches 
	([keywords],[searchstring],[ip],[uid],[groupid],[postdatetime],[expiration],[topics],[tids])
VALUES
	(@keywords,@searchstring,@ip,@uid,@groupid,@postdatetime,@expiration,@topics,@tids)
SELECT SCOPE_IDENTITY()  AS 'searchid'

 

CREATE PROCEDURE [dbo].[dnt_createtags]
@tags nvarchar(55),
@userid int,
@postdatetime datetime
AS
BEGIN	
	INSERT INTO [dnt_tags]([tagname], [userid], [postdatetime], [orderid], [color], [count], [fcount], [pcount], [scount], [vcount]) 
		SELECT [item], @userid, @postdatetime, 0, '', 0, 0, 0, 0, 0 FROM [dnt_split](@tags, ' ') AS [newtags] 
		WHERE NOT EXISTS (SELECT [tagname] FROM [dnt_tags] WHERE [newtags].[item] = [tagname])
END

 

CREATE PROCEDURE [dbo].[dnt_createtopic]
@fid smallint,
@iconid smallint,
@title nchar(80),
@typeid smallint,
@readperm int,
@price smallint,
@poster char(20),
@posterid int,
@postdatetime smalldatetime,
@lastpost smalldatetime,
@lastpostid int,
@lastposter char(20),
@views int,
@replies int,
@displayorder int,
@highlight varchar(500),
@digest int,
@rate int,
@hide int,
@attachment int,
@moderated int,
@closed int,
@magic int,
@special tinyint,
@attention int
AS DECLARE @topicid int DELETE FROM [dnt_topics] WHERE [tid]>(SELECT ISNULL(max(tid),0)-100 FROM [dnt_topics]) AND [lastpostid]=0 INSERT INTO [dnt_topics]([fid], [iconid], [title], [typeid], [readperm], [price], [poster], [posterid], [postdatetime], [lastpost], [lastpostid], [lastposter], [views], [replies], [displayorder], [highlight], [digest], [rate], [hide], [attachment], [moderated], [closed], [magic], [special],[attention]) VALUES(@fid, @iconid, @title, @typeid, @readperm, @price, @poster, @posterid, @postdatetime, @lastpost, @lastpostid, @lastposter, @views, @replies, @displayorder, @highlight, @digest, @rate, @hide, @attachment, @moderated, @closed, @magic, @special,@attention)SET @topicid=SCOPE_IDENTITY()IF @@ERROR=0 AND @displayorder=0
	BEGIN
		UPDATE [dnt_statistics] SET [totaltopic]=[totaltopic] + 1
		UPDATE [dnt_forums] SET [topics] = [topics] + 1,[curtopics] = [curtopics] + 1 WHERE [fid] = @fid
		
		IF @posterid <> -1
		BEGIN
			INSERT INTO [dnt_mytopics]([tid],[uid],[dateline]) VALUES(@topicid,  @posterid,  @postdatetime)
		END
		
	END
	
SELECT @topicid as topicid

 

CREATE PROCEDURE [dbo].[dnt_createtopictags]
@tags nvarchar(55),
@tid int,
@userid int,
@postdatetime datetime
AS
BEGIN
	exec [dnt_createtags] @tags, @userid, @postdatetime	UPDATE [dnt_tags] SET [fcount]=[fcount]+1,[count]=[count]+1
	WHERE EXISTS (SELECT [item] FROM [dnt_split](@tags, ' ') AS [newtags] WHERE [newtags].[item] = [tagname])	INSERT INTO [dnt_topictags] (tagid, tid)
	SELECT tagid, @tid FROM [dnt_tags] WHERE EXISTS (SELECT * FROM [dnt_split](@tags, ' ') WHERE [item] = [dnt_tags].[tagname])
END

 

CREATE PROCEDURE [dbo].[dnt_createuser]
@username nchar(20),
@nickname nchar(20),
@password char(32),
@secques char(8),
@gender int,
@adminid int,
@groupid smallint,
@groupexpiry int,
@extgroupids char(60),
@regip char(15),
@joindate char(19),
@lastip char(15),
@lastvisit char(19),
@lastactivity char(19),
@lastpost char(19),
@lastpostid int,
@lastposttitle nchar(60),
@posts int,
@digestposts smallint,
@oltime int,
@pageviews int,
@credits int,
@extcredits1 float,
@extcredits2 float,
@extcredits3 float,
@extcredits4 float,
@extcredits5 float,
@extcredits6 float,
@extcredits7 float,
@extcredits8 float,
@avatarshowid int,
@email char(50),
@bday char(19),
@sigstatus int,
@tpp int,
@ppp int,
@templateid smallint,
@pmsound int,
@showemail int,
@newsletter int,
@invisible int,
@newpm int,
@accessmasks int,
@website varchar(80),
@icq varchar(12),
@qq varchar(12),
@yahoo varchar(40),
@msn varchar(40),
@skype varchar(40),
@location nvarchar(30),
@customstatus varchar(30),
@avatar varchar(255),
@avatarwidth int,
@avatarheight int,
@medals varchar(300),
@bio nvarchar(500),
@signature nvarchar(500),
@sightml nvarchar(1000),
@authstr varchar(20),
@realname nvarchar(10),
@idcard varchar(20),
@mobile varchar(20),
@phone varchar(20)
AS
DECLARE @uid int INSERT INTO [dnt_users]([username],[nickname], [password], [secques], [gender], [adminid], [groupid], [groupexpiry], [extgroupids], [regip], [joindate], [lastip], [lastvisit], [lastactivity], [lastpost], [lastpostid], [lastposttitle], [posts], [digestposts], [oltime], [pageviews], [credits], [extcredits1], [extcredits2], [extcredits3], [extcredits4], [extcredits5], [extcredits6], [extcredits7], [extcredits8], [avatarshowid], [email], [bday], [sigstatus], [tpp], [ppp], [templateid], [pmsound], [showemail], [newsletter], [invisible], [newpm], [accessmasks]) VALUES(@username,@nickname, @password, @secques, @gender, @adminid, @groupid, @groupexpiry, @extgroupids, @regip, @joindate, @lastip, @lastvisit, @lastactivity, @lastpost, @lastpostid, @lastposttitle, @posts, @digestposts, @oltime, @pageviews, @credits, @extcredits1, @extcredits2, @extcredits3, @extcredits4, @extcredits5, @extcredits6, @extcredits7, @extcredits8, @avatarshowid, @email, @bday, @sigstatus, @tpp, @ppp, @templateid, @pmsound, @showemail, @newsletter, @invisible, @newpm, @accessmasks)
SELECT SCOPE_IDENTITY()  AS 'userid'
SET @uid = SCOPE_IDENTITY()IF @@ERROR=0
	BEGIN
		UPDATE [dnt_statistics] SET [totalusers]=[totalusers] + 1,[lastusername]=@username,[lastuserid]=@uid
	END INSERT INTO dnt_userfields 
	([uid],[website],[icq],[qq],[yahoo],[msn],[skype],[location],[customstatus],[avatar],[avatarwidth],[avatarheight],[medals],[bio],[signature],[sightml],[authstr],[realname],[idcard],[mobile],[phone])
VALUES
	(@uid,@website,@icq,@qq,@yahoo,@msn,@skype,@location,@customstatus,@avatar,@avatarwidth,@avatarheight,@medals,@bio,@signature,@sightml,@authstr,@realname,@idcard,@mobile,@phone)

 

CREATE PROCEDURE [dbo].[dnt_deleteonlineusers] 
@olidlist varchar(5000) = ''
AS EXEC('DELETE FROM [dnt_online] WHERE [olid] IN (' + @olidlist + ')');

 

CREATE PROCEDURE [dbo].[dnt_deletepost1bypid]
                        @pid int,
			@chanageposts AS BIT
                    AS                        DECLARE @fid int
                        DECLARE @tid int
                        DECLARE @posterid int
                        DECLARE @lastforumposterid int
                        DECLARE @layer int
                        DECLARE @postdatetime smalldatetime
                        DECLARE @poster varchar(50)
                        DECLARE @postcount int
                        DECLARE @title nchar(60)
                        DECLARE @lasttid int
                        DECLARE @postid int
                        DECLARE @todaycount int
                    	
                    	
                        SELECT @fid = [fid],@tid = [tid],@posterid = [posterid],@layer = [layer], @postdatetime = [postdatetime] FROM [dnt_posts1] WHERE pid = @pid                        DECLARE @fidlist AS VARCHAR(1000)
                    	
                        SET @fidlist = '';
                    	
                        SELECT @fidlist = ISNULL([parentidlist],'') FROM [dnt_forums] WHERE [fid] = @fid
                        IF RTRIM(@fidlist)<>''
                            BEGIN
                                SET @fidlist = RTRIM(@fidlist) + ',' + CAST(@fid AS VARCHAR(10))
                            END
                        ELSE
                            BEGIN
                                SET @fidlist = CAST(@fid AS VARCHAR(10))
                            END
                        IF @layer<>0                            BEGIN
                    			
								IF @chanageposts = 1
									BEGIN
										UPDATE [dnt_statistics] SET [totalpost]=[totalpost] - 1										UPDATE [dnt_forums] SET 
											[posts]=[posts] - 1, 											[todayposts]=CASE 
																WHEN DATEPART(yyyy, @postdatetime)=DATEPART(yyyy,GETDATE()) AND DATEPART(mm, @postdatetime)=DATEPART(mm,GETDATE()) AND DATEPART(dd, @postdatetime)=DATEPART(dd,GETDATE()) THEN [todayposts] - 1
																ELSE [todayposts]
														END						
										WHERE (CHARINDEX(',' + RTRIM([fid]) + ',', ',' +
															(SELECT @fidlist AS [fid]) + ',') > 0)
                    			
										UPDATE [dnt_users] SET [posts] = [posts] - 1 WHERE [uid] = @posterid										UPDATE [dnt_topics] SET [replies]=[replies] - 1 WHERE [tid]=@tid
									END
                    			
                                DELETE FROM [dnt_posts1] WHERE [pid]=@pid
                    			
                            END
                        ELSE
                            BEGIN
                    		
                                SELECT @postcount = COUNT([pid]) FROM [dnt_posts1] WHERE [tid] = @tid
                                SELECT @todaycount = COUNT([pid]) FROM [dnt_posts1] WHERE [tid] = @tid AND DATEDIFF(d, [postdatetime], GETDATE()) = 0
                    			
								IF @chanageposts = 1
									BEGIN
										UPDATE [dnt_statistics] SET [totaltopic]=[totaltopic] - 1, [totalpost]=[totalpost] - @postcount
		                    			
										UPDATE [dnt_forums] SET [posts]=[posts] - @postcount, [topics]=[topics] - 1,[todayposts]=[todayposts] - @todaycount WHERE (CHARINDEX(',' + RTRIM([fid]) + ',', ',' +(SELECT @fidlist AS [fid]) + ',') > 0)
		                    			
										UPDATE [dnt_users] SET [posts] = [posts] - @postcount WHERE [uid] = @posterid
                    			
									END                                DELETE FROM [dnt_posts1] WHERE [tid] = @tid
                    			
                                DELETE FROM [dnt_topics] WHERE [tid] = @tid
                    			
                            END	
                    		                        IF @layer<>0
                            BEGIN
                                SELECT TOP 1 @pid = [pid], @posterid = [posterid], @postdatetime = [postdatetime], @title = [title], @poster = [poster] FROM [dnt_posts1] WHERE [tid]=@tid ORDER BY [pid] DESC
                                UPDATE [dnt_topics] SET [lastposter]=@poster,[lastpost]=@postdatetime,[lastpostid]=@pid,[lastposterid]=@posterid WHERE [tid]=@tid
                            END                        SELECT @lasttid = [lasttid] FROM [dnt_forums] WHERE [fid] = @fid                    	
                        IF @lasttid = @tid
                            BEGIN                    			
                    			                                SELECT TOP 1 @pid = [pid], @tid = [tid],@lastforumposterid = [posterid], @title = [title], @postdatetime = [postdatetime], @poster = [poster] FROM [dnt_posts1] WHERE [fid] = @fid ORDER BY [pid] DESC
                    			
                            
                            
                                UPDATE [dnt_forums] SET 
                    			
	                                [lastpost]=@postdatetime,
	                                [lastposter]=ISNULL(@poster,''),
	                                [lastposterid]=ISNULL(@lastforumposterid,'0')                                WHERE (CHARINDEX(',' + RTRIM([fid]) + ',', ',' +
					                                (SELECT @fidlist AS [fid]) + ',') > 0)
                    			
                                SELECT TOP 1 @pid = [pid], @tid = [tid],@posterid = [posterid], @postdatetime = [postdatetime], @title = [title], @poster = [poster] FROM [dnt_posts1] WHERE [posterid]=@posterid ORDER BY [pid] DESC
                    			
                                UPDATE [dnt_users] SET
                    			
	                                [lastpost] = @postdatetime,
	                                [lastpostid] = @pid,
	                                [lastposttitle] = ISNULL(@title,'')
                    				
                                WHERE [uid] = @posterid
                    			
                            END

 

CREATE PROCEDURE [dbo].[dnt_deleteps]
	@index int,
	@pmidlist varchar(1000)='',
	@userid int=0
 AS	DECLARE @strSQL varchar(5000)	IF @index=0
		BEGIN
			GOTO UserDeletePM
		END 
UserDeletePM:	SET @strSQL='DELETE FROM [dnt_pms] WHERE [pmid] IN (' + @pmidlist + ') AND [userid]=' + STR(@userid)

 

CREATE PROCEDURE [dbo].[dnt_deletetopicbytidlist]	@tidlist AS VARCHAR(2000),
	@posttablename AS VARCHAR(20),
	@chanageposts AS BIT AS	DECLARE @postcount int
	DECLARE @topiccount int
	DECLARE @todaycount int
	DECLARE @sqlstr nvarchar(4000)
	DECLARE @fid varchar(2000)
	DECLARE @posterid varchar(200)
	DECLARE @tempFid int
	DECLARE @tempPosterid int
	DECLARE @tempLayer int
	DECLARE @temppostdatetime datetime	DECLARE @tempfidlist AS VARCHAR(1000)		SET @fid = ''
	SET @posterid = ''
	SET @postcount=0
	SET @topiccount=0
	SET @todaycount=0
	
	SET @tempfidlist = '';
	IF @tidlist<>''
		BEGIN
			SET @sqlstr = 'DECLARE cu_dnt_posts CURSOR FOR SELECT [fid],[posterid],[layer],[postdatetime] FROM [' + @posttablename + '] WHERE [tid] IN (' + @tidlist + ')'
			EXEC (@sqlstr)
			OPEN cu_dnt_posts
			FETCH NEXT FROM cu_dnt_posts into @tempFid,@tempPosterid,@tempLayer,@temppostdatetime
			WHILE @@FETCH_STATUS = 0
				BEGIN
					SET @postcount = @postcount + 1
					IF @tempLayer = 0
						BEGIN
							SET @topiccount = @topiccount + 1
							
						END					IF DATEDIFF(d,@temppostdatetime,GETDATE()) = 0
						BEGIN
							SET @todaycount = @todaycount + 1
						END
					IF CHARINDEX(',' + LTRIM(STR(@tempFid)) + ',',@fid + ',') = 0
						BEGIN
							--SET @fid = @fid + ',' + LTRIM(STR(@tempFid))	
							SELECT @tempfidlist = ISNULL([parentidlist],'') FROM [dnt_forums] WHERE [fid] = @tempFid
							IF RTRIM(@tempfidlist)<>''
								BEGIN
									SET @fid = RTRIM(@fid) + ',' +  RTRIM(@tempfidlist) + ',' + CAST(@tempFid AS VARCHAR(10))
								END
							ELSE
								BEGIN
									SET @fid =RTRIM(@fid) + ',' +  CAST(@tempFid AS VARCHAR(10))
								END					
						END
					IF @chanageposts = 1
						BEGIN
							UPDATE [dnt_users] SET [posts] = [posts] - 1 WHERE [uid] = @tempPosterid
						END
				
					FETCH NEXT FROM cu_dnt_posts into @tempFid,@tempPosterid,@tempLayer,@temppostdatetime
				END			CLOSE cu_dnt_posts
			DEALLOCATE cu_dnt_posts	
			IF LEN(@fid)>0
				BEGIN				
					SET @fid = SUBSTRING(@fid,2,LEN(@fid)-1)
		
					IF @chanageposts = 1
						BEGIN
		
							UPDATE [dnt_statistics] SET [totaltopic]=[totaltopic] - @topiccount, [totalpost]=[totalpost] - @postcount							SET @sqlstr = 'UPDATE [dnt_forums] SET [posts]=[posts] - ' +  cast(@postcount AS VARCHAR(10))  + 
											', [topics]=[topics] - ' + cast(@topiccount AS VARCHAR(10)) + 
											', [todayposts] = [todayposts] - ' + cast(@todaycount AS VARCHAR(10)) + 
									' WHERE [fid] IN (' + @fid + ')'
							EXEC (@sqlstr)
						END
		
					SET @sqlstr = 'DELETE FROM [dnt_favorites] WHERE [tid] IN (' + @tidlist + ') AND [typeid]=0'
					EXEC (@sqlstr)
					
					SET @sqlstr = 'DELETE FROM [dnt_polls] WHERE [tid] IN (' + @tidlist + ')'
					EXEC (@sqlstr)					SET @sqlstr = 'DELETE FROM [' + @posttablename + '] WHERE [tid] IN (' + @tidlist + ')'
					EXEC (@sqlstr)					SET @sqlstr = 'DELETE FROM [dnt_mytopics] WHERE [tid] IN (' + @tidlist + ')'
					EXEC(@sqlstr)
				
				END
			SET @sqlstr = 'DELETE FROM [dnt_topics] WHERE [closed] IN (' + @tidlist + ') OR [tid] IN (' + @tidlist + ')'
			EXEC (@sqlstr)
			SET @sqlstr = 'UPDATE [dnt_tags] SET [count]=[count]-1, [fcount]=[fcount]-1 WHERE [tagid] IN (SELECT [tagid] FROM [dnt_topictags] WHERE [tid] IN (' + @tidlist + '))'
			EXEC (@sqlstr)
			SET @sqlstr = 'DELETE FROM [dnt_topictags] WHERE [tid] IN (' + @tidlist + ')'
			EXEC (@sqlstr)
			SET @sqlstr = 'DELETE FROM [dnt_topictagcaches] WHERE [tid] IN (' + @tidlist + ') OR [linktid] IN (' + @tidlist + ')'
		END
		

 

CREATE PROCEDURE [dbo].[dnt_deletetopictags]
	@tid int
 AS
BEGIN       
	UPDATE [dnt_tags] SET [count]=[count]-1,[fcount]=[fcount]-1 
	WHERE EXISTS (SELECT [tagid] FROM [dnt_topictags] WHERE [tid] = @tid AND [tagid] = [dnt_tags].[tagid])    DELETE FROM [dnt_topictags] WHERE [tid] = @tid	
END

 

CREATE PROCEDURE [dbo].[dnt_getadmintopiclist]
@pagesize int,
@pageindex int,
@startnum int,
@condition varchar(80)
AS
DECLARE @strSQL varchar(5000)IF @pageindex = 1
	BEGIN
		SET @strSQL = 'SELECT TOP ' + STR(@pagesize) +' [tid],[iconid],[title],[poster],[posterid],[replies],[views],[postdatetime],[lastpost],[lastposter],[price],[lastpostid],[lastposterid],[replies],[highlight],[digest],[displayorder],[closed],[magic] FROM [dnt_topics] WHERE  '+ @condition + ' ORDER BY [lastpostid] DESC'
	END
ELSE
	BEGIN
		SET @strSQL = 'SELECT TOP ' + STR(@pagesize) +' [tid],[iconid],[title],[special],[poster],[posterid],[replies],[views],[postdatetime],[lastpost],[lastposter],[price],[lastpostid],[lastposterid],[replies],[highlight],[digest],[displayorder],[closed],[magic] FROM [dnt_topics] WHERE [lastpostid] < (SELECT min([lastpostid])  FROM (SELECT TOP ' + STR((@pageindex-1)*@pagesize-@startnum) + ' [lastpostid] FROM [dnt_topics] WHERE [displayorder]=0' + @condition + ' ORDER BY [lastpostid] DESC) AS tblTmp ) AND  ' + @condition + ' ORDER BY [lastpostid] DESC'
	END
EXEC(@strSQL)

 

CREATE PROCEDURE [dbo].[dnt_getalltopiccount]
@fid int
AS SELECT COUNT(tid) FROM [dnt_topics] WHERE ([fid]=@fid   OR   [fid]  IN (  SELECT fid  FROM [dnt_forums]  WHERE  CHARINDEX(',' + RTRIM(@fid) + ',', ',' + RTRIM(parentidlist) + ',') > 0))  AND [displayorder]>=0

 

CREATE PROCEDURE [dbo].[dnt_getattentiontopics] @fid varchar(255)='',
@tpp int,
@pageid int,
@condition nvarchar(255)=''
AS DECLARE @pagetop int,@strSQL varchar(5000)SET @pagetop = (@pageid-1)*@tpp
IF @pageid = 1
	BEGIN
		SET @strSQL = 'SELECT TOP  ' +STR( @tpp) + '  * FROM [dnt_topics] WHERE [displayorder]>=0  AND [attention]=1'
                     	
		IF @fid<>'0'
                            SELECT  @strSQL=@strSQL+'  AND [fid] IN ('+@fid+')'
                            IF @condition<>''
                            SELECT  @strSQL=@strSQL+@condition                           SELECT @strSQL=@strSQL+'  ORDER BY [lastpost] DESC'
                                  
	END
ELSE
	BEGIN
		SET @strSQL = 'SELECT TOP  ' +STR( @tpp) + '  * FROM [dnt_topics]  WHERE [tid] < (SELECT MIN([tid])  FROM (SELECT TOP '+STR(@pagetop)+' [tid] FROM [dnt_topics]   WHERE [displayorder]>=0  AND [attention]=1'
				 IF @fid<>'0'
 
                            SELECT  @strSQL=@strSQL+'  AND [fid] IN ('+@fid+')'
                          
                            IF @condition<>''
                            SELECT  @strSQL=@strSQL+@condition
                                               SELECT @strSQL=@strSQL+'   ORDER BY [tid] DESC'
                          SELECT @strSQL=@strSQL+'  )  AS T) '		 IF @fid<>'0'
 
                           SELECT  @strSQL=@strSQL+'  AND [fid] IN ('+@fid+')'			    IF @condition<>''
                            SELECT  @strSQL=@strSQL+@condition
                           SELECT @strSQL=@strSQL+'  AND [displayorder]>=0  AND [attention]=1 ORDER BY [tid] DESC'                                 
	END
EXEC(@strSQL)

 

CREATE PROCEDURE [dbo].[dnt_getdebatepostlist] 
	@tid int,
	@opinion int,
	@pagesize int,
	@pageindex int,
	@posttablename varchar(20),
	@orderby varchar(20),
	@ascdesc varchar(5)
AS
BEGIN
	DECLARE @pagetop int
	SET @pagetop = (@pageindex-1)*@pagesize	IF @pageindex = 1 
		EXEC('SELECT * FROM ' + @posttablename + ' 
				LEFT JOIN dnt_users ON dnt_users.uid = ' + @posttablename + '.posterid 
				LEFT JOIN [dnt_userfields] ON [dnt_userfields].[uid]=[dnt_users].[uid] 
				WHERE ' + @posttablename + '.invisible=0 AND ' + @posttablename + '.pid IN 
					(SELECT TOP ' + @pagesize + ' pid FROM dnt_postdebatefields 
					 WHERE opinion=' + @opinion + ' AND 
							tid=' + @tid+')')
	ELSE
		EXEC('SELECT * FROM ' + @posttablename + ' 
				LEFT JOIN dnt_users ON dnt_users.uid = ' + @posttablename + '.posterid 
				LEFT JOIN [dnt_userfields] ON [dnt_userfields].[uid]=[dnt_users].[uid] 
				WHERE ' + @posttablename + '.invisible=0 AND ' + @posttablename + '.pid IN 
					(SELECT TOP ' + @pagesize + ' pid FROM dnt_postdebatefields 
					 WHERE opinion=' + @opinion + ' AND 
							tid=' + @tid+' AND pid > (SELECT MAX(pid) FROM (
								SELECT TOP ' + @pagetop + ' pid FROM dnt_postdebatefields 
								WHERE opinion=' + @opinion + ' AND 
										tid=' + @tid+' ORDER BY pid) AS tblTmp) ORDER BY pid)')
	
END

 

CREATE PROCEDURE [dbo].[dnt_getexpiredonlineuserlist]
@expires datetime
AS SELECT [olid], [userid] FROM [dnt_online] WHERE [lastupdatetime]<@expires


 

CREATE PROCEDURE [dbo].[dnt_getfavoritescount]
@uid int
AS
SELECT COUNT(uid) as c FROM [dnt_favorites] WHERE [uid]=@uid

 

CREATE PROCEDURE [dbo].[dnt_getfavoritescountbytype]
@uid int,
@typeid tinyint
AS
SELECT COUNT(uid) as c FROM [dnt_favorites] WHERE [uid]=@uid AND [typeid]=@typeid

 

CREATE PROCEDURE [dbo].[dnt_getfavoriteslist]
@uid int,
@pagesize int,
@pageindex int
AS
DECLARE @strSQL varchar(5000)
SET @strSQL='SELECT [f].[uid],[f].[tid],[topics].[title],[topics].[poster],[topics].[postdatetime],[topics].[replies],[topics].[views],[topics].[posterid] FROM [dnt_favorites] [f],[dnt_topics] [topics] WHERE [f].[tid]=[topics].[tid] AND [f].[typeid]=0 AND [f].[uid]=' + STR(@uid)IF @pageindex = 1
	BEGIN
		SET @strSQL = 'SELECT TOP ' + STR(@pagesize) +'  [uid],[tid],[title],[poster],[postdatetime],[replies],[views],[posterid]  FROM (' + @strSQL + ') f' + '  ORDER BY [tid] DESC'
	END
ELSE
	BEGIN
		SET @strSQL = 'SELECT TOP ' + STR(@pagesize) +'  [uid],[tid],[title],[poster],[postdatetime],[replies],[views],[posterid]  FROM (' + @strSQL + ') f1 WHERE [tid] < (SELECT MIN([tid]) FROM (SELECT TOP ' + STR((@pageindex-1)*@pagesize) + ' [tid] FROM (' + @strSQL + ') f2' + '  ORDER BY [tid] DESC) AS tblTmp)' + '  ORDER BY [tid] DESC'
	END EXEC(@strSQL)

 

CREATE PROCEDURE [dbo].[dnt_getfavoriteslistbyalbum]
@uid int,
@pagesize int,
@pageindex int
AS
DECLARE @strSQL varchar(5000)
SET @strSQL='SELECT [f].[tid], [f].[uid], [albumid], [albumcateid], [userid] AS [posterid], [username] AS [poster], [title], [description], [logo], [password], [imgcount], [views], [type], [createdatetime] AS [postdatetime] FROM [dnt_favorites] [f],[dnt_albums] [albums] WHERE [f].[tid]=[albums].[albumid] AND [f].[typeid]=1 AND [f].[uid]=' + STR(@uid)IF @pageindex = 1
	BEGIN
		SET @strSQL = 'SELECT TOP ' + STR(@pagesize) +'  [tid], [uid], [albumid], [albumcateid], [posterid], [poster], [title], [description], [logo], [password], [imgcount], [views], [type], [postdatetime]  FROM (' + @strSQL + ') f' + '  ORDER BY [tid] DESC'
	END
ELSE
	BEGIN
		SET @strSQL = 'SELECT TOP ' + STR(@pagesize) +'  [tid], [uid], [albumid], [albumcateid], [posterid], [poster], [title], [description], [logo], [password], [imgcount], [views], [type], [postdatetime]  FROM (' + @strSQL + ') f1 WHERE [tid] < (SELECT MIN([tid]) FROM (SELECT TOP ' + STR((@pageindex-1)*@pagesize) + ' [tid] FROM (' + @strSQL + ') f2' + '  ORDER BY [tid] DESC) AS tblTmp)' + '  ORDER BY [tid] DESC'
	END EXEC(@strSQL)

 

CREATE PROCEDURE [dbo].[dnt_getfirstpost1id]
@tid int
AS
SELECT TOP 1 [pid] FROM [dnt_posts1] WHERE [tid]=@tid ORDER BY [pid]

 

CREATE PROCEDURE [dbo].[dnt_getforumnewtopics]
@fid int
AS
SELECT TOP 20 [dnt_topics].[tid],[dnt_topics].[title],[dnt_topics].[poster],[dnt_topics].[postdatetime],[dnt_posts1].[message] FROM [dnt_topics] LEFT JOIN [dnt_posts1] ON [dnt_topics].[tid]=[dnt_posts1].[tid]  WHERE [dnt_posts1].[layer]=0 AND  [dnt_topics].[fid]=@fid ORDER BY [lastpost] DESC

 

CREATE PROCEDURE [dbo].[dnt_getindexforumlist]
AS
SELECT CASE WHEN DATEDIFF(n, [lastpost], GETDATE())<600 THEN 'new' ELSE 'old' END AS [havenew],[dnt_forums].*, [dnt_forumfields].* FROM [dnt_forums] LEFT JOIN [dnt_forumfields] ON [dnt_forums].[fid]=[dnt_forumfields].[fid] WHERE [dnt_forums].[parentid] NOT IN (SELECT [fid] FROM [dnt_forums] WHERE [status] < 1 AND [layer] = 0) AND [dnt_forums].[status] > 0 AND [layer] <= 1 ORDER BY [displayorder]


 

CREATE PROCEDURE [dbo].[dnt_getlastexecutescheduledeventdatetime]
(
	@key VARCHAR(100),
	@servername VARCHAR(100),
	@lastexecuted DATETIME OUTPUT
)
AS
SELECT @lastexecuted = MAX([lastexecuted]) FROM [dnt_scheduledevents] WHERE [key] = @key AND [servername] = @servername IF(@lastexecuted IS NULL)
BEGIN
	SET @lastexecuted = DATEADD(YEAR,-1,GETDATE())
END
 

 

CREATE PROCEDURE [dbo].[dnt_getlastpostlist]
	@tid int,
	@postnum int,
	@posttablename varchar(20)
AS EXEC('SELECT TOP ' + @postnum + ' [' + @posttablename + '].[pid], [' + @posttablename + '].[fid], [' + @posttablename + '].[layer], [' + @posttablename + '].[posterid], [' + @posttablename + '].[title], [' + @posttablename + '].[message], [' + @posttablename + '].[postdatetime], [' + @posttablename + '].[attachment], [' + @posttablename + '].[poster], [' + @posttablename + '].[posterid], [' + @posttablename + '].[invisible], [' + @posttablename + '].[usesig], [' + @posttablename + '].[htmlon], [' + @posttablename + '].[smileyoff], [' + @posttablename + '].[parseurloff], [' + @posttablename + '].[bbcodeoff], [' + @posttablename + '].[rate], [' + @posttablename + '].[ratetimes], [dnt_users].[username], [dnt_users].[email], [dnt_users].[showemail], [dnt_userfields].[avatar], [dnt_userfields].[avatarwidth], [dnt_userfields].[avatarheight], [dnt_userfields].[sightml] AS signature, [dnt_userfields].[location], [dnt_userfields].[customstatus] FROM [' + @posttablename + '] LEFT JOIN [dnt_users] ON [dnt_users].[uid]=[' + @posttablename + '].[posterid] LEFT JOIN [dnt_userfields] ON [dnt_userfields].[uid]=[dnt_users].[uid] WHERE [' + @posttablename + '].[tid]=' + @tid + '  AND  [' + @posttablename + '].[invisible]=0 ORDER BY [' + @posttablename + '].[pid] DESC')

 

CREATE PROCEDURE [dbo].[dnt_getmyattachments]
@uid int,
@pageindex int,
@pagesize int
 AS
DECLARE @strSQL varchar(5000)
IF @pageindex = 1
BEGIN
	SET @strSQL ='select TOP  '+ STR(@pagesize) + ' *  from [dnt_myattachments]  where  [uid]='+STR(@uid)+'  order by [aid] desc'END
ELSE
BEGIN
	SET @strSQL = 'SELECT TOP  '+STR(@pagesize)+' * FROM [dnt_myattachments] WHERE [aid] >(SELECT ISNULL(MAX([aid]),0) FROM (SELECT TOP '+STR((@pageindex-1)*@pagesize)+' [aid] FROM [dnt_myattachments]  ORDER BY aid) as A) and [uid]='+ STR(@uid)+'  ORDER BY aid 'END
EXEC(@strSQL)

 

CREATE PROCEDURE [dbo].[dnt_getmyattachmentsbytype]
@uid int,
@pageindex int,
@pagesize int,
@extlist as varchar(100)
 AS
DECLARE @strSQL varchar(5000)
IF @pageindex = 1
BEGIN
	SET @strSQL ='select TOP '+ STR(@pagesize) + ' *  from [dnt_myattachments] where  [extname] in ('+@extlist+') and [uid]='+STR(@uid)+' order by [aid] desc'END
ELSE
BEGIN
	SET @strSQL = 'select TOP '+ STR(@pagesize) + ' *  from dnt_myattachments where [extname] in ('+@extlist+')  and [aid] >(SELECT ISNULL(MAX([aid]),0) FROM (SELECT TOP '+STR((@pageindex-1)*@pagesize)+' [aid] FROM [dnt_myattachments]  where [extname] in ('+@extlist+') ORDER BY aid) as A) and [uid]='+STR(@uid)+' ORDER BY aid 'END
EXEC(@strSQL)

 

CREATE PROCEDURE [dbo].[dnt_getmyposts]
@uid int,
@pageindex int,
@pagesize int
 AS
DECLARE @strSQL varchar(5000)
IF @pageindex = 1
BEGIN
	SET @strSQL = 'SELECT [tid], [fid], [iconid], [typeid], [readperm], [price], [poster], [posterid], [title], [postdatetime], [lastpost], [lastpostid], [lastposter], [lastposterid], [views], [replies], [displayorder], [highlight], [digest], [rate], [hide], [special], [attachment], [moderated], [closed], [magic]
					 FROM [dnt_topics] 
					WHERE [tid] IN (
							SELECT DISTINCT TOP ' + STR(@pagesize) + ' [tid] 
							FROM [dnt_myposts] 
							WHERE [uid]=' + STR(@uid) + ' 
							ORDER BY [tid] DESC
									) 
					ORDER BY [tid] DESC'
END
ELSE
BEGIN
	SET @strSQL = 'SELECT [tid], [fid], [iconid], [typeid], [readperm], [price], [poster], [posterid], [title], [postdatetime], [lastpost], [lastpostid], [lastposter], [lastposterid], [views], [replies], [displayorder], [highlight], [digest], [rate], [hide], [special], [attachment], [moderated], [closed], [magic]
					 FROM [dnt_topics] 
					WHERE [tid] IN (
							SELECT DISTINCT TOP ' + STR(@pagesize) + ' [tid] 
							FROM [dnt_myposts] 
							WHERE [uid]=' + STR(@uid) + ' 
							AND [tid] < (
										SELECT MIN([tid])
										FROM (
											SELECT DISTINCT TOP ' + STR((@pageindex-1)*@pagesize) + ' [tid] 
											FROM [dnt_myposts]
											WHERE [uid]=' + STR(@uid) + ' 
											ORDER BY [tid] DESC
											 ) AS [ttt]
										)
							ORDER BY [tid] DESC
									) 
					ORDER BY [tid] DESC'END
EXEC(@strSQL)

 

CREATE PROCEDURE [dbo].[dnt_getmytopics]
@uid int,
@pageindex int,
@pagesize int
 AS
DECLARE @strSQL varchar(5000)
IF @pageindex = 1
BEGIN
	SET @strSQL = 'SELECT [tid], [fid], [iconid], [typeid], [readperm], [price], [poster], [posterid], [title], [postdatetime], [lastpost], [lastpostid], [lastposter], [lastposterid], [views], [replies], [displayorder], [highlight], [digest], [rate], [hide], [special], [attachment], [moderated], [closed], [magic]
					 FROM [dnt_topics] 
					WHERE [tid] IN (
							SELECT TOP ' + STR(@pagesize) + ' [tid] 
							FROM [dnt_mytopics] 
							WHERE [uid]=' + STR(@uid) + ' 
							ORDER BY [tid] DESC
									) 
					ORDER BY [tid] DESC'
END
ELSE
BEGIN
	SET @strSQL = 'SELECT [tid], [fid], [iconid], [typeid], [readperm], [price], [poster], [posterid], [title], [postdatetime], [lastpost], [lastpostid], [lastposter], [lastposterid], [views], [replies], [displayorder], [highlight], [digest], [rate], [hide], [special], [attachment], [moderated], [closed], [magic]
					 FROM [dnt_topics] 
					WHERE [tid] IN (
							SELECT TOP ' + STR(@pagesize) + ' [tid] 
							FROM [dnt_mytopics] 
							WHERE [uid]=' + STR(@uid) + ' 
							AND [tid] < (
										SELECT MIN([tid])
										FROM (
											SELECT TOP ' + STR((@pageindex-1)*@pagesize) + ' [tid] 
											FROM [dnt_mytopics]
											WHERE [uid]=' + STR(@uid) + ' 
											ORDER BY [tid] DESC
											 ) AS [ttt]
										)
							ORDER BY [tid] DESC
									) 
					ORDER BY [tid] DESC'END
EXEC(@strSQL)

 

 CREATE PROCEDURE [dbo].[dnt_getnewnoticecountbyuid]
@uid int
AS SELECT COUNT(nid) FROM [dnt_notices] WHERE [uid] =  @uid  AND [new] = 1

 

CREATE PROCEDURE [dbo].[dnt_getnewtopics] 
                    @fidlist VARCHAR(500)
                    AS
                    DECLARE @strSQL VARCHAR(5000)
					DECLARE @strMaxPostTableId VARCHAR(3)
					SELECT @strMaxPostTableId=max([id]) FROM [dnt_tablelist]
                    IF @fidlist<>''
                    BEGIN
                    SET @strSQL = 'SELECT TOP 20 [dnt_posts' + @strMaxPostTableId + '].[tid], [dnt_posts' + @strMaxPostTableId + '].[title], [dnt_posts' + @strMaxPostTableId + '].[poster], [dnt_posts' + @strMaxPostTableId + '].[postdatetime], [dnt_posts' + @strMaxPostTableId + '].[message],[dnt_forums].[name] FROM [dnt_posts' + @strMaxPostTableId + ']  LEFT JOIN [dnt_forums] ON [dnt_posts' + @strMaxPostTableId + '].[fid]=[dnt_forums].[fid] WHERE  [dnt_forums].[fid] NOT IN ('+@fidlist +')  AND [dnt_posts' + @strMaxPostTableId + '].[layer]=0 ORDER BY [dnt_posts' + @strMaxPostTableId + '].[pid] DESC' 
                    END
                    ELSE
                    BEGIN
                    SET @strSQL = 'SELECT TOP 20 [dnt_posts' + @strMaxPostTableId + '].[tid], [dnt_posts' + @strMaxPostTableId + '].[title], [dnt_posts' + @strMaxPostTableId + '].[poster], [dnt_posts' + @strMaxPostTableId + '].[postdatetime], [dnt_posts' + @strMaxPostTableId + '].[message],[dnt_forums].[name] FROM [dnt_posts' + @strMaxPostTableId + ']  LEFT JOIN [dnt_forums] ON [dnt_posts' + @strMaxPostTableId + '].[fid]=[dnt_forums].[fid] WHERE [dnt_posts' + @strMaxPostTableId + '].[layer]=0 ORDER BY [dnt_posts' + @strMaxPostTableId + '].[pid] DESC'
                    END
                    EXEC(@strSQL)
           


 

 CREATE PROCEDURE [dbo].[dnt_getnoticebyuid]
@uid int,
@type int AS IF @type = 0
     SELECT nid, uid, type, new, posterid, poster, note, postdatetime FROM [dnt_notices] WHERE [uid] = @uid  ORDER BY [postdatetime] DESC
ELSE
    SELECT nid, uid, type, new, posterid, poster, note, postdatetime  FROM [dnt_notices] WHERE [uid] = @uid AND [type] = @type ORDER BY [postdatetime] DESC

 

CREATE PROCEDURE [dbo].[dnt_getnoticecount]
@userid int,
@type int = -1,
@state int=-1
AS	IF @type = -1
		BEGIN
			IF @state = -1
				BEGIN
					SELECT COUNT(nid) AS [pmcount] FROM [dnt_notices] WHERE [uid]=@userid
				END
			ELSE
				BEGIN
					SELECT COUNT(nid) AS [pmcount] FROM [dnt_notices] WHERE [uid]=@userid AND [new]=@state
				END
		END
	ELSE
		BEGIN
			IF @state = -1
				BEGIN
					SELECT COUNT(nid) AS [pmcount] FROM [dnt_notices] WHERE [uid]=@userid AND [type]=@type
				END
			ELSE
				BEGIN
					SELECT COUNT(nid) AS [pmcount] FROM [dnt_notices] WHERE [uid]=@userid AND [new]=@state AND [type]=@type
				END
		END

 

 CREATE PROCEDURE [dbo].[dnt_getnoticecountbyuid]
@uid int,
@type int
AS
IF @type = -1
   SELECT COUNT(nid) FROM [dnt_notices] WHERE [uid] = @uid
ELSE
    SELECT COUNT(nid) FROM [dnt_notices] WHERE [uid] = @uid AND [type]=@type

 

CREATE PROCEDURE [dbo].[dnt_getonlineuser]
@userid int,
@password char(32)
AS
SELECT TOP 1 [olid]
      ,[userid]
      ,[ip]
      ,[username]
      ,[nickname]
      ,[password]
      ,[groupid]
      ,[olimg]
      ,[adminid]
      ,[invisible]
      ,[action]
      ,[lastactivity]
      ,[lastposttime]
      ,[lastpostpmtime]
      ,[lastsearchtime]
      ,[lastupdatetime]
      ,[forumid]
      ,[forumname]
      ,[titleid]
      ,[title]
      ,[verifycode]
      ,[newpms]
      ,[newnotices] FROM [dnt_online] WHERE [userid]=@userid AND [password]=@password


 

CREATE PROCEDURE [dbo].[dnt_getonlineuserbyip]
@userid int,
@ip varchar(15)
AS SELECT TOP 1 [olid]
      ,[userid]
      ,[ip]
      ,[username]
      ,[nickname]
      ,[password]
      ,[groupid]
      ,[olimg]
      ,[adminid]
      ,[invisible]
      ,[action]
      ,[lastactivity]
      ,[lastposttime]
      ,[lastpostpmtime]
      ,[lastsearchtime]
      ,[lastupdatetime]
      ,[forumid]
      ,[forumname]
      ,[titleid]
      ,[title]
      ,[verifycode]
      ,[newpms]
      ,[newnotices] FROM [dnt_online] WHERE [userid]=@userid AND [ip]=@ip


 

CREATE PROCEDURE [dbo].[dnt_getonlineuserlist]
AS
SELECT [olid]
      ,[userid]
      ,[ip]
      ,[username]
      ,[nickname]
      ,[password]
      ,[groupid]
      ,[olimg]
      ,[adminid]
      ,[invisible]
      ,[action]
      ,[lastactivity]
      ,[lastposttime]
      ,[lastpostpmtime]
      ,[lastsearchtime]
      ,[lastupdatetime]
      ,[forumid]
      ,[forumname]
      ,[titleid]
      ,[title]
      ,[verifycode]
      ,[newpms]
      ,[newnotices] FROM [dnt_online]


 

CREATE PROCEDURE [dbo].[dnt_getonlineuserlistbyfid]
@fid int
AS
SELECT [olid]
      ,[userid]
      ,[ip]
      ,[username]
      ,[nickname]
      ,[password]
      ,[groupid]
      ,[olimg]
      ,[adminid]
      ,[invisible]
      ,[action]
      ,[lastactivity]
      ,[lastposttime]
      ,[lastpostpmtime]
      ,[lastsearchtime]
      ,[lastupdatetime]
      ,[forumid]
      ,[forumname]
      ,[titleid]
      ,[title]
      ,[verifycode]
      ,[newpms]
      ,[newnotices] FROM [dnt_online] WHERE [forumid]=@fid


 

CREATE PROCEDURE [dbo].[dnt_getpmcount]
@userid int,
@folder int=0,
@state int=-1
AS IF @folder=-1
	BEGIN
	  SELECT COUNT(pmid) AS [pmcount] FROM [dnt_pms] WHERE ([msgtoid]=@userid AND [folder]=0) OR ([msgfromid] = @userid AND [folder] = 1) OR ([msgfromid] = @userid AND [folder] = 2)
	END
ELSE
    BEGIN
		IF @folder=0
			BEGIN
				IF @state=-1
					BEGIN
						SELECT COUNT(pmid) AS [pmcount] FROM [dnt_pms] WHERE [msgtoid]=@userid AND [folder]=@folder
					END
				ELSE IF @state=2
					BEGIN
						SELECT COUNT(pmid) AS [pmcount] FROM [dnt_pms] WHERE [msgtoid]=@userid AND [folder]=@folder AND [new]=1 AND GETDATE()-[postdatetime]<3
					END
				ELSE
					BEGIN
						SELECT COUNT(pmid) AS [pmcount] FROM [dnt_pms] WHERE [msgtoid]=@userid AND [folder]=@folder AND [new]=@state
					END
			END
		ELSE
			BEGIN
				IF @state=-1
					BEGIN
						SELECT COUNT(pmid) AS [pmcount] FROM [dnt_pms] WHERE [msgfromid]=@userid AND [folder]=@folder
					END
				ELSE IF @state=2
					BEGIN
						SELECT COUNT(pmid) AS [pmcount] FROM [dnt_pms] WHERE [msgfromid]=@userid AND [folder]=@folder AND [new]=1 AND GETDATE()-[postdatetime]<3
					END
				ELSE
					BEGIN
						SELECT COUNT(pmid) AS [pmcount] FROM [dnt_pms] WHERE [msgfromid]=@userid AND [folder]=@folder AND [new]=@state
					END
			END
	END


 

CREATE PROCEDURE [dbo].[dnt_getpmlist]
@userid int,
@folder int=0,
@pagesize int,
@pageindex int,
@strwhere varchar(500)
AS
DECLARE @strSQL varchar(5000)DECLARE @msgformORtoID varchar(10)
SET @msgformortoid='msgtoid'IF @folder=1 OR @folder=2
	BEGIN
		SET @msgformortoid='msgfromid'
	END IF @pageindex = 1
	BEGIN
		IF @strwhere != ''   
			SET @strSQL = 'SELECT TOP ' + STR(@pagesize) +' [pmid],[msgfrom],[msgfromid],[msgto],[msgtoid],[folder],[new],[subject],[postdatetime],[message] FROM [dnt_pms] WHERE [' + @msgformortoid + ']=' +STR(@userid) + ' AND [folder]=' +STR(@folder) + ' AND ' + @strwhere + ' ORDER BY [pmid] DESC'
		ELSE
			SET @strSQL = 'SELECT TOP ' + STR(@pagesize) +' [pmid],[msgfrom],[msgfromid],[msgto],[msgtoid],[folder],[new],[subject],[postdatetime],[message] FROM [dnt_pms] WHERE [' + @msgformortoid + ']=' +STR(@userid) + ' AND [folder]=' +STR(@folder) + ' ORDER BY [pmid] DESC'
		
	END
ELSE
	BEGIN
		SET @strSQL = 'SELECT TOP ' + STR(@pagesize) +' [pmid],[msgfrom],[msgfromid],[msgto],[msgtoid],[folder],[new],[subject],[postdatetime],[message] FROM [dnt_pms] WHERE [pmid] < (SELECT MIN([pmid]) FROM (SELECT TOP ' + STR((@pageindex-1)*@pagesize) + ' [pmid] FROM [dnt_pms] WHERE [' + @msgformortoid + ']=' +STR(@userid) + ' AND [folder]=' +STR(@folder) + ' ORDER BY [pmid] DESC) AS tblTmp) AND [' + @msgformortoid + ']=' +STR(@userid) + ' AND [folder]=' + STR(@folder) + ' ORDER BY [pmid] DESC'
		IF @strwhere != ''
			BEGIN
				SET @strSQL = 'SELECT TOP ' + STR(@pagesize) +' [pmid],[msgfrom],[msgfromid],[msgto],[msgtoid],[folder],[new],[subject],[postdatetime],[message] FROM [dnt_pms] WHERE [pmid] < (SELECT MIN([pmid]) FROM (SELECT TOP ' + STR((@pageindex-1)*@pagesize) + ' [pmid] FROM [dnt_pms] WHERE [' + @msgformortoid + ']=' +STR(@userid) + ' AND [folder]=' +STR(@folder) + ' AND ' + @strwhere + ' ORDER BY [pmid] DESC) AS tblTmp) AND [' + @msgformortoid + ']=' +STR(@userid) + ' AND [folder]=' +STR(@folder) + ' AND ' + @strwhere + ' ORDER BY [pmid] DESC'
			END
	END EXEC(@strSQL)

 

CREATE PROCEDURE [dbo].[dnt_getpost1count]
@tid int
AS
SELECT COUNT(pid) FROM [dnt_posts1] WHERE [tid]=@tid AND [invisible]=0 AND layer>0

 

CREATE PROCEDURE [dbo].[dnt_getpost1tree]
@tid int
AS
SELECT [pid], [layer], [title], [poster], [posterid],[postdatetime],[message] FROM [dnt_posts1] WHERE [tid]=@tid AND [invisible]=0 ORDER BY [parentid];

 

CREATE PROCEDURE [dbo].[dnt_getpostcountbycondition]
@condition varchar(100),
@posttablename varchar(20)
AS
declare @strSQL varchar(200)
set @strSQL ='SELECT COUNT(pid) FROM [' + @posttablename + '] WHERE '+@condition+ ' AND [layer]>=0'EXEC(@strSQL)

 

 CREATE PROCEDURE [dbo].[dnt_getpostlist]
@tid int,
@pagesize int,
@pageindex int,
@posttablename varchar(20)
AS
DECLARE @pagetop int SET @pagetop = (@pageindex-1)*@pagesize IF @pageindex = 1 EXEC('SELECT TOP ' + @pagesize + '
									[' + @posttablename + '].[pid], 
									[' + @posttablename + '].[fid], 
									[' + @posttablename + '].[title], 
									[' + @posttablename + '].[layer],
									[' + @posttablename + '].[message], 
									[' + @posttablename + '].[ip], 
									[' + @posttablename + '].[lastedit], 
									[' + @posttablename + '].[postdatetime], 
									[' + @posttablename + '].[attachment], 
									[' + @posttablename + '].[poster], 
									[' + @posttablename + '].[posterid], 
									[' + @posttablename + '].[invisible], 
									[' + @posttablename + '].[usesig], 
									[' + @posttablename + '].[htmlon], 
									[' + @posttablename + '].[smileyoff], 
									[' + @posttablename + '].[parseurloff], 
									[' + @posttablename + '].[bbcodeoff], 
									[' + @posttablename + '].[rate], 
									[' + @posttablename + '].[ratetimes], 
									[dnt_users].[nickname],  
									[dnt_users].[username], 
									[dnt_users].[groupid], 
									[dnt_users].[spaceid],
									[dnt_users].[gender],
									[dnt_users].[bday],
									[dnt_users].[email], 
									[dnt_users].[showemail], 
									[dnt_users].[digestposts], 
									[dnt_users].[credits], 
									[dnt_users].[extcredits1], 
									[dnt_users].[extcredits2], 
									[dnt_users].[extcredits3], 
									[dnt_users].[extcredits4], 
									[dnt_users].[extcredits5], 
									[dnt_users].[extcredits6], 
									[dnt_users].[extcredits7], 
									[dnt_users].[extcredits8], 
									[dnt_users].[posts], 
									[dnt_users].[joindate], 
									[dnt_users].[onlinestate],
									[dnt_users].[lastactivity], 
									[dnt_users].[invisible], 
									[dnt_userfields].[avatar], 
									[dnt_userfields].[avatarwidth], 
									[dnt_userfields].[avatarheight],
									[dnt_userfields].[medals],
									[dnt_userfields].[sightml] AS signature, 
									[dnt_userfields].[location], 
									[dnt_userfields].[customstatus], 
									[dnt_userfields].[website], 
									[dnt_userfields].[icq], 
									[dnt_userfields].[qq], 
									[dnt_userfields].[msn], 
									[dnt_userfields].[yahoo], 
									[dnt_userfields].[skype] 
	 FROM [' + @posttablename + '] LEFT JOIN [dnt_users] ON [dnt_users].[uid]=[' + @posttablename + '].[posterid] LEFT JOIN [dnt_userfields] ON [dnt_userfields].[uid]=[dnt_users].[uid] WHERE [' + @posttablename + '].[tid]=' + @tid + ' AND [' + @posttablename + '].[invisible]<=0 ORDER BY [' + @posttablename + '].[pid]')ELSE EXEC('SELECT TOP ' + @pagesize + ' 
									[' + @posttablename + '].[pid], 
									[' + @posttablename + '].[fid], 
									[' + @posttablename + '].[title], 
									[' + @posttablename + '].[layer],
									[' + @posttablename + '].[message], 
									[' + @posttablename + '].[ip], 
									[' + @posttablename + '].[lastedit], 
									[' + @posttablename + '].[postdatetime], 
									[' + @posttablename + '].[attachment], 
									[' + @posttablename + '].[poster], 
									[' + @posttablename + '].[posterid], 
									[' + @posttablename + '].[invisible], 
									[' + @posttablename + '].[usesig], 
									[' + @posttablename + '].[htmlon], 
									[' + @posttablename + '].[smileyoff], 
									[' + @posttablename + '].[parseurloff], 
									[' + @posttablename + '].[bbcodeoff], 
									[' + @posttablename + '].[rate], 
									[' + @posttablename + '].[ratetimes],
									[dnt_users].[nickname],  
									[dnt_users].[username], 
									[dnt_users].[groupid], 
									[dnt_users].[spaceid],
									[dnt_users].[gender],
									[dnt_users].[bday],
									[dnt_users].[email], 
									[dnt_users].[showemail], 
									[dnt_users].[digestposts], 
									[dnt_users].[credits], 
									[dnt_users].[extcredits1], 
									[dnt_users].[extcredits2], 
									[dnt_users].[extcredits3], 
									[dnt_users].[extcredits4], 
									[dnt_users].[extcredits5], 
									[dnt_users].[extcredits6], 
									[dnt_users].[extcredits7], 
									[dnt_users].[extcredits8], 
									[dnt_users].[posts], 
									[dnt_users].[joindate], 
									[dnt_users].[onlinestate],
									[dnt_users].[lastactivity],  
									[dnt_users].[invisible] AS [userinvisible], 
									[dnt_userfields].[avatar], 
									[dnt_userfields].[avatarwidth], 
									[dnt_userfields].[avatarheight], 
									[dnt_userfields].[medals],
									[dnt_userfields].[sightml] AS [signature], 
									[dnt_userfields].[location], 
									[dnt_userfields].[customstatus], 
									[dnt_userfields].[website], 
									[dnt_userfields].[icq], 
									[dnt_userfields].[qq], 
									[dnt_userfields].[msn], 
									[dnt_userfields].[yahoo], 
									[dnt_userfields].[skype] 
	FROM [' + @posttablename + '] LEFT JOIN [dnt_users] ON [dnt_users].[uid]=[' + @posttablename + '].[posterid] LEFT JOIN [dnt_userfields] ON [dnt_userfields].[uid]=[dnt_users].[uid] WHERE [' + @posttablename + '].[tid]=' + @tid + ' AND [pid] > (SELECT MAX([pid]) FROM (SELECT TOP ' + @pagetop + ' [' + @posttablename + '].[pid] FROM [' + @posttablename + '] WHERE [' + @posttablename + '].[tid]=' + @tid + ' AND [' + @posttablename + '].[invisible]<=0 ORDER BY [' + @posttablename + '].[pid]) AS tblTmp) AS tblTmp) AND [' + @posttablename + '].[invisible]<=0 ORDER BY [' + @posttablename + '].[pid]')


 

CREATE PROCEDURE [dbo].[dnt_getpostlistbycondition]
@tid int,
@pagesize int,
@pageindex int,
@condition varchar(100),
@posttablename varchar(20)
AS
DECLARE @pagetop int SET @pagetop = (@pageindex-1)*@pagesize IF @pageindex = 1 EXEC('SELECT TOP ' + @pagesize + '
									[' + @posttablename + '].[pid], 
									[' + @posttablename + '].[fid], 
									[' + @posttablename + '].[title], 
									[' + @posttablename + '].[layer],
									[' + @posttablename + '].[message], 
									[' + @posttablename + '].[ip], 
									[' + @posttablename + '].[lastedit], 
									[' + @posttablename + '].[postdatetime], 
									[' + @posttablename + '].[attachment], 
									[' + @posttablename + '].[poster], 
									[' + @posttablename + '].[posterid], 
									[' + @posttablename + '].[invisible], 
									[' + @posttablename + '].[usesig], 
									[' + @posttablename + '].[htmlon], 
									[' + @posttablename + '].[smileyoff], 
									[' + @posttablename + '].[parseurloff], 
									[' + @posttablename + '].[bbcodeoff], 
									[' + @posttablename + '].[rate], 
									[' + @posttablename + '].[ratetimes], 
									[dnt_users].[nickname],  
									[dnt_users].[username], 
									[dnt_users].[groupid], 
									[dnt_users].[spaceid],
									[dnt_users].[gender],
									[dnt_users].[bday],
									[dnt_users].[email], 
									[dnt_users].[showemail], 
									[dnt_users].[digestposts], 
									[dnt_users].[credits], 
									[dnt_users].[extcredits1], 
									[dnt_users].[extcredits2], 
									[dnt_users].[extcredits3], 
									[dnt_users].[extcredits4], 
									[dnt_users].[extcredits5], 
									[dnt_users].[extcredits6], 
									[dnt_users].[extcredits7], 
									[dnt_users].[extcredits8], 
									[dnt_users].[posts], 
									[dnt_users].[joindate], 
									[dnt_users].[onlinestate],
									[dnt_users].[lastactivity],  
									[dnt_users].[invisible], 
									[dnt_userfields].[avatar], 
									[dnt_userfields].[avatarwidth],
									[dnt_userfields].[avatarheight],
									[dnt_userfields].[medals],
									[dnt_userfields].[sightml] AS signature, 
									[dnt_userfields].[location], 
									[dnt_userfields].[customstatus], 
									[dnt_userfields].[website], 
									[dnt_userfields].[icq], 
									[dnt_userfields].[qq], 
									[dnt_userfields].[msn], 
									[dnt_userfields].[yahoo], 
									[dnt_userfields].[skype] 
	 FROM [' + @posttablename + '] LEFT JOIN [dnt_users] ON [dnt_users].[uid]=[' + @posttablename + '].[posterid] LEFT JOIN [dnt_userfields] ON [dnt_userfields].[uid]=[dnt_users].[uid] WHERE [' + @posttablename + '].[tid]=' + @tid + ' AND [' + @posttablename + '].[invisible]=0 AND '+@condition+' ORDER BY [' + @posttablename + '].[pid]')ELSE EXEC('SELECT TOP ' + @pagesize + ' 
									[' + @posttablename + '].[pid], 
									[' + @posttablename + '].[fid], 
									[' + @posttablename + '].[title], 
									[' + @posttablename + '].[layer],
									[' + @posttablename + '].[message], 
									[' + @posttablename + '].[ip], 
									[' + @posttablename + '].[lastedit], 
									[' + @posttablename + '].[postdatetime], 
									[' + @posttablename + '].[attachment], 
									[' + @posttablename + '].[poster], 
									[' + @posttablename + '].[posterid], 
									[' + @posttablename + '].[invisible], 
									[' + @posttablename + '].[usesig], 
									[' + @posttablename + '].[htmlon], 
									[' + @posttablename + '].[smileyoff], 
									[' + @posttablename + '].[parseurloff], 
									[' + @posttablename + '].[bbcodeoff], 
									[' + @posttablename + '].[rate], 
									[' + @posttablename + '].[ratetimes],
									[dnt_users].[nickname],  
									[dnt_users].[username], 
									[dnt_users].[groupid], 
									[dnt_users].[spaceid],
									[dnt_users].[gender],
									[dnt_users].[bday],
									[dnt_users].[email], 
									[dnt_users].[showemail], 
									[dnt_users].[digestposts], 
									[dnt_users].[credits], 
									[dnt_users].[extcredits1], 
									[dnt_users].[extcredits2], 
									[dnt_users].[extcredits3], 
									[dnt_users].[extcredits4], 
									[dnt_users].[extcredits5], 
									[dnt_users].[extcredits6], 
									[dnt_users].[extcredits7], 
									[dnt_users].[extcredits8], 
									[dnt_users].[posts], 
									[dnt_users].[joindate], 
									[dnt_users].[onlinestate], 
									[dnt_users].[lastactivity], 
									[dnt_users].[invisible], 
									[dnt_userfields].[avatar], 
									[dnt_userfields].[avatarwidth], 
									[dnt_userfields].[avatarheight], 
									[dnt_userfields].[medals],
									[dnt_userfields].[sightml] AS signature, 
									[dnt_userfields].[location], 
									[dnt_userfields].[customstatus], 
									[dnt_userfields].[website], 
									[dnt_userfields].[icq], 
									[dnt_userfields].[qq], 
									[dnt_userfields].[msn], 
									[dnt_userfields].[yahoo], 
									[dnt_userfields].[skype] 
	FROM [' + @posttablename + '] LEFT JOIN [dnt_users] ON [dnt_users].[uid]=[' + @posttablename + '].[posterid] LEFT JOIN [dnt_userfields] ON [dnt_userfields].[uid]=[dnt_users].[uid] WHERE [' + @posttablename + '].[tid]=' + @tid + ' AND [' + @posttablename + '].[invisible]=0 AND '+ @condition+'  AND [pid] > (SELECT MAX([pid]) FROM (SELECT TOP ' + @pagetop + ' [' + @posttablename + '].[pid] FROM [' + @posttablename + '] LEFT JOIN [dnt_users] ON [dnt_users].[uid]=[' + @posttablename + '].[posterid] LEFT JOIN [dnt_userfields] ON [dnt_userfields].[uid]=[dnt_users].[uid] WHERE [' + @posttablename + '].[tid]=' + @tid + '  AND '+@condition+'  ORDER BY [' + @posttablename + '].[pid]) AS tblTmp) ORDER BY [' + @posttablename + '].[pid]')

 

CREATE PROCEDURE [dbo].[dnt_getrelatedtopics]
@count int,
@tid int
AS EXEC('SELECT TOP ' + @count + ' * FROM [dnt_topictagcaches] WHERE [tid]=' + @tid + ' ORDER BY [linktid] DESC')


 

 CREATE PROCEDURE [dbo].[dnt_getreplypid]
@uid int,
@tid int,
@posttableid char(3)AS EXEC('SELECT TOP 1 [pid] FROM [dnt_posts' + @posttableid + '] WHERE [tid] = ' + @tid + ' AND [posterid]=' + @uid)

 

CREATE PROCEDURE [dbo].[dnt_getshortuserinfo]
@uid int
AS
SELECT TOP 1 * FROM [dnt_users] WHERE [uid]=@uid


 

CREATE PROCEDURE [dbo].[dnt_getsinglepost1]
                    @tid int,
                    @pid int
                    AS
                    SELECT [aid], [tid], [pid], [postdatetime], [readperm], [filename], [description], [filetype], [filesize], [attachment], [downloads], [attachprice], [uid]  FROM [dnt_attachments] WHERE [tid]=@tid                    SELECT TOP 1 
	                                [dnt_posts1].[pid], 
	                                [dnt_posts1].[fid], 
	                                [dnt_posts1].[title], 
	                                [dnt_posts1].[layer],
	                                [dnt_posts1].[message], 
	                                [dnt_posts1].[ip], 
	                                [dnt_posts1].[lastedit], 
	                                [dnt_posts1].[postdatetime], 
	                                [dnt_posts1].[attachment], 
	                                [dnt_posts1].[poster], 
	                                [dnt_posts1].[invisible], 
	                                [dnt_posts1].[usesig], 
	                                [dnt_posts1].[htmlon], 
	                                [dnt_posts1].[smileyoff], 
	                                [dnt_posts1].[parseurloff], 
	                                [dnt_posts1].[bbcodeoff], 
	                                [dnt_posts1].[rate], 
	                                [dnt_posts1].[ratetimes], 
	                                [dnt_posts1].[posterid], 
	                                [dnt_users].[nickname],  
	                                [dnt_users].[username], 
	                                [dnt_users].[groupid],
                                    [dnt_users].[spaceid],
                                    [dnt_users].[gender],
									[dnt_users].[bday], 
	                                [dnt_users].[email], 
	                                [dnt_users].[showemail], 
	                                [dnt_users].[digestposts], 
	                                [dnt_users].[credits], 
	                                [dnt_users].[extcredits1], 
	                                [dnt_users].[extcredits2], 
	                                [dnt_users].[extcredits3], 
	                                [dnt_users].[extcredits4], 
	                                [dnt_users].[extcredits5], 
	                                [dnt_users].[extcredits6], 
	                                [dnt_users].[extcredits7], 
	                                [dnt_users].[extcredits8], 
	                                [dnt_users].[posts], 
	                                [dnt_users].[joindate], 
	                                [dnt_users].[onlinestate], 
	                                [dnt_users].[lastactivity], 
	                                [dnt_users].[invisible], 
	                                [dnt_userfields].[avatar], 
	                                [dnt_userfields].[avatarwidth], 
	                                [dnt_userfields].[avatarheight], 
	                                [dnt_userfields].[medals], 
	                                [dnt_userfields].[sightml] AS signature, 
	                                [dnt_userfields].[location], 
	                                [dnt_userfields].[customstatus], 
	                                [dnt_userfields].[website], 
	                                [dnt_userfields].[icq], 
	                                [dnt_userfields].[qq], 
	                                [dnt_userfields].[msn], 
	                                [dnt_userfields].[yahoo], 
	                                [dnt_userfields].[skype] 
                    FROM [dnt_posts1] LEFT JOIN [dnt_users] ON [dnt_users].[uid]=[dnt_posts1].[posterid] LEFT JOIN [dnt_userfields] ON [dnt_userfields].[uid]=[dnt_users].[uid] WHERE [dnt_posts1].[pid]=@pid

 

CREATE PROCEDURE [dbo].[dnt_getsitemapnewtopics]
@fidlist VARCHAR(500)
AS
IF @fidlist<>''
     BEGIN
      DECLARE @strSQL VARCHAR(5000)
      SET @strSQL = 'SELECT TOP 20 [tid], [fid], [title], [poster], [postdatetime], [lastpost], [replies], [views], [digest] FROM [dnt_topics] WHERE [fid] 
NOT IN ('+@fidlist +') ORDER BY [tid] DESC' 
     END
ELSE
     BEGIN
      SET @strSQL = 'SELECT TOP 20 [tid], [fid], [title], [poster], [postdatetime], [lastpost], [replies], [views], [digest] FROM [dnt_topics] ORDER BY [tid] 
DESC'
     END
  EXEC(@strSQL)

 

 CREATE PROCEDURE [dbo].[dnt_gettodayuploadedfilesize] 
@uid int AS SELECT SUM([filesize]) AS [todaysize] FROM [dnt_attachments] WHERE [uid]=@uid AND DATEDIFF(d,[postdatetime],GETDATE())=0

 

CREATE PROCEDURE [dbo].[dnt_gettopiccount]
@fid int
AS
SELECT [curtopics] FROM [dnt_forums] WHERE [fid]=@fid

 

CREATE PROCEDURE [dbo].[dnt_gettopiccountbycondition]
@fid int,
@state int=0,
@condition varchar(80)=null
AS
DECLARE @sql varchar(500)
IF @state=-1
	BEGIN
		set @sql ='SELECT COUNT(tid) FROM [dnt_topics] WHERE [fid]='+str(@fid)+' AND [displayorder]>-1 AND [closed]<=1'+@condition
	END
ELSE
	BEGIN
set @sql ='SELECT COUNT(tid) FROM [dnt_topics] WHERE [fid]='+str(@fid)+' AND [displayorder]>-1 AND [closed]='+str(@state)+' AND [closed]<=1'+@condition
	END
exec(@sql)

 

CREATE PROCEDURE [dbo].[dnt_gettopiccountbytype]
@condition varchar(4000)
AS
DECLARE @sql varchar(4100)
set @sql ='SELECT COUNT(tid) FROM [dnt_topics] WHERE [displayorder]>-1 AND [closed]<=1 '+@condition
exec(@sql)

 

CREATE PROCEDURE [dbo].[dnt_gettopicinfo]
@tid int,
@fid int,
@mode int
AS
IF @mode = 1
	BEGIN
       SELECT TOP 1 [tid]
      ,[fid]
      ,[iconid]
      ,[readperm]
      ,[price]
      ,[poster]
      ,[posterid]
      ,[title]
      ,[postdatetime]
      ,[lastpost]
      ,[lastpostid]
      ,[lastposter]
      ,[lastposterid]
      ,[views]
      ,[replies]
      ,[displayorder]
      ,[highlight]
      ,[digest]
      ,[hide]
      ,[attachment]
      ,[moderated]
      ,[closed]
      ,[magic]
      ,[identify]
      ,[special]
      ,[typeid]
      ,[rate]
      ,[attention] FROM [dnt_topics] WHERE [fid]=@fid AND [tid]<@tid AND [displayorder]>=0 ORDER BY [tid] DESC
	END
ELSE IF @mode = 2
	BEGIN
       SELECT TOP 1 [tid]
      ,[fid]
      ,[iconid]
      ,[readperm]
      ,[price]
      ,[poster]
      ,[posterid]
      ,[title]
      ,[postdatetime]
      ,[lastpost]
      ,[lastpostid]
      ,[lastposter]
      ,[lastposterid]
      ,[views]
      ,[replies]
      ,[displayorder]
      ,[highlight]
      ,[digest]
      ,[hide]
      ,[attachment]
      ,[moderated]
      ,[closed]
      ,[magic]
      ,[identify]
      ,[special]
      ,[typeid]
      ,[rate]
      ,[attention] FROM [dnt_topics] WHERE [fid]=@fid AND [tid]>@tid AND [displayorder]>=0 ORDER BY [tid] ASC
	END
ELSE
	BEGIN
       SELECT TOP 1 [tid]
      ,[fid]
      ,[iconid]
      ,[readperm]
      ,[price]
      ,[poster]
      ,[posterid]
      ,[title]
      ,[postdatetime]
      ,[lastpost]
      ,[lastpostid]
      ,[lastposter]
      ,[lastposterid]
      ,[views]
      ,[replies]
      ,[displayorder]
      ,[highlight]
      ,[digest]
      ,[hide]
      ,[attachment]
      ,[moderated]
      ,[closed]
      ,[magic]
      ,[identify]
      ,[special]
      ,[typeid]
      ,[rate]
      ,[attention] FROM [dnt_topics] WHERE [tid]=@tid
	END


 

CREATE PROCEDURE [dbo].[dnt_gettopiclist]
@fid int,
@pagesize int,
@pageindex int,
@startnum int,
@condition varchar(80)
AS
DECLARE @strSQL varchar(5000)IF @pageindex = 1
	BEGIN
		SET @strSQL = 'SELECT TOP ' + STR(@pagesize) +' [rate],[tid],[iconid],[typeid],[title],[price],[hide],[readperm],[special],[poster],[posterid],[replies],[views],[postdatetime],[lastpost],[lastposter],[lastpostid],[lastposterid],[replies],[highlight],[digest],[displayorder],[attachment],[closed],[magic],[special] FROM [dnt_topics] WHERE [fid]=' +STR(@fid) + ' AND [displayorder]=0' + @condition + ' ORDER BY [lastpostid] DESC'
	END
ELSE
	BEGIN
		SET @strSQL = 'SELECT TOP ' + STR(@pagesize) +'[rate], [tid],[iconid],[typeid],[title],[price],[hide],[readperm],[special],[poster],[posterid],[replies],[views],[postdatetime],[lastpost],[lastposter],[lastpostid],[lastposterid],[replies],[highlight],[digest],[displayorder],[attachment],[closed],[magic],[special] FROM [dnt_topics] WHERE [lastpostid] < (SELECT min([lastpostid])  FROM (SELECT TOP ' + STR((@pageindex-1)*@pagesize-@startnum) + ' [lastpostid] FROM [dnt_topics] WHERE [fid]=' +STR(@fid) + ' AND [displayorder]=0' + @condition + ' ORDER BY [lastpostid] DESC) AS tblTmp ) AND [fid]=' +STR(@fid) + ' AND [displayorder]=0' + @condition + ' ORDER BY [lastpostid] DESC'
	END
EXEC(@strSQL)

 

CREATE  PROCEDURE [dbo].[dnt_gettopiclistbydate]
@fid int,
@pagesize int,
@pageindex int,
@startnum int,
@condition varchar(100),
@orderby varchar(100),
@ascdesc int
AS DECLARE @strsql varchar(5000)
DECLARE @sorttype varchar(5)IF @ascdesc=0
   SET @sorttype='ASC'
ELSE
   SET @sorttype='DESC'IF @pageindex = 1
	BEGIN
		SET @strsql = 'SELECT TOP ' + STR(@pagesize) +' [tid],[iconid],[title],[price],[typeid],[readperm],[hide],[special],[poster],[posterid],[replies],[views],[postdatetime],[lastpost],[lastposter],[lastpostid],[lastposterid],[replies],[highlight],[digest],[displayorder],[attachment],[closed],[magic],[rate] FROM [dnt_topics] WHERE [fid]=' +STR(@fid) + ' AND [displayorder]=0'+@condition+' ORDER BY '+@orderby+' '+@sorttype
	END
ELSE
           IF @sorttype='DESC'
	BEGIN
		SET @strSQL = 'SELECT TOP ' + STR(@pagesize) +' [tid],[iconid],[title],[price],[typeid],[hide],[readperm],[special],[poster],[posterid],[replies],[views],[postdatetime],[lastpost],[lastposter],[lastpostid],[lastposterid],[replies],[highlight],[digest],[displayorder],[attachment],[closed],[magic],[rate] FROM [dnt_topics] WHERE ['+@orderby+'] < (SELECT min(['+@orderby+']) FROM (SELECT TOP ' + STR((@pageindex-1)*@pagesize-@startnum) + ' ['+@orderby+']  FROM [dnt_topics] WHERE [fid]=' +STR(@fid) + ' AND [displayorder]=0'+@condition+' ORDER BY  '+@orderby+' '+@sorttype+')AS tblTmp ) AND [fid]=' +STR(@fid) + ' AND [displayorder]=0'+@condition+' ORDER BY  '+@orderby+' '+@sorttype
	END
      ELSE
             BEGIN
		SET @strSQL = 'SELECT TOP ' + STR(@pagesize) +' [tid],[iconid],[title],[price],[hide],[typeid],[readperm],[special],[poster],[posterid],[replies],[views],[postdatetime],[lastpost],[lastposter],[lastpostid],[lastposterid],[replies],[highlight],[digest],[displayorder],[attachment],[closed],[magic],[rate] FROM [dnt_topics] WHERE ['+@orderby+'] > (SELECT MAX(['+@orderby+']) FROM (SELECT TOP ' + STR((@pageindex-1)*@pagesize-@startnum) + ' ['+@orderby+'] FROM [dnt_topics] WHERE [fid]=' +STR(@fid) + ' AND [displayorder]=0'+@condition+' ORDER BY  '+@orderby+' '+@sorttype+')AS tblTmp ) AND [fid]=' +STR(@fid) + ' AND [displayorder]=0'+@condition+' ORDER BY '+@orderby+' '+@sorttype
            END
EXEC(@strsql)

 

CREATE PROCEDURE [dbo].[dnt_gettopiclistbynumber]
( 
@orderfield varchar(100),
@pageindex int,
@pagesize int=16,
@strwhere varchar(200),
@ordertype bit=1
) 
AS 
Declare @tablename varchar(100);
set @tablename='dnt_topics'
Declare @fieldlist varchar(500);
set  @fieldlist=' [tid],[iconid],[title],[price],[hide],[readperm],[special],[poster],[posterid],[replies],[views],[postdatetime],[lastpost],[lastposter],[lastpostid],[lastposterid],[replies],[highlight],[digest],[displayorder],[attachment],[closed],[magic],[rate]'
Declare @keyfield varchar(100);
set  @keyfield=' tid'
 SET NOCOUNT ON 
    declare @sqlstr varchar(6000) 
    set @strwhere=replace(@strwhere,'''','''''') 
    set @strwhere=replace(@strwhere,'--','') 
    set @strwhere=replace(@strwhere,';','') 
    set @sqlstr='declare @CurPageNum int;' 
    set @sqlstr=@sqlstr+'declare @nextpagenum int;' 
    set @sqlstr=@sqlstr+'set @curpagenum='+cast(@PageIndex as varchar)+'*'+cast(@Pagesize as varchar)+';' 
    set @sqlstr=@sqlstr+'set @nextpagenum='+cast(@PageIndex+1 as varchar)+'*'+cast(@Pagesize as varchar)+';' 
    set @sqlstr=@sqlstr+'declare @sqlstr varchar(6000);' 
    if @ordertype=1 
    begin 
    set @sqlstr=@sqlstr+'set @sqlstr=''select '+@fieldlist+' from ( select top ''+cast(@nextpagenum as varchar)+'' * from  
 
'+@tablename+'  where '+@strwhere+' order by '+@orderfield+' desc ) as a where '+@keyfield+' not in (  
 
select top ''+cast(@curpagenum as varchar)+'' '+@keyfield+' from '+@tablename+' where '+@strwhere+'  
 
order by '+@orderfield+' desc) order by '+@orderfield+' desc'';' 
    end 
    else 
    begin 
    set @sqlstr=@sqlstr+'set @sqlstr=''select '+@fieldlist+' from ( select top ''+cast(@nextpagenum as varchar)+'' * from  
 
'+@tablename+'  where '+@strwhere+' order by '+@orderfield+' asc ) as a where '+@keyfield+' not in (  
 
select top ''+cast(@curpagenum as varchar)+'' '+@keyfield+' from '+@tablename+' where '+@strwhere+'  
 
order by '+@orderfield+' asc) order by '+@orderfield+' asc'';' 
    end 
    set @sqlstr=@sqlstr+'execute( @sqlstr)' 
    execute(@sqlstr)

 

CREATE PROCEDURE [dbo].[dnt_gettopiclistbytag]	
	@tagid int,
	@pageindex int,
	@pagesize int
AS
BEGIN
	DECLARE @strSQL varchar(2000)
	IF @pageindex = 1
	BEGIN
		SET @strSQL='SELECT TOP ' + STR(@pagesize) + ' [t].[tid], [t].[title],[t].[poster],[t].[posterid],[t].[fid],[t].[postdatetime],[t].[replies],[t].[views],[t].[lastposter],[t].[lastposterid],[t].[lastpost] 
		FROM [dnt_topictags] AS [tt], [dnt_topics] AS [t] 
		WHERE [t].[tid] = [tt].[tid] AND [t].[displayorder] >=0 AND [tt].[tagid] = ' + STR(@tagid) + ' 
		ORDER BY [t].[lastpostid] DESC'
	END
	ELSE
	BEGIN
		SET @strSQL='SELECT TOP ' + STR(@pagesize) + ' [t].[tid], [t].[title],[t].[poster],[t].[posterid],[t].[fid],[t].[postdatetime],[t].[replies],[t].[views],[t].[lastposter],[t].[lastposterid],[t].[lastpost] 
		FROM [dnt_topictags] AS [tt], [dnt_topics] AS [t] 
		WHERE [t].[tid] = [tt].[tid] AND [t].[displayorder] >=0 AND [tt].[tagid] = ' + STR(@tagid) + ' 
		AND [t].[lastpostid] < (SELECT MIN([lastpostid]) FROM (SELECT TOP ' + STR((@pageindex-1)*@pagesize) + ' 
		[lastpostid] FROM [dnt_topictags] AS [tt], [dnt_topics] AS [t] 
		WHERE [t].[tid] = [tt].[tid] AND [t].[displayorder] >=0 AND [tt].[tagid] = ' + STR(@tagid) + ' 
		ORDER BY [t].[lastpostid] DESC) as tblTmp) 
		ORDER BY [t].[lastpostid] DESC'
	END
	EXEC(@strSQL)
END

 

CREATE PROCEDURE [dbo].[dnt_gettopiclistbytype]
@pagesize int,
@pageindex int,
@startnum int,
@condition varchar(1000),
@ascdesc int
AS
DECLARE @strSQL varchar(5000)DECLARE @sorttype varchar(5)IF @ascdesc=0
   SET @sorttype='ASC'
ELSE
   SET @sorttype='DESC'IF @pageindex = 1
	BEGIN
		SET @strSQL = 'SELECT TOP ' + STR(@pagesize) +' [tid],[iconid],[typeid],[title],[price],[hide],[readperm],[special],[poster],[posterid],[replies],[views],[postdatetime],[lastpost],[lastposter],[lastpostid],[lastposterid],[replies],[highlight],[digest],[displayorder],[attachment],[closed],[magic],[rate] FROM [dnt_topics] WHERE  [displayorder]>=0' + @condition + ' ORDER BY [tid] '+@sorttype +',  [lastpostid] '+@sorttype
	END
ELSE
	BEGIN
		IF @sorttype='DESC'
		BEGIN
			SET @strSQL = 'SELECT TOP ' + STR(@pagesize) +' [tid],[iconid],[typeid],[title],[price],[hide],[readperm],
	
	[special],[poster],[posterid],[replies],[views],[postdatetime],[lastpost],[lastposter],
	
	[lastpostid],[lastposterid],[replies],[highlight],[digest],[displayorder],[attachment],[closed],[magic],[rate] FROM 
	
	[dnt_topics] WHERE [lastpostid] < (SELECT min([lastpostid])  FROM (SELECT TOP ' + STR
	
	((@pageindex-1)*@pagesize-@startnum) + ' [lastpostid] FROM [dnt_topics] WHERE  [displayorder]>=0' + @condition + ' ORDER BY [tid] ' + @sorttype + ' , [lastpostid] ' + @sorttype + ') AS tblTmp ) 
	
	AND  [displayorder]>=0' + @condition +'ORDER BY [tid] ' + @sorttype + ' ,  [lastpostid] ' + @sorttype
		END
		ELSE
		BEGIN
			SET @strSQL = 'SELECT TOP ' + STR(@pagesize) +' [tid],[iconid],[typeid],[title],[price],[hide],[readperm],
	
	[special],[poster],[posterid],[replies],[views],[postdatetime],[lastpost],[lastposter],
	
	[lastpostid],[lastposterid],[replies],[highlight],[digest],[displayorder],[attachment],[closed],[magic] FROM 
	
	[dnt_topics] WHERE [lastpostid] > (SELECT MAX([lastpostid])  FROM (SELECT TOP ' + STR
	
	((@pageindex-1)*@pagesize-@startnum) + ' [lastpostid] FROM [dnt_topics] WHERE  [displayorder]>=0' + @condition + ' ORDER BY [tid] ' + @sorttype + ' , [lastpostid] ' + @sorttype + ') AS tblTmp ) 
	
	AND  [displayorder]>=0' + @condition +'ORDER BY [tid] ' + @sorttype + ' ,  [lastpostid] ' + @sorttype
		END
	END
EXEC(@strSQL)

 

CREATE PROCEDURE [dbo].[dnt_gettopiclistbytypedate]
@pagesize int,
@pageindex int,
@startnum int,
@condition varchar(1000),
@orderby varchar(100),
@ascdesc int
AS DECLARE @strsql varchar(5000)
DECLARE @sorttype varchar(5)IF @ascdesc=0
   SET @sorttype='ASC'
ELSE
   SET @sorttype='DESC'IF @pageindex = 1
	BEGIN
		SET @strsql = 'SELECT TOP ' + STR(@pagesize) +' [tid],[iconid],[typeid],[title],[special],[price],[hide],[readperm],[poster],[posterid],[replies],[views],[postdatetime],[lastpost],[lastposter],[lastpostid],[lastposterid],[replies],[highlight],[digest],[displayorder],[closed],[attachment],[magic],[rate] FROM [dnt_topics] WHERE [displayorder]>=0'+@condition+' ORDER BY '+@orderby+' '+@sorttype
	END
ELSE
           IF @sorttype='DESC'
	BEGIN
		SET @strSQL = 'SELECT TOP ' + STR(@pagesize) +' [tid],[iconid],[typeid],[title],[special],[price],[hide],[readperm],[poster],[posterid],[replies],[views],[postdatetime],[lastpost],[lastposter],[lastpostid],[lastposterid],[replies],[highlight],[digest],[displayorder],[closed],[attachment],[magic],[rate] FROM [dnt_topics] WHERE ['+@orderby+'] < (SELECT min(['+@orderby+']) FROM (SELECT TOP ' + STR((@pageindex-1)*@pagesize-@startnum) + ' ['+@orderby+']  FROM [dnt_topics] WHERE  [displayorder]>=0'+@condition+' ORDER BY  '+@orderby+' '+@sorttype+')AS tblTmp ) AND [displayorder]>=0'+@condition+' ORDER BY  '+@orderby+' '+@sorttype
	END
      ELSE
             BEGIN
		SET @strSQL = 'SELECT TOP ' + STR(@pagesize) +' [tid],[iconid],[typeid],[title],[special],[price],[hide],[readperm],[poster],[posterid],[replies],[views],[postdatetime],[lastpost],[lastposter],[lastpostid],[lastposterid],[replies],[highlight],[digest],[displayorder],[closed],[attachment],[magic],[rate] FROM [dnt_topics] WHERE ['+@orderby+'] > (SELECT MAX(['+@orderby+']) FROM (SELECT TOP ' + STR((@pageindex-1)*@pagesize-@startnum) + ' ['+@orderby+'] FROM [dnt_topics] WHERE [displayorder]>=0'+@condition+' ORDER BY  '+@orderby+' '+@sorttype+')AS tblTmp ) AND [displayorder]>=0'+@condition+' ORDER BY '+@orderby+' '+@sorttype
            END EXEC(@strsql)

 

CREATE PROCEDURE [dbo].[dnt_gettopictags]
@topicid int
AS SELECT t.* FROM [dnt_tags] t, [dnt_topictags] tt WHERE tt.[tagid] = t.[tagid] AND tt.[tid] = @topicid ORDER BY [orderid]


 

CREATE PROCEDURE [dbo].[dnt_gettoptopiclist]
@fid int,
@pagesize int,
@pageindex int,
@tids varchar(500)
AS
DECLARE @strSQL varchar(5000)IF @pageindex = 1
	BEGIN
		SET @strSQL = 'SELECT TOP ' + STR(@pagesize) + '[rate], [tid],[fid],[typeid],[iconid],[title],[price],[hide],[readperm], [special],[poster],[posterid],[replies],[views],[postdatetime],[lastpost],[lastposter],[lastpostid],[lastposterid],[replies],[highlight],[digest],[displayorder],[closed],[attachment],[magic],[special] FROM [dnt_topics] WHERE [displayorder]>0 AND charindex('',''+CAST([tid] AS varchar(10))+'','' , '','+@tids+','')>0  ORDER BY [lastpost] DESC'
	END
ELSE
	BEGIN
		SET @strSQL = 'SELECT TOP ' + STR(@pagesize) + ' [rate],[tid], [fid],[typeid], [iconid], [title], [price], [hide], [readperm], [special], [poster], [posterid], [replies], [views], 
      [postdatetime], [lastpost], [lastposter], [lastpostid], [lastposterid], [replies] AS Expr1, [highlight], 
      [digest], [displayorder], [closed], [attachment],[magic],[special] FROM dnt_topics
WHERE (EXISTS   (SELECT TOP ' + STR((@pageindex-1)*@pagesize) + ' [tid]
                 FROM [dnt_topics]
                 WHERE [displayorder] > 0 AND  charindex('',''+CAST([tid] AS varchar(10))+'','' , '','+@tids+','')>0
                 ORDER BY [lastpost] DESC)) AND (displayorder > 0) AND 
      ( charindex('',''+CAST([tid] AS varchar(10))+'','' , '','+@tids+','')>0)
ORDER BY lastpost DESC'
	
	END EXEC(@strSQL)

 

 CREATE PROCEDURE [dbo].[dnt_getuseridbyemail]
@email char(50)
AS SELECT TOP 1 [uid] FROM [dnt_users] WHERE [email]=@email

 

CREATE PROCEDURE [dbo].[dnt_getuserinfo]
@uid int
AS
SELECT TOP 1 [dnt_users].*, [dnt_userfields].* FROM [dnt_users] LEFT JOIN [dnt_userfields] ON [dnt_users].[uid]=[dnt_userfields].[uid] WHERE [dnt_users].[uid]=@uid

 

 CREATE PROCEDURE [dbo].[dnt_getuserinfobyip]
@regip char(15)
AS SELECT TOP 1 [u].[uid], [u].[username], [u].[nickname], [u].[password], [u].[secques], [u].[spaceid], [u].[gender], [u].[adminid], [u].[groupid], [u].[groupexpiry], [u].[extgroupids], [u].[regip], [u].[joindate], [u].[lastip], [u].[lastvisit], [u].[lastactivity], [u].[lastpost], [u].[lastpostid], [u].[lastposttitle], [u].[posts], [u].[digestposts], [u].[oltime], [u].[pageviews], [u].[credits], [u].[extcredits1], [u].[extcredits2], [u].[extcredits3], [u].[extcredits4], [u].[extcredits5], [u].[extcredits6], [u].[extcredits7], [u].[extcredits8], [u].[avatarshowid], [u].[email], [u].[bday], [u].[sigstatus], [u].[tpp], [u].[ppp], [u].[templateid], [u].[pmsound], [u].[showemail], [u].[invisible], [u].[newpm], [u].[newpmcount], [u].[accessmasks], [u].[onlinestate], [u].[newsletter], [uf].[website], [uf].[icq], [uf].[qq], [uf].[yahoo], [uf].[msn], [uf].[skype], [uf].[location], [uf].[customstatus], [uf].[avatar], [uf].[avatarwidth], [uf].[avatarheight], [uf].[medals], [uf].[bio], [uf].[signature], [uf].[sightml], [uf].[authstr], [uf].[authtime], [uf].[authflag], [uf].[realname], [uf].[idcard], [uf].[mobile], [uf].[phone], [uf].[ignorepm] FROM [dnt_users] [u] LEFT JOIN [dnt_userfields] [uf] ON [u].[uid]=[uf].[uid] WHERE [u].[regip]=@regip ORDER BY [u].[uid] DESC

 

CREATE PROCEDURE [dbo].[dnt_getuserlist]
@pagesize int,
@pageindex int,
@orderby AS varchar(200)
AS
DECLARE @pagetop int
DECLARE @sql varchar(1000)SET @pagetop = (@pageindex-1)*@pagesize IF @pageindex = 1
	BEGIN
	SET @sql = 'SELECT TOP ' + CAST(@pagesize AS varchar(10)) + ' [dnt_users].[uid], 
									[dnt_users].[groupid],
									[dnt_users].[username], 
									[dnt_users].[nickname], 
									[dnt_users].[joindate], 
									[dnt_users].[credits], 
									[dnt_users].[posts], 
									[dnt_users].[lastactivity], 
									[dnt_users].[email], 
									[dnt_users].[oltime], 
									[dnt_userfields].[location] 
					FROM [dnt_users] LEFT JOIN [dnt_userfields] ON [dnt_userfields].[uid] = [dnt_users].[uid] ' + @orderby
	END
ELSE
	BEGIN
		SET @sql = 'SELECT TOP ' + CAST(@pagesize AS varchar(10)) + ' [dnt_users].[uid], [dnt_users].[groupid], [dnt_users].[username], [dnt_users].[nickname], [dnt_users].[joindate], [dnt_users].[credits], [dnt_users].[posts], [dnt_users].[email], [dnt_users].[lastactivity], [dnt_users].[oltime], [dnt_userfields].[location] FROM [dnt_users] LEFT JOIN [dnt_userfields] ON [dnt_userfields].[uid] = [dnt_users].[uid] WHERE [dnt_users].[uid] NOT IN (SELECT TOP ' + CAST(@pagetop AS varchar(10)) + ' [uid] FROM [dnt_users]  ' + @orderby + ') '+ replace(@orderby,'WHERE','AND')	END
	
	EXEC(@sql)

 

CREATE PROCEDURE [dbo].[dnt_neatenrelatetopic]
AS
BEGIN
	DECLARE @tagid int
	DECLARE [tag_cursor] CURSOR FOR	
	SELECT DISTINCT [tagid] FROM [dnt_topictags]
	OPEN [tag_cursor]
	FETCH NEXT FROM [tag_cursor] INTO @tagid
	WHILE @@FETCH_STATUS = 0
		BEGIN
			INSERT INTO [dnt_topictagcaches] 
			SELECT [t1].[tid],[t2].[tid],[t2].[title] FROM (SELECT [tid] FROM [dnt_topictags]
				WHERE [tagid] = @tagid) AS [t1],(SELECT [t].[tid],[t].[title] FROM [dnt_topics] AS [t],[dnt_topictags] AS [tt] 
				WHERE [tt].[tagid] = @tagid AND [t].[tid] = [tt].[tid] AND [t].[displayorder] >=0) AS [t2] 
			WHERE [t1].[tid] <> [t2].[tid] AND NOT EXISTS (SELECT 1 FROM [dnt_topictagcaches] WHERE [tid]=[t1].[tid] AND [linktid]=[t2].[tid])
						FETCH NEXT FROM [tag_cursor] INTO @tagid
		END;
	CLOSE [tag_cursor]
	DEALLOCATE [tag_cursor]END

 

CREATE PROCEDURE [dbo].[dnt_revisedebatetopicdiggs]
	@tid int,
	@opinion int,
	@count int out
AS
BEGIN
	SELECT @count=COUNT(1) FROM [dnt_postdebatefields] WHERE [tid] = @tid AND [opinion] = @opinion
	IF @opinion=1
	BEGIN
		UPDATE [dnt_debates] SET [positivediggs]= @count WHERE [tid] = @tid
	END
	ELSE
	BEGIN
		UPDATE [dnt_debates] SET [negativediggs]= @count WHERE [tid] = @tid
	END
END

 

CREATE PROCEDURE [dbo].[dnt_setlastexecutescheduledeventdatetime]
(
	@key VARCHAR(100),
	@servername VARCHAR(100),
	@lastexecuted DATETIME
)
AS
DELETE FROM [dnt_scheduledevents] WHERE ([key]=@key) AND ([lastexecuted] < DATEADD([day], - 7, GETDATE()))INSERT [dnt_scheduledevents] ([key], [servername], [lastexecuted]) Values (@key, @servername, @lastexecuted)

 

CREATE PROCEDURE [dbo].[dnt_shrinklog]  
@DBName  nchar(50) 
AS
Begin
	exec('BACKUP LOG ['+@DBName+']  WITH NO_LOG')
	exec('DBCC  SHRINKDATABASE(['+@DBName+'])')
End

 

CREATE PROCEDURE [dbo].[dnt_updateadmingroup]
	@admingid smallint,
	@alloweditpost tinyint,
	@alloweditpoll tinyint,
	@allowstickthread tinyint,
	@allowmodpost tinyint,
	@allowdelpost tinyint,
	@allowmassprune tinyint,
	@allowrefund tinyint,
	@allowcensorword tinyint,
	@allowviewip tinyint,
	@allowbanip tinyint,
	@allowedituser tinyint,
	@allowmoduser tinyint,
	@allowbanuser tinyint,
	@allowpostannounce tinyint,
	@allowviewlog tinyint,
	@disablepostctrl tinyint,
	@allowviewrealname tinyint
AS
UPDATE dnt_admingroups SET 
	[alloweditpost]=@alloweditpost,
	[alloweditpoll]=@alloweditpoll,
	[allowstickthread]=@allowstickthread,
	[allowmodpost]=@allowmodpost,
	[allowdelpost]=@allowdelpost,
	[allowmassprune]=@allowmassprune,
	[allowrefund]=@allowrefund,
	[allowcensorword]=@allowcensorword,
	[allowviewip]=@allowviewip,
	[allowbanip]=@allowbanip,
	[allowedituser]=@allowedituser,
	[allowmoduser]=@allowmoduser,
	[allowbanuser]=@allowbanuser,
	[allowpostannounce]=@allowpostannounce,
	[allowviewlog]=@allowviewlog,
	[disablepostctrl]=@disablepostctrl,
	[allowviewrealname]=@allowviewrealname
WHERE [admingid]=@admingid

 

CREATE PROCEDURE [dbo].[dnt_updateonlineaction] 
@action smallint,
@lastupdatetime datetime,
@forumid int,
@forumname nvarchar(100),
@titleid int,
@title nvarchar(160),
@olid int
AS UPDATE [dnt_online] SET [lastactivity]=[action],[action]=@action,[lastupdatetime]=@lastupdatetime,[forumid]=@forumid,[forumname]=@forumname,[titleid]=@titleid,[title]=@title WHERE [olid]=@olid


 

CREATE PROCEDURE [dbo].[dnt_updatepost1]
	@pid int,
	@title nvarchar(160),
	@message ntext,
	@lastedit nvarchar(50),
	@invisible int,
	@usesig int,
	@htmlon int,
	@smileyoff int,
	@bbcodeoff int,
	@parseurloff int
AS
UPDATE dnt_posts1 SET 
	[title]=@title,
	[message]=@message,
	[lastedit]=@lastedit,
	[invisible]=@invisible,
	[usesig]=@usesig,
	[htmlon]=@htmlon,
	[smileyoff]=@smileyoff,
	[bbcodeoff]=@bbcodeoff,
	[parseurloff]=@parseurloff WHERE [pid]=@pid

 

CREATE PROCEDURE [dbo].[dnt_updatetopic]
	@tid int,
	@fid smallint,
	@iconid smallint,
	@title nchar(60),
	@typeid smallint,
	@readperm int,
	@price smallint,
	@poster char(20),
	@posterid int,
	@postdatetime smalldatetime,
	@lastpost smalldatetime,
	@lastposter char(20),
	@replies int,
	@displayorder int,
	@highlight varchar(500),
	@digest int,
	@rate int,
	@hide int,
    @special int,
	@attachment int,
	@moderated int,
	@closed int,
	@magic int
AS
UPDATE dnt_topics SET
	[fid]=@fid,
	[iconid]=@iconid,
	[title]=@title,
	[typeid]=@typeid,
	[readperm]=@readperm,
	[price]=@price,
	[poster]=@poster,
	[posterid]=@posterid,
	[postdatetime]=@postdatetime,
	[lastpost]=@lastpost,
	[lastposter]=@lastposter,
	[replies]=@replies,
	[displayorder]=@displayorder,
	[highlight]=@highlight,
	[digest]=@digest,
	[rate]=@rate,
	[hide]=@hide,
    [special]=@special,
	[attachment]=@attachment,
	[moderated]=@moderated,
	[closed]=@closed,
	[magic]=@magic WHERE [tid]=@tid 


 

CREATE PROCEDURE [dbo].[dnt_updatetopicviewcount]
@tid int,
@viewcount int
AS
UPDATE [dnt_topics]  SET [views]= [views] + @viewcount WHERE [tid]=@tid

 

CREATE PROCEDURE [dbo].[dnt_updateuser]
@username nchar(20),
@nickname nchar(20),
@password char(32),
@secques char(8),
@spaceid int,
@gender int,
@adminid int,
@groupid smallint,
@groupexpiry int,
@extgroupids char(60),
@regip char(15),
@joindate char(19),
@lastip char(15),
@lastvisit char(19),
@lastactivity char(19),
@lastpost char(19),
@lastpostid int,
@lastposttitle nchar(60),
@posts int,
@digestposts smallint,
@oltime int,
@pageviews int,
@credits int,
@extcredits1 float,
@extcredits2 float,
@extcredits3 float,
@extcredits4 float,
@extcredits5 float,
@extcredits6 float,
@extcredits7 float,
@extcredits8 float,
@avatarshowid int,
@email char(50),
@bday char(19),
@sigstatus int,
@tpp int,
@ppp int,
@templateid smallint,
@pmsound int,
@showemail int,
@newsletter int,
@invisible int,
@newpm int,
@newpmcount int,
@accessmasks int,
@onlinestate int,
@website varchar(80),
@icq varchar(12),
@qq varchar(12),
@yahoo varchar(40),
@msn varchar(40),
@skype varchar(40),
@location nvarchar(30),
@customstatus varchar(30),
@avatar varchar(255),
@avatarwidth int,
@avatarheight int,
@medals varchar(300),
@bio nvarchar(500),
@signature nvarchar(500),
@sightml nvarchar(1000),
@authstr varchar(20),
@authtime smalldatetime,
@authflag tinyint,
@realname nvarchar(10),
@idcard varchar(20),
@mobile varchar(20),
@phone varchar(20),
@ignorepm nvarchar(1000),
@uid int
AS UPDATE [dnt_users] SET [username]=@username,[nickname]=@nickname, [password]=@password, [secques]=@secques, [spaceid]=@spaceid, [gender]=@gender, [adminid]=@adminid, [groupid]=@groupid, [groupexpiry]=@groupexpiry, 
[extgroupids]=@extgroupids, [regip]= @regip, [joindate]= @joindate, [lastip]=@lastip, [lastvisit]=@lastvisit, [lastactivity]=@lastactivity, [lastpost]=@lastpost, 
[lastpostid]=@lastpostid, [lastposttitle]=@lastposttitle, [posts]=@posts, [digestposts]=@digestposts, [oltime]=@oltime, [pageviews]=@pageviews, [credits]=@credits, 
[extcredits1]=@extcredits1, [extcredits2]=@extcredits2, [extcredits3]=@extcredits3, [extcredits4]=@extcredits4, [extcredits5]=@extcredits5, [extcredits6]=@extcredits6, 
[extcredits7]=@extcredits7, [extcredits8]=@extcredits8, [avatarshowid]=@avatarshowid, [email]=@email, [bday]=@bday, [sigstatus]=@sigstatus, [tpp]=@tpp, [ppp]=@ppp, 
[templateid]=@templateid, [pmsound]=@pmsound, [showemail]=@showemail, [newsletter]=@newsletter, [invisible]=@invisible, [newpm]=@newpm, [newpmcount]=@newpmcount, [accessmasks]=@accessmasks, [onlinestate]=@onlinestate 
WHERE [uid]=@uid UPDATE [dnt_userfields] SET [website]=@website,[icq]=@icq,[qq]=@qq,[yahoo]=@yahoo,[msn]=@msn,[skype]=@skype,[location]=@location,[customstatus]=@customstatus,
[avatar]=@avatar,[avatarwidth]=@avatarwidth,[avatarheight]=@avatarheight,[medals]=@medals,[bio]=@bio,[signature]=@signature,[sightml]=@sightml,[authstr]=@authstr,
[authtime]=@authtime,[authflag]=@authflag,[realname]=@realname,[idcard]=@idcard,[mobile]=@mobile,[phone]=@phone,[ignorepm]=@ignorepm 
WHERE [uid]=@uid


 

CREATE PROCEDURE [dbo].[dnt_updateuserauthstr]
	@uid int,
	@authstr char(20),
	@authflag int =1
AS
UPDATE [dnt_userfields] SET [authstr]=@authstr, [authtime] = getdate(), [authflag]=@authflag WHERE [uid]=@uid

 

CREATE PROCEDURE [dbo].[dnt_updateuserforumsetting]
	@uid int,
	@tpp int,
	@ppp int,
	@invisible int,
	@customstatus varchar(30),
	@sigstatus int,
	@signature nvarchar(500),
	@sightml nvarchar(1000)
AS
UPDATE [dnt_users] SET [tpp]=@tpp, [ppp]=@ppp, [invisible]=@invisible,[sigstatus]=@sigstatus WHERE [uid]=@uid
UPDATE [dnt_userfields] SET [signature]=@signature,[sightml] = @sightml,[customstatus]=@customstatus WHERE [uid]=@uid

 

CREATE PROCEDURE [dbo].[dnt_updateuseronlinestates] 
@uidlist varchar(5000) = '' 
AS EXEC('UPDATE [dnt_users] SET [onlinestate]=0,[lastactivity]=GETDATE() WHERE [uid] IN (' + @uidlist + ')')

 

CREATE PROCEDURE [dbo].[dnt_updateuserpassword]
	@uid int,
	@password char(44)
AS
UPDATE [dnt_users] SET [password]=@password WHERE [uid]=@uid

 

CREATE PROCEDURE [dbo].[dnt_updateuserpreference]
	@uid int,
	@avatar varchar(255),
	@avatarwidth int,
	@avatarheight int,
	@templateid int
AS
UPDATE [dnt_userfields] SET [avatar]=@avatar, [avatarwidth]=@avatarwidth, [avatarheight]=@avatarheight WHERE [uid]=@uid
UPDATE [dnt_users] SET [templateid]=@templateid WHERE [uid]=@uid

 

CREATE PROCEDURE [dbo].[dnt_updateuserprofile]
	@uid int,
	@nickname nchar(20),
	@gender int,
	@email char(50),
	@bday char(10),
	@showemail int,
	@website nvarchar(80),
	@icq varchar(12),
	@qq varchar(12),
	@yahoo varchar(40),
	@msn varchar(40),
	@skype varchar(40),
	@location nvarchar(30),
	@bio nvarchar(500),
	@realname nvarchar(10),
	@idcard varchar(20),
	@mobile varchar(20),
	@phone varchar(20)
AS
UPDATE [dnt_users] SET [nickname]=@nickname, [gender]=@gender , [email]=@email , [bday]=@bday, [showemail]=@showemail WHERE [uid]=@uid
UPDATE [dnt_userfields] SET [website]=@website , [icq]=@icq , [qq]=@qq , [yahoo]=@yahoo , [msn]=@msn , [skype]=@skype , [location]=@location , [bio]=@bio,[realname]=@realname,[idcard]=@idcard,[mobile]=@mobile,[phone]=@phone  WHERE [uid]=@uid

 

CREATE FUNCTION [dbo].[dnt_split]
(
 @splitstring NVARCHAR(4000),
 @separator CHAR(1) = ','
)
RETURNS @splitstringstable TABLE
(
 [item] NVARCHAR(200)
)
AS
BEGIN
    DECLARE @currentindex INT
    DECLARE @nextindex INT
    DECLARE @returntext NVARCHAR(200)

    SELECT @currentindex=1

    WHILE(@currentindex<=datalength(@splitstring)/2)
    BEGIN
        SELECT @nextindex=charindex(@separator,@splitstring,@currentindex)
        IF(@nextindex=0 OR @nextindex IS NULL)
            SELECT @nextindex=datalength(@splitstring)/2+1
        
        SELECT @returntext=substring(@splitstring,@currentindex,@nextindex-@currentindex)

        INSERT INTO @splitstringstable([item])
        VALUES(@returntext)
        
        SELECT @currentindex=@nextindex+1
    END
    RETURN
END