﻿<%@ page language="C#" autoeventwireup="true" inherits="V5Shop.Admin.Product_StockLog_Manage, V5Shop.Shop.Category" enableviewstatemac="false" enableEventValidation="false" viewStateEncryptionMode="Never" %>

<%@ Register Src="control/ManageHeader.ascx" TagName="ManageHeader" TagPrefix="uc3" %>
<%@ Register Src="control/PageBottom.ascx" TagName="PageBottom" TagPrefix="uc2" %>
<%@ Register Src="control/HiddenField.ascx" TagName="HiddenField" TagPrefix="uc1" %>
<%@ Register TagPrefix="V5Shop" Namespace="V5Shop.Control" Assembly="V5Shop.Control" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title></title>
    <link href="css/css.css" rel="stylesheet" type="text/css" />
    <link href="css/css_list.css" rel="stylesheet" type="text/css" />
    <link href="css/control.css" rel="stylesheet" type="text/css" />

    <script type="text/javascript" language="javascript" src="js/Common.js"></script>

    <script type="text/javascript" language="javascript" src="js/Control_Calendar.js"></script>

</head>
<body>
    <form id="form1" runat="server">
        <uc3:ManageHeader ID="ManageHeader1" runat="server" />
        <div>
            <div id="search">
                <div style="padding: 10px 20px; border: 1px #eeeeee solid; background: #f7f7f7">
                    <asp:Label ID="lblName" runat="server" Text="商品名称："></asp:Label><asp:TextBox ID="txtName" runat="server"></asp:TextBox>
                    <asp:Label ID="lblDate" runat="server" Text="操作时间："></asp:Label><asp:TextBox ID="txtStartDate" runat="server"></asp:TextBox>
                    <img id="sltStart" src="images/calendar1.gif" title="打开日历" alt="打开日历" align="absmiddle" />
                    <asp:RegularExpressionValidator ID="RegularExpressionValidator1" ControlToValidate="txtStartDate"
                        runat="server" ErrorMessage="日期格式不正确" ValidationExpression="^\d{4}-\d{2}-\d{2}$"
                        Display="Dynamic"></asp:RegularExpressionValidator>-
                    <asp:TextBox ID="txtEndDate" runat="server"></asp:TextBox>
                    <img id="sltEnd" src="images/calendar1.gif" title="打开日历" alt="打开日历" align="absmiddle" />
                    <asp:RegularExpressionValidator ID="RegularExpressionValidator2" ControlToValidate="txtEndDate"
                        runat="server" ErrorMessage="日期格式不正确" ValidationExpression="^\d{4}-\d{2}-\d{2}$"
                        Display="Dynamic"></asp:RegularExpressionValidator>
                    <asp:Label ID="lblIsOut" runat="server" Text="操作类型："></asp:Label><asp:DropDownList ID="ddlIsOut" runat="server">
                    </asp:DropDownList>
                    <asp:Button ID="btnSearch" runat="server" Text="查询" CssClass="button" OnClick="btnSearch_Click" />
                </div>
            </div>
            <div id="content">
                <div style="padding: 3px 25px; color: #4B6888; border-bottom: 1px #CCCCCC solid">
                    <input type="checkbox" id="CheckAllBox" onclick="CheckAll()" class="checkbox" />
                    全选
　
<asp:LinkButton ID="btnAdd" runat="server" ForeColor="#4B6888" OnClick="btnAdd_Click"><img src="images/icon/key_add.gif" /> 添加</asp:LinkButton>
　
<asp:LinkButton ID="btnDel" runat="server" ForeColor="#4B6888" OnClick="btnDel_Click"
                        OnClientClick="return CheckDel()"><img src="images/icon/key_delete.gif" /> 删除</asp:LinkButton></div>
                <div class="listborder">
                    <V5Shop:V5ShopGridView ID="GridViewShow" runat="server" AllowPaging="True" AllowSorting="True"
                        AutoGenerateColumns="False" CssClass="datalist" HeaderStyle-Height="18px" HeaderStyle-ForeColor="#000"
                        EmptyDataText="没有查询到任何记录" TableName="StockLog" CacheName="StockLog" PageSize="12"
                        BorderWidth="0px" GridLines="None" Width="100%">
                        <Columns>
                            <asp:TemplateField>
                                <itemstyle horizontalalign="Center" width="3%" />
                                <itemtemplate>
                            <input runat="server" Value='<%# Eval("ID") %>' ID="CheckBoxID" type="checkbox" onmouseover="this.mouse='over'" onmouseout="this.mouse='out'" mouse="out" class="checkbox">
</itemtemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="ID" SortExpression="ID">
                                <itemstyle width="6%" />
                                <itemtemplate>
<asp:Label runat="server" Text='<%# Bind("ID") %>' id="ID"></asp:Label>
</itemtemplate>
                            </asp:TemplateField>
                            <asp:BoundField DataField="ProductName" SortExpression="ProductName" HeaderText="商品名称">
                            </asp:BoundField>
                            <asp:BoundField DataField="Count" SortExpression="Count" HeaderText="入库数量"></asp:BoundField>
                            <asp:BoundField DataField="UserName" HeaderText="操作人" SortExpression="UserName" />
                            <asp:TemplateField HeaderText="操作类型" SortExpression="IsOut">
                                <itemtemplate>
<asp:Label runat="server" Text='<%# FormatIsOut(DataBinder.Eval(Container,"DataItem(IsOut)","{0}")) %>' id="Label1"></asp:Label>
</itemtemplate>
                            </asp:TemplateField>
                            <asp:BoundField DataField="Date" HeaderText="操作时间" SortExpression="Date" />
                        </Columns>
                        <PagerSettings Mode="NumericFirstLast" />
                        <HeaderStyle CssClass="category" ForeColor="Black" Height="18px" />
                    </V5Shop:V5ShopGridView>
                </div>
            </div>
            <div id="hiddenfield">
                <asp:HiddenField ID="CheckedIDS" runat="server" Value="0" />
                <asp:HiddenField ID="PageIndex" runat="server" Value="0" />
                <asp:HiddenField ID="MaxPageIndex" runat="server" Value="0" />
                <uc1:HiddenField ID="Alert" runat="server" />
            </div>
            <uc2:PageBottom ID="PageBottom1" runat="server" />
        </div>

        <script type="text/javascript">
        Calendar.setup({
	        inputField     :    "txtStartDate",
	        ifFormat       :    "%Y-%m-%d", 
	        button         :    "sltStart",
	        align          :    "Br",
	        singleClick    :    true
        });
        Calendar.setup({
	        inputField     :    "txtEndDate",
	        ifFormat       :    "%Y-%m-%d", 
	        button         :    "sltEnd",
	        align          :    "Br",
	        singleClick    :    true
        });
        </script>

    </form>
</body>
</html>
