﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Configuration;
using System.Web;
public class StaticFileCacheModule : IHttpModule
{
    private void context_BeginRequest(object sender, EventArgs e)
    {
        HttpContext context = ((HttpApplication)sender).Context;
        if (context.Request.AppRelativeCurrentExecutionFilePath.ToLower().EndsWith(".aspx"))
        {
            string fileUrl = "~/CacheFile/";
            string fileName = GetFileName(context);
            string filePath = context.Server.MapPath(fileUrl) + fileName;
            if (File.Exists(filePath) && (DateTime.Compare(File.GetLastWriteTime(filePath).AddDays(1.0), DateTime.Now) > 0))
            {
                context.RewritePath(fileUrl + fileName, false);
            }
        }
    }

    public void Dispose()
    {
    }

    public static string GetFileName(HttpContext context)
    {
        return (context.Request.AppRelativeCurrentExecutionFilePath.ToLower().Replace(".aspx", "").Replace("~/", "") + context.Request.Url.Query.Replace("?", "__").Replace("&", "_").Replace("/", "").Replace(@"\", "") + ".html");
    }

    public void Init(HttpApplication context)
    {
        context.BeginRequest += new EventHandler(this.context_BeginRequest);
    }
}