﻿namespace TaoBaoAPI
{
    using System;
    using System.Xml;
    using Taobao.Top.Api;
    using Taobao.Top.Api.Request;

    public class TaoBaoProd
    {
        private static string app_key = Config.app_key;
        private static string app_secret = Config.app_secret;
        private static string nick = Config.nick;

        public static XmlNode GetItemGet(string nick, string iid)
        {
            XmlNode node = null;
            int appKeyCount = Utility.AppKeyCount();
            if (appKeyCount == 0)
            {
                try
                {
                    node = GetItemGet(nick, iid, app_key, app_secret);
                }
                catch
                {
                    return null;
                }
                return node;
            }
            int tryCount = 0;
            while (tryCount < appKeyCount)
            {
                try
                {
                    return GetItemGet(nick, iid, Utility.ArrAppKey(tryCount), Utility.ArrAppSecret(tryCount));
                }
                catch
                {
                    tryCount++;
                }
            }
            return node;
        }

        public static XmlNode GetItemGet(string nick, string iid, string appKey, string appSecret)
        {
            TopXmlRestClient client = new TopXmlRestClient("http://gw.api.taobao.com/router/rest", appKey, appSecret);
            ItemGetRequest req = new ItemGetRequest();
            req.Fields = "iid,detail_url,num_iid,title,nick,type,cid,seller_cids,props,input_pids,input_str,desc,pic_url,num,valid_thru,list_time,delist_time,stuff_status,location,price,post_fee,express_fee,ems_fee,has_discount,freight_payer,has_invoice,has_warranty,has_showcase,modified,increment,auto_repost,approve_status,postage_id,product_id,auction_point,property_alias,itemimg,propimg,sku,outer_id,is_virtural,is_taobao,is_ex,video";
            req.Nick = nick;
            req.Iid = iid;
            string rsp = client.GetResponse(req);
            XmlDocument xmlDocument = new XmlDocument();
            xmlDocument.LoadXml(rsp);
            return xmlDocument.DocumentElement.ChildNodes.Item(0);
        }

        public static XmlNode GetItemsSearch(string nick)
        {
            XmlNode node = null;
            int appKeyCount = Utility.AppKeyCount();
            if (appKeyCount == 0)
            {
                try
                {
                    node = GetItemsSearch(nick, app_key, app_secret);
                }
                catch
                {
                    return null;
                }
                return node;
            }
            int tryCount = 0;
            while (tryCount < appKeyCount)
            {
                try
                {
                    return GetItemsSearch(nick, app_key, app_secret);
                }
                catch
                {
                    tryCount++;
                }
            }
            return node;
        }

        public static XmlNode GetItemsSearch(string nick, string appKey, string appSecret)
        {
            TopXmlRestClient client = new TopXmlRestClient("http://gw.api.taobao.com/router/rest", appKey, appSecret);
            ItemsSearchRequest req = new ItemsSearchRequest();
            req.Fields = "iid,title,cid,pic_path,price,seller_cids,desc,sku";
            req.Nicks = nick;
            string rsp = client.GetResponse(req);
            XmlDocument xmlDocument = new XmlDocument();
            xmlDocument.LoadXml(rsp);
            return xmlDocument.DocumentElement.ChildNodes.Item(0);
        }
    }
}

