﻿namespace TaoBaoAPI
{
    using System;
    using System.Xml;
    using Taobao.Top.Api;
    using Taobao.Top.Api.Request;

    public class TaoBaoShop
    {
        private static string app_key = Config.app_key;
        private static string app_secret = Config.app_secret;
        private static string nick = Config.nick;

        public static XmlNode GetShopGet(string nick)
        {
            XmlNode node = null;
            int appKeyCount = Utility.AppKeyCount();
            if (appKeyCount == 0)
            {
                try
                {
                    node = GetShopGet(nick, app_key, app_secret);
                }
                catch
                {
                    return null;
                }
                return node;
            }
            int tryCount = 0;
            while (tryCount < appKeyCount)
            {
                try
                {
                    return GetShopGet(nick, Utility.ArrAppKey(tryCount), Utility.ArrAppSecret(tryCount));
                }
                catch
                {
                    tryCount++;
                }
            }
            return node;
        }

        public static XmlNode GetShopGet(string nick, string appKey, string appSecret)
        {
            TopXmlRestClient client = new TopXmlRestClient("http://gw.api.taobao.com/router/rest", appKey, appSecret);
            ShopGetRequest req = new ShopGetRequest();
            req.Fields = "sid,cid,nick,title,desc,bulletin,pic_path,created,modified";
            req.Nick = nick;
            string rsp = client.GetResponse(req);
            XmlDocument xmlDocument = new XmlDocument();
            xmlDocument.LoadXml(rsp);
            return xmlDocument.SelectNodes("shop_get_response/shop").Item(0);
        }
    }
}

