﻿namespace TaoBaoAPI
{
    using System;
    using System.Collections;
    using System.IO;
    using System.Net;
    using System.Text;
    using System.Web;

    public class Tools
    {
        public static void CreateHtml(string url, string saveFile)
        {
            Exception ex;
            Encoding code = Encoding.GetEncoding("UTF-8");
            string strHtmlCode = string.Empty;
            StreamReader sr = null;
            WebResponse myTemp = WebRequest.Create(url).GetResponse();
            sr = new StreamReader(myTemp.GetResponseStream(), code);
            try
            {
                sr = new StreamReader(myTemp.GetResponseStream(), code);
                strHtmlCode = sr.ReadToEnd();
            }
            catch (Exception exception1)
            {
                ex = exception1;
                throw ex;
            }
            finally
            {
                sr.Close();
            }
            StreamWriter writerHtml = null;
            try
            {
                writerHtml = new StreamWriter(saveFile, false, code);
                writerHtml.Write(strHtmlCode);
                writerHtml.Flush();
            }
            catch (Exception exception2)
            {
                ex = exception2;
                throw ex;
            }
            finally
            {
                writerHtml.Close();
            }
        }

        public static string dfCheckInput(string strTemp)
        {
            try
            {
                return strTemp.Trim().Replace("'", "").Replace("<", "〈").Replace(">", "〉");
            }
            catch
            {
                return "";
            }
        }

        public static string dfObjectToStr(object objTemp)
        {
            try
            {
                return objTemp.ToString().Trim();
            }
            catch
            {
                return "";
            }
        }

        public static bool dfStrToBoolean(string str)
        {
            bool result;
            return (bool.TryParse(str, out result) && result);
        }

        public static byte dfStrToByte(string str)
        {
            byte result;
            if (byte.TryParse(str, out result))
            {
                return result;
            }
            return 0;
        }

        public static DateTime dfStrToDateTime(string str)
        {
            DateTime result;
            if (DateTime.TryParse(str, out result))
            {
                return result;
            }
            return new DateTime(0x7d0, 1, 1);
        }

        public static decimal dfStrToDecimal(string str)
        {
            decimal result;
            if (decimal.TryParse(str, out result))
            {
                return result;
            }
            return 0M;
        }

        public static double dfStrToDouble(string str)
        {
            double result;
            if (double.TryParse(str, out result))
            {
                return result;
            }
            return 0.0;
        }

        public static short dfStrToInt16(string str)
        {
            short result;
            if (short.TryParse(str, out result))
            {
                return result;
            }
            return 0;
        }

        public static int dfStrToInt32(string str)
        {
            int result;
            if (int.TryParse(str, out result))
            {
                return result;
            }
            return 0;
        }

        public static long dfStrToInt64(string str)
        {
            long result;
            if (long.TryParse(str, out result))
            {
                return result;
            }
            return 0L;
        }

        public static string dfStrToSQL(string str)
        {
            return str.Replace("'", "''");
        }

        public static string dfStrToTrimStr(string str)
        {
            if (str == null)
            {
                return string.Empty;
            }
            return str.Trim();
        }

        public static string FilterSpan(string title)
        {
            return title.Replace("<span class=H>", " ").Replace("</span>", " ");
        }

        public static string InterceptStr(string str, int lenght)
        {
            if (str.Length > lenght)
            {
                return str.Substring(0, lenght);
            }
            return str;
        }

        public static string InterceptStr(string str, int lenght, string spilth)
        {
            if (str.Length > lenght)
            {
                return (str.Substring(0, lenght) + spilth);
            }
            return str;
        }

        public static bool ValidGeneral(string str)
        {
            string FILE_NAME = HttpContext.Current.Server.MapPath("/App_Data/mingan.txt");
            if (System.IO.File.Exists(FILE_NAME))
            {
                StreamReader objReader = new StreamReader(FILE_NAME, Encoding.GetEncoding("gb2312"));
                string sLine = "";
                ArrayList arrText = new ArrayList();
                while (sLine != null)
                {
                    sLine = objReader.ReadLine();
                    if (sLine != null)
                    {
                        arrText.Add(sLine);
                    }
                }
                objReader.Close();
                foreach (string sOutput in arrText)
                {
                    string[] strArr = sOutput.Split(new char[] { '|' });
                    for (int i = 0; i < strArr.Length; i++)
                    {
                        if (Config.matching == "1")
                        {
                            if (strArr[i] == str)
                            {
                                return true;
                            }
                        }
                        else if (str.Contains(strArr[i]))
                        {
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        public static bool ValidGeneralUrl(string url)
        {
            string FILE_NAME = HttpContext.Current.Server.MapPath("/App_Data/minganUrl.txt");
            if (System.IO.File.Exists(FILE_NAME))
            {
                StreamReader objReader = new StreamReader(FILE_NAME, Encoding.GetEncoding("gb2312"));
                string sLine = "";
                ArrayList arrText = new ArrayList();
                while (sLine != null)
                {
                    sLine = objReader.ReadLine();
                    if (sLine != null)
                    {
                        arrText.Add(sLine);
                    }
                }
                objReader.Close();
                foreach (string sOutput in arrText)
                {
                    string[] strArr = sOutput.Split(new char[] { '|' });
                    for (int i = 0; i < strArr.Length; i++)
                    {
                        if (strArr[i] == url)
                        {
                            return true;
                        }
                    }
                }
            }
            return false;
        }
    }
}

