﻿using System;
using System.Configuration;
using System.Web;
using System.Xml;
using TaoBaoAPI;

namespace TaoHuoNet
{
    public partial class BaoBei : System.Web.UI.Page
    {
        public string approve_status;
        public string auction_point;
        public string auto_repost;
        public string cid;
        public string click_url;
        public string commission;
        public string delist_time;
        public string desc;
        public string detail_url;
        public string ems_fee;
        public string express_fee;
        public string freight_payer;
        public string has_discount;
        public string has_invoice;
        public string has_showcase;
        public string has_warranty;
        public string iid;
        public string increment;
        public string input_pids;
        public string input_str;
        public string is_virtural;
        public string itemimg;
        public string list_time;
        public string location;
        public string modified;
        public string nick;
        public string nick_mj;
        public string num;
        public string num_iid;
        public string pic_path;
        public string post_fee;
        public string postage_id;
        public string price;
        public string product_id;
        public string property_alias;
        public string propimg;
        public string props;
        public string seller_cids;
        public string shop_click_url;
        public string siteName;
        public string sku;
        public string stuff_status;
        public string title;
        public string type;
        public string user_id;
        public string valid_thru;
        public string video;

        private void BindHot(int cid)
        {
            TaoBaoKe tbk = new TaoBaoKe();
            tbk.Cid = cid.ToString();
            tbk.Sort = "commissionNum_desc";
            tbk.Page_size = "4";
            this.rptHot.DataSource = TaoBaoKe.GetItemsGet(tbk);
            this.rptHot.DataBind();
        }

        private void BindOldProd(string nick, string iid)
        {
            XmlNode xmlNode = TaoBaoProd.GetItemGet(nick, iid);
            if (xmlNode != null)
            {
                this.title = xmlNode["title"].InnerText;
                if (Tools.ValidGeneral(this.title) || Tools.ValidGeneralUrl(base.Request["nick"] + "-" + iid))
                {
                    base.Response.Redirect("index.aspx");
                }
                else
                {
                    this.nick_mj = xmlNode["nick"].InnerText;
                    this.type = xmlNode["type"].InnerText;
                    this.cid = xmlNode["cid"].InnerText;
                    this.desc = xmlNode["desc"].InnerText;
                    this.pic_path = xmlNode["pic_url"].InnerText;
                    this.num = xmlNode["num"].InnerText;
                    this.valid_thru = xmlNode["valid_thru"].InnerText;
                    this.list_time = xmlNode["list_time"].InnerText;
                    this.delist_time = xmlNode["delist_time"].InnerText;
                    this.stuff_status = xmlNode["stuff_status"].InnerText;
                    this.location = xmlNode["location"].InnerText;
                    this.price = xmlNode["price"].InnerText;
                    this.post_fee = xmlNode["post_fee"].InnerText;
                    this.express_fee = xmlNode["express_fee"].InnerText;
                    this.ems_fee = xmlNode["ems_fee"].InnerText;
                    this.has_discount = xmlNode["has_discount"].InnerText;
                    this.freight_payer = xmlNode["freight_payer"].InnerText;
                    this.has_invoice = xmlNode["has_invoice"].InnerText;
                    this.has_warranty = xmlNode["has_warranty"].InnerText;
                    this.shop_click_url = "/GoShop.aspx?nick=" + Utility.EncodingString(nick);
                    this.BindHot(Tools.dfStrToInt32(this.cid));
                }
            }
        }

        private void BindProd(string num_iids)
        {
            XmlNode xmlNode = TaoBaoKe.GetItemsDetail(num_iids);
            if (xmlNode != null)
            {
                this.title = xmlNode.FirstChild.NextSibling["title"].InnerText;
                if ((Tools.ValidGeneral(this.title) || Tools.ValidGeneralUrl(num_iids)) || Tools.ValidGeneralUrl(base.Request["nick"] + "-" + num_iids))
                {
                    base.Response.Redirect("index.aspx");
                }
                else
                {
                    this.nick_mj = xmlNode.FirstChild.NextSibling["nick"].InnerText;
                    this.type = xmlNode.FirstChild.NextSibling["type"].InnerText;
                    this.cid = xmlNode.FirstChild.NextSibling["cid"].InnerText;
                    this.desc = xmlNode.FirstChild.NextSibling["desc"].InnerText;
                    this.pic_path = xmlNode.FirstChild.NextSibling["pic_url"].InnerText;
                    this.num = xmlNode.FirstChild.NextSibling["num"].InnerText;
                    this.valid_thru = xmlNode.FirstChild.NextSibling["valid_thru"].InnerText;
                    this.list_time = xmlNode.FirstChild.NextSibling["list_time"].InnerText;
                    this.delist_time = xmlNode.FirstChild.NextSibling["delist_time"].InnerText;
                    this.stuff_status = xmlNode.FirstChild.NextSibling["stuff_status"].InnerText;
                    this.location = xmlNode.FirstChild.NextSibling["location"].InnerText;
                    this.price = xmlNode.FirstChild.NextSibling["price"].InnerText;
                    this.post_fee = xmlNode.FirstChild.NextSibling["post_fee"].InnerText;
                    this.express_fee = xmlNode.FirstChild.NextSibling["express_fee"].InnerText;
                    this.ems_fee = xmlNode.FirstChild.NextSibling["ems_fee"].InnerText;
                    this.has_discount = xmlNode.FirstChild.NextSibling["has_discount"].InnerText;
                    this.freight_payer = xmlNode.FirstChild.NextSibling["freight_payer"].InnerText;
                    this.has_invoice = xmlNode.FirstChild.NextSibling["has_invoice"].InnerText;
                    this.has_warranty = xmlNode.FirstChild.NextSibling["has_warranty"].InnerText;
                    this.click_url = Utility.EncodingString(xmlNode["click_url"].InnerText);
                    if (string.IsNullOrEmpty(this.click_url))
                    {
                        this.click_url = Utility.EncodingString("/GoBuy.aspx?iid=" + num_iids);
                    }
                    this.seller_cids = xmlNode["seller_credit_score"].InnerText;
                    this.shop_click_url = Utility.EncodingString(xmlNode["shop_click_url"].InnerText);
                    if (string.IsNullOrEmpty(this.shop_click_url))
                    {
                        this.shop_click_url = Utility.EncodingString("/GoShop.aspx?nick=" + HttpUtility.UrlEncode(this.nick_mj));
                    }
                    this.BindHot(Tools.dfStrToInt32(this.cid));
                }
                Page.Title = title + " - " + TaoBaoItem.GetParentItemCats(this.cid)["name"].InnerText + " - " + this.siteName;

            }
        }

        private void BindUser(string nick)
        {
            XmlNode userNode = TaoBaoUser.GetUser(nick);
            if (userNode != null)
            {
                this.user_id = userNode["user_id"].InnerText;
                this.seller_cids = userNode.ChildNodes[6]["level"].InnerText;
            }
        }

        public string GetStuff(string stuff)
        {
            if (stuff == "new")
            {
                return "全新";
            }
            if (stuff == "unused")
            {
                return "闲置";
            }
            return "二手";
        }

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!this.Page.IsPostBack && (base.Request["iid"] != null))
            { 
                this.siteName = ConfigurationManager.AppSettings["siteName"];
                string num_iids = Tools.dfObjectToStr(base.Request["iid"]);
                if (base.Request["nick"] != null)
                {
                    this.nick = Tools.dfObjectToStr(Utility.DecodingString(base.Request["nick"]));
                    this.BindOldProd(this.nick, num_iids);
                    this.BindUser(this.nick);
                    this.click_url = "/GoBuy.aspx?iid=" + num_iids;
                }
                else
                {
                    this.BindProd(num_iids);
                }
               
               
            }
        }

    }
}
