﻿<%@ page language="C#" validaterequest="false" masterpagefile="MyShop.master" enableeventvalidation="false" autoeventwireup="true" inherits="Shop_Manage_shop_product_category, WebApp_deploy" title="商品分类" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">
<asp:ScriptManager ID="ScriptManager1" runat="server" EnablePartialRendering ="true" />
<div class="pageTitle">店铺商品分类管理</div>    
<div class="tips_onclick"  style="width:94%">给商品分类，方便买家浏览。
<asp:LinkButton ID="LinkProductunClassed" runat="server" OnClick="LinkProductunClassed_Click" CausesValidation="False" Text="商品分类"  ForeColor="red"/>
</div>
<div>
  <asp:UpdatePanel ID="UpdatePanel1" runat="server">
      <ContentTemplate>
        <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" CssClass="tableHead" DataSourceID="ProductLikeCategory"  DataKeyNames="ShopProductClassID"
             OnDataBound="GridView1_DataBound" OnRowUpdated="GridView1_Updated">
          <Columns>
            <asp:TemplateField  HeaderText='编号'>
               <EditItemTemplate>
                  <asp:Literal ID="ShopProductClassID" runat="server" Text='<%# Bind("ShopProductClassID") %>' />
               </EditItemTemplate>  
               <ItemTemplate>                
                  <asp:Literal ID="ShopProductClassID" runat="server" Text='<%# Bind("ShopProductClassID") %>' />             
               </ItemTemplate>           
            </asp:TemplateField>
            <asp:TemplateField  HeaderText='名称'>
               <EditItemTemplate>
                  <asp:TextBox ID="TxtShopProducClassName" runat="server" Text='<%# Bind("ShopProductClassName") %>' Width="100px"/>
               </EditItemTemplate>
               <ItemTemplate>
                 <asp:Literal ID="LShopProducClassNamen" runat="server" Text='<%# Eval("ShopProductClassName") %>' />
               </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField HeaderText="排列序号" DataField="orderby" />          
            <asp:CommandField  ShowEditButton="true" HeaderText="编辑" EditText="编辑"  CausesValidation="false"/>

            <asp:CommandField  ShowDeleteButton="true" HeaderText="删除" SelectText="删除"  />
            <asp:HyperLinkField DataNavigateUrlFields="ShopProductClassID" DataNavigateUrlFormatString="Shop_ViewProductByShopProductClassID.aspx?ShopProductClassID={0}"
                HeaderText="查看商品" Text="商品列表" />
           </Columns>          
           <EmptyDataTemplate>
                 <table style="width:98%">
                 <tr>
                 <th>编号</th>
                 <th>名称</th>
                 <th>排列序号</th>
                 <th>编辑</th>
                 <th>删除</th>
                 <th>查看商品</th>
                 </tr>
                 <tr><td colspan="6">没有符合查询条件的记录！</td></tr>
                 </table>
           </EmptyDataTemplate>
        </asp:GridView>  
        <br />
        <asp:Label ID="err_tips" runat="server" />
     </ContentTemplate>
        <Triggers>
            <asp:AsyncPostBackTrigger ControlID="AddCategoryButton" EventName="Click" />
        </Triggers>
    </asp:UpdatePanel>
</div> 
<div class="SearchTableStyle">

    <asp:UpdatePanel id="UpdatePanel2" runat="server">
        <contenttemplate>
<span>
    新分类名称：<asp:TextBox ID="TxtClassName" runat="server" MaxLength="100"  Width="300px"/>
    排序<asp:TextBox ID="TxtOrderBy" runat="server" Width="40px"/>
    <asp:Button ID="AddCategoryButton" runat="server" Text="添加" OnClick="Button2_Click" /></span><br />
    (注:分类名称限定50字以内,支持HTML代码)
</contenttemplate>
    </asp:UpdatePanel>
</div>      

<div style="clear:both">
        
        <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="TxtClassName"  ErrorMessage="不能空" />
        <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="TxtOrderBy"   ErrorMessage="不能空" />
        <asp:RangeValidator ID="RangeValidator1" runat="server" ControlToValidate="TxtOrderBy" ErrorMessage="必须为正整数" MaximumValue="9999" MinimumValue="1" Type="Integer"/>
</div>
<asp:ObjectDataSource ID="ProductLikeCategory" runat="server" DeleteMethod="DeleteProductLikeCategory"
       InsertMethod="InsertProductLikeCategory" SelectMethod="GetProductLikeCategory"
       TypeName="HoWave.Web.Shop_ProductLikeCategory" UpdateMethod="UpdateProductLikeCategory" OldValuesParameterFormatString="{0}">
    <InsertParameters>
        <asp:Parameter Name="shopid" Type="Int32" />
        <asp:Parameter Name="ShopProductClassName" Type="String" />
        <asp:Parameter Name="orderby" Type="Int32" />
    </InsertParameters>
    <SelectParameters>
        <asp:Parameter   Name="ShopID" Type="Int32" />
    </SelectParameters>
    <DeleteParameters>
        <asp:Parameter Name="ShopProductClassID" Type="Int32" />
    </DeleteParameters>
    <UpdateParameters>
        <asp:Parameter Name="ShopProductClassName" Type="String" />
        <asp:Parameter Name="orderby" Type="Int32" />
        <asp:Parameter Name="ShopProductClassID" Type="Int32" />
    </UpdateParameters>
</asp:ObjectDataSource> 
</asp:Content>

