Imports System
Imports System.Configuration
Imports System.Data
Imports System.Data.Common
Imports System.Threading
Imports System.Web
Imports System.Collections.Generic
Imports Microsoft.Practices.EnterpriseLibrary.Common
Imports Microsoft.Practices.EnterpriseLibrary.Data


Namespace NetShopForge.Library.Ad


    Public Class AdController


        ''' <summary>
        ''' Get Ad list
        ''' </summary>
        ''' <param name="pageName">page's Name</param>
        ''' <param name="placement">λ</param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Shared Function GetAdList(ByVal pageName As String, ByVal placement As Integer) As List(Of AdInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbCommand As DbCommand = db.GetStoredProcCommand("nsf_Ad_GetAdList")
            ' Add paramters
            ' Input parameters can specify the input value
            db.AddInParameter(dbCommand, "@PageName", DbType.String, pageName)
            db.AddInParameter(dbCommand, "@Placement", DbType.Int32, placement)

            Dim listAd As New List(Of AdInfo)
            Using reader As IDataReader = db.ExecuteReader(dbCommand)
                While reader.Read
                    listAd.Add(FillAdInfo(reader))
                End While
                Return listAd
            End Using

        End Function

        Public Function GetAdInfo(ByVal adID As Integer) As AdInfo
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim dbcommand As DbCommand = db.GetStoredProcCommand("nsf_Ad_GetAdInfo")
            db.AddInParameter(dbcommand, "@AdID", DbType.Int32, adID)
            Using reader As IDataReader = db.ExecuteReader(dbcommand)
                While reader.Read
                    Return FillAdInfo(reader)
                End While
            End Using
            Return Nothing
        End Function

        Public Function AddAd(ByVal ad As AdInfo) As Integer
            Dim db As Database = DatabaseFactory.CreateDatabase()

            Dim sqlCommand As String = "nsf_Ad_AddAd"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            Dim AdID As Integer = NetShopForge.Common.GetKeys("AdID")
            db.AddInParameter(dbCommand, "AdID", DbType.Int32, AdID)
            db.AddInParameter(dbCommand, "PageName", DbType.String, ad.PageName)
            db.AddInParameter(dbCommand, "Placement", DbType.Int32, ad.Placement)
            db.AddInParameter(dbCommand, "AdText", DbType.String, ad.AdText)
            db.AddInParameter(dbCommand, "DateExpire", DbType.Date, ad.DateExpire)
            db.AddInParameter(dbCommand, "IsValid", DbType.Boolean, ad.IsValid)

            db.ExecuteNonQuery(dbCommand)
            Return AdID
        End Function

        Public Sub UpdateAD(ByVal ad As AdInfo)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim sqlCommand As String = "nsf_Ad_UpdateAd"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)
            db.AddInParameter(dbCommand, "AdID", DbType.Int32, ad.AdID)
            db.AddInParameter(dbCommand, "AdText", DbType.String, ad.AdText)
            db.AddInParameter(dbCommand, "DateExpire", DbType.Date, ad.DateExpire)
            db.AddInParameter(dbCommand, "IsValid", DbType.Boolean, ad.IsValid)
            db.ExecuteNonQuery(dbCommand)

        End Sub

        Public Sub DeleteAD(ByVal adID As Integer)
            Dim db As Database = DatabaseFactory.CreateDatabase
            Dim sqlCommand As String = "nsf_Ad_DeleteAd"
            Dim dbCommand As DbCommand = db.GetStoredProcCommand(sqlCommand)

            db.AddInParameter(dbCommand, "AdID", DbType.Int32, adID)
            db.ExecuteNonQuery(dbCommand)
        End Sub

        Friend Shared Function FillAdInfo(ByVal reader As IDataReader) As AdInfo

            Dim ad As New AdInfo
            ad.AdID = reader("AdID")
            ad.AdText = reader("AdText").ToString
            ad.DateExpire = CDate(reader("DateExpire"))
            ad.IsValid = CBool(reader("IsValid"))
            ad.PageName = reader("PageName").ToString
            ad.Placement = CInt(reader("Placement"))
            Return ad
        End Function
    End Class
End Namespace
